!--------------------------------------------------------------------------
!				THREEBM
!92   Routine for estimating location and magnitude of 3-beam interactions
!			(Ifeff=2, AGE=1?)
!	Also includes COMPAREMEASURES (Ifeff=1) and BRAGGIFP (AGE=0)
!NOV92:	with profilec,qrombd,trapzd,polintd from gaussubs/Num.Rec.
!
!--------------------------------------------------------------------------
SUBROUTINE THREEBM(OPT,ORDER,fscale,aplane)
  IMPLICIT NONE
!			Passed variables:
  INTEGER OPT
  DOUBLE PRECISION ORDER
  DOUBLE PRECISION fscale,aplane
!
  INTEGER iatoms,isites
  PARAMETER (iatoms=40,isites=3)
  INTEGER IDIG,nalphs,nelas,nbasis,ksites,natoms(iatoms) &
      ,nsites(iatoms),iZed(iatoms,isites),ntherm(iatoms,isites) &
      ,atomtype(iatoms,isites)
  DOUBLE PRECISION a01,b01,c01,calpha,cbeta,cgamma,Tref,aalph(6) &
      ,elast(6),fpop(iatoms,isites),btherm(iatoms,isites,6),xco(100,3)
  CHARACTER PLABEL(15)*12
  COMMON/XLATTICE/PLABEL,IDIG,nalphs,nelas,nbasis,ksites,natoms &
      ,nsites,iZed,ntherm,atomtype &
      ,a01,b01,c01,calpha,cbeta,cgamma,Tref &
      ,aalph,elast,fpop,btherm,xco
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER ielem
  PARAMETER (ielem=20)
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!92		Separate THREEBM/FHCALCN parameters:
  INTEGER IM(4)
  DOUBLE PRECISION a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,d2,xTemp
  DOUBLE PRECISION Numcells
  COMPLEX*16 FHr, FHi, FHn(ielem)
  common/com2d/ IM,a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,Numcells,d2,xTemp,FHr,FHi,FHn
!91			Form factor variables
  integer iedge
  parameter (iedge=24)
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!
  INTEGER Intflag,Iint
  COMMON /COMINT/ Intflag,Iint
!BCC2
  DOUBLE PRECISION amu(ielem),rho(ielem),Mui(ielem)
  integer nedge(ielem),iPhoto
  INTEGER emultype
  COMMON/FORMFC2/amu,rho,Mui,nedge,iPhoto,emultype
!
  DOUBLE PRECISION energynew
  DOUBLE PRECISION fp(ielem),fpp(ielem)
  common/newcom/energynew,fp,fpp
!			database integration
  INTEGER iGLflag,iGLorder,iGLstep
  DOUBLE PRECISION d_x(16), d_a(16)
  COMMON/GLweights/ d_x,d_a,iGLflag,iGLorder,iGLstep
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!MAC95
  CHARACTER dout*11,dcom*11,ddat*7,dhen*16,dhm*8
  COMMON/Macfiles/ dout,dcom,ddat,dhen,dhm
!MAC95
!		local variables
!
  INTEGER LH(4),L1(4),LHMAX,LKMAX,LLMAX,ILH,ILK,ILL,INPUT,ITHETA
  INTEGER FIRSTFLAG,LDUFF,I,HML(4),LASTI,J,Ifst,Item,Inext,IPNT
  CHARACTER*24 NEWFIL
  DOUBLE PRECISION MINTBH,MAXTBH,Emin,Emax,lmin,lmax,ENDTBH,sinTBH
  DOUBLE PRECISION cosTBH,sinTBL
  COMPLEX*16 F0TABLE(1000),FHrTABLE(1000) &
      ,FHiTABLE(1000),FLrTABLE(1000),FLiTABLE(1000),F0np(1000,ielem)
  DOUBLE PRECISION gamfac,HLratio,sinphi,phiabs,dellambda
  DOUBLE PRECISION d2L,d2L1,cosTHL,cosTHL1,sinTHL,sinTHL1
  DOUBLE PRECISION gamhl,delthH,cosL1L,delphi,stepm1,phiabs2
  DOUBLE PRECISION delphip,delphip1,dellambdap,dellambdap1,kl2
  DOUBLE PRECISION Lsig2,delk2p,rt2p1,rt2m1,delphiq,delphiq1
  DOUBLE PRECISION delphir,delphir1,phib1,phib2,delsphi
  DOUBLE PRECISION lam0,lam1,dellambda1,delthH1,temord
  DOUBLE PRECISION FMH,FMK,FML,FLH,FLK,FLL,F1H,F1K,F1L
  DOUBLE PRECISION phiabs3,phiabs4,Ft1,Ft2,Ft3,Ft4,d2HML
  DOUBLE PRECISION Delfh1(ielem,2)	! for L and HML
  DOUBLE PRECISION phiref,phitol,dphitol
  INTEGER phiflag,Plab1,Plab2
!			,FHnp(1000,ielem)
  INTEGER Iflag1,Istep,IMATCH0,IMATCH1,iexpfhr
  INTEGER ITM(4),ILHwrite
  INTEGER fnum,rmssts,rmsstv,iunit,conval
!
  DOUBLE PRECISION New2d
  EXTERNAL New2d
!	Use a* b* c* alpha* beta* gamma* d_H hk(i)l defined by GEN2d et seq.
!		Initial variable declaration
  CALL GEN2D
  FMH=DFLOAT(IM(1))
  FMK=DFLOAT(IM(2))
  FML=DFLOAT(IM(idig))
  DO I=1,idig
    ITM(I)=IM(I)
  ENDDO
  LHMAX=50
  LKMAX=50
  LLMAX=50
  MINTBH=0.D0
  MAXTBH=DPIo2
  Emax=1.D2
  lmin=hckeV/Emax
  lmax=d2/ORDER
  Emin=hckeV/lmax
  gamfac=re0/dpi/Volcell*1.D10
  Istep=200
  phiref=0.D0
  phitol=4.D0
  dphitol=0.D0
  phiflag=-1
!	Input limit of loop over L (third beam) and theta_B,H by
!	 max/min E, lambda, theta_B,H, (hk(i)l)_L
  WRITE (*,*) ' Enter 1=write curves; 0=nowrite'
  READ (*,*) ILHwrite
10 WRITE (*,*) ' Enter 0-continue; 1-adj. hkl limits;'
  WRITE (*,*) ' 2-theta_B,H; 3-limit E; 4- lambda, 5- steps'
  WRITE (*,*) ' 6-give ref. phi, tolerance, dtol(v no constraint)'
  WRITE (*,*) ' Defaults are 50,50,50;0-pi/2;0-100 keV;0-2d;200'
  READ (*,*) INPUT
  IF (INPUT.EQ.1) THEN
    WRITE (*,*) ' Enter h,k,l maxima:'
    READ (*,*) LHMAX, LKMAX, LLMAX
  ELSEIF (INPUT.EQ.2) THEN
    WRITE (*,*) ' Enter Bragg angle min,max for hk(i)l (rad):'
    READ (*,*) MINTBH,MAXTBH
    IF (MINTBH.LT.0.) MINTBH=0.D0
    IF (MAXTBH.GT.DPIo2.OR.MAXTBH.LT.0.D0) MAXTBH=DPIo2
    IF (MINTBH.GT.MAXTBH) MINTBH=MAXTBH/2.D0
  ELSEIF (INPUT.EQ.3) THEN
    WRITE (*,*) ' Enter energy limits (keV):'
    READ (*,*) Emin,Emax
    lmin=hckeV/Emax
    IF (Emin.LT.hckeV*ORDER/d2) THEN
      WRITE(*,*) ' Emin too low; reset'
      Emin=hckeV*ORDER/d2
    ENDIF
    lmax=hckeV/Emin
  ELSEIF (INPUT.EQ.4) THEN
    WRITE (*,*) ' Enter lambda limits (Angstroms):'
    READ (*,*) lmin,lmax
    lmax=DMIN1(lmax,d2/ORDER)
    Emin=hckeV/lmax
    IF (lmin.GT.0.D0) Emax=hckeV/lmin
  ELSEIF (INPUT.EQ.5) THEN
    WRITE (*,*) ' Enter max. number of output steps:'
    READ (*,*) Istep
  ELSEIF (INPUT.EQ.6) THEN
    WRITE (*,*) ' Reference phiabs, tolerance, dphimin(rad):'
    READ (*,*) phiref,phitol,dphitol
    IF (DABS(phiref).LE.DPI.AND.phitol.LT.DPI) phiflag=1
  ENDIF
  IF (INPUT.GT.0.AND.INPUT.LE.6) GOTO 10
  MINTBH=DMAX1(MINTBH,DASIN(lmin*ORDER/d2))
  IF (lmax.GE.d2/ORDER) THEN
    lmax=d2/order
    MAXTBH=DMIN1(MAXTBH,DPIo2)
  ELSE
    MAXTBH=DMIN1(MAXTBH,DASIN(lmax*ORDER/d2))
  ENDIF
  LHMAX=MIN(LHMAX,IDINT(2.D0*a02/d2*ORDER/DSIN(MINTBH)))
  LKMAX=MIN(LKMAX,IDINT(2.D0*b02/d2*ORDER/DSIN(MINTBH)))
  LLMAX=MIN(LLMAX,IDINT(2.D0*c02/d2*ORDER/DSIN(MINTBH)))
  stepm1=DFLOAT(Istep-1)
!
!	Loop over theta (Energy) to get form factor data
!
  IF (OPT.EQ.5) THEN
    Plab1=1
    Plab2=3
  ELSE
    Plab1=3
    Plab2=5
  ENDIF
!Mactest	  write(*,*)dout,plabel(opt),plab1,plab2
  OPEN(UNIT=12,FILE=dout//'Htab.'//PLABEL(OPT)(Plab1:Plab2) &
      //PLABEL(OPT)(10:12),STATUS='NEW',ERR=1000)
  OPEN(UNIT=14,FILE=dout//'Hsum.'//PLABEL(OPT)(Plab1:Plab2) &
      //PLABEL(OPT)(10:12),STATUS='NEW',ERR=1100)
  OPEN(UNIT=15,FILE=dout//'Hfil.'//PLABEL(OPT)(Plab1:Plab2) &
      //PLABEL(OPT)(10:12),STATUS='NEW',ERR=1150)
  IF (phiflag.EQ.-1) THEN
    WRITE(14,40) PLABEL(OPT),IDNINT(ORDER),MINTBH,MAXTBH,Emin &
        ,Emax,lmin,lmax,-LHMAX,LHMAX,-LKMAX,LKMAX,-LLMAX,LLMAX &
        ,Istep
  ELSE
    WRITE(14,41) PLABEL(OPT),IDNINT(ORDER),MINTBH,MAXTBH,Emin &
        ,Emax,lmin,lmax,-LHMAX,LHMAX,-LKMAX,LKMAX,-LLMAX,LLMAX &
        ,Istep,phitol,phiref,dphitol
  ENDIF
40 FORMAT(X,' Summary file: 3-beam interactions. Crystal,hkl=' &
       ,A12,'x',I3,/,' theta=(',F6.4,',',F6.4,')(rad),E=(',1PE10.4 &
       ,',',1PE10.4,')(keV)',/,' l=(',1PE10.4,',',1PE10.4,')' &
       ,',Range over L=[(',I4,',',I4,'),(',I4,',',I4,'),(',I4,',' &
       ,I4,')]',/,' Steps=',I4,',azimuthal angle wrt normal to hkl' &
       ,' of 1st match=in plane of 1st match')
41 FORMAT(X,' Summary file: 3-beam interactions. Crystal,hkl=' &
       ,A12,'x',I3,/,' theta=(',F6.4,',',F6.4,')(rad),E=(',1PE10.4 &
       ,',',1PE10.4,')(keV)',/,' l=(',1PE10.4,',',1PE10.4,')' &
       ,',Range over L=[(',I4,',',I4,'),(',I4,',',I4,'),(',I4,',' &
       ,I4,')]',/,' Steps=',I4,',azimuthal angle wrt normal to hkl' &
       ,' of 1st match=in plane of 1st match',/ &
       ,' Quoted matches within ',1PE8.2,' rad of phiabs=',1PE10.4 &
       ,', phiwidth>',1PE8.2)
!test      GOTO 70
  iexpfhr=0
  ksp=ORDER/d2
  DO ITHETA=1,Istep
    THETA=MINTBH+DFLOAT(ITHETA-1)/stepm1*(MAXTBH-MINTBH)
!	Generate cosTBL,sinTBH,cosTBH and hence sinphiLL, sinphiL1
    sinTBH=DSIN(THETA)
    dlambdanew=d2/ORDER*sinTBH
    Energynew=hckeV/dlambdanew	! ready for FORMF and forbidden test:
!91			send this inner loop to formf
    DO iatom=1,natomtypes
      CALL FORMF
    ENDDO
    f01(1)=f01(1)*fscale
    f02(1)=f02(1)*fscale
    fh1(1)=fh1(1)*fscale
    DO iatom=1,natomtypes
!92           FHnp(ITHETA,iatom)=DCMPLX(fh1(iatom),f02(iatom))
      F0n(iatom)=DCMPLX(f01(iatom),f02(iatom))
      F0np(ITHETA,iatom)=F0n(iatom)
    ENDDO
    CALL F0CALCN
    F0TABLE(ITHETA)=F0(3)
    IF (iexpfhr.EQ.0) CALL FHCALCN(ITM,ORDER)
    IF (CDABS(FHr+(0.D0,1.D0)*FHi).LT.1.D-2 &
        *CDABS(F0TABLE(ITHETA)).AND.ITHETA.EQ.1) THEN
      write(*,*) ' Enter FHr for refln (-1 or 1<RET>FHr,FHi)?'
      READ(*,*) iexpfhr
      IF (iexpfhr.EQ.1) THEN
        READ(*,55) Ft1,Ft2,Ft3,Ft4
55      FORMAT('4F')
        FHr=DCMPLX(Ft1,Ft2)
        FHi=DCMPLX(Ft3,Ft4)
      ENDIF
    ENDIF
    FHiTABLE(ITHETA)=FHi
    FHrTABLE(ITHETA)=FHr
!		PLOT theta,lambdanew,energynew,F0,FHr,FHi for H
    WRITE(12,60) THETA,dlambdanew,energynew,F0(3),FHr,FHi
60  FORMAT(F6.4,F8.4,1PE10.3,1PE10.3,1PE8.1 &
        ,1PE10.3,1PE11.3,1PE8.1,1PE9.1)
  ENDDO
!test 70      continue
  CLOSE(UNIT=12,STATUS='KEEP')
!
!	Loop over L:
!
  temord=1.D0
  FIRSTFLAG=0		! keep flag to identify first match
  DO ILH=0,2*LHMAX
    LH(1)=INT(ILH/2)
    IF (LH(1)*2.LT.ILH) LH(1)=-LH(1)-1
    DO ILK=0,2*LKMAX
      LH(2)=INT(ILK/2)
      IF (LH(2)*2.LT.ILK) LH(2)=-LH(2)-1
      DO ILL=0,2*LLMAX
        LH(idig)=INT(ILL/2)
        IF (LH(idig)*2.LT.ILL) LH(idig)=-LH(idig)-1
!	Reject 000, H, integral multiples of H, and (if possible, later)
!	  symmetry-forbidden reflections (Calculate F_L, F_H-L)
        Iflag1=0
        DO I=1,3
          J=I
          IF (I.EQ.3) J=idig
          IF (LH(J).NE.0.AND.IM(J).EQ.0) GOTO 90
          IF (LH(J).EQ.0.AND.IM(J).EQ.0) GOTO 85
          IF (Iflag1.EQ.0) THEN
            HLratio=DFLOAT(LH(J))/DFLOAT(IM(J))
            Iflag1=1
          ELSE
            IF (HLratio.NE.DFLOAT(LH(J))/DFLOAT(IM(J))) GOTO 90
          ENDIF
85      ENDDO
        GOTO 500
90      CONTINUE
        LDUFF=0		! like firstflag, but for i/o indication
!
!	Determine cos(theta_HL) from reciprocal-lattice product, sinTHL, dL
        d2L=new2d(LH)
        IF (d2L.LT.d2/ORDER*DSIN(MINTBH)) GOTO 600
        FLH=DFLOAT(LH(1))
        FLK=DFLOAT(LH(2))
        FLL=DFLOAT(LH(idig))
!test         write(*,*) d2,order,d2l,flh,fll,ast,alpst,fmh
        cosTHL=(FMH*FLH*ast*ast+FMK*FLK*bst*bst+FML &
            *FLL*cst*cst+(FMH*FLK+FMK*FLH)*ast*bst*DCOS(gamst) &
            +(FMH*FLL+FML*FLH)*ast*cst*DCOS(betst) &
            +(FMK*FLL+FML*FLK)*bst*cst*DCOS(alpst))*d2*d2L/4.D0
        sinTHL=DSQRT(1.D0-cosTHL*cosTHL)	! +ve
!
!	Generate  s_x=LxH/|LxH| in reciprocal-lattice coordinates
!		 and hence deltaphi
        IF (FIRSTFLAG.EQ.0) THEN
          delphi=0.D0
          L1(1)=LH(1)
          L1(2)=LH(2)
          L1(idig)=LH(idig)
          F1H=FLH
          F1K=FLK
          F1L=FLL
          d2L1=d2L
          cosTHL1=cosTHL
          sinTHL1=sinTHL
!         ENDIF
        ELSE
          cosL1L=(F1H*FLH*ast*ast+F1K*FLK*bst*bst+F1L &
              *FLL*cst*cst+(F1H*FLK+F1K*FLH)*ast*bst*DCOS(gamst) &
              +(F1H*FLL+F1L*FLH)*ast*cst*DCOS(betst) &
              +(F1K*FLL+F1L*FLK)*bst*cst*DCOS(alpst))*d2L1*d2L/4.D0
          delphi=(cosL1L-cosTHL1*cosTHL)/sinTHL1/sinTHL
          IF (delphi.GE.1.D0) THEN
            delphi=0.D0			! same plane implication
          ELSEIF (delphi.LE.-1.D0) THEN
            delphi=DPI			! opp. plane implication
          ELSE
            delphi=DACOS(delphi)
          ENDIF
        ENDIF
!	Loop over 0<theta_B,H<asin(min(1,dL/dH)) in Istep
!	Truncate by maxima/minima as appropriate
        IF (d2L*ORDER/d2.LT.1.D0) THEN
          ENDTBH=DMIN1(MAXTBH,DASIN(d2L*ORDER/d2))
          LASTI=IDINT((ENDTBH-MINTBH)/(MAXTBH-MINTBH)*stepm1+1.D0)
        ELSE
          ENDTBH=MAXTBH
          LASTI=Istep
        ENDIF
        IMATCH0=0
        IMATCH1=0
!test         write(*,130) (IM(i),i=1,idig),(LH(i),i=1,idig)
!t130      FORMAT(' IM,LH=',8I4)
!			prepare complements:
        HML(1)=IM(1)*ORDER-LH(1)
        HML(2)=IM(2)*ORDER-LH(2)
        HML(idig)=IM(idig)*ORDER-LH(idig)
        d2HML=new2d(HML)
        DO iatom=1,natomtypes
          f01(iatom)=0.D0
          ksp=1.D0/d2L
          CALL FORMF0
          Delfh1(iatom,1)=fh1(iatom)
          ksp=1.D0/d2HML
          CALL FORMF0
          Delfh1(iatom,2)=fh1(iatom)
        ENDDO
!
        DO ITHETA=1,LASTI
          THETA=MINTBH+DFLOAT(ITHETA-1)/stepm1*(MAXTBH-MINTBH)
!	Generate cosTBL,sinTBH,cosTBH and hence sinphiLL, sinphiL1
          cosTBH=DCOS(THETA)
          sinTBH=DSIN(THETA)
          dlambdanew=sinTBH*d2/ORDER
          sinTBL=dlambdanew/d2L
          IF (cosTBH.EQ.0.D0) THEN
            sinphi=1.D0-sinTHL/cosTHL
          ELSE
            sinphi=(cosTHL*sinTBH-sinTBL)/(cosTBH*sinTHL)
          ENDIF
          IF (DABS(sinphi).GT.1.D0) THEN
!test
            IF (ITHETA.EQ.1) &
                write(*,140) ITHETA,theta,sinphi,costhl,sintbl,sinthl
140         FORMAT(' sinphi err:',I5,5F8.4)	! sinphi error
            GOTO 400	! next energy/angle
          ENDIF
          phiabs=DASIN(sinphi)+delphi		! real values found!
          phiabs2=DPI-DASIN(sinphi)+delphi	! 1=2;3=4
          phiabs3=delphi-DASIN(sinphi)
          phiabs4=DPI+DASIN(sinphi)+delphi
150       IF (phiabs.GT.DPI-1.D-6) THEN
            phiabs=phiabs-2.D0*DPI
          ELSEIF (phiabs.LT.-DPI-1.D-6) THEN
            phiabs=phiabs+2.D0*DPI
          ELSE
            GOTO 152
          ENDIF
          GOTO 150
152       IF (phiabs2.GT.DPI-1.D-6) THEN
            phiabs2=phiabs2-2.D0*DPI
          ELSEIF (phiabs2.LT.-DPI-1.D-6) THEN
            phiabs2=phiabs2+2.D0*DPI
          ELSE
            GOTO 153
          ENDIF
          GOTO 152
153       IF (phiabs3.GT.DPI-1.D-6) THEN
            phiabs3=phiabs3-2.D0*DPI
          ELSEIF (phiabs3.LT.-DPI-1.D-6) THEN
            phiabs3=phiabs3+2.D0*DPI
          ELSE
            GOTO 154
          ENDIF
          GOTO 153
154       IF (phiabs4.GT.DPI-1.D-6) THEN
            phiabs4=phiabs4-2.D0*DPI
          ELSEIF (phiabs4.LT.-DPI-1.D-6) THEN
            phiabs4=phiabs4+2.D0*DPI
          ELSE
            GOTO 155
          ENDIF
          GOTO 154
155       Energynew=hckeV/dlambdanew	! ready for FORMF and forbidden test:
          DO iatom=1,natomtypes		! reset FHn=fh1,f02
            f01(iatom)=DREAL(F0np(ITHETA,iatom))
            f02(iatom)=DIMAG(F0np(ITHETA,iatom))
            fh1(iatom)=f01(iatom)+Delfh1(iatom,1)
          ENDDO
!		Forbidden test ? (could have been earlier)
          CALL FHCALCN(LH,temord)
          FLiTABLE(ITHETA)=FHi
          FLrTABLE(ITHETA)=FHr
          IF (CDABS(FHr+(0.D0,1.D0)*FHi).LT.1.D-3*CDABS &
              (FHrTABLE(ITHETA)+(0.D0,1.D0)*FHiTABLE(ITHETA))) THEN
!t           IF (ITHETA.EQ.istep) write(*,160) (LH(i),i=1,4),FHr
!t160        FORMAT(' Weak L,FLr=',4(I3),2(1PE12.4))	! weak match!
            GOTO 400		! next energy/angle
          ENDIF
!		Put in optional phiref/tol constraint:
          IF (FIRSTFLAG.GT.0.AND.phiflag.EQ.1.AND.LDUFF.EQ.0) THEN
            IF (DABS(phiabs-phiref).GT.phitol &
                .AND.DABS(phiabs2-phiref).GT.phitol &
                .AND.DABS(phiabs3-phiref).GT.phitol &
                .AND.DABS(phiabs4-phiref).GT.phitol) THEN
!t            IF (ITHETA.EQ.istep) write(*,165) (LH(i),i=1,4)
!t     1       ,phiabs,phiabs2,phiabs3,phiabs4
!t165         FORMAT(' L phi>tol:',4(I3),4(1PE12.4))	! distant match!
              GOTO 400		! next energy/angle
            ENDIF
          ENDIF
!
!		Qun Shen estimate? (Acta Cryst. A42 (1986) 525-533):
!
          DO iatom=1,natomtypes		! reset FHn=fh1,f02
            f01(iatom)=DREAL(F0np(ITHETA,iatom))
            f02(iatom)=DIMAG(F0np(ITHETA,iatom))
            fh1(iatom)=f01(iatom)+Delfh1(iatom,2)
          ENDDO
          CALL FHCALCN(HML,temord)
!          IF (CDABS(FHr+(0.D0,1.D0)*FHi).LT.1.D-3*CDABS
!	1  (FHrTABLE(ITHETA)+(0.D0,1.D0)*FHiTABLE(ITHETA))) THEN
!           IF (ITHETA.EQ.1) write(*,160) FHr,F0table(itheta)
!           GOTO 400		! next energy/angle
!          ENDIF
!
!92		Better estimates for 3-beam amplitude?:
!
          gamhl=gamfac*CDABS((FHr+(0.D0,1.D0)*FHi)* &
              (FLrTABLE(ITHETA)+(0.D0,1.D0)*FLiTABLE(ITHETA)) &
              /(FHrTABLE(ITHETA)+(0.D0,1.D0)*FHiTABLE(ITHETA)))
          kl2=1.D0/dlambdanew/dlambdanew+4.D0/d2L/d2L- &
              4.D0*cosTHL*ORDER/d2/d2L+4.D0/d2L/dlambdanew*cosTBH*sinTHL &
              *DSIN(phiabs-delphi)		! sinphi or dsin(phiabs1-4 - delphi)
          IF (DSIN(aplane).EQ.0.) THEN
            Lsig2=4.D0/d2L/d2L*sinTHL*sinTHL*DCOS(phiabs-delphi) &
                *DCOS(phiabs-delphi)
          ELSE
            Lsig2=4.D0/d2L/d2L*(sinTHL*(DCOS(aplane)*cosTBH* &
                DCOS(phiabs-delphi)+DSIN(aplane)*sinTBH*DCOS(delphi)) &
                +cosTHL*DSIN(aplane)*cosTBH*DSIN(phiabs))**2/ &
                (1.D0-(DSIN(aplane)*cosTBH*DCOS(phiabs)-DCOS(aplane) &
                *sinTBH)**2)
          ENDIF
!92		! equal Amp.='Int.x0 or x4'; sepn x2 => Int.x0.25 or x2.25;
!92		! fwhm=sepn x2rt2 => from 2x (dk2=1/(rt2+1)) to 2x (1/(rt2-1))
          delk2p=gamhl*(kl2-Lsig2)	!*DSQRT(8.D0)	! fwhm following:
!old          dellambda=dlambdanew*gamhl*d2L*d2L/DSQRT(2.D0)
!old		neglects kl2-Lsig2 varn:
!          IF (DABS(DSIN(phiabs-delphi)).LT.1.D-20) THEN
!           dellambda=dlambdanew
!          ELSE
!           dellambda=delk2p*d2L/DSQRT(2.D0)/sinTHL
!     1      /DSIN(phiabs-delphi)*dlambdanew*dlambdanew*cosTBH
!          ENDIF
!old		neglects kl2-Lsig2 varn:
!          delsphi=delk2p*d2L/DSQRT(2.D0)/sinTHL
!     1      *dlambdanew/cosTBH
!          IF (DABS(DCOS(phiabs-delphi)).LT.1.D-2) THEN
!           delphiq=(DABS(DCOS(phiabs-delphi))-DSQRT(
!     1      DCOS(phiabs-delphi)**2-2.D0*DSIN(phiabs-delphi)*delsphi))
!     2      /DABS(DSIN(phiabs-delphi))
!          ELSE
!           delphiq=DABS(delsphi/DCOS(phiabs-delphi))
!          ENDIF
!92		still neglects quadratic terms, assumes aplane=0:
          rt2p1=-DSQRT(2.D0)-1.D0
          rt2m1=-2.D0-rt2p1
          dellambdap=(1.D0-DCOS(phiabs-delphi)**2*sinTBL*sinTBL &
              *sinTHL*sinTHL*4.D0)*dlambdanew* &
              (1.D0/DABS(sinTHL*DSIN(phiabs-delphi)*sinTBL/cosTBH*4.D0 &
              *(rt2p1/gamhl-1.D0)-2.D0) &
              +1.D0/DABS(sinTHL*DSIN(phiabs-delphi)*sinTBL/cosTBH*4.D0 &
              *(rt2m1/gamhl-1.D0)-2.D0))
!		! neglects linear varn in kl2-Lsig2:
!          delphip=delk2p*d2L*dlambdanew/4.D0/cosTBH/sinTHL
!     1     /DCOS(phiabs-delphi)*(DSQRT(8.D0)*gamhl-2.D0)
!     2     /(gamhl-DSQRT(8.D0)+1.D0/gamhl)
!92		! still neglects dsinphi2 quadratic contribution:
          phib1=DABS((rt2p1/gamhl-1.D0)/sinTBL/sinTHL &
              *cosTBH-2.D0*DSIN(phiabs-delphi))
          phib2=DABS((rt2m1/gamhl-1.D0)/sinTBL/sinTHL &
              *cosTBH-2.D0*DSIN(phiabs-delphi))
          delphip=DABS(-DCOS(phiabs-delphi)+2.5D-1/sinTBL/sinTBL &
              /sinTHL/sinTHL/DCOS(phiabs-delphi))* &
              (1.D0/phib1+1.D0/phib2)
!92		! includes dsinphi, sin(phi+d) quadratic contributions?
          delsphi=phib1/2.D0-DSQRT(phib1*phib1/4.D0 &
              -DCOS(phiabs-delphi)**2 &
              +2.5D-1/sinTHL/sinTHL/sinTBL/sinTBL)
          IF (DABS(DSIN(phiabs-delphi)).LT.1.D-3) THEN
            delphir=DABS(delsphi/DCOS(phiabs-delphi))
          ELSEIF (DCOS(phiabs-delphi)**2.LT. &
              delsphi*2.D0*DSIN(phiabs-delphi)) THEN
            delphir=DSQRT(DABS(delsphi*2.D0/DSIN(phiabs-delphi)))
          ELSE
            delphir=DABS((DABS(DCOS(phiabs-delphi)) &
                -DSQRT(DCOS(phiabs-delphi)**2-2.D0*DSIN(phiabs-delphi) &
                *delsphi))/DSIN(phiabs-delphi))
          ENDIF
          delsphi=phib2/2.D0-DSQRT(phib2*phib2/4.D0 &
              -DCOS(phiabs-delphi)**2 &
              +2.5D-1/sinTHL/sinTHL/sinTBL/sinTBL)
          IF (DABS(DSIN(phiabs-delphi)).LT.1.D-3) THEN
            delphir=delphir+DABS(delsphi/DCOS(phiabs-delphi))
          ELSEIF (DCOS(phiabs-delphi)**2.LT. &
              delsphi*2.D0*DSIN(phiabs-delphi)) THEN
            delphir=DSQRT(DABS(delsphi*2.D0/DSIN(phiabs-delphi)))
          ELSE
            delphir=delphir+DABS((DABS(DCOS(phiabs-delphi)) &
                -DSQRT(DCOS(phiabs-delphi)**2 &
                -2.D0*DSIN(phiabs-delphi)*delsphi))/DSIN(phiabs-delphi))
          ENDIF
!
          IF (DABS((dlambdanew-DABS(dellambdap))*ORDER/d2).GT.1.D0) &
              THEN
            delthH=THETA
          ELSE
            delthH=DABS(DASIN((dlambdanew-DABS(dellambdap))*ORDER/d2) &
                -THETA)
          ENDIF
!		Put in optional dphitol width constraint:
          IF (FIRSTFLAG.GT.0.AND.phiflag.EQ.1.AND.LDUFF.EQ.0) THEN
            IF (DABS(delphir).LT.dphitol) THEN	! delphir would become r1
              IF (ITHETA.EQ.1) write(*,170) (LH(i),i=1,4) &
                  ,delphir,dphitol
170           FORMAT(' Narrow dphi, L=',4(I3),2(1PE12.4))	! narrow match!
              GOTO 400		! next energy/angle
            ENDIF
          ENDIF
!
!		PASSED ALL TESTS!
!
          IF (LDUFF.EQ.0) THEN			! first itheta match!
            FIRSTFLAG=FIRSTFLAG+1		! count L-matches
            IPNT=1
            DO I=1,IDIG
              Ifst=IABS(LH(I))/100
              Item=IABS(LH(I))/10-Ifst*10
              Inext=IABS(LH(I))-Item*10-Ifst*100
              IF (LH(I).LT.0) THEN
                NEWFIL(IPNT:IPNT)='-'
                IPNT=IPNT+1
              ENDIF
              IF (Ifst.GT.0) THEN
                NEWFIL(IPNT:IPNT)=CHAR(48+Ifst)
                IPNT=IPNT+1
              ENDIF
              IF (Item.GT.0) THEN
                NEWFIL(IPNT:IPNT)=CHAR(48+Item)
                IPNT=IPNT+1
              ENDIF
              NEWFIL(IPNT:IPNT)=CHAR(48+Inext)
              IPNT=IPNT+1
              IF (I.EQ.1) THEN
                NEWFIL(IPNT:IPNT)='K'
                IPNT=IPNT+1
              ELSEIF (I.EQ.idig-1) THEN
                NEWFIL(IPNT:IPNT)='L'
                IPNT=IPNT+1
              ENDIF
            ENDDO
            IF (ILHwrite.EQ.1) OPEN(UNIT=13,FILE=dout//'LH'// &
                NEWFIL(1:IPNT-1)//'.'//PLABEL(OPT)(Plab1:Plab2)// &
                PLABEL(OPT)(10:12),STATUS='NEW',ERR=1200)
            WRITE (15,*) 'LH'//NEWFIL(1:IPNT-1)//'.' &
                //PLABEL(OPT)(Plab1:Plab2)//PLABEL(OPT)(10:12)
!92175        FORMAT(A30)
          ENDIF
          LDUFF=LDUFF+1			! count itheta matches
          IF (IMATCH0.EQ.0) THEN
            IMATCH0=LDUFF
            lam0=dlambdanew
          ELSE
            IMATCH1=LDUFF
            lam1=dlambdanew
          ENDIF
          IF (LDUFF.EQ.1) THEN
!           dellambda1=dellambda
            delthH1=delthH
            dellambdap1=dellambdap
            delphip1=delphip
!           delphiq1=delphiq
            delphir1=delphir
          ENDIF
!		PLOT theta,dlambdanew,phiabs,L,FLr,FLi,gamma for L:
!		Estimate of magnitude of 3-beam interaction ?
          IF (ILHwrite.EQ.1) &
              WRITE(13,200) THETA,dlambdanew,phiabs,phiabs2,phiabs3,phiabs4
200       FORMAT(F8.5,F10.6,4(1PE11.3))
          IF (LDUFF.EQ.1) WRITE(14,210) phiabs,phiabs2,phiabs3,phiabs4 &
              ,delphi
210       FORMAT(/' Min. angle, l. phi/del:',5(1PE11.3))
!
400     ENDDO
        IF (LDUFF.GT.0) THEN
          IF (ILHwrite.EQ.1) CLOSE(13,STATUS='KEEP')
          WRITE(14,405) phiabs,phiabs2,phiabs3,phiabs4
405       FORMAT(' Max. angle,lambda match:',4(1PE11.3),' for:')
          WRITE(14,410) FIRSTFLAG,LH(1),LH(2),LH(idig),d2L,LDUFF &
              ,lam0,lam1,FLrTABLE(IMATCH0),FLiTABLE(IMATCH0) &
              ,FLrTABLE(IMATCH1),FLiTABLE(IMATCH1) &
              ,dellambdap1,dellambdap,delthH1,delthH,delphir1,delphir
!     4     ,dellambda1,dellambda,delphiq1,delphiq,delphip1,delphip
        ENDIF
410     FORMAT(' Plane',I6,',',3I3,',2d=',1PE12.6,',',I4,' matches,l=' &
            ,1PE10.3,' to',1PE10.3,/,' FLr,FLi=',2('(',1PE10.3,',', &
            1PE10.3,')'),/,'      to ',2('(',1PE10.3,',',1PE10.3,')') &
            ,/,' dlam,dthH,dphi=' &
            ,1PE9.2,' -',1PE9.2,',',1PE9.2,' -',1PE9.2 &
            ,',',1PE9.2,' -',1PE9.2)
!     6    ,/,' dl0,dphi0,L='
!     7    ,1PE9.2,' -',1PE9.2,',',1PE9.2,' -',1PE9.2
!     8    ,',',1PE9.2,' -',1PE9.2)
!test
!t          WRITE(14,420) delphi,cosTHL,cosL1L,cosTHL1,sinTHL,sinTHL1
!t          WRITE(14,420) ast,bst,cst,alpst,betst,gamst
!t420       FORMAT(1X,6(1PE10.3))
500   ENDDO
600 ENDDO
  ENDDO
  CLOSE(14,STATUS='KEEP')
  CLOSE(15,STATUS='KEEP')
  RETURN
1000 WRITE(*,*) ' Error opening output file in THREEBM/Htable'
  RETURN
1100 WRITE(*,*) ' Error opening output file in THREEBM/Hsum'
  RETURN
1150 WRITE(*,*) ' Error opening output file in THREEBM/Hfile'
  RETURN
1200 WRITE(*,*) ' Error opening output file in THREEBM/LH..K..L..'
!      CALL ERRSNS(fnum,rmssts,rmsstv,iunit,conval)
!      WRITE(*,1250)
!1250  FORMAT(2X,'Error codes:',5I6)
  WRITE (*,*) 'LH'//NEWFIL(1:IPNT-1)//'.' &
      //PLABEL(OPT)(Plab1:Plab2)//PLABEL(OPT)(10:12)
  RETURN
END
!--------------------------------------------------------------------------
!92	Routine for estimating Bragg diffraction shifts,widths
!			for curved crystals.
!
!--------------------------------------------------------------------------
SUBROUTINE COMPAREMEASURES(GBt1,ORDER,swidth)
  IMPLICIT NONE
!		Passed variables
  DOUBLE PRECISION GBt1,ORDER,swidth
!
  DOUBLE PRECISION dlambda,Mshift21,Mshift31(2),Mshift41(2)
  COMMON /mosout/ dlambda,Mshift21,Mshift31,Mshift41
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER ielem
  PARAMETER (ielem=20)
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!91		Form factor variables
  integer iedge
  parameter (iedge=24)
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!92		major new curved crystal variables:
  DOUBLE PRECISION AxisTh,ABtem,Mininc,THABX,THBAX,BXmin
  DOUBLE PRECISION thm1C(2),ThminC(2),ThmaxC(2),thminoC(2) &
      ,thmaxoC(2),YozC(2),YminoC(2),YmaxoC(2)
  INTEGER VARMAX,Isect(2)
  COMMON/CS5B/AxisTh,ABtem,Mininc,THABX,THBAX,BXmin &
      ,thm1C,ThminC,ThmaxC,thminoC,thmaxoC,YozC,YminoC,YmaxoC &
      ,VARMAX,Isect
!		Common (I/O) vars (CS5-Rcurve)
  INTEGER ISTEPSO,ISTEPSP
  PARAMETER (ISTEPSO=8000,ISTEPSP=8001)
  DOUBLE PRECISION RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr
  DOUBLE PRECISION MPSIr2,MPSIi2,p,s,K1,Temth0,Thout0, &
      muabs,mcurv,mReftem1,Maxt2,umbo2
  DOUBLE PRECISION Irel1(ISTEPSP),Irel2(ISTEPSP),Irel3(ISTEPSP), &
      Reflint(6),Reflintth,ReflintHy,Mshift1,Mshift2,Mshift3(2,2), &
      Mshift4(3),Ermshift4,MShiftB(6),Irel5(ISTEPSP),Irel6(ISTEPSP)
  DOUBLE PRECISION MaxI1,MaxI2,MaxI3,MaxI4,Thpk, &
      Thpko,Ypko,Th1,Thout,Yshift, &
      STEPS1,STEPS2,STEPS3,STEPS4,basym,IRELM
  COMMON/CS5C/RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr,MPSIr2,MPSIi2, &
      p,s,K1,Temth0,Thout0,muabs,mcurv,mReftem1,Maxt2,umbo2, &
      Irel1,Irel2,Irel3,Reflint,Reflintth,ReflintHy,Mshift1, &
      Mshift2,Mshift3,Mshift4,Ermshift4,MShiftB,Irel5,Irel6,MaxI1, &
      MaxI2,MaxI3,MaxI4,Thpk,Thpko, &
      Ypko,Th1,Thout,Yshift,STEPS1,STEPS2,STEPS3,STEPS4,basym &
      ,IRELM
!
  DOUBLE PRECISION c251,c252,c253,c751,c752,c753,mt0
  DOUBLE PRECISION mq2,PkTh1,Reflinto,thmaxf,thminf,Mosdel, &
      c1ff(6),c2ff(6),ffpk(2),Maxff,maxt0,maxt3,sigscat,siginc &
      ,Reflintm,Reflinty,ReflintthinC
  DOUBLE PRECISION transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm(2,8,2)
  INTEGER K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2
  CHARACTER numstr*4
  COMMON/CS5D/c251,c252,c253,c751,c752,c753,mt0,mq2,PkTh1, &
      Reflinto,thmaxf,thminf,Mosdel,c1ff,c2ff, &
      ffpk,Maxff,maxt0,maxt3,sigscat,siginc,Reflintm,Reflinty, &
      Reflintthinc,transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm,K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2,numstr
!
  INTEGER ffs
  PARAMETER (ffs=30100)
  COMPLEX*16 DPSI0, DPSIHr, DPSIHi
  DOUBLE PRECISION Thm2,Thm3,Temthm2,Temthm3,Yrel(ISTEPSP,6), &
      Thtem(ffs),Rtem(ffs),Ttem(ffs),Ytem(ffs),dely0,dely0t,mufilm, &
      TEMUL,Mphotoshift,mdepth(6),mthld(6),emthld(2) &
      ,mcontl,meanff(7,2),maxdp,maxdm,thff,Chinit,Chfin
  DOUBLE PRECISION Rzf,Cx
!93atest:	add mYo for output asymmetry evaluation:
  DOUBLE PRECISION fscale,RtemC(ffs),TtemC(ffs),Tabdy(ffs,4),mYo(6)
  DOUBLE PRECISION BXm,BXx
  INTEGER fof,detmatch,ip
  COMMON/CS5E/ DPSI0,DPSIHr,DPSIHi,Thm2,Thm3,Temthm2,Temthm3,Yrel, &
      Thtem,Rtem,Ttem,Ytem,dely0,dely0t,mufilm,TEMUL,Mphotoshift, &
      mdepth,mthld,emthld,mcontl,meanff,maxdp,maxdm,thff &
      ,Chinit,Chfin,Rzf,Cx,fscale,RtemC,TtemC &
      ,Tabdy,mYo,BXm,BXx,fof,detmatch,ip
!91		constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!91		I/O pars (IFP +)
  DOUBLE PRECISION RANGE(2),STEPS,DELJ(2),denom,aplane,G,G2,K12,K,K2
  DOUBLE PRECISION RI1(3),RI2(3),RI3,RFL(3),RFL2(3),RANGE0
  INTEGER CYCLE,Ibit,Jbit,J,Item
  DOUBLE PRECISION fwhm1,fwhm2
  DOUBLE PRECISION mangle(6,3,2)
  DOUBLE PRECISION RIT(6,3,2),RFLT(6,3,2)
  DOUBLE PRECISION scale1,thpk1,thpk2
  COMMON/COMIFP/RANGE,STEPS,DELJ,denom,aplane,G,G2,K12,K,K2 &
      ,RI1,RI2,RI3,RFL,RFL2,RANGE0 &
      ,fwhm1,fwhm2,mangle,RIT,RFLT &
      ,scale1,thpk1,thpk2,CYCLE,Ibit,Jbit,J,Item
!92		Separate THREEBM/FHCALCN parameters:
  INTEGER IM(4)
  DOUBLE PRECISION a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,d2,xTemp
  DOUBLE PRECISION Numcells
  COMPLEX*16 FHr, FHi, FHn(ielem)
  common/com2d/ IM,a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,Numcells,d2,xTemp,FHr,FHi,FHn
!DEC92:		      Yiz estimates + CMac meanxxp
  DOUBLE PRECISION YozestC(2),YestfC(2,2) &
      ,YestcC(2,2),ThetaacC(2,2),XXC(2),minxxp(2),maxxxp(2) &
      ,meanxxp(2),STEPS1o
  COMMON /COMYEST/ YozestC,YestfC,YestcC,ThetaacC,XXC &
      ,minxxp,maxxxp,meanxxp,STEPS1o
!92
  INTEGER i
  DOUBLE PRECISION bscale,temb,DELest,DELlest,DELtest,DELt2est
  DOUBLE PRECISION DELest2,DELlest2,DELtest2,DELt3est
  DOUBLE PRECISION DELest3,DELlest3,DELtest3,DELYest
  DOUBLE PRECISION DELtest4(2),DELtest5,DELtest6,DELtest7
  DOUBLE PRECISION DELtest8,DELYest8,DELtest9,DELYest9,meandest
  DOUBLE PRECISION DELstest4(2),atheta,btheta,ctheta,cstheta
  DOUBLE PRECISION S1,S2,ulim,llim,numint,denint
  DOUBLE PRECISION cstheta2,Fphotoshift,dtheta,etheta,atheta2
  DOUBLE PRECISION sinth,costh,sinth2,costh2 !complex algebra v Re=dpi/2
!93      DOUBLE PRECISION TEMUL		! local = 13 mum
!test
  DOUBLE PRECISION DELtest7o,meandesto,Deltest8o,Deltest8t, &
      DelYest8o,Delyest9o,Delyest9p,Deltest9o,Delyest10,Deltest10, &
      atheta3,ctheta3,atheta5,ctheta5,ctheta2 &
      ,dtheta2,etheta2,dtheta3,etheta3,dtheta4,etheta4,dtheta5,etheta5 &
      ,dtheta6,etheta6,cstheta3,cstheta4,cstheta5,cstheta6 &
      ,Delyest11,Deltest11,Delyest12,Deltest12,Delyest13,Deltest13 &
      ,btheta2,Y1,Y2,Y3,Y4,Deltest7p,Deltest7s,Y5 &
      ,M1,M2,M3,M4,M5,M6,delthgm
!
  DOUBLE PRECISION profilec
  EXTERNAL profilec
!
  INTEGER IFL2
  DOUBLE PRECISION GBt1i,Muabsi,THETAi,aplanei
  COMMON /PARAMC/ GBt1i,Muabsi,THETAi,aplanei,IFL2
!92	NOTE for xrays, RI<1 (usually!) so lambda 'increased',
!	theta (out) 'increased' Yz 'increased' compared to Bragg law
!			Refractive Index Shifts:
!		1: estimates based on RPSI0 (real structure factor)
!     bscale=0.5-0.25*(basym+1.0/basym)	! wrt incident beam
  TEMUL=1.3D2
  GBt1i=GBt1
  Muabsi=Muabs
  THETAi=THETA
  aplanei=aplane
!
  sinth=dlambdanew/d2*ORDER		! scaling? Order?
  IF (DABS(sinth).LE.1.D0) THEN	! real equivalents
    costh=DSQRT(1.D0-sinth*sinth)
  ELSE				! complex equivalents
    costh=-0.5D0*(sinth+DSQRT(sinth*sinth-1.D0) &
        -1.D0/(sinth+DSQRT(sinth*sinth-1.D0)))
  ENDIF
!NOV92:      WRITE(*,10) GBt1,THETA,aplane,muabs,maxdp,maxdm,dlambdanew,d2,ORDER
!     1  ,sinth,costh
!10    FORMAT(1X,'R,t,ap,mu,Md,l,2d,o,st,ct=',10(1PE10.3))
!
  bscale=0.5D0*(1.D0-basym)		!exit angle shift (broad source)
  DELest=-RPSI0/2.D0*bscale
!	'RI corrns make no sense if th+del>pi/2' => dell relates to sinth??
!old      DELlest=DELest/DSIN(THETA)**2.D0	! (lambdaCryst-lambda0)/lambda0
!old      DELtest=DELlest*DTAN(THETA)	! thetaC-thetaB
  DELlest=DELest/sinth**2.D0	! (lambdaCryst-lambda0)/lambda0
  DELtest=DELlest*sinth/costh	! thetaC-thetaB
!		'Exact' implementation of Eqn 5b,
!	but with nl/2d old+new replaced by 'effective' (1=max):
  DELt2est=DASIN(DMIN1(1.D0,DSQRT(DELest*(2.D0-DELest) &
      +sinth**2.D0)))-THETA		! Real part only
!old     1  +DSIN(THETA)**2.D0)))-THETA	! Real part only
!old      DELt3est=DASIN(DMIN1(1.D0,DSIN(THETA)+DELest/DSIN(THETA)))
!		'Exact' implementation of Eqn 6,
!	but with nl/2d old+new replaced by 'effective' (1=max):
  DELt3est=DASIN(DMIN1(1.D0,sinth+DELest/sinth)) &
      -THETA				! Real part only
  DELYest=DELtest*GBt1		! Yiz-Yoz
!		2: estimates based on kZed
  DELest2=DREAL(F0(1))*Numcells*dlambdanew**2.*1D-20*re0/2.D0 &
      /DPI*bscale
  DELlest2=DELest2/sinth/sinth	! (lambdaCryst-lambda0)/lambda0
  DELtest2=DELlest2*sinth/costh	! thetaC-thetaB
!old      DELlest2=DELest2/DSIN(THETA)**2.	! (lambdaCryst-lambda0)/lambda0
!old      DELtest2=DELlest2*DTAN(THETA)	! thetaC-thetaB
!      DELt2est2=DASIN(DSQRT(DELest2*(2.D0-DELest2)+DSIN(THETA)**2))-THETA
!      DELYest2=DELtest2*GBt1		! Yiz-Yoz
!		3: estimates based on Zeff
  DELest3=DREAL(F0(2))*Numcells*dlambdanew**2.D0*1D-20*re0/2.D0 &
      /DPI*bscale
  DELlest3=DELest3/sinth/sinth	! (lambdaCryst-lambda0)/lambda0
  DELtest3=DELlest3*sinth/costh	! thetaC-thetaB
!old      DELlest3=DELest3/DSIN(THETA)**2.! (lambdaCryst-lambda0)/lambda0
!old      DELtest3=DELlest3*DTAN(THETA)	! thetaC-thetaB
!      DELt2est3=DASIN(DSQRT(DELest3*(2.D0-DELest)+DSIN(THETA)**2))-THETA
!      DELYest3=DELtest3*GBt1		! Yiz-Yoz
!		4:	Profile Asymmetry (maximum): - sign.
  temb=-DSQRT(DABS(basym))/basym
  DELstest4(1)=-DSQRT(MPSIr2)/sinth*DABS(costh*costh &
      -sinth*sinth)/temb	! delsinth;K=abs(cos2th)
  DELstest4(2)=-DSQRT(MPSIr2)/sinth/temb	! *K2=*1
!	old method dth=delsinth/DCOS(THETA+DELt3est) is fine below pi/2, vs
  sinth2=sinth+DELlest3*sinth
  IF (DABS(sinth2).LE.1.D0) THEN	! real equivalents
    costh2=DSQRT(1.D0-sinth2*sinth2)
  ELSE
    costh2=-0.5D0*(sinth2+DSQRT(sinth2*sinth2-1.D0) &
        -1.D0/(sinth2+DSQRT(sinth2*sinth2-1.D0)))
  ENDIF
  DO i=1,2
!old       DELtest4(i)=DASIN(DSIN(THETA+DELt3est)+DELstest4(i))
!old     1   -(THETA+DELt3est)		! more robust only up to pi/2
    DELtest4(i)=DELstest4(i)/costh2	! should be zero above pi/2
  ENDDO
!		5:	Depth Penetration (high energy): - sign.
  DELtest5=-MaxT2/4.D0/GBt1*(1.D0/DTAN(THETA+aplane)+ &
      1.D0/DTAN(THETA-aplane))
!		6:	Depth Penetration (low energy): - sign.
  S1=muabs/(1.D0/DSIN(THETA+aplane)+1.D0/DSIN(THETA-aplane))
  DELtest6=-1.D0/S1/2.D0/GBt1*(1.D0/DTAN(THETA+aplane) &
      +1.D0/DTAN(THETA-aplane))
!		7:	Depth Penetration (general energy): - sign.
!92NOV:
  IFL2=1
  llim=0.D0
  ulim=DMIN1(MaxT2,GBt1*(1.D0/DCOS(THETA+aplane)-1.D0) &
      ,GBt1*(1.D0/DCOS(THETA-aplane)-1.D0))
  CALL QROMBD(profilec,llim,ulim,numint)
  IFL2=2
  CALL QROMBD(profilec,llim,ulim,denint)
  meandest=numint/denint
!OCT
  meandesto=((DEXP(-S1*MaxT2)-1.D0)/S1+MaxT2*DEXP(-S1*MaxT2)) &
      /(DEXP(-S1*MaxT2)-1.D0)
!		7.5:	XZ lateral shift DthA/2=mean DthB(DP)
!OCT
  DELtest7o=-0.5D0/GBt1*(1.D0/DTAN(THETA+aplane) &
      +1.D0/DTAN(THETA-aplane))*meandest
!92NOV:
  DELtest7=0.5D0*(DACOS((1.D0+meandest/GBt1)*DCOS(THETA+aplane)) &
      +DACOS((1.D0+meandest/GBt1)*DCOS(THETA-aplane)))-THETA
!92NOV:				PI POLN:
  DELtest7p=0.5D0*(DACOS((1.D0+mdepth(2)/GBt1)*DCOS(THETA+aplane)) &
      +DACOS((1.D0+mdepth(2)/GBt1)*DCOS(THETA-aplane)))-THETA
!92NOV:				SIGMA POLN:
  DELtest7s=0.5D0*(DACOS((1.D0+mdepth(1)/GBt1)*DCOS(THETA+aplane)) &
      +DACOS((1.D0+mdepth(1)/GBt1)*DCOS(THETA-aplane)))-THETA
!		8:	Tertiary correction: min.lateral shift: - sign.
!NOV92:
  btheta=THETA+aplane
  atheta=-2.D0*DELtest7+btheta	! tha+thb=|Dth+ + Dth-|+THB+apl
  etheta=DSIN(atheta)**2*(DSIN(atheta)**2 &
      -4.D0*DCOS(btheta)*(DCOS(btheta)-DCOS(atheta)))
  IF (etheta.LE.0.D0) THEN
    DELtest8t=(2.D0*DCOS(btheta)-DCOS(atheta))*DCOS(atheta)
  ELSE
    DELtest8t=(2.D0*DCOS(btheta)-DCOS(atheta))*DCOS(atheta) &
        -DSQRT(etheta)		! note always - sign
  ENDIF
  IF (DELtest8t.GT.-1.D0) THEN
    DELtest8=0.5D0*DACOS(DELtest8t)-btheta
  ELSE
    DELtest8=DPIo2-btheta
  ENDIF
  DELYest8=DELtest8*GBt1
!OCT
  DELYest8o=-(costh*costh*costh/sinth/sinth/sinth) &
      *2.D0*meandest**2.D0/Gbt1
  DELtest8o=DELYest8o/GBt1
!		9:	Tertiary correction: max.lateral shift: - sign.
!NOV92
!M	maxdp/m
  atheta2=2.D0*DASIN((maxdp+maxdm)/2.D0/GBt1)+btheta !tha+b;maxdel=1/2 arc
  ctheta2=atheta2+2.D0*DELtest7			!
  dtheta=(2.D0*DCOS(btheta)-DCOS(atheta2))*DCOS(atheta2)
  etheta=DSIN(atheta2)**2*(DSIN(atheta2)**2 &
      -4.D0*DCOS(btheta)*(DCOS(btheta)-DCOS(atheta2)))
  IF (etheta.LE.0.D0) THEN
    etheta=0.D0
  ELSE
    etheta=DSQRT(etheta)
  ENDIF
!      IF (dtheta.LT.0.D0) THEN
!       cstheta=dtheta+etheta
!      ELSE
  cstheta=dtheta-etheta
!      ENDIF
  dtheta2=(2.D0*DCOS(btheta)-DCOS(ctheta2))*DCOS(ctheta2)
  etheta2=DSIN(ctheta2)**2*(DSIN(ctheta2)**2 &
      -4.D0*DCOS(btheta)*(DCOS(btheta)-DCOS(ctheta2)))
  IF (etheta2.LE.0.D0) THEN
    etheta2=0.D0
  ELSE
    etheta2=DSQRT(etheta2)
  ENDIF
!      IF (dtheta2.LT.0.D0) THEN
!       cstheta2=dtheta2+etheta2
!      ELSE
  cstheta2=dtheta2-etheta2
!      ENDIF
  IF (cstheta.GT.-1.D0.AND.cstheta.LT.1.D0) THEN
    DELtest9=0.5D0*(DACOS(cstheta)-DACOS(cstheta2))
  ELSEIF (cstheta2.GT.-1.D0.AND.cstheta2.LT.1.D0) THEN
    DELtest9=0.5D0*(DPI-DACOS(cstheta2))
  ELSE
    DELtest9=0.D0
  ENDIF
  DELYest9=DELtest9*GBt1
!OCT
  DELYest9o=-(costh*costh/sinth/sinth)*(maxdp+maxdm)*meandest/Gbt1
  DELtest9o=DELYest9o/GBt1
  DELYest9p=-(costh/sinth)*Gbt1/2.D0*DSIN(ThetaacC(1,ip))**2
!DEC92		10:	Tertiary correction: est.lateral shift: - sign.
  ctheta3=-ThetaacC(1,ip)+btheta	! tha+thb, base / no XZ
  atheta3=ctheta3-2.D0*DELtest7	! dtha=-2Dt7 (+ve)
  dtheta3=(2.D0*DCOS(btheta)-DCOS(atheta3))*DCOS(atheta3)
  etheta3=DSIN(atheta3)**2*(DSIN(atheta3)**2 &
      -4.D0*DCOS(btheta)*(DCOS(btheta)-DCOS(atheta3)))
  IF (etheta3.LE.0.D0) THEN
    etheta3=0.D0
  ELSE
    etheta3=DSQRT(etheta3)
  ENDIF
!      IF (dtheta3.LT.0.D0) THEN
!       cstheta3=dtheta3+etheta3
!      ELSE
  cstheta3=dtheta3-etheta3
!      ENDIF
  dtheta4=(2.D0*DCOS(btheta)-DCOS(ctheta3))*DCOS(ctheta3)
  etheta4=DSIN(ctheta3)**2*(DSIN(ctheta3)**2 &
      -4.D0*DCOS(btheta)*(DCOS(btheta)-DCOS(ctheta3)))
  IF (etheta4.LE.0.D0) THEN
    etheta4=0.D0
  ELSE
    etheta4=DSQRT(etheta4)
  ENDIF
!      IF (dtheta4.LT.0.D0) THEN
!       cstheta4=dtheta4+etheta4
!      ELSE
  cstheta4=dtheta4-etheta4
!      ENDIF
  IF (cstheta3.GT.-1.D0.AND.cstheta3.LT.1.D0) THEN
    DELtest10=0.5D0*(DACOS(cstheta3)-DACOS(cstheta4))
  ELSEIF (cstheta4.GT.-1.D0.AND.cstheta4.LT.1.D0) THEN
    DELtest10=0.5D0*(DPI-DACOS(cstheta4))
  ELSE
    DELtest10=0.D0
  ENDIF
  DELYest10=DELtest10*GBt1
!DEC92		11:	Tertiary correction: est.lateral shift: - sign.
  btheta2=aplane+meanff(2,2)+Deltest7p	! pi poln
!      atheta5=-ThetaacC(1,ip)+btheta2
!      ctheta5=atheta5+2.D0*DELtest7p
  ctheta5=-ThetaacC(1,ip)+btheta2	! tha+thb, base / no XZ
  atheta5=ctheta5-2.D0*DELtest7p	! dtha=-2Dt7p (+ve)
  dtheta5=(2.D0*DCOS(btheta2)-DCOS(atheta5))*DCOS(atheta5)
  etheta5=DSIN(atheta5)**2*(DSIN(atheta5)**2 &
      -4.D0*DCOS(btheta2)*(DCOS(btheta2)-DCOS(atheta5)))
  IF (etheta5.LE.0.D0) THEN
    etheta5=0.D0
  ELSE
    etheta5=DSQRT(etheta5)
  ENDIF
!      IF (dtheta5.LT.0.D0) THEN
!       cstheta5=dtheta5+etheta5
!      ELSE
  cstheta5=dtheta5-etheta5
!      ENDIF
  dtheta6=(2.D0*DCOS(btheta2)-DCOS(ctheta5))*DCOS(ctheta5)
  etheta6=DSIN(ctheta5)**2*(DSIN(ctheta5)**2 &
      -4.D0*DCOS(btheta2)*(DCOS(btheta2)-DCOS(ctheta5)))
  IF (etheta6.LE.0.D0) THEN
    etheta6=0.D0
  ELSE
    etheta6=DSQRT(etheta6)
  ENDIF
!      IF (dtheta6.LT.0.D0) THEN
!       cstheta6=dtheta6+etheta6
!      ELSE
  cstheta6=dtheta6-etheta6
!      ENDIF
  IF (cstheta5.GT.-1.D0.AND.cstheta5.LT.1.D0) THEN
    DELtest11=0.5D0*(DACOS(cstheta5)-DACOS(cstheta6))
  ELSEIF (cstheta6.GT.-1.D0.AND.cstheta6.LT.1.D0) THEN
    DELtest11=0.5D0*(DPI-DACOS(cstheta6))
  ELSE
    DELtest11=0.D0
  ENDIF
  DELYest11=DELtest11*GBt1
  Y5=0.5D0*DACOS(cstheta6)*GBt1-YozC(ip)
!DEC92		12:	Tertiary correction: est.lateral shift: - sign.
!      atheta5=ThetaacC(1,ip)+THETA+aplane	! tha+thb, max
!      ctheta5=atheta5-2.D0*DELtest7
!      dtheta5=(2.D0*DCOS(btheta)-DCOS(atheta5))*DCOS(atheta5)
!      etheta5=DSIN(atheta5)**2*(DSIN(atheta5)**2
!     1  -4.D0*DCOS(btheta)*(DCOS(btheta)-DCOS(atheta5)))
!      IF (etheta5.LE.0.D0) THEN
!       etheta5=0.D0
!      ELSE
!       etheta5=DSQRT(etheta5)
!      ENDIF
!c      IF (dtheta5.LT.0.D0) THEN
!c       cstheta5=dtheta5+etheta5
!c      ELSE
!       cstheta5=dtheta5-etheta5
!c      ENDIF
!      dtheta6=(2.D0*DCOS(btheta)-DCOS(ctheta5))*DCOS(ctheta5)
!      etheta6=DSIN(ctheta5)**2*(DSIN(ctheta5)**2
!     1  -4.D0*DCOS(btheta)*(DCOS(btheta)-DCOS(ctheta5)))
!      IF (etheta6.LE.0.D0) THEN
!       etheta6=0.D0
!      ELSE
!       etheta6=DSQRT(etheta6)
!      ENDIF
!c      IF (dtheta6.LT.0.D0) THEN
!c       cstheta6=dtheta6+etheta6
!c      ELSE
!       cstheta6=dtheta6-etheta6
!c      ENDIF
!      IF (cstheta5.GT.-1.D0.AND.cstheta5.LT.1.D0) THEN
!        DELtest12=0.5D0*(DACOS(cstheta5)-DACOS(cstheta6))
!      ELSEIF (cstheta6.GT.-1.D0.AND.cstheta6.LT.1.D0) THEN
!        DELtest12=0.5D0*(DPI-DACOS(cstheta6))
!      ELSE
!        DELtest12=0.D0
!      ENDIF
!      DELYest12=DELtest12*GBt1
!DEC92		13:	Tertiary correction: est.lateral shift: - sign.
!      atheta5=ThetaacC(1,ip)+THETA+aplane	! tha+thb, max
!      ctheta5=atheta5+2.D0*DELtest7
!      dtheta5=(2.D0*DCOS(btheta)-DCOS(atheta5))*DCOS(atheta5)
!      etheta5=DSIN(atheta5)**2*(DSIN(atheta5)**2
!     1  -4.D0*DCOS(btheta)*(DCOS(btheta)-DCOS(atheta5)))
!      IF (etheta5.LE.0.D0) THEN
!       etheta5=0.D0
!      ELSE
!       etheta5=DSQRT(etheta5)
!      ENDIF
!c      IF (dtheta5.LT.0.D0) THEN
!c       cstheta5=dtheta5+etheta5
!c      ELSE
!       cstheta5=dtheta5-etheta5
!c      ENDIF
!      dtheta6=(2.D0*DCOS(btheta)-DCOS(ctheta5))*DCOS(ctheta5)
!      etheta6=DSIN(ctheta5)**2*(DSIN(ctheta5)**2
!     1  -4.D0*DCOS(btheta)*(DCOS(btheta)-DCOS(ctheta5)))
!      IF (etheta6.LE.0.D0) THEN
!       etheta6=0.D0
!      ELSE
!       etheta6=DSQRT(etheta6)
!      ENDIF
!c      IF (dtheta6.LT.0.D0) THEN
!c       cstheta6=dtheta6+etheta6
!c      ELSE
!       cstheta6=dtheta6-etheta6
!c      ENDIF
!      IF (cstheta5.GT.-1.D0.AND.cstheta5.LT.1.D0) THEN
!        DELtest13=0.5D0*(DACOS(cstheta5)-DACOS(cstheta6))
!      ELSEIF (cstheta6.GT.-1.D0.AND.cstheta6.LT.1.D0) THEN
!        DELtest13=0.5D0*(DPI-DACOS(cstheta6))
!      ELSE
!        DELtest13=0.D0
!      ENDIF
!      DELYest13=DELtest13*GBt1
!testDEC92
  WRITE(*,144) meandesto,meandest &
      ,mdepth(3),mdepth(4),mdepth(5),mdepth(6)
144 FORMAT(1X,'dbar/muabs ',1PE8.2,1PE10.3,'/exp,1/.1%',4(1PE10.3))
  WRITE(*,146) &
!93     1 Deltest5,Deltest6,Deltest7o,
      Deltest7,Deltest7s,Deltest7p,Y5
146 FORMAT(1X,'DTheta DPmuabs/exp,s/p=',3(1PE10.3) &
        ,' Off-axis shift:',1PE10.3)
  WRITE(*,147) 		 &! Deltest8,DelYest8,Deltest8o,Deltest9o,
      Deltest9			 &! ,DelYest9o
      ,DelYest9,Deltest10,DelYest10 &
      ,Deltest11,DelYest11	! ,Y5,XXC(1),minxxp(1),maxxxp(1)
147 FORMAT(1X,'Lat.dt,dY max/abs/pi',6(1PE10.3))
!		10:	Last shift mentioned = Mphotoshift: + sign.
!		Mshift1:
  WRITE(12,150) THETA,dlambdanew,DELtest,DELtest2,DELtest3 &
      ,DELt2est,DELt3est,bscale-1.D0,DELtest4(1),DELtest4(2)
!	^ all measures independent of ifp/ffp/fcm (AGE)
150 FORMAT(F7.4,1PE13.6,3(1X,1PE10.3),2(1X,1PE10.3),4(1X,1PE9.2))
  IF (AGE.EQ.0) THEN		! ifp measures:
    WRITE(13,151) THETA,dlambdanew,meandest,DELtest5,DELtest6 &
        ,DELtest7 &
!	^ measures independent of ifp/ffp/fcm (AGE)
        ,mangle(1,1,1),mangle(1,1,2) &
!	^sigma,pi delth values (full range, delth scale)
        ,thpk1-THETA,thpk2-THETA,fwhm1,fwhm2
!	^shift of peaks; fwhm's
151 FORMAT(F7.4,1PE13.6,1PE11.4,3(1X,1PE10.3),2(1X,1PE11.4) &
        ,2(1X,1PE10.3),2(1X,1PE10.3))
    Fphotoshift=(1.D0/mufilm-DEXP(-mufilm*TEMUL/DSIN(atheta)) &
        *(1.D0/mufilm+TEMUL/DSIN(atheta))) &
        /(1.D0-DEXP(-mufilm*TEMUL/DSIN(atheta)))*DCOS(atheta)
!			Mshift3:
    WRITE(14,153) THETA,dlambdanew,DELest &
        ,DELtest8,DELtest9,Fphotoshift &
        ,DELlest,DELt3est+DELtest4(1)/4.D0 &
        ,DELt3est+DELtest4(2)/4.D0 &
        ,DELYest,Deltest8o,Deltest9o	!Mshift31/GBt1,Mshift3/GBt1
!	^ Fph=c6, Fsum=c8,9, Dt89o=c11,12, dept on ifp/ffp/fcm (AGE)
153 FORMAT(F7.4,1PE13.6,1X,1PE10.3,2(1X,1PE10.3),2(1X,1PE10.3) &
        ,2(1X,1PE11.4),3(1X,1PE10.3))
    WRITE(15,156) THETA,dlambdanew,((mangle(1,i,j),j=1,2),i=2,3), &
!	^sigma,pi delth values (2/3 decade ranges, delth scale)
        ((DASIN(mangle(4,i,j)+DSIN(THETA))-THETA,j=1,2),i=1,2)
!	^sigma,pi delth values (full/2-decade ranges, delsinth scale)
!	^near pi/2,delsth/100 (etc.) so precision-limited?
156 FORMAT(F7.4,1PE13.6,8(1X,1PE11.4))
  ELSEIF (AGE.LE.1) THEN		! ffp measures:
    WRITE(13,151) THETA,dlambdanew,meandest,DELtest5,DELtest6 &
        ,DELtest7 &
!	^ all measures independent of ifp/ffp/fcm (AGE)
        ,meanff(1,1)-THETA,meanff(1,2)-THETA &
!	^sigma,pi delth values (full range, delth scale)
        ,ffpk(1)-THETA,ffpk(2)-THETA,c2ff(1)-c1ff(1),c2ff(2)-c1ff(2)
!	^shift of peaks; fwhm's
    Fphotoshift=DCOS(atheta)/GBt1*(1.D0/mufilm-TEMUL/DSIN(atheta) &
        /(DEXP(mufilm*TEMUL/DSIN(atheta))-1.D0))
!old    (1.D0/mufilm-DEXP(-mufilm*TEMUL/DSIN(atheta))
!     1  *(1.D0/mufilm+TEMUL/DSIN(atheta)))/GBt1
!     2  /(1.D0-DEXP(-mufilm*TEMUL/DSIN(atheta)))*DCOS(atheta)
!			Mshift3:
    WRITE(14,153) THETA,dlambdanew,DELest &
        ,DELtest8,DELtest9,Fphotoshift &
        ,DELlest,DELt3est+DELtest4(1)/4.D0 &
        ,DELt3est+DELtest4(2)/4.D0 &
        ,DELYest,Deltest8o,Deltest9o	!Mshift31/GBt1,Mshift3/GBt1
!	^ Fph=c6, Fsum=c8,9, Dt89o=c11,12, dept on ifp/ffp/fcm (AGE)
    WRITE(15,156) THETA,dlambdanew,((meanff(i,j)-THETA,j=1,2),i=2,3), &
!	^sigma,pi delth values (2/3 decade ranges, delth scale)
        ((meanff(i,j)-THETA,j=1,2),i=4,5)
!	^sigma,pi delth values (full/2-decade ranges, delsinth scale)
  ELSE				! fcp/ curved ffp measures
    IF (detmatch.EQ.0) THEN
      WRITE(13,151) THETA,dlambdanew,mdepth(1),mdepth(2),DELtest7s &
          ,DELtest7p &
!	^ sigma, pi depths, mean angular DP shift (AGE)
          ,Mshift21,Mshift2,Mshift41(1)-THETA,Mshift4(1)-THETA &
!       ^sigma,pi ESTD delth shifts on thout,thff,Y scales, curved crystals
          ,Mshift31(1)/GBt1,Mshift31(2)/GBt1
    ENDIF
!			Mshift3:
    WRITE(14,153) THETA,dlambdanew &
        ,DELYest8,DELYest9,GBt1*(meanff(2,1)-THETA) &
        ,GBt1*(meanff(2,2)-THETA),GBt1*Mshift21,GBt1*Mshift2 &
        ,GBt1*(DELt3est+DELtest4(1)/4.D0+DELtest7) &
        ,Mphotoshift,Mshift31(1),Mshift31(2)
!	^all exc Mph=c6,Sum=c8,9,Msh=c11,12, indept of ifp/ffp/fcm (AGE)
    WRITE(15,156) THETA,dlambdanew,((meanff(i,j)-THETA,j=1,2),i=2,3), &
!	^sigma,pi delth values (2/3 decade ranges, delth scale)
        ((meanff(i,j)-THETA,j=1,2),i=4,5)
!	^sigma,pi delth values (full/2-decade ranges, delsinth scale)
    IF (mthld(1).LE.0.D0) THEN
      M1=0.D0
      M2=0.D0
      M3=0.D0
      M4=0.D0
      M5=0.D0
      M6=0.D0
    ELSE
      M1=mthld(1)-THETA
      M2=mthld(2)-THETA
      M3=mthld(1)-meanff(3,1)
      M4=mthld(2)-meanff(3,2)
      M5=mthld(3)-meanff(2,1)	! 2-decade compared to 2-decade...
      M6=mthld(4)-meanff(2,2)
    ENDIF
    IF (detmatch.EQ.0) THEN
      IF (YestcC(1,1).LE.0.D0) THEN
        Y1=0.D0
        Y3=0.D0
      ELSE
        Y1=YestcC(1,1)-YozC(1)
        Y3=YestcC(1,1)-YozC(1)+DelYest11+Mphotoshift
      ENDIF
      IF (YestcC(1,2).LE.0.D0) THEN
        Y2=0.D0
        Y4=0.D0
      ELSE
        Y2=YestcC(1,2)-YozC(1)
        Y4=YestcC(1,2)-YozC(1)+DelYest11+Mphotoshift
      ENDIF
!			Mshift5:
      WRITE(16,159) THETA,dlambdanew,M1 &
!old		,YozC(1)-GBt1*THETA
          ,YestfC(1,1)-YozC(1) &
          ,YestfC(1,2)-YozC(1),Y1,Y2 &
          ,M2,M5,M6 &
!old     4  ,DelYest10,DelYest11,Y5
          ,Y3,Y4
      delthgm=(2.25D0*swidth*swidth/DSIN(meanff(2,1)) &
          /DCOS(meanff(2,1)) &
          +3.D0*maxt2*maxt2-0.25*(maxdp+maxdm)**2/DTAN(meanff(2,1))) &
          /(24.D0*GBt1*GBt1)
!M maxdm/p
!			Mshift7:
      IF (VARMAX.EQ.1) THEN
        WRITE(18,159) THETA,dlambdanew,XXC(1),minxxp(1),maxxxp(1) &
            ,YestfC(1,1)-GBt1*meanff(2,1) &
            ,YestfC(1,2)-GBt1*meanff(2,2),0.D0,0.D0,0.D0,0.D0,0.D0 ! ,delthgm
      ELSEIF (VARMAX.EQ.2) THEN
        WRITE(18,159) THETA,dlambdanew,XXC(1),minxxp(1),maxxxp(1) &
            ,YestfC(1,1)-GBt1*meanff(2,1) &
            ,YestfC(1,2)-GBt1*meanff(2,2) &
            ,XXC(2),minxxp(2),maxxxp(2) &
            ,YestfC(2,1)-GBt1*meanff(2,1) &
            ,YestfC(2,2)-GBt1*meanff(2,2)
      ENDIF
    ENDIF
!			Mshift6:
    WRITE(17,159) THETA,dlambdanew &
        ,YozC(1)-GBt1*THETA,DelYest10 &
        ,emthld(1)-meanff(3,1)+THETA &
        ,emthld(2)-meanff(3,2)+THETA,M3 &
        ,M4,Delyest9p &
        ,DelYest11,Y5 &
        ,mdepth(3)
159 FORMAT(F7.4,1PE14.5,10(1X,1PE10.3))
  ENDIF
!
  RETURN
END
!-------------------------------------------------------------------------
DOUBLE PRECISION FUNCTION PROFILEC(xp1)
  IMPLICIT NONE
  INTEGER IFL2
  DOUBLE PRECISION GBt1,Muabs,THETA,aplane
  COMMON /PARAMC/ GBt1,Muabs,THETA,aplane,IFL2
  DOUBLE PRECISION xp1
  DOUBLE PRECISION B1,B2,P1,P2,P6
!
!		Utility functions for integration
!
  B1=(GBt1+xp1)*DSIN(THETA-aplane)
  B2=(GBt1+xp1)*DSIN(THETA+aplane)
  P1=B1-DSQRT(DABS(B1*B1-GBt1*2.D0*xp1-xp1*xp1))
  P2=B2-DSQRT(DABS(B2*B2-GBt1*2.D0*xp1-xp1*xp1))
  P6=DEXP(-muabs*(P1+P2))
  IF (IFL2.EQ.1) THEN	! numerator
    PROFILEC=P6*xp1
  ELSEIF (IFL2.EQ.2) THEN	! denominator
    PROFILEC=P6
  ELSE
    PROFILEC=0.D0
  ENDIF
!	PRINT*,'Profile at ',xp1,' = ',SNGL(P6),GBt1,Muabs,THETA,aplane
  RETURN
END
!-----------------------------------------------------------------------
!-----------------------------------------------------------------------
SUBROUTINE TRAPZD(PROFILEC,A,B,S,N)
!		Computes the Nth stage of refinement of an extended
!		trapezoidal rule for integrating FUNC from A to B = S
!		Each call adds 2**(N-2) interior pnts, increasing the
!		accuracy of S.
  IMPLICIT NONE
  INTEGER IFL2
  DOUBLE PRECISION GBt1,Muabs,THETA,aplane
  COMMON /PARAMC/ GBt1,Muabs,THETA,aplane,IFL2
  DOUBLE PRECISION profilec
  EXTERNAL profilec
!
  DOUBLE PRECISION A,B,S,X,DEL,SUM,TNM
  INTEGER N,IT,J
!
  IF (N.EQ.1) THEN
    S=0.5D0*(B-A)*(PROFILEC(A)+PROFILEC(B))
    IT=1	!no. of points added in NEXT call
  ELSE
    TNM=DFLOAT(IT)
    DEL=(B-A)/TNM	!spacing of points
    X=A+0.5D0*DEL
    SUM=0.D0
    DO J=1,IT
      SUM=SUM+PROFILEC(X)
      X=X+DEL
    ENDDO
    S=0.5D0*(S+(B-A)*SUM/TNM)
    IT=2*IT
  ENDIF
  RETURN
END
!---------------------------------------------------------------------
SUBROUTINE POLINTd(XA,YA,N,X,Y,DY)
!		Given arrays XA,YA of length N and a value X, this
!		returns Y and an error estimate DY.
!
  IMPLICIT NONE
  INTEGER IFL2
  DOUBLE PRECISION GBt1,Muabs,THETA,aplane
  COMMON /PARAMC/ GBt1,Muabs,THETA,aplane,IFL2
!
  INTEGER NS,N,I
  INTEGER NMAX,M
  PARAMETER (NMAX=10)
  DOUBLE PRECISION XA(N),YA(N),C(NMAX),D(NMAX),X,Y,DY,HO,HP &
      ,W,DEN,DIF,DIFT
!
  NS=1
  DIF=DABS(X-XA(1))
  DO I=1,N
    DIFT=DABS(X-XA(I))
    IF(DIFT.LT.DIF) THEN
      NS=I
      DIF=DIFT
    ENDIF
    C(I)=YA(I)
!(I)=YA(I)
  ENDDO
  Y=YA(NS)
  NS=NS-1
  DO M=1,N-1
    DO I=1,N-M
      HO=XA(I)-X
      HP=XA(I+M)-X
      W=C(I+1)-D(I)
      DEN=HO-HP
      IF (DEN.EQ.0.D0) THEN
        DEN=1.D0
        PRINT *,' Two XAs are equal in polintd'
      ELSE
        DEN=W/DEN
      ENDIF
      D(I)=HP*DEN
!(I)=HO*DEN
    ENDDO
    IF (2*NS.LT.N-M) THEN	!after each column in the tableau
!			is completed, decide which correction (C or D)
!			to add to the accumulating value Y (forking
!			up or down along the most 'straight line' route)
      DY=C(NS+1)
    ELSE
      DY=D(NS)
      NS=NS-1
    ENDIF
    Y=Y+DY
  ENDDO
  RETURN
END
!-----------------------------------------------------------------------
SUBROUTINE QROMBD(PROFILEC,A,B,SS)
!		Returns as SS the integral of PROFILE from A to B, by 
!		Romberg's method of order 2K, for a closed interval
!
  IMPLICIT NONE
  INTEGER IFL2
  DOUBLE PRECISION GBt1,Muabs,THETA,aplane
  COMMON /PARAMC/ GBt1,Muabs,THETA,aplane,IFL2
!
  DOUBLE PRECISION profilec
  EXTERNAL profilec
!
  INTEGER JMAX,JMAXP,K,KM
  PARAMETER (JMAX=20,JMAXP=JMAX+1,K=3,KM=K-1)
!		EPS is the desired fractional accuracy from the
!		extrapolation estimate, JMAX limits the no. of steps
  DOUBLE PRECISION S(JMAXP),H(JMAXP),A,B,SS,DSS,EPS
  INTEGER J
!
  EPS=0.0002D0
  H(1)=1.D0
  DO J=1,JMAX
    CALL TRAPZD(PROFILEC,A,B,S(J),J)
    IF (J.GE.K) THEN
      CALL POLINTD(H(J-KM),S(J-KM),K,0.D0,SS,DSS)
      IF (DABS(DSS).LE.EPS*DABS(SS)) RETURN
    ENDIF
    S(J+1)=S(J)
    H(J+1)=H(J)*0.25D0	!the extrapolation is a poly in h**2
  ENDDO
  PRINT*,'too many steps in Romberg Int',(S(J),J=1,2),EPS
  RETURN
END
!-------------------------------------------------------------------------
!-------------------------------------------------------------------------
!91		Routine for calculating Bragg diffraction profiles
!		  for one or two infinite flat perfect crystals.
!	  Notes: 1) 'Ideally' a convolution should be made over source distn
!	and wavelength spread. For a single crystal this is a straightforward
!	convolution and adds nothing (and we want to compare the result
!	to the ideal ffm monochromatic point source before convolving the
!	source with the curved crystal result, anyway).
!	  2) The double crystal results could relate to narrow detectors
!	and hence measure profiles in angle or position from the second
!	crystal; or they could use broad detectors and hence only measure
!	the change in integrated / convolved reflectivity. Conventional
!	scans can be theta-2theta, but are more commonly just the second
!	crystal rotation with a broad detector.
!	In the 2+ dimensional space (alpha1,alpha2,beta,theta_Det,x_Det),
!	there is a question as to correct alignment (y=0 location?,
!	Bragg location?, mean or peak location?) and how to achieve it;
!	and hence how to scan to derive the profile.
!	  3) Compared to this convention, I have used
!	R(theta-Delta,P2)=R(theta-Delta,1)R(theta-Delta,1) (+,-, PARALLEL,
!	'non-dispersive') instead of INT[I(alpha)R(th+alpha)R(th+alpha-beta)];
!	R(theta-Delta,A2)=R(theta-Delta,1)R(theta+Delta,1) (+,+, ANTIPARALLEL,
!	'dispersive') instead of INT[I(alpha)R(th+alpha)R(th-alpha+beta)];
!	alpha==Delta==offset from Bragg location; beta==conventional scan var.
!	theta is defined by the alignment of one crystal to the other in
!	the AP mode (the convolution is symmetric about this point): hence
!	theta must be specified as theta_B, theta_C, theta_P, theta_M, etc.
!	  In the P mode crystal misalignment is indicated through beta
!	and the peak necessarily corresponds to theta+alpha (or Delta)
!	=theta_P or theta_M depending on other broadening.
!	  4) Hence the results herein represent the double-crystal profile
!	for ideal symmetric positions (parallel crystals; or differing by
!	exactly 2theta_B) with beta=0, by varying the NARROW or PS
!	detector location (angle, or x). The sum of this profile shall
!	be the integrated reflectivity for an optimum point on either scan.
!-----------------------------------------------------------------------------
SUBROUTINE BRAGGIFP(ORDER,sintha)
  IMPLICIT NONE
!		Passed variable -
  DOUBLE PRECISION ORDER,sintha
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!92			major new curved crystal variables:
  DOUBLE PRECISION AxisTh,ABtem,Mininc,THABX,BXmin
  DOUBLE PRECISION thm1C(2),ThminC(2),ThmaxC(2),thminoC(2) &
      ,thmaxoC(2),YozC(2),YminoC(2),YmaxoC(2)
  INTEGER VARMAX,Isect(2)
  COMMON/CS5B/AxisTh,ABtem,Mininc,THABX,BXmin &
      ,thm1C,ThminC,ThmaxC,thminoC,thmaxoC,YozC,YminoC,YmaxoC &
      ,VARMAX,Isect
!		      Common (I/O) vars (CS5-Rcurve)
  INTEGER ISTEPSO,ISTEPSP
  PARAMETER (ISTEPSO=8000,ISTEPSP=8001)
  DOUBLE PRECISION RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr
  DOUBLE PRECISION MPSIr2,MPSIi2,p,s,K1,Temth0,Thout0, &
      muabs,mcurv,mReftem1,Maxt2,umbo2
  DOUBLE PRECISION Irel1(ISTEPSP),Irel2(ISTEPSP),Irel3(ISTEPSP), &
      Reflint(6),Reflintth,ReflintHy,Mshift1,Mshift2,Mshift3(2,2), &
      Mshift4(3),Ermshift4,MShiftB(6),Irel5(ISTEPSP),Irel6(ISTEPSP)
  DOUBLE PRECISION MaxI1,MaxI2,MaxI3,MaxI4,Thpk, &
      Thpko,Ypko,Th1,Thout,Yshift, &
      STEPS1,STEPS2,STEPS3,STEPS4,basym,IRELM
  COMMON/CS5C/RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr,MPSIr2,MPSIi2, &
      p,s,K1,Temth0,Thout0,muabs,mcurv,mReftem1,Maxt2,umbo2, &
      Irel1,Irel2,Irel3,Reflint,Reflintth,ReflintHy,Mshift1, &
      Mshift2,Mshift3,Mshift4,Ermshift4,MShiftB,Irel5,Irel6,MaxI1, &
      MaxI2,MaxI3,MaxI4,Thpk,Thpko, &
      Ypko,Th1,Thout,Yshift,STEPS1,STEPS2,STEPS3,STEPS4,basym
!
  DOUBLE PRECISION c251,c252,c253,c751,c752,c753,mt0
  DOUBLE PRECISION mq2,PkTh1,Reflinto,thmaxf,thminf,Mosdel, &
      c1ff(6),c2ff(6),ffpk(2),Maxff,maxt0,maxt3,sigscat,siginc &
      ,Reflintm,Reflinty,ReflintthinC
  DOUBLE PRECISION transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm(2,8,2)
  INTEGER K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2
  CHARACTER numstr*4
  COMMON/CS5D/c251,c252,c253,c751,c752,c753,mt0,mq2,PkTh1, &
      Reflinto,thmaxf,thminf,Mosdel,c1ff,c2ff, &
      ffpk,Maxff,maxt0,maxt3,sigscat,siginc,Reflintm,Reflinty, &
      Reflintthinc,transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm,K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2,numstr
!91			Form factor variables
  INTEGER ielem
  PARAMETER (ielem=20)
!91			Form factor variables
  integer iedge
  parameter (iedge=24)
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!92		Separate THREEBM/GEN2D parameters:
  INTEGER IM(4)
  DOUBLE PRECISION a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,d2,xTemp
  DOUBLE PRECISION Numcells
  COMPLEX*16 FHr, FHi, FHn(ielem)
  common/com2d/ IM,a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,Numcells,d2,xTemp,FHr,FHi,FHn
!91		I/O pars (IFP +)
  DOUBLE PRECISION RANGE(2),STEPS,DELJ(2),denom,aplane,G,G2,K12,K,K2
  DOUBLE PRECISION RI1(3),RI2(3),RI3,RFL(3),RFL2(3),RANGE0
  INTEGER CYCLE,Ibit,Jbit,J,Item
  DOUBLE PRECISION fwhm1,fwhm2
  DOUBLE PRECISION mangle(6,3,2)
  DOUBLE PRECISION RIT(6,3,2),RFLT(6,3,2)
  DOUBLE PRECISION scale1,thpk1,thpk2
  COMMON/COMIFP/RANGE,STEPS,DELJ,denom,aplane,G,G2,K12,K,K2 &
      ,RI1,RI2,RI3,RFL,RFL2,RANGE0 &
      ,fwhm1,fwhm2,mangle,RIT,RFLT &
      ,scale1,thpk1,thpk2,CYCLE,Ibit,Jbit,J,Item
!
  DOUBLE PRECISION MAXR(2),MAXJ(2)
  DOUBLE PRECISION c25j1,c75j1,c25j2,c75j2
  DOUBLE PRECISION thc251,thc252,thc751,thc752
  COMMON /COMOIFP/ MAXR,MAXJ, &
      c25j1,c75j1,c25j2,c75j2,thc251,thc252,thc751,thc752
!
  INTEGER IREAD,Photo,Jbit4,Fwrite(0:20)
  COMMON/CS5F/ IREAD,Photo,Jbit4,Fwrite
  INTEGER Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
  COMMON /COMINTS/ Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
!91		Separate output/temp. parameters (BRAGGIFP+)
  DOUBLE PRECISION ALPHA(2),DELTA(2),Y2(4),L2(4),R2(4),RRAD(2)
  DOUBLE PRECISION RFLo(2),RFLS(6,3,2),MAXRo(2),mav,temrr,temrr2
  DOUBLE PRECISION mangleo(2),R2o(4),Rj11,Rj12,Rjl1,Rjl2
  INTEGER mkr(2),Rflag(2),Rflag1,Ibit1,Jbit5,Jbit6
  CHARACTER FILEIN2*20
  DOUBLE PRECISION DELRJ(2),thc11,thc12,thc21,tolminang &
      ,thc22,toliifp,toldifp,dsinth(2),dth(2),R3(3,2),R5,R6,fwhm3
  DOUBLE PRECISION dec(3),mango(2),mangleT(6,3,2),delsinth(2),G3(4)
  DOUBLE PRECISION sinthdf,dtheta1j(2),umbo1,basym1,basym2	!,MXM(2)
  DOUBLE PRECISION delsinth0,delth0,sintinc,Kdiff,THDEL1
  COMPLEX*16 cpolf,sinthp,ctemrf(2)
  INTEGER id,ip,mkr3(3,3,2),i2,ip1
  CHARACTER*2 AN(3)
!      DOUBLE PRECISION c1(3,2,2),c99(3,2,2)
!
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!MAC95
  CHARACTER dout*11,dcom*11,ddat*7,dhen*16,dhm*8
  COMMON/Macfiles/ dout,dcom,ddat,dhen,dhm
!MAC95
!93:
  AN(1)='FL'
  AN(2)='2D'
  AN(3)='3D'
  cpolf=DCMPLX(1.D0+RPSI0,APSI0)
  tolminang=2.D-3
  delsinth0=umbo2*RPSI0/2.D0/sintha
  delth0=DASIN(DMIN1(delsinth0+sintha,1.D0))-THETA	! exp.diff.angle shift
!93
  dec(2)=1.D-2
  dec(3)=1.D-3
  toliifp=5.D-4
  toldifp=1.D-4			! save time vs 5.D-5
  RANGE(1)=RANGE0			! 10 - 40 minutes = 3 - 12 mrad
  RANGE(2)=RANGE0
  STEPS=1.D3
  DELJ(1)=-STEPS/2.D0
  DELJ(2)=-STEPS/2.D0
  MAXJ(1)=0.D0                  	! Iteration parameters
  MAXJ(2)=0.D0
  MAXRo(1)=0.D0
  MAXRo(2)=0.D0
  Jbit=1
  Jbit5=1
  Jbit6=1
  RFLo(1)=0.D0
  RFLo(2)=0.D0
  mkr(1)=2
  mkr(2)=2
  DO ip=1,2
    DO id=2,3
      DO i2=1,3
        mkr3(i2,id,ip)=2
      ENDDO
    ENDDO
  ENDDO
  DO ip=1,2
    DO i2=1,6
      DO id=1,3
        RFLT(i2,id,ip)=0.D0		! reset rflt id=2,3 at start only
        mangle(i2,id,ip)=0.D0
        RFLS(i2,id,ip)=0.D0		! reset refls for each cycle
        mangleT(i2,id,ip)=0.D0
      ENDDO
    ENDDO
  ENDDO
  Rflag1=0
2250 MAXR(1)=0.D0
  MAXR(2)=0.D0
  mangleo(1)=mangle(1,1,1)
  mangleo(2)=mangle(1,1,2)
  mango(1)=mangle(1,2,1)
  mango(2)=mangle(1,2,2)
  RRAD(1)=RANGE(1)/10800.D0*DPI		! range in radians
  RRAD(2)=RANGE(2)/10800.D0*DPI		! range in radians
  DELRJ(1)=RRAD(1)*DELJ(1)/STEPS
  DELRJ(2)=RRAD(2)*DELJ(2)/STEPS
!92		used to change both limits symmetrically;
!		now only sets upper / lower limit.
!	 Commence above crystal surface:
  DO ip=1,2
    IF ((THETA-delth0-aplane+DELRJ(ip)-RRAD(ip)/2.D0.LT.tolminang &
        .AND.Rflag(ip).EQ.0).OR.Igraz.EQ.1) THEN
      IF (Igraz.NE.1) THEN
        RANGE(ip)=RANGE(ip)/2.D0+DABS(THETA-aplane-delth0+DELRJ(ip) &
            -tolminang)*10800.D0/DPI
        RRAD(ip)=RANGE(ip)/10800.D0*DPI		! range in radians
      ENDIF
      DELJ(ip)=DELRJ(ip)*STEPS/RRAD(ip)
      Rflag1=1
      Rflag(ip)=-1
    ENDIF
!92		 Terminate at normal to Bragg planes:
    IF (THETA-delth0+DELRJ(ip)+RRAD(ip)/2.D0.GT.DPIo2 &
        .AND.Rflag(ip).EQ.0) THEN
      RANGE(ip)=RANGE(ip)/2.D0+DABS(DPIo2-THETA-DELRJ(ip)) &
          *10800.D0/DPI
      RRAD(ip)=RANGE(ip)/10800.D0*DPI		! range in radians
      DELJ(ip)=DELRJ(ip)*STEPS/RRAD(ip)
      Rflag1=1
      Rflag(ip)=1
    ENDIF
    dth(ip)=RRAD(ip)/STEPS
  ENDDO
!test
!      write(*,*)'ps,den,k12,p,sc,dt0,drj(2),Rflg1,Rflag(2)',rpsi0
!     1 ,denom,k12,p,scale1,delth0,delrj(1),delrj(2),Rflag1
!     2 ,Rflag(1),Rflag(2)
!t
  RFL(3)=0.D0
  RFL2(3)=0.D0
  DO ip=1,2
    DO i2=1,6
      RFLT(i2,1,ip)=0.D0		! reset summed rflt each cycle
      mangle(i2,1,ip)=0.D0
      DO id=1,3
        RFLS(i2,id,ip)=0.D0		! reset refls for each cycle
        mangleT(i2,id,ip)=0.D0
      ENDDO
    ENDDO
  ENDDO
  DO ip1=1,4
    R2o(ip1)=0.D0
  ENDDO
  DO J=0,IDNINT(STEPS)
    DO ip=1,2
      IF (Rflag(ip).EQ.0) THEN	! centred with aplane offset. surface.
        DELTA(ip)=delth0-RRAD(ip)*(DFLOAT(J)+DELJ(ip))/STEPS
      ELSEIF (Rflag(ip).EQ.-1) THEN	! surface grazing angle limit:
        DELTA(ip)=-aplane+THETA-tolminang-RRAD(ip)*DFLOAT(J)/STEPS
      ELSE				! DPIo2 diffracting angle limit:
        DELTA(ip)=THETA-DPIo2+RRAD(ip)-RRAD(ip)*DFLOAT(J)/STEPS
      ENDIF
      IF (J.EQ.0) THEN
        dtheta1j(ip)=DELTA(ip)
      ENDIF
! Delta is the abscissa giving a total range of +/- RANGE/2 arc minutes
!		for DELTA      DELTA is in radians = ThB-Th      
!	y=((1-b)/2*PSI0r/|PSIHr|-b(TH0-thetaB)sin(2thetaB))/(Csqrt(|b|))
!   =(g0/gh DELTA sin(2thetaB)+ .5 PSI0 (1-g0/gh))/(|C|sqrt(g0/gh)|PSIH|)
!	g=(1-b)PSI0i/PSIHr/(2Csqrt(|b|)) but b=-1
!	  ysurf=(umbo2*RPSI0+b*(Temth0-Thetas)*sin2T0)/Tem4
!old       ALPHA=2.0D0*DELTA*DSIN(2.D0*THETA)
!old       ALPHA2=2.0D0*DELTA2*DSIN(2.D0*THETA)
!93
!		The old method used b=b(th_B) for the whole profile;
!		and R2=R2(b(th_B),-p) (i.e. y => -y for the second /AP crystal);
!		whereas geometry suggests Deltath should be symmetric
!		about the peak/mean and not Bragg or y.
!		But best simple estimate is the y=0 angle (delth0).
!
      IF (ip.EQ.1) THEN
        THDEL1=THETA+DELTA(ip)-2.D0*delth0	! diffracting angle,2nd crystal
        sinthdf=DSIN(THDEL1)
        sintinc=DSIN(THDEL1-aplane)
        delsinth(ip)=sintha-sinthdf			! NOT DSIN(THETA)
        ALPHA(ip)=4.D0*sintha*delsinth(ip)		! NOT DSIN(THETA)
!92co      basym=-1.D0/(cos2apl+sin2apl*scTemth)	! approximate
!93c5      basym=-sinThins/sinThout0		! ???
!93m3      basym=-DSIN(THETA)/DSIN(THETA+2.*aplane) ! peak approx
!93AC         basym1=sintinc/(sintinc-2.D0*DSIN(THETA)*DCOS(aplane))
        basym1=-sintinc/DSIN(THDEL1+aplane)
        umbo1=(1.D0-basym1)/2.D0      ! = 1 usually
!93:	! Polarisation correction K/pi=1 but K/sigma.not.cos2thetaB:
        Kdiff=DABS(1.D0-2.D0*sinthdf*sintha) &
            /DSQRT(1.D0+4.D0*sintha*(sintha-sinthdf))
!93:	! Note this neglects refraction: sinthdf should be inside the crystal.
!93:	! Note kinematic diffn would predict cos 2thetadf instead!
        G3(3)=umbo1*APSI0/Kdiff/DSQRT(DABS(basym1)*MPSIr2)
        Y2(3)=(umbo1*RPSI0-0.5D0*ALPHA(ip)) &
            /(Kdiff*DSQRT(MPSIr2*DABS(basym1)))
!
        THDEL1=THETA-DELTA(ip)		! diffracting angle,1st crystal
        sinthdf=DSIN(THDEL1)
        sintinc=DSIN(THDEL1-aplane)
        basym1=-sintinc/DSIN(THDEL1+aplane)
!93         basym1=sintinc/(sintinc
!93     1    -2.D0*DSIN(THETA)*DCOS(aplane))	! exact? first crystal
        umbo1=(1.D0-basym1)/2.D0      ! = 1 usually
!93:	! Polarisation correction K/pi=1 but K/sigma.not.cos2thetaB:
        Kdiff=DABS(1.D0-2.D0*sinthdf*sintha) &
            /DSQRT(1.D0+4.D0*sintha*(sintha-sinthdf))
!93:	! Note this neglects refraction: sinthdf should be inside the crystal.
!93:	! Note kinematic diffn would predict cos 2thetadf instead!
        G3(1)=umbo1*APSI0/Kdiff/DSQRT(DABS(basym1)*MPSIr2)
        delsinth(ip)=sintha-sinthdf			! NOT DSIN(THETA)
        ALPHA(ip)=4.D0*sintha*delsinth(ip)		! NOT DSIN(THETA)
        Y2(1)=(umbo1*RPSI0-0.5D0*ALPHA(1)) &
            /(Kdiff*DSQRT(MPSIr2*DABS(basym1)))
!93	 ! Estimate of Fresnel coefficient for grazing angles:
!         sinthp=CDSQRT(DCMPLX(sinthdf**2+RPSI0,APSI0))
!         ctemrf(1)=(cpolf*DCMPLX(sinthdf,0.D0)-sinthp)
!     1   /(cpolf*DCMPLX(sinthdf,0.D0)+sinthp)
!		This 'is' what AC states, but needs an alpha:
        sinthp=CDSQRT(DCMPLX(sintinc**2+RPSI0,APSI0))
        ctemrf(1)=(cpolf*DCMPLX(sintinc,0.D0)-sinthp) &
            /(cpolf*DCMPLX(sintinc,0.D0)+sinthp)
      ELSE
        THDEL1=THETA+DELTA(ip)-2.D0*delth0	! diffracting angle,2nd crystal
        sinthdf=DSIN(THDEL1)
        sintinc=DSIN(THDEL1-aplane)
        delsinth(ip)=sintha-sinthdf			! NOT DSIN(THETA)
        ALPHA(ip)=4.D0*sintha*delsinth(ip)		! NOT DSIN(THETA)
!92co      basym=-1.D0/(cos2apl+sin2apl*scTemth)	! approximate
!93c5      basym=-sinThins/sinThout0		! ???
!93m3      basym=-DSIN(THETA)/DSIN(THETA+2.*aplane) ! peak (approx)
!93AC         basym1=sintinc/(sintinc-2.D0*DSIN(THETA)*DCOS(aplane))
        basym2=-sintinc/DSIN(THDEL1+aplane)
        umbo2=(1.D0-basym2)/2.D0      ! = 1 usually
        G3(4)=umbo2*APSI0/K2/DSQRT(DABS(basym2)*MPSIr2)
        Y2(4)=(umbo2*RPSI0-0.5D0*ALPHA(2)) &
            /(K2*DSQRT(MPSIr2*DABS(basym2)))
!
        THDEL1=THETA-DELTA(ip)		! diffracting angle,1st crystal
        sinthdf=DSIN(THDEL1)
        sintinc=DSIN(THDEL1-aplane)
        basym2=-sintinc/DSIN(THDEL1+aplane)
!AC         basym2=sintinc/(sintinc
!AC     1    -2.D0*DSIN(THETA)*DCOS(aplane))	! exact? first crystal
        umbo2=(1.D0-basym2)/2.D0      ! = 1 usually
        G3(2)=umbo2*APSI0/K2/DSQRT(DABS(basym2)*MPSIr2)
        delsinth(ip)=sintha-sinthdf			! NOT DSIN(THETA)
        ALPHA(ip)=4.D0*sintha*delsinth(ip)		! NOT DSIN(THETA)
        Y2(2)=(umbo2*RPSI0-0.5D0*ALPHA(2)) &
            /(K2*DSQRT(MPSIr2*DABS(basym2)))
!93	 ! Estimate of Fresnel coefficient for grazing angles:
!         sinthp=CDSQRT(DCMPLX(sinthdf**2+RPSI0,APSI0))
!         ctemrf(2)=(DCMPLX(sinthdf,0.D0)-sinthp)
!     1   /(DCMPLX(sinthdf,0.D0)+sinthp)
!		This 'is' what AC states, but needs an alpha:
        sinthp=CDSQRT(DCMPLX(sintinc**2+RPSI0,APSI0))
        ctemrf(2)=(DCMPLX(sintinc,0.D0)-sinthp) &
            /(DCMPLX(sintinc,0.D0)+sinthp)
      ENDIF
    ENDDO
    DO ip1=1,4
      L2(ip1)=(Y2(ip1)*Y2(ip1)+G3(ip1)*G3(ip1) &
          +DSQRT((Y2(ip1)*Y2(ip1)-G3(ip1)*G3(ip1) &
          -1.D0+K12)**2.D0+4.D0*(G3(ip1)*Y2(ip1)-p) &
          *(G3(ip1)*Y2(ip1)-p)))/denom
!old       L2(3)=(Y2(1)*Y2(1)+G*G+DSQRT((Y2(1)*Y2(1)-G*G-1.D0+K12)**2.D0+ 
!old     1     4.D0*(G*Y2(1)+p)*(G*Y2(1)+p)))/denom	! nb basym (G,Y) differ
      IF (L2(ip1).GT.1.D6) THEN
        R2(ip1)=scale1/2.D0/L2(ip1)		! max.frac.error=1/(4LL)
      ELSE
        R2(ip1)=scale1*(L2(ip1)-DSQRT(L2(ip1)*L2(ip1)-1.D0))
      ENDIF		! failed in 2locns: L2>4e7 (=0, n.s.f.), 2-valued
      IF (R2(ip1).LT.1.D-99) R2(ip1)=1.D-99
    ENDDO
    DO ip=1,2
!93test:	the following line is critical: 'Fresnel is OK'
      IF (Igraz.EQ.1.OR.Igraz.EQ.-1) THEN
        R2(ip)=(DSQRT(R2(ip))+DREAL(ctemrf(ip)))**2 &
            +DIMAG(ctemrf(ip))**2
      ENDIF
!93	 ! There! Painless but wrong! Note decoupling => ctemr^2+r2 instead.
!	 ! Also note Fresnel Re phase = -ve above 45 degrees (so R|b=0->max)
      R3(1,ip)=R2(ip)
      R3(2,ip)=R2(ip)*R2(ip)
      R3(3,ip)=R2(ip)*R2(ip+2)
    ENDDO
    DO ip=1,2
      mangle(1,1,ip)=mangle(1,1,ip)+R3(1,ip)*DELTA(ip)*dth(ip)
!92		dsinth measures !!!:
      dsinth(ip)=(DSIN(THETA-DELTA(ip))-DSIN(THETA-DELTA(ip) &
          +RRAD(ip)/STEPS))
      mangle(4,1,ip)=mangle(4,1,ip)-R3(1,ip)*delsinth(ip)*dsinth(ip)
!		ndisp2x, dtheta measures:
      mangle(2,1,ip)=mangle(2,1,ip)+R3(2,ip)*DELTA(ip)*dth(ip)
!		ndisp2x, dsinth measures !!!:
      mangle(5,1,ip)=mangle(5,1,ip)-R3(2,ip)*delsinth(ip)*dsinth(ip)
!		disp2x, dtheta measures:
      mangle(3,1,ip)=mangle(3,1,ip)+R3(3,ip)*DELTA(ip)*dth(ip)
!		disp2x, dsinth measures !!!:
      mangle(6,1,ip)=mangle(6,1,ip)-R3(3,ip)*delsinth(ip)*dsinth(ip)
!92			full calcns only
!		RFL= INT(RAVG over radians or sinth!)
      DO i2=1,3
        RFLT(i2,1,ip)=RFLT(i2,1,ip)+R3(i2,ip)*dth(ip)
        RFLT(i2+3,1,ip)=RFLT(i2+3,1,ip)-R3(i2,ip)*dsinth(ip)
      ENDDO
    ENDDO
!
    IF (CYCLE.EQ.0.OR.CYCLE.EQ.5) THEN
      R5=R2(1)		! vs MAX(R5,R)
      R6=R2(2)		! vs MAX(R6,R2)
      Ibit1=Ibit1+1
      IF ((Ibit1.GE.Jbit).OR.(Ibit1.GE.Jbit5.AND.R5.GT.4.D-2 &
          *MAXRo(1).AND.c75j1-c25j1.GT.1.).OR.(Ibit1.GE.Jbit6.AND. &
          R6.GT.4.D-2*MAXRo(2).AND.c75j2-c25j2.GT.1.)) THEN
        WRITE(1,2260) (THETA-DELTA(1)),R5,Ibit,Y2(1)	!,G3(1),L2(1)
        WRITE(7,2260) (THETA-DELTA(2)),R6,Ibit,Y2(2)	!,G3(2),L2(2)
        Ibit=Ibit+1
        R5=-1.D0
        R6=-1.D0
        Ibit1=0
      ENDIF
2260  FORMAT(1X,1PE15.8,1X,1PE13.6,1X,I5,1X,1PE11.4)	!,2(1X,1PE9.2))
    ENDIF
!
    IF (J.EQ.0) THEN
      Rj11=R2(1)
      Rj12=R2(2)
    ENDIF
    IF (J.EQ.IDNINT(STEPS)) THEN
      Rjl1=R2(1)
      Rjl2=R2(2)
    ENDIF
    DO ip=1,2
      IF (MAXR(ip).LE.R2(ip)) THEN
        MAXR(ip)=R2(ip)
        MAXJ(ip)=DFLOAT(J)
!         IF (MAXR(ip).GT.MAXRo(ip)) THEN
!          MXM(ip)=MAXR(ip)
!         ENDIF
      ENDIF
    ENDDO
!92		Iteration to c25, c75
    IF (mkr(1).EQ.0.AND.R2(1).GT.MAXRo(1)/2.D0) THEN
      c25j1=DFLOAT(J)-(R2(1)-0.5D0*MAXRo(1))/(R2(1)-R2o(1))
      mkr(1)=1
    ELSEIF (mkr(1).EQ.1.AND. &
        R2(1).LT.MAXRo(1)/2.D0.AND.R2o(1).GE.MAXRo(1)/2.D0) THEN
      c75j1=DFLOAT(J)-(0.5D0*MAXRo(1)-R2(1))/(R2o(1)-R2(1))
    ENDIF
    IF (mkr(2).EQ.0.AND.R2(2).GT.MAXRo(2)/2.D0) THEN
      c25j2=DFLOAT(J)-(R2(2)-0.5D0*MAXRo(2))/(R2(2)-R2o(2))
      mkr(2)=1
    ELSEIF (mkr(2).EQ.1.AND. &
        R2(2).LT.MAXRo(2)/2.D0.AND.R2o(2).GE.MAXRo(2)/2.D0) THEN
      c75j2=DFLOAT(J)-(R2(2)-0.5D0*MAXRo(2))/(R2(2)-R2o(2))
    ENDIF
!92		Iteration to c1, c0.1, c99, c99.9:
    DO id=2,3
      DO ip=1,2
        IF (mkr3(1,id,ip).EQ.0.AND.R2(ip).GT. &
            MAXRo(ip)*dec(id)) THEN
          mkr3(1,id,ip)=1
        ENDIF
        IF (mkr3(2,id,ip).EQ.0.AND.R2(ip)*R2(ip).GT. &
            MAXRo(ip)*MAXRo(ip)*dec(id)) THEN
          mkr3(2,id,ip)=1
        ENDIF
        IF (mkr3(3,id,ip).EQ.0.AND.R2(ip)*R2(ip+2) &
            .GT.MAXRo(ip)*MAXRo(ip)*dec(id)) THEN
          mkr3(3,id,ip)=1
        ENDIF
        IF (mkr3(1,id,ip).EQ.1.AND.R2(ip).LT. &
            MAXRo(ip)*dec(id)) THEN
          mkr3(1,id,ip)=0
        ENDIF
        IF (mkr3(2,id,ip).EQ.1.AND.R2(ip)*R2(ip).LT. &
            MAXRo(ip)*MAXRo(ip)*dec(id)) THEN
          mkr3(2,id,ip)=0
        ENDIF
        IF (mkr3(3,id,ip).EQ.1.AND.R2(ip)*R2(ip+2) &
            .LT.MAXRo(ip)*MAXRo(ip)*dec(id)) THEN
          mkr3(3,id,ip)=0
        ENDIF
        DO i2=1,3
          IF (mkr3(i2,id,ip).EQ.1) THEN
            mangleT(i2,id,ip)=mangleT(i2,id,ip)+R3(i2,ip)*DELTA(ip) &
                *dth(ip)
            mangleT(i2+3,id,ip)=mangleT(i2+3,id,ip)-R3(i2,ip) &
                *delsinth(ip)*dsinth(ip)
            RFLS(i2,id,ip)=RFLS(i2,id,ip)+R3(i2,ip)*dth(ip)
            RFLS(i2+3,id,ip)=RFLS(i2+3,id,ip)-R3(i2,ip)*dsinth(ip)
          ENDIF
        ENDDO
      ENDDO
    ENDDO
    DO ip1=1,4
      R2o(ip1)=R2(ip1)
    ENDDO
!
  ENDDO
!
!		      Looping to converge
!
  DO ip=1,2
    DO id=2,3
      DO i2=1,6
        RFLT(i2,id,ip)=RFLS(i2,id,ip)
        RFLT(i2,id,ip)=RFLS(i2,id,ip)
        mangle(i2,id,ip)=mangleT(i2,id,ip)
        mangle(i2,id,ip)=mangleT(i2,id,ip)
      ENDDO
    ENDDO
  ENDDO
  DO ip=1,2
    DO id=1,3
      DO i2=1,6    !ANGLE=THETA-DELTA
        IF (RFLT(i2,id,ip).EQ.0.D0) THEN
!o        WRITE(*,*) 'ip=',ip,' reflection too weak'
          mangle(i2,id,ip)=0.D0
        ELSE
          mangle(i2,id,ip)=-mangle(i2,id,ip)/RFLT(i2,id,ip)
        ENDIF
      ENDDO
    ENDDO
  ENDDO
  DO ip=1,2
    MAXRo(ip)=MAXR(ip)
  ENDDO
  IF (CYCLE.EQ.5.OR.CYCLE.EQ.0) THEN
    CLOSE(UNIT=1,STATUS='KEEP')
    CLOSE(UNIT=7,STATUS='KEEP')
  ENDIF
  RFL(3)=RFLT(1,1,1)
  RFL2(3)=RFLT(1,1,2)
!test	 WRITE(*,*) CYCLE,RANGE(1),DELJ(1),NINT(STEPS),NINT(c25j1)
!	1,NINT(c75j1),NINT(c25j2),NINT(c75j2)
!         WRITE(*,*) RFL(3),RFLo(1),RFL2(3),RFLo(2),MAXR(1),MAXR(2)
!	1,NINT(MAXJ(1)),NINT(MAXJ(2))
!t
  WRITE(*,2298) IDNINT(Range(1)),IDNINT(Range(2)),IDNINT(STEPS) &
      ,dtheta1j(1),dtheta1j(2),CYCLE,mangle(1,1,1),mangle(1,1,2) &
      ,RFL(3),RFL2(3)
2298 FORMAT(' RS1ri',2(I4),I8,2(1PE9.2),I2,2(1PE10.3),2(1PE9.2))
!
  IF (CYCLE.LE.1) THEN		! establish range, peak
    IF ((MAXJ(1).EQ.STEPS.OR.MAXJ(2).EQ.STEPS).AND.Rflag1.EQ.0 &
        )THEN				! not valid for grazing inc.
      CYCLE=1
      DO ip=1,2
        RANGE(ip)=RANGE(ip)*2.D0
        IF (RANGE(ip).GT.5400.) THEN
          RANGE(ip)=5400.
          CYCLE=2
        ENDIF
      ENDDO
      GOTO 2250
    ELSEIF (Rflag1.EQ.1) THEN
      DO ip=1,2
        DELJ(ip)=DELJ(ip)*2.D0+MAXJ(ip)*2.D0-STEPS
      ENDDO
      STEPS=STEPS*2.D0
!old			! not (c25j1+c75j1)/2... on first cycle
      CYCLE=2
      GOTO 2400
    ELSE
      DO ip=1,2
        DELJ(ip)=MAXJ(ip)+DELJ(ip)-STEPS/2.D0
      ENDDO
!old			! not (c25j1+c75j1)/2... on first cycle
      CYCLE=2
      GOTO 2400
    ENDIF
  ELSEIF(CYCLE.EQ.2) THEN		! improve range, fwhm
    IF((mkr(1).LT.1.OR.mkr(2).LT.1.OR.c25j1.EQ.0..OR. &
        c25j2.EQ.0.).AND.Rflag1.EQ.0) THEN
      DO ip=1,2
        RANGE(ip)=RANGE(ip)*2.D0
        IF (RANGE(ip).GT.5400.) THEN
          RANGE(ip)=5400.
          CYCLE=3
        ENDIF
      ENDDO
      DELJ(1)=DELJ(1)/2.D0-STEPS/2.D0+(c25j1+c75j1)/4.D0	!Centre peak
      DELJ(2)=DELJ(2)/2.D0-STEPS/2.D0+(c25j2+c75j2)/4.D0	!Centre peak
      GOTO 2400
    ELSE
      temrr=(c75j1-c25j1)*2.D2/STEPS	!fwhm == 1/200th of plot
      IF (temrr.LT.1..AND.c75j1.GT.1.) THEN
        temrr=DABS(c75j1-MAXJ(1))*2.D2/STEPS	! pk-c75 == 1/200th
      ELSEIF (temrr.LT.1.) THEN
        temrr=2.D0
      ENDIF
      RANGE(1)=RANGE(1)*temrr
      temrr2=(c75j2-c25j2)*2.D2/STEPS      !fwhm == 1/200th of plot
      IF (temrr2.LT.1..AND.c75j2.GT.1.) THEN
        temrr2=DABS(c75j2-MAXJ(2))*2.D2/STEPS ! pk-c75 == 1/200th
      ELSEIF (temrr2.LT.1.) THEN
        temrr2=2.D0
      ENDIF
      RANGE(2)=RANGE(2)*temrr2
      DO ip=1,2
        IF (RANGE(ip).GT.5400.) THEN
          RANGE(ip)=5400.
        ENDIF
      ENDDO
      IF (temrr2.EQ.2.D0.AND.mangle(1,1,1).GT.0.D0) THEN
        DELJ(1)=((c25j1+c75j1)/2.D0+DELJ(1))*RRAD(1) &
            /mangle(1,1,1)/STEPS-RRAD(1)*temrr/mangle(1,1,1)*5.D-1
        DELJ(2)=((c25j2+c75j2)/2.D0+DELJ(2))*RRAD(2) &
            /mangle(1,1,2)/STEPS-RRAD(2)*temrr2/mangle(1,1,2)*5.D-1
        STEPS=STEPS*2.D0
      ELSEIF (temrr2.EQ.2.D0) THEN
        DELJ(1)=((c25j1+c75j1)/2.D0+DELJ(1))*RRAD(1) &
            /mangle(1,1,1)/STEPS-STEPS/2.D0
        DELJ(2)=((c25j2+c75j2)/2.D0+DELJ(2))*RRAD(2) &
            /mangle(1,1,2)/STEPS-STEPS/2.D0
        STEPS=STEPS*2.D0
      ELSEIF (STEPS.LT.RRAD(2)*temrr2/mangle(1,1,2)*1.D2) THEN
        DELJ(1)=((c25j1+c75j1)/2.D0+DELJ(1))*RRAD(1)*1.D2 &
            /mangle(1,1,1)/STEPS-RRAD(1)*temrr/mangle(1,1,1)*5.D1
        DELJ(2)=((c25j2+c75j2)/2.D0+DELJ(2))*RRAD(2)*1.D2 &
            /mangle(1,1,2)/STEPS-RRAD(2)*temrr2/mangle(1,1,2)*5.D1
        STEPS=DFLOAT(IDINT(RRAD(2)*temrr2/mangle(1,1,2)*1.D2)+1)
      ELSE
        DELJ(1)=((c25j1+c75j1)/2.D0+DELJ(1))/temrr-STEPS/2.D0
        DELJ(2)=((c25j2+c75j2)/2.D0+DELJ(2))/temrr2-STEPS/2.D0
      ENDIF
      CYCLE=3
      GOTO 2400
    ENDIF
  ELSEIF(CYCLE.EQ.3) THEN
    IF ((DABS(mangle(1,1,2)-mangleo(2)).GT.toldifp &
        *DABS(mangle(1,1,2)).OR.DABS(mangle(1,1,1)-mangleo(1)).GT. &
        toldifp*DABS(mangle(1,1,1)).OR.DABS(mangle(1,2,1)-mango(1)) &
        .GT.toldifp*DABS(mangle(1,2,1)).OR. &
        DABS(mangle(1,2,2)-mango(2)).GT.toldifp*DABS(mangle(1,2,2)) &
        ).AND.(Igraz.LE.0.OR.RANGE(1).LT.900.)) THEN
!92		Refractive Index Precision cutoff:
      DELJ(1)=DELJ(1)*2.D0+(c25j1+c75j1)-STEPS
      DELJ(2)=DELJ(2)*2.D0+(c25j2+c75j2)-STEPS
      STEPS=STEPS*2.D0
!         Jbit=NINT(STEPS/399.D0)
      GOTO 2400
    ELSEIF ((DABS(RFLo(1)-RFL(3)).GT.toliifp*RFL(3).OR. &
        DABS(RFLo(2)-RFL2(3)).GT.toliifp*RFL2(3)) &
        .AND.RFL(3)+RFL2(3).GT.1.D-98 &
        .AND.(Igraz.LE.0.OR.STEPS.LT.1.D6.OR.RANGE(2).LT.900.)) THEN
!92		Integrated Reflectivity Precision cutoff:
      temrr=1.5D0
      temrr=DFLOAT(IDNINT(STEPS*temrr))/STEPS
      STEPS=DFLOAT(IDNINT(STEPS*temrr))
      RANGE(1)=RANGE(1)*temrr
      RANGE(2)=RANGE(2)*temrr
      DO ip=1,2
        IF (RANGE(ip).GT.5400.) THEN
          RANGE(ip)=5400.
        ENDIF
      ENDDO
      DELJ(1)=((c25j1+c75j1)/2.D0+DELJ(1))-STEPS/2.D0
      DELJ(2)=((c25j2+c75j2)/2.D0+DELJ(2))-STEPS/2.D0
      RFLo(1)=RFL(3)
      RFLo(2)=RFL2(3)
!        Jbit=NINT(STEPS/399.D0)
      GOTO 2400
    ELSE
      IF (Fwrite(Inext).EQ.Ilist.OR.ANS.GT.0) THEN            ! profiles
        RFLo(1)=RFL(3)
        RFLo(2)=RFL2(3)
        DELJ(1)=((c25j1+c75j1)/2.D0+DELJ(1))-STEPS/2.D0
        DELJ(2)=((c25j2+c75j2)/2.D0+DELJ(2))-STEPS/2.D0
        CYCLE=5
        FILEIN2='RSG.D'//numstr(2:4)
        OPEN (UNIT=1,FILE=dout//FILEIN2,STATUS='NEW')
        FILEIN2='RPI.D'//numstr(2:4)
        OPEN (UNIT=7,FILE=dout//FILEIN2,STATUS='NEW')
        R5=-1.D0
        R6=-1.D0
        Ibit=0
        Ibit1=0
        Inext=Inext+1
        Isum=Isum+1
        Iten=Isum/10
        numstr='S'//CHAR(48+Iten)//CHAR(48+Isum-Iten*10)//numstr(4:4)
        Jbit=MAX(IDNINT(STEPS/1999.D0),1)
        Jbit5=MAX(IDNINT((c75j1-c25j1)/4.D1),1)
        Jbit6=MAX(IDNINT((c75j2-c25j2)/4.D1),1)
        GOTO 2400
      ENDIF
    ENDIF
  ENDIF
  GOTO 2401
2400 mkr(1)=0
  mkr(2)=0
  DO ip=1,2
    DO id=2,3
      DO i2=1,3
        mkr3(i2,id,ip)=0
      ENDDO
    ENDDO
  ENDDO
  GOTO 2250
!
!		      Final Parameters
!
2401 DO ip=1,2
    RRAD(ip)=RANGE(ip)/10800.D0*DPI		! range in radians
  ENDDO
!urrent, versus earlier simple average of polarisations:
  mav=(mangle(1,1,1)*RFL(3)+mangle(1,1,2)*RFL2(3))/(RFL(3)+RFL2(3))
  RI1(3)=1.D0-ORDER/d2*dLambdanew/DSIN(Theta+mangle(1,1,1)+aplane)
  RI2(3)=1.D0-ORDER/d2*dLambdanew/DSIN(Theta+mangle(1,1,2)+aplane)
  RI3=1.D0-ORDER/d2*dLambdanew/DSIN(Theta+mav+aplane)
  DO ip=1,2
    DO id=1,3
      DO i2=1,3
        RIT(i2,id,ip)=1.D0-ORDER/d2*dLambdanew &
            /DSIN(Theta+mangle(i2,id,ip)+aplane)
        RIT(i2+3,id,ip)=1.D0-ORDER/d2*dLambdanew &
            /(DSIN(Theta+aplane)+mangle(i2+3,id,ip))
      ENDDO
    ENDDO
  ENDDO
  fwhm1=(c75j1-c25j1)*RRAD(1)/STEPS
  fwhm2=(c75j2-c25j2)*RRAD(2)/STEPS
  fwhm3=DMAX1(DABS(c75j2-c25j1),DABS(c75j1-c25j2))*RRAD(2)/STEPS
  IF (Rflag(1).EQ.0) THEN
    thpk1=THETA+RRAD(1)*(MAXJ(1)+DELJ(1))/STEPS-delth0
    thc251=THETA+RRAD(1)*(c25j1+DELJ(1))/STEPS-delth0
    thc751=THETA+RRAD(1)*(c75j1+DELJ(1))/STEPS-delth0
    thc11=THETA+RRAD(1)*DELJ(1)/STEPS-delth0
    thc21=THETA+RRAD(1)*(STEPS+DELJ(1))/STEPS-delth0
  ELSEIF (Rflag(1).EQ.-1) THEN
    thpk1=tolminang+aplane+RRAD(1)*MAXJ(1)/STEPS
    thc251=tolminang+aplane+RRAD(1)*c25j1/STEPS
    thc751=tolminang+aplane+RRAD(1)*c75j1/STEPS
    thc11=tolminang+aplane
    thc21=tolminang+aplane+RRAD(1)
  ELSE
    thpk1=DPIo2-RRAD(1)+RRAD(1)*MAXJ(1)/STEPS
    thc251=DPIo2-RRAD(1)+RRAD(1)*c25j1/STEPS
    thc751=DPIo2-RRAD(1)+RRAD(1)*c75j1/STEPS
    thc11=DPIo2-RRAD(1)
    thc21=DPIo2
  ENDIF
  IF (Rflag(2).EQ.0) THEN
    thpk2=THETA+RRAD(2)*(MAXJ(2)+DELJ(2))/STEPS-delth0
    thc252=THETA+RRAD(2)*(c25j2+DELJ(2))/STEPS-delth0
    thc752=THETA+RRAD(2)*(c75j2+DELJ(2))/STEPS-delth0
    thc12=THETA+RRAD(2)*DELJ(2)/STEPS-delth0
    thc22=THETA+RRAD(2)*(STEPS+DELJ(2))/STEPS-delth0
  ELSEIF (Rflag(2).EQ.-1) THEN
    thpk2=tolminang+aplane+RRAD(2)*MAXJ(2)/STEPS
    thc252=tolminang+aplane+RRAD(2)*c25j2/STEPS
    thc752=tolminang+aplane+RRAD(2)*c75j2/STEPS
    thc12=tolminang+aplane
    thc22=tolminang+aplane+RRAD(2)
  ELSE
    thpk2=DPIo2-RRAD(2)+RRAD(2)*MAXJ(2)/STEPS
    thc252=DPIo2-RRAD(2)+RRAD(2)*c25j2/STEPS
    thc752=DPIo2-RRAD(2)+RRAD(2)*c75j2/STEPS
    thc12=DPIo2-RRAD(2)
    thc22=DPIo2
  ENDIF
!
  WRITE(*,2500) RANGE(1),RANGE(2),IDNINT(STEPS),RRAD(1)/STEPS &
      ,DELJ(1),DELJ(2),1.D2*(1.D0-RFLo(1)/RFL(3)) &
      ,1.D2*(1.D0-RFLo(2)/RFL2(3)),R2(1),R2(2)
2500 FORMAT(' Range(min,s/p),STEPS,rad/STEP,' &
         ,'Theta shift(steps,s/p)=',/,1X,2(1PE9.2),I7,1PE9.2,2(1X,1PE13.6) &
         ,/,' Err(Int.Refls),last terms=',1PE8.1,'%,',1PE8.1,'%,' &
         ,2(1PE10.3))
  WRITE(*,2501) THETA*1.8D2/DPI,THETA
2501 FORMAT(X,'Output scale: 1E+6; Theta (Bragg,degs,R) = ',2F11.8)
  WRITE(*,2502) thc11,thc21,thc12,thc22
2502 FORMAT(X,'1st,last angles(rad;sig,pi)= ',4F11.8)
  WRITE(*,2503) fwhm1,fwhm2,fwhm3
2503 FORMAT(' fwhm(sig,pi,1:1 output I;rad)=',3(1PE13.6))
  WRITE(*,2504) MAXR(1),MAXR(2)
2504 FORMAT(' peak reflectivities (sig,pi) =',2(1PE13.6))
  WRITE(*,2506) NINT(MAXJ(1)),NINT(MAXJ(2)),thpk1,thpk2
2506 FORMAT(X,'pk channels,angles(Rad)=',2I7,2(1PE13.6))
  WRITE(*,2508) thc251,thc751,thc252,thc752
2508 FORMAT(X,'c25,c75 angles(Rad)=',4(1PE13.6))
  WRITE(*,2510) RFL(3),RFL2(3),RFL(3)+RFL2(3)
2510 FORMAT(' Integr.Refl.dthB(sig,pi,s+p)=',3(1PE13.6))
  WRITE(*,2512) mangle(1,1,1),mangle(1,1,2),mav
2512 FORMAT(' Mean DELTH(sig,pi,inc.s+p;rad w.aplane)=',3(1PE13.6))
  WRITE(*,2515) mangle(1,2,1),mangle(1,2,2),mangle(1,3,1) &
      ,mangle(1,3,2)
2515 FORMAT(' DTH(s,p);2/3 decade range=',4(1PE13.6))
  WRITE(*,2520) RI1(3),RI2(3),RI3
2520 FORMAT(' RI=(1-del)*(2d/nl)**2=1-nl/(2dsinTh)', &
         3(1PE14.7))
  WRITE(*,2530) RIT(1,2,1),RIT(1,2,2),RIT(1,3,1),RIT(1,3,2)
2530 FORMAT(' RI(s,p); 2/3 decade range=',4(1PE13.6))
  WRITE(*,2540)
2540 FORMAT(' DTH(2crystal ndisp/disp),DsinTH(1c/2cryst ndisp/disp)' &
         ,'(full/2/3);' &
         ,/,6X,'RFL(sig,pi),',10X,'mdelta(sig,pi),',11X,'RI(sig,pi)')
  DO i2=2,6
    DO id=1,3
      WRITE(*,2550) AN(id),RFLT(i2,id,1),RFLT(i2,id,2),mangle(i2,id,1) &
          ,mangle(i2,id,2),RIT(i2,id,1),RIT(i2,id,2)
    ENDDO
  ENDDO
2550 FORMAT(1X,A2,2(1PE12.5),1X,2(1PE13.6),1X,2(1PE13.6))
  RETURN
END
!-------------------------------------------------------------------------
!			FPS/FTN77 INTERFACE FUNCTION
!      FUNCTION SECNDS(TIM1)
!      LOGICAL OLDEN
!      INTEGER SYS$GETTIME
!C
!C     ----- ROUTINE TO GET THE CPU TIME FOR FPS164 -----
!C
!      DATA OLDEN/.FALSE./
!C
!      IF(OLDEN) GO TO 100
!      OLDEN = .TRUE.
!C
!C     ----- INITIALISATION OF THE TIME -----
!C
!      CPUINI = 0.0E0
!      WORLDI = 0.0E0
!      CPUTIM = 0.0E0
!      WORLDT = 0.0E0
!C
!      IDUM = SYS$GETTIME(CPUINI,WORLDI)
!  100 CONTINUE
!C
!C     ----- GET THE ACCUMULATED TIMINGS -----
!C
!      IDUM = SYS$GETTIME(CPUTIM,WORLDT)
!      CPUTIM = CPUTIM-CPUINI
!      WORLDT = WORLDT-WORLDI
!      SECNDS=CPUTIM-TIM1
!      RETURN
!      END
!--------------------------------------------------------------------------
