!		Moscurve3				02 Jun 1992	C. T. Chantler
!             					09 Sep 1992
!								30 Apr 1993
!L				(Laue3)			18 Aug 1993
!B								   Sep 1993
!MAC			Mac				8  Mar 1995
!5								8  Nov 1995
!93atest Vax/Thesis/Mac/Unix	1  Jan 1996
!U95  changes by David Paterson Dec95-Jan96 to run on UNIX
!U96  changes by David Paterson Dec95-Jan96 to run on UNIX
!UJun96 Mods to rationalise output / ADP/PET tests: Jun 96
!plate96 mods to include platefunction DJP 1996
!out97  mods to output including flags and full output files 
!
!	[First Edition: C. T. Chantler	27 September 1988	= Moscurve]
!	Program to calculate the rocking curve for a crystal.
!	PET,KAP,Si,ADP,a-Quartz, data-input crystals (Ge,KDP,RAP,LiF...),
!       pseudo- simple cubic elemental crystals, or user-input form factors
!       may be used to calculate profiles, widths, reflectivities, shifts,
!       mosaicity, ... for infinite/finite, flat/curved, perfect/non-ideally
!       imperfect crystals. Can be updated to other crystals with data files.
!---------------------------------------------------------------------------
!	Components herein: Moscurve3,get_lattice,bodge_lattice
!---------------------------------------------------------------------------
!	2-beam dynamical diffraction theory is assumed, except for 000.
!	A subroutine THREEBM (3-beam) is able to indicate regions where this
!	is likely to give significant/gross errors or asymmetry.
!	Additional (general) locations of this sort include:
!	 (i) forbidden reflections, where off-resonance multiple beams
!	of many planes contribute to the reflectivity and asymmetry;
!	 (ii) far tails of diffraction peaks, where the sphericity of the
!	diffracting surface dominates and multiple beam interference is
!	intrinsic (not included herein); and
!	 (iii) near grazing incidence and the critical angle, where
!	Fresnel coefficients corresponding to (000) diffraction dominate,
!	corresponding to alternate 3-beam cases and/or failure of other
!	assumptions. The Fresnel reflection coefficient is now approximated.
!	 (i-iii) are often averaged over or avoided for curved crystals
!	where peak behaviour is of primary concern.
!----------------------------------------------------------------------------
!L			Compilation for Laue3:
!L	Linking with LaueFF.OBJ (double precision G-floating format),
!L	     Laue5.OBJ, LaueFFM.OBJ, inclusion of FFCOM.FOR,
!			Compilation for Moscurve3:
!	Linking with FFSUPP.OBJ (double precision G-floating format),
!	     CS5.OBJ, THREEBM.OBJ, BRAGGFFM.OBJ, inclusion of FFCOM.FOR,
!	VAX Data from RDDEx.C1,.C2,.D1-.D9; *.CLAT; [.HenPC]*.ASC;
!	     absorption$data==absorption.dat;
!	     abs$raycomp_data==abs$raycomp.dat;
!	     and abs$sfcoef_data==abs$sfcoef.dat.
!M      Mac Data: (DATA.CTCMPW.)DATA.RDDEx.C1-.D9;*.CLAT; MPWFTN.HenPC.*.ASC;
!	     MPWFTN.absorption.dat; abs$raycomp.dat; and abs$sfcoef.dat.
!	Transfer files: ABSFDP.DAT, ABSF0.DAT, ABSSCAT.DAT
!	Decompression, recompression: FFTRANS.FOR, FFCOMPRESS.f(or)
!----------------------------------------------------------------------------
!			Updates / Modifications:
!		       ..........................
!5      8 November 1995. Native MPW environment, update of LS Ftn.
!               Change to makefiles re xcoff and shared libraries.
!       Revisiting thesis (88/89) computations.
!       Data files allow >10A wavelengths by remormatting 7...+/- to _7...+-
!               Old runs lacked many checks / intermediate parameters.
!               Current 1st order higher by 2mu (ADP), 6mu? (PET),
!               PET high precision 1st order mosaic (w,w/o Fresnel) =garbage,
!       current 4th order lower by 23-24mu (ADP), 36mu (Lyb), 16-22mu (PET),
!               current 5th order lower by 25-31mu (ADP), 10-20mu (PET).
!       Major changes NOT affecting results: Iffsource=3 (CLC), beta=.136/0,
!               prec=0/3 (old was better than 0, faster than 3), mosaicity,
!               maxdp/m=12mm, or even Fresnel inclusion.
!       However, Fresnel inclusion may lead to r+t>1 for grazing angles
!       ((ADP,PET) C,x,... r=0.98, t=0.15 near critical angle STEPSF=3020).
!       Looping error / comment 980 loop, 981loop from ylayer-ysurf > Dymaxt
!       (overestimated number of layers or limited Dymaxt, PET Mos.+ prec=3?)
!               (commented out)
!               Check x-> xbdisp?, thetas -> thetas1?, mininc?
!       ifp, ffp close agreement with ADP / old but old curved computation had
!       significantly lower mean depth (Lyb) 60.5mu vs new 80.9mu, t0 = 4mu
!       vs 5.27mu, Dy0 = 18.4/5.8 vs new 22.8/8.3 SO Pk Refl (new) x2, fwhmx.8,
!       ffRC (new) x1.4, but curved (new) x0.6, RI: -4.5-4 -> -5.9-4 D.P.
!               but mufilm .004 -> .0375 so emulsion 8.4mu -> 2.2mu
!       (new range much larger but prec similar, ff F, Dtheta, RI consistent)
! PET = above conclusions but also FHr(4th/5th order, new)  = FHr (old) / 1.9,
!               FHi = FHi / 2.5. No obvious reason / basis for this error?
!               emulsion = same result? g: -0.63 -> -1.16.
!               Pk Refl^2 or x .5 (not ADP 2); Int.Refl. x0.5...
!

!M	3 April 1995. Square source option (negative values), optimising
!		STEPS1/2 for broad sources, and testing
!		alignment -1 with offsets for alphas??
!		meanxxp,DelthL,Thetas1,Thsrange,MShiftB(6)
!M	31 March 1995	Maxdel -> maxdp=maxdm or otherwise
!M	8 March 1995. Macintosh adaptation and modifications
!		See MPW Worksheet and PPC mods. IF Loop in Threebm. ERRSNS.
!		+	Compile/Link/Run(Apps only)/File locns.
!		VAX:[CHANTLER.CMOS] => DATA:CTCMPW:MacFtn or Fortran
!			[CHANTLER.HENPC] => ::HENPC:
!			local ff/lattice data => ::DATA:
!			local inputs (command files, Scripts or dat files) => ::Comfiles:
!			local outputs (.out,...=>[.RESULTS]) => ::FResults:
!		log output to ROOT => local/redirected tools or window???
!		Also absorption,...,.dat and FFCOMPRESS consistency (recl=32)
!		g<0 in user-defined option. siginc/sigscat in same section.
!		dlambdadmu for safety.
!		CS5A (13 Jul 1994) commenting out of cutoffs from extremes
!		i/o Mac File labels (especially for Applications)
!		Problem with /clockt/ Time2... evaluation(PPC compiler).
!MACtest	Test lines for compatibility.
!B	Sept 1993	Integrated with Bragg option and renamed to Moscurve3
!B      Ideal Bragg aplane=0
!L	18 Aug 1993     Laue3		GENSECT
!L		Ideal Laue aplane=dpio2; LOCAL Mininc (Min thinc) =0.
!93	30 APR 93 proposed modifications (proposed prior JUN 92; C93):
!		o) Laue (flat) crystal diffraction routine.
!		oo) Restructure input section to request required
!		 variables only and not irrelevant ones; and to avoid
!		 duplication of variables.
!		i) Further? AJV mods testing / replacement in fcm routine:
!		 Geometry/on-circle Johann/flat detector and source
!		 distribution (cf. Moscurvar/ A. J. Varney;
!		 both incomplete, currently).
!		ii) Extension to double-crystal instruments
!		 (flat-flat; curved-curved?; Laue-Laue? Different crystals?).
!		iii) Removal of secondary approximations (thesis/articles):
!		 (curved crystallite; coherence of wavefield?).
!		iv) Removal of redundant variables/common blocks.
!		v) Other Extensions: Curved asymptotic dispersion surface;
!		 Inclusion of surface (Fresnel) reflection (vi),
!		 Laue diffraction et al. (cf. Taupin-Takagi equations);
!		 Transmission interference fan;
!		 Amplitude propagation vs Intensity truncation (w. A. Caticha?);
!		 and/or alternate formulations (Darwin,Kinematic: (vi)).
!		vi) JUL 93 Fresnel Alternatives and possible extensions:
!			A) Previous default: no Fresnel / H=0 coeff.
!		(always required in 0-90deg region on low side of peak);
!			B) Current default: ifp amplitude bodge,
!		ffm phase and amp. Fresnel 2-bm approxn.
!		(ifp neglects phase in mid-tail; ffm neglects other peaks
!		in multiple-tail diffraction; transmission correction
!		neglected; second interface t_F2 and t_F on r_A neglected:
!		results in factor 2 errors in (broad) tail region);
!			C) Replacing ifp, ffm with AC's detailed Laue solution.
!		(n.a. for ifp; only for 'semi-infinite', symmetric Bragg,
!		TE (sigma poln), reflectivity. Could be extended.
!		Still neglects other peaks 0-90deg.);
!			D) Use of AC's Darwin diffraction model.
!		Explicit inclusion of -1-1-1 ... 555 orders.
!		(Not designed to deal with asymmetric diffraction of any kind.
!		Very efficient (only) for symmetric Bragg diffn and multiple
!		orders of same primitive vector, normal to surface.)
!		vii) consideration of asymmetry and extent of tails?
!		viii) amplitude and phase propagation?
!		ix) explicit inclusion of lateral defocusing / shifts
!		 in ray tracing??
!		x) Effect of stress ... cf. vi), 30 APR 93 ...
!		 Major consideration of anticlastic curvature and
!		 elasticity effects, with 2d variation: AIM is to
!		 implement or estimate the significance of this.
!		 CASES: 1) Mosaic v Perfect crystals;
!			2) Perfect cylinder vs 4-bar vs spherical vs thermal
!			 vs impressed vs 4-point, 2-bar vs triangular... ;
!			3) Introduction of phi, angle of H to Gx
!			 (previously assumed =0);
!			4) Specific elasticity coefficients for crystal planes;
!			5) Change of local reflectivity and direction required.
!			6) Current implementation: planes at constant aplane
!			 to Neutral Surface, local curvature = impressed
!			 curvature, no 2d variation from flat crystal.
!93      6 JUL 93 modifications, for comparison to grazing incidence data:
!		i) OPT=9 Elemental simple cubic crystal bodge Z=(1,2,)3-92;
!		ii) Minimum angle restriction reduced below thetaCrit;
!		iii) Initial search location either min. angle or thetaB;
!		iv) Grazing incidence modifications to convergence criteria;
!		v) Fresnel coefficients: following AC Eqns 2.8-2.9;
!		 ONLY VALID FOR 2-bm Laue: neglect of lower or higher
!		 orders for tails (e.g. 444 requires 333, 555 for tails,
!		 001 requires 000, 002, 00-1 for tails; Si 111 at Cu Ka
!		 (16deg) requires -1-1-1,000,222,333,444,555 from 0-90deg);
!		 neglect of order chi2;
!		 non-magnetic materials, of course; neglect of transmission
!		 correction of r_a or t_a;
!		vi) Phase and amplitude matching: ffm appears good, smooth,
!		 correct sign? ifp has no phase info. hence fails in middle
!		 of tail region.
!		vii) Correction of second crystal reflectivity
!		 in braggifp. Now consistent with detector scan at peak (P)
!		 or near optimum (peak/mean) crystal alignment (AP).
!		viii) Correction of basym in ifp crystal; allowance for
!		 AC definition, but this fails in the tails (where it is
!		 intended to be valid and explicitly designed for...?).
!		ix) NOTE POLARISATION FACTOR: |cos2theta|: what is theta?
!		 Fresnel coefficient theta is (must be) the grazing
!		 angle of incidence to the crystal surface. Hence the
!		 Fresnel component must vanish at 45degrees to the surface.
!		 This can define a TM mode (M component normal to the p.o.i.).
!		x) Polarisation factor for Bragg reflection: |cos2theta|:
!		 NOT thetaB (old) or thetainc or thetadiff (or thetaB+RI) as
!		 given in literature.
!		 ACTUALLY cos(thetaD+thetaoutD)=(1-2.sinthD.sinthB)
!		  / DSQRT(1+4sinthB(sinthB-sinthD))
!		 NOTE thetaD is the diff.angle INSIDE THE CRYSTAL
!		 (post-refraction). I have generally neglected thD'-thD herein.
!		xi) IFP has no transmission. R_F pseudo-coherent (phase lost).
!		 ffm includes T_F, R_F unless preparing for fcp. Phase included.
!		 fcp treats R_F, T_F as (incoherent) layer=0.
!93      30 APR 93 modifications, for comparison to Fe, Ge data and articles:
!		i) Option for thetaaxis specification instead of BD(cosmetic).
!		ii) temul, emultype option. Update of attenuation coef.in film.
!		iii) Reorganisation of .out, .oty et al. output:
!		 IR of double soln should be summed; RI o/p should be weighted;
!		 FFRC,RPI,RSG only VL=1; RPP,RPL VL=1,2 solns as appropriate;
!		 FFRC,RSG,RPI,RPP/Ltho channel o/p update;
!		 RPP/Lth1,yo mean bin o/p update.
!		iv) d labels and output file specification in comments
!		 and log file, and update of examples (cosmetic).
!		v) allowance for beta and/or theta scanning (dbetaread).
!		vi) Major consideration of anticlastic curvature begun.
!92-93   09 SEP 92 through 25 MAR 93 modifications (C92/C93):
!		i) Separation of output routines in Moscurve3 into
!		 subroutine OUTFILS of CS5/whatever; in Braggffm.
!*		 RI ffp,ifp calcns for c1,c0.1,full on theta (vs) sinth scales;
!		 and for ifp dispersive/non-dispersive double crystal modes.
!		ii) Development of Mshift1-7... files for comparemeasures
!		 (THREEBM) with associated formulae: estimates of component
!		 effects (RI, prof a/s, depth penetration, mean diffracting
!		 angle, mean output angle to surface, lateral shifts
!		 on depth penetration, lateral et al. off-axis shifts,
!		 finite crystal and source contributions, emulsion shifts)
!		 versus computed results.
!		iii) Generalisation to source point ON-Rowland Circle
!		 geometry vis a vis AJV; redefinition of XXC/XXP (CS5)
!		 as arc-length (for crystal limit comparison, and
!		 limitation) versus earlier chord-length
!		 (used for ray tracing in approximate off-circle case).
!		iv) Introduction of GENXYS to simplify Yiz ray tracing;
!		 correction of Sector 3 error / inconsistency therein;
!		 also a preparation for AJV detector relations.
!		v) Completion of VL=2 solutions and output, with
!		 reorganised layout of log file summary; n.b. possible
!		 Sector 4 inconsistency (but who cares?).
!92     02 JUN 92 modifications (C92):
!		i) Removal of geometric approximation (thesis/articles).
!		ii) Correction (partial or complete?) for confluence of
!		 aplane.NE.0 (asymmetric Bragg - or Laue?) with
!		 dalpha.NE.0 (angle of incidence wrt Generatrix) for
!		 curved crystal propagation/geometry (modular).
!		iii) Generalisation to all Bragg sectors and allowance
!		 for double angle matching, Bragg angles greater than normal
!		 (i.e. imaginary).
!		iv) Mods of THREEBM, BRAGGFFM looping and convergence
!		 structure for curved crystal computation;
!		 ffp calculation convergence was updated dramatically,
!		 earlier (the code is probably OK for either case, now);
!		 ifp computation was also rewritten and agreement of
!		 convergence of both routes confirmed for thick crystals.
!		 This is qualitatively different from earlier ifp routine
!		 which was 'intentionally wrong' following Caciuffo et al.,
!		 for 'comparison' to ffp,fcp improvement.
!		v) Inclusion of AJV subroutines and (much) modified
!		 code and explicit comments regarding validity thereof;
!		 with extension to GENGEOMC,GENGEOMS,GENTHS... routines.
!92	18 MAY 92 modifications:
!		i) Update of form factor interpolation code ffsupp (COMINT)
!		 and adjustment of 'optimum' ff choice.
!		 Choice lies between Henke82+, Henke88, CL83, CLC92.
!		ii) Compatibility update with ffcompare.
!		iii) local/non-local/Vax use flag.
!               iv) Separation of ffp, ffm routine, redefinition of
!		 AGE=0, AGE=1; auxiliary variables for thermal parameters
!		 and general functions.
!		v) Development of Ifeff options (COMPAREMEASURES and THREEBM).
!91	28 OCT 91 extensions (C91):
!		i) Precision constants (dpi,dln2,re0,hckeV,Na11,mec2,dpio2)
!		ii) Modularity, esp. crystal structures, form factors
!		iii) Development of theor/exptal form factor data base
!		 cf. P.Cowan, S.Brennan (NIST/SSRL)/XDF,DN4.for:
!		 READ ffcompare.tex (summary of observations ...)
!		iv) Appendices of three command file examples
!               v) Mac - like extensions/compatibility (LS fortran/MPW):
!		  CLOSE(... STATUS='KEEP'); (NOT 'SAVE')
!		  USE of DOUBLE PRECISION (NOT real*4,real*8)(no longer real)
!		  AVOID print* statements and unit numbers 5,6,9
!		  IMac switch for recl=VAX*4, path searching
!		Note location of i/o files; problem of space allocation;
!		 application (stand-alone) versus tool (batch) designation.
!		 MacIIci(25MHz) is 11x speed of (batch) muVaxII, 2.5-3.0x
!		 (interactive) muVaxII, 0.6x Oxford VAX8700 (single-user),
!		 1.5x IBM 386SX (20MHz), 0.44x IBM 486 (33MHz),
!		 0.3?x Quadra 700 (25MHz), 0.15?x 1992 optimum workstations.
!		vi) LOG, FETEST output reformatted, GB(8) (re)introduced
!		vii) Comparison to semi-empirical forms for systematic
!		 shifts, integrated reflectivities, fwhm estimates
!		viii) Separation of ifp,ffm routines
!V	01 DEC 90 MOSCURVAR
!	   	edits for flat (MCP) detector,
!		parameters for Ni Lyman alpha experiment:
!		2Rz==1m {GB(1)==10000000.}, maxdel==6mm {0.6D+5}->maxdp,maxdm,
!		BD,BX {GB vars} (2/91)
!V		edits for exact (general) geometry, etc. 2/91
!	07 AUG 90 MH MK ML reinstated for ifp calculations
!	14 MAR 90 version with ADP coordinate choice
!		x,x2 arrays declared explicitly; FHi,FHr C*16
!		cc1 calculation more robust; LENGTH check
!		Iast3/Numcells/fscale/dalpha correct precision
!		ITEST looping modified for convex?
!		High/Low precision versions with Iprecs
!		Avoiding file 5/6 o/p (convex)
!	23 FEB 90 MODIFIED FOR VAXFTN (function statements commented out)
!	Version requiring /NOSTANDARD compilation option only on FPS/FTN77
!	 (! in-line comments) (reduced ffrc, I/Yrel arrays - ffs=9100,2001)
!	 + o/p 519==595,1350 and STEPS2,1 order limits updated
!	4th order upper steps1 limits; improved atomic positions;
!	 form factor, atomic site tests (2Rz, Rzf, Cx, maxdel tests).
!	15 FEB 90 FPS/FTN77 Version
!	  NB: DREAL,CDEXP,DIMAG,DCMPLX,CDSQRT Complex*16 intrinsic fns
!	  are unsupported, but for FPS are equivalent to REAL,DEXP,AIMAG,
!	  CMPLX,DSQRT as given as statement functions in MAIN and CS5
!		SECNDS=> SYS$GETTIME routine?
!	CTC 28.DEC.1989 - improved mosaic precision
!	First edition: CTC	27 SEPTEMBER 1988
!
!----------------------------------------------------------------------7------
!			Diffraction Theory.
! Results are based on the 2-beam dynamical theory of Xray diffraction:
!	q.v. Thesis (University of Oxford, 1991) for details, and/or
! (Batterman & Cole, Rev. Mod. Phys. 1964 (complete with errors) (B);
!  R.Caciuffo et al., Phys.Rep.152(1987)1-71 (errors in signs of 'b') (C);
!  A.Burek Space Sci.Inst.2(1976)53-104 (with many corrections!); Burek
!  R.W.James/Solid State Physics 15 (1963)53-220, Slater (J); (?)
!  W.H.Zachariasen, Theory of X-ray Diffn in Crystals,(1945)(Z)(approxns);
!  S.Kikuta,K.Kohra, J.Phys.Soc.Japan 29(1970)1322-1328 (K);
!  P.B.Hirsch,G.N.Ramachandran, Acta Cryst.3(1950)187 (H);
!  Cole,Stemple, J.Appl.Phys.33(1962)2227-2233 (C&S) CORRECT:
!	(inc.inv.centre=> PSIHr,i complex);
!  J.M.Laming thesis & earlier programme (JML); ....)
!  In general PSIHi,r are both complex (when (H.rj).not.=2.pi.n);
!	JML et al. have confused/neglected this (esp. Si111!).
!  JML had not included the effect of thermal vibration.
!  KAP contains no inversion centre (Okaya,Acta Cryst.19(1965)879
!   so the imaginary components of PSIHr,i should be accounted for in
!   general (but not in the case 002n, given). Quartz requires this too!
!
!  (K) defines an asymmetry parameter b; we follow (C&S,H) in using
!	 b=-sin(thetaB-alpha)/sin(thetaB+alpha)=-b (K) where alpha=angle
!	from the Bragg planes to the crystal surface on the incident side
!	of the plane of incidence; wrt which the principal equations
!	(cf G(eta=Gr H) Batterman 715 == L Caciuffo 49,simp. of C&S) have
!	y=((1-b)/2*PSI0r/|PSIHr|-b(TH0-thetaB)sin(2thetaB))/(Csqrt(|b|))
!	=(g0/gh DELTA sin(2thetaB)+.5PSI0(1-g0/gh))/(|C|sqrt(g0/gh)|PSIH|)
!	g=(1-b)PSI0i/PSIHr/(2Csqrt(|b|))
!	In our case (Bragg planes parallel to surface) b=-1
!	 TH0 = inc. angle to Bragg planes = thetaB+DELTA
!	 and C=poln factor = 1 (electric vector E perp. inc. plane (pi))
!			   = cos2thetaB (parallel, sig.)
!  Two qualitative additions are the bending of the crystal and increased
!	 mosaic character; (C) treats one explicitly and the other
!	 accidentally. Updated formulae combine with the Rowland circle
!	 geometry to give METHOD 2 (using AGE=2).
!
!  Error testing of the procedure follows from (i) ifp (infinite,flat,
!	 perfect) calcns with AGE=0 (corrected,complex,w,w/o inv.centre);
!	 (ii) ffp (finite,f,p) profiles FFRC, AGE=1/MOSDEL=0.;
!	 (iii) ffp (finite,f,p) profiles FFRC, AGE=2/MOSDEL=0.;
!	 (iv) ffi (f,f,imperfect) profiles FFRC, AGE=2/MOSDEL='1.';
!	 (v) fcp (f,curved,p) profiles RPP,RPL, AGE=2/MOSDEL=0.;
!	 (vi) fci (f,c,i) profiles RPP,RPL (th1,tho,yo), AGE=2/MOSDEL='1.';
!	plus FELIN.OUTa,.OTYa and *.LOG results; plus
!	 (vii) AGE=3/MOSDEL=0. focussing/geometry test (maxlayer=1.);
!	 (viii) AGE=4/MOSDEL=0. comparison to C and ifp calcns - xbdisp=0;
!	 (ix) AGE=5/MOSDEL=0. maxl=1,xbdisp=0: focussing/interpolation; and
!	finally (x) checking of Tmax due to absn, t0,dt0 (crystallites),
!	and the dbar estimation.AGE=0 uses common vars but a diff. formula.
!	FFRC IS the profile used in the curved calculations.
!----------------------------------------------------------------------
!   FORM FACTOR / ATTENUATION databases:
!	cf. FFCOMPARE.TEX, .FOR, subroutine FORMF et seq.
!----------------------------------------------------------------------
!   TEMPERATURE FACTORS from crystallographic articles.
!	F=F'exp(-h(i)h(j)Beta(i,j)) where h(1,2,3)=h,k,l
!	For e.g. KAP00n, Beta33=.0030-4 at room temp.; this temp~ours
!91 Bren/Cowan (NIST, XDF/DN4.FOR) use isotropic mean 'crystal' Debye T
!    but include allowance for temp. varn of this and linear expansion.
!   However, variation of B,beta with direction is a factor of 3,
!    varn with atom type is e.g. (4-8) for K vs 0.2 for C in e.g. KAP/KDP,
!    while varn by dT=30K gives only 2.2% (high Debye T, e.g. C)
!    or est. 5-10% (low, e.g. K). Expressions for the latter are
!    approx. valid for cubic lattices with single atom types only,
!    but can give first order corrections for other lattices noting
!    that each independent site and axis will have different Debye T's.
!   Debye models can give errors of 27% as T:293->90K (Li),
!    linear extrapolations are accurate to 5-10% for simple systems
!    (monatomic solids, binaries) with 30K<T_D<700K (i.e. not Be,B,C)
!    the literature does not normally provide B_0 (\simeq 0.05-0.35),
!    the relation is approx. quadratic for T/T_D<0.2 (often T<100K),
!    and approx. linear for T>0.5 (with intercept \simeq 30% B_0).
!    Models improved upon Debye's yield 20% errors at room T(Sea)
!    (Sears+,Acta Cryst A47(1991)441-446). Debye Temps:
!    645(Bren/Cohen), 505-658(IntTabXRC), 545(A.Caticha), 761(Sea).
!   This thermal correction is then important only for e.g. precision
!    calcns of Si/Ge, where other dominant effects cancel.
!  IMPLEMENTED: a linear interpolation, typically valid to 5-10%
!    over T/2,T*2, and (almost) as good as more complicated est's,
!    but in any case providing an upper limit to the change of B
!    with temperature. For Be,B,(C,Si)(diamond) a constant B is closer.
!    Linear expansion estimates will often fail beyond these ranges.
!   Variation with order of reflection is at the 10% level, due to
!    thermal parameters of valence vs core vibrations:
!    Bexp_293(1988)=.45(2);.463(4)(Deutsch,Hart,<=888);.509(4)(>101010)
!
!----------------------------------------------------------------------
!  Theoretical Note: The model is NOT composed of layers of mean
!	crystallites with gaussian angular spread (unless mosdel>0) NOR of
!	a mean of a set of blocks projecting from the surface of into the
!	surface (the surface is assumed atomically perfect) NOR of the mean
!	of such a set with half-blocks and sub-blocks filling to the surface
!	(absn too great and r1/2,t1/2 do not follow simple scaling, and dely0
!	model unit destroyed) BUT of a single uniform crystal with a mean
!	depth penetration, transmission and reflectivity given from absn and
!	component reflectivities at diff. levels in the crystallite. Apart
!	from dely0<>2., this differs greatly from C. Note also that the
!	crystallite is assumed curved to the appropriate radius, with
!	diffraction effects from crystallite to crystallite neglected for
!	outgoing rays, but with variation of theta and r within the
!	crystallite being taken into account (to first order).
!
!----------------------------------------------------------------------
!  References:
!	Bad Refs from Burek, f'S FROM HENKE, INTERNAT.TABS V4.99
!	AH=Aldred,PJE,Hart,M.,Proc.R.Soc.London Ser.A332(1973)223-238
!	B=Burek; C=Caciuffo; L=LBL Data Booklet 5-1/J.H.Underwood, from
!	 E.P.Bertin in J.W.Robinson,Ed.,CRC Handbook of Spectroscopy
!	 (1974)p238;
!	BH=Bearden,A.J.,Huffman,F.N.,Rev.Sci.Inst.34(1963)1233;
!	D=D'Amour,H.,Denner,D.,Schulz,H.,Acta Cryst.B35(1979)550-5
!	E=Eilerman,D.,Rudman,R.,Acta Cryst.B35(1979)2458-2460
!	F=Frolov,A.P.,Vereshchagin,L.F.,Rodionov,Soviet Physics-Solid
!	 State 4(1962)1178-82
!	H=Hendrey,G.L., Langford,J.I., X-ray Spectrom.3(1974)133
!	R=Ray Hall, DPhil Thesis,Univ.Leicester(1980)
!	LP=Le Page,Donnay, Acta Cryst.B32(1976)2456-9
!	K=Khan,A.A.,Baur,W.H.,Acta Cryst.B29(1973)2721-5 + Baur,W.H. ''2726-31
!	O=Okaya,Y.,Acta Cryst.19(1965)879
!	S=Smith,R.A.,Acta Cryst.B31(1975)2347
!91	Se=Semmingsen, D.,Acta Chem.Scand.A42(1988)279-83
!	W=P-H Wei, Z.Kristallogr. (A)92 (1935)355
!-----------------------------------------------------------------------
!  Structures: lattice spacings (2d) & atomic positions(S):
!	OHS, Octadecyl hydrogen succinate (??) 2d~97 CH3(CH2)17OOC-CH2CH2COOH
!	 - L
!	OHM, Octadecyl hydrogen maleate (??) 2d~63.5 CH3(CH2)17OOC-CH:CHCOOH
!	 - L; 2d~96(B)
!	KAP=KHP, Potassium hydrogen (acid) phthallate (100) 2d=26.632 KHC8H4O4
!	 - L; 2d=26.5790(B=BH); 2d=27.70(14),S(O)
!	RAP=RHP, Rubidium hydrogen phthallate (100) 2d=26.121; R=4-8*R(KAP)
!	 - L,B; P2(sub1)ab,a=6.561(1),b=10.064(2),c=13.068(2) (S)
!	TlAP=TlHP, Thallium hydrogen phthallate (100) 2d=25.9
!	 - L; 2d=25.7567(B=H)
!	Mica,muscovite (002) 2d=19.84; K20.3Al2O3.6SiO2.2H2O (L,B)
!	 - BUT GARBAGE!!! - 2d varies among specimens
!	Beryl,golden(10-10) 2d~15.954 but varies among specimens (L)
!	SHA, Sorbitol hexaacetate (110) CH3COCHOH-(COH-COCH3)4-CHOHCOCH3
!	 2d=13.98(L,B)
!	ADP, Ammonium dihydrogen phosphate NH4H2PO4 (101) 2d=10.640;
!	 wk cf PET,EDDT (L); 2d=10.648(B) 'R<R(EDDT), long-term stability of
!	 solution-polished crystals?, piezoelectric' S=I-42d(B,K);
!	 a=7.502,c=7.546(Bref)=> 2d=10.6404;
!	 a=7.4997(4),c=7.5494(12)=> 2d=10.6411 (K)
!	EDDT, Ethylenediamine-d-tartrate ring(NH2-CH2-CH2-NH2-COOH-(CHOH)2-COOH)
!	 (020) 2d=8.808(L,B) 'Rugged & stable'
!	PET, Pentaerythritol C(CH2OH)4 (002) 'deteriorates with age & xrays,
!	 soft,store in desiccator, R~2*R(EDDT)~2.5*KAP' 2d=8.742(L,B);
!	 2d=8.757,S(E); 2d=8.7358(18degs)(R); a=6.10,c=8.73(1)(F)
!	 a=b=6.079(3),c=8.745(4),S(Se)
!	alpha-Quartz, SiO2 (10-10) R<R(EDDT) 2d=8.512(L);=8.350(B=W,'53);
!	 S=P3(sub1,2)21 (B),P3(sub1)2 2d=8.5096(C);
!	 a=4.90,c=5.39,C3(sub2)2(W);
!	 a=4.921(1),c=5.400(4)=> 2d=8.5234,S=P3(sub2=1)21 (D);
!	 a=4.9134,c=5.4052=> 2d=8.5103,S=P3(sub2=1)21 (LP)
!	ADP (200) 2d=7.5 R>R(EDDT) (L); 2d=7.50(B)
!	alpha-Quartz, (10-11) R(EDDT)<R<R(PET) 2d=6.687(L);=6.592(B=old,'53)
!	Germanium, Ge (111) 2d=6.532(L);=6.545(B)
!	Silicon, Si (111) 2d=6.271(L);=6.284(B);a=5.43044(AH) S=I-4d(B),Fd3m(C)
!		Deslattes/JML 2d/111=6.271251245
!	other planes of ADP (112,220), alpha-Quartz(11-20,10-12,20-20,
!	 11-22,21-31,20-23,22-40,31-40,22-43,50-52), Ge,Si(200,220)
!	other crystals: LiF,KBr,Al at low wavelengths.
!----------------------------------------------------------------------
!  Values used:
!	 PET(002): S(E,B,Se)=I-4,2d(R,F)=8.7358	! fudged into the structure!
!	 KAP(001): S(O)=P2(sub1)ab,2d(BH)=26.5790; I use 26.632(=L) ***
!	 ADP(101): S(B)=I-42d, a=7.4997(4),c=7.5494(12)=> 2d=10.641147 (K)
!		K has false H locations; O is given as attest
!		T gives better H_O, H_N and implied uncertainty
!	 Si(111): S(std texts,e.g.C)=Fd3m,2d(C)=6.2712108,==a=b=c=5.4310279
!	 alpha-Quartz(10-10): S(C)=P3(sub1)2,a=4.9134,c=5.4052=>2d=8.5103(LP)
!	Atom positions: PET, ADP & Quartz are updated.
!
!----------------------------------------------------------------------
!		Major Control Parameters / Variables:
!
!	OPT=1-9; 8=optional geometry input; 7=user-input F's for tests;
!	 5=crystal structure read from data file;
!	 1-4,6=PET,KAP,Si,ADP,Quartz crystals;
!93	 9 = bodge elemental crystal, cubic symmetry
!
!	Iffsource=0-6 default source of f1,f0,f2,(mu,siginc,sigscat),
!	 0=default;1-6=CTC/H(82),HenPC(88),
!	 B/C/C(2)[iGLorder=16/10/5],B/C/C(1)[iGLorder=5]
!
!	AGE=0 used to give a partially corrected inf. flat crystal calcn
!	AGE=0 gives RHths = integration over the surface Bragg th. = RHTh1
!			(infinite flat crystal; used to be AGE=1)
!	|AGE|=1 gives RHths = integration over the surface Bragg th. = RHTh1
!			(finite flat crystal)
!	|AGE|=2 gives RHysurf == RHy for a flat crystal;                 
!		    Reflint =  actual Iout/Iin for the Th1 range
!		    RHTh1   == RH for a point source, == RHths in the
!	  case of a flat crystal, +  FFRC and RHths for the flat crystal 
!	|AGE|=3 gives the above with maxlayer = 1
!	|AGE|=4 ditto with xbdisp=0 only
!	|AGE|=5 ditto with xbdisp=0, maxlayer=1
!	AGE<0 includes photographic emulsion shift
!	 (Photo=1 vs 0) in fci/p calculations (|AGE|>1)
!
!	Ifeff=0 is default
!	Ifeff=1 compares calculations to simple qualitative estimates;
!	Ifeff=2 indicates locations of 3-beam interaction (only)
!	 => AGE=0, ORDER=1, ANS=-1
!
!93	ORDER=-2 (Read list; o/p; observe at grazing angle)
!	ORDER=-1 (Read list of wavelengths; o/p RPI/RSG/RPP/RPL/FFRC)
!	ORDER=0  (Read list but don't write o/p files)
!	ORDER=1-n (diffraction order, single user-input wavelength)
!
!	tflag=1  (curved crystal: t0, dely defined for each angle)
!	tflag=2  (curved crystal: t0 limited by crystal thickness)
!	tflag=0  (initial or reset state = flat crystal)
!
!	norm=0   (ffm calcn: set range with base precision; mcyc=1-4)
!	norm=1   (ffm calcn: set dely0=effective thickness; mcyc=5-7)
!	norm=2   (ffm calcn: refine range, steps, symmetry; mcyc=8-10)
!	norm=3   (ffm calcn: include mosaicity;		    mcyc=11)
!
!	IREAD=0 (ORDER=1-n); IREAD=1 (ORDER=-2-0)
!	Ilist	number of wavelength(s) in list (ORDER<1)
!	Inext	next wavelength to be WRITTEN to o/p (if Fwrite(Inext)>0)
!	Isum	pointer for output files
!	ANS=-1	default; =0-3 o/p files for single run (ORDER>0)
!
!	Igraz=0 normal centring on Bragg peak. Omit Fresnel coefficients.
!	Igraz=-1 normal centring on Bragg peak. Include Fresnel.
!	Igraz=1 centre on grazing angle and converge. Include Fresnel always.
!
!	Maxt2 = physical crystal thickness
!	maxt3 = same, limited by mosaic block thickness
!	Maxt1 (CS5) estimate for 12 attenuation depths (negligible wavefields)
!	Maxt  (CS5) = min(Maxt1,Maxt2) est. of effective maximum depth
!	tlast0 (CS5,curved) = (max) depth from surface to below diffn peak
!	tlast  (CS5,curved) = min(Maxt,tlast0) for each thinc ray
!	t0c    (CS5/FFM) = layer thickness (limited by Maxt2) (for tracking)
!	t0     (FFM) = layer thickness (limited by maxt3) (for diffraction)
!	t0pk   (FFM) = reference t0 for ffm peak reflectivity
!	dt0    (CS5,curved) = layer thickness within layer calculation
!	mt0    (CS5,curved) = dt0 for maximum IRELR (source x layer refl)
!	maxt0  (CS5,curved) = maxt for maximum IRELR
!	dprime (FORMF0) = 2/3 'd', 'd' = mean emulsion grain diameter
!	TEMUL  (FORMF...) = mean photographic emulsion (detector) thickness
!	
!
!--------------------------------------------------------------------------
!	Moscurve subroutine and function structure, timing and loops:
!	MOSCURVE	  1: Input/open/read files
!		=> date, get_lattice (OPT=5); unit=10 (*.CLAT), secnds
!		=> bodge_lattice (OPT=9);
!		=> Units 4,3,7 (FELIN(ES) list of wavelengths, IR, RI)
!		=> FORMF1 => FORMF (CTC/H82;Henpc88;C/L/C92 for emulsion)
!		   (FFSUPP: atomic_data,raycomp,cromer etc.)
!			  2a: Read crystal parameters, calc. form factors
!		=> FORMF (CTC/H82;Henpc88;C/L/C92 for emulsion)
!		   (FFSUPP: atomic_data (rdat),raycomp,
!		    cromer(mcm,rdat,sort,polint,aknint,
!		     gauss(legendre,(o)sigma0-5) ) )
!			  2b: Calculate structure factors
!		=> GEN2D (New2d), FHCALCN, F0CALCN
!			  3: Sigma and Pi loops (simultaneous for AGE<1):
!		=>| BRAGGIFP (AGE=0, return);
!		  | THREEBM  (Ifeff=2, stop) (GEN2D,FORMF,F0/Hcalcn,New2d);
!		  | CS5 (AGE>1) (gengeom,emitang,xchord,secnds)+
!			  4: ffrc calcn: 1000<=STEPSF<=18000,+20, <10cycles?
!		  |=> BRAGGFFM (AGE=1, return);
!			       Steps/o/p: 1(Th1),2(xbdisp);   3(THO),4(YO)
!			  5: fcrc cycle1: 500,           5;     8000, 8000
!			  6:      cycle2: 2000,			75;    8000, 8000
!			  high precision:		       100;
!		OR(imp,s,1-4)1.4k,61/1k,43/800,37/1650/f(th),35	1000, 1000
!		OR (imp,pi) 1.1k,61/1.5k,43/1k,45/1400/g(th),47	1000, 1000
!Mac	OR (broad source,pnt crystal) steps1-steps2 reversed
!			 (high precision: STEPS1*3/2,<=2000)
!			Purpose:	  source: angle width
!		 Internal loops: layer=1,ntot(1-100)
!		  layer<=2.OR.ABS(ylayer)<=5*delyo(0.27delthf)
!			 high precision:
!		  layer<=2.OR.ABS(ylayer)<=7*delyo(0.35delthf)
!			Purpose:	 diffraction model
!	      	   ITEST=1,ITIMES=4 to 60 (2-40 for imperfect)
!			Purpose:	 depth penetration precision
!
!		  	  7: comparison of estimates:
!		  |=> OUTFILS (output results, estimates);
!		=> COMPAREMEASURES (Ifeff=1);
!			     writing/closing/opening RP files
!----------------------------------------------------------------------------
!			INPUT AND OUTPUT FILES
!
!	Form factors, scattering, attenuation:
!		<DATFIL>.<CFIL> = RDDEa.D1 (H); .D2 (C); .D3 (N); .D4 (O);
!  .D9 (P); .C1 (Si); .C2 (K).   == UNIT 2 input (Henke 1982+CTC old database);
!		[.henpc]*.asc    == unit 2 input (HenPC, 1988 database);
!		abs$sfcoef_data  == unit 2 input (Cromer/Mann f0 base);
!		absorption$data  == unit 2 input (C/L, B/C/C, f" base);
!		abs$raycomp_data == unit 2 input (Balyuzi scattering).
!	Crystal lattice input data:
!91		<LATFIL>.LAT     == UNIT 10 input of crystal lattices.
!	Wavelength summary and ID files, with short results:
!		(FELINES).DAT  == UNIT 4 input of theoretical wavelengths;
!		(FELINES).OUTa == UNIT 3 output (IR, RI corrns & wavelengths);
!		(FELINES).OTYa == UNIT 7 output (IR, RI corrns on film &c).
!	Profile output files:
!		FFRC.S0na == UNIT 8 (Finite flat crystal profiles, sigma);
!		FFRC.P0na == UNIT 8 (Finite flat crystal, pi = perp. poln);
!		RPI.D0na  == UNIT 7 output of ifp, pi poln profile;
!		RSG.D0na  == UNIT 1 output of ifp, sigma poln (E ll inc.plane);
!			(note reversion to Z,C et al of nomenclature);
!		RPLTH1.D0na  == UNIT 1 fcm, sig (E ll plane of inc.),source th;
!		RPPTH1.D0na  == UNIT 1 fcm, pi (E perp.inc.plane),source angle;
!		RPLTHO,RPPTHO.D0na == UNIT 1 (Thout, exit angle);
!		RPLYO,RPPYO.D0na == UNIT 1 (Shift along Generatrix on film).
!	Temporary computation file for CPU limit:
!		TEMPSIG.0a == UNIT 11 (RFL,RI1 if running out of cpu time);
!		TEMPSIG.1a == UNIT 11 cumulation of 0a.
!	Comparemeasures output data files (no comments):
!		Mshift1-7.(adp)nnn == units 12-18 (Ifeff=1).
!	Threebm output data files (no comments):
!		Htab.(adp101),LH..K..L..,Hsum,Hfil = units 12-15 (Ifeff=2).
!	Log. file:
!		....log == default o/p UNIT, detailed listing of results.
!
!--------------------------------------------------------------------------
!			OUTPUT PARAMETERS and FIELDS:
!	AGE=?		FIELD:	      1       2     3	     4
!	0-5:	*.LOG file ('fully commented')
!	0:
!		RPI,RSG .D0na:        delTh   r     chno     Y
!	0-5,	IREAD=1, data read from *.DAT:
!		*.OUTa                lambda  +/-   IRsig,pi RIsig,pi ID order
!	1-5:
!		FFRC.S...,.P...:      Th/rad  r	    t	     Y
!	2-5:
!		RPPTH1,RPLTH1 .D...:  Th1rad  R     ch	     Ysurf
!		RPPTHO,RPLTHO .D...:  Thout   R	    ch	     Ylayer
!		RPPYO,RPLYO .D...:    Yo/.1mu R	    ch	     Ylayer
!	2-5,	IREAD=1, data read from *.DAT:
!		*.OTYa                lambda  +/-   IRsig,pi DYsig,pi ID order
!	0-5,	Ifeff=1 (cf. COMPAREMEASURES/THREEBM.FOR):
!	    MSHIFT1.(adp101), UNIT 12 (Refractive Index estimates):
!		[1] THETA (rad); [2] dlambdanew (spectrometer incident l,Angs);
!		[3] DELtest (Approx.E5b+Exact E2 (F_0));
!		[4] DELtest2(Approx.E5b+'approx.'E3 (Z));
!		[5] DELtest3(Approx.E5b+Approx.E4 (Z_eff);
!		[6] DELt2est(E5b,exact,extended+exact E2 (F_0));
!		[7] DELtest3(E6, exact,extended  (F_0));
!		[8] bscale=(-b-1)/2 indication of asymmetry, fractional
!		    shift of exit angle, neglecting alpha_p itself;
!		[9/10] DELtest4(1/2) Profile asymmetry, y=-1 upper limit,s/pi.
!	    MSHIFT2.xxxnnn, UNIT 13 (depth penetration and mean DT parameters):
!	0-1:	[3] meandest (depth penetration est. E11a);
!		[4] DELtest5 (DP est. E11c: High E, T/2, -ve);
!		[5] DELtest6 (DP est. E11d: Low E, mu_abs, over-est.);
!		[6] DELtest7 (DP est. E11a (mu_abs) + Exact E10);
!		[7] mangle(1,1,1) / meanff(1,1)-Theta (ifp/ffp, mean Dtheta,
!		    summed over full range on Dtheta scale) sigma poln;
!		[8] mangle(1,1,2) / meanff(1,2)=Theta (ditto) pi poln;
!		[9] thpk1-T/ffpk(1)-T (Dtheta of peak from Bragg,ifp/ffp)sigma;
!		[10] thpk2-T/ffpk(2)-T (ditto) pi poln;
!		[11/12] fwhm1/2 / c2ff(1/2)-c1ff(1/2) (dtheta_fwhm,ifp/ffp)s/p.
!	2-5:	[3/4] mdepth(1/2) sigma/pi, Monte Carlo 'exptal' fcm DP, muext;
!		[5/6] DELtest7s/p sigma/pi, E10 exact+E11a muabs+muext;
!		[7/8] Mshift21/2 s/p, mean Delta Theta_out;
!		[9/10] Mshift41(1/2)-T s/p, inverse transform DTheta from
!		       mean DY, limited by crystal;
!		[11/12] Mshift31(1/2)/GBt1 s/p, mean DY/2Rz.
!	    MSHIFT3.xxxnnn, UNIT 14 (lateral, off-axis shifts / DY parameters):
!	0-1:	[3] DELest (delta for 'exact' E2);
!		[4] DELtest8 (Min.lat.E16cd,E15ab,using t7 muabs);
!		[5] DELtest9 (Max.lat.E16cd,E15a,DT_Amax,using t7 muabs);
!		[6] FPhoto (DYiz, expected);
!		[7] DELlest (Approx. dlambda from DELest;
!		[8/9] DELt3est+t4(1/2)/4 s/p, realistic y=-.25 p a/s max.;
!		[10] DELYest poor dY from DELest;
!		[11/12] DELtest8/9o Approx.Lat.Shift Min/Max(E16ab).
!	2-5:	[3] DELtest8 (Min.lat.E16cd,E15ab,using t7 muabs);
!		[4] DELtest9 (Max.lat.E16cd,E15a,DT_Amax,using t7 muabs);
!		[5/6] sigma/pi, 2R(meanff(2,1/2)-T) scaled mean thout;
!		[7/8] 2R*Mshift21/2 s/p, scaled mean Delta Theta_out;
!		[9] 2R(DELt3+Dt4(1)/4+Dt7) est. of RI+p.a/s+DP, scaled;
!		[10] MPhotoshift (DYiz, observed / ray tracing average);
!		[11/12] Mshift31(1/2) s/p, mean DY.
!	    MSHIFT4.xxxnnn, UNIT 15 (mean angular shifts ifp/ffp/curved ffp):
!	0-5:	[3/4] mangle(121/2) / meanff(21/2)-T s/p (mean DT, 2decade,DT);
!		[5/6] mangle(131/2) / meanff(31/2)-T s/p (mean DT, 3decade,DT);
!		[7/8] mangle(411/2)/meanff(41/2)-T (dT, full range, mean DsinT);
!		[9/10] mangle(421/2)/meanff(51/2)-T (dT, 2 decade, mean DsinT).
!	(omitted mangle(111/2) / meanff(11/2) mDT full range in MSHIFT2;
!		 mangle(431/2) / meanff(61/2) DT <-mean DsinT, 3 decade;
!		 mangle(2/5 1-3 1-2) DT<- mean DT/DsinT DOUBLE CRYSTAL!
!		  'non-dispersive' arrangement (parallel crystals);
!		 mangle(3/6 1-3 1-2) DT<- mean DT/DsinT DOUBLE CRYSTAL!
!		  'dispersive' arrangement (crystals at 2theta_B);
!		 cf. ifp output log file).
!	    MSHIFT5.xxxnnn, UNIT 16 (diffracting angle, off-axis shifts):
!	2-5only:[3] sigma, dTh_l-Th_B, full;
!		[4/5] s/p, YestfC(1,1/2)-YozC(1) off-axis ffp->fcp est.; 
!		[6/7] s/p, YestcC(1,1/2)-YozC(1) off-axis fcp est.(ray tracing);
!		[8] pi, mthld(1/2)-T, dTh_l-Th_B, full range;
!		[9/10] s/p, mthld(3/4)-meanff(2,1/2), dTh_l-Th_B, 1%-1%;
!		[11/12] s/p, YestcC(1,1/2)-YozC(1)+DY11+MPh, Yiz=DT->Y+lat+Ph.
!	    MSHIFT6.xxxnnn, UNIT 17 (diffracting angle, lat./off-axis shifts):
!	2-5only:[3] YozC(1)-2R.Theta, Zero offset;
!		[4] DELYest10, lat.shift from Th_AC(1,ip),Th_B,Dt7==muabs;
!		[5/6] emthld(1/2)-meanff(3,1/2)+T,FLAT EST.dThl-mTff(3-dec.);
!		[7/8] mthld(1/2)-meanff(3,1/2), dTh_l-mean Th_ff(3-decade);
!		[9] DELYest9p, E13/14 est. Yoz-2R.Th;
!		[10] DELYest11, XZ/pi lat.shift/Th_AC(1,ip),Th_ff,Dt7p;
!		[11] Y5=total? XYZF-YozC(1) shift (pi poln, DY11 est.);
!		[12] mean depth(3), sigma poln mean over 1% range.
!	    MSHIFT7.xxxnnn, UNIT 18 (lateral / off-axis shifts):
!	2-5only:[3] XXC(VL=1) fcp sepn of Bragg locn on crystal from AxisTh;
!		[4] minxxp(VL=1) crystal limit for 5% of pk contribution;
!		[5] maxxxp(VL=1) crystal limit for 5% of pk contribution;
!		[6/7] YestfC(VL=1,1/2)-2R.meanff(2,1/2), off-axis shift;
!		[8] XXC(VL=2) fcp sepn of Bragg locn from AxisTh;
!		[9] minxxp(VL=2) crystal limit for 5% of pk contribution;
!		[10] maxxxp(VL=2) crystal limit for 5% of pk contribution;
!		[11/12] YestfC(VL=2,1/2)-2R.meanff(2,1/2), off-axis shift.
!
!	0,	Ifeff=2 (cf. THREEBM/THREEBM.FOR):
!	    LH..K..L..(adp101), UNIT 13 (files of 3-beam interactions):
!		[1] Theta,lambda,phiabs(1-4).
!	    Htab.(adp101), UNIT 12 (tabulation of structure factors):
!		[1] Theta,lambda,E,F0,FHr,FHi.
!	    Hsum.(adp101), UNIT 14 (summary file of 3-beam interactions):
!		[1] Crystal,3-hkl,Theta,E,lambda,indice range;
!		[2] phiabs(1-4) for minimum angle match;
!		[3] phiabs(1-4) for maximum angle match;
!		[4] plane,2d,matches,lambda range;
!		[5] FLr,FLi;
!		[6] dlambda,dtheta_H,dphi interaction widths.
!	    Hfil.(adp101), UNIT 15 (List of LH.. files for plotting+).
!--------------------------------------------------------------------------
!	UNITS: Generally crystal params are in Angstroms,
!		PSI (diffn) vars are dimless (but N,V are in m),
!		and geometric vars (GB(I),XX,BX,xline,Sk,swidth,
!		1/muabs,1/muext) are in 0.1 microns.
!
!--------------------------------------------------------------------------
!
PROGRAM MOSCURVE3
  IMPLICIT NONE
!			GENDAT variables:
  INTEGER NINDEPT
  PARAMETER (NINDEPT=28)
  INTEGER MAXK,KM(NINDEPT),ISP,OFL,OFL2,MS,JM
  DOUBLE PRECISION GB(NINDEPT),ERGB(NINDEPT),LB(NINDEPT), &
      UB(NINDEPT),GBP(NINDEPT),LBP(NINDEPT),UBP(NINDEPT),ERGBP(NINDEPT)
!U96: alignment
  COMMON/FITVAR/ GB,ERGB,LB,UB,GBP,LBP,UBP,ERGBP, &
      MAXK,KM,ISP,OFL,OFL2,MS,JM
!
  INTEGER iatoms,isites
  PARAMETER (iatoms=40,isites=3)
  INTEGER IDIG,nalphs,nelas,nbasis,ksites,natoms(iatoms) &
      ,nsites(iatoms),iZed(iatoms,isites),ntherm(iatoms,isites) &
      ,atomtype(iatoms,isites)
  DOUBLE PRECISION a01,b01,c01,calpha,cbeta,cgamma,Tref,aalph(6) &
      ,elast(6),fpop(iatoms,isites),btherm(iatoms,isites,6),xco(100,3)
  CHARACTER PLABEL(15)*12
  COMMON/XLATTICE/PLABEL,IDIG,nalphs,nelas,nbasis,ksites,natoms &
      ,nsites,iZed,ntherm,atomtype &
      ,a01,b01,c01,calpha,cbeta,cgamma,Tref &
      ,aalph,elast,fpop,btherm,xco
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER ielem
  PARAMETER (ielem=20)
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!91			Form factor variables
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!
  INTEGER Intflag,Iint
  COMMON /COMINT/ Intflag,Iint
!BCC2
  DOUBLE PRECISION amu(ielem),rho(ielem),Mui(ielem)
  integer nedge(ielem),iPhoto
  INTEGER emultype
  COMMON/FORMFC2/amu,rho,Mui,nedge,iPhoto,emultype
!
  DOUBLE PRECISION energynew
  DOUBLE PRECISION fp(ielem),fpp(ielem)
  common/newcom/energynew,fp,fpp
!92		Separate THREEBM/FHCALCN parameters:
  INTEGER IM(4)
  DOUBLE PRECISION a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,d2,xTemp
  DOUBLE PRECISION Numcells
  COMPLEX*16 FHr, FHi, FHn(ielem)
  common/com2d/ IM,a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,Numcells,d2,xTemp,FHr,FHi,FHn
!91		I/O pars (BRAGGIFP +)
  DOUBLE PRECISION RANGE(2),STEPS,DELJ(2),denom,aplane,G,G2,K12,K,K2
  DOUBLE PRECISION RI1(3),RI2(3),RI3,RFL(3),RFL2(3),RANGE0
  DOUBLE PRECISION fwhm1,fwhm2
  DOUBLE PRECISION mangle(6,3,2)
  DOUBLE PRECISION RIT(6,3,2),RFLT(6,3,2)
  DOUBLE PRECISION scale1,thpk1,thpk2
  INTEGER CYCLE,Ibit,Jbit,J,Item
!U96 change order in common statement (alignment for Unix)
  COMMON/COMIFP/RANGE,STEPS,DELJ,denom,aplane,G,G2,K12,K,K2 &
      ,RI1,RI2,RI3,RFL,RFL2,RANGE0 &
      ,fwhm1,fwhm2,mangle,RIT,RFLT &
      ,scale1,thpk1,thpk2,CYCLE,Ibit,Jbit,J,Item
!
  DOUBLE PRECISION dlambda,Mshift21,Mshift31(2),Mshift41(2)
  COMMON /mosout/ dlambda,Mshift21,Mshift31,Mshift41
!
  DOUBLE PRECISION B,FOUT,fwhm,Energy,A0
  DOUBLE PRECISION sum1,sum2,sintha, XI, WC
  INTEGER ibasis,iatomtype,isite,ialph
  double precision MH,MK,MI,ML,THERM,fh1bT,f02bT
  COMPLEX FSI0, FSIH, PSI0,PSIHr,PSIHi
  DOUBLE PRECISION A2,dbeta,dbetaread
!		      Passed vars
  DOUBLE PRECISION dalpha,dTwod,swidth
  DOUBLE PRECISION ORDER,dlambdadmu
  INTEGER iorder
  INTEGER OPT,i1
  character FILEIN*11,LINE*80,FILEIN2*20,RUBBISH*8
!92			major new curved crystal variables:
  DOUBLE PRECISION AxisTh,ABtem,Mininc,THABX,THBAX,BXmin
  DOUBLE PRECISION thm1C(2),ThminC(2),ThmaxC(2),thminoC(2) &
      ,thmaxoC(2),YozC(2),YminoC(2),YmaxoC(2)
  INTEGER VARMAX,Isect(2)
  COMMON/CS5B/AxisTh,ABtem,Mininc,THABX,THBAX,BXmin &
      ,thm1C,ThminC,ThmaxC,thminoC,thmaxoC,YozC,YminoC,YmaxoC &
      ,VARMAX,Isect
!		      Common (I/O) vars (CS5-Rcurve)
  INTEGER ISTEPSO,ISTEPSP
  PARAMETER (ISTEPSO=8000,ISTEPSP=8001)
  DOUBLE PRECISION RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr
  DOUBLE PRECISION MPSIr2,MPSIi2,p,s,K1,Temth0,Thout0, &
      muabs,mcurv,mReftem1,Maxt2,umbo2
  DOUBLE PRECISION Irel1(ISTEPSP),Irel2(ISTEPSP),Irel3(ISTEPSP), &
      Reflint(6),Reflintth,ReflintHy,Mshift1,Mshift2,Mshift3(2,2), &
      Mshift4(3),Ermshift4,MShiftB(6),Irel5(ISTEPSP),Irel6(ISTEPSP)
  DOUBLE PRECISION MaxI1,MaxI2,MaxI3,MaxI4,Thpk, &
      Thpko,Ypko,Th1,Thout,Yshift, &
      STEPS1,STEPS2,STEPS3,STEPS4,basym,IRELM
  COMMON/CS5C/RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr,MPSIr2,MPSIi2, &
      p,s,K1,Temth0,Thout0,muabs,mcurv,mReftem1,Maxt2,umbo2, &
      Irel1,Irel2,Irel3,Reflint,Reflintth,ReflintHy,Mshift1, &
      Mshift2,Mshift3,Mshift4,Ermshift4,MShiftB,Irel5,Irel6,MaxI1, &
      MaxI2,MaxI3,MaxI4,Thpk,Thpko, &
      Ypko,Th1,Thout,Yshift,STEPS1,STEPS2,STEPS3,STEPS4,basym &
      ,IRELM
!
  DOUBLE PRECISION c251,c252,c253,c751,c752,c753,mt0
  DOUBLE PRECISION mq2,PkTh1,Reflinto,thmaxf,thminf,Mosdel, &
      c1ff(6),c2ff(6),ffpk(2),Maxff,maxt0,maxt3,sigscat,siginc &
      ,Reflintm,Reflinty,ReflintthinC
  DOUBLE PRECISION transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm(2,8,2)
  INTEGER K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2
  CHARACTER numstr*4
  COMMON/CS5D/c251,c252,c253,c751,c752,c753,mt0,mq2,PkTh1, &
      Reflinto,thmaxf,thminf,Mosdel,c1ff,c2ff, &
      ffpk,Maxff,maxt0,maxt3,sigscat,siginc,Reflintm,Reflinty, &
      Reflintthinc,transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm,K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2,numstr
!
  INTEGER ffs
  PARAMETER (ffs=30100)
  COMPLEX*16 DPSI0, DPSIHr, DPSIHi
  DOUBLE PRECISION Thm2,Thm3,Temthm2,Temthm3,Yrel(ISTEPSP,6), &
      Thtem(ffs),Rtem(ffs),Ttem(ffs),Ytem(ffs),dely0,dely0t,mufilm, &
      TEMUL,Mphotoshift,mdepth(6),mthld(6),emthld(2) &
      ,mcontl,meanff(7,2),maxdp,maxdm,thff,Chinit,Chfin
  DOUBLE PRECISION Rzf,Cx
!93atest:       add mYo for output asymmetry evaluation:
  DOUBLE PRECISION fscale,RtemC(ffs),TtemC(ffs),Tabdy(ffs,4),mYo(6)
  DOUBLE PRECISION BXm,BXx
  INTEGER fof,detmatch,ip
  COMMON/CS5E/ DPSI0,DPSIHr,DPSIHi,Thm2,Thm3,Temthm2,Temthm3,Yrel, &
      Thtem,Rtem,Ttem,Ytem,dely0,dely0t,mufilm,TEMUL,Mphotoshift, &
      mdepth,mthld,emthld,mcontl,meanff,maxdp,maxdm,thff &
      ,Chinit,Chfin,Rzf,Cx,fscale,RtemC,TtemC &
      ,Tabdy,mYo,BXm,BXx,fof,detmatch,ip
!93atest-
  INTEGER IREAD,Photo,Jbit4,Fwrite(0:20)
  COMMON/CS5F/ IREAD,Photo,Jbit4,Fwrite
!		Time vars
  DOUBLE PRECISION Maxtim,DTIME(6),Mtime,Ntime
  REAL*4 Time0,Time1,Time2,Tim2f,Tim21,Tim22
!U96   alignment: order of variables + name in COMMON statement:
  COMMON/clockt/ Maxtim,DTIME,Mtime,Ntime,Time0,Time1,Time2,Tim2f &
      ,Tim21,Tim22
!
  INTEGER Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
  COMMON /COMINTS/ Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
!		      Temp. Vars
  DOUBLE PRECISION RESN,OLDORDER,OLD2ORDER
  INTEGER ILEN,ISEQUENCE,I,I2,I3,Icycle &
      ,Maxch,IPNT,I2SEQ,IL,attest,Isecto(2)
  INTEGER IdcomLEN,IdoutLEN
  DOUBLE PRECISION Dummy1,Dummy2,Dummy3,dlratio
  DOUBLE PRECISION thetaap,BXp,THABXp,tem	! local pre-cs5 vars
  DOUBLE PRECISION Ft1,Ft2,Ft3,Ft4
  INTEGER iexpfhr
!V	new AV variables (for MCP detector)
  DOUBLE PRECISION XD,XDmin,XDmax,XD0,thetaD,Thetaap2
  COMMON/CS5G/ XD,XDmin,XDmax,XD0,thetaD,Thetaap2
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!MAC95
  CHARACTER dout*11,dcom*11,ddat*7,dhen*16,dhm*8
  COMMON/Macfiles/ dout,dcom,ddat,dhen,dhm
!MAC95
!onvex      REAL SECNDS
  REAL SECNDS
!onvex      EXTERNAL SECNDS
!
  INTEGER IDELN,ANS1,Gflag
  DOUBLE PRECISION Gbt1
!B
  INTEGER Bragg
!L
  DOUBLE PRECISION I2Rz,THBAXp
!L
!  CHARACTER*9 datef
  CHARACTER*30 datef
!plate96
  DOUBLE PRECISION Detx,Detarmlen,Detbeta,Dettheta,Rplate
  COMMON/PLATE/Detx,Detarmlen,Detbeta,Dettheta,Rplate
!out97
  INTEGER outputflag
  INTEGER Outfilesflag, Maxlines
  COMMON/OUTBRAGG/Outfilesflag, Maxlines
!LFS: Added next variable
  INTEGER Iquit,Iio_status
  LOGICAL test_read_first_order_line, test_read_arbitrary_order_line, test_OPT_implimented
  LOGICAL test_continuation_calc
!-------------------------------------------------------------------
!			FPS interface functions
!      DOUBLE PRECISION DREAL
!      DOUBLE PRECISION DIMAG
!      DOUBLE PRECISION XREALX,YREALY
!      COMPLEX*16 XCMPLX
!      COMPLEX*16 CDEXP
!      COMPLEX*16 DCMPLX
!      COMPLEX*16 CDSQRT
!
!      DREAL(XCMPLX)=REAL(XCMPLX)
!      CDEXP(XCMPLX)=CEXP(XCMPLX)
!      DIMAG(XCMPLX)=AIMAG(XCMPLX)
!      DCMPLX(XREALX,YREALY)=CMPLX(XREALX,YREALY)
!      CDSQRT(XCMPLX)=CSQRT(XCMPLX)
!-------------------------------------------------------------------
!			include common block
  INCLUDE 'FFCOM.FOR'
!91			control parameter initialisation
!----------------START BLOCK 1-------------------------
!LFS: Added next lines
  Iquit = 0
  ANS1  = 1
  test_OPT_implimented = .true.
  
  Bragg=1
!B
!L
  Intflag=0
  Iint=5
!U96 add switch for UNIX as well as VAX should run with VAX switch 
!U09  IMac=-1
  IMac=2
!U96      IMac=1		! Set up for MacPPC; vs 0=VAX, muVax, Cluster, -1 = UNIX, -2 = GNU compiler
  IREAD=0
  OLDORDER=0.D0
  ISEQUENCE=0
  Ilist=0
  Iprecs=0		! low precision default
  DO I=0,20
    Fwrite(I)=0
  ENDDO
  Inext=0
  DATFIL='RDDEF.'
  Iffsource=0
  Ifeff=0
!91			data/defaults and geometry
!	gb1-10=2Rz,beta,w0,alpha',BDz,BXz,flamb,alpha_bm,alpha",Nsscale
!	q.v. Thesis/GENDAT for details; applied to Fe25+ QED measurement
!	only GB(1,2,(3),5,6 and 8) affect geometric/diffraction calcn
!	 NOTE [1]: dalpha=alpha_1, the angle of BX'Y'Z'F' to BXYZF,
!	replaces w0 (w_est)=GB(3) and is given herein;
!	dbeta=beta=v/c (read or input) replaces GB(2);
!	GB(1),GB(5),GB(6) and GB(8) are input in option 8.
!	This data is therefore of limited value, primarily for
!	illustrative/comparative purposes and correspondence to GENDAT.
!	 NOTE [1a]: this alpha(EL) is replaced by alpha(AZ).
!	 NOTE [2]: a_Bm is wrt X (not Xz); this is identical at normal
!	incidence, but otherwise a_Bm\simeq\a_Bm(0)cos(Th1) in standard
!	set-up (source B,crystal,film in same plane). For the SS1
!	extreme, maxdp,maxdm=12mm, 2Rz=300mm, BDz,BXz gives -0.46<Th1<0.257,
!	so a_Bm=(0.896-1.0-0.967)a_Bm(0). If this were ever a problem,
!	the spectrometer (crystal) could be rotated so a_Bm=0, alpha_1>>0
!	(and F must then be translated).
!	 NOTE [3]: Current source and programme gives reflectivity
!	as a fraction of 2pi == sigma radiation distribution and beta=0.
!	This must then be scaled by the effective solid angle.
!	A possible extension would assume sigma (or pi) radiation
!	distributed in 4pi in the lab. frame or in the beam frame.
!
  DATA (GB(I),I=1,10)/3000000.,.137,0.,.052,1.5D+5,2.6D+5, &
      0.,0.,0.,0./
  DATA (ERGB(I),I=1,10)/1000.,.0005,20000.,.015,10000.,10000., &
      1.,.1,.01,.01/
  DATA (PLABEL(I),I=1,6)/'  PET    002','  KAP    001' &
      ,'  Si     111','  ADP    101','  Mica   ---','Quartz 10-10'/
!M
  maxdp=1.2D+5      ! 12mm=1.2+5*.1mu each side of crystal pole
  maxdm=maxdp
  TEMUL=1.3D2	! 13 micron active DEF392 emulsion thickness
!91			testing defaults
  RANGE0=8.D0
  IDIG=3
  IDELN=0
  fscale=1.0D0
  attest=0
  GBt1=GB(1)
  Rzf=GB(1)/2.D0
  Cx=0.0D0 ! the dist. bewtween the pole of the crystal and the axis of rotation for the detector
  aplane=.0
  dbeta=GB(2)
  dbetaread=0.D0
  xTemp=-1.D2	! set to Tref (us. room temperature (293K)) later
  Mininc=-1.D0	! set later
!
!MAC
  IF (IMac.EQ.1) THEN
    ddat='::DATA:'
    dhm='::HENPC:'
    dhen=' '
    dcom='::Comfiles:'
    dout='::Fresults:'
!U95 folowing line must be commented out to run on UNIX, replace when running 
!U95	on a MAC  
!U95 IMac=1 (Mac) include next line, IMac=-1 (UNIX) comment out next line 
!	   OPEN(UNIT=5,FILE=*,STATUS='OLD')
!	   OPEN(UNIT=6,FILE=*,STATUS='NEW')
  ELSEIF (IMac.EQ.0) THEN
    ddat=' '
    dhen='[CHANTLER.HENPC]'
    dhm=' '
    dcom=' '
    dout=' '
  ELSE		!Unix
    ddat='undata/'
    dhen='asciformfactdat/'
    dhm=' '
    dcom=' '
    dout=' '
  ENDIF
!MAC
!  CALL DATE(datef)
  CALL FDATE(datef)
  WRITE(*,6) datef
6 FORMAT('-------------------------------------------------------------',/, &
         ' MOSPLATE98/NOV97, calculating rocking curves',/, &
         ' and integrated reflectivities for plate detector. ',A9,/, &
         ' Input units:',/, &
         '  Angle  - radians,',/, &
         '  Length - 0.1 microns.',/, &
         '-------------------------------------------------------------')
  WRITE(*,*) ''
  WRITE(*,*) 'Enter'
  WRITE(*,*) ' Bragg or Laue diffraction? (1/0)'
  READ(*,*) Bragg
  IF (Bragg.EQ.1) THEN
    fof=18000
  ELSE
    fof=9000
  ENDIF
!----------------END BLOCK 1-------------------------

  DO !until ANS1 is not 1

!----------------START BLOCK 2-------------------------
    DO !until OPT is valid and not 8
      DO !until OPT is valid
        WRITE(*,*) 'Enter' 
        WRITE(*,*) ' Number of Xtal to be used:'
        WRITE(*,*) '  1 PET, any plane(002), or 6.2A/n;n=1,4(2d=8.7358)'
        WRITE(*,*) '  2 KAP, any plane(001), or 11.37/n, n=2,1 (2d=26.632)'
        WRITE(*,*) '  3 Si,  any plane(111), or 4.76A/n, n=1,4 (2d=6.2712)'
        WRITE(*,*) '  4 ADP, any plane(101), n=1-4+ (2d=10.6414)'
!91
        WRITE(*,*) '  5 Crystal and structure input from data file'
!/old,disabled      WRITE(*,*) ' 5 Mica(---), none, (2d=19.84???)'
        WRITE(*,*) '  6 Quartz, any plane(hkil), n=1-4+ (2d(10-10)=8.5103)'
        WRITE(*,*) '  7 User-specified parameters, for testing'
        WRITE(*,*) '  8 set 2Rz(crystal,film),Cx(c-f/circle),xtal arc/2...'
        WRITE(*,*) '  9 Elemental cubic crystal bodge from data file'
        READ(*,*)  OPT

!91	removed 'OPT.EQ.5.OR.' from below
        IF (OPT.GE.1.AND.OPT.LE.9) THEN
          EXIT
        ENDIF
      ENDDO
    
      IF (OPT.EQ.6) THEN ! 'Quartz, any plane(hkil), n=1-4+ (2d(10-10)=8.5103)'
        IDIG=4
      ENDIF
    
      IF (OPT.EQ.8) THEN
        IF (Bragg.EQ.1) THEN
          WRITE(*,101) GB(1),Rzf,Cx,maxdp,maxdm
101       FORMAT(' Enter' &
              ,/,'  2Rz, Rzf, Cx,' &
              ,/,'  crystal arc on each side' &
              ,/,'   of pole/.1mu (flat==2Rz=0 giving 1/2Rz=0; Laue==2Rz+/-),' &
              ,/,'  f1(O) scale (1.0=no change),atomic site test (1=yes),' &
              ,/,'  Temperature, low or high precision (0/1),' &
              ,/,'  Gflag (BD input==0; Axisth input==1).' &
              ,/,'  Default values are:' &
              ,/,X,1PE11.4,',',1PE11.4,3(',',1PE10.3),',1.0,0,Tref,0,0')
          READ(*,*) GB(1),Rzf,Cx,maxdp,maxdm,fscale,attest,xTemp,Iprecs,Gflag
        ELSE ! don't enter Cx if not Bragg
          WRITE(*,11) GB(1),Rzf,maxdp,maxdm
11        FORMAT(' Enter' &
              ,/,'  2Rz, surface-detector z,' &
              ,/,'  crystal arc on each side' &
              ,/,'   of pole/.1mu (flat==2Rz=0 giving 1/2Rz=0; Laue==2Rz+/-),' &
              ,/,'  f1(O) scale(1.0=no change), atomic site test (1=yes),' &
              ,/,'  Temperature, low or high precision (0/1),' &
              ,/,'  Gflag (BD input==0; Axisth input==1).' &
              ,/,'  Default values are:' &
              ,/,X,1PE11.4,2(',',1PE10.3),',1.0,0,Tref,0,0')
          READ(*,*) GB(1),Rzf,maxdp,maxdm,fscale,attest,xTemp,Iprecs,Gflag
        ENDIF
!L
        IF (Iprecs.NE.0) fof=30000
        Gbt1=GB(1)
        WRITE(*,111)  GB(6),GB(5),GB(8)
111     FORMAT(' Enter' & !BXz, Axisth/BDz, a+AF8-Bm, Iff(2+AD0-H88,3+AD0-CLC tables)
            ,/,'  BXz (source-[Rowland circle-centre;surface]);' &
            ,/,'  BDz/AxisTh,' &
            ,/,'  equatorial plane/generatrix(-1=Read;-2=Aligned);' &
            ,/,'   alpha_Bm(in fwd/backward direction);' &
            ,/,'  default source of f1,f0,f2,(mu,siginc,sigscat)' &
            ,/,'   0=default;1-6=CTC/H(82),HenPC(88), B/C/C(2)[iGL=16/10/5], B/C/C(1)[5]:' &
            ,/,'  Default values are:' &
            ,X,1PE11.4,',',1PE11.4,',',1PE11.4,',0')
        READ(*,*) GB(6),GB(5),GB(8),Iffsource
      ENDIF
      
      IF (OPT.NE.8) THEN
        EXIT
      ENDIF
    ENDDO

!91			repond to database
    IF (Iffsource.EQ.0) THEN
      Iffsource=2	! reset old H to new H
    ENDIF
    
    IF (Iffsource.EQ.4) THEN	! medium precision for B/C/C(2)
      iGLorder=10
      iGLflag=1		! new method
    ELSEIF (Iffsource.EQ.5) THEN
      iGLorder=5		! low precision
      iGLflag=1
    ELSEIF (Iffsource.EQ.6) THEN
      iGLorder=5
      iGLflag=-1	! old method (B/C/C(1))
    ELSE
      iGLorder=16	! high precision - good for Z<=20, OK for all?
      iGLflag=1
    ENDIF		! iGLstep determined later (cromer) if needed.
!
    WRITE(*,121)
121 FORMAT(' Enter' &
          ,/,'  alpha (Azimuthal angle at local crystal surface,' &
          ,/,'   vs angle of Elevation; wrt Generatrix:' &
          ,/,'   tanalphaEL = west/(BXYZ+xline)=(h-z)/BXinc.;' &
          ,/,'   tanalphaAZ=tanalphaEL / costhetaCPT).' &
          ,/,'  Gaussn source fwhm(source extending to +-.75fwhm),' &
          ,/,'   or Square wave if sw<0, extending to +-.5 fwhm.' &
          ,/,'  beta(-1==read from DAT file).' &
          ,/,'  aplane(angle from surface to d-spacing).' &
          ,/,'  crystal thickness/.1mu: e.g. 0.,20000.,.1360,0.,4000.')
    READ(*,*) dalpha,swidth,dbetaread,aplane,Maxt2
!plate96

    WRITE(*,*)' Enter length of detector arm in units of 0.1 microns'
    READ(*,*) Detarmlen
    WRITE(*,122)
122 FORMAT(' Enter' &
          ,/,'  AGE,Ifeff,outputflag.' &
          ,/,'   AGE:(<0 =>Photo emulsion shift);' &
          ,/,'   |AGE|:' &
          ,/,'    0==ifp (infinite,flat,perfect) calcns;' &
          ,/,'    1==ffi (finite,flat,(im)perfect) calcns;' &
          ,/,'    2==ffp,fcp,fci (finite,flat/curved,(im)perfect);' &
          ,/,'    3==focussing/geometry test (surface layer only);' &
          ,/,'    4==comparison to C, ifp calcns (x=0/pnt source);' &
          ,/,'    5==focussing/interpolation (maxlayer=1, x=0);' &
          ,/,'   Ifeff:' &
          ,/,'    0==default;' &
          ,/,'    1==include simple estimates;' &
          ,/,'    2==only calculate 3-beam interactions (ifp)' &
          ,/,'   outputflag:' &
          ,/,'    0==all output files but max 1000 lines;' &
          ,/,'    1==only curved crystal output film and plate BUT all data.' &
          ,/,'    2==only curved crystal output, BUT max 1000 lines.' )  
    READ (*,*) AGE,Ifeff,outputflag
!     out97  include in AGE flag output changes

    IF (outputflag.EQ.0) THEN
      Outfilesflag=0
      Maxlines=0
    ELSE IF (outputflag.EQ.1) THEN
      Outfilesflag=3
      Maxlines=1
    ELSE
      Outfilesflag=3
      Maxlines=0      
    ENDIF
    
    IF (AGE.LT.0) THEN ! Photo emulsion shift
      AGE=IABS(AGE)
      Photo=1
      WRITE(*,123)
123   FORMAT(' Enter' &
          ,/,'  emulsion type:' &
          ,/,'   1=DEF default: T=13mu=130(.1mu)-140,' &
          ,/,'     AgBr Vol.fraction=.4(1),t0=1.1-2.0,d=1.53-1.69,etc' &
          ,/,'     cf. ' &
          ,/,'   0=101 default(T=1.2mu,VF=.74,t0=.053,d=.85...)' &
          ,/,'     (Deep ave. mu derived) only approx., to e.g. .2mu')
      READ(*,*) emultype
      IF (emultype.EQ.1) THEN
        TEMUL=130
      ELSEIF (emultype.EQ.0) THEN
        TEMUL=12
      ENDIF
    ELSE
      Photo=0
    ENDIF
    
    IF (Ifeff.GE.2) THEN
      AGE=0
      Ifeff=2
    ENDIF
    
    IF (AGE.EQ.1) THEN ! ffi calc.
      WRITE(*,124)
124   FORMAT(' Numerical evaluation fails if t0=>infty,' &
            ,'  Delsinth=>1,theta=>0,lambda=>0 or' &
          ,/,'  psi0=>large. The 1st 2 cases indicate ifp calcns; the 3rd' &
            ,'  needs Fresnel corrns; the remainder are (much) ' &
            ,'less probable.')
    ENDIF
    
!V.....1991 to allow for 'scanning'
    IF (dbetaread.GT.-1.D0.OR.dbetaread.EQ.-2.D0) THEN
      dbeta = dbetaread
    ENDIF
    
    IF (GB(5).EQ.-1.D0.AND.Gflag.EQ.1) THEN ! BDz/AxisTh eq -1 and 'Axisth input'
      dbetaread = dbetaread - 2.0
    ENDIF
    
    IF (GB(5).EQ.-2.D0) THEN ! BDz/AxisTh eq -2
      Gflag=-2.D0
    ENDIF
    
    maxt3=Maxt2
    IF (AGE.LT.1.AND.Ifeff.NE.2) THEN ! an ifp calc. and not three-beam
      WRITE(*,*) 'Enter'
      WRITE(*,*) ' initial range for abscissa in mins of arc'
      READ(*,*)  RANGE0
    ELSE
      RANGE0=1.D1
    ENDIF
    
    IF (Ifeff.EQ.2) THEN ! three beam calulation
      ORDER=1.D0
      Ilist=-1
      IORDER=IDNINT(ORDER)
    ELSE ! non three beam calulation
      WRITE(*,125)
125   FORMAT(' Enter' &
          ,/,'  the order of diffraction,' &
          ,/,'   0     = read from input file/' &
          ,/,'   -1    = read from input file and  write profiles' &
          ,/,'           with Fresnel coeffs around Bragg peak,' &
          ,/,'   -2/-3 = look at grazing inc. with F.,' &
          ,/,'   -4/-5 = look at Bragg peak without F.:')
      READ(*,*) ORDER
      Igraz=-1
      
      IF (ORDER.LE.-4.AND.ORDER.GE.-5) THEN
        Igraz=0
        ORDER=ORDER+4
      ELSEIF (ORDER.LE.-2.AND.ORDER.GE.-3) THEN
        Igraz=1
        ORDER=ORDER+2
      ENDIF
      ! Now: ORDER is in {-1,0,1,2,....}
      
      IF (ORDER.LT.1) THEN
        IF (AGE.GT.1.AND.(dbetaread.GT.-1.D0.OR.dbetaread.EQ.-2.D0)) THEN
          IDELN=5
        ELSEIF (AGE.GT.1) THEN
          IDELN=4
        ELSE
          IDELN=2
        ENDIF
      ELSE
      
      ENDIF
    ENDIF
    
    ANS=-1
    numstr='S01F'
    
    IF (AGE.GE.1.AND.AGE.LE.5) THEN
      WRITE(*,*) 'Enter'
      WRITE(*,*) ' Mosaic half-width(rad)(0-.01;>max=>3.636-6)?'
      READ(*,*) Mosdel

      IF (AGE.GT.1) THEN
        WRITE(*,*) 'Enter'
        WRITE(*,*) ' RP* files type'
        WRITE(*,*) '  1=emission geom.'
        WRITE(*,*) '  2=xray mirror'
        WRITE(*,*) '  3=ratio'
        READ(*,*) Irpout
      ELSE
        Irpout=1
      ENDIF
    
      IF (Mosdel.LE.0.D0) THEN
        Mosdel=0.D0
      ELSEIF (Mosdel.GT.1.D-2) THEN
        Mosdel=3.6361E-6
      ELSE
        WRITE(*,*) 'Enter'
        WRITE(*,*) ' mean crystallite width(mosaic unit)(.1mu)'
        READ(*,*) maxt3
        maxt3=DMIN1(maxt3,Maxt2)
      ENDIF
      
    ENDIF
    
    IF (OPT.EQ.5) THEN
!91		might as well read everything!
      PLABEL(OPT)='            '
      CALL get_lattice
    ELSEIF (OPT.EQ.9) THEN
      PLABEL(OPT)='            '
      CALL bodge_lattice
    ENDIF
    
! 		then section using IDIG remains here
    test_read_first_order_line     = AGE.GE.0.AND.IDIG.EQ.3 ! not ifp and non quartz crystal 
    test_read_arbitrary_order_line = AGE.GE.0.AND.IDIG.EQ.4 ! not ifp and quartz crystal
    
    IF (test_read_first_order_line) THEN ! read Miller indices
      WRITE(*,*) 'Enter'
      WRITE(*,*) ' h,k,l (for 1st order lines):'
      READ(*,*) IM(1),IM(2),IM(3)
      MH=IM(1)
      MK=IM(2)
      ML=IM(3)
    ELSEIF (test_read_arbitrary_order_line) THEN ! read Miller-Bravais indices
      WRITE(*,*) 'Enter'
      WRITE(*,*) ' h,k,i,l (or h,k,0,l) '
      READ(*,*) IM(1),IM(2),IM(3),IM(4)
      MH=IM(1)
      MK=IM(2)
      MI=IM(3)
      ML=IM(4)
    ENDIF
    
    IF (test_read_first_order_line.OR.test_read_arbitrary_order_line) THEN
      IPNT=12
      DO I=1,IDIG
        Iten=IABS(IM(IDIG-I+1))/10
        Inext=IABS(IM(IDIG-I+1))-Iten*10
        PLABEL(OPT)(IPNT:IPNT)=CHAR(48+Inext)
        IPNT=IPNT-1
        IF (Iten.GT.0) THEN
          PLABEL(OPT)(IPNT:IPNT)=CHAR(48+Iten)
          IPNT=IPNT-1
        ENDIF
        IF (IM(IDIG-I+1).LT.0) THEN
          PLABEL(OPT)(IPNT:IPNT)='-'
          IPNT=IPNT-1
        ENDIF
      ENDDO
      Inext=0
    ENDIF

!
    Time0=SECNDS(0.0)
!MAC		WRITE(*,*)'Time0=',Time0

    IF (Ifeff.EQ.2) THEN ! three beam calulation
      WRITE(*,*) ' Enter REAL time lim.(<=0==inf.)<RET>,'
      WRITE(*,*) ' + I/O char(A1)<RET>'
      READ(*,*) Maxtim
      READ(*,21) numstr(4:4)
      DATFIL(5:5)=numstr(4:4)
      RESN=100000.
      WRITE(*,*) 'Enter (dummy) lambda'
      READ(*,*) dlambda
      Energy=hckeV/dlambda      	! keV.Angstroms
      dlratio=(1.D0-dbeta*DSIN(dalpha+GB(8)))/DSQRT(1.D0-dbeta*dbeta)
      dlambdanew=dlambda*dlratio
      Energynew=hckeV/dlambdanew
      Ilist=-1
      IORDER=NINT(ORDER)
    ELSE ! non three beam calulation

      IF (ORDER.GE.0.5) THEN  ! read stdin input for line info
        IF (AGE.LT.1) THEN
          WRITE(*,*) 'Output (RPI,RSG=sigma.D011) of no(-1),init(0), ' &
              ,	'fin(1),both(2) ranges?'
          READ(*,*)  ANS
        ELSEIF (AGE.EQ.1) THEN
          WRITE(*,*) 'Output no profile(0), or FFRC...(2)'
          READ(*,*) ANS
        ELSE
          WRITE(*,*) 'Output no profile(0),RPP...+RPL...(1),FFRC...(2)' &
              ,	'or both(3)?'
          READ(*,*) ANS
        ENDIF
!old       IF (OPT.GE.4.AND.AGE.EQ.1) AGE=0  
!old       IF (AGE.GE.1.OR.OPT.GT.3) THEN
        WRITE(*,*) 'Enter lambda'
        READ(*,*) dlambda
        Energy=hckeV/dlambda      	! keV.Angstroms
        dlratio=(1.D0-dbeta*DSIN(dalpha+GB(8)))/DSQRT(1.D0-dbeta*dbeta)
        dlambdanew=dlambda*dlratio
        Energynew=hckeV/dlambdanew
!old       ENDIF
        Ilist=-1
        IORDER=NINT(ORDER)
      ELSE ! read file input for line info
        Time2=0.0
        DO I=1,6
          DTIME(I)=0.D0
        ENDDO
        Mtime=1.2D2
        Ntime=0.D0
        IREAD=1
        
        IF (Ifeff.NE.2) THEN ! non three beam calulation
!U95    split WRITE statement into 2 write statements to avoid continuing 
!U95    across two lines
          WRITE(*,*) 'Enter'
          WRITE(*,*) ' Resolution for sequencing, REAL time lim.(<=0==inf.)<RET>,'
          WRITE(*,*) ' +DATFILE<RET>,'
          WRITE(*,*) ' I/O char(A1)<RET>'
          READ(*,*) RESN,Maxtim
          READ(*,18) FILEIN
        ELSE
          WRITE(*,*) 'Enter'
          WRITE(*,*) ' REAL time lim.(<=0==inf.)<RET>,'
          WRITE(*,*) ' + I/O char(A1)<RET>'
          READ(*,*) Maxtim
          RESN=100000.
        ENDIF
18      FORMAT(A11)

        ILEN=LEN(FILEIN)
        DO WHILE (ICHAR(FILEIN(ILEN:ILEN)).LT.40.AND.ILEN.NE.0)
          ILEN=ILEN-1
        ENDDO

        READ(*,21) numstr(4:4)
        DATFIL(5:5)=numstr(4:4)
!Mactest
        WRITE(*,*) 'Data from ',DATFIL,',',FILEIN	!,'Time2=',Time2
21      FORMAT(A1)

        IF (ORDER.LT.-0.5) THEN
          Inext=1
          WRITE(*,*) 'Default o/p of lines 1,4,30,80,81,82'

          DO
            WRITE(*,*) 'Enter -1(default),0(end),or I (in incr.order) for lines'
            READ(*,*) Ilist
            IF (Ilist.EQ.-1) THEN
              Fwrite(1)=1
              Fwrite(2)=4
              Fwrite(3)=30
              Fwrite(4)=80
              Fwrite(5)=81
              Fwrite(6)=82
              Fwrite(7)=0
            ELSE
              Fwrite(Inext)=Ilist
              Inext=Inext+1
            ENDIF

            IF (Ilist.LE.0) THEN
              EXIT
            ENDIF
          ENDDO
          
        ENDIF

!------------------------------------------------------------------------------
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------    
!------------------------------------------------------------------------------
!-----------------  End of main stream input phase ----------------------------
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------

        Inext=1
        Iten=Inext/10
        Isum=1
        numstr='S'//CHAR(48+Iten)//CHAR(48+Inext-Iten*10)//numstr(4:4)
        Ilist=0
        IL=0

! LFS: Added upto the next LFS comment
! LFS: Find the length of the dcom and dcom strings with spaces trimmed off the ends.
        IdcomLEN=LEN(dcom)
        DO WHILE (ICHAR(dcom(IdcomLEN:IdcomLEN)).LT.40.AND.IdcomLEN.NE.0)
          IdcomLEN=IdcomLEN-1
        ENDDO
        
        IdoutLEN=LEN(dout)
        DO WHILE (ICHAR(dout(IdoutLEN:IdoutLEN)).LT.40.AND.IdoutLEN.NE.0)
          IdoutLEN=IdoutLEN-1
        ENDDO
! LFS: End addition

        FILEIN2=FILEIN(1:ILEN)//'.DAT'
!Mactest		WRITE(*,*) FILEIN2
        OPEN (UNIT=4,FILE=dcom(1:IdcomLEN)//FILEIN2,STATUS='OLD') ! The wavelength input file, LFS: Added (1:IdcomLEN)
        WRITE(*,*) 'FILEIN=[',FILEIN, '], ','FILEIN2=[',FILEIN2,']'
        WRITE(*,*) 'unit 4 is [',dcom(1:IdcomLEN)//FILEIN2,']'
        FILEIN2=FILEIN(1:ILEN)//'.OUT'//numstr(4:4)
        OPEN (UNIT=3,FILE=dout(1:IdoutLEN)//FILEIN2,STATUS='UNKNOWN') ! LFS: Added (1:IdoutLEN)
        WRITE(*,*) 'FILEIN=[',FILEIN,'], ','FILEIN2=[',FILEIN2,']'
        WRITE(*,*) 'unit 3 is [',dout(1:IdoutLEN)//FILEIN2,']'
        IF (AGE.GT.1) THEN
          FILEIN2=FILEIN(1:ILEN)//'.OTY'//numstr(4:4)
          OPEN (UNIT=7,FILE=dout(1:IdoutLEN)//FILEIN2,STATUS='UNKNOWN') ! LFS: Added (1:IdoutLEN)
          WRITE(*,*) 'unit 7 is [',dout(1:IdoutLEN)//FILEIN2,']'
        ENDIF
!
!LFS:      I=0
!LFS:25    CONTINUE ! short loop 25-26-27
!LFS:      READ (3,55,END=27) LINE
!LFS:      I=I+1
!LFS:      IF (LINE(2:2).EQ.'L') GOTO 26      ! 'Line' replaces Begin  ! short loop 25-26
!LFS:      GOTO 25 ! short loop 25-26-27
!LFS:26    CONTINUE  ! short loop 25-26-27
!LFS:      !LFS: We are at the Line statement of the OUT file
!LFS:      !LFS: I is the line number of th Line statement in the OUT file    
!LFS:      IL=1
!LFS:27    CONTINUE ! short loop 25-26-27

!LFS:      I=0
!LFS:25    CONTINUE ! start short loop with try catch 25-27
!LFS:      READ (3,55,END=27) LINE
!LFS:      I=I+1
!LFS:      IF (LINE(2:2).NE.'L') THEN ! 'Line' replaces Begin  ! short loop with try catch 25-27
!LFS:        GOTO 25 ! end short loop with try catch 25-27
!LFS:      ENDIF
!LFS:      !LFS: We are at the Line statement of the OUT file
!LFS:      !LFS: I is the line number of th Line statement in the OUT file    
!LFS:      IL=1
!LFS:      GOTO 28
!LFS:27    CONTINUE ! catch of short loop with try-catch 25-27
!LFS:      write(*,*) 'I=',I
!LFS:      BACKSPACE 3
!LFS:28    CONTINUE

        I=0
        DO
          READ (3,55,IOSTAT=Iio_status) LINE
          IF (Iio_status.LT.0) THEN ! EOF
            write(*,*) 'I=',I !debug
            BACKSPACE 3
            EXIT
          ELSE
            I=I+1
            IF (LINE(2:2).EQ.'L') THEN ! 'Line' replaces 'Begin'  ! short loop with try catch 25-27
              IL=1
              EXIT
            ENDIF
          ENDIF
        ENDDO

!          Three if statments follow:
!             IF (I.GT.0)             output wavelength file has lines
!             IF (I.GT.0.OR.IL.EQ.1)  we at the first wavelength in the output wavelength file
!             IF (I.LE.0.AND.IL.NE.1) output wavelength file is empty

!91
        IF (I.GT.0) THEN
          DO J=1,I-IDELN            ! get to the first wavelength of the input wavelength file
            READ (4,55) LINE
            IF (LINE(1:1).EQ.'B') EXIT      ! Begin
          ENDDO

          IF (AGE.GT.1) THEN ! not ifp or ffi calc
            DO J=1,I            	! include output lines
              READ (7,55,IOSTAT=Iio_status) LINE	! 4:I,5:I,7:I
              IF (Iio_status.LT.0) EXIT
            ENDDO
          ENDIF
!		      Cycle through lines
          I=0
          DO ! read last wavelength from output wavelength file
            READ (3,2430,IOSTAT=Iio_status) ISEQUENCE,OLDORDER,LINE(1:9),RFL(3),RFL2(3),RI1(3),RI2(3),LINE(10:33),IORDER
            IF (Iio_status.LT.0) EXIT
            I=I+1
          ENDDO

        ENDIF
!91
        IF (I.GT.0.OR.IL.EQ.1) THEN
          IF (I.GT.0) THEN
          
            DO J=1,2*I
!V....scanning
              IF (dbetaread.LE.-1.D0.AND.dbetaread.GT.-2.D0) THEN ! -2 < dbetaread <= -1
                READ (4,72) OLD2ORDER,LINE,IORDER,RUBBISH,dbeta
              ELSEIF (dbetaread.EQ.-2.D0) THEN                    !  dbetaread == -2
                READ (4,72) OLD2ORDER,LINE,IORDER,RUBBISH,GB(5)
              ELSEIF (dbetaread.LT.-2.D0) THEN                    !  dbetaread > -2
                READ (4,73) OLD2ORDER,LINE,IORDER,RUBBISH,dbeta,GB(5)
              ELSE                                                ! -1 < dbetaread
                READ (4,70) OLD2ORDER,LINE,IORDER
              ENDIF
!V
              IF (OLD2ORDER.EQ.OLDORDER) EXIT
            ENDDO

            IF (AGE.GT.1) THEN ! not ifp or ffi calc
            
              DO J=1,I
                READ (7,2430,IOSTAT=Iio_status) I2SEQ,OLD2ORDER,LINE(1:9),RFL(3),RFL2(3),RI1(3),RI2(3),LINE(10:33),IORDER
                IF (OLD2ORDER.EQ.OLDORDER.OR.Iio_status.LT.0) THEN
                  EXIT
                ENDIF
              ENDDO

            ENDIF
          ENDIF
          
          ! set 'numstr'
          Ilist=I
          DO Inext=1,20
            IF (Fwrite(Inext).GT.Ilist) EXIT
            IF (Fwrite(Inext).EQ.0) EXIT
          ENDDO
          Iten=Inext/10
          Isum=Inext
          numstr='S'//CHAR(48+Iten)//CHAR(48+Isum-Iten*10)//numstr(4:4)

        ENDIF
        
!91      plabel(5) input from data file earlier
        IF (I.LE.0.AND.IL.NE.1) THEN ! if the file didn't exist, write the headers
          I=0

          DO ! write all lines in the input wavelength file before the 'Begin' into the output wavelength file
            READ (4,55) LINE
            I=I+1
55          FORMAT(A80)
            IF (LINE(1:1).NE.'B') THEN
              WRITE(3,56) (LINE(J*10+1:J*10+10),J=0,7)
              IF (AGE.GT.1) THEN
                WRITE(7,56) (LINE(J*10+1:J*10+10),J=0,7)
              ENDIF
56            FORMAT(1X,8(A10))
            ELSE
              EXIT
            ENDIF
          ENDDO
          Ilist=0
!91		Output run parameters common for all lines:
!UJun96:   Minor format changes:
          !Print line 1
          WRITE(*,57) PLABEL(OPT),AGE,NINT(RESN),aplane,dalpha,dbeta,MaxT2
          WRITE(3,57) PLABEL(OPT),AGE,NINT(RESN),aplane,dalpha,dbeta,MaxT2

          IF (AGE.GT.1) THEN
            WRITE(7,571) PLABEL(OPT),AGE,NINT(RESN),aplane,dalpha,dbeta,MaxT2
          ENDIF
57        FORMAT(2X,A12,',AGE=',I2,',resn=',I5,',aplane=' &
              ,F5.2,',alpha=',F5.2,',beta=',F6.4,',T=',1PE9.2)
571       FORMAT(2X,A12,',AGE=',I2,',resn=',I5,',aplane=' &
              ,F5.2,',alpha=',F5.2,',beta=',F6.4,',T=',1PE9.2,',Yshift')

          !Print line 2
          IF (Photo.EQ.1) THEN
            WRITE(*,574) fscale,attest,Iprecs,Iffsource,iGLorder,xTemp,emultype
            WRITE(3,574) fscale,attest,Iprecs,Iffsource,iGLorder,xTemp,emultype
            IF (AGE.GT.1) THEN
              WRITE(7,574) fscale,attest,Iprecs,Iffsource,iGLorder,xTemp,emultype
            ENDIF
574         FORMAT(3X,'f1(0)x',F5.2,',site test=',I1,',precn=',I2 &
                   ,',f1 from ',I2,',B/C order=',I2,',Temp=',F8.2,',emul=',I1)
          ELSE
            WRITE(*,575) fscale,attest,Iprecs,Iffsource,iGLorder,xTemp
            WRITE(3,575) fscale,attest,Iprecs,Iffsource,iGLorder,xTemp
            IF (AGE.GT.1) THEN
              WRITE(7,575) fscale,attest,Iprecs,Iffsource,iGLorder,xTemp
            ENDIF
575         FORMAT(3X,'f1(0)x',F5.2,',site test=',I1,',precn=',I2 &
                   ,',f1 from ',I2,',B/C order=',I2,',Temp=',F8.2)
          ENDIF


!B
          IF (AGE.GT.1) THEN
            IF (Bragg.EQ.1) THEN
              WRITE(*,58) GB(1),2.D0*Rzf,Cx,maxdp+maxdm,GB(6),GB(5),GB(8),swidth,datef
              WRITE(3,58) GB(1),2.D0*Rzf,Cx,maxdp+maxdm,GB(6),GB(5),GB(8),swidth,datef
              WRITE(7,58) GB(1),2.D0*Rzf,Cx,maxdp+maxdm,GB(6),GB(5),GB(8),swidth,datef
58            FORMAT(3X,'2Rz(c,f)=',2(1PE9.2,','),'Cx(c-f)=',1PE9.2,',Crystal arc=',1PE9.2,/ &
                    ,3X,'BXz,BDz,a_Bm=',3(1PE9.2,','),'beam fwhm=',1PE9.2,1X,A25)
            ELSE
              WRITE(*,585) GB(1),Rzf,Cx,maxdp+maxdm,GB(6),GB(5),GB(8),swidth,datef
              WRITE(3,585) GB(1),Rzf,Cx,maxdp+maxdm,GB(6),GB(5),GB(8),swidth,datef
              WRITE(7,585) GB(1),Rzf,Cx,maxdp+maxdm,GB(6),GB(5),GB(8),swidth,datef
585           FORMAT(3X,'2Rz,PZ=',2(1PE9.2,','),'Cx(c-f)=',1PE9.2,',Crystal arc=',1PE9.2,/ &
                    ,3X,'BXz,BDz,a_Bm=',3(1PE9.2,','),'beam fwhm=',1PE9.2,1X,A25)
            ENDIF
!L
            IF (dbetaread.GT.-1.D0.OR.dbetaread.EQ.-2.D0) THEN
              dlratio=(1.D0-dbeta*DSIN(dalpha+GB(8)))/DSQRT(1.D0-dbeta*dbeta)
              WRITE(*,59) dlratio
              WRITE(3,59) dlratio
              WRITE(7,59) dlratio
            ENDIF
59          FORMAT(2X,' lambda(lab=real)/lambda(beam)=',1PE9.2 &
                   ,',dlambda/l=dtheta/tantheta,dtheta=dY/2R')
          ENDIF
!91
          WRITE(3,61)
          IF (AGE.GT.1)THEN
            WRITE(7,62)
          ENDIF
          
61        FORMAT(' Line:lambda,err,',8X,'Int.Refl.(Sig,Pi),',4X, &
                 'Yiz Corr(Sig,Pi),',3X,'Description,Diffn Order,MeanTh/deg')
62        FORMAT(' Line:lambda,err,',8X,'Int.Refl.(Sig,Pi),',4X, &
                 'RI th.Corr(Sig,Pi),',1X,'Description,Diffn Order:')
        ENDIF
        
      ENDIF ! read file input for line info
    
    ENDIF ! not three beam
    
!		Reading, first line or writing all
!92		at beginning of run
    IF (Ifeff.EQ.1) THEN  ! Include simple estimates

      OPEN(UNIT=12,FILE=dout//'MShift1.'//PLABEL(OPT)(1:5)// &
          PLABEL(OPT)(10:12),STATUS='UNKNOWN')
      OPEN(UNIT=13,FILE=dout//'MShift2.'//PLABEL(OPT)(1:5)// &
          PLABEL(OPT)(10:12),STATUS='UNKNOWN')
      OPEN(UNIT=14,FILE=dout//'MShift3.'//PLABEL(OPT)(1:5)// &
          PLABEL(OPT)(10:12),STATUS='UNKNOWN')
      OPEN(UNIT=15,FILE=dout//'MShift4.'//PLABEL(OPT)(1:5)// &
          PLABEL(OPT)(10:12),STATUS='UNKNOWN')

      IF (AGE.GT.1) THEN
        OPEN(UNIT=16,FILE=dout//'MShift5.'//PLABEL(OPT)(1:5)// &
            PLABEL(OPT)(10:12),STATUS='UNKNOWN')
        OPEN(UNIT=17,FILE=dout//'MShift6.'//PLABEL(OPT)(1:5)// &
            PLABEL(OPT)(10:12),STATUS='UNKNOWN')
        OPEN(UNIT=18,FILE=dout//'MShift7.'//PLABEL(OPT)(1:5)// &
            PLABEL(OPT)(10:12),STATUS='UNKNOWN')
      ENDIF
      

      DO
        READ(12,55,END=621) LINE
      ENDDO
621   CONTINUE ! short loop 620-621

      DO
        READ(13,55,END=622) LINE
      ENDDO
622   CONTINUE ! short loop

      DO
        READ(14,55,END=623) LINE
      ENDDO
623   CONTINUE ! short loop

      DO
        READ(15,55,END=624) LINE
      ENDDO
624   CONTINUE ! short loop

      IF (AGE.GT.1) THEN
        DO
          READ(16,55,END=625) LINE
        ENDDO
625     CONTINUE ! short loop

        DO
          READ(17,55,END=626) LINE
        ENDDO
626     CONTINUE ! short loop

        DO
          READ(18,55,END=627) LINE
        ENDDO
627     CONTINUE ! short loop

      ENDIF

    ENDIF
    
!----------------END BLOCK 2-------------------------


!------------------------------------------------------------------------------  
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------
!-------------------  big loop over input lines  ------------------------------
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------
!------------------------------------------------------------------------------
    DO

!----------------START BLOCK 3-------------------------

      IF (IREAD.EQ.1) THEN
        dlambda=-1.0
!V....scanning


        !LFS:68    CONTINUE ! short loop 68
        !LFS:      ! Read line wavelength, line description, diffraction order, etc
        !LFS:      IF (dbetaread.LE.-1.D0.AND.dbetaread.GT.-2.D0) THEN
        !LFS:        READ (4,72,END=691) OLD2ORDER,LINE,IORDER,RUBBISH,dbeta
        !LFS:      ELSEIF (dbetaread.EQ.-2.D0) THEN
        !LFS:        READ (4,72,END=691) OLD2ORDER,LINE,IORDER,RUBBISH,GB(5)
        !LFS:      ELSEIF (dbetaread.LT.-2.D0) THEN
        !LFS:        READ (4,73,END=691) OLD2ORDER,LINE,IORDER,RUBBISH,dbeta,GB(5)
        !LFS:      ELSE
        !LFS:        READ (4,70,END=691) OLD2ORDER,LINE,IORDER 
        !LFS:      ENDIF
        !LFS:      GOTO 692  ! skip over the quit
        !LFS:691   CONTINUE ! in short loop 68 - EOF(input)
        !LFS:      Iquit = 2
        !LFS:      GOTO 2550 ! quit becasue read EOF(input)
        !LFS:692   CONTINUE ! in short loop 68
        !LFS:
        !LFS:70    FORMAT(F10.7,A33,I1)
        !LFS:72    FORMAT(F10.7,A33,I1,A8,F9.6)
        !LFS:73    FORMAT(F10.7,A33,I1,A8,2F9.6)
        !LFS:!V
        !LFS:!test       write (*,*) oldorder,old2order
        !LFS:      IF (OLD2ORDER.LE.0.D0.OR.OLD2ORDER.EQ.OLDORDER) THEN
        !LFS:        !skip some lines by looping through the input file
        !LFS:        GOTO 68 ! short loop 68
        !LFS:      ENDIF

        DO
          ! Read line wavelength, line description, diffraction order, etc from wavelength input file
          IF (dbetaread.LE.-1.D0.AND.dbetaread.GT.-2.D0) THEN
            READ (4,72,IOSTAT=Iio_status) OLD2ORDER,LINE,IORDER,RUBBISH,dbeta
          ELSEIF (dbetaread.EQ.-2.D0) THEN
            READ (4,72,IOSTAT=Iio_status) OLD2ORDER,LINE,IORDER,RUBBISH,GB(5)
          ELSEIF (dbetaread.LT.-2.D0) THEN
            READ (4,73,IOSTAT=Iio_status) OLD2ORDER,LINE,IORDER,RUBBISH,dbeta,GB(5)
          ELSE
            READ (4,70,IOSTAT=Iio_status) OLD2ORDER,LINE,IORDER 
          ENDIF

70        FORMAT(F10.7,A33,I1)
72        FORMAT(F10.7,A33,I1,A8,F9.6)
73        FORMAT(F10.7,A33,I1,A8,2F9.6)
          
          IF (Iio_status.LT.0) THEN
            Iquit = 2 ! quit becasue read EOF(input)
            EXIT
          ENDIF

!test       write (*,*) oldorder,old2order
          IF (OLD2ORDER.GT.0.D0.AND.OLD2ORDER.NE.OLDORDER) THEN
            EXIT
          ENDIF
        ENDDO

        IF (Iquit.EQ.2) THEN ! quit becasue read EOF(input)
          EXIT !GOTO 2550 
        ENDIF

      
        Ilist=Ilist+1
        ORDER=DFLOAT(IORDER)
        dlambda=OLD2ORDER/ORDER
!91				precision
        Energy=hckeV/dlambda
        dlratio=(1.D0-dbeta*DSIN(dalpha+GB(8)))/DSQRT(1.D0-dbeta*dbeta)
        dlambdanew=dlambda*dlratio
        Energynew=hckeV/dlambdanew
!       IREAD=1
        ANS=-1
        Time1=SECNDS(0.0)
        IF (Maxtim.LT.DBLE(Time1-Time0)+DMAX1(DTIME(IORDER)*1.3D0,Mtime*1.5D0*ORDER) &
            .AND.Maxtim.GT.0.D0) THEN
          WRITE(*,*) 'Finishing run, Elapsed time=',Time1-Time0, &
                     ',No. of lines=',IDNINT(Ntime),'Last running times:'
          DO I=1,6
            IF (DTIME(I).GT.0.D0) WRITE(*,*) 'Order=',I,':T=',DTIME(I)
          ENDDO
          CLOSE(4,STATUS='KEEP')
          CLOSE(3,STATUS='KEEP')
          IF (AGE.GT.1) THEN
            CLOSE(7,STATUS='KEEP')
          ENDIF
          STOP
        ENDIF
      ENDIF
      
!Mactest	WRITE(*,*) 'How time flies',Time1
!
!		Evaluation of mufilm
!

      IF (Photo.EQ.1.OR.(AGE.LE.1.AND.Ifeff.EQ.1)) THEN ! emultion or an ifp calc. with simple estimates
        iPhoto=1
        CALL FORMF1      ! Filerddef HENDET, giving muabs(film) - (CS5plate.f)
        mufilm=Mu      ! in /.1microns
      ENDIF
      
      iPhoto=0
!test		WRITE(*,*) age,OPT,ifeff,order,iphoto,photo,ans,idig,
!     1 im(1),im(2),im(idig)
!

!----------------END BLOCK 3-------------------------

! ****************************************************************
! ****************************************************************
! ****************************************************************

      SELECT CASE (OPT)
        CASE (1) ! option for PET crystal
!*****************************************************************************
!
!		PET      C10 O8 H24	Z=1
! FH is the structure factor for the hkl Bragg diffraction,
!	while F0 is the factor for forward scattering.
! Coordinates of atoms are given as elements of arrays xco(J,1-3),
!	as x,y,z-components of the C,H,O atoms in the 
! tetragonal basis set {a,b,c} and J labels the 42 atoms in the unit cell.
! Tetragonal I-4 => posseses an inversion centre?, so OK.
!91	n.b. thermal parameters are from Se;
!	n.b. 'traces of water/mineral acid' may give obs(delta d)
!	Ray Hall v Eilerman & Rudman ... cf. Semmingsen
!
! Introduce components of the basis set. For the (002) reflection 
! we need only the c components, so that r.h = 2z where z is the atomic
! coordinate in units of c the length of the unit cell edge. For the (008)
! reflection r.h = 8z.
!
          a01=6.087		! E v 6.10 Soviet Physics SS4 v Se 6.079(3)
          b01=a01
          c01=8.7358	! R cell edge, v B .743, JML=E .757(2), Se 8.745(4)
          aalph(1)=0.0	! Int.Tab.X-ray Cryst.Vol III, 2.6,p127
          aalph(2)=aalph(1)
          aalph(3)=1.31D-4
!91		thermal expansion
          Tref=293		! T for d-spacing
          IF (xTemp.LT.0.D0) xTemp=Tref
          a02=a01*(1.D0+aalph(1)*(xTemp-Tref))
          b02=b01*(1.D0+aalph(2)*(xTemp-Tref))
          c02=c01*(1.D0+aalph(3)*(xTemp-Tref))
!old       IF (AGE.EQ.0) THEN
!o           dLAMBDANEW = 6.2/ORDER
!o           MH=0
!o           MK=0
!o           ML=2
!o         ENDIF
!		! orthorhombic/tetragonal relation 2d=8.7358 (002)
          d2=2.D0/DSQRT(MH*MH/a02/a02+MK*MK/b02/b02+ML*ML/c02/c02)
          ksp=ORDER/d2
          Volcell=a02*b02*c02
          nalphs=3
          Numcells=1.D30/Volcell
! Number of unit cells per unit volume (m^3)
!		Supplementary parameters for general functions:
          calpha=DPIo2
          cbeta=calpha
          cgamma=calpha
          nbasis=4
          nsites(1)=2
          nsites(2)=8
          nsites(3)=8
          nsites(4)=24
          natoms(1)=1
          natoms(2)=1
          natoms(3)=1
          natoms(4)=1
          atomtype(1,1)=2
          atomtype(2,1)=2
          atomtype(3,1)=3
          atomtype(4,1)=1
          fpop(1,1)=1
          fpop(2,1)=1
          fpop(3,1)=1
          fpop(4,1)=1
          ntherm(1,1)=3
          ntherm(2,1)=6
          ntherm(3,1)=6
          ntherm(4,1)=6
          btherm(1,1,1)=.0119
          btherm(1,1,2)=.0119
          btherm(1,1,3)=.0089
          btherm(2,1,1)=.0225
          btherm(2,1,2)=.0209
          btherm(2,1,3)=.0116
          btherm(2,1,4)=.0068
          btherm(2,1,5)=.0021
          btherm(2,1,6)=-.0066
          btherm(3,1,1)=.0169
          btherm(3,1,2)=.0232
          btherm(3,1,3)=.0213
          btherm(3,1,4)=.0005
          btherm(3,1,5)=-.0042
          btherm(3,1,6)=-.0067
          btherm(4,1,1)=.0407
          btherm(4,1,2)=.0379
          btherm(4,1,3)=.0188
          btherm(4,1,4)=.0283
          btherm(4,1,5)=-.0124
          btherm(4,1,6)=-.0226
!92		End of supplementary parameters
          DO J=1,3
            xco(1,J)=0.0		! x=0,y=0 fixed, defining lattice
            xco(2,J)=0.5
          ENDDO
!			Carbons
          xco(3,1)=0.15837	! (Se) gives .15832(27),.12586(29),-.10388(29)
          xco(3,2)=0.12569
          xco(3,3)=-0.10337	!! C uncertainty (E)= (13)(z); (23)(x); (20)(y)
!			Oxygen
          xco(11,1)=0.31806	!!! (Se) gives .31717(27),.24829(34),-.02029(27)
          xco(11,2)=0.24610	!!!!
          xco(11,3)=-0.01937 !! O uncertainty (E)= (14)(z); (10)(x); (16)(y)
          IF (attest.EQ.1) THEN
            xco(11,1)=.31717
            xco(11,2)=.24829
            xco(11,3)=-.02029
          ENDIF
!			Hydrogens
          xco(19,1)=0.2333	!!!! (Se) gives .24476(82),.01112(71),-.17450(52)
          xco(19,2)=0.0277	!5sd
          xco(19,3)=-0.1700	!! H1 uncertainty (E)=(17)(z); (28)(x); (24)(y)
          xco(27,1)=0.0744	!! (Se) gives .06654(78),.23629(73),-.17684(49)
          xco(27,2)=0.2292	!!
          xco(27,3)=-0.1671	!!!! H2 uncertainty (E)=(19)(z); (34)(x); (28)(y)
          xco(35,1)=0.2723	! (Se) gives .26674(58),.39052(55),-.00104(47)
          xco(35,2)=0.3595	!7sd
          xco(35,3)=-0.0073	!! H2 uncertainty (E)=(23)(z); (25)(x); (37)(y)
!
          DO J=3,35,8
            xco(J+1,1)=-xco(J,1)
            xco(J+1,2)=-xco(J,2)
            xco(J+1,3)=xco(J,3)
            DO I=2,3
              xco(J+I,1)=xco(J,2)
              xco(J+I,2)=-xco(J,1)
              xco(J+I,3)=-xco(J,3)
              xco(J+2+I,1)=0.5+xco(J,1)
              xco(J+2+I,2)=0.5+xco(J,2)
              xco(J+2+I,3)=0.5+xco(J,3)
              xco(J+4+I,1)=0.5-xco(J,1)
              xco(J+4+I,2)=0.5-xco(J,2)
              xco(J+4+I,3)=0.5-xco(J,3)
            ENDDO
          ENDDO
!	 
! Include the atomic scattering factors for C, H, O, put these into an array
! with unused elements (no atomic scatterer) left as zero:
!
          natomtypes=3
          kZed(1)=1
          kZed(2)=6
          kZed(3)=8
          kpop(1)=24.0
          kpop(2)=10.0
          kpop(3)=8.0
!old       IF (AGE.EQ.0) THEN
!o           IF(NINT(ORDER).EQ.1) THEN
!o            F0n(1) =DCMPLX(1.000,0.000031)
!o            Fhn(1) =DCMPLX(0.799,0.000031)
!o           ELSE
!o            F0n(1) =DCMPLX(1.000,0.00000159)
!o            FHn(1) =DCMPLX(0.090,0.00000159)
!o           ENDIF
!o           IF(NINT(ORDER).EQ.1) THEN
!o            F0n(2) =DCMPLX(6.15,0.2)
!o            FHn(2) =DCMPLX(4.94,0.2)
!o           ELSE
!o            F0n(2) =DCMPLX(6.000,0.0134)
!o            FHn(2) =DCMPLX(1.770,0.0134)
!o           ENDIF
!o           IF(NINT(ORDER).EQ.1) THEN
!o            F0n(3) =DCMPLX(8.33,0.55)
!o            FHn(3) =DCMPLX(7.28,0.55)
!o           ELSE
!o            F0n(3) =DCMPLX(8.000,0.0463)
!o            FHn(3) =DCMPLX(2.564,0.0463)
!o           ENDIF
!o         ELSE
!91		kZed passed for communication; NOT cfil
          DO iatom=1,natomtypes
            CALL FORMF ! (CS5plate.f)
            FHn(iatom)=DCMPLX(fh1(iatom),f02(iatom))
            F0n(iatom)=DCMPLX(f01(iatom),f02(iatom))
          ENDDO
!o      ENDIF
!
!91   MW=(136.07/.14899)x2 for PET, RHO=1.390E-4g/cm3 cm/mu,/10=/.1mu
!	 Obsd varn from 1.393-1.363, vs calcd 1.3918/70/36 with 8.757
!	 Se=>1.399: Precision of abc in unit cell =0.35%, mainly da=db?
!		old /136/10*RHO now *Numcells/Na11
          sigscat=(24.*SIG(1,1)*1.00797+10.*SIG(1,2)*12.01115 &
              +8.*SIG(1,3)*15.9994)*(Numcells/Na11)
          siginc=(24.*SIG(2,1)*1.00797+10.*SIG(2,2)*12.01115 &
              +4.*SIG(2,3)*15.9994)*(Numcells/Na11)
!91		Now compute structure factors      
!5-
          CALL FHCALCN(IM,ORDER) ! (CS5plate.f)
!92        The following can now be replaced by CALL FHCALCN(IM,ORDER)
!          FHi=DCMPLX(0.,0.)
!          FHr=DCMPLX(0.,0.)
!			Carbons
!91        n.b. effect on B(T) (over-)estimated by linear extrapolation
!          old beta11=22=33=.0084; vs (Se) U11=224(14)E-4/a02/a02*pi*pi*2
!          THERM=DEXP(-(MH*MH*.0119+MK*MK*.0119+ML*ML*.0089 &
!                     )*ORDER*ORDER*xTemp/Tref)		!mean pars,room temp,correct!
!          DO 910 J=1,2
!           FHr=FHr+DCMPLX(fh1(2)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
!               2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
!           FHi=FHi+DCMPLX(f02(2)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
!               2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
!910       CONTINUE
!          THERM=DEXP(-( MH*MH*.0225+MK*MK*.0209+ML*ML*.0116-MH*MK*.0066 &
!                       +MH*ML*.0068+MK*ML*.0021)*ORDER*ORDER*xTemp/Tref)	!mean pars,293K
!          DO 911 J=3,10
!           FHr=FHr+DCMPLX(fh1(2)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
!               2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
!           FHi=FHi+DCMPLX(f02(2)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
!               2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
!911       CONTINUE
!		Oxygens: therm vs B=-1.0
!          THERM=DEXP(-(MH*MH*.0169+MK*MK*.0232+ML*ML*.0213-MH*MK*.0067 &
!                      +MH*ML*.0005-MK*ML*.0042)*ORDER*ORDER*xTemp/Tref)		!293K
!          DO 915 J=11,18
!           FHr=FHr+DCMPLX(fh1(3)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
!               2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
!           FHi=FHi+DCMPLX(f02(3)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
!               2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
!915       CONTINUE
!   		Hydrogens: therm vs B=-3.2 vs (Se):
!	    H(1) Uij: 764(24),713(22),728(21),-212(22),379(19),-166(23)
!	    H(2) Uij: 710(28),726(21),756(22),-138(22),-85(21),-315(22)
!	    H(3) Uij: 551(17),390(20),849(21),-68(14),65(18),-18(19)
!
!          THERM=DEXP(-(MH*MH*.0407+MK*MK*.0379+ML*ML*.0188-MH*MK*.0226 &
!                      +MH*ML*.0283-MK*ML*.0124)*ORDER*ORDER*xTemp/Tref)		!293K
!          DO 920 J=19,42
!           FHr=FHr+DCMPLX(fh1(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
!               2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
!           FHi=FHi+DCMPLX(f02(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
!               2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
!920       CONTINUE
!92			End of potential replacement.
!	 Use these structure factors to compute the PSI variables:
!

        CASE (2) ! option for KAP crystal
!*************************************************************************
!
!	KAP. Potassium Acid Phthallate C32O16H20K4, orthorhombic, Z=1
! P2-fold screw axis,a,b glides => no inv. centre? (except for 002n...)
!	P2sub1ab. Coordinates of the atoms in the unit cell (Okaya...):
          xco(1,1)=0.00561
          xco(1,2)=-0.17780
          xco(1,3)=0.21761	! C uncertainty (O)=(310)(z); (300)(x); (330)(y)
!92			xco rearrangement update
          xco(5,1)=-.23842
          xco(5,2)=.06887
          xco(5,3)=0.15685	! C uncertainty (O)=(270)(z); (270)(x); (250)(y)
!			Carbons/Benzene ring:
          xco(9,1)=-.02519
          xco(9,2)=-.05921
          xco(9,3)=0.28937	! C uncertainty (O)=(290)(z); (280)(x); (300)(y)
          xco(13,1)=.06263
          xco(13,2)=-.06367
          xco(13,3)=0.38466	! C uncertainty (O)=(340)(z); (330)(x); (380)(y)
          xco(17,1)=.03824
          xco(17,2)=.04731
          xco(17,3)=0.45050	! C uncertainty (O)=(330)(z); (320)(x); (440)(y)
          xco(21,1)=-.07350
          xco(21,2)=.16280
          xco(21,3)=0.42058	! C uncertainty (O)=(350)(z); (340)(x); (400)(y)
          xco(25,1)=-.15805
          xco(25,2)=.16928
          xco(25,3)=0.32513	! C uncertainty (O)=(340)(z); (330)(x); (330)(y)
          xco(29,1)=-.13588
          xco(29,2)=.05799
          xco(29,3)=0.25841	! C uncertainty (O)=(290)(z); (270)(x); (290)(y)
!			Oxygens
          xco(33,1)=0.07871
          xco(33,2)=-.29831
          xco(33,3)=0.26258	! O uncertainty (O)=(250)(z); (230)(x); (230)(y)
          xco(37,1)=0.01748
          xco(37,2)=-.16109
          xco(37,3)=0.12732	! O uncertainty (O)=(240)(z); (230)(x); (270)(y)
          xco(41,1)=-.15861
          xco(41,2)=.14522
          xco(41,3)=0.09314	! O uncertainty (O)=(240)(z); (230)(x); (240)(y)
          xco(45,1)=-.40385
          xco(45,2)=.00006
          xco(45,3)=0.14401	! O uncertainty (O)=(230)(z); (220)(x); (240)(y)
!			Hydrogens
          xco(49,1)=0.038
          xco(49,2)=-.380
          xco(49,3)=0.235	! H uncertainty (O)=(4+)(z); (4+)(x); (4+)(y)
          xco(53,1)=0.140
          xco(53,2)=-.146
          xco(53,3)=0.400	! H uncertainty (O)=(4+)(z); (4+)(x); (4+)(y)
          xco(57,1)=0.096
          xco(57,2)=0.048
          xco(57,3)=0.521	! H uncertainty (O)=(4+)(z); (4+)(x); (4+)(y)
          xco(61,1)=-.091
          xco(61,2)=0.237
          xco(61,3)=0.464	! H uncertainty (O)=(4+)(z); (4+)(x); (4+)(y)
          xco(65,1)=-.231
          xco(65,2)=0.252
          xco(65,3)=0.304	! H uncertainty (O)=(4+)(z); (4+)(x); (4+)(y)
!			Potassium site
          xco(69,1)=0.25000
          xco(69,2)=0.09898
          xco(69,3)=0.03878	! K uncertainty (O)=(70)(z); (70)(x); (70)(y)
          IF (attest.EQ.1) THEN
            xco(69,1)=xco(69,1)+.00070
            xco(69,2)=xco(69,2)+.00070
            xco(69,3)=xco(69,3)+.00070
          ENDIF
          DO I=1,69,4
            xco(1+I,1)=0.5+xco(I,1)
            xco(1+I,2)=0.5-xco(I,2)
            xco(1+I,3)=xco(I,3)
            xco(I+2,1)=0.5+xco(I,1)
            xco(I+2,2)=1.00-xco(I,2)
            xco(I+2,3)=1.00-xco(I,3)
            xco(I+3,1)=xco(I,1)
            xco(I+3,2)=0.5+xco(I,2)
            xco(I+3,3)=1.00-xco(I,3)
          ENDDO
!
          a01=6.46	!(6); Bearden/Huffman Rev.Sci.Inst. 34(1963)1233-4:
          b01=9.60	!(9)		gives 6.47, 9.62.
          c01=13.3164
! The 2d spacing of KAP 001 is 26.632 (LLNL vs O: 27.70(14)) 
          aalph(1)=4.0E-5	! No reference; estd from hydrogenous crystals
          aalph(2)=aalph(1)
          aalph(3)=4.050E-5	! (45)
          nalphs=3
!91		thermal expansion
          Tref=293		! T for d-spacing
          IF (xTemp.LT.0.0) xTemp=Tref
          a02=a01*(1.0+aalph(1)*(xTemp-Tref))
          b02=b01*(1.0+aalph(2)*(xTemp-Tref))
          c02=c01*(1.0+aalph(3)*(xTemp-Tref))
!old       IF (AGE.EQ.0) THEN
!o          dLAMBDANEW = 11.37/ORDER
!o          MH=0
!o          MK=0
!o          ML=1
!o         ENDIF
!		! orthorhombic/tetragonal relation 2d=8.7358 (002)
          d2=2./DSQRT(MH*MH/a02/a02+MK*MK/b02/b02+ML*ML/c02/c02)
          ksp=ORDER/d2
          Volcell=a02*b02*c02
          Numcells=1.D30/Volcell
! Number of unit cells per unit volume (1.206E27)
!
!		Supplementary parameters for general functions:
!91:		Old equivalents:
!          nbasis=4		! Okaya gives thermal pars for 18 basis sites
!          nsites(1)=32	! - each with nsites=4
!          nsites(2)=16
!          nsites(3)=20
!          nsites(4)=4
!91:		Emended as thermal parameters were only 50% accurate
!92			Following Okaya:
          calpha=DPIo2
          cbeta=calpha
          cgamma=calpha
          nbasis=18
          DO I=1,nbasis
            nsites(I)=4
            natoms(I)=1
            fpop(I,1)=1.
            IF (I.LT.9) THEN
              atomtype(I,1)=2
              ntherm(I,1)=6
            ELSEIF(I.LE.12) THEN
              atomtype(I,1)=3
              ntherm(I,1)=6
            ELSEIF(I.LE.17) THEN
              atomtype(I,1)=1
              ntherm(I,1)=1
            ELSE
              atomtype(I,1)=4
              ntherm(I,1)=6
            ENDIF
          ENDDO
!92			Carbons: current accuracy circa 10%
          btherm(1,1,1)=.01194
          btherm(1,1,2)=.00736
          btherm(1,1,3)=.00336
          btherm(1,1,4)=-.00148
          btherm(1,1,5)=-.00038
          btherm(1,1,6)=.00425
          btherm(2,1,1)=.01074
          btherm(2,1,2)=.00461
          btherm(2,1,3)=.00336
          btherm(2,1,4)=-.00042
          btherm(2,1,5)=-.00002
          btherm(2,1,6)=.00260
          btherm(3,1,1)=.01064
          btherm(3,1,2)=.00574
          btherm(3,1,3)=.00305
          btherm(3,1,4)=.00045
          btherm(3,1,5)=.00069
          btherm(3,1,6)=.00045
          btherm(4,1,1)=.01605
          btherm(4,1,2)=.00897
          btherm(4,1,3)=.00322
          btherm(4,1,4)=-.00164
          btherm(4,1,5)=.00067
          btherm(4,1,6)=.00159
          btherm(5,1,1)=.01647
          btherm(5,1,2)=.01122
          btherm(5,1,3)=.00342
          btherm(5,1,4)=-.00135
          btherm(5,1,5)=-.00215
          btherm(5,1,6)=-.00235
          btherm(6,1,1)=.01479
          btherm(6,1,2)=.00974
          btherm(6,1,3)=.00402
          btherm(6,1,4)=.00196
          btherm(6,1,5)=-.00405
          btherm(6,1,6)=-.00297
          btherm(7,1,1)=.01353
          btherm(7,1,2)=.00638
          btherm(7,1,3)=.00439
          btherm(7,1,4)=.00168
          btherm(7,1,5)=-.00191
          btherm(7,1,6)=.00016
          btherm(8,1,1)=.00940
          btherm(8,1,2)=.00582
          btherm(8,1,3)=.00296
          btherm(8,1,4)=.00050
          btherm(8,1,5)=.00006
          btherm(8,1,6)=-.00073
!92			Oxygen:
          btherm(9,1,1)=.02048
          btherm(9,1,2)=.00588
          btherm(9,1,3)=.00404
          btherm(9,1,4)=.00236
          btherm(9,1,5)=.00097
          btherm(9,1,6)=.00539
          btherm(10,1,1)=.02475
          btherm(10,1,2)=.00842
          btherm(10,1,3)=.00321
          btherm(10,1,4)=-.00035
          btherm(10,1,5)=-.00045
          btherm(10,1,6)=.00744
          btherm(11,1,1)=.01835
          btherm(11,1,2)=.00720
          btherm(11,1,3)=.00395
          btherm(11,1,4)=.00167
          btherm(11,1,5)=.00290
          btherm(11,1,6)=-.00017
          btherm(12,1,1)=.01202
          btherm(12,1,2)=.00701
          btherm(12,1,3)=.00393
          btherm(12,1,4)=-.00251
          btherm(12,1,5)=-.00110
          btherm(12,1,6)=-.00280
!92			Hydrogen:
          btherm(13,1,1)=4.8
          btherm(14,1,1)=2.2
          btherm(15,1,1)=5.0
          btherm(16,1,1)=1.6
          btherm(17,1,1)=2.4
!92			K
          btherm(18,1,1)=.01293
          btherm(18,1,2)=.00800
          btherm(18,1,3)=.00436
          btherm(18,1,4)=.00045
          btherm(18,1,5)=-.00418
          btherm(18,1,6)=.00094
!92		End of supplementary parameters
          natomtypes=4
          kZed(1)=1
          kZed(2)=6
          kZed(3)=8
          kZed(4)=19
          kpop(1)=20.0
          kpop(2)=32.0
          kpop(3)=16.0
          kpop(4)=4.0
!
! Atomic scattering factors from Henke et. al. are;
!
!old       IF (AGE.EQ.0) THEN
!o          F0n(1)=DCMPLX(1.0,0.00014)
!o          IF(NINT(ORDER).EQ.2) THEN
!o            FHn(1)=DCMPLX(0.914,0.00014)
!o          ELSE
!o            FHn(1)=DCMPLX(0.977,0.00014)
!o          ENDIF
!o          F0n(2)=DCMPLX(6.32,0.5)
!o          IF(NINT(ORDER).EQ.2) THEN
!o            FHn(2)=DCMPLX(5.78,0.5)
!o          ELSE
!o            FHn(2)=DCMPLX(6.18,0.5)
!o          ENDIF
!o          F0n(3)=DCMPLX(8.3,1.5)
!o          IF(NINT(ORDER).EQ.2) THEN
!o            FHn(3)=DCMPLX(7.56,1.5)
!o          ELSE
!o            FHn(3)=DCMPLX(8.18,1.5)
!o          ENDIF
!o          F0n(4)=DCMPLX(18.75,3.5)
!o          IF(NINT(ORDER).EQ.2) THEN
!o            FHn(4)=DCMPLX(17.24,3.5)
!o          ELSE
!o            FHn(4)=DCMPLX(18.27,3.5)
!o          ENDIF
!o         ELSE
!91		kZed passed for communication; NOT cfil
          DO iatom=1,natomtypes
            CALL FORMF ! (CS5plate.f)
          ENDDO
          fh1(4)=fh1(4)*fscale		! for testing
          f01(4)=f01(4)*fscale
          f02(4)=f02(4)*fscale
          DO iatom=1,natomtypes
            FHn(iatom)=DCMPLX(fh1(iatom),f02(iatom))
            F0n(iatom)=DCMPLX(f01(iatom),f02(iatom))
          ENDDO
!o         ENDIF
!91        MW=(204.22865)x4 for KAP, RHO=1.6357E-4g/cm3 cm/mu,/10=/.1mu
!	    vs calcd 1.6427: drho=.43%, well within exp ab errors (1%)
          sigscat=((20.*SIG(1,1)*1.00797+32.*SIG(1,2)*12.01115 &
              +16.*SIG(1,3)*15.9994+4.*SIG(1,4)*39.102)*(Numcells/Na11))
          siginc=((20.*SIG(2,1)*1.00797+32.*SIG(2,2)*12.01115 &
              +16.*SIG(2,3)*15.9994+4.*SIG(2,4)*39.102)*(Numcells/Na11))
!	   Compute structure factors:
!92         The following should now be replaced by CALL FHCALCN(IM,ORDER):
          FHi=DCMPLX(0.,0.)
          FHr=DCMPLX(0.,0.)
!              Ave. thermal parameters from structure: Carbons
!91            n.b. effect on B(T) over-estimated by linear extrapolation
          THERM=DEXP(-(MH*MH*.01294+MK*MK*.00748+ML*ML*.00347+MK*MH*.00044- &
              MH*ML*.00004-MK*ML*.00089)*ORDER*ORDER*xTemp/Tref) !mean pars,293K
          DO J=1,32
            FHr=FHr+DCMPLX(fh1(2)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(f02(2)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
          ENDDO
!			Oxygens
          THERM=DEXP(-(MH*MH*.01890+MK*MK*.00713+ML*ML*.00378+MK*MH*.00247+ &
              MH*ML*.00030-MK*ML*.00113)*ORDER*ORDER*xTemp/Tref) !mean pars,293K
          DO J=33,48
            FHr=FHr+DCMPLX(fh1(3)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(f02(3)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
          ENDDO
!			Hydrogens
          THERM=DEXP(-3.2/d2/d2*ORDER*ORDER*xTemp/Tref) !mean pars,293K
          DO J=49,68
            FHr=FHr+DCMPLX(fh1(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(f02(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
          ENDDO
!			Potassium
          THERM=DEXP(-(MH*MH*.01293+MK*MK*.00800+ML*ML*.00436+MK*MH*.00094+ &
              MH*ML*.00045-MK*ML*.00418)*ORDER*ORDER*xTemp/Tref) !mean pars,293K
          DO J=69,72
            FHr=FHr+DCMPLX(fh1(4)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(f02(4)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
          ENDDO
!92			End of intended replacement
      
        CASE (3) ! option for Si crystal
!****************************************************************************
!	
! For Si the structure is not Face Centred Cubic (inc.inv.centre) I-4d
!	but rhombohedral (!)
! The coordinates of the atoms in the unit cell are written in the form
! xco(i,1-3) where
! x,y,z are the coordinates of the ith atom in the Cartesian system:
!			  Basic lattice:
          xco(1,1) = 0.0	! attest has no effect
          xco(1,2) = 0.0
          xco(1,3) = 0.0
          xco(2,1) = 0.5
          xco(2,2) = 0.5
          xco(2,3) = 0.0
          xco(3,1) = 0.5
          xco(3,2) = 0.0
          xco(3,3) = 0.5
          xco(4,1) = 0.0
          xco(4,2) = 0.5
          xco(4,3) = 0.5
!         plus interpenetration for diamond lattice
          DO I=1,4
            DO J=1,3
              xco(I+4,J)=xco(I,J)+.25
            ENDDO
          ENDDO
!
!         The unit cell edge dimension is
          a01=5.4310196	! (11)1986 adj./PDB v D5.4310279 v AH5.43044
          b01=a01
          c01=a01
          Tref=291		! T for d-spacing
          aalph(1)=2.56E-6	! (3),18C, cf. 3-4.5E-6K-1 (700oC)
          aalph(2)=aalph(1)
          aalph(3)=aalph(1)
          nalphs=3
!91		thermal expansion
          IF (xTemp.LT.0.0) xTemp=Tref
          a02=a01*(1.0+aalph(1)*(xTemp-Tref))
          b02=b01*(1.0+aalph(2)*(xTemp-Tref))
          c02=c01*(1.0+aalph(3)*(xTemp-Tref))
          Volcell=a02*b02*c02
          Numcells=1.D30/Volcell	! 6.2424E27
!         Number of unit cells per unit volume
          d2=2.0*a02/DSQRT(MH*MH+MK*MK+ML*ML)      ! 2d (FCC basis v rhomb)
          ksp=ORDER/d2
!old      IF (AGE.EQ.0) dLAMBDANEW = 4.76/ORDER
!		Supplementary parameters for general functions:
          calpha=DPIo2
          cbeta=calpha
          cgamma=calpha
          nbasis=1
          nsites(1)=8
          natoms(1)=1
          atomtype(1,1)=1
          fpop(1,1)=1
          ntherm(1,1)=3
!		Note: Hart+ (Price, Maslen, Mair 78) B=0.4676(14)A^2
!		 or beta=3.965E-3
!		Saka/Kato (data, 1986) M=3.877E-3(h^2+k^2+l^2)
          btherm(1,1,1)=.003877
          btherm(1,1,2)=.003877
          btherm(1,1,3)=.003877
!	  Atomic scattering factors and structure factors for Si:
          natomtypes=1
          kZed(1)=14
          kpop(1)=8.0
          iatom=1
!old       IF (AGE.EQ.0) THEN
!o          IF(NINT(ORDER).EQ.1) THEN
!o           f01(1)=14.03
!o           f02(1)=2.35
!o           fh1(1)=10.57
!o            ELSE
!o           f01(1)=14.14
!o           f02(1)=0.19
!o           fh1(1)=5.13
!o          END IF
!o         ELSE
          CALL FORMF ! (CS5plate.f)
!o         ENDIF
          fh1(iatom)=fh1(iatom)*fscale
          F0n(iatom)=DCMPLX(f01(iatom),f02(iatom))
          FHn(iatom)=DCMPLX(fh1(iatom),f02(iatom))
!91        MW=(28.09)x8 for Si, RHO=2.3294E-4g/cm3 cm/mu,/10=/.1mu
          sigscat=SIG(1,1)/10.*2.3294D-4
          siginc=SIG(2,1)/10.*2.3294D-4
!92         The following should now be replaced by CALL FHCALCN(IM,ORDER):
          FHi=DCMPLX(0.,0.)
          FHr=DCMPLX(0.,0.)
          THERM=DEXP(-0.4676*(ORDER/d2)**2*xTemp/Tref) 	! B, 293K (PMM)
!KAP?      THERM=DEXP(-(MH*MH*.01293+MK*MK*.00800+ML*ML*.00436+MK*MH*.00094+ &
!KAP?                   MH*ML*.00045-MK*ML*.00418)*ORDER*ORDER*xTemp/Tref) !mean pars,293K
!err?      THERM=DEXP(-.01057*(a01/DSQRT(8.)/d2*ORDER)**2)
!	   n.b. effect on B(T) over-estimated by linear extrapolation
!	   For silicon, this is nearly constant below 290K:
!	   B_0=B_20=.16(5),B_93=.18(5),B_293=.31-.40; Sears=.52(2)
!	   exp_293(1988)=.45(2);.463(4)(Deutsch,Hart,<888);.509(4)(>101010)
!	   assume mean pars,room temp, Ref. 440 BATTERMAN/CHIPMAN!
          DO I=1,8
            FHr=FHr+DCMPLX(fh1(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(I,1)*MH+xco(I,2)*MK+xco(I,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(f02(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(I,1)*MH+xco(I,2)*MK+xco(I,3)*ML)*ORDER))
          ENDDO
!92		End of intended replacement.
!test      WRITE(*,*) FHr,FHi,idig,order,IM,THERM,I
! Use these structure factors to compute the PSI variables:
!

        CASE (4) ! option for ADP crystal
!************************************************************************
!	ADP NH4 H2PO4      Tetragonal, Z=4, inc.inv.centre I-42d
!		Tenzer; Khan...
!
          IF (attest.EQ.1) THEN	! O site
            xco(1,1)=0.0843
            xco(1,2)=0.1466
            xco(1,3)=0.1151
          ELSE
            xco(1,1)=0.085
            xco(1,2)=0.146
            xco(1,3)=0.115
          ENDIF
          xco(17,1)=0.014		! H site
          xco(17,2)=0.111
          xco(17,3)=0.573
          xco(33,1)=0.227		! H site, 0.5 occupancy
          xco(33,2)=0.146
          xco(33,3)=0.122
!	   uncertainties/x2=(10,not 1),(6,not 1),(?1)=K,(1),(1),(1)=T
!	   vs H's from K: -.002(5),.089(3),.563(2),.25f,.150(6),.125f
!	   x2     1-3=Oxygen (x,y,z), 4-6=H(n), 7-9=H(o) (popn=0.5)
          DO I=0,2
            xco(16*i+2,1)=-xco(16*i+1,2)
            xco(16*i+2,2)=xco(16*i+1,1)
            xco(16*i+2,3)=-xco(16*i+1,3)
            DO i1=1,2
              DO j=1,2
                xco(16*i+2+i1,j)=-xco(16*i+i1,j)
              ENDDO
              xco(16*i+2+i1,3)=xco(16*i+i1,3)
            ENDDO
            DO i1=1,4
              xco(16*i+4+i1,1)=0.5+xco(16*i+i1,1)
              xco(16*i+4+i1,2)=1.0-xco(16*i+i1,2)
              xco(16*i+4+i1,3)=0.25-xco(16*i+i1,3)
            ENDDO
            DO i1=1,8
              DO j=1,3
                xco(16*i+8+i1,j)=0.5+xco(16*i+i1,j)
              ENDDO
            ENDDO
          ENDDO
          DO J=1,3		! P site
            xco(49,J)=0.0
          ENDDO
          xco(50,1)=0.5
          xco(50,2)=0.0
          xco(50,3)=0.25
          xco(51,1)=0.5
          xco(51,2)=0.5
          xco(51,3)=0.5
          xco(52,1)=0.0
          xco(52,2)=0.5
          xco(52,3)=0.75
          xco(53,1)=0.0		! N site
          xco(53,2)=0.0
          xco(53,3)=0.5
          xco(54,1)=0.5
          xco(54,2)=0.0
          xco(54,3)=0.75
          xco(55,1)=0.5
          xco(55,2)=0.5
          xco(55,3)=0.0
          xco(56,1)=0.0
          xco(56,2)=0.5
          xco(56,3)=0.25
!
          a01=7.4997	! (4)
          b01=7.4997
          c01=7.5494	! (12)
          Tref=293		! T for d-spacing
          aalph(1)=3.93E-5	! vs W.R.Cook, Jr 3.20E-5
          aalph(2)=aalph(1)
          aalph(3)=1.90E-6	! vs 4.20E-6
          nalphs=3
!91		thermal expansion
          IF (xTemp.LT.0.0) xTemp=Tref
          a02=a01*(1.0+aalph(1)*(xTemp-Tref))
          b02=b01*(1.0+aalph(2)*(xTemp-Tref))
          c02=c01*(1.0+aalph(3)*(xTemp-Tref))
!		Tetragonal, Z=2 so (2d=10.641147 (101))
          d2=2.D0/DSQRT((MH*MH+MK*MK)/a02/a02+ML*ML/c02/c02)
          ksp=ORDER/d2
          Volcell=a02*b02*c02
          Numcells=1.D30/Volcell
!92		Supplementary parameters:
          calpha=DPIo2
          cbeta=calpha
          cgamma=calpha
          nbasis=5		! actually 14
          DO I=1,nbasis
            natoms(I)=1
            IF (I.LE.1) THEN
              nsites(I)=16
              atomtype(I,1)=3
              fpop(I,1)=1.
              ntherm(I,1)=5
              btherm(I,1,1)=.00628
              btherm(I,1,2)=.00594
              btherm(I,1,3)=.00801
              btherm(I,1,4)=.00216
              btherm(I,1,5)=.00124
            ELSEIF (I.LE.2) THEN
              nsites(I)=16
              atomtype(I,1)=1
              fpop(I,1)=1
              ntherm(I,1)=5
              btherm(I,1,1)=.0169
              btherm(I,1,2)=.0134
              btherm(I,1,3)=.0167
              btherm(I,1,4)=.00707
              btherm(I,1,5)=.00062
            ELSEIF (I.LE.3) THEN
              nsites(I)=16
              atomtype(I,1)=1
              fpop(I,1)=0.5
              ntherm(I,1)=3
              btherm(I,1,1)=.00927
              btherm(I,1,2)=.00927
              btherm(I,1,3)=.00927
            ELSEIF (I.EQ.4) THEN
              nsites(I)=4
              atomtype(I,1)=4
              fpop(I,1)=1
              ntherm(I,1)=3
              btherm(I,1,1)=.0055
              btherm(I,1,2)=.0055
              btherm(I,1,3)=.0084
            ELSE
              nsites(I)=4
              atomtype(I,1)=2
              fpop(I,1)=1
              ntherm(I,1)=3
              btherm(I,1,1)=.0110
              btherm(I,1,2)=.0110
              btherm(I,1,3)=.0088
            ENDIF
          ENDDO
!92		End of supplementary parameters.
!	   Compute structure factors:
          natomtypes=4
          kZed(1)=1			! Hydrogen
          kZed(2)=7			! Nitrogen
          kZed(3)=8			! Oxygen
          kZed(4)=15		! Phosphorus
          kpop(1)=24.0
          kpop(2)=4.0
          kpop(3)=16.0
          kpop(4)=4.0
          DO iatom=1,natomtypes
            CALL FORMF            ! Compute f01(I),f02(I)=fh2(I),fh1(I) - (CS5plate.f)
          ENDDO
          f01(4)=f01(4)*fscale
          f02(4)=f02(4)*fscale
          fh1(4)=fh1(4)*fscale
          DO iatom=1,natomtypes
            FHn(iatom)=DCMPLX(fh1(iatom),f02(iatom))
            F0n(iatom)=DCMPLX(f01(iatom),f02(iatom))
          ENDDO
!           MW=(115.02592)x4 for ADP, RHO=1.798E-4g/cm3 cm/mu,/10=/.1mu
!		vs calcd 1.7993: drho=.07% vs .03% quoted abc
          sigscat=((24.*SIG(1,1)*1.00797+4.*SIG(1,2)*14.0067 &
              +16.*SIG(1,3)*15.9994+4.*SIG(1,4)*30.9738)*(Numcells/Na11))
          siginc=((24.*SIG(2,1)*1.00797+4.*SIG(2,2)*14.0067 &
              +16.*SIG(2,3)*15.9994+4.*SIG(2,4)*30.9738)*(Numcells/Na11))
!92	   The following should now be replaced by CALL FHCALCN(IM,ORDER):
          FHr=DCMPLX(0.,0.)
          FHi=DCMPLX(0.,0.)
!91	   n.b. effect on B(T) over-estimated by linear extrapolation
!		 ! Nitrogens: 293K
          THERM=DEXP(-(MH*MH*.0110+MK*MK*.0110+ML*ML*.0088)*ORDER*ORDER &
              *xTemp/Tref)	! Khan, X-ray
!T         THERM=DEXP(-(MH*MH*.0083+MK*MK*.0083+ML*ML*.0083)*ORDER*ORDER &
!T                    *xTemp/Tref)	!Tenzer, neutron
          DO J=53,56
            FHr=FHr+DCMPLX(fh1(2)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(f02(2)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
          ENDDO
!		 !room temp,correct	! P site:
          THERM=DEXP(-(MH*MH*.0055+MK*MK*.0055+ML*ML*.0084)*ORDER*ORDER &
              *xTemp/Tref)
!T         THERM=DEXP(-(MH*MH*.00373+MK*MK*.00373+ML*ML*.00470)*ORDER*ORDER &
!T                    *xTemp/Tref)	!Tenzer, neutron
          DO J=49,52
            FHr=FHr+DCMPLX(fh1(4)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(f02(4)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
          ENDDO
!		!mean pars,room T	! full + half H's:
!K         THERM=DEXP(-(MH*MH*.016+MK*MK*.016+ML*ML*.016)*ORDER*ORDER &
!K                    *xTemp/Tref)
          THERM=DEXP(-(MH*MH*.0169+MK*MK*.0134+ML*ML*.0167+MH*ML*.00707 &
                      +MK*ML*.00062)*ORDER*ORDER*xTemp/Tref)	!Tenzer, neutron
          DO J=17,32
            FHr=FHr+DCMPLX(fh1(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0,2.D0 &
                *DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(f02(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0,2.D0 &
                *DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
          ENDDO
          THERM=DEXP(-(MH*MH*.00927+MK*MK*.00927+ML*ML*.00927)*ORDER*ORDER &
              *xTemp/Tref)	!Tenzer, neutron
          DO J=33,48
            FHr=FHr+DCMPLX(fh1(1)*THERM,0.D0)*0.5*CDEXP(DCMPLX(0.D0,2.D0 &
                *DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(0.5*f02(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0,2.D0 &
                *DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
          ENDDO
!			Oxygens
!K         THERM=DEXP(-(MH*MH*.0075+MK*MK*.0083+ML*ML*.0118+MK*MH*.0026- &
!K                      MH*ML*.0044-MK*ML*.0074)*ORDER*ORDER*xTemp/Tref) !293K, O sites
          THERM=DEXP(-(MH*MH*.00628+MK*MK*.00594+ML*ML*.00801+MH*ML*.00216 &
              +MK*ML*.00124)*ORDER*ORDER*xTemp/Tref)	!Tenzer, neutron
          DO J=1,16
            FHr=FHr+DCMPLX(fh1(3)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
            FHi=FHi+DCMPLX(f02(3)*THERM,0.D0)*CDEXP(DCMPLX(0.D0, &
                2.D0*DPI*(xco(J,1)*MH+xco(J,2)*MK+xco(J,3)*ML)*ORDER))
          ENDDO
!92		End of intended replacement.
!

        CASE (9) ! option for bodging elemental cubic d2
!********************************************************************
!93		Elemental, cubic crystal structure bodge.
!		Parameter Z read earlier
!	s, Vol, a*, b*, c*, cos calpha*,cbeta*,cgamma*, d2, Numcells
!		for simple cubic case:
!
          iatom=1
          CALL FORMF ! (CS5plate.f)
          a01=(amu(1)/Na11/rho(1)*1.D35)**0.333333 !cubic inversion / amu,rho
          b01=a01
          c01=a01
          CALL GEN2D
          ksp=ORDER/d2
!test      write (*,*) iatom,a01,b01,c01,Na11,rho(1),amu(1),d2,ORDER,ksp
      
        CASE (5) ! Data file input crystal
!********************************************************************
!91			User-input crystal structure.
!		Parameters read in earlier (unit 5, LATFIL)
!	s, Vol, a*, b*, c*, cos calpha*,cbeta*,cgamma*, d2, Numcells
!		for general (TRICLINIC) case:
!
          CALL GEN2D
          ksp=ORDER/d2
!
!		Compute/recover fh1,f01,f02,sig(1,sig(2, Mui,amu
!		form factors, coherent, incoherent scattering
!91			send this inner loop to ```formf
!MNK Modified next three lines to compile under ifort
!MNK old code
!MNK      DO 1520 iatom=1,natomtypes
!MNK        CALL FORMF
!MNK  1520  CONTINUE
!MNK new code
          DO iatom=1,natomtypes
            CALL FORMF ! (CS5plate.f)
          END DO
!MNK end new code


        CASE (6) ! Quartz crystal

!***********************************************************************
!	alpha-quartz, NOT P-H Wei, Z.Kristallogr. (A)92 (1935)355
!		SiO2     10-10      (100)
!		no inversion centre! Trigonal.
!	alpha-Q(10-10): S(C)=P3(sub1)2,a=4.9134,c=5.4052=>2d=8.5103(LP)
!			Si site
          xco(1,1)= 0.46987
          xco(1,2)=0.0
          xco(1,3)=0.0
!	  Si uncertainties = (9),-,-
          xco(2,1)=0.53013
          xco(2,2)=0.53013
          xco(2,3)=0.33333333
          xco(3,1)=0.0
          xco(3,2)=0.46987
          xco(3,3)=0.66666667
          IF (attest.EQ.1) THEN
            xco(1,1)=xco(1,1)+.00009
            xco(3,2)=xco(3,2)+.00009
            xco(2,1)=xco(2,1)-.00009
            xco(2,2)=xco(2,2)-.00009
          ENDIF
!91			O site
          xco(4,1)= 0.4141
          xco(4,2)= 0.2681
          xco(4,3)= 0.1188
!	  O uncertainties = (2),(2),(1)
          DO I=4,5
            xco(I+1,1)=xco(I,2)-xco(I,1)
            xco(I+1,2)=-xco(I,1)
            xco(I+1,3)=0.666666667+xco(I,3)      ! not 0.3333+z
          ENDDO
          DO I=4,6
            xco(I+3,1)=xco(I,2)            !not x-y !! Int.Tables
            xco(I+3,2)=xco(I,1)            !not -y !!
            xco(I+3,3)=-xco(I,3)
          ENDDO
!
!		Structure factors
!
          natomtypes=2
          kZed(1)=14
          kZed(2)=8
          kpop(1)=3
          kpop(2)=6
          DO iatom=1,natomtypes
            CALL FORMF ! (CS5plate.f)
          ENDDO
          f01(1)=f01(1)*fscale
          f02(1)=f02(1)*fscale
          fh1(1)=fh1(1)*fscale
          DO iatom=1,natomtypes
            FHn(iatom)=DCMPLX(fh1(iatom),f02(iatom))
            F0n(iatom)=DCMPLX(f01(iatom),f02(iatom))
          ENDDO
          a01=4.9134	! v 4.913(C), not 4.90 Wei. alpha=120 degrees
          c01=5.4052	! v 5.405(C), not 5.39. hexagonal Z=3
!			! P 3, 2 not C 32 2
          Tref=293		! T for d-spacing
          aalph(1)=1.428E-5
          aalph(2)=aalph(1)
          aalph(3)=8.71E-6
          nalphs=3
!91		thermal expansion
          IF (xTemp.LT.0.0) xTemp=Tref
          a02=a01*(1.0+aalph(1)*(xTemp-Tref))
          b02=a02
          c02=c01*(1.0+aalph(3)*(xTemp-Tref))
          Volcell=a02*a02*c02*DSQRT(0.75D0)
          Numcells=1.D30/Volcell
          d2=2.0/DSQRT((MH*MH+MK*MK+MH*MK)/(0.75*a02*a02)+ML*ML/c02/c02)
          ksp=ORDER/d2	     ! 2d(10-10)=8.5234 vs .5096
!92			Supplementary parameters:
          calpha=DPIo2
          cbeta=calpha
          cgamma=2.*DPI/3.0
          nbasis=2
          nsites(1)=3
          nsites(2)=6
          natoms(1)=1
          natoms(2)=1
          atomtype(1,1)=1
          atomtype(2,1)=2
          fpop(1,1)=1.
          fpop(2,1)=1.
          ntherm(1,1)=6
          ntherm(2,1)=6
          btherm(1,1,1)=.0072
          btherm(1,1,2)=.0056
          btherm(1,1,3)=.0041
          btherm(1,1,4)=-.00026
          btherm(1,1,5)=-.00051
          btherm(1,1,6)=.0056
          btherm(2,1,1)=.0170
          btherm(2,1,2)=.0126
          btherm(2,1,3)=.0081
          btherm(2,1,4)=-.00493
          btherm(2,1,5)=-.00782
          btherm(2,1,6)=.0455
!92			End of supplementary parameters.
!           MW=(180.2544)x1 for quartz, RHO=2.6438E-4g/cm3 cm/mu,/10=/.1mu
!		vs calcd 2.6487: drho=.19% vs .1% dabc?
          sigscat=((3.*SIG(1,1)*28.086+6.*SIG(1,2)*15.9994) &
              *(Numcells/Na11))
          siginc=((3.*SIG(2,1)*28.086+6.*SIG(2,2)*15.9994) &
              *(Numcells/Na11))
!92	   The following should now be replaced by CALL FHCALCN(IM,ORDER):
          FHr=DCMPLX(0.D0,0.D0)
          FHi=DCMPLX(0.,0.)
!91	   n.b. effect on B(T) over-estimated by linear extrapolation
!A         THERM=DEXP(-0.7/d2/d2*ORDER*ORDER*xTemp/Tref)      !Amour
          THERM=DEXP(-(MH*MH*.0072+MK*MK*.0056+ML*ML*.0041+MH*MK*.0056 &
              -MH*ML*.00026-MK*ML*.00051)*ORDER*ORDER*xTemp/Tref) !LePage
          DO J=1,3
            FHr=FHr+DCMPLX(fh1(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0,2.D0*DPI* &
                (MH*xco(J,1)+MK*xco(J,2)+ML*xco(J,3))*ORDER))
            FHi=FHi+DCMPLX(f02(1)*THERM,0.D0)*CDEXP(DCMPLX(0.D0,2.D0*DPI* &
                (MH*xco(J,1)+MK*xco(J,2)+ML*xco(J,3))*ORDER))
          ENDDO
!A         THERM=DEXP(-1.0/d2/d2*ORDER*ORDER*xTemp/Tref)	!Amour
          THERM=DEXP(-(MH*MH*.0170+MK*MK*.0126+ML*ML*.0081+MH*MK*.0455 &
              -MH*ML*.00493-MK*ML*.00782)*ORDER*ORDER*xTemp/Tref) !LePage
          DO J=4,9
            FHr=FHr+DCMPLX(fh1(2)*THERM,0.D0)*CDEXP(DCMPLX(0.D0,2.D0*DPI* &
                (MH*xco(J,1)+MK*xco(J,2)+ML*xco(J,3))*ORDER))
            FHi=FHi+DCMPLX(f02(2)*THERM,0.D0)*CDEXP(DCMPLx(0.D0,2.D0*DPI* &
                (MH*xco(J,1)+MK*xco(J,2)+ML*xco(J,3))*ORDER))
          ENDDO
!92		End of intended replacement.
      
        CASE (7) ! User-defined parameters for testing
! ****************************************************************
!		User-defined parameters for testing
          DO
            DO
              WRITE(*,*) 'Enter 1,5,6, or 8 to input 2Rz,BDz,BXz,Bmalpha'
              READ(*,*) I
              IF (I.GT.0.AND.I.LT.11) THEN
                READ(*,*) GB(I)
                IF (I.EQ.8) THEN
                  dlambdanew=dlambda/DSQRT(1.D0-dbeta*dbeta)*(1.D0-dbeta*DSIN(dalpha+GB(8)))
                  Energynew=hckeV/dlambdanew
                ENDIF
              ELSE
                EXIT
              ENDIF
            ENDDO
          
            WRITE(*,*) 'Enter Re(FHr),Im(FHr),Re(FHi),Im(FHi),Re(F0),Im(F0)'
            READ(*,*) FHr,FHi,F0(3)
            WRITE(*,*) 'Enter d2 (order=1),N,sigscat,siginc'
            READ(*,*) d2,Numcells,sigscat,siginc
            ksp=ORDER/d2
            K1=DSQRT(DREAL(FHi)**2.D0+DIMAG(FHi)**2.D0)/DSQRT(DREAL(FHr) &
                **2.D0+DIMAG(FHr)**2.D0)
!Mac  		! ImF0>0, DSQRT>0, G<0
            G2=-DIMAG(F0(3))/DSQRT(DREAL(FHr)**2.D0+DIMAG(FHr)**2.D0)
            G=G2/DABS(DCOS(2.D0*THETA))
            IF (AGE.GT.1) THEN
              sintha=dLAMBDANEW*ksp
              mcurv=sintha*dlambdanew*1.0D-3/DPIo2 &
                  /(Numcells*re0/DPI*dLAMBDANEW**2*1.0D-20)**2.D0 &
                  /(DREAL(FHi)**2+DIMAG(FHi)**2+DREAL(FHr)**2+DIMAG(FHr)**2) &
                  /GB(1)*(1.D0-sintha**2*(1.D0+K1))     ! +ve,.1mu
              A0=2.D0/mcurv
            ELSE
              mcurv=0.D0
              A0=0.D0				! infty
            ENDIF
!92			Supplementary parameters:
            calpha=DPIo2
            cbeta=calpha
            cgamma=DPIo2
            natomtypes=1			! random values
            kZed(1)=6
            kpop(1)=1.0
            F0(1)=6.0
            F0(2)=6.0
!
            WRITE(*,*) 'This corresponds roughly to c,A,g(sig,pi),kappa='
            WRITE(*,*) mcurv,A0,G,G2,K1
            WRITE(*,*) 'neglecting b,siginc,dely0<>2 OK?(0=no/1=yes/-1=quit)'
            READ(*,*) I
            IF (I.NE.0)THEN
              EXIT ! Don't get more user input in OPT==7 as the input was right or the user wanted to quit
            ENDIF
          ENDDO
          IF (I.LT.0) Iquit = 1 ! quit by user-input in OPT==7

! ****************************************************************
!
!	Output quantities re0,PI,Lambda,Theta,Range0,Numcells,
!		FHr,FHi,F0,d2,RHO,sigscat,siginc
!		n.b. PSIH=PSIHr+iPSIHi, but (Quartz) PSIHr=cmplx too
!	s=(PSIHri.PSIHir-PSIHrr.PSIHii)/MPSIr2,
!	MPSIr2=PSIHrr**2+PSIHri**2,
!	p=(PSIHrr.PSIHir+PSIHri.PSIHii)/MPSIr2
!
        CASE DEFAULT
          WRITE(*,*) ' Option not implemented'
          test_OPT_implimented = .false.
      END SELECT

! ****************************************************************
! ****************************************************************
! ****************************************************************

      IF (OPT.EQ.9.OR.OPT.EQ.5) THEN
!LFS: code inputs  - f01,f02,fh1, fscale, natomtypes, SIG,amu,kpop, Numcells, Na11, IM,ORDER
!LFS: code outputs - f01,f02,fh1, FHn, F0n, SIG,sigscat,siginc
        f01(1)=f01(1)*fscale
        f02(1)=f02(1)*fscale
        fh1(1)=fh1(1)*fscale
        DO iatom=1,natomtypes
          FHn(iatom)=DCMPLX(fh1(iatom),f02(iatom))
          F0n(iatom)=DCMPLX(f01(iatom),f02(iatom))
        ENDDO
!
        sigscat=0.D0
        siginc=0.D0
        DO iatomtype=1,natomtypes
          sigscat=sigscat+(SIG(1,iatomtype)*kpop(iatomtype) &
              *amu(iatomtype))
          siginc=siginc+(SIG(2,iatomtype)*kpop(iatomtype) &
              *amu(iatomtype))
        ENDDO
        sigscat=sigscat*(Numcells/Na11)
        siginc=siginc*(Numcells/Na11)
!mactest	  write(*,*) 'Sig',sigscat,siginc,Mui(1),SIG(1,1),SIG(2,1),kpop(1),amu(1),iatomtype,Numcells/Na11
        CALL FHCALCN(IM,ORDER) ! (CS5plate.f)
!91      Mica 002: Muscovite K20.3(Al203).6(Si02).2(H20)
!	A2/a;4	C2/c=C62h a01=5.18, b0=9.02, c0=20.1, beta=95.66deg
!	 disabled since nobody knows what this is!!!
      ENDIF
      
!LFS: End crystal setup


!----------------START BLOCK 4-------------------------
!LFS: Added next line
      IF (Iquit.EQ.1) THEN
        EXIT !GOTO 2550  ! quit by user-input in OPT==7
      ENDIF
      
      IF (test_OPT_implimented) THEN
      
        IF (OPT.NE.7) THEN
          CALL F0CALCN	! Replace older F0 calcn (CS5plate.f)
        ENDIF
        
        sintha=dLAMBDANEW*ksp
        IF (sintha.GT..9999) THEN
          WRITE(*,*) ' Bragg angle does not exist (imaginary)'
          IF (sintha.GT.1.1.AND.Igraz.NE.1) THEN
            WRITE(*,*) dlambda,dlambdanew,order,d2,a02,b02,c02,sintha
            Iquit = 4
            EXIT !GOTO 2550 ! 2000: quit because sinth>1 (lambda>2d)
          ELSE
            THETA=DPIo2		! ray tracing approximation
          ENDIF
        ELSE
          THETA=DASIN(sintha)
        ENDIF
        
        
        IF (Ifeff.EQ.2) THEN  ! three beam calulation
!B
          CALL THREEBM(OPT,ORDER,fscale,aplane) ! (THREEBMplate.f)
!L?
          STOP
        ENDIF
        
        IF (CDABS(FHr+(0.D0,1.D0)*FHi).LT.1.D-2*CDABS(F0(3))) THEN
          write(*,*) 'Enter'
          WRITE(*,*) ' FHr for refln (-1 or 1<RET>FHr,FHi)?'
          READ(*,*) iexpfhr
          IF (iexpfhr.EQ.1) THEN
            READ(*,2001) Ft1,Ft2,Ft3,Ft4
2001        FORMAT('4F')
            FHr=DCMPLX(Ft1,Ft2)
            FHi=DCMPLX(Ft3,Ft4)
          ENDIF
        ENDIF
!mactest		WRITE(*,*) numstr,dout,AGE
        IF ((IABS(ANS).EQ.1).OR.AGE.GE.1) THEN
          CYCLE=1
        ELSEIF (AGE.LT.1) THEN	! ANS=0,2, AGE=0
          FILEIN2='RSG.D'//numstr(2:4)
          OPEN (UNIT=1,FILE=dout//FILEIN2,STATUS='NEW')
          FILEIN2='RPI.D'//numstr(2:4)
          OPEN (UNIT=7,FILE=dout//FILEIN2,STATUS='NEW')
          CYCLE=0            ! Printing RPI.DAT on first cycle
        ENDIF
!
!	Following Cole & Stemple
!
!91			 precision
!B
        basym=-DSIN(THETA)/DSIN(THETA+2.*aplane)	! for peak centre, approx.
!	simeq -1/(DCOS(2.*aplane)+DSIN(2.*aplane) / DTAN(theta))
!L		                   ! 1st estimate
        umbo2=(1.D0-basym)/2.D0      ! = 1 usually
        A2=Numcells*re0/DPI
        DPSI0=-A2*dLAMBDANEW**2*1.D-20*F0(3)
        RPSI0=DREAL(DPSI0)
        APSI0=DIMAG(DPSI0)
        muabs=-2.D+3*DPI/dlambdanew*APSI0+sigscat ! muabs,siginc,scat in .1mu
        APSI0=APSI0-dlambdanew/2.D+3/DPI*siginc
        DPSI0=DCMPLX(RPSI0,APSI0)
        DPSIHr=-A2*dLAMBDANEW**2*1.D-20*FHr
        DPSIHi=-A2*dLAMBDANEW**2*1.D-20*FHi-dlambdanew/2.D+3/DPI*DCMPLX(siginc,0.D0)
!	! include incoherent scattering in psi0 & psihi
        PSI0=CMPLX(DPSI0)
        PSIHr=CMPLX(DPSIHr)
        PSIHi=CMPLX(DPSIHi)
!91
!MACtest  write(*,*) 'Gen',A2,DPSI0,RPSI0,APSI0,muabs,sigscat,siginc &
!	             ,DPSIHr,DPSIHi,-dlambdanew/2.D+3/DPI*siginc
        MPSIr2=DREAL(DPSIHr)**2+DIMAG(DPSIHr)**2
        MPSIi2=DREAL(DPSIHi)**2+DIMAG(DPSIHi)**2
        s=(DIMAG(DPSIHr)*DREAL(DPSIHi)-DREAL(DPSIHr)*DIMAG(DPSIHi))/MPSIr2
        p=(DREAL(DPSIHr)*DREAL(DPSIHi)+DIMAG(DPSIHr)*DIMAG(DPSIHi))/MPSIr2
        K12=MPSIi2/MPSIr2
        K1=DSQRT(K12)
        K=DABS(DCOS(2.D0*THETA))
        K2=1.D0
        G=umbo2*APSI0/K/DSQRT(DABS(basym)*MPSIr2)
        G2=G*K/K2
        denom=DSQRT((1.D0-K12)*(1.D0-K12)+4.D0*p*p)
!test	  write(*,*) 'ap,umbo,rpsi0,mpsir2,i,basym,denom,k12,k,p=' &
!                    ,aplane,umbo2,rpsi0,mpsir2,mpsii2,basym,denom,k12,k1,p 
!      WRITE(*,*) 'F,K,G,THETA,Range=',F0(3),K,K2,G,G2 &
!                  ,THETA,IDNINT(Range0)
!t
        scale1=(1.D0+K12+2.D0*s)/denom
!91			precision
        dTwod=d2/ORDER*1.D-3  !2d, double precn, given plane,order
!
!Mactest		WRITE(*,*) IREAD,numstr,dout

! BLOCK set
!  possibly opened units:
!   1, 7
!  set common:
!   THETA
!   FHr, FHi
!   denom, scale1, G2, G, K2, K, K12, CYCLE
!   p, s, MPSIi2, MPSIr2, APSI0, muabs, RPSI0, umbo2
!   DPSI0,DPSIHr,DPSIHi
!  set local:
!   dTwod, sintha
!----------------END BLOCK 4-------------------------

!----------------START BLOCK 5-------------------------
! calls CS5
!
        test_continuation_calc = .false.
        IF (IREAD.EQ.1) THEN
        
!LFS:        The folloiwing code is replaced with the code after
!LFS:      FILEIN2='TEMPSIG.0'//numstr(4:4)
!LFS:      OPEN (UNIT=11,FILE=dout//FILEIN2,STATUS='UNKNOWN')
!LFS:      READ(11,2178,END=2105) RFL,RI1,Mshift31(1)
!LFS:      CLOSE(UNIT=11,STATUS='DELETE')
!LFS:      
!LFS:      FILEIN2='TEMPSIG.1'//numstr(4:4)
!LFS:      OPEN (UNIT=11,FILE=dout//FILEIN2,STATUS='UNKNOWN')  
!LFS:      
!LFS:2103  CONTINUE ! short loop 2103-2104
!LFS:      READ(11,2178,END=2104) Dummy1,Dummy2,Dummy3
!LFS:      GOTO 2103 ! short loop 2103-2104
!LFS:2104  CONTINUE ! short loop 2103-2104
!LFS:
!LFS:      WRITE(11,2178) RFL,RI1,Mshift31(1)
!LFS:      CLOSE(UNIT=11,STATUS='KEEP')
!LFS:      
!LFS:      GOTO 2180
!LFS:
!LFS:2105  CONTINUE ! short spagetti code
!LFS:
!LFS:      CLOSE(UNIT=11,STATUS='DELETE')

!LFS:     Previous code replaced with this:
          FILEIN2='TEMPSIG.0'//numstr(4:4)
          
          OPEN (UNIT=11,FILE=dout//FILEIN2,STATUS='UNKNOWN')
          READ(11,2178,IOSTAT=Iio_status) RFL,RI1,Mshift31(1)
          CLOSE(UNIT=11,STATUS='DELETE')
          
          IF (Iio_status.GE.0) THEN ! 'TEMPSIG.0'//numstr(4:4) existed
            FILEIN2='TEMPSIG.1'//numstr(4:4)
            OPEN (UNIT=11,FILE=dout//FILEIN2,STATUS='UNKNOWN')  
          
            DO
              READ(11,2178,END=2104) Dummy1,Dummy2,Dummy3
            ENDDO
2104        CONTINUE ! short loop 2103-2104

            WRITE(11,2178) RFL,RI1,Mshift31(1)
            CLOSE(UNIT=11,STATUS='KEEP')

            test_continuation_calc = .true.
        
          ENDIF

        ENDIF
!L
        IF (test_continuation_calc) THEN

          WRITE(*,*) ' '
          numstr(1:1)='P'                        ! pi:perp.(K2=1)
          ip=2
          ICycle=1
          CALL CS5(ICycle,dalpha,dlambdadmu,dTwod,swidth,K2,aplane,G2,ORDER,Bragg) ! (CS5plate.f)

        ELSE

          IF (DABS(GB(1)).LT.1.D-9) THEN ! radius of curvature of crystal is negligable
            I2Rz=0.0
          ELSE
            I2Rz=1.D0/GB(1)
          ENDIF
!L
          IF (AGE.GE.1.AND.AGE.LE.5) THEN ! not an ifp calculation
            RPSIHi=DREAL(DPSIHi)
            APSIHi=DIMAG(DPSIHi)
            RPSIHr=DREAL(DPSIHr)
            APSIHr=DIMAG(DPSIHr)
!
            IF (Mininc.EQ.-1.D0.OR.dbetaread.LE.-2.D0.OR.Gflag.EQ.-2.D0) THEN ! start generate geometry
              ! BDz/AxisTh eq -2
              
              ! Set AxisTh, GB(5) and Tem. (GB(6) is source to crystal dist.)
              IF (Gflag.EQ.0) THEN	   ! BD input
!93              Tem=(GB(1)*GB(1)/4.D0+GB(6)*GB(6)-(GB(1)/2.D0-GB(5))**2.D0) &
!93                   /GB(1)/GB(6)
!L
                Tem = GB(5)/GB(6) + DABS(I2Rz)*(GB(6)*GB(6)-GB(5)*GB(5))/GB(6)
                AxisTh=DASIN(Tem)
              ELSEIF (Gflag.EQ.-2.D0) THEN ! Axisth input/aligned thB
                Tem=dlambdanew*1.D-3/dTwod  ! l in A,2d/n in 0.1mu
                AxisTh=DASIN(Tem)
                GB(5)=GB(1)/2.D0 - DSQRT(GB(1)*GB(1)/4.D0+GB(6)*GB(6)-Tem*GB(1)*GB(6))
              ELSE                         ! Axisth input
                AxisTh=GB(5)
                Tem=DSIN(AxisTh)
                GB(5)=GB(1)/2.D0 - DSQRT(GB(1)*GB(1)/4.D0+GB(6)*GB(6)-Tem*GB(1)*GB(6))
              ENDIF
              ! GB(5) is now the distance from the source to the Roland circle (inside the circle is +ve).
              ! Tem is now sin(AxisTh).
              
!92           Minimum angle at surface (could include Cx):
!L
              ABtem=DSQRT(GB(1)**2-GB(6)*GB(1)*2.D0*Tem+GB(6)*GB(6)) ! the distance from the source to center of the circle of the crystal.
              
              IF (GB(1).LE.ABtem) THEN ! source is outside the circle of the crystal
                Mininc=DACOS(DABS(GB(1))/ABtem)  !grazing angle,ABtem simeq BD-2Rz
                BXmin=ABtem*DSIN(Mininc)	! defines sector limit;
!L		other limit provided by sign(th1) or XX'...
              ELSE
                Mininc=DACOS(ABtem/GB(1))
                BXmin=GB(1)*DSIN(Mininc)
              ENDIF
!L			! simple Laue only (for Dick) ...
!              THABX=0.D0
!L		! cf. general ... (B+L): MId (centred) location first...
              THABX=DASIN(DCOS(AxisTh)*DABS(GB(1))/ABtem)! the angle from the crystal pole to the source measured from the crystal center of curvature
              Isect(1)=2				! Case 2, AJV
!94*
!              WRITE(*,*)THBAX,ABtem,Mininc,BXmin,GB(1),GB(6),Axisth
!94*
              IF (GB(6).LT.BXmin.AND.GB(1).GT.ABtem) THEN
                ! source is inside the circle of the crystal
                THABX=DPI-THABX	! Case 1, CTC, ABX>pi/2
                Isect(1)=1
                THBAX=Dpio2-THABX+Axisth
              ELSEIF (GB(6).GT.BXmin.AND.GB(1).LT.ABtem) THEN
                ! source is outside the circle of the crystal
                Isect(1)=1		! GB<0 sector labels switch
                THBAX=Dpio2-THABX+Axisth
!L		to match BAX declaration and GEN... functions...
!94*
              ELSEIF (GB(6).GT.BXmin.AND.GB(1).GE.ABtem) THEN	! Laue err/OK???
                ! source is inside the circle of the crystal
                THBAX=Dpio2-THABX+Axisth
!94*
              ELSE
                THBAX=Dpio2-THABX-Axisth
              ENDIF
!              XXmax1=2.D0*GB(1)*DSIN((AxisTh-THABX+DPIo2)/2.D0)
!              XXmax2=2.D0*GB(1)*DSIN((AxisTh-THABX-DPIo2)/2.D0)
!              XXmin1=2.D0*GB(1)*DSIN((Mininc+THABX-AxisTh-DPIo2)/2.D0)
!              XXmin2=2.D0*GB(1)*DSIN((Mininc-THABX+AxisTh+DPIo2)/2.D0)
!92	      Minimum from crystal maxdp,maxdm=half crystal length on Gx:
!L
!94*test       WRITE(*,*)THABX,THBAX
              IF (GB(1).GT.ABtem.OR.Isect(1).EQ.1) THEN
                Thetaap=maxdp/DABS(GB(1)) ! angle on Gx, same sign as XX,opp.th1 (B)
              ELSE
                Thetaap=-maxdp/DABS(GB(1)) ! angle on Gx, same sign as XX and th1 (L)
              ENDIF
              CALL GENSECT(GB(1),ABtem,Isect(1),THABX,Axisth,Thetaap,BXmin &
                  ,THBAX,THBAXp,BXp,THABXp,Thm2,Isect(2),Temthm2,Mininc)
              IF (GB(1).LT.ABtem.AND. &
                  (Isect(2).EQ.2.OR.Isect(2).EQ.4)) THEN
                BXm=GB(1)*DCOS(THABXp+Temthm2)/DSIN(THABXp)
              ELSE
                BXm=GB(1)*DCOS(THABXp-Temthm2)/DSIN(THABXp)
              ENDIF
!94*test       WRITE(*,*)THABXp,Temthm2,BXm
!92	      Maximum from crystal=maxdel=half crystal length on Gx:
!L
              IF (GB(1).GT.ABtem.OR.Isect(1).EQ.1) THEN
                Thetaap=-maxdm/DABS(GB(1)) ! angle on Gx, same sign as XX,opp.th1 (B)
              ELSE
                Thetaap=maxdm/DABS(GB(1)) ! angle on Gx, same sign as XX and th1 (L)
              ENDIF
              CALL GENSECT(GB(1),ABtem,Isect(1),THABX,Axisth,Thetaap,BXmin &
                  ,THBAX,THBAXp,BXp,THABXp,Thm3,Isecto(2),Temthm3,Mininc)
              IF (GB(1).LT.ABtem.AND. &
                  (Isect(2).EQ.2.OR.Isect(2).EQ.4)) THEN
                BXx=GB(1)*DCOS(THABXp+Temthm3)/DSIN(THABXp)
              ELSE
                BXx=GB(1)*DCOS(THABXp-Temthm3)/DSIN(THABXp)
              ENDIF
!94*test       WRITE(*,*)THABXp,Temthm3,BXx
!L
!             Allow for AJV-style inversion of order (ERRORS):
              IF (Thm2.GT.Thm3) THEN
                WRITE(*,*) ' Thm2/3 error/inversion',BXx,BXm,THBAX
                Tem=Thm3
                Thm3=Thm2
                Thm2=Tem
                Tem=BXm
                BXm=BXx
                BXx=BXm
              ENDIF
!92           Allow for contribution / dominance of swidth:
!Mac          allow for sw<0 and constrain to +-fwhm/2 or *.75:
              Thm2=Thm2-DASIN(DMIN1(DABS(swidth)/GB(6)*.75D0,1.D0))
              Thm3=Thm3+DASIN(DMIN1(DABS(swidth)/GB(6)*.75D0,1.D0))
              WRITE(*,2108) Thm2,Thm3,Temthm2,Temthm3,Mininc
2108          FORMAT(4X,'Crystal limits: Th1=',2(F9.6,','),'ThsGx=' &
                  ,F8.6,',',F8.6,',Mininc=',F8.6)
              WRITE(*,2109) Axisth,THABX,ABtem,Isect(1),Isect(2),Isecto(2)
2109          FORMAT(4X,'Axisth,ABX,AB,Sector(mid/min/max)=',2(F9.6,',') &
                  ,1PE13.6,3I2)
              ! end generate geometry
            ENDIF 
!
            dlambdadmu=dlambdanew*1.D-3
            
            WRITE(*,*) ' '
            numstr(1:1)='S'		              ! s:E ll inc.plane
            ip=1
            ICycle=1
            CALL CS5(ICycle,dalpha,dlambdadmu,dTwod,swidth,K,aplane,G,ORDER,Bragg) ! (CS5plate.f)
            
            IF (IREAD.EQ.1) THEN
              Time2=SECNDS(Time1)	!CMactest vs S(Time0)-Time1
              WRITE(*,2176) Tim2f,Tim21,Tim22,Time2
              IF (1.9*Time2.GT.SNGL(Maxtim)-Time2-Time1+Time0.AND.Maxtim.GT.0.D0) THEN
                FILEIN2='TEMPSIG.0'//numstr(4:4)
                OPEN (UNIT=11,FILE=dout//FILEIN2,STATUS='UNKNOWN')
                WRITE(11,2178) RFL,RI1,Mshift31(1)
                CLOSE(UNIT=11,STATUS='KEEP')
2176            FORMAT(1X,'Sigma Times to ffrc,cyc1,cyc2,end=',4(1PE9.2))
2178            FORMAT(1X,3(E13.6))

                WRITE(*,*) ' Ending at end of sigma'
                
                Iquit = 5
                EXIT !GOTO 2550 ! quit because out of time                
              ENDIF
            ENDIF
!
            WRITE(*,*) ' '
            numstr(1:1)='P'                        ! pi:perp.(K2=1)
            ip=2
            ICycle=1
            CALL CS5(ICycle,dalpha,dlambdadmu,dTwod,swidth,K2,aplane,G2,ORDER,Bragg) ! (CS5plate.f)

!
!
!	    Common (I/O) vars (CS5-Rcurve)
!	    AxisTh,Temth0,muabs
!
          ELSEIF (AGE.LT.1) THEN ! an ifp calculation
            WRITE(*,2114) Ilist,dlambda,dlambdanew,iorder
2114        FORMAT(/,1X,'line=',I3,';lambda(unshifted)=',F10.6,'(real)=',F10.6,';order=',I3)
            WRITE(*,2399) d2,Numcells,G
2399        FORMAT(1X,'2d=',1PE12.5,';cells/m3=',1PE9.2,',g(abs,sig)=',1PE9.2)
            WRITE(*,2117) FHr,FHi,F0(3)
2117        FORMAT(' S.factors FHr,FHi,F0=',6(1PE9.2,X))
!B
            CALL BRAGGIFP(ORDER,sintha) ! (THREEBMplate.f)
!L
          ENDIF 

        ENDIF
!B

        IF (Ifeff.EQ.1) THEN ! Include simple estimates
          CALL COMPAREMEASURES(GBt1,ORDER,swidth) ! (THREEBMplate.f)
        ENDIF

      ENDIF ! IF (test_OPT_implimented)

!----------------END BLOCK 5-------------------------



      IF (IREAD.EQ.1) THEN
        IF (RFL(3)+RFL2(3).NE.0.) THEN
          Mshift4(3)=Mshift4(3) &
                     /(RFL(3)+RFL2(3))*1.8D2/DPI	! Unpol'd eff.th/deg
        ENDIF
        IF (RESN.GT.OLDORDER/DABS(OLD2ORDER-OLDORDER)) THEN
          ISEQUENCE=ISEQUENCE+1
        ENDIF
        WRITE(3,2420) ISEQUENCE,OLD2ORDER,LINE(1:9) &
                      ,RFL(3),RFL2(3),RI1(3),RI2(3),LINE(10:33),IORDER,Mshift4(3)
        IF (AGE.GT.1) THEN
          WRITE(7,2430) ISEQUENCE,OLD2ORDER,LINE(1:9) &
                        ,RFL(3),RFL2(3),Mshift31(1),Mshift31(2),LINE(10:33),IORDER
        ENDIF
        OLDORDER=OLD2ORDER
2420    FORMAT(I4,F11.7,A9,2(1PE10.3),2(1PE11.3),A24,I1,0PF11.6)
2430    FORMAT(I4,F11.7,A9,2(1PE10.3),2(1PE11.3),A24,I1)
        Time2=SECNDS(Time1)	!CMactest vs S(Time0)-Time1
        IF (AGE.GE.1.AND.AGE.LE.5) THEN
          WRITE(*,2431) Tim2f,Tim21,Tim22,Time2
        ENDIF
2431    FORMAT(1X,'Pi Times to ffrc,cyc1,cyc2,end=',4(1PE9.2))
        DTIME(IORDER)=DBLE(Time2)
        Mtime=(Mtime*Ntime+DTIME(IORDER)/ORDER)/(Ntime+1.D0)
        Ntime=Ntime+1.D0
      ENDIF

      IF (IREAD.NE.1) THEN
        Iquit=3
        EXIT
      ENDIF
      
    ENDDO !loop 63 ! big loop over input lines


!   End of run:

    SELECT CASE (Iquit)
      CASE (1)
        WRITE(*,*) ' End for goto 2530=quit by user-input'
      CASE (2)
        WRITE(*,*) ' End for goto 2500=read EOF(input)'
      CASE (3)
        WRITE(*,*) ' End for IREAD=0 and [no more]'
      CASE (4)
        WRITE(*,*) ' End for goto 2520=sinth>1 (lambda>2d)'
      CASE (5)
        WRITE(*,*) ' End for goto 2540=out of time'
      CASE DEFAULT
        WRITE(*,*) ' Error: End for unknown reason'
    END SELECT
    
    IF (Ifeff.EQ.1) THEN ! Include simple estimates
      CLOSE(12,STATUS='KEEP')
      CLOSE(13,STATUS='KEEP')
      CLOSE(14,STATUS='KEEP')
      CLOSE(15,STATUS='KEEP')
      IF (AGE.GT.1) THEN
        CLOSE(16,STATUS='KEEP')
        CLOSE(17,STATUS='KEEP')
        CLOSE(18,STATUS='KEEP')
      ENDIF
    ENDIF
    
    IF (IREAD.EQ.1) THEN
      CLOSE(4,STATUS='KEEP')
      CLOSE(3,STATUS='KEEP')
      IF (AGE.GT.1) THEN
        CLOSE(7,STATUS='KEEP')
      ENDIF
      ANS1 = 0
    ELSE
      WRITE(*,*) ' Another? (1=yes) '
      READ(*,*) ANS1
    ENDIF
    
    IF (ANS1.NE.1) THEN
      EXIT
    ENDIF
  ENDDO

  STOP
END


!---------------------------------------------------------------------------
!91			get_lattice
!		read plabel(5), IDIG line
!		might as well read everything!
SUBROUTINE get_lattice
  IMPLICIT NONE
!
  INTEGER iatoms,isites
  PARAMETER (iatoms=40,isites=3)
  INTEGER IDIG,nalphs,nelas,nbasis,ksites,natoms(iatoms) &
      ,nsites(iatoms),iZed(iatoms,isites),ntherm(iatoms,isites) &
      ,atomtype(iatoms,isites)
  DOUBLE PRECISION a01,b01,c01,calpha,cbeta,cgamma,Tref,aalph(6) &
      ,elast(6),fpop(iatoms,isites),btherm(iatoms,isites,6),xco(100,3)
  CHARACTER PLABEL(15)*12
  COMMON/XLATTICE/PLABEL,IDIG,nalphs,nelas,nbasis,ksites,natoms &
      ,nsites,iZed,ntherm,atomtype &
      ,a01,b01,c01,calpha,cbeta,cgamma,Tref &
      ,aalph,elast,fpop,btherm,xco
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER ielem
  PARAMETER (ielem=20)
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!MAC95
  CHARACTER dout*11,dcom*11,ddat*7,dhen*16,dhm*8
!U95  change dhm*8 to dhm in following line
  COMMON/Macfiles/ dout,dcom,ddat,dhen,dhm
!MAC95
!			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
  CHARACTER*8 LATFIL
!MAC
  INTEGER ILATFIL
  CHARACTER*20 FILEIN3
!MAC
  CHARACTER*15 RUBBISH
  INTEGER ialph,ielas,ibasis,iatom,itherm,isite,iatomtype &
      ,iflagtype
!
  WRITE(*,*) ' Enter lattice file (A8, omit suffix .CLAT):'
!U96  insert FORMAT (A8) in UNIX code to read LATFIL
  READ(*,51) LATFIL
51 FORMAT(A8)
  ILATFIL=LEN(LATFIL)
  
5 CONTINUE ! short loop 5-8
  IF (ICHAR(LATFIL(ILATFIL:ILATFIL)).GE.40) THEN
    GOTO 8 ! short loop 5-8
  ENDIF
  ILATFIL=ILATFIL-1
  GOTO 5 ! short loop 5-8
8 CONTINUE

  FILEIN3=ddat//LATFIL(1:ILATFIL)//'.CLAT'
10 FORMAT(A8)
  OPEN(UNIT=10,FILE=FILEIN3,STATUS='OLD')
  READ(10,11) PLABEL(5)(1:5),IDIG
11 FORMAT(X,A5,X,I2)
  READ(10,10) RUBBISH	! comment, references
  READ(10,*) a01,b01,c01,calpha,cbeta,cgamma,Tref	! lattice pars
  READ(10,*) nalphs,nelas,nbasis
  READ(10,*) (aalph(ialph),ialph=1,nalphs) !linear expansion coeffs
  READ(10,*) (elast(ielas),ielas=1,nelas)
!
  WRITE(*,20) a01,b01,c01,calpha,cbeta,cgamma,Tref	! lattice pars
  WRITE(*,21) (aalph(ialph),ialph=1,nalphs) !linear expansion coeffs
  WRITE(*,22) (elast(ielas),ielas=1,nelas)
20 FORMAT(1X,'a,b,c,angles(o),Tref=',3(F8.4),3(F6.1),F8.3)
  calpha=calpha*DPI/1.8D2
  cbeta=cbeta*DPI/1.8D2
  cgamma=cgamma*DPI/1.8D2
21 FORMAT(1X,'linear expn coeffs:',3(1PE10.3))
22 FORMAT(1X,'elastic coeffs:',3(1PE10.3))
!91		! elastic coefficients, c11,c33,c44,c66,c12,c13 e.g.)
  ksites=0
  natomtypes=0
  DO ibasis=1,nbasis
    READ(10,10) RUBBISH	! Atoms in basis site n
    READ(10,*) natoms(ibasis),nsites(ibasis)
    DO iatom=1,natoms(ibasis)
      READ(10,*) iZed(ibasis,iatom),fpop(ibasis,iatom) &
          ,ntherm(ibasis,iatom)
!test    WRITE(*,*) iZed(ibasis,iatom),fpop(ibasis,iatom)
!t     1,ntherm(ibasis,iatom)
      IF (ntherm(ibasis,iatom).EQ.1) THEN
        READ(10,*) btherm(ibasis,iatom,1)
      ELSE
        READ(10,*) (btherm(ibasis,iatom,itherm),itherm=1 &
            ,ntherm(ibasis,iatom))
      ENDIF
      IF (natomtypes.EQ.0) THEN
        kZed(1)=iZed(ibasis,iatom)
        natomtypes=1
        kpop(natomtypes)=fpop(ibasis,iatom)*nsites(ibasis)
        atomtype(ibasis,iatom)=1
      ELSE
        iflagtype=1
        DO iatomtype=1,natomtypes
          IF (kZed(iatomtype).EQ.iZed(ibasis,iatom)) THEN
            iflagtype=0
            kpop(iatomtype)=kpop(iatomtype)+fpop(ibasis,iatom) &
                *nsites(ibasis)
            atomtype(ibasis,iatom)=iatomtype
          ENDIF
        ENDDO
        IF (iflagtype.EQ.1) THEN
          natomtypes=natomtypes+1
          atomtype(ibasis,iatom)=natomtypes
          kZed(natomtypes)=iZed(ibasis,iatom)
          kpop(natomtypes)=fpop(ibasis,iatom)*nsites(ibasis)
        ENDIF
      ENDIF
    ENDDO
    DO isite=1,nsites(ibasis)
      ksites=ksites+1
      READ(10,*) xco(ksites,1),xco(ksites,2),xco(ksites,3)
    ENDDO
!MACtest         WRITE(*,*) xco(ksites,1),xco(ksites,2),xco(ksites,3)
  ENDDO
  CLOSE(UNIT=10,STATUS='KEEP')
  RETURN
END
!-------------------------------------------------------------------------
!---------------------------------------------------------------------------
!91			bodge_lattice
!		read plabel(9), IDIG line
!		might as well read everything!
SUBROUTINE bodge_lattice
  IMPLICIT NONE
!
  INTEGER iatoms,isites
  PARAMETER (iatoms=40,isites=3)
  INTEGER IDIG,nalphs,nelas,nbasis,ksites,natoms(iatoms) &
      ,nsites(iatoms),iZed(iatoms,isites),ntherm(iatoms,isites) &
      ,atomtype(iatoms,isites)
  DOUBLE PRECISION a01,b01,c01,calpha,cbeta,cgamma,Tref,aalph(6) &
      ,elast(6),fpop(iatoms,isites),btherm(iatoms,isites,6),xco(100,3)
  CHARACTER PLABEL(15)*12
  COMMON/XLATTICE/PLABEL,IDIG,nalphs,nelas,nbasis,ksites,natoms &
      ,nsites,iZed,ntherm,atomtype &
      ,a01,b01,c01,calpha,cbeta,cgamma,Tref &
      ,aalph,elast,fpop,btherm,xco
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER ielem
  PARAMETER (ielem=20)
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!MAC95
  CHARACTER dout*11,dcom*11,ddat*7,dhen*16,dhm*8
!U95  change dhm*8 to dhm in following line of code
  COMMON/Macfiles/ dout,dcom,ddat,dhen,dhm
!MAC95
!			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!			element symbols
  character*2 elemend(92)
  COMMON/elecom/elemend
!
  INTEGER ialph,ielas,ibasis,iatom,itherm,isite,iatomtype &
      ,iflagtype
!
  WRITE(*,*) ' Atomic number of element (Z), to 92:'
  READ(*,*) iZed(1,1)
  PLABEL(9)(1:5)='  '//elemend(iZed(1,1))//' '
  IDIG=3
  calpha=DPIo2
  cbeta=DPIo2
  cgamma=DPIo2
  Tref=293
  nalphs=1
  nelas=3
  nbasis=1
  aalph(1)=2.56E-6		! arbitrary, from Si
  elast(1)=16.58
  elast(2)=6.39
  elast(3)=7.96
!
  WRITE(*,20) calpha,cbeta,cgamma,Tref	! lattice pars
  WRITE(*,21) (aalph(ialph),ialph=1,nalphs) !linear expansion coeffs
  WRITE(*,22) (elast(ielas),ielas=1,nelas)
20 FORMAT(1X,'angles(o),Tref=',3(F6.1),F8.3)
21 FORMAT(1X,'linear expn coeffs:',3(1PE10.3))
22 FORMAT(1X,'elastic coeffs:',3(1PE10.3))
!91		! elastic coefficients, c11,c33,c44,c66,c12,c13 e.g.)
  natoms(1)=1
  nsites(1)=1
  fpop(1,1)=1.0
  ntherm(1,1)=3
  btherm(1,1,1)=0.003877	! arbitrary, betaHH,KK,LL, from Si
  btherm(1,1,2)=0.003877
  btherm(1,1,3)=0.003877
  ibasis=1
  iatom=1
  kZed(1)=iZed(ibasis,iatom)
  natomtypes=1
  kpop(natomtypes)=fpop(ibasis,iatom)*nsites(ibasis)
  atomtype(ibasis,iatom)=1
  ksites=1
  xco(ksites,1)=0.0
  xco(ksites,2)=0.0
  xco(ksites,3)=0.0
  RETURN
END
!-------------------------------------------------------------------------
!L	Subroutine to clarify sector determinations in GB+/- cases (B/L):
SUBROUTINE GENSECT(GB1,ABtem,Isect1,THABX,Axisth,Thetaap,BXmin &
     ,THBAX,THBAXp,BXp,THABXp,Th1a,Isect2,Thincgx,Mininc)
  IMPLICIT NONE
  DOUBLE PRECISION GB1	 &! +ve or -ve crystal radius.
      ,ABtem			 &! +ve length from crystal to source centre
      ,THABX			 &! ABX at Axisth
      ,Axisth			 &! grazing inc. angle at crystal on RC
      ,Thetaap		 &! shift around crystal centre at surface
      ,BXmin			 &! sector limit location (grazing angle min.)
      ,THBAX			 &! input BAX for axisth
      ,THBAXp			 &! output BAX'
      ,BXp			 &! output BX'
      ,THABXp			 &! output ABX'
      ,Th1a			 &! Th1 value wrt axisth
      ,Thincgx		 &! Grazing angle on Gx, crystal surface
      ,Mininc			! Angle at A wrt AB for minimum grazing angle
  INTEGER Isect1		 &! Rowland circle focus definition (thaxis)
      ,Isect2			! sector location this is located in
  
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
  THBAXp=THBAX-Thetaap
  IF (THBAXp.LT.-Mininc) THEN	! S3 or S4, worst quarter!
!L				! == BXp.GT.BXmin, with - sign vs THABXp/<0
    THBAXp=-THBAXp
    IF (GB1.GT.ABtem) THEN
      Isect2=4
    ELSE
      Isect2=3
    ENDIF
  ELSEIF (THBAXp.GT.2.D0*DPI-Mininc) THEN ! S4/3, near AB axis,wrong side
!L				! == BXp.LT.BXmin, with - sign vs THABXp
    THBAXp=2.D0*DPI-THBAXp
    IF (GB1.GT.ABtem) THEN
      Isect2=3
    ELSE
      Isect2=4
    ENDIF
  ELSEIF (THBAXp.LT.0.D0) THEN	! S4/3
    THBAXp=-THBAXp
    IF (GB1.GT.ABtem) THEN
      Isect2=3
    ELSE
      Isect2=4
    ENDIF
  ELSEIF (THBAXp.GT.DPI) THEN ! S3 or S4
    THBAXp=2.D0*DPI-THBAXp
    IF (GB1.GT.ABtem) THEN
      Isect2=4
    ELSE
      Isect2=3
    ENDIF
  ELSEIF (THBAXp.LT.Mininc) THEN			! S1 or S2
!L	! best sector, right side ! == BXp.LT.BXmin, with + sign vs THABXp
    IF (GB1.GT.ABtem) THEN
      Isect2=1
    ELSE
      Isect2=2
    ENDIF
  ELSE	! if (THABXp.GE.Mininc.AND.THABXp.LE.DPI) then
    IF (GB1.GT.ABtem) THEN
      Isect2=2
    ELSE
      Isect2=1	! a bit ugly since XX(th1) 2-valued
!L			! but OK if remaining in sector
!L			! cf. S1=2: dpi-THABX-THABXp-2Mininc
    ENDIF
  ENDIF
  BXp=DSQRT(ABtem*ABtem+GB1*GB1-2.D0*DABS(GB1*DCOS(THBAXp)) &
      *ABtem)			!+ve
  THABXp=DASIN(DABS(GB1*DSIN(THBAXp))/BXp)	! +ve
  IF (GB1.GT.ABtem.AND.(Isect2.EQ.1.OR.Isect2.EQ.3)) THEN
    THABXp=DPI-THABXp	! larger than dpio2 for gb1>0
  ENDIF
  IF (Isect2.EQ.1.OR.Isect2.EQ.2) THEN
    Th1a=THABX-THABXp
  ELSE
    Th1a=THABX+THABXp
    IF (Th1a.GT.DPI) THEN
      Th1a=Th1a-2.D0*DPI
    ENDIF
  ENDIF
  IF (GB1.GT.ABtem.OR.(Isect2.EQ.1.OR.Isect2.EQ.3)) THEN
    Thincgx=THABXp-DPIo2+THBAXp
  ELSE
    Thincgx=-THABXp+DPIo2-THBAXp
  ENDIF
!L		Compared to old result:
!        IF (THABXp.LT.0.D0.AND.BXp.LT.BXmin) THEN	! end in sector 3
!         THABXp=DPI+THABXp
!         Th1a=THABX+THABXp-2.D0*DPI
!         Isect(2)=3
!        ELSEIF (THABXp.LT.0.D0) THEN		! end in sector 4
!         THABXp=-THABXp
!         Th1a=THABX+THABXp-2.D0*DPI
!         Isect(2)=4
!        ELSEIF (BXp.LT.BXmin) THEN		! if sector 1 (CTC)
!         THABXp=DPI-THABXp			! Case 1, ABX>pi/2
!         Th1a=THABX-THABXp
!         Isect(2)=1
!        ELSE					! if sector 2 (AJV)
!         Th1a=THABX-THABXp
!         Isect(2)=2
!        ENDIF
!        Thincgx=THABXp-DPIo2+DABS(DPIo2-THBAXp)
  RETURN
END
!-------------------------------------------------------------------------
!-------------------------------------------------------------------------
!		Appendix 1: Vax, PET, Fe Ly alpha, fcp calcn: (...COM file)
!
!$ GOTO LAST
!...
!$ LAST:
!$ SM			! Vax login command to set sub-directory = SET DEF [.cmos]
!$ DEFINE SYS$OUTPUT MOSCURVET1.LOG ! Vax interactive redirection of output
!$ R MOSCURVE3	! Vax initiation command
!1				! Select Bragg (reflecting) option vs Laue
!8				! specify supplementary parameters
!3.D6,1.5D6,0.,3.2D5,1.0,0,-100.,0,0 ! 2Rz,Rzf,Cx,arc from pole,f1,at,T,Ip,Gf
!2.6D5,1.5D5,0.,3	! BXz,Axisth/BDz,a_Bm,Iffsource (CTC tables v 2=HPC)
!1				! Choice of PET crystal
!0.,100000.,.136,0.,4000.	! alpha,swidth,beta,aplane,T=0.4mm
!2,0			! AGE(fcp), Ifeff(no comparative measures)
!-1				! read from file, and write profiles
!0.				! No Mosaicity
!1				! Norm, only for curved crystals
!0,0,2			! hkl
!2000.,9000000.	! Resn,REAL t limit,filein(Ifeff<2). RDDEx data:
!FETEST
!F
!1				! Output profiles for lines 1,2,6
!2
!6
!0
!$ rename ffrc.* ffge220hm.*
!$ rename rppth1.* rppth1ge220hm.*
!$ rename rpptho.* rppthoge220hm.*
!$ rename rppyo.* rppyoge220hm.*
!$ rename rplth1.* rplth1ge220hm.*
!$ rename rpltho.* rplthoge220hm.*
!$ rename rplyo.* rplyoge220hm.*
!$ !rename ms*.ge220 *.ge220hm
!$ rename ge220h.outa *.outhm
!$ rename ge220h.otya *.otyhm
!$ end:
!$ DEASSIGN SYS$OUTPUT
!----------------------------------------------------------------------------
!		Appendix 2: Mac 680x0(tool), Quartz, Fe Ly alpha, fcm calcn:
!	MPW command line: Moscurve3 < (this file) > Quartz.log
!1				! Bragg
!8				! specify supplementary parameters
!3.D6,1.5E6,0.,120000.,1.,0,-100,1,0 ! 2Rz,Rzf,Cx,arc from pole,f1,at,
!!				! xTemp defaults (iron expt);high precision,Gf
!260000.,150000.,0.,3		! BXz,BDz,a_Bm, Iffsource (C/L/C tables)
!6				! Choice of alpha-Quartz crystal
!0.,100000.,.136,0.,4000.	! alpha,swidth,beta,aplane,T
!-2,0			! AGE(inc.emulsion),Ifeff(no compare measures)
!1				! ***emulsion type = DEF 392 X-ray film***
!-1				! read from file, and write profiles
!0.001			! ***Mosaicity***
!1				! emission geometry, not vs x-ray mirror
!100			! ***mean mosaic unit (0.1mu)***
!1,0,-1,0		! ***hkil***
!2000.,-4000.	! Resn,Maxtim infinite,spectral file. RDDEx data:
!FETEST
!a
!1				! Output profiles for lines 1,4,6
!4
!6
!0
!
!----------------------------------------------------------------------------
!		Appendix 3: Mac 680x0(tool), Germanium, Ge Ly alpha, ifp calcn:
!1				! Bragg
!5				! ***Choice of Ge crystal from database***
!0.,37500.,.1772,0.0,1524.	! alpha,swidth,beta,aplane,T
!0,1			! ***AGE (ifp calculation),Ifeff(compare ests)***
!10.			! ***initial abscissa range (mins of arc)***
!-1				! read from file, and write profiles. ***Crystal:***
!GE
!2,2,0			! hkl
!4000.,-10.		! Resn,REAL t limit,spectral file. RDDEx data:
!GETEST
!F
!1				! Output profiles for lines 1,2
!2
!0
!----------------------------------------------------------------------------
!		Appendix 4: Vax (batch file), ADP, ffp calcn:
!$ sm
!$ r moscurve3
!1				! Bragg
!4				! ADP
!0.,200.,0.,0.,400.	!
!1,0			! ***ffm calcn***
!-1				! read from files
!0.				! ***no mosaicity***
!1,0,1			! hkl
!20000.,-10.
!jslin
!f
!1
!5
!0
!----------------------------------------------------------------------------
!		Appendix 5: Vax (batch file), Si, ifp three-beam calcn:
!$ sm
!$ r moscurve3
!1				! Bragg
!3				! Si
!0.,200.,0.,0.,400.
!0,2			! ***three-beam computation***
!4,4,2			! hkl
!-10.			! time limit
!3				! i/o character
!1.8			! dummy lambda
!1				! Write LH... curves
!4				! enter lambda limits
!1.54335,10.	! Angstroms
!1				! Adjust hkl limits from 50,50,50 max
!10,10,10		! OK for soft energies
!0				! continue
!1				! forbidden reflection, reenter FH (vs -1, leave zero)
!0.035,1.E-14,0.035,1.E-14
!$ rename h*.* [.mosres]*.si442f
!$ subs tbmsi111	! short for submit/queue=short tbmsi111
!----------------------------------------------------------------------------
!		Appendix 6: MacPPC 7.5 (semi-batch Application), Ge220 calcn:
!	Drag Comfile (e.g. Ge220calnswinn) into M3comfile Applescript application
!	Respond to Mac LSFtn request (file=*)
!		with (Data:CTCMPW:Comfiles:)Ge220calnswinn, which contains:
!1				! Bragg
!8				! PERFECT,VKa/Ge220, Caln Source,swinn F-11.81
!1.846D7,9.23D6,0.,1.D4,1.0,0,-100.,1,1 ! 2Rz,Rzf,Cx,arc-pole,f1,at,T,prec,Gf
!8.59D6,-2.,0.,3	! BXz,Axisth/BDz,a_Bm,Iff(2=H88,3=CLC tables)
!5				! Input
!0.,2.D4,0.,0.,8000.! alpha,sw,beta,apl,T=0.8mm
!2,0			! ffm, NO compareme
!-1				! FRESNEL
!0.
!1
!GE
!2,2,0
!20000.,-10.
!ge220g
!a
!2
!5
!0
!----------------------------------------------------------------------------
