!---------------------------- FTSUPP.FOR --------------------------
!	   ....supplemental files for form factor determination....
!	C. T. Chantler
!	atomic_data, cromer; for use with FFCOMPARE.FOR
!	 (ftcompare, bewindow) / MOSCURVE3.FOR
!	CALLS:	SIGMA0,SIGMA1,SIGMA2,SIGMA3,LEGENDRE,GAUSS,POLINT,SORT,
!		McM,RDAT (included)
!test		abscromer incorporated for comparison with B/C/C(1) mod.
!t	calls:	oSIGMA0, SIGMA1, oSIGMA2, SIGMA3, AKNINT (included)
!
!	 4 May 1992 Inclusion of local/global/Mac switch CTC
!	24 Aug 1994 Major correction of McM for H and He CTC
!	20 Sep 1994 Major correction of interpolation for low-energy edges CTC
!96	   Nov 1996 Splicing for compatibility with FFSUPP CTC
!
!***********************************************************************
!91*	ABS$ATOMIC_DATA.FOR (old version!) converted to atomic_data
!		to preserve lun unit numbers and correct div/0 errors.
!***********************************************************************
subroutine atomic_data(jZed,amu,rho, n_edge, abs_edge)
  implicit none
  integer iedge
  parameter (iedge=24)
  integer jZed,n_edge
  double precision amu,rho
  double precision abs_edge(iedge), k_edge
!			database integration
  INTEGER iGLflag,iGLorder,iGLstep
  DOUBLE PRECISION d_x(16), d_a(16)
  COMMON/GLweights/ d_x,d_a,iGLflag,iGLorder,iGLstep
!96
  integer iopen,n_orb,i_funtype(iedge),i_nparms(iedge)
  DOUBLE PRECISION d_xsect(iedge,11), d_nrg(iedge,11) &
      ,d_sum_fp(4)	,d_sum_fpp(4)
  double precision eterm,amu_save,rho_save,bind_nrg(iedge)
  common/ CRODAT/ iopen, n_orb, i_funtype, i_nparms &
      , eterm, amu_save, rho_save, bind_nrg &
      , d_xsect, d_nrg,d_sum_fp,d_sum_fpp
!		bind_nrg(1)=ek, the k-edge energy
!		bind_nrg(2)=el3, the LIII edge energy
!		eterm=-relcor is the relativistic correction term
  integer i
!
  IF (jZed.LT.3) THEN
!91 NO! DON'T		call McM(jZed,amu_save,rho_save,k_edge)
    iopen=jZed
    n_orb=1		! load common block
    IF (jZed.EQ.1) THEN
      k_edge=.0136
      bind_nrg(1)=k_edge
      amu_save=1.008
      rho_save=8.987E-5	! wrong anyway, but who cares!
    ELSE
      k_edge=.0246
      bind_nrg(1)=k_edge
      amu_save=4.003
      rho_save=1.664E-4	! wrong anyway, but who cares!
    ENDIF
  ELSE
    call rdat(jZed,n_orb,eterm,amu_save,rho_save &
        ,i_funtype,i_nparms, bind_nrg, d_xsect, d_nrg)
    iopen=jZed
  ENDIF
  amu=amu_save
  rho=rho_save
  n_edge=n_orb
  DO i=1,n_edge
    abs_edge(i)=bind_nrg(i)
  ENDDO
  RETURN
END
!******************************************************************
!	  Fabricate H, He form factor data in B/C/C formalism
!		from McMaster tables
subroutine McM(jZed,EkeV,fpp,kedge)
  implicit none
  integer jZed
  DOUBLE PRECISION EkeV, fpp, kedge
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
  DOUBLE PRECISION p1, p2, p3,eneV,p4
!
  eneV=EkeV*1.D3
  P1=DLOG(EkeV)
  P2=P1*P1
  P3=P2*P1
  P4=DLOG(eneV)
!			Cubic fit of ln-ln in 'b/atom'
  IF (jZed.EQ.1.AND.EkeV.GT.kedge) THEN	! Hydrogen
    fpp=e_per_b*eneV* dexp( 2.44964- 3.34953* p1 &
        - 0.047137*p2 + 0.00709962*p3)
  ELSEIF (EkeV.GT.1.d0) THEN 	!Helium, McM region,vs kedge)THEN
    fpp=e_per_b*eneV* dexp( 6.06488- 3.29055* p1 &
        - 0.107256* p2 + 0.0144465* p3)
  ELSEIF (EkeV.GT.kedge) THEN 	!Helium, edge interface
    fpp=eneV* dexp( 1.70068- 0.73678*p4 &
        - 0.180408* p4*p4)
  ELSE					! below edge
    fpp=0.
  ENDIF
  RETURN
END
!******************************************************************
!	  rdat reads f2 data for B/C/C formalism
!		from ABSORPTION$DATA==ABSORPTION.DAT
!
subroutine rdat(jZed, n_orb, relcor, amu, rho &
     , i_funtype, i_nparms, bind_nrg, d_xsect, d_nrg)
  implicit none
  integer iedge
  parameter (iedge=24)
  integer jZed,n_orb,i_funtype(iedge),i_nparms(iedge)
  double precision relcor,amu,rho,bind_nrg(iedge)
  DOUBLE PRECISION d_xsect(iedge,11),d_nrg(iedge,11)
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!
  real xsect(iedge,11), nrg(iedge,11),sbind_nrg(iedge)
  real srelcor,samu,srho
  integer irb,ipr,j,lun
!
  WRITE(*,*) 'IMac is ',IMac
  lun=2
  IF (IMac.EQ.0) THEN		! local Vax source
    open(lun,file='absorption.dat', status='old',access='direct',recl=602)
  ELSEIF (IMac.EQ.1 ) THEN	! local Mac source
    open(lun,file='absorption.dat', status='old',access='direct',recl=2312)
  ELSEIF (IMac.EQ.-1) THEN	! local Unix source
    open(lun,file='absorption.dat', status='old',access='direct',recl=2408)
  ELSEIF (IMac.EQ.2) THEN	! GNU compiler source
    open(lun,file='absorption.dat', status='old',access='direct',recl=9632)
  ELSE				! global Vax source
    open(lun,file='absorption$data',status='old',access='direct',recl=602)
  ENDIF
  read(lun,REC=jZed) n_orb, srelcor, samu, srho &
      ,(i_funtype(irb)   ,i_nparms(irb)   ,sbind_nrg(irb) &
      ,(xsect(irb,ipr),nrg(irb,ipr),ipr=1,i_nparms(irb)) &
      ,irb=1,n_orb)
  close(unit=lun)

!!--------------------------------------------------------
!! testing
!!   Who goes?
!  WRITE(*,*) ''
!  WRITE(*,*) 'Testing rdat in FTSUPP:'
!  WRITE(*,10) jZed,n_orb,relcor,amu,rho
!10 FORMAT(X,I4,',',I4,3(',',1PE13.6))
!  DO irb=1,n_orb
!    WRITE(5,15) irb,i_funtype(irb),i_nparms(irb),bind_nrg(irb)
!15  FORMAT(X,I4,',',I4,',',I4,',',1PE13.6)
!    WRITE(5,20) (xsect(irb,ipr),nrg(irb,ipr),ipr=1,i_nparms(irb))
!20  FORMAT(X,1PE12.5,5(X,1PE12.5))
!  END DO
!  WRITE(*,*) 'End Testing'
!  WRITE(*,*) ''
!!  WRITE(5,*)
!!  end testing
!!--------------------------------------------------------

! convert cross-sections to double precision
  DO irb=1,n_orb
    DO ipr=1,i_nparms(irb)
      d_xsect(irb,ipr)=DBLE(xsect(irb,ipr))
      d_nrg(irb,ipr)  =DBLE(nrg(irb,ipr))
    ENDDO
    bind_nrg(irb)=DBLE(sbind_nrg(irb))
  ENDDO
  relcor=DBLE(srelcor)
  amu=DBLE(samu)
  rho=DBLE(srho)
  RETURN
END
!------------------------------------------------------------------------
!	ABS$RAYCOMP.FOR converted to raycomp	 20-APR-91 SMB
! Calculate elastic and compton cross-sections (in barns/atom)
! (for scaling to cm2/g) vs earlier electrons/atom (same scale as fp,fpp)
!		reads from ABS$RAYCOMP_DATA==ABS$RAYCOMP.DAT
!
subroutine raycomp(jZed,energy,ray,comp)
  implicit none
  INTEGER jZed
  DOUBLE PRECISION energy, ray,comp
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!
  DOUBLE PRECISION dco_inco(8), p1, p2, p3
  real co_inco(8)
  integer i,lun
!
  IF (jZed.LT.1.OR.jZed.GT.92) THEN
    WRITE (*,*) 'Atomic number out of range'
    RETURN
  ENDIF
  IF (energy.LE.0.) THEN
    WRITE(*,*) ' Energy undefined'
    RETURN
  ENDIF
  lun=2
  IF (IMac.EQ.0) THEN		! local Vax source
    open(lun,file='abs$raycomp.dat' &
        ,status='old',access='direct',recl=8)
  ELSEIF (IMac.EQ.1) THEN		! local Mac source
    open(lun,file='abs$raycomp.dat' &
        ,status='old',access='direct',recl=32)
!       add IMac switch for Unix note "Recl" same as for VAX ==8
  ELSEIF (IMac.EQ.-1) THEN     ! local Unix source
    open(lun,file='absraycomp.dat' &
        ,status='old',access='direct',recl=32)
  ELSEIF (IMac.EQ.2) THEN	! GNU compiler source
    open(lun,file='absraycomp.dat' &
        ,status='old',access='direct',recl=128)
  ELSE			! global Vax source
    open(lun,file='abs$raycomp_data' &
        ,status='old',access='direct',recl=8)
  ENDIF
  read(lun,REC=jZed) (co_inco(i),i=1,8)
  close(unit=lun)
  p1=DLOG(energy/1.D3)
  p2=p1*p1
  p3=p2*p1
  DO I=1,8
    dco_inco(i)=DBLE(co_inco(i))
  ENDDO
!		! co_inco(1-4)=rayleigh in barns/atom
  ray=dexp(dco_inco(1)+ dco_inco(2)* p1+ &
      dco_inco(3)* p2+ dco_inco(4)* p3)
!		! co_inco(5-8)=compton in barns/atom
  comp=dexp(dco_inco(5)+ dco_inco(6)* p1+ &
      dco_inco(7)* p2+ dco_inco(8)* p3)
  RETURN
END
!------------------------------------------------------------------------
!------------------------------------------------------------------------
!	ABS$CROMER.FOR from system routine converted to CROMER
!
!	CALLS:	SIGMA0,SIGMA1,SIGMA2,SIGMA3,LEGENDRE,GAUSS,POLINT,SORT,
!		McM,RDAT
!test		abscromer incorporated for comparison with B/C/C(1) mod.
!t	calls:	oSIGMA0, SIGMA1, oSIGMA2, SIGMA3, AKNINT
!	This routine reads data for f' and f" according to an algorithm by
!	Cromer and Liberman, given to Fuoss, converted to direct access
!	file by Brennan; last modified 
!	29-MAY-89	SMB	Rework for shareable image library
!	20-APR-91	SMB	Correct bug in H calculation 
!	20-DEC-91	CTC	div/zero error; inclusion herein as B/C/C(1)
!	Assumes: Non-relativistic approximation with 1st-order corrn
!		 Coherent scattering (just what we want, here)
!		 Nearly forward scattering (i.e. failing for sinth/l>>1.0?)
!		 Electric dipole approximation
!		 Neglect of unoccupied bound states
!		 Separation of nuclear et al. amplitudes
!		Several functional errors in energy ranges,
!		 particularly eps1<1keV, eps1>70keV, E>60keV: corrected.
!		5-point Gauss-Legendre numerical integration,
!		 generalised to arbitrary (but with interpolation
!		 difficulties: if poly(interp)<poly(GL), won't converge).
!		Aitken quadratic interpolation gives 40% error in xsect
!		 near edge, and is not monotonic - extrapolation has
!		 serious failure. Replaced by polint.
!		Corrected result denoted as B/C/C(2).
!	1-JAN-92 CTC	iPhoto passed for Moscurve1.for
!		(=1 yields attenuation calcn only; =0 gives fp, fpp)
!
subroutine cromer(jZed,energy,fp,fpp,relcor,iPhoto)
  implicit none
  integer iedge
  parameter (iedge=24)
  integer jZed, iPhoto
  double precision energy,fp,fpp,relcor
!
  integer iopen,n_orb,i_funtype(iedge),i_nparms(iedge)
  DOUBLE PRECISION d_xsect(iedge,11), d_nrg(iedge,11) &
      ,d_sum_fp(4)	,d_sum_fpp(4)
  double precision eterm,amu_save,rho_save,bind_nrg(iedge)
  common/ CRODAT/ iopen, n_orb, i_funtype, i_nparms &
      , eterm, amu_save, rho_save, bind_nrg &
      , d_xsect, d_nrg,d_sum_fp,d_sum_fpp
!		bind_nrg(1)=the k-edge energy
!		bind_nrg(2)=the LIII edge energy
!		relcor is the relativistic correction term
  DOUBLE PRECISION d_xsect_barns,d_bind_nrg_au,d_xsect_int(17), &
      d_energy_au
  INTEGER icount
  COMMON /GAUS/ d_xsect_barns,d_bind_nrg_au,d_xsect_int &
      ,d_energy_au,icount
  DOUBLE PRECISION d_xsect_edge_au
  COMMON /EDGE/ d_xsect_edge_au
!			database integration
  INTEGER iGLflag,iGLorder,iGLstep
  DOUBLE PRECISION d_x(16), d_a(16)
  COMMON/GLweights/ d_x,d_a,iGLflag,iGLorder,iGLstep
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
  INTEGER Intflag,Iint
  COMMON /COMINT/ Intflag,Iint
!
  integer irb, ipr,jj, i_zero, i_nxsect,isno,idelno
  double precision jensen_cor,k_edge,corr
  DOUBLE PRECISION	d_fp_orb	,d_fpp_orb &
      ,d_nrg_s(11)	,d_xsect_s(11) &
      ,d_log_nrg(11)	,d_log_xsect(11) &
      ,d_nrg_int(17)	,d_fp_corr,d_log_bndg_nrg &
      ,d_energy	,d_log_energy,d_var
  DOUBLE PRECISION fppx,keVedge
  DOUBLE PRECISION FINE_PI		!=1/(alpha)/(2*pi^2)
!       	flag and iteration variables for test/old routine:
  INTEGER idGL,idstart,idstop,i
  INTEGER ilist
!B
  DOUBLE PRECISION dfpporb(iedge)
  common/fpporbs/dfpporb
!
  DOUBLE PRECISION sigma0,sigma1,sigma2,sigma3,sigma4,sigma5 &
      ,gauss,polint,osigma0,osigma2,aknint
  EXTERNAL sigma0,sigma1,sigma2,sigma3,sigma4,sigma5 &
      ,gauss,polint,osigma0,osigma2,aknint
!
  FINE_PI=INV_FINE_STRUCT/2.0D0/DPI**2	!6.940501 v old 6.942325
!		read in data (if not already read in)
  IF (jZed.LT.1.OR.jZed.GT.92) THEN
    WRITE(*,*) 'Atomic number out of range'
    RETURN
  ENDIF
  IF (energy.LE.0.) THEN
    WRITE(*,*) 'Energy undefined'
    RETURN
  ENDIF
!91		! McM or rdat tabulation + gaussian integration
!		! Separate relcor+Jensen from cromer/fp
  d_energy=energy/1.D3		! change to keV
  IF (jZed.LT.3) THEN
    n_orb=1
    iopen=jZed
    i_funtype(1)=2
    eterm=0.0
!	    call McM(jZed,d_energy,fppx,bind_nrg(1))	! Rewritten here
!DONOTRETURN	    RETURN
  ELSEIF (iopen.NE.jZed) THEN
    call rdat(jZed,n_orb,eterm,amu_save,rho_save &
        ,i_funtype,i_nparms,bind_nrg,d_xsect,d_nrg)
    iopen=jZed
  ENDIF
  d_log_energy=DLOG(d_energy)
  d_energy_au=d_energy/KEV_PER_RYD
  DO idGL=1,4
    d_sum_fp(idGL)=0.d0
    d_sum_fpp(idGL)=0.d0
  ENDDO
!91		Default 5-point Gauss-Legendre integration CORRECTED
!			! MAIN LOOP THROUGH THE ORBITALS
  DO irb=1,n_orb
    d_fp_orb=0.d0
    d_fp_corr=0.d0
    d_fpp_orb=0.d0
    d_xsect_barns=0.d0
    d_bind_nrg_au=bind_nrg(irb)/KEV_PER_RYD
    d_log_bndg_nrg=DLOG(bind_nrg(irb))
!
!old	    IF(i_nparms(irb).EQ.11) THEN	! fntype=0; 1.001eps1
!old	     d_xsect_edge_au=d_xsect(irb,11)/AU_CROSS
!old	    ENDIF
    IF (jZed.GE.3) THEN
!			! copy subset into second array
      DO ipr=6,10
        jj=ipr-5
        d_xsect_int(jj)=d_xsect(irb,ipr)/AU_CROSS
        d_nrg_int(jj)=d_nrg(irb,ipr)
      ENDDO
!		 sorting messes up subsequent calls with same energy;
!			 copy to second array first
      DO ipr=1,i_nparms(irb)
        d_xsect_s(ipr)=d_xsect(irb,ipr)
        d_nrg_s(ipr)=d_nrg(irb,ipr)
      ENDDO
      call sort(i_nparms(irb),d_nrg_s,d_xsect_s)
      DO ipr=1,i_nparms(irb)  ! convert to log of energy,xsect
        d_log_nrg(ipr)=DLOG(d_nrg_s(ipr))
        IF(d_xsect_s(ipr).EQ.0.0) THEN
!91	Error1a??	false log.: -31?, not 0.0?
          d_log_xsect(ipr)=-31.0D00
        ELSE
          d_log_xsect(ipr)=DLOG(d_xsect_s(ipr))
        ENDIF
      ENDDO
      IF (d_log_xsect(1).EQ.-31.0d0) THEN
        i_zero=0
        ipr=1
!91	Error1b:
        DO while(d_log_xsect(ipr).EQ.-31.0d0)
          i_zero=i_zero+1
          ipr=ipr+1
        ENDDO
        i_nxsect=i_nparms(irb)-i_zero
        i_zero=i_zero+1
      ELSE
        i_nxsect=i_nparms(irb)
        i_zero=1
      ENDIF
    ENDIF
!91
!		FUNCTION DETERMINATION:
!	Based on fntype=2(eps1<1keV),1(eps1>70keV),0(1keV<eps1<70keV)
! (n.b. this is arb. transformation for simpler integration);
! and E=hbar.omega<eps1(binding energy of orbital) or E>=eps1.
!	FN1 applies only to K-orbs for Z>=75. Gives higher precision
! than normal 5-pnt, particularly for E<70keV, with E(min,int)=1.024eps1;
! implementation omits xsect(edge), so interpolation still inferior.
! Much lower precision than ANY 10-pnt, or closed interval methods;
! but B/C data only goes up to E=4.617eps1 (331keV for Z=75; 534keV
! for Z=92). Ergo fundamental limitation for E>331-534keV in these cases,
! not ameliorated by 10-pnt method (since data missing).
!	FN0 has E(min,int)=1.049eps1, giving problem near edge (but fast);
! interpolation OK since E(edge) also given.
! E(max,int)=21.3eps1 (21.3keV-1.492MeV) and interpolation up to do./80keV.
! Ergo 10-pnt can give improvement in 21.3-160keV (est.) range for
! 1keV<eps1<4keV esp., and also for all from low E int. since E(edge) given.
! Depends on interpolation of reasonable accuracy.
!	FN2 has E(min,int)=1.101eps1, giving significant problem near edges.
! Applies to K-orbs for H...C,N,O,F,Ne; L-orbs to Co/Ni/Cu; M-orbs to
! Z=51,53(I),54,59,60; N-orbs to Z=84,87,90,... and all of the rest!
! Interpolation suffers similarly. E(max,int)=454.4eps1, giving improved
! int. above 2-3eps1 (i.e. for E>2-3keV in general). Emax fails between
! 80keV and 454keV re. interpolation.
! Ergo 10-pnt gives improvement for low E(int) (subject to interpolation),
! high E(int) for eps1<176eV and perhaps generally (subject to interp.),
! for all energies. Fundamental limitation appears above E=80-454keV
! (namely, int. only covers half relevant range).
! For E<3keV (E<3eps1), choice of FN2 is poor: should have used FN1/10-pnt.
! Interpolation for xsect, fpp will still go down to 1.10eps1.
!
!	Conclusion: Use 10-pnt generally, and hope that interp. adequate.
!	CPU increases due to problems re data base: could rewrite database.
!	No point in changing FN1 to FN0 at high E (no data, 10-pnt better)
!	No point in changing FN0 to FN2 at high E (no data, 10-pnt better)
!		CHANGE FN0 to FN1 at low E (E<1.4eps1?)
!		CHANGE FN2 to FN0/FN1 at low E (E<4eps1;2eps1;1.4eps1?)
!
!		INTEGRAND subtraction, D, relates to s0-s5:
!	s0=FN0(E>>eps1),D==xsect(E), 'always' of similar order to rest.
!	s2=FN2(E>>eps1),D==xsect(E), 'always' of similar order to rest.
!	s1=FN1(E<eps1),D==0, 'dumb'.
!	s3=FN0(E<eps1),D==xsect(edge), 'always' of similar order to rest.
!91?	s0=FN2=>FN0(3eps1>E>eps1),D==xsect(E), similar order to rest.
!91	s3=FN2=>FN0(E<eps1),D==xsect(edge), similar order to rest.
!91	s4=FN1(E>eps1),D==xsect(E), 'always' of similar order to rest.
!91	s5=FN1(E<eps1),D==xsect(edge), 'always' of similar order to rest.
!91?	s4=FN0=>FN1(2eps1>E>eps1),D==xsect(E), similar order to rest.
!		For E>eps1, denom. has pole when
!	(xE=eps1,FN0/1keV<E<70keV), (xE^2=eps1^2,FN1/E>70keV) or
!	(x^2E=eps1,FN2/E<1keV), from the eps+-eps1=E pole. This has
!	been evaluated (fp_corr) and subtracted, so that numerator and
!	denom. both contain this zero at the pole, and the fn is smooth.
!	However, the zeros must be cancelled whenever the situation
!	arises, and (hence) during evaluation of s0,s2,s4.
!
!91	Retain old routine for iGLflag=-1 for comparison, and
!91		set of four for testing/convergence.
    IF (Intflag.NE.0) THEN	! do f', f" calcns 4 times
      idstart=2
      idstop=5
    ELSEIF (iGLflag.EQ.0) THEN	! do f', f" calcns 4,2 times
      idstart=1
      idstop=4
    ELSEIF (iGLflag.EQ.-1) THEN
      idstart=1
      idstop=1
    ELSE
      idstart=2
      idstop=2
    ENDIF
    DO idGL=idstart,idstop
      IF (Intflag.NE.0) THEN
        Iint=idGL-1
        ilist=Iint
      ELSE
        Iint=5
        ilist=idGL
      ENDIF
      IF (idGL.EQ.1) THEN
        isno=i_funtype(irb)
        IF (isno.EQ.1) THEN	! no correction, no fpp
          idelno=0
        ELSEIF (isno.EQ.3) THEN	! corr, E<eps1, no fpp
          idelno=2
        ELSEIF (isno.EQ.0) THEN	! corr, E>eps1, fpp
          idelno=1
        ELSE			! corr, E>eps1?, fpp?
          idelno=1
        ENDIF
      ELSEIF (i_funtype(irb).EQ.1) THEN	 ! eps1>70keV
        IF (d_energy.GE.bind_nrg(irb)) THEN
          isno=4			 ! indicates functional form
          idelno=1		 ! del=xsect(E)
        ELSE
          isno=5
          idelno=2		 ! del=xsect(edge)
        ENDIF
      ELSEIF (i_funtype(irb).EQ.0) THEN ! 1keV<eps1<70keV
        IF (d_energy.GE.2.d0*bind_nrg(irb)) THEN
          isno=0			 ! indicates functional form
          idelno=1		 ! del=xsect(E)
        ELSEIF (d_energy.GE.bind_nrg(irb)) THEN
          isno=4			 ! indicates functional form
          idelno=1		 ! del=xsect(E)
        ELSE
          isno=3
          idelno=2		 ! del=xsect(edge)
        ENDIF
      ELSEIF (i_funtype(irb).EQ.2) THEN ! eps1<1keV
        IF (d_energy.GE.3.d0*bind_nrg(irb)) THEN
          isno=2			 ! indicates functional form
          idelno=1		 ! del=xsect(E)
        ELSEIF (d_energy.GE.bind_nrg(irb)) THEN
          isno=0			 ! indicates functional form
          idelno=1		 ! del=xsect(E)
        ELSE
          isno=3
          idelno=2		 ! del=xsect(edge)
        ENDIF
      ELSE				 ! dummy for old eps1>70keV
        isno=1
        idelno=0		 ! none
      ENDIF
      IF (iGLflag.EQ.0) THEN	! interface for testing routine
        IF (idGL.LE.2) THEN
          iGLorder=5
        ELSEIF (idGL.EQ.3) THEN
          iGLorder=10
        ELSE
          iGLorder=16
        ENDIF
      ENDIF
      IF (iGLorder.EQ.5) THEN
        iGLstep=0
      ELSEIF (iGLorder.EQ.10) THEN
        iGLstep=3
      ELSE
        iGLstep=8
      ENDIF
!94
      IF (iGLorder.EQ.5.AND.iPhoto.NE.1.AND.jZed.GE.3.AND. &
          (i_funtype(irb).EQ.isno.OR.(i_funtype(irb).EQ.0.AND. &
          isno.EQ.3).OR.(i_funtype(irb).EQ.1.AND.isno.GT.3))) THEN
!						! 5-pnt method
        call sort(5,d_nrg_int,d_xsect_int)
!test	write(5,*)'s',(d_nrg_int(ipr),d_xsect_int(ipr),ipr=1,iGLorder)
      ELSEIF (iPhoto.NE.1) THEN	! interpolate integration xsects
        DO ipr=1,(iGLorder+1)/2
          IF (isno.EQ.2) THEN
            d_nrg_int(ipr)=bind_nrg(irb) &
                /(1.d0-d_x(ipr+iGLstep))**2		! from lgndr
            d_nrg_int(iGLorder-ipr+1)=bind_nrg(irb) &
                /d_x(ipr+iGLstep)**2
          ELSEIF (isno.EQ.1.OR.isno.GT.3) THEN
            d_nrg_int(ipr)=bind_nrg(irb) &
                /DSQRT(1.d0-d_x(ipr+iGLstep))		! from lgndr
            d_nrg_int(iGLorder-ipr+1)=bind_nrg(irb) &
                /DSQRT(d_x(ipr+iGLstep))
          ELSE
            d_nrg_int(ipr)=bind_nrg(irb) &
                /(1.d0-d_x(ipr+iGLstep))		! from lgndr
            d_nrg_int(iGLorder-ipr+1)=bind_nrg(irb) &
                /d_x(ipr+iGLstep)
          ENDIF
          IF (jZed.GE.3) THEN
            d_xsect_int(ipr)=polint(DLOG(d_nrg_int(ipr)) &
                ,i_nxsect,i_zero,d_log_nrg,d_log_xsect &
                ,irb,i_funtype(irb),bind_nrg(irb))
            d_xsect_int(ipr)=dexp(d_xsect_int(ipr))/AU_CROSS  !au
            d_xsect_int(iGLorder-ipr+1)=polint(DLOG(d_nrg_int( &
                iGLorder-ipr+1)) &
                ,i_nxsect,i_zero,d_log_nrg,d_log_xsect &
                ,irb,i_funtype(irb),bind_nrg(irb))
            d_xsect_int(iGLorder-ipr+1)=dexp( &
                d_xsect_int(iGLorder-ipr+1))/AU_CROSS  !atomic units
!94
          ELSE		! McM evaluation!
            call McM(jZed,d_nrg_int(ipr),fppx,bind_nrg(1))
            d_xsect_int(ipr)=fppx*(4.d0*DPI)/INV_FINE_STRUCT &
                /d_nrg_int(ipr)*keV_per_ryd	! in au or barns or cm2/g?
!test	    write(7,61) d_nrg_int(ipr),d_xsect_int(ipr),fppx
!t61	FORMAT(2X,'Ekev,mu,fpp',3(1PE11.4))
            call McM(jZed,d_nrg_int(iGLorder-ipr+1) &
                ,fppx,bind_nrg(1))
            d_xsect_int(iGLorder-ipr+1)=fppx*(4.d0*DPI)/INV_FINE_STRUCT &
                /d_nrg_int(iGLorder-ipr+1)*keV_per_ryd
!test	    write(7,61) d_nrg_int(iGLorder-ipr+1)
!t	1	,d_xsect_int(iGLorder-ipr+1),fppx
          ENDIF
!94
        ENDDO
!test	    write(7,*)'i',(d_nrg_int(ipr),d_xsect_int(ipr),ipr=1,iGLorder)
      ENDIF
      icount=iGLorder+1
!	eps1<=E=hbar.omega: big PE, fpp cross-section
!	straight-forward interpolation routine over ln(sig) v ln(E)
!old	     IF (bind_nrg(irb).LE.d_energy) THEN ! xsect(E)
!old	     ENDIF
      IF (idelno.EQ.1.AND. &
          bind_nrg(irb).GT.d_energy) THEN
        d_xsect_barns=0.0D0	! otherwise interpolation awry
        d_fpp_orb=0.0D0
        d_fp_corr=0.0D0
      ELSEIF (idelno.EQ.1) THEN			! xsect(E) for del
        d_var=DABS(d_energy_au-d_bind_nrg_au) !f2 old cancellation
!		What if E=1.05eps1? Henke doesn't give orbitals.
!		A:fits extrapolation of power ratio from high E (OK)
        IF (DABS(d_var).LT.1.0D-30) THEN
!		d_var=1.0D0	! this fails
          d_energy_au=1.0005*d_bind_nrg_au	! correction?
          d_var=DABS(d_energy_au-d_bind_nrg_au)
        ENDIF
!test	WRITE(5,*) i_zero,(sngl(d_log_nrg(i_zero+i)),i=0,3)
!94
        IF (jZed.LT.3) THEN
          call McM(jZed,d_energy,fppx,bind_nrg(1))	! Rewritten here
          d_xsect_barns=fppx*(4.d0*DPI)/INV_FINE_STRUCT &
              /d_energy_au		! is this in au or barns or cm2/g?
          d_fpp_orb=fppx
        ELSE
!94
          IF (idGL.EQ.1) THEN		! old/erroneous
            d_xsect_barns=aknint(d_log_energy,i_nxsect &
                ,i_zero,d_log_nrg,d_log_xsect)
          ELSE
            d_xsect_barns=polint(d_log_energy &
                ,i_nxsect,i_zero,d_log_nrg,d_log_xsect &
                ,irb,i_funtype(irb),bind_nrg(irb))
          ENDIF
          d_xsect_barns=dexp(d_xsect_barns)/AU_CROSS  !atomic units
          d_fpp_orb=INV_FINE_STRUCT*d_xsect_barns &
              *d_energy_au/(4.d0*DPI)
        ENDIF
        d_fp_corr=-0.5*d_xsect_barns*d_energy_au &
            *FINE_PI*DLOG((d_energy_au+d_bind_nrg_au)/d_var)
      ELSEIF (idelno.EQ.2) THEN		! xsect(edge) for del
!		eps1>E=hbar.omega: no PE, fpp cross-section
!old	      IF(i_nparms(irb).NE.11) THEN	! fntype=1,2,no edge given
!94
        IF (jZed.LT.3) THEN
          keVedge=bind_nrg(1)*1.00001
          call McM(jZed,keVedge,fppx,bind_nrg(1)) ! or here
          d_xsect_edge_au=fppx*(4.d0*DPI)/INV_FINE_STRUCT &
              /d_bind_nrg_au		! is this in au or barns or cm2/g?
        ELSE
!94
          IF (idGL.EQ.1) THEN		! old/erroneous
            d_xsect_edge_au=aknint(d_log_bndg_nrg,i_nxsect &
                ,i_zero,d_log_nrg,d_log_xsect)
          ELSE
            d_xsect_edge_au=polint(d_log_bndg_nrg &
                ,i_nxsect,i_zero,d_log_nrg,d_log_xsect &
                ,irb,i_funtype(irb),bind_nrg(irb))
          ENDIF
          d_xsect_edge_au=DEXP(d_xsect_edge_au)/AU_CROSS
!old	      ENDIF
        ENDIF
        d_fp_corr=0.5*d_xsect_edge_au*d_bind_nrg_au**2 &
            * DLOG((-d_bind_nrg_au+d_energy_au) &
            /(-d_bind_nrg_au-d_energy_au)) &
            /d_energy_au*FINE_PI
      ENDIF
!test	   write(7,62)irb,bind_nrg(irb),jZed,isno,idelno,sngl(d_fpp_orb)
!t	1	,sngl(d_fp_corr),d_xsect_edge_au,fppx,d_xsect_barns
!t62	   FORMAT(2X,I2,1PE11.4,3I3,4(1PE11.4))
!t
      IF (iPhoto.NE.1) THEN
        IF(isno.EQ.0.AND.idGL.GT.1) THEN
          d_fp_orb=gauss(sigma0) * FINE_PI
        ELSEIF(isno.EQ.0) THEN
          d_fp_orb=gauss(osigma0) * FINE_PI
        ELSEIF(isno.EQ.1) THEN
!91	Error2:	assumed E<50keV, neglected del (i.e. function error)
          d_fp_orb=gauss(sigma1) * FINE_PI
        ELSEIF(isno.EQ.2.AND.idGL.GT.1) THEN
!91	Error3: assumed E>2keV, 5-pnt limitation, no del change
          d_fp_orb=gauss(sigma2) * FINE_PI
        ELSEIF(isno.EQ.2) THEN
          d_fp_orb=gauss(osigma2) * FINE_PI
        ELSEIF (isno.EQ.3) THEN
          d_fp_orb=gauss(sigma3) * FINE_PI
        ELSEIF(isno.EQ.4) THEN		! new
          d_fp_orb=gauss(sigma4) * FINE_PI
        ELSEIF(isno.EQ.5) THEN		! new
          d_fp_orb=gauss(sigma5) * FINE_PI
        ENDIF
        d_sum_fp(ilist)=d_sum_fp(ilist)+d_fp_orb+d_fp_corr
      ENDIF
      d_sum_fpp(ilist)=d_sum_fpp(ilist)+d_fpp_orb
      dfpporb(irb)=d_fpp_orb
    ENDDO
  ENDDO			! end of loop over orbits
  fpp=d_sum_fpp(idstop)
  jensen_cor=-0.5*dfloat(jZed) &
      *(d_energy_au/INV_FINE_STRUCT**2)**2
  relcor=-eterm+jensen_cor	! ala ludwig
!91	n.b. Smith et al. would use relcor=-0.6*eterm. See ffcompare.tex
  fp=d_sum_fp(idstop)
!test	WRITE(5,*) fp,fpp,d_fp_orb,d_fp_corr,d_fpp_orb
!test		separate: +relcor	! change back to DOUBLE PRECISION
!t	IF (idstart.EQ.1) d_sum_fp(1)=d_sum_fp(1)+relcor
  IF (idstop.EQ.4) THEN
    DO idGL=2,idstop
      corr=2.19E-6*dfloat(jZed)**3+1.03E-4*dfloat(jZed)**2
      d_sum_fp(idGL)=d_sum_fp(idGL)-0.6*corr	!+jensen_cor
    ENDDO
  ENDIF
  RETURN
END
!**************************************************************************
!	 The two functions (osigma0 and osigma2) are zeroed
!	at singularities compared to earlier code; 
!	the corrected updated versions (sigma0, sigma2) avoid div/0 errors.
!	 sigma0 has two changes; one for the div/0 and one for
!	computational near-singularities
!	 sigma2 is slightly more complicated and flags these and
!	one or two other 'errors' (which may arise from misapplication
!	of the form)
!	 sigma1 as originally given should never be used, so I have
!	avoided treatment of div/0 errors.
!**************************************************************************
double precision function osigma0(x)
  implicit none
  DOUBLE PRECISION x
  DOUBLE PRECISION d_xsect_barns, d_bind_nrg_au, d_xsect_int(17) &
      , d_energy_au
  INTEGER icount
  COMMON /GAUS/ d_xsect_barns, d_bind_nrg_au, d_xsect_int &
      , d_energy_au,icount
  DOUBLE PRECISION d_prod
  icount = icount-1
  d_prod = d_energy_au**2* x**2- d_bind_nrg_au**2
  IF (DABS(d_prod).LT.1.0D-30) THEN
    osigma0=0.0
  ELSE
    osigma0=d_xsect_int(icount)*d_bind_nrg_au**3/x**2/d_prod &
        -d_bind_nrg_au* d_xsect_barns* d_energy_au**2/ d_prod
  ENDIF
  return
end
!***********************************************************************
double precision function sigma1(x)
  implicit none
  DOUBLE PRECISION x
  DOUBLE PRECISION d_xsect_barns, d_bind_nrg_au, d_xsect_int(17) &
      , d_energy_au
  INTEGER icount
  COMMON /GAUS/ d_xsect_barns, d_bind_nrg_au, d_xsect_int &
      , d_energy_au, icount
  DOUBLE PRECISION d_prod
  icount = icount-1
  d_prod=dsqrt(x)*(d_energy_au**2*x*x-d_bind_nrg_au**2*x)
  IF (DABS(d_prod).LT.1.0D-30) THEN
    sigma1=0.0
  ELSE
    sigma1=0.5*d_bind_nrg_au**3*d_xsect_int(icount)/d_prod
  ENDIF
  return
end
!***********************************************************************
double precision function osigma2(x)
  implicit none
  DOUBLE PRECISION x
  DOUBLE PRECISION d_xsect_barns, d_bind_nrg_au, d_xsect_int(17) &
      , d_energy_au
  INTEGER icount
  COMMON /GAUS/ d_xsect_barns, d_bind_nrg_au, d_xsect_int &
      , d_energy_au, icount
  DOUBLE PRECISION denom
  icount=icount-1
  denom= x**3* d_energy_au**2- d_bind_nrg_au**2/ x
  IF (DABS(denom).LT.1.0D-30) THEN
    osigma2=0.0
  ELSE
    osigma2=2.0*d_xsect_int(icount)*d_bind_nrg_au**3/x**4/denom &
        -2.0*d_bind_nrg_au*d_xsect_barns*d_energy_au**2/denom
  ENDIF
  return
end
!***********************************************************************
double precision function sigma3(x)
  implicit none
  DOUBLE PRECISION x
  DOUBLE PRECISION d_xsect_barns, d_bind_nrg_au, d_xsect_int(17) &
      , d_energy_au
  INTEGER icount
  COMMON /GAUS/ d_xsect_barns, d_bind_nrg_au, d_xsect_int &
      , d_energy_au, icount
  DOUBLE PRECISION d_xsect_edge_au
  COMMON /EDGE/ d_xsect_edge_au
  icount=icount-1
  sigma3=d_bind_nrg_au**3*(d_xsect_int(icount) &
      -d_xsect_edge_au*x**2) &
      /(x**2*(x**2*d_energy_au**2-d_bind_nrg_au**2))
  return
end
!***********************************************************************
double precision function sigma0(x)
  implicit none
  DOUBLE PRECISION x
  DOUBLE PRECISION d_xsect_barns, d_bind_nrg_au, d_xsect_int(17) &
      , d_energy_au
  INTEGER icount
  COMMON /GAUS/ d_xsect_barns, d_bind_nrg_au, d_xsect_int &
      , d_energy_au, icount
  DOUBLE PRECISION d_prod
  icount=icount-1
  d_prod=d_energy_au**2*x**2-d_bind_nrg_au**2
!91		n.b. signs may err?
  IF (DABS(d_prod).LT.1.0D-30) THEN
    sigma0=-d_xsect_int(icount)*d_bind_nrg_au/x**2
  ELSE
    sigma0=(d_xsect_int(icount)* d_bind_nrg_au**3/ x**2 &
        -d_bind_nrg_au*d_xsect_barns*d_energy_au**2)/d_prod
  ENDIF
  RETURN
END
!***********************************************************************
double precision function sigma2(x)
  implicit none
  DOUBLE PRECISION x
  DOUBLE PRECISION d_xsect_barns, d_bind_nrg_au, d_xsect_int(17) &
      , d_energy_au
  INTEGER icount
  COMMON /GAUS/ d_xsect_barns, d_bind_nrg_au, d_xsect_int &
      , d_energy_au, icount
  DOUBLE PRECISION denom
  icount=icount-1
!91*		! fp div zero error, d_xsect_int(5)/SORT error
  IF (DABS(x).LT.1.0D-31) THEN
    WRITE(5,*) 'Denom. overflow'
    sigma2=0.0
  ELSEIF (d_energy_au.LT.1.0D-31) THEN
    sigma2=0.0
    WRITE (5,*) 'e simeq 0'
    ELSEIF (DABS(d_xsect_int(icount)-d_xsect_barns).LT.1.0D-30) &
        THEN
    WRITE(5,*) 'Factor cancels'
    sigma2=-2.0d00*d_xsect_int(icount)*d_bind_nrg_au/x**3
  ELSE
    denom= x**3*d_energy_au**2-d_bind_nrg_au**2/ x
    IF (DABS(denom).LT.1.0D-31) THEN
      WRITE(5,*) 'Denom. zero'
      sigma2=-2.0d00*d_xsect_int(icount)*d_bind_nrg_au/x**3
    ELSE
      sigma2=2.0d00*(d_xsect_int(icount)*(d_bind_nrg_au/x)**3/x- &
          d_bind_nrg_au* d_xsect_barns* d_energy_au**2)/denom
    ENDIF
  ENDIF
  RETURN
END
!91*********************************************************************
double precision function sigma4(x)
  implicit none
  DOUBLE PRECISION x
  DOUBLE PRECISION d_xsect_barns, d_bind_nrg_au, d_xsect_int(17) &
      , d_energy_au
  INTEGER icount
  COMMON /GAUS/ d_xsect_barns, d_bind_nrg_au, d_xsect_int &
      , d_energy_au, icount
  DOUBLE PRECISION d_prod
!
  icount=icount-1
  d_prod=d_energy_au**2*x-d_bind_nrg_au**2
  IF (DABS(d_prod).LT.1.0D-30) THEN
    sigma4=-0.5D0*d_xsect_int(icount)*d_bind_nrg_au/x
  ELSE
    sigma4=0.5D0*(d_bind_nrg_au**3*d_xsect_int(icount)- &
        d_bind_nrg_au*d_energy_au**2*d_xsect_barns*x) &
        /(DSQRT(x)*(d_energy_au**2* x*x-d_bind_nrg_au**2* x))
  ENDIF
  RETURN
END
!91*********************************************************************
double precision function sigma5(x)
  implicit none
  DOUBLE PRECISION x
  DOUBLE PRECISION d_xsect_barns, d_bind_nrg_au, d_xsect_int(17) &
      , d_energy_au
  INTEGER icount
  COMMON /GAUS/ d_xsect_barns, d_bind_nrg_au, d_xsect_int &
      , d_energy_au, icount
  DOUBLE PRECISION d_xsect_edge_au
  COMMON /EDGE/ d_xsect_edge_au
!
  icount=icount-1
  sigma5=0.5D0*d_bind_nrg_au**3*(d_xsect_int(icount) &
      -d_xsect_edge_au*x) &
      /(DSQRT(x)*(x*x*d_energy_au**2-d_bind_nrg_au**2*x))
  RETURN
END
!***********************************************************************
subroutine legendre (index,d_bb,d_cc)
  implicit none
  integer index
  DOUBLE PRECISION d_bb, d_cc
!			database integration
  INTEGER iGLflag,iGLorder,iGLstep
  DOUBLE PRECISION d_x(16), d_a(16)
  COMMON/GLweights/ d_x,d_a,iGLflag,iGLorder,iGLstep
  integer ip
!  THIS ROUTINE HAS BEEN STRIPPED (cf. LA-4403) SO IS ONLY USEFUL
!  for 5(10,16)-pnt integration (with parameters from FFcompare)
  ip=index
!		! replacing:	d_cc=-d_const+DSIGN(d_x(ip),d_const)
  IF (ip.GT.(iGLorder+1)/2) THEN	! ip limited to 1-3 or 1-5
    d_bb=d_a(iGLstep+iGLorder+1-ip)
    d_cc=1.0D00-d_x(iGLstep+iGLorder+1-ip)
  ELSE
    d_bb=d_a(iGLstep+ip)
    d_cc=d_x(iGLstep+ip)
  ENDIF
  RETURN
END
!***********************************************************************
double precision function gauss(sigma)
  implicit none
  DOUBLE PRECISION sigma
!			database integration
  INTEGER iGLflag,iGLorder,iGLstep
  DOUBLE PRECISION d_x(16), d_a(16)
  COMMON/GLweights/ d_x,d_a,iGLflag,iGLorder,iGLstep
!
  integer i, index
  DOUBLE PRECISION aa,bb,cc,dd
!
  aa=0.d0
  DO i=1,iGLorder
    index=i
    call legendre(index,bb,cc)
    dd=sigma(cc)
    aa=aa+bb*dd
  ENDDO
!test	write(5,*)'(fp-fc)/6.9=',SNGL(aa),SNGL(bb),SNGL(cc),SNGL(dd)
  gauss=aa
  RETURN
END
!********************************************************************
!	Aitken repeated interpolation (obsolete, and erroneous)
!   d_log_energy = abscissa at which interpolation is desired
!   d_log_nrg    = vector of n values of abscissa
!   d_log_xsect    = vector of n values of ordinate
!   t    = temporary storage vector of 4*(m+1) locations)
double precision function aknint &
     (d_log_energy,jn,jzero,d_log_nrg,d_log_xsect)
  implicit none
  integer jn,jzero
  DOUBLE PRECISION d_log_energy,d_log_nrg(11),d_log_xsect(11)
  INTEGER i,indexA,mendA,kk,jj,izero,n
  DOUBLE PRECISION t(20),del
!
  indexA=0			! from SB
  if(jn.le.2) then
    write(*,'('' Too few points, funct=y(1)'')')
    aknint = d_log_xsect(jzero)	! not nec. 1
    return
  endif
  izero=jzero
  n=jn
  del=d_log_nrg(izero+1)-d_log_nrg(izero)
  i=0
  if(del.gt.0.) then
    do while(d_log_nrg(i+izero).lt.d_log_energy.and.i.le.n)
      indexA=i
      i=i+1
    enddo
  else
    do while(d_log_nrg(i+izero).gt.d_log_energy.and.i.le.n)
      indexA=i
      i=i+1
    enddo
  endif
  indexA=indexA-1
  indexA=max0(indexA,0)	!ctest should indexA be zero vs 1?
  indexA=min0(indexA,n-3)	! last one, minus 2 =3 vs 2.
  mendA=indexA+2
!test	WRITE(5,*) izero,indexA,mendA,(sngl(d_log_nrg(izero+i))
!t	1,i=indexA,mendA)
  do i=indexA,mendA
    kk=i-indexA+1
    t(kk)=d_log_xsect(i+izero)
    t(kk+3)=d_log_nrg(i+izero)-d_log_energy
  enddo
  do i=1,2
    kk=i+1
    do jj=kk,3
      t(jj)=(t(i)*t(jj+3)-t(jj)*t(i+3)) &
          /(d_log_nrg(jj+indexA-1+izero)-d_log_nrg(i+indexA-1+izero))
    enddo
  enddo
  aknint=t(3)
  return
end
!*************************************************************
!91	Num.Rec.POLINT (p82) polynomial interpolation
!		(on log-log grid)
!	   d_log_energy=abscissa at which interpolation is desired
!	   d_log_nrg   =vector of n values of abscissa
!	   d_log_xsect =vector of n values of ordinate
!	   x,y,c,d  =temporary storage vectors
!	NOTE: Aitken quadratic interpolation on the log scale
!	 yielded non-monotonic errors of 40% in std (near-edge)
!	 interpolated cross-sections, let alone extrapolations!
!	The current method avoids this. Cubic and higher
!	 extrapolations from the first/last E still fail,
!	 so only linear extrapolations should be used in this region.
!	Linear log-log interpolations are used in the end sections.
!	Approximations/estimates must be used in intermediate regions:
!	 n=2 (linear log-log), n=4 (cubic spline log-log) and
!	 n=6 (quintic log-log) all weight both sides equally but yield
!	 larger discontinuities in derivative (n=2) or
!	 larger potential spurious oscillations (n=6, 8).
!	 These oscillations dominate from the first few data points
!	 in the current case. n=2 is 'safe but inaccurate'.
!	Non-linear interpolations are replaced by linear log-log int.
!	 in non-monotonic cases (for Iint=5+)
!
!	Alternatives are indicated by Iint=1-6
!
double precision function polint &
     (d_log_energy,jn,jzero,d_log_nrg,d_log_xsect &
     ,iorb,ifuntype,bindnrg)
  implicit none
  integer jn,jzero
  DOUBLE PRECISION d_log_energy,d_log_nrg(11),d_log_xsect(11)
  integer iorb,ifuntype
  double precision bindnrg,templogenergy
!
  INTEGER i,index,mend,kk,jj,m,n,izero,index0,izero1
  DOUBLE PRECISION x(11),y(11),c(11),d(11),del,dif,dift,yest &
      ,wdel,xdel,HO,HP,erry,Lest,Lscale	!,Loff
  INTEGER ien
!
  INTEGER Intflag,Iint
  COMMON /COMINT/ Intflag,Iint
!91		old routine failed for n=2 and generally.
  IF (jn.LE.1) THEN
    write(*,'('' Too few points, funct=y(1)'')')
    polint=d_log_xsect(jzero)		! not nec. 1
    RETURN
  ENDIF
  izero=jzero		! default, overwritten
  n=jn
  templogenergy=d_log_energy
!test	write(5,*) 'ln/pol',n,izero,(d_log_nrg(i),d_log_xsect(i),i=1,11)
!		! linear order max. for extrapolations, first section,
!		! and last 3 sections (quite restrictive).
  IF (d_log_energy.GT.d_log_nrg(jn+jzero-2)) THEN	! last or extrap
    izero=jn+jzero-2
    n=2
!94
  ELSEIF (d_log_energy.LT.d_log_nrg(jzero+1) &
      .AND.Iint.NE.5) THEN	! 1st or extrap
    n=2
  ELSE
    DO ien=jzero,jn+jzero-1
      IF (d_log_energy.LT.d_log_nrg(ien)) GOTO 20
    ENDDO
20  ien=ien-1
    IF (Iint.EQ.1) THEN		! linear log-log interpolation
      izero=ien			! fails near edges
      n=2
    ELSEIF (Iint.EQ.2.OR.jn.LE.4) THEN	! preferred cubic log-log
      n=MIN(jn,4)				! fails far from edges
      izero=MAX(jzero,ien-1)
    ELSEIF (Iint.EQ.3.OR.jn.LE.6) THEN	! preferred quintic log-log
      n=MIN(jn,6)				! fails in var. regimes
      izero=MAX(jzero,MIN(ien-2,jn-5))
    ELSEIF (Iint.EQ.4) THEN		! preferred maximum
      n=jn
      izero=jzero
!94			New Standard!
    ELSEIF (Iint.EQ.5) THEN		! new standard
      IF (ien-jzero.LT.1.AND.d_log_energy.GT.0.0) THEN
        n=2					 ! 0th/1st sections,high E
      ELSEIF (ien-jzero.EQ.1.AND.d_log_energy.GT.0.0) THEN ! 2nd,high E
        izero=jzero
        n=MIN(jn,4)
      ELSEIF (ien-jzero.LE.1) THEN		! 0th/1st/2nd sections, low E
        IF (d_log_energy.LT.d_log_nrg(jzero)) THEN
          d_log_energy=d_log_nrg(jzero)+0.0001	! establish derivative
        ENDIF
        izero=jzero
        n=jn
      ELSEIF (ien-jzero.EQ.2) THEN		! 3rd section?
        n=jn
        izero=jzero
      ELSEIF (ien-jzero.GE.(jn-1)/2-1.AND.d_log_energy.GT.0.0) THEN
!94						! last half+ of sections
        izero=ien
        n=2
      ELSEIF (ien-jzero.EQ.3) THEN		! 4th section
        n=jn
        izero=jzero
      ELSE					! later sections, low energy
        n=2
        izero=ien
      ENDIF
    ELSEIF (Iint.EQ.6) THEN		! old standard
      IF (n+izero-3.GT.0.AND. &
          d_log_energy.GT.d_log_nrg(n+izero-3)) THEN
        izero=n+izero-3
        n=2
      ELSEIF (n+izero.GT.4.AND. &
          d_log_energy.GT.d_log_nrg(n+izero-4)) THEN
        izero=n+izero-4
        n=2
!n          ELSEIF (n.GT.4) THEN ! avoid near-edge shape and tail errors
!n           izero=izero+1
!n           n=n-2			! choose lower-order polynomial!
      ENDIF
    ENDIF
  ENDIF
  DO i=1,n
    y(i)=d_log_xsect(i+izero-1)
    x(i)=d_log_nrg(i+izero-1)
    c(i)=y(i)
    d(i)=y(i)
  ENDDO
  del=x(2)-x(1)
  IF (n.EQ.2) THEN	! linear (on log-log plot)
    yest=y(1)+(y(2)-y(1))*(d_log_energy-x(1))/del
  ELSE
    index=1
    dif=DABS(d_log_energy-x(1))
    DO i=2,n
      dift=DABS(d_log_energy-x(i))
      IF (dift.LT.dif) THEN
        index=i
        dif=dift
      ENDIF
    ENDDO
    yest=y(index)
    IF (d_log_energy-x(index).LT.0.0D0) THEN
      index0=index-1
    ELSE
      index0=index
    ENDIF
    IF (index0.LT.1) index0=1
    izero1=1
    index=index-1
    DO m=1,n-1
      DO i=izero1,n-m
        HO=x(i)-d_log_energy
        HP=x(i+m)-d_log_energy
        wdel=c(i+1)-d(i)
        xdel=HO-HP
        IF (xdel.NE.0.D0) THEN	! error treatment
          xdel=wdel/xdel
        ELSE
!test
          write(5,*) 'Interpolation 0 delta',HO,wdel,i,m,Iint,jn,n,izero
        ENDIF
        d(i)=HP*xdel
        c(i)=HO*xdel
      ENDDO
      IF (2*index.LT.n-m) THEN
        erry=c(index+1)
      ELSE
        erry=d(index)
        index=index-1
      ENDIF
      yest=yest+erry
    ENDDO
  ENDIF
  IF (yest.LT.-1.5D02) THEN	! bound extrapolations
    polint=-1.5D02
  ELSEIF (yest.GT.1.5D02) THEN
    polint=1.5D02
  ENDIF
!T4:		Analytical Derivative Continuation for extrapolations:
  IF (n.GT.2.AND.Iint.GT.4.AND.templogenergy.LT.d_log_energy) THEN
    yest=d_log_xsect(jzero)-(d_log_xsect(jzero)-yest) &
        *(templogenergy-d_log_nrg(jzero))/0.0001
    d_log_energy=templogenergy
  ENDIF
!94			Explicit errors, and inappropriate near edge
!94			or for low-energy edges (at all)...:
  IF (n.GT.2.AND.d_log_energy.GT.d_log_nrg(jzero).AND.Iint.GT.4 &
      .AND.d_log_energy.LT.d_log_nrg(jn+jzero-1) &
      ) THEN	! interpolating, higher order
!	IF (ien-jzero.GT.1.AND.n.GT.2.AND.
!	1 d_log_energy.GT.d_log_nrg(jzero).AND.Iint.GT.4
!	1.AND.d_log_energy.LT.d_log_nrg(jn+jzero-1)
!	1.AND.d_log_energy.GT.-1.) THEN	! interpolating, higher order, <1keV
!			! DABS(erry).GT.0.2D0*yest.OR. omitted
!94?		ien-jzero.GT.1.AND..AND.d_log_energy.GT.-1.
    Lest=y(index0)+(y(index0+1)-y(index0)) &
        *(d_log_energy-x(index0))/(x(index0+1)-x(index0))
!T2:	 IF (ien-jzero.EQ.0) THEN	! first interpolation section
!	  Loff=0.2
!	  Lscale=0.7
!	 ELSEIF (ien-jzero.EQ.1) THEN	! second interpolation section
!	  Loff=0.18
!	  Lscale=0.5
!	 ELSEIF (ien-jzero.GE.2) THEN	! third interpolation section
!	  Loff=0.15
!	  Lscale=0.35
!	 ENDIF
!	 IF (yest.GT.Lest+Loff) THEN
!	  yest=(yest-Lest-Loff)*Lscale+Lest+Loff
!	 ELSEIF (yest.LT.Lest-Loff) THEN
!	  yest=(yest-Lest+Loff)*Lscale+Lest-Loff
!T2.	 ENDIF
!T3:
    IF (d_log_nrg(jzero).LT.-0.8) THEN	! somewhat arbitrary -0.8 (ln)
      IF (ien-jzero.LE.1) THEN	! first/second interpolation sections
        Lscale=1.
      ELSEIF (ien-jzero.EQ.2) THEN	! third interpolation section
        Lscale=1.-0.3*(d_log_energy-d_log_nrg(jzero+2))/ &
            (d_log_nrg(jzero+3)-d_log_nrg(jzero+2))
      ELSEIF (ien-jzero.EQ.3) THEN	! fourth interpolation section
        Lscale=0.7-0.21*(d_log_energy-d_log_nrg(jzero+3))/ &
            (d_log_nrg(jzero+4)-d_log_nrg(jzero+3))
      ELSEIF (ien-jzero.EQ.4) THEN	! fifth interpolation section??
        Lscale=0.49-0.147*(d_log_energy-d_log_nrg(jzero+4))/ &
            (d_log_nrg(jzero+5)-d_log_nrg(jzero+4))
      ENDIF
    ELSE
      IF (ien-jzero.EQ.0) THEN	! first interpolation section
        Lscale=1.-0.4*(d_log_energy-d_log_nrg(jzero))/ &
            (d_log_nrg(jzero+1)-d_log_nrg(jzero))
      ELSEIF (ien-jzero.EQ.1) THEN	! second interpolation section
        Lscale=0.6-0.24*(d_log_energy-d_log_nrg(jzero+1))/ &
            (d_log_nrg(jzero+2)-d_log_nrg(jzero+1))
      ELSEIF (ien-jzero.GE.2) THEN	! third interpolation section
        Lscale=0.36-0.144*(d_log_energy-d_log_nrg(jzero+2))/ &
            (d_log_nrg(jzero+3)-d_log_nrg(jzero+2))
      ENDIF
    ENDIF
    yest=(yest-Lest)*Lscale+Lest
!T3.
    IF (yest.GT.y(index0).AND.yest.GT.y(index0+1) &
        .AND.bindnrg.GT.-1.) THEN
!		! non-monotonic => linear (on log-log plot)
!94			Simple correction / replacement:
!?	  yest=MAX(y(index0),y(index0+1))
!94			Better, mollified, replacement:
      yest=yest*Lscale+(1.-Lscale)*MAX(y(index0),y(index0+1))
    ELSEIF (yest.LT.y(index0).AND.yest.LT.y(index0+1) &
        .AND.bindnrg.GT.-1.) THEN
!94			Simple correction / replacement:
!?	  yest=MIN(y(index0),y(index0+1))
!94			Better, mollified, replacement:
      yest=yest*Lscale+(1.-Lscale)*MIN(y(index0),y(index0+1))
    ENDIF
  ENDIF
!test	write(5,*) 'pol',yest,erry,n,izero,index0
  polint=yest
  RETURN
END
!******************************************************************
!		 bubble sort.  largest becomes last
subroutine sort(n,a,b)
  implicit none
  integer n
  DOUBLE PRECISION a(11), b(11)
  INTEGER i,j
  DOUBLE PRECISION x,y
!
  DO i=1,n-1
    DO j=i+1,n
      IF(a(j).lt.a(i)) THEN
        x=a(j)
        y=a(i)
        a(i)=x
        a(j)=y
        x=b(j)
        y=b(i)
        b(i)=x
        b(j)=y
      ENDIF
    ENDDO
  ENDDO
  RETURN
END
!-------------------------------------------------------------------------
