!-------------------------------------------------------------------------
!		FFCOM.FOR common block and constants
!	for FFCOMPARE.FOR and MOSCURVE3.FOR and FILELIND.FOR
!-------------------------------------------------------------------------
!U95  alterations by David Paterson December 95 to run on UNIX
!			element symbols
      character*2 elemend(92)
      COMMON/elecom/elemend
!			database integration
      DOUBLE PRECISION d_x(16), d_a(16)
      INTEGER iGLflag,iGLorder,iGLstep
!U95 change order of variables in common statement so will compile 
!U95 without warning on UNIX
      COMMON/GLweights/ d_x,d_a,iGLflag,iGLorder,iGLstep
!91			constants
      DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
        ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
      COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
        ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
	data elemend/'H ','HE','LI','BE','B ','C ','N ','O ','F ',&
         'NE','NA','MG','AL','SI','P ','S ','CL','AR',&
         'K ','CA','SC','TI','V ','CR','MN','FE','CO','NI','CU',&
         'ZN','GA','GE','AS','SE','BR','KR',&
         'RB','SR','Y ','ZR','NB','MO','TC','RU','RH','PD','AG',&
         'CD','IN','SN','SB','TE','I ','XE',&
         'CS','BA','LA','CE','PR','ND','PM','SM','EU','GD','TB',&
         'DY','HO','ER','TM','YB','LU',&
         'HF','TA','W ','RE','OS','IR','PT','AU','HG',&
         'TL','PB','BI','PO','AT','RN',&
         'FR','RA','AC','TH','PA','U '/
!91			constants
      DPIo2=DASIN(1.D0)
      DPI=DPIo2*2.D0		! 3.141592653589793D00 incorrect but consistent
      dln2=6.931471806D-1
      mec2=510.99906D0          ! (15) electron rest mass (keV)=mc2/e
      re0=2.81794092D-15	! (38) 1986 Adj. e2/mc2 (metres)
!	 classical electron radius=alpha^2 a_0
      hckeV=12.3984244D0	! (37) 1986 Adj. hc in Angstroms-keV
      Na11=6.0221367D+34	! (36) 1986 Adj. Avogadros no.10^11
      keV_per_Ryd=2.72113961D-2	! (81) (2Rhc=e2/a0=me4/hbar2)/e/1000
!		keV_per_Ryd converts au of energy to keV
      INV_FINE_STRUCT=137.0359895 !(61) alpha^-1=(2h/mu0=hbarE+7)/ce^2
      au_cross=re0**2*INV_FINE_STRUCT**4*1.0D+28
!	au cross-section in a_0^2 vs in barns (/atom)=2.8002848E+7
      e_per_b=5.D-22/re0/hckeV
! e_per_b*E(eV) converts the cross section in barns/atom
! into a cross-section in electrons/atom which is the same as f',f''.
! e_per_b= 10^{-8}/(2*re0=2.8179^-5*hc=12398.52) cf. V,p79,80
!old  data e_per_b/1.4311e-8/
!	data for gauss-legendre integration:
      d_x(1)=.04691007703067D0
      d_x(2)=.23076534494716D0
      d_x(3)=0.5D00
      d_a(1)=.11846344252810D0
      d_a(2)=.23931433524968D0
      d_a(3)=.28444444444444D0
      d_a(4)=.03333567215D00
      d_a(5)=.07472567455D00
      d_a(6)=.10954318125D00
      d_a(7)=.13463335965D00
      d_a(8)=.14776211235D00
      d_x(4)=.01304673575D00
      d_x(5)=.06746831665D00
      d_x(6)=.16029521590D00
      d_x(7)=.28331730295D00
      d_x(8)=.42556283055D00
      d_a(9)=.01357622970588D00
      d_a(10)=.03112676196932D00
      d_a(11)=.04757925584125D00
      d_a(12)=.06231448562777D00
      d_a(13)=.07479799440829D00
      d_a(14)=.08457825969750D00
      d_a(15)=.09130170752246D00
      d_a(16)=.09472530522754D00
      d_x(9)=.00529953250417D00
      d_x(10)=.02771248846338D00
      d_x(11)=.06718439880608D00
      d_x(12)=.12229779582250D00
      d_x(13)=.19106187779868D00
      d_x(14)=.27099161117138D00
      d_x(15)=.35919822461038D00
      d_x(16)=.45249374508118D00
