!----------------------------------------------------------------------
!B	CS5 for Bragg / Laue calculations...
!L	Laue5 replacement of CS5 for Laue and flat plate ray tracing.
!	Includes CS5, FORMF1, FORMF, FORMF0, F0CALCN, FHCALCN
!					  18 Aug. 1993 CTC
!Mac	Updated after crash 12 April 95 CTC Adding wrt thB(Broad source)
!U96	alterations by David Paterson + CTC Dec95-Jan96 to run on UNIX
!U96	Thesis precision, Results, Update Error of Thick and IF loops
!U96	detected and recovered. Hence mosaic slowed by factor of 100!
!plate96 Modifications to include plate function  David Paterson July96-?
!	See diagram in DJP thesis for explanation of geometry and variable names
!	CONCERNS: Laueffm sign/range/conv.; Laue5: A: Range/signs;
!	 B: Source definition and 3-d integration, current neglect of
!	    Dy, Dz varn; C: generality of GEN... subroutines;
!	 D: dsinthdy and Temt1 and Dymax signs...
!	 E: Propagation of Reflectivities and Transmission Coeffs
!----------------------------------------------------------------------
!	CS5 (in NEWCURVE) for the SPECIAL (Curved crystal) fn calcn
!		Separated from Moscurve3, 29 July 1992 CTC
!	Includes transfer subroutines FORMF,FORMF1,FORMF0 for ffsupp;
!	and structure factor calcn subroutines F0CALCN, FHCALCN
!----------------------------------------------------------------------
!	CV: Varney test / comparison lines commented out for efficiency
!	CTC: Chantler test / comparison lines commented out
!	Cchord: XX changed from chord defn(for th/Y detn) to arc(for cryst.lim)
!	Cold: OLDER lines with potentially larger errors
!	CERROR: OLDER lines illustrating explicit errors of earlier code
!----------------------------------------------------------------------
!	NEW FUNCTION: Determination of profile characteristics
!	incident on a detector in a 2R Rowland circle mount
!	with a semi-perfect CURVED diffracting crystal and a gaussian
!	source radiating along a plane at angle alpha to the crystal/film
!	generatrix.
!	HHcalc(xbdisp)=X0(scan)+2R(film)*asin([nlambda(corr)]/[2d/g])
!	where [2d/g](scan)=2d*DSQRT(1-beta**2)*cos(alpha)/(1-beta*sin(alpha))
!	  beta=beta(film)
!	  [nlambda(corr)]=n(order of diffn of line)*lambda0(line)*
!	(A3*Refl(line)/(1.-RI(line))+(1.-A3)*Refl2(line)/(1.-RI2(line))
!	/(A3*Refl+(1.-A3)*Refl2)	 = input 'x-posn'
!	with A3=%sigma polarisation incident on the diff crystal(film?),
!	     RI,RI2 = refractive index correction for each poln,
!	     Refl,Refl2 = Integrated reflectivity for each poln.
!----------------------------------------------------------------------------
!	The old ALPHA Monte Carlo method used
!	2d/[2d/g]=sin( Si Ka + DELHH(5-4)/2R ) / (n lambda(corr)/2d)
!	with estimates: beta=.137+/-.0005, sin(alpha)=a*(deln+n),
!	 del(n)=1.001+/- <.004, a=(3.70+/-.1)E-3, -2.<x<2.,
!	 Si Ka1 == .954084; Ka2 == .953583 => DEL ca .15mm+/- .1mm;
!	 DELHH + est. .0160mm +/- .005mm;
!	 2R= 300.+/-.1mm * HH,Stage angle .05R => 300.4+/-.15mm
!	 lambda(corr)= 7.088919 angstroms + blend of 7.091258 (est.10pc)
!	 2d=8.742 +/- .001 angstroms.
!	The precision was limited by the profile of the calibn line SiKa,
!	the blend in the Balmer line (used), and the early
!	and primitive fits of these lines.
!---------------------------------------------------------------------------
!2	ORDER OF INDEPT VARS: 2d (not fitted),2Rz,beta,wo,sina',BD,BX,
!	fractional Lamb shift err.=GB(7);
!	BEAM angle to spectrometer axis (alpha4, GB(8));
!	alpha'2=GB(9)=angle of longit.drive wrt z-axis (not inc. HH cpt);
!	a'3=angle of trans.drive wrt film z-axis (not inc. HH a')+ErNs scale.
!	 By measurement, errors (.1mu or rad) ==
!		.001A, 1000, .0005, 20000, <.015, 10000, 10000, ?(1), <.08,
!		<.01, <.02.
!--------------------------------------------------------------------------
!		The expression below is only correct for local (Ly/Ba)
!		comparisons and must be modified for the extended fit.
!		q.v. C2,subroutine CS5 in the programme for details.
!
!	  sin(alpha(scan))=IArc(film)*(deln(film)+n(scan))
!	[deln and IArc vary from line to line, Q is a fudge factor, 
!	 X0(nscans) also varies from line to line but is locally OK]
!--------------------------------------------------------------------------
!2						CTC 10.8.88
!2		Beginning of calcn: Along the real zero, the above
!	is OK; along a const. alpha line, 2R=2Rz/cos(alpha), but the scans
!	follow a RECTANGULAR grid at some angle a' to the zero alpha line.
!	Further, tan(alpha)= w/(Ychordz+BX') where
!		Ychordz.approx.2Rz*sin((Yiz+XX')/2Rz)+EX;
!			=DSQRT(Rz*Rz+(Rz+EX)**2-2Rz*(Rz+EX)cos((Yiz+XX')/Rz),
!		w is the perp. height from the zero axis,
!		Yiz is the arc from the intn of the zero axis & the perp.
!		 to the centre of the diffracting crystal,
!		XX' is the energy-dept diffn posn on the crystal wrt the
!		 centre (along the zero axis),
!		o subscripts refer to a reference beam-line 
!	  and   BX' is the distance along the zero axis from the diffng
!		 posn to the centre of the source.
!	w = wo + Ns(j)*(1.+Nsscale) + (Yiz-Yoz)tan(a'2),
!	wo wrt Yoz(1st scan)=Yoz0, Ns increase downstream (i.e. with scan)
!	BX'=-2Rz*sin(theta)+SQRT((2Rz*sin(theta))**2+2.2Rz.BD-4.BD.BD)
!	arc XX'=DX-2Rz.asin(BX.cos(theta)/(2Rz-BD))
!	arc Yiz = Yoz + (Yi-Yo)cos(a'), but Yi and Yo == different alphas
!		a'=.052+/-<.015; a'2=0.+/-<.01; Nsscale inc. a'err=0+/-<.02
!		The sign of Ns(j),gb9 & w0 are given by that of west, since
!	alpha1=the angle in the fwd dirn (& bma=angle towards crystal).
!	Since scan 1 is upstream of scan j, Ns(1)<Ns(j).
!
!	 N.B. A: defocussing is composed of three parts:
!	     1) Line broadening and asymmetry (measurable)
!	     2) Deviation of the diffng surface from the Rowland circle
!	  [ given by EX'= f(transparency of crystal to energy E) -
!	   GB(1)*.5+.5*DSQRT(GB(1)*GB(1)+XX*XX*2.)
!	     3) non-2R bending of the crystal + lattice imperfections
!	  (2) is calculated and accounted for here, and the deviation
!	  measured by (1) implies the presence of (3). Transparency
!	  == 7ppm or 2.66microns in error (1st order).
!		This routine explicitly accounts for the transparency
!	  of the crystal,the curvature and 'known deformation' and the
!	  defocussing due to non-coincidence of the film with the rotated
!	  (XX) or tilted (alpha) Rowland circle.
!2	 N.B. B: non-linearity of the film, errors in the radius of the
!	  front emulsion of the film, transverse and longitudinal varn
!	  of this radius are likely but give v.small effects and so are
!	  not accounted for in this model.
!	 N.B. C: different lines, having different production mechanisms
!	  and different lifetimes, shall have different zero alpha axes;
!	  this varn is slight (<<1mm) and is ignored herein. Errors in
!	  the location of the source give a shift of wo only.
!	 N.B. D: the vertical angle of the crystal wrt the spectrometer
!	  is assumed to be 90deg(-alpha3). Varn will occur and affect:
!	  BEAM ALPHA=alpha1+alpha3, alphavert=alpha1 still, but this
!	  = atan(west'/(BX'+Ychordz'));
!	    west'=west*cos(alpha3-alpha1)/cos(alpha1);
!	    BX'=BX*cos(alpha3); Ychordz'=Ychordz/cos(alpha3)-BXsin(a3)**2.	
!	  This is horribly convoluted, so I'm not doing it! Varn of the
!	  diffn planes wrt the crystal surface is hopefully zero.
!	 N.B. E: the est. distances from source centre to crystal are
!	  BD=15mm to near pnt of Rowland Circle; BX=26mm to crystal pole;
!	  These have large errors (1.mm) and are fitted.
!-------------------------------------------------------------------------
!			Procedure for a single line:
!	     1: Calc. expected locn on film for pnt source kinematic
!		diffraction off the surface;
!	A: Cycle A to establish Th1,xbdisp,Thout,Yshift ranges;
!		 B to provide profiles;
!		  2: Loop over: deviation from this angle;
!				xbdisp (not y) deviation from the point (pointing at X(th1));
!		  3: Calc. diffn off layers for |y|<10, t(y=0)<ta absn limit;
!		  4: Calc. shift of locn and Thetaout around crystal;
!		  5: Calc. shift of locn on film, and intensity cpt;
!		  endloop;
!		 endcycle;
!	     6: Calc. profile and mean shift.
!----------------------------------------------------------------------------
SUBROUTINE CS5(ICycle,dalpha,lambda,Twod,swidth,K,aplane,G,ORDER,Bragg)
  IMPLICIT NONE
!		      Passed vars:
  DOUBLE PRECISION dalpha,lambda,Twod,swidth,K,aplane,G
  DOUBLE PRECISION ORDER
  INTEGER ICycle,Bragg
!91			Form factor variables
  INTEGER ielem
  PARAMETER (ielem=20)
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!			GENDAT variables:
  INTEGER NINDEPT
  PARAMETER (NINDEPT=28)
  INTEGER MAXK,KM(NINDEPT),ISP,OFL,OFL2,MS,JM
  DOUBLE PRECISION GB(NINDEPT),ERGB(NINDEPT),LB(NINDEPT), &
      UB(NINDEPT),GBP(NINDEPT),LBP(NINDEPT),UBP(NINDEPT), &
      ERGBP(NINDEPT)
  COMMON/FITVAR/ GB,ERGB,LB,UB,GBP,LBP,UBP,ERGBP, &
      MAXK,KM,ISP,OFL,OFL2,MS,JM
!92			major new curved crystal variables:
  DOUBLE PRECISION AxisTh,ABtem,Mininc,THABX,THBAX,BXmin
  DOUBLE PRECISION thm1C(2),ThminC(2),ThmaxC(2),thminoC(2) &
      ,thmaxoC(2),YozC(2),YminoC(2),YmaxoC(2)
  INTEGER VARMAX,Isect(2)
  COMMON/CS5B/AxisTh,ABtem,Mininc,THABX,THBAX,BXmin &
      ,thm1C,ThminC,ThmaxC,thminoC,thmaxoC,YozC,YminoC,YmaxoC &
      ,VARMAX,Isect
!		      Common (I/O) vars (CS5-Rcurve)
  INTEGER ISTEPSO,ISTEPSP
  PARAMETER (ISTEPSO=8000,ISTEPSP=8001)
  DOUBLE PRECISION RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr
  DOUBLE PRECISION MPSIr2,MPSIi2,p,s,K1,Temth0,Thout0, &
      muabs,mcurv,mReftem1,Maxt2,umbo2
  DOUBLE PRECISION Irel1(ISTEPSP),Irel2(ISTEPSP),Irel3(ISTEPSP), &
      Reflint(6),Reflintth,ReflintHy,Mshift1,Mshift2,Mshift3(2,2), &
      Mshift4(3),Ermshift4,MShiftB(6),Irel5(ISTEPSP),Irel6(ISTEPSP)
  DOUBLE PRECISION MaxI1,MaxI2,MaxI3,MaxI4,Thpk, &
      Thpko,Ypko,Th1,Thout,Yshift, &
      STEPS1,STEPS2,STEPS3,STEPS4,basym,IRELM
  COMMON/CS5C/RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr,MPSIr2,MPSIi2, &
      p,s,K1,Temth0,Thout0,muabs,mcurv,mReftem1,Maxt2,umbo2, &
      Irel1,Irel2,Irel3,Reflint,Reflintth,ReflintHy,Mshift1, &
      Mshift2,Mshift3,Mshift4,Ermshift4,MShiftB,Irel5,Irel6,MaxI1, &
      MaxI2,MaxI3,MaxI4,Thpk,Thpko, &
      Ypko,Th1,Thout,Yshift,STEPS1,STEPS2,STEPS3,STEPS4,basym &
      ,IRELM
!
  DOUBLE PRECISION c251,c252,c253,c751,c752,c753,mt0
  DOUBLE PRECISION mq2,PkTh1,Reflinto,thmaxf,thminf,Mosdel, &
      c1ff(6),c2ff(6),ffpk(2),Maxff,maxt0,maxt3,sigscat,siginc &
      ,Reflintm,Reflinty,ReflintthinC
  DOUBLE PRECISION transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm(2,8,2)
  INTEGER K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2
  CHARACTER numstr*4
  COMMON/CS5D/c251,c252,c253,c751,c752,c753,mt0,mq2,PkTh1, &
      Reflinto,thmaxf,thminf,Mosdel,c1ff,c2ff, &
      ffpk,Maxff,maxt0,maxt3,sigscat,siginc,Reflintm,Reflinty, &
      Reflintthinc,transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm,K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2,numstr
!
  INTEGER ffs
  PARAMETER (ffs=30100)
  COMPLEX*16 DPSI0, DPSIHr, DPSIHi
  DOUBLE PRECISION Thm2,Thm3,Temthm2,Temthm3,Yrel(ISTEPSP,6), &
      Thtem(ffs),Rtem(ffs),Ttem(ffs),Ytem(ffs),dely0,dely0t,mufilm, &
      TEMUL,Mphotoshift,mdepth(6),mthld(6),emthld(2) &
      ,mcontl,meanff(7,2),maxdp,maxdm,thff,Chinit,Chfin
  DOUBLE PRECISION Rzf,Cx
!93atest:	add mYo for output asymmetry evaluation:
  DOUBLE PRECISION fscale,RtemC(ffs),TtemC(ffs),Tabdy(ffs,4),mYo(6)
  DOUBLE PRECISION BXm,BXx
  INTEGER fof,detmatch,ip
  COMMON/CS5E/ DPSI0,DPSIHr,DPSIHi,Thm2,Thm3,Temthm2,Temthm3,Yrel, &
      Thtem,Rtem,Ttem,Ytem,dely0,dely0t,mufilm,TEMUL,Mphotoshift, &
      mdepth,mthld,emthld,mcontl,meanff,maxdp,maxdm,thff &
      ,Chinit,Chfin,Rzf,Cx,fscale,RtemC,TtemC &
      ,Tabdy,mYo,BXm,BXx,fof,detmatch,ip
!93atest-
  INTEGER IREAD,Photo,Jbit4,Fwrite(0:20)
  COMMON/CS5F/ IREAD,Photo,Jbit4,Fwrite
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!		      Time vars
!		Time vars
  DOUBLE PRECISION Maxtim,DTIME(6),Mtime,Ntime
  REAL*4 Time0,Time1,Time2,Tim2f,Tim21,Tim22
  COMMON/clockt/ Maxtim,DTIME,Mtime,Ntime,Time0,Time1,Time2,Tim2f &
      ,Tim21,Tim22
  INTEGER Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
  COMMON /COMINTS/ Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
!
!V	new AV variables (for MCP detector)
!	DOUBLE PRECISION XD,XDmin,XDmax,XD0,thetaD,Thetaap2V
!	COMMON/CS5G/ XD,XDmin,XDmax,XD0,thetaD,Thetaap2V
!		  Diffn vars from COMFFM/Braggffm:
  DOUBLE PRECISION bigD,bigQ,U,V,sa,sv,sw,Maxt,Maxt1,mz2
  COMPLEX*16 dq,dz,dqplusz2,drtqp2,cc2p1
  COMPLEX*16 ctem,ctem2,cx1,cx2,cc1,cc2,cc1p,cc2p,ctemr,ctemt
  DOUBLE PRECISION rc,tc,ddel,logttime
!		      Mosaic vars
  DOUBLE PRECISION Ascale,Rfact(0:ffs),temsum
  INTEGER Idel,Imax,Ist,Jst,Jast
!		      Other FFM variables:
  INTEGER EXTRASTEPS,tflag,ittime,Iolddel,Mosflag
  DOUBLE PRECISION JU,JL,JU2,JL2,JU3,JL3,JU4,JL4,norm
  DOUBLE PRECISION Temt1,tmin,Delthm,thtime &
      ,sintime,costime,costh,Tem5,Tem4,t0,GB1,sinth,dely &
      ,ytime,rtime,ttime,yffpk,Tlim,Delthf,scTemth,dsinthdy,TemU
  COMMON /COMFFM/ bigD,bigQ,U,V,sa,sv,sw,Maxt,Maxt1,mz2 &
      ,dq,dz,dqplusz2,drtqp2,ctem,ctem2,cx1,cx2,cc1,cc2,cc1p,cc2p &
      ,cc2p1,ctemr,ctemt,rc,tc,ddel,logttime,Ascale,Rfact,temsum &
      ,Idel,Imax,Ist,Jst,Jast,EXTRASTEPS,tflag &
!U96: norm
      ,ittime,JU,JL,JU2,JL2,JU3,JL3,JU4,JL4,norm,Iolddel &
      ,Mosflag,Temt1,tmin,Delthm,thtime,sintime,costime &
      ,costh,Tem5,Tem4,t0,GB1,sinth,dely,ytime,rtime,ttime &
      ,yffpk,Tlim,Delthf,scTemth,dsinthdy,TemU
!93		,sin2T0,sin2apl,cos2apl cancelled
!DEC92:		      Yiz estimates + CMac meanxxp
  DOUBLE PRECISION YozestC(2),YestfC(2,2) &
      ,YestcC(2,2),ThetaacC(2,2),XXC(2),minxxp(2),maxxxp(2) &
      ,meanxxp(2),STEPS1o
  COMMON /COMYEST/ YozestC,YestfC,YestcC,ThetaacC,XXC &
      ,minxxp,maxxxp,meanxxp,STEPS1o
!93atest:		extreme .1%ile estimates:
  DOUBLE PRECISION MaxI3t
  INTEGER K2min,K3min,K2maxt,K3maxt,K3Imax
  COMMON /COMEXTREME/ MaxI3t,K2min,K3min,K2maxt,K3maxt,K3Imax
!93atest-
!		      Temp. vars
  INTEGER I,K1I,K2I,K3I,K8I,ITEST,ITIMES,Iold,I1L,I1U, &
      I2L,I2U,I3L,I3U,Iast3,Ist3,J
  DOUBLE PRECISION Tem,TemL,tlast0, &
      tlast1,tlast,Reftem1,Reftem1C,XXtem,muext,Utem,Vtem,TemSk, &
      cosThl,sinThl,sinThs,cosThs,sinhaw2,sinav2,thmaxt, &
      thmint,thprint,Irel4,rold,told,thold,rnew,irelscale, &
      tnew,thnew,cosalpha,sinalpha,cosaplane,sinaplane, &
      Onotemt1,MaxI12,MaxI13,Ypk1o,Thpk1o,Kdiff,tem5f &
      ,TsurfF
  COMPLEX*16 cpolf,ctemrf(2),ctemtf(2),sinthp
!91
  DOUBLE PRECISION DELX,CENT3,WDTH3,CENT2,WDTH2,CENT8
!Mac
  DOUBLE PRECISION xdiff,Th1x,DelthL, &
      Th1diff
!		      Geometric vars
  DOUBLE PRECISION Temxl,xline,BXp,XXp &
      ,DXXp2,XXp2,thetaouts
!		      Emulsion vars
  DOUBLE PRECISION theta3,maxx,dydchx,ONEchx,NORMx &
      ,delyshiftC(2),minth3,maxth3,minthap2,maxthap2,dchxdy
!		      Important loop vars:
  DOUBLE PRECISION Temth,tmax,Thetaap, &
      xbdisp,Temth1,IREL,Thetas,A02,dt0,ysurf,Dymax,ylayer,Cumt, &
      Thlayer,rlayer,tlayer,dbar,Sk,Refl,IRELR,Yiz,Sum, &
      Skin,Wgt(100),ndely1,ndely2,thetaap2,Sk0
!
!plate96
  INTEGER Outfilesflag,Ist8,Iast8,I8L,I8U !
  DOUBLE PRECISION &
      Thoutp(ISTEPSP),		 &! Thout used in plate calc end of layerloop cycle
      Thetaap2p(ISTEPSP), 	 &! Thetaap2  used in plate calc end of layerloop  
      
      Detcenx(2), 		 &! centre position of detector, should be zero
      MaxK8I,MinK8I,	 &! extreme ray numbers of K8I flate plate 
      Irel28(ISTEPSP),Irel9(ISTEPSP), &
      WDTH8,MaxI18,MaxI8,Detxpk1o,  &!variables to store info about Irel8 array
      lo1pc, hi1pc, Maxchan,  &!variables to store info about Irel8 array
      lo50pc, hi50pc !variables to store info about Irel8 array
  DOUBLE PRECISION  Irel8(ISTEPSP),  &! Rel intensity on Plate detector
      Detminx(2),Detmaxx(2), &! max and min range onto detector
      K8maxt,Detxpko    
  INTEGER K8max,K8min,STEPS8
!MK03************************************************************************
!MK03 The variables Detxpk1o, low1pc, hi1pc, low50pc, hi50pc were added to 
!MK03 the COMMON variables under CS5Plate by Mark Kinnane (3/10/03).
  COMMON /CS5Plate/ &
      Irel8,Detminx,Detmaxx,K8maxt,Detxpko,  &! Irel8==IrelPlate
      K8max,K8min,STEPS8,Detxpk1o,lo1pc,hi1pc,lo50pc,hi50pc
!MK03************************************************************************
  INTEGER iplate            ! plateswitch calc output for plate =1,
!plate96                     !=0 for Rowland circle
  DOUBLE PRECISION Detx	 &!position of ray on flat plate
      ,Detarmlen	 &!length of detector arm 
      ,Detbeta		 &!angle of detector plate to detector arm,ideal=0 deg
      ,Detphi  &!angle of detector arm to incident radiation=(two theta)/2	  
      ,Dettheta  &!Calc'd angle of detector equivalent to AV's ThetaD
      ,Rplate    &!Radius of centre of detector plate from centre of Rowland 
      ,Defocus	  !Rplate - Rowland =defocusing of detector
  COMMON/PLATE/Detx,Detarmlen,Detbeta,Dettheta,Rplate
  
  DOUBLE PRECISION sinthsd,sinthld,thetaoutl,Dymaxt, &
      sintho,costhld,sinthol,sintemth0,costemth0,sintemths, &
      sinthins,thins,sinthout0,sinthfs,sinthfo,costlt, &
      sinthcs,sintemtho,costhsd
  INTEGER ntot,ntotp,layer,ntott,detflag
!L
  DOUBLE PRECISION Refll(0:10000),dbarl(0:10000),Tranl(0:10000) &
      ,thldl(0:10000),thoutl2(0:10000),temt1l(0:10000) &
      ,thetaap2l(0:10000),Pathl(0:10000),ylayl(0:10000) &
      ,RSk(0:10000),Tsum1l(0:10000)
!L
!		      Mshift4 loop vars
  DOUBLE PRECISION thtem4,thtema(2),thtema4,Yoztem,sinth2 &
      ,dyizdthtem,Scale,costh2
  DOUBLE PRECISION tem24,Reftem,dyizdtha,dyizdtemth,dthadtemth
!93test			Temporary test variables:
  DOUBLE PRECISION dyizdthtemC,thtema4V,dthtema4dthtemV,tem14 &
      ,dthtema4dthtem,Tem1,dyizdtemxl
!		Gen. geometry temporary variables:
  INTEGER VL
  DOUBLE PRECISION GB6,TEMTERM,TEMSQRT,Rzftem,YtemoC &
      ,ThetmnC(2),ThetmxC(2),Thetas1,Thsrange
  DOUBLE PRECISION XXC2(2),thetaaC(2),EANGC(2),THABXp(2),DelthC &
      ,theta3C(2),Thm2C(2),Thm3C(2),thld,thlt,sintlt,thinl,thoutl &
      ,thm3t,Imdepth2(ISTEPSP),Imthld2(ISTEPSP),Irels &
      ,Irels3,Irel22(ISTEPSP),Irel23(ISTEPSP),adely,adelth
  INTEGER Isecto(2)
!
  DOUBLE PRECISION temth0g,temtho,temthog,temths,temthsg &
      ,thminsg,thmaxsg,Delthap,thetaspi,thetasd,thetaoutg,ABtemp &
      ,thminog,thmaxog,thld0g,thlt0g,thmint0g,thmaxt0g,thf0g &
      ,thfog,thfo,thfsg,thfs,thcsg,thcs,thco,thcog,thc0g &
      ,thmino,thmaxo,JUC1,JUC2,JUC3,JLC1,JLC2,JLC3,temSTEPS &
      ,thminf3,thmaxf3,JUP1,JLP1,JUP2,JLP2,JUP3,JLP3,JUQ2,JLQ2
  DOUBLE PRECISION Temeg,Temog,Temsg,Temsg2,Temog2,toldel &
      ,sthmint0g
  LOGICAL CTC
!L
  DOUBLE PRECISION I2Rz,Minthinc
!93atest:
  DOUBLE PRECISION PZ               ! Plate Location = Rzf!
  DOUBLE PRECISION JLQ3,JUQ3    	! c0013 counters
  DOUBLE PRECISION IRELMo           ! Cycle 1 est scale for MaxI3t
  DOUBLE PRECISION BXpp             ! test for Delthap alternative
  DOUBLE PRECISION meanyl			! post-itimes average
  DOUBLE PRECISION sinthldl,thldl1,costhldl	! ditto
  DOUBLE PRECISION adely1,adelth1	! adely for I+1
!93atest:
  DOUBLE PRECISION Thtem2(ffs),Rtem2(ffs),Ttem2(ffs)
  COMMON/FFREFL/Thtem2,Rtem2,Ttem2
  DOUBLE PRECISION Tabdy2(ffs,4)
  COMMON/FFTable/Tabdy2
!UJun96			Supplementary ranges:
  DOUBLE PRECISION Irel7		! for MaxI1r
  DOUBLE PRECISION Ytem2(ffs)	 &!=Thin
      ,t0pk,t0c					 &!non-overrun lamellar/mosaic thicknesses
      ,JUM,JLM,JLM2,JUM2,JLM4,JUM4,JL1,JU1	 &! mosdel convolved widths
      ,pcontl									 &! last trunc layer Refl*IREL
      ,xmin1,xmax1,xmin,xmax					 &! xrange: initial & final
      ,Thm2L(2),Thm3L(2)						 &! th1 ranges (VL)
      ,MaxI1r,MaxI3r,mcontr,pcontr			! reflectivity maxima
  INTEGER Jmaxff,Jmaxff2,xtot,ptot,pdivs
  COMMON/FFmarkers/Ytem2,t0pk,t0c &
      ,JUM,JLM,JLM2,JUM2,JLM4,JUM4,JL1,JU1 &
      ,pcontl,xmin1,xmax1,xmin,xmax,Thm2L,Thm3L,MaxI1r,MaxI3r,mcontr,pcontr &
      ,Jmaxff,Jmaxff2,xtot,ptot,pdivs
!93atest-
  DOUBLE PRECISION THSET
!93atest-
!-------------------------------------------------------------------
!			FPS interface functions
!onvex      REAL SECNDS
  REAL SECNDS
!onvex      EXTERNAL SECNDS
!      DOUBLE PRECISION DREAL
!      DOUBLE PRECISION DIMAG
!      DOUBLE PRECISION XREALX,YREALY
!      COMPLEX*16 XCMPLX
!      COMPLEX*16 CDEXP
!      COMPLEX*16 DCMPLX
!      COMPLEX*16 CDSQRT
!
!      DREAL(XCMPLX)=REAL(XCMPLX)
!      CDEXP(XCMPLX)=CEXP(XCMPLX)
!      DIMAG(XCMPLX)=AIMAG(XCMPLX)
!      DCMPLX(XREALX,YREALY)=CMPLX(XREALX,YREALY)
!      CDSQRT(XCMPLX)=CSQRT(XCMPLX)
!-------------------------------------------------------------------
!			Zero output:
!plate96
  iplate =1
  Reflint(1)=0.D0
  Reflintth=0.D0
  ReflintHy=0.D0
  Reflinty=0.D0
  Reflintthinc=0.D0
  minxxp(1)=Maxdp	! maxdel = 1/2 crystal arc
  maxxxp(1)=-Maxdm
  minxxp(2)=Maxdp	! maxdel = 1/2 crystal arc
  maxxxp(2)=-Maxdm
  mdepth(ip)=0.D0
  mthld(ip)=0.D0
!UJun96      mcontl=0.D0	Redundant?
  Mshift1=0.D0
  Mshift2=0.D0
  Mshift3(1,ip)=0.D0
  Mshift3(2,ip)=0.D0
  MshiftB(3*ip-2)=0.D0
  MshiftB(3*ip-1)=0.D0
  Mphotoshift=0.D0
!UJun96:      MaxI1=0.D0
!UJun96:      MaxI2=0.D0
!UJun96:      MaxI4=0.D0
!			Constants:
!      CTC=.FALSE.	! CTC may be false, but is truer!
  detmatch=0	! reset detector match; assume OK
  cosaplane=DCOS(aplane)
  sinaplane=DSIN(aplane)
  cosalpha=DCOS(dalpha)
  sinalpha=DSIN(dalpha)
  PZ=Rzf		! c93atest!
  sinTh=lambda/Twod		! Doppler corrected ab initio; sinth >0
!L
  IF (DABS(GB(1)).LT.1.D-9) THEN
    I2Rz=0.0
  ELSE
    I2Rz=1.D0/GB(1)
  ENDIF
!L
  IF (ip.EQ.1) THEN
    cpolf=DCMPLX(1.D0,0.D0)+DPSI0
  ELSE		! ip=2, pi
    cpolf=DCMPLX(1.D0,0.D0)
  ENDIF
  IF (sinTh.GT.1.1.AND.Igraz.NE.1) THEN	! seriously imaginary!
    detmatch=1
    WRITE(*,10)
10  FORMAT(' a) No match for this diffracting plane')
    VL=1
    VARMAX=1
    CALL OUTFILS(VL,dalpha,lambda,Twod,swidth,ORDER)
    RETURN
  ELSEIF (sinTh.GT..9999) THEN	! 0 < Temth0 < DPIo2
    VARMAX=2
    Temth0=DPIo2		! ray tracing approximation
    sinTemth0=1.D0
    cosTemth0=0.D0
  ELSE
    VARMAX=2
    Temth0=DASIN(sinTh)
    sinTemth0=sinth
    cosTemth0=DCOS(Temth0)
  ENDIF			! not 'Temth', but note effect on Gx
  costh=DMAX1(cosTemth0,1.D-5)
!93:
  CALL GENTHSG(sinTemth0,cosTemth0,sinaplane,cosaplane &
      ,sinalpha,cosalpha,0.D0,sinThins,sinThout0 &
      ,Thins,Temthsg,Temth0g,Thout0,Temthog)	! on Gx to/from surface
!B
  IF (Bragg.EQ.1) THEN
    basym=-sinThins/sinThout0		! Bragg
  ELSE
    basym=sinThins/sinThout0		! Laue alternative !
  ENDIF
!L
  Tem5=DSQRT(MPSIr2)*K/2.D0/sinth
  umbo2=(1.D0-basym)/2.D0			!=1 in Symm.Bragg Refln
  dsinthdy=-DSQRT(DABS(basym))/basym*Tem5	! <0 for Laue
  Temt1=DMIN1(DMAX1(-dsinthdy/costh,-1.D8),1.D8)	!1st est, to 1E-4
  GB1=GB(1)/cosalpha            ! modified 2R off Genx
!
!93	1: Calc. expected locn on film for pnt source kinematic
!93	diffraction off crystal surface (symmetric Bragg):
!L		location on plate given by subroutine... Xoz
!	2d,l in 0.1mu; should include dalpha correctly (below==Gx)
!	! Xoz should not (?) include basym,aplane,Cx,Rzf
!		                  ! est of kinetic peak, th1 range
!		versus new:
  IF (DCOS(Temthsg)*GB1/ABtem.GT.1.D0) THEN
    YozC(1)=GB(1)*Temth0		! alternate default; also vs 0.D0
    YozC(2)=GB(1)*Temth0		! alternate default; also vs 0.D0
  ELSE
    CALL GENGEOMC(XXC(1),XXC(2),Thm1C(1),Thm1C(2),ThetaaC(1), &
        ThetaaC(2),GB(1),AxisTh,GB(6),Temthsg,ABtem,THABX &
        ,THBAX,THABXp(1),THABXp(2),Isecto(1),Isecto(2))
!v      CALL GENGEOM(XCH(1),XCH(2),EANG(1),EANG(2),GB(1),AxisTV,
!v     1   GB(6),TemTV,VARFLAG)
    DO VL=1,2			! I==VARLOOP
!B        BX=GB(6)*DSIN(AxisTh-ThetaaC(VL)/2.D0)
!B     1      /DSIN(Temthsg+ThetaaC(VL)/2.D0)
!L			Not used; was not general, either.
!l        IF (GB(1).LT.ABtem.AND.
!l     1     (Isecto(VL).EQ.2.OR.Isecto(VL).EQ.4)) THEN
!l         BXp=GB(1)*DCOS(THABXp(VL)+Temthsg)/DSIN(THABXp(VL))
!l        ELSE
!l         BXp=GB(1)*DCOS(THABXp(VL)-Temthsg)/DSIN(THABXp(VL))
!l        ENDIF
      thtema(VL)=thetaaC(VL)
!B
      IF (Bragg.EQ.1) THEN
        Rzftem=GB(1)/2.D0
!plate96    WRITE(*,*) 'ThetaaC just before call to GENXYS',ThetaaC(VL)
        CALL GENXYS(YozC(VL),Theta3,detflag,xline, &
            thtema(VL),GB(1),Axisth,Temthog,0.D0,Rzftem,Isect(VL))
        CALL PLATEFUNC (Detx,Temthog,GB(1),Cx,Axisth,thtema(VL), &
            Detarmlen,Dettheta,Detbeta,Rplate)
        IF (VL.EQ.1) THEN
          WRITE(*,11) Detx,Temthog,Axisth,thtema(VL)
11        FORMAT(4X,'Centre of Detector: Detx,Temthog,Axisth,thtema(VL)',4(1PE10.3,','))
        ENDIF
      ELSE
        CALL GENXPZ(YozC(VL),Theta3,xline,thtema(VL) &
            ,GB(1),Axisth,Temthog,THABX,THBAX,PZ,0.D0,Isecto(VL),detflag)
      ENDIF
!L
    ENDDO
  ENDIF
!TC		Note: dalpha assumed zero in this subroutine:
  IF (IREAD.EQ.1) Tim2f=SECNDS(Time1)	!vs S(Time0)-Time1
!MacTest		WRITE(*,*) 'Time/CS5',Tim2f,Time0,Time1
  VL=1
  CALL BRAGGFFM(K,sinaplane,cosaplane,sinalpha,cosalpha &
      ,aplane,lambda,ORDER,Bragg)
  toldel=DMIN1(3.D-2,2.D0*(c2ff(ip+2)-c1ff(ip+2)))	!2x percentile range
  IF (IREAD.EQ.1) Tim21=SECNDS(Time1)	!vs old
  IF (AGE.EQ.1) THEN
    VARMAX=1
    CALL OUTFILS(VL,dalpha,lambda,Twod,swidth,ORDER)
    RETURN
  ENDIF
!TC		Finished ffm calcn; prepare for cycling:
!
!93:	Reset asymmetry for Bragg after braggffm:
!B
  IF (Bragg.EQ.1) THEN
    basym=-sinThins/sinThout0	! Still for Bragg angle
  ELSE
    basym=sinThins/sinThout0		! Still for Bragg angle
  ENDIF
!L
  Tem5=DSQRT(MPSIr2)*K/2.D0/sinth
  dsinthdy=-DSQRT(DABS(basym))/basym*Tem5
  umbo2=(1.D0-basym)/2.D0			!=1 in Symm.Bragg Refln
  Temt1=DMIN1(DMAX1(-dsinthdy/costh,-1.D8),1.D8)	!1st est, to 1E-4
  muext=DPI*DPI/2.D2/lambda*DSQRT(MPSIr2) !assume 100 layers,I/Io=.5**4
  Maxt1=1.2D1*DSIN(Temthsg)/(muabs+muext)	!12 extn lengths?
  Maxt=DMAX1(1.D0,DMIN1(Maxt1,Maxt2)) ! est. max t/crystal t
!
!92old     		ITIMES evaluation for inner loop
  mdvs=MAX(IDNINT(t0/1.D1),3)		! 1.0mum precision
  IF (Mosflag.EQ.0) THEN
    mdvs=MIN(mdvs,100)			! precision limit
  ELSE
    mdvs=MIN(mdvs,20)
  ENDIF
!     Yozest should include basym,aplane,Cx(included from Temxl),Rzf:
  IF (ABtem.GE.GB(1)) THEN
    Minthinc=0.D0
  ELSE
    Minthinc=Mininc
  ENDIF
  CALL GENTHSG(sinTemth0,cosTemth0,sinaplane &
      ,cosaplane,sinalpha,cosalpha,Minthinc &
      ,sinTemths,sinTemtho,Temths,Temsg &
      ,Temeg,Temtho,Temog)	! on Gx to/from surface WITH MININC=0(Laue)
!		versus new (determine sectors):
  Tem1=sinTemths-DCOS(Temths-AxisTh)*GB(6)/GB(1)
  CALL GENGEOMC(XXC(1),XXC(2),EANGC(1),EANGC(2),ThetaaC(1), &
      ThetaaC(2),GB(1),AxisTh,GB(6),Temsg,ABtem,THABX &
      ,THBAX,THABXp(1),THABXp(2),Isect(1),Isect(2))
!92
  DO VL=1,2			! I==VARLOOP
!L		Not referenced...
!l        IF (GB(1).LT.ABtem.AND.
!l     1     (Isect(VL).EQ.2.OR.Isect(VL).EQ.4)) THEN
!l         BXp=GB(1)*DCOS(THABXp(VL)+Temsg)/DSIN(THABXp(VL))
!l        ELSE
!l         BXp=GB(1)*DCOS(THABXp(VL)-Temsg)/DSIN(THABXp(VL))
!l        ENDIF
!B       BX=GB(6)*DSIN(AxisTh-ThetaaC(VL)/2.D0)
!B     1      /DSIN(Temsg+ThetaaC(VL)/2.D0)
!       	! YozestC(VL)  ref posn; == pnt source, est.
!		! diffn, no penetration of surface, 'focussed':
!B
    IF (Bragg.EQ.1) THEN
!plate96		WRITE(*,*) 'ThetaaC lkine 606 before call to GENXYS',ThetaaC(VL)
      CALL GENXYS(YozestC(VL),Theta3,detflag,xline, &
          ThetaaC(VL),GB(1),Axisth,Temog,Cx,PZ,Isect(VL))	!PZ=Rzf
      IF (detflag.EQ.1 &
          .OR.Temth0+toldel.LT.Minthinc) THEN	! not temthsg???
        WRITE(*,13) VL
13      FORMAT(1X,' c) VL=',I1,',No match on spectrometer surface' &
            ,'(R C, Gx) near peak with aplane')
        VARMAX=1
        IF (VL.EQ.1) THEN
          detmatch=1
          WRITE(*,*) 'line 620 Thout,Irel2(1),Irel3(1),thetaap2', &
              Thout,Irel2(4000),Irel3(4000),thetaap2
          CALL OUTFILS(VL,dalpha,lambda,Twod,swidth,ORDER)
          RETURN	! closest solution fails
        ENDIF
      ENDIF
    ELSE
      CALL GENXPZ(YozestC(VL),Theta3,xline,ThetaaC(VL) &
          ,GB(1),Axisth,Temog,THABX,THBAX,PZ,0.D0,Isect(VL),detflag)
    ENDIF
!L
  ENDDO
!DEC92test Thm1C(1),Thm1C(2), ,thtema(1),thtema(2)
  WRITE(*,20) EANGC(1),EANGC(2),XXC(1),XXC(2) &
      ,ThetaaC(1),ThetaaC(2) &
      ,Isecto(1),Isecto(2),Isect(1),Isect(2) &
      ,YozC(1),YozC(2),YozestC(1),YozestC(2) &
      ,Temth0,Temths,Temsg,Temog,THABX
20 FORMAT(1X,'Yoz:th1',2(1PE11.4),' XX' &
       ,2(1PE11.4),' tha',2(1PE11.4),/,' S',I2,3(I1),';Y',2(1PE11.4) &
       ,2(1PE11.4),/,' Temth0,s/g,og=',4(1PE11.4) &
       ,';ABAx ',1PE12.5)
!DEC92 below:
!        YestfC includes b,ap,Cx,Rzf; AND RI shift, Profile a/s:
  CALL GENTHSG(DSIN(meanff(7,ip)),DCOS(meanff(7,ip)) &
      ,sinaplane,cosaplane,sinalpha,cosalpha,Minthinc,sinthfs &
      ,sinthfo,thfs,thfsg,thf0g,thfo,thfog)	! diff.ang. -> on Gx,surface
!1093:			Limit for Fresnel Domination signature:
  IF (Temog.GT.DMIN1(Temthm2,Temthm3).AND.thfog.LT. &
      DMIN1(Temthm2,Temog,Temthm3)) THEN
    thfsg=DMIN1(Temthm2,Temog,Temthm3)
    thfog=thfsg				! Approxn
  ENDIF
!		new (determine sectors):
  CALL GENGEOMC(XXC(1),XXC(2),EANGC(1),EANGC(2),ThetaaC(1), &
      ThetaaC(2),GB(1),AxisTh,GB(6),thfsg,ABtem,THABX &
      ,THBAX,THABXp(1),THABXp(2),Isect(1),Isect(2))
  DO VL=1,2			! I==VARLOOP
    IF (GB(1).LT.ABtem.AND. &
        (Isect(VL).EQ.2.OR.Isect(VL).EQ.4)) THEN
      BXp=GB(1)*DCOS(THABXp(VL)+thfsg)/DSIN(THABXp(VL))
    ELSE
      BXp=GB(1)*DCOS(THABXp(VL)-thfsg)/DSIN(THABXp(VL))
    ENDIF
!B       BX=GB(6)*DSIN(AxisTh-ThetaaC(VL)/2.D0)
!B     1      /DSIN(thfsg+ThetaaC(VL)/2.D0)
!		! diffn, no penetration of surface, 'focussed'
!B
    IF (Bragg.EQ.1) THEN
!plate96	   WRITE(*,*) 'ThetaaC line 664 GENXYS',ThetaaC(VL)
      CALL GENXYS(YestfC(VL,ip),Theta3C(VL),detflag,xline, &
          ThetaaC(VL),GB(1),Axisth,thfog,Cx,PZ,Isect(VL))	!PZ=Rzf
      IF (detflag.EQ.1) THEN
        WRITE(*,14) VL
14      FORMAT(1X,' cf) VL=',I1,',No match on detector surface' &
            ,'(R C, Gx) with aplane')
        VARMAX=1
        IF (VL.EQ.1) THEN
          detmatch=1
          WRITE(*,*) 'line 679 Thout,Irel2(1),Irel3(1),thetaap2', &
              Thout,Irel2(4000),Irel3(4000),thetaap2
          CALL OUTFILS(VL,dalpha,lambda,Twod,swidth,ORDER)
          RETURN	! closest solution fails
        ENDIF
      ENDIF
    ELSE
      CALL GENXPZ(YestfC(VL,ip),Theta3C(VL),xline,ThetaaC(VL) &
          ,GB(1),Axisth,thfog,THABX,THBAX,PZ,0.D0,Isect(VL),detflag)
    ENDIF
!L
  ENDDO
!DEC92test
  WRITE(*,22) EANGC(1),EANGC(2),XXC(1),XXC(2) &
      ,ThetaaC(1),ThetaaC(2),Isect(1),Isect(2) &
      ,YestfC(1,ip),YestfC(2,ip)
22 FORMAT(1X,'Yestf:th1',1PE11.4,1PE10.3,';XX',1PE11.4 &
       ,1PE10.3,';tha',1PE11.4,/,1X,1PE10.3,' S',2(I2),';Y' &
       ,1PE11.4,1PE10.3)
!DEC92 above
!chord      IF (DABS(XXC(1)).GT.2.D0*GB(1)*DSIN(maxdel/GB(1)/2.D0)) THEN
!M      IF (DABS(XXC(1)).GT.maxdel) THEN		! XX=arc from now on!
  IF (XXC(1).GT.maxdp.OR.XXC(1).LT.-maxdm) THEN	! XX=arc from now on!
    WRITE(*,*) ' d0) No match on crystal (R circle, Gx, aplane)'
!94       detmatch=1
    VL=1
    VARMAX=1
!94       CALL OUTFILS(VL,dalpha,lambda,Twod,swidth,ORDER)
!94       RETURN
!chord      ELSEIF (DABS(XXC(2)).GT.2.D0*GB(1)*DSIN(maxdel/GB(1)/2.D0)) THEN
  ELSEIF (XXC(2).GT.maxdp.OR.XXC(2).LT.-maxdm) THEN	! XX=arc from now on!
    WRITE(*,*) ' d1) 1 match on crystal (R circle, Gx) with aplane'
    VARMAX=1
  ELSEIF (Bragg.EQ.1) THEN
!B
    VARMAX=2
  ELSE
    VARMAX=1
!L
  ENDIF
  DO VL=1,VARMAX						! == VARLOOP
    IF (Photo.EQ.1) THEN
      maxx=TEMUL/DSIN(theta3C(VL))				! pathlength
      NORMx=1.D0/mufilm*(1.D0-DEXP(-mufilm*maxx))
      delyshiftC(VL)=1.D0/mufilm/mufilm-DEXP(-mufilm*maxx)/mufilm &
          *(1.D0/mufilm+maxx)
      delyshiftC(VL)=delyshiftC(VL)/NORMx*DCOS(theta3C(VL))	! Yiz shift
    ELSE
      delyshiftC(VL)=0.D0
    ENDIF
  ENDDO
!      muext=DPI*DPI/2.D2/lambda*DSQRT(MPSIr2) !assume 100 layers,I/Io=.5**4
!ERROR:				! leave this until later
  thtem4=Temsg		! angle to surface; plane ignoring aplane
  tem14=tem1
!************************** Real RI corrn ******************************
!		A: Icycle 1
!		alternate range detn:
!
!92	thmint=min for CTC case if Th1=+ve to right of Axis
!       reverse convention/AJV case 2/second soln leads to thmint=max
!U96:	Use JUM2 (thin) vs JU2 (original and thick):
!      thmaxf3=thminf+Delthf*(JU2-1.D0)/DFLOAT(STEPSF-1) ! not max/AxisTh
  thmaxf3=thminf+Delthf*(JUM2-1.D0)/DFLOAT(STEPSF-1) ! not max/AxisTh
!Mac old inclusion of source was for parallel rays:
!      thmint=DMAX1(DMIN1(thmaxf3+swidth/DABS(GB1/DSIN(thmaxf3))
!     1     +3.D-4,DPIo2),Minthinc)			! inc. angle; n.b. aplane
!Mac new inclusion of source is for convergent rays:
  thmint=DMAX1(DMIN1(thmaxf3+DABS(swidth)*.75D0/GB(6) &
      +3.D-4,DPIo2),Minthinc)			! inc. angle; n.b. aplane
!L		Note thminf==thinc; GENTHSG:thdiff->thinc
!B      CALL GENTHSG(DSIN(thmint),DCOS(thmint)
!B     1 ,sinaplane,cosaplane,sinalpha,cosalpha,Minthinc,sinTemths
!B     2 ,sinTemtho,Temths,thminsg,thmint0g,thmaxo,thmaxog) !on Gx to/from surf.
!L
  thminsg=thmint
  CALL GENTHD(thminsg,sinaplane,cosaplane,sinalpha,cosalpha &
      ,sinth,sinTemths,sinTemtho,Temths,sthmint0g &
      ,thmint0g,thmaxo,thmaxog) !inc:- diff -> inc. from surf.
!L		versus new (sectors defined):
  CALL GENGEOMS(XXC2(1),XXC2(2),ThminC(1),ThminC(2),ThetmnC(1), &
      ThetmnC(2),GB(1),AxisTh,GB(6),thminsg,ABtem,THABX &
      ,THBAX,THABXp(1),THABXp(2),Isect(1),Isect(2))
  
  DO VL=1,2
!B
    IF (Bragg.EQ.1) THEN
!platedebug         WRITE (*,*) 'ThetmnC,Isect(VL),thmaxog',ThetmnC(VL),Isect(VL),thmaxog
      CALL GENXYS(YminoC(VL),Theta3C(VL),detflag,xline, &
          ThetmnC(VL),GB(1),Axisth,thmaxog,Cx,PZ,Isect(VL))
!B			!PZ=Rzf, thmaxog vs ThminoC(VL)
!plate96 calc of centre position on flat plate detector should be zero
! 			check on geometry
      Rplate = DSQRT((GB(1)/2.D0+Cx)**2+Detarmlen**2-2.0D0*(GB(1)/2.D0+Cx)*Detarmlen* &
               DCOS(DPIo2-Axisth))
      Dettheta = DASIN(Detarmlen*DSIN(DPIo2-Axisth)/Rplate)
      Defocus = Rplate - GB(1)/2.D0
      CALL PLATEFUNC (Detcenx(VL),Axisth,GB(1),Cx,Axisth,0.0D0, &
                      Detarmlen,Dettheta,Detbeta,Rplate)
!plate96 Safety checks on centering of Detector 	     
      IF(Detcenx(VL).GT.1.0D-8.AND.VL.EQ.1) THEN
        WRITE (*,*) ' WARNING Detcenx(VL) does not equal zero problem with geometry'
        WRITE (*,23) Detcenx(VL)
23      FORMAT(1X,'value of Detcenx(VL)',F6.2)
      ENDIF
      
      
      IF(DABS(Defocus).GT.1.0D5.AND.VL.EQ.1) THEN
        WRITE (*,25) Defocus/1.D5
25      FORMAT(' WARNING DETECTOR IS STRONGLY DEFOCUSED: >1cm from Rowland circle',F6.2,'cm')
      ELSE
        WRITE (*,261) defocus
261     FORMAT(1X,'DEFOCUS of plate detector:',1PE10.3)
      ENDIF
!plate96 calc of min position on flat plate detector
      CALL PLATEFUNC (Detminx(VL),thmaxog,GB(1),Cx,Axisth,ThetmnC(VL), &
          Detarmlen,Dettheta,Detbeta,Rplate)
      
      IF(DABS(Detminx(1)).GT.3.0D5.AND.VL.EQ.1) THEN
        WRITE (*,*) 'WARNING extreme rays are missing detector '
      ENDIF
      IF (detflag.EQ.1) THEN
        YminoC(VL)=YestfC(VL,ip)
      ENDIF
    ELSE
      CALL GENXPZ(YminoC(VL),Theta3C(VL),xline,ThetmnC(VL) &
          ,GB(1),Axisth,thmaxog,THABX &
          ,THBAX,PZ,0.D0,Isect(VL),detflag)
    ENDIF
  ENDDO
!DEC92test
  WRITE(*,24) XXC2(1),thminsg,thmaxog,thmint0g &
      ,ThetmnC(1),ThetmnC(2),YminoC(1)	!,Isect(1),Isect(2)
24 FORMAT(1X,'MX',(1PE10.3), &
       ';thm',3(1PE10.3),';a',3(1PE10.3))
  
!L			Wrong: Dy=f(thD), not ths
!      Dymax=-(DACOS(DCOS(thminf)/DABS(Maxt/GB1+1.D0))-thminf)/Temt1 ! >0 L-,B+
!U96:		Use JLM2 (thin) vs JL2 (original/thick):
!      thminf3=DMIN1(thminf+Delthf*(JL2-1.D0)/DFLOAT(STEPSF-1),DPIo2)
  thminf3=DMIN1(thminf+Delthf*(JLM2-1.D0)/DFLOAT(STEPSF-1),DPIo2)
!Mac old inclusion of source was for parallel rays:
!      thmaxt=DMAX1(thminf3-swidth/DABS(GB1/DSIN(thminf3))
!     1   -3.D-4			! -DABS(Dymax*Temt1)
!     1   ,Minthinc)		! inc. angle
!Mac new inclusion of source is for convergent rays:
  thmaxt=DMAX1(thminf3-DABS(swidth)/GB(6)	 &!*.75D0
      -3.D-4,Minthinc)		! inc. angle
!U96: use larger range-
!		! min ths/x=0, -delth(x=+/-1sd), -delth(bottom layer)
!L		Note thminf==thinc; GENTHSG:thdiff->thinc
!B      CALL GENTHSG(DSIN(thmaxt),DCOS(thmaxt)
!B     1 ,sinaplane,cosaplane,sinalpha,cosalpha,Minthinc,sinTemths
!B     2 ,sinTemtho,Temths,thmaxsg,thmaxt0g,thmino,thminog) !on Gx to/from surf.
!L
  thmaxsg=thmaxt
  CALL GENTHD(thmaxsg,sinaplane,cosaplane,sinalpha,cosalpha &
      ,sinth,sinTemths,sinTemtho,Temths,sthmint0g &
      ,thmaxt0g,thmino,thminog) !inc:- diff -> inc. from surf.
  CALL GENGEOMS(XXC2(1),XXC2(2),ThmaxC(1),ThmaxC(2),ThetmxC(1), &
      ThetmxC(2),GB(1),AxisTh,GB(6),thmaxsg,ABtem,THABX &
      ,THBAX,THABXp(1),THABXp(2),Isect(1),Isect(2))
  DO VL=1,2
!B
    IF (Bragg.EQ.1) THEN
      WRITE (*,*) 'ThetmxC,thminog,Isect(VL)',ThetmxC(VL),thminog,Isect(VL)
      CALL GENXYS(YmaxoC(VL),Theta3C(VL),detflag,xline, &
          ThetmxC(VL),GB(1),Axisth,thminog,Cx,PZ,Isect(VL))
!B				!PZ=Rzf; thminog vs ThmaxoC(VL)
!plate96 calc of max position on flat plate detector
      CALL PLATEFUNC (Detmaxx(VL),thminog,GB(1),Cx,Axisth,ThetmxC(VL), &
          Detarmlen,Dettheta,Detbeta,Rplate)        
      
      IF(DABS(Detmaxx(1)).GT.3.0D5) THEN
        WRITE (*,*) 'WARNING extreme rays are missing detector '
      ENDIF
      IF (detflag.EQ.1) THEN
        YmaxoC(VL)=YestfC(VL,ip)
      ENDIF
    ELSE
      CALL GENXPZ(YmaxoC(VL),Theta3C(VL),xline,ThetmxC(VL) &
          ,GB(1),Axisth,thminog,THABX &
          ,THBAX,PZ,0.D0,Isect(VL),detflag)
    ENDIF
  ENDDO
  STEPS8=2.D3
  MinK8I=IDINT(Detminx(1)/(Detmaxx(1)-Detminx(1))*(STEPS8-1.D0)+1.D0)
  MaxK8I=IDINT(Detmaxx(1)/(Detmaxx(1)-Detminx(1))*(STEPS8-1.D0)+1.D0)
  WRITE(*,24) XXC2(1),thmaxsg,thminog,thmint0g &
      ,ThetmnC(1),ThetmnC(2),YmaxoC(1)	!,Isect(1),Isect(2)
  WRITE (*,*) 'value of Detminx(1),Detmaxx(1),YminoC(1),YmaxoC(1)', &
      Detminx(1),Detmaxx(1),YminoC(1),YmaxoC(1)
!L
  IF (Thmino.GT.Thmaxo) THEN	! Laue diffraction?
    Tem=Thmaxo
    Thmaxo=Thmino
    Thmino=Tem
  ENDIF
  DO VL=1,VARMAX
    ThmaxoC(VL)=thmaxo
    ThminoC(VL)=thmino
!92		Invert max/min as appropriate:
!	case 1 (CTC) 2nd soln; case 2 (AJV) 1st soln:
    IF (ThminC(VL).GT.ThmaxC(VL)) THEN
      WRITE(*,15) VL
15    FORMAT(1X,' f) ThmaxC/minC error/inversion, VL=',I2)
      Tem=ThmaxC(VL)
      ThmaxC(VL)=ThminC(VL)
      ThminC(VL)=Tem
    ENDIF
  ENDDO
!92		CTC Local (VL) sector limits: in th1 (anti-cwise):
!Mac	note Thm2=crystal limit inc. x, Thm2C=sector limit w/o x
!Mac	note is Laue sign interpretation still OK for xdiff?
  xdiff=DABS(swidth)/GB(6)*.75D0
  DO VL=1,VARMAX
    IF (GB(1).GT.ABtem) THEN
      IF (Isect(VL).EQ.1.AND.Thm2.LT.THABX-DPI) THEN
        Thm2C(VL)=THABX-DPI-xdiff
      ELSEIF (Isect(VL).EQ.2.AND.Thm2.LT.THABX-DPIo2) THEN
        Thm2C(VL)=THABX-DPIo2-xdiff
      ELSEIF (Isect(VL).EQ.3.AND.Thm2.LT.THABX-DPIo2-DPI) THEN
        Thm2C(VL)=THABX-DPIo2-DPI-xdiff
      ELSEIF (Isect(VL).EQ.4.AND.Thm2.LT.THABX) THEN
        Thm2C(VL)=THABX-xdiff
      ELSE
        Thm2C(VL)=Thm2
      ENDIF
      IF (Isect(VL).EQ.1.AND.Thm3.GT.THABX-DPIo2) THEN
        Thm3C(VL)=THABX-DPIo2+xdiff
      ELSEIF (Isect(VL).EQ.2.AND.Thm3.LT.THABX) THEN
        Thm3C(VL)=THABX+xdiff
      ELSEIF (Isect(VL).EQ.3.AND.Thm3.LT.THABX-DPI) THEN
        Thm3C(VL)=THABX-DPI+xdiff
      ELSEIF (Isect(VL).EQ.4.AND.Thm3.LT.THABX+DPIo2) THEN
        Thm3C(VL)=THABX+DPIo2+xdiff
      ELSE
        Thm3C(VL)=Thm3
      ENDIF
    ELSEIF (GB(1).LE.ABtem) THEN
      IF (Thm2.LT.0.AND.((BXm.GT.BXmin.AND.Isect(VL).EQ.2) &
          .OR.(BXm.LE.BXmin.AND.Isect(VL).EQ.1))) THEN
        Thm2C(VL)=Mininc-DPIo2-xdiff
      ELSEIF (Thm2.LT.THABX.AND.Isect(VL).LE.2) THEN
        Thm2C(VL)=Thm2
      ELSEIF (Isect(VL).LE.2) THEN
        Thm2C(VL)=THABX-xdiff
      ELSEIF (Thm2.LT.THABX.AND.Isect(VL).GT.2) THEN
        Thm2C(VL)=THABX-xdiff
      ELSEIF (Thm2.GT.THABX.AND.((BXm.GT.BXmin.AND.Isect(VL).EQ.4) &
          .OR.(BXm.LE.BXmin.AND.Isect(VL).EQ.3))) THEN
        Thm2C(VL)=DPIo2-Mininc-xdiff
      ELSEIF (Isect(VL).GT.2) THEN
        Thm2C(VL)=Thm2
      ENDIF
      IF (Thm3.LT.0.AND.((BXm.GT.BXmin.AND.Isect(VL).EQ.2) &
          .OR.(BXm.LE.BXmin.AND.Isect(VL).EQ.1))) THEN
        Thm3C(VL)=Mininc-DPIo2+xdiff
      ELSEIF (Thm3.LT.THABX.AND.Isect(VL).LE.2) THEN
        Thm3C(VL)=Thm3
      ELSEIF (Isect(VL).LE.2) THEN
        Thm3C(VL)=THABX+xdiff
      ELSEIF (Thm3.LT.THABX.AND.Isect(VL).GT.2) THEN
        Thm3C(VL)=THABX+xdiff
      ELSEIF (Thm3.GT.THABX.AND.((BXm.GT.BXmin.AND.Isect(VL).EQ.4) &
          .OR.(BXm.LE.BXmin.AND.Isect(VL).EQ.3))) THEN
        Thm3C(VL)=DPIo2-Mininc+xdiff
      ELSEIF (Isect(VL).GT.2) THEN
        Thm3C(VL)=Thm3
      ENDIF
    ENDIF
    IF (ThmaxC(VL).LT.Thm2.OR.ThminC(VL).GT.Thm3 &
        .OR.ThmaxC(VL).EQ.ThminC(VL)) THEN
      IF (VL.EQ.1) THEN	! sector edges irrelevant??
        WRITE(*,*) ' g0) No match of max/min for crystal length'
!94         detmatch=1
        VARMAX=1
!94         CALL OUTFILS(VL,dalpha,lambda,Twod,swidth,ORDER)
        ThmaxC(VL)=Thm2
        ThminC(VL)=Thm3
!94         RETURN
      ELSE
        WRITE(*,*) ' g1) One match of max/min for crystal length'
        VARMAX=1
      ENDIF
    ELSE
!Mac			*** Allow for broad source imaging ***
      IF (ThmaxC(VL).GT.Thm3C(VL)) THEN	! thmino and Yoz limited later
        WRITE(*,1111) 'ax=',ThmaxC(VL),Thm3,Thm3C(VL) &
            ,'in=',ThminC(VL),Thm2,Thm2C(VL)
        ThmaxC(VL)=Thm3C(VL)
      ENDIF
      IF (ThminC(VL).LT.Thm2C(VL)) THEN
        WRITE(*,1111) 'in=',ThminC(VL),Thm2,Thm2C(VL) &
            ,'ax=', ThmaxC(VL),Thm3,Thm3C(VL)
        ThminC(VL)=Thm2C(VL)
      ENDIF
    ENDIF
    IF (YmaxoC(VL).LT.YminoC(VL)) THEN
      YtemoC=YmaxoC(VL)
      YmaxoC(VL)=YminoC(VL)
      YminoC(VL)=YtemoC
      WRITE(*,*)' YminoC(VL),YmaxoC(VL),VL',YminoC(VL),YmaxoC(VL),VL
    ENDIF
!plate96
    IF (Detmaxx(VL).LT.Detminx(VL)) THEN
      YtemoC=Detmaxx(VL)
      Detmaxx(VL)=Detminx(VL)
      Detminx(VL)=YtemoC
      WRITE(*,*)'Inversion of Detminx(VL),Detmaxx(VL),VL',Detminx(VL),Detmaxx(VL),VL
    ENDIF
!L				ad hoc. (== Bragg?):
    YminoC(VL)=YminoC(VL)-2.D-4*DABS(GB(1))/ORDER &
        *DFLOAT(Mosflag+1)+delyshiftC(VL)
    YmaxoC(VL)=YmaxoC(VL)+2.D-4*DABS(GB(1))/ORDER &
        *DFLOAT(Mosflag+1)+delyshiftC(VL)
!L
  ENDDO
1111 FORMAT(1X,'Thm',A3,1PE11.4,' v',2(1PE11.4) &
         ,',M',A3,1PE11.4,2(1PE11.4))
!TC		Versus old (and AJV):
!      Thmin=DMAX1(Thmin,Thm2)      ! centre -.02, or crystal lim.(x=0)
!      Thmax=DMIN1(Thmax,Thm3)
!
!DEC92test                   
  WRITE(*,26) ThminC(1),ThminC(2),ThmaxC(1),ThmaxC(2) &
      ,XXC2(1),XXC2(2)
!test     1   ,ThetaaC(1),ThetaaC(2),Isect(1),Isect(2)
!t     2  ,ThminoC(1),ThminoC(2),ThmaxoC(1),ThmaxoC(2)
!t     3  ,YminoC(1),YminoC(2),YmaxoC(1),YmaxoC(2)
26 FORMAT(1X,'Min/Max:th1',2(1PE10.3,1PE9.2),';XX' &
       ,(1PE10.3,1PE9.2))
!t     2 ,/,' thaSoY',(1PE10.3,1PE8.1),2(I2),4(1PE11.4,1PE8.1))
!92			Begin cycle over VARMAX:
  DO VL=1,VARMAX
!       thtema4=thetaaC(VL)	! variables for Mshift4 calcn at end
    Yoztem=YozestC(VL)
!Mac		Dominated by source width?: Thm2 inc. x but not Temthm2?
!Mac		Th1= Thm2 -> Thm3; but we want Ths= Temthm2/3/mininc -> 2/3
    Thsrange=DABS(Temthm3-Temthm2)	! OK unless mininc=thaxis=thpk
    IF (Thsrange/DABS(swidth)*GB(6).LT..2) THEN
      STEPS2=4.D2
!93atest:
      STEPS1=9.D0                     ! older5.D0
!	   ELSEIF (Thsrange/DABS(swidth)*GB(6).LT.1.5) THEN
!        STEPS2=4.D1		! best ray-tracing but like offset rulers
!        STEPS1=5.D1		! so low IR, profile precision
    ELSE
      STEPS1=4.D2		! AJV 2.D3 and old(er) 400
      STEPS2=9.D0                     ! older5.D0             ! AJV 1.D
    ENDIF
!93atest-
    STEPS3=2.D3
    STEPS4=2.D3
!plate96 STEPS8 is no. of steps along flat plate face 	   
    STEPS8=2.D3
    STEPS1o=8.D2
    ICycle=1
    IF (Iprecs.GT.1) THEN
!U96: Unnecessary:	    STEPS1=DMIN1(STEPS1*DFLOAT(Iprecs),DFLOAT(ISTEPSO))
      STEPS1=STEPS1*DFLOAT(Iprecs)
!U96-
      STEPS2=DMIN1(STEPS2*DFLOAT(Iprecs),DFLOAT(ISTEPSO))
    ENDIF
    WRITE(*,*)YminoC(VL),YmaxoC(VL)
    WRITE(*,595) ThminC(VL),ThmaxC(VL),Thmino,Thmaxo,YminoC(VL) &
        ,YmaxoC(VL),numstr(1:1),NINT(ORDER)	! ,lambda
595 FORMAT(1X,'Cyc1 Thmin/ax',2(F7.4), &
        ';tho',2(F7.4),';Yo',2(1PE9.2),' pol',A1,I2)	! ,',l=',1PE10.3)
    MaxI3t=0.D0	! ??? do not rezero after first cycle.
!Mac!!!	First Cycle Crystal or sector limits only; x accounted for later:
    Thm2L(VL)=Thm2C(VL)+xdiff
    Thm3L(VL)=Thm3C(VL)-xdiff
    DelthL=(Thm3L(VL)-Thm2L(VL))/(STEPS1-1.D0)
!Mac		Source option with square shape
    IF (AGE.GE.4) THEN                  ! X=0 only
      swidth=0.D0
      DELX=1.D0
!plate96	    xmin=0.2D4
!plate96	    xmax=0.2D4
      xmin=0.D0
      xmax=0.D0
    ELSEIF (swidth.LT.0.D0) THEN
      DELX=-swidth/(STEPS2-1.D0)
      xmin=.5D0*swidth
      xmax=-xmin
    ELSE
      DELX=1.5D0*swidth/(STEPS2-1.D0)
      xmin=-.75D0*swidth
      xmax=-xmin
    ENDIF
!UJun96		Cycle 1 = Source parameters:
    xmin1=xmin
    xmax1=xmax
!93atest:           was rezeroed but not updated -> K2min = min ray (not .5%)
!UJun96      MaxI2=0.D0
600 CONTINUE
    Reflint(1)=0.D0
    Reflintth=0.D0
    ReflintHy=0.D0
    Reflinty=0.D0
    Reflintthinc=0.D0
    minxxp(VL)=Maxdp	! maxdp = +ve (anticlockwise) 1/2 of crystal arc
    maxxxp(VL)=-Maxdm
    meanxxp(VL)=0.D0
    mdepth(ip)=0.D0
    mthld(ip)=0.D0
    mcontl=0.D0
!UJun96		Reinstating xtot determination in Feb 13 code.
    xtot=1
    pcontl=0.D0
    mcontr=0.D0
    pcontr=0.D0
    MaxI3r=0.D0
    MaxI1r=0.D0
    ptot=0
    pdivs=0
    Mshift1=0.D0
    Mshift2=0.D0
    Mshift3(VL,ip)=0.D0
    MshiftB(3*ip-3+VL)=0.D0
    Mphotoshift=0.D0
    MaxI1=0.D0
    MaxI4=0.D0
    minth3=10.
    maxth3=-1.
    minthap2=10.
    maxthap2=-1.
    DO I=1,ISTEPSP
      Irel1(I)=0.D0
      Irel2(I)=0.D0
      Irel3(I)=0.D0
      Irel5(I)=0.D0
      Irel6(I)=0.D0
!plate96       
      Irel8(I)=0.D0
      Irel9(I)=0.D0
      Imdepth2(I)=0.D0
      Imthld2(I)=0.D0
      Irel22(I)=0.D0
      Irel23(I)=0.D0
      Irel28(I)=0.D0
      DO J=1,6
        Yrel(I,J)=0.D0
      ENDDO
    ENDDO
!plate96 WDTH = 2.0 in second cycle ie 2 channels of broadening      
    WDTH3=STEPS4/2.D3            ! use aliasing width for Yo=min/est.
    WDTH2=STEPS3/2.D3			   ! thout
    WDTH8=STEPS8/2.D3	!this may be too much broadening check later
    K2max=ISTEPSP
    K3max=ISTEPSP
!plate96
    K8max=ISTEPSP
    K2min=K2max
    K3min=K3max
    K8min=K8max
    K2maxt=0
    K3maxt=0
    K8maxt=0
    GB6=GB(6)/cosalpha
    thprint=5.D2
    Sum=0.D0
    Refl=0.D0
    IF (AGE.LT.4.AND.swidth.GT.0.D0) THEN
!      IRELM=1.8788745574D0*1.5/STEPS2
      irelscale=-2.7725887224D0/swidth/swidth
!UJun96: xmin1 range, not xmin
      DO xbdisp=xmin1,xmax1,DELX
        IREL=DEXP(irelscale*xbdisp*xbdisp)	! *IRELM
        Sum=Sum+IREL
      ENDDO
      IRELM=1.D0/Sum
    ELSEIF (AGE.LT.4.AND.swidth.LT.0.D0) THEN
      Sum=1.D0
      IRELM=1.D0/(STEPS2-1.D0)
    ELSE
      Sum=1.D0
      IRELM=1.D0
    ENDIF
!UJun96:               rescale MaxI3t: base K2min/max on 0.9xMaxI3t, not MaxI2
    IF (Icycle.EQ.2) MaxI3t=MaxI3t*IRELM/IRELMo*9.D-1 !to expect reset
!UJun96      ThminC(VL)=Thm2L(VL)-5.D-1*(Thm3L(VL)-Thm2L(VL)) !for correct counting
!UJun96      ThmaxC(VL)=Thm3L(VL)+5.D-1*(Thm3L(VL)-Thm2L(VL)) !L=precn th1 range,
!U96		 C=output th1x
!			Iprecs cut-offs
    IF (Iprecs.EQ.0) THEN
      ndely1=6.D0*dely0t	! calcn and ray tracing vs 5dy0/4.5dy0
      ndely2=DMIN1(2.D0*(c2ff(ip+4)-c1ff(ip+4)),0.25*Delthf) ! v.25/.27*Delthf
    ELSE
!UJun96			Time to change ndely1? e.g. (6.D0+DBLE(Iprecs))*dely0t
      ndely1=8.D0*dely0t	! calcn and ray tracing
      ndely2=DMIN1(4.D0*(c2ff(ip+4)-c1ff(ip+4)) &
          ,0.35*Delthf)		! mosaic tracing: hwhm=2(.1%-.1%) v .35*Delthf
    ENDIF
!MacTest		WRITE(*,*)'1',Sum,DELX,xmin,xmax,swidth,AGE,ThminC(VL),ThmaxC(VL)
!
!	     2: Loop over: deviation from this angle;
!		            x=xbdisp deviation from the point;
!Mac!!!			Ranges computed above; x accounted for below:
    DelthC=(ThmaxC(VL)-ThminC(VL))/(STEPS1o-1.D0)
    DO Th1=Thm2L(VL),Thm3L(VL),DelthL   ! cylindrical symm.
!old      DO 1030 Th1=ThminC(VL),ThmaxC(VL),DelthC   ! cylindrical symm.
      
      DO xbdisp=xmin,xmax,DELX
        
!UJun96:
        Irel7=0.D0
        THABXp(VL)=DABS(THABX-Th1)		! CL abs for S3,S4
!L       Thetas=DACOS(DMIN1(ABtem*DSIN(THABXp(VL))/DABS(GB(1))+xbdisp/GB(1) &
!                           ,1.D0)) ! on Gx cpt.
!Mac!!
        Thetas1=DACOS(DMIN1(ABtem*DSIN(THABXp(VL))/DABS(GB(1)),1.D0))!on Gx cpt.
        IF ((Isect(VL).EQ.2.OR.Isect(VL).EQ.4) &
            .AND.GB(1).LT.ABtem) THEN
          Delthap=DPIo2-THABXp(VL)-Thetas1	! THBAXp
        ELSE
          Delthap=DPIo2-THABXp(VL)+Thetas1
        ENDIF
!L
!B		Note following designed for S2-> 1 or 3; not S1/3->?
!        IF (Th1.LT.THABX-DPI) THEN
!         Thetaap=DPIo2-THABX+Axisth+Delthap
!        ELSE
!         Thetaap=DPIo2-THABX+Axisth-Delthap
!B        ENDIF
!L
        IF (Isect(VL).LE.2) THEN
          Thetaap=THBAX-Delthap
        ELSEIF ((Isect(VL).EQ.3.AND.GB1.GT.ABtem).OR. &
            (Isect(VL).EQ.4.AND.GB1.LT.ABtem)) THEN
          Thetaap=THBAX+Delthap
        ELSE
          Thetaap=THBAX+Delthap-2.D0*DPI
        ENDIF
!L
!chord        XXp=2.D0*GB(1)*DSIN(thetaap/2.D0)
        XXp=DABS(GB(1))*thetaap			! XX = arc from now on!
!M        IF (DABS(XXp).GT.Maxdel) GOTO 1025	! surface point off crystal!
        IF (XXp.GT.maxdp.OR.XXp.LT.-maxdm) GOTO 1025	! off crystal!
!b        BX=GB(1)*DSIN(Delthap)/DSIN(THABXp(VL))	! affects transcale
!        IF (GB(1).LT.ABtem.AND.
!     1     (Isect(VL).EQ.2.OR.Isect(VL).EQ.4)) THEN
!         BXpp=DABS(GB(1))*DCOS(THABXp(VL)+Temthsg)/DSIN(THABXp(VL))
!       ELSE
!         BXpp=DABS(GB(1))*DCOS(THABXp(VL)-Temthsg)/DSIN(THABXp(VL))
!        ENDIF
!93atest:
        BXp=DABS(GB(1))*DSIN(Delthap)/DSIN(THABXp(VL))
!Mac!!!			Include x converging to crystal surface:
!				XXp, thetaap unchanged. Delthap never used again.
        Th1diff=DASIN(xbdisp/BXp)
        BXp=BXp/DCOS(Th1diff)		!CMac exact
        Th1x=Th1+Th1diff		!CMac exact with new BXp
        Thetas=Thetas1-Th1diff
!U96fast                ABtemp=ABtem+xbdisp*DSIN(THABXp(VL))
!U96fast                THABXp(VL)=THABXp(VL)-xbdisp*DCOS(THABXp(VL))/ABtem
!U96: n.b.      THABXp2=DASIN(DCOS(Thincgx)*DABS(GB1)/ABtem) !used GENGEOMC/S
!U96:			could use ABtemp, xbdisp????
!93atest: Correction to ABtem(p) not thabxp, but not used anyway:
!               write(*,*) 'test BXp',BXp,BXpp,xbdisp/BXpp
!               P.S. ABtemp and THABXp are not used further, so approx. is OK:
!       better is asin(sinTHABXp(1+cot(Delthap)xbdisp/ABtem*sin(THABXp)))
!93atest-       last was very approx:
!U96  problem with next line, so add D0 to 1. 
        K1I=IDNINT(DMIN1(DMAX1((Th1x-ThminC(VL))/DelthC+1.D0,1.D0),STEPS1o))
!U96		 ! may load up on ends of range!
!Mac!!!	 changes may be incompatible with GENGEOM, reftem functions
!93
!Mac not appropriate for new cycling?
!		IF (ABtem*DABS(DSIN(THABX-Th1)).LE.-xbdisp) THEN
!		 WRITE(*,*)'Often?',xbdisp,Th1
!         GOTO 1025			! Angle => adj. sector (3?)
!M        ENDIF
!        ABtemp=ABtem+xbdisp/DSIN(THABX-Th1)
!ERR:
        thetaouts=thetas		! on Gx, surface angle out,ap=0
!93		On Gx,surf -> off Gx,surf -> diff(surf) -> off/on Gx,surf
!93		Off,surf in/out used for basym->Temt1
!93		Diff(surf) used for dely,t0,ysurf,ylayer,thld
        CALL GENTHD(thetas,sinaplane,cosaplane &
            ,sinalpha,cosalpha,sinth,sinths,sinTho &
            ,thetasPI,sinthsd,thetasd,thout,thetaoutg)
!Mactest	  WRITE(*,*) TH1,TH1X,xbdisp,thetas1,thetas,thetaspi,thetasd,sinthsd
        cosThs=DCOS(ThetasPI)
        cosThsd=DCOS(thetasd)
!B
        IF (Bragg.EQ.1) THEN
          basym=-sinths/sintho
        ELSE
          basym=sinths/sintho
        ENDIF
!L
        umbo2=(1.D0-basym)/2.D0      ! = 1 usually
!93:	! Polarisation correction K/pi=1 but K/sigma.not.cos2thetaB:
        IF (ip.EQ.2) THEN
          Kdiff=K
          Tem5f=Tem5
        ELSE
          Kdiff=DABS(1.D0-2.D0*sinthsd*sinth) &
              /DSQRT(1.D0+4.D0*sinth*(sinth-sinthsd))
          Tem5f=Tem5*Kdiff/K
        ENDIF
        dsinthdy=-DSQRT(DABS(basym))/basym*Tem5f
        Tem4=-dsinthdy*2.D0*sinth*basym		! needed for ysurf
        IF (Kdiff.GT.1.D-8) THEN	! 1/Temt1 normal should be Kdiff
          Onotemt1=-costhsd/dsinthdy	! v sin2T0*basym/Tem4
          Temt1=1.D0/Onotemt1      ! OK?
        ELSE			! truncate K for sigma at 45 degrees
          Onotemt1=2.D8*sinth*costhsd*basym &
              /DSQRT(DABS(basym)*MPSIr2)
          Temt1=-dsinthdy/costhsd		!Tem4/sin2T0/basym,.simeq.0
        ENDIF
!L			Really only for inversion: to be omitted...
        Reftem1=				 &! dysurf/dth1 dth1
            -Onotemt1			 &! dy(surf)/dtheta(diff)s (off Gx)
            *(cosths/DCOS(thetasPI))**2.D0/cosalpha  &!dths off Gx/dths
            *(ABtem*DCOS(THABX-Th1)	 &! versus ABtemp old and: CMac: Th1x?
!92error?    -xbdisp*DSIN(THABX-Th1)*DSIN(Th1)/DCOS(Th1)/DCOS(Th1) &
            )/GB(1)/DSIN(ThetasPI)			 &! dths(Gx)/dth1
!Mac!!!							! integration step = DelthL
            *DelthL				! dth1
!     4   *DelthC				! dth1 older value w/o optimisation.
!		       !  aplane=towards rev dirn of inc ray
        IF (AGE.GE.4) THEN
          IREL=1.D0
        ELSEIF (AGE.LT.4.AND.swidth.LT.0.D0) THEN
          IREL=IRELM
        ELSE
          IREL=IRELM*DEXP(irelscale*xbdisp*xbdisp)
        ENDIF				 ! normd  so sum(irel) simeq 1
        ysurf=(umbo2*RPSI0)/Tem4+(sinthsd-sinTh)/dsinthdy
!VtestDEC92
!        IF (DABS(Th1-Thm1C(VL)).LT.DelthC.AND.DABS(xbdisp).LT.DELX
!     1    .AND.Icycle.EQ.1) WRITE(*,*)
!     2   ' 5XXp,c,v=',SNGL(XXp),SNGL(XXpC),SNGL(XXpV)
!     3   ,'ths,c,v=',SNGL(thetas),SNGL(thetasc),SNGL(thetasv)
!     4   ,'thap,c,v=',SNGL(thetaap),SNGL(thetaapC),SNGL(thetaapV)
!     5   ,' x=',SNGL(xbdisp),'Reft1',SNGL(Reftem1)
!     6   ,'thos,g',SNGL(thetaouts),SNGL(thetaoutg),'bas',SNGL(basym)
!     7   ,'t4,t1,dy,ys=',SNGL(Tem4),SNGL(Temt1)
!     8   ,SNGL(dsinthdy),SNGL(ysurf)
!		! (C) uses wrong sign and omits K, PERHAPS to be
!		! replaced in t.prop.1/c, 'c'=K?
!		! it is better to use t=f(Thltop,Thlbot), Th=f(y)
!		! N.B. t=gb1(cos(th wrt surface)/cos(th2 wrt surface)-1)
!	N.B. the whole use of basym to characterise a flat crystal
!	is WRONG: aplane is const, & sin2aplane\simeq(1+basym)/(-basym)tanths
!
!     3: Calc. diffn off layers for |y|<5*dely0 for t(y=0)<ta absn limit;
        Maxt1=1.2D1*sinThs/(muabs+muext) ! est. of mean muext(c60 layers);
!		                  ! 2x old depth (30 layers) 
!
!B
        IF (Bragg.EQ.1) THEN
          Maxt=DMIN1(Maxt1,Maxt2) ! absorption,but no thicker than crystal!
        ELSE
          Maxt=Maxt2				! Crystal thickness T
        ENDIF
        IF (Mosflag.EQ.0) THEN
          tlast0=DABS(DABS(GB1)*cosThs/DCOS(ThetasPI+(ysurf-ndely1) &
              *Temt1)-DABS(GB1))	! |ths-thl|=|thld-thsd|
        ELSE
          tlast0=DABS(DABS(GB1)*cosThs/DCOS(ThetasPI+ndely2+ysurf &
              *Temt1)-DABS(GB1))
        ENDIF            !not:
!L
!	  tlast1=-lambda/DPI/Tem4*sinThs*ysurf/curvature ! delA=ysurf/curvature
!U96:		Define Dymaxt always: c93atest:
        Dymaxt=-(DACOS(cosThs/DABS(Maxt &
            /GB1+1.D0))-ThetasPI)*Onotemt1 ! >0 L-,B+; <0 L+,B-
!B
        IF ((tlast0.GT.Maxt.AND.(ysurf.LT.ndely1.OR.Mosflag.EQ.1)) &
            .OR.Bragg.NE.1) THEN
!L				! crystal limit (/absorption limit)
          tlast=Maxt
          Dymax=Dymaxt ! >0 L-,B+; <0 L+,B-
!U96:		 vs longer earlier form, but Not:
!B		      !not Dymax=-tlast*DPI*curvature/lambda/sinThs*Tem4
        ELSEIF (Mosflag.EQ.1) THEN      !! locn of y=+ndely2/Temt1
          Dymax=-ysurf+ndely2*DABS(Onotemt1)
          IF (tlast0.GT.0.) THEN
            tlast=tlast0
          ELSE
            tlast=0.D0
          ENDIF
        ELSE
          Dymax=-ysurf+ndely1      !! locn of y=+10/14 (5 or 7*dely0)
          IF (tlast0.GT.0.) THEN
            tlast=tlast0
          ELSE
            tlast=0.D0
          ENDIF
        ENDIF
!NOV92
!93	    Replaced earlier approx,following,by dely,t0=f(thetasd(thetasPI))
!U96:		use this if mosaic dely used: (more robust):
!Uthick:
!		dely=Tabdy(Jmaxff,4)
!Uthin:
        dely=Tabdy2(Jmaxff2,4)
!U96:        IF (t0c.GE.Maxt2) THEN		! Cryst v t(C/Extn) v t3(inc.Mosaic)
!         dely=-(DACOS(cosths/DABS(Maxt2
!     1     /GB1+1.D0))-thetasPI)*Onotemt1	! Onotemt1 replaced
!L
        t0c=(DABS(GB1)*cosths &
            /DCOS(DABS(thetasPI)+DABS(dely0*Temt1))-DABS(GB1))
        IF (t0c.LE.0.D0) THEN			! high th??
          t0c=(DABS(GB1)*DCOS(DABS(thetasPI)-DABS(dely0*Temt1)) &
              /cosths-DABS(GB1))
        ENDIF
!L
!        ELSE
!         dely=dely0
!        ENDIF
        IF (dely.LE.0.D0) THEN	!CUJun96: What about Laue?
          ntot=1				! only one layer
          ntott=1
        ELSE
          ntot=IDINT(0.5+(Dymax/dely))	! locn of last layer
          ntott=IDINT(0.5+(Dymaxt/dely))	! locn of last layer of crystal
!93test        ntot=MAX(ntot,1)
!93test        JUST THE SURFACE LAYER
!MACTEST,dely0,FLOAT(ntott)	WRITE(*,9801) FLOAT(ntot),dely,Dymax,
!     1    Dymaxt,FLOAT(ntotp),ysurf
!L
        ENDIF
!UJun96			Attenuation before crystal limit.
        IF (ntot.GT.ntott) ntot=ntott
        ntot=ntot+1
!U96:		! reset ntot,dely?
        IF (ntot.GT.IDNINT(Maxt2/t0pk)) THEN	!.AND.Dymax.GE.Dymaxt
          ntot=IDNINT(Maxt2/t0pk)
          ntott=ntot
!         dely=-(DACOS(cosths/DABS(Maxt2
!     1     /GB1+1.D0))-thetasPI)*Onotemt1	! Onotemt1 replaced
        ENDIF
!NOV92
!        IF (dely0.LE.0.D0) THEN
!         ntotp=1000000		! or so!
!        ELSE
!         ntotp=IDINT(1.5-ysurf/dely0)      !! locn of y=0
!        ENDIF
!U96:		Inconsistent / incompatible (unless dely=dely0):
        IF (dely.LE.0.D0) THEN
          ntotp=100000		! or so!
        ELSE
          ntotp=IDINT(1.5-ysurf/dely)      !! locn of y=0
        ENDIF
!B        IF ((
!     1   ((Bragg.EQ.1.AND.(((ntotp.LE.ntot+9.AND.Mosflag.EQ.0)
!     1   .OR.(DFLOAT(ntotp-ntot)*dely0.LE.
!     2   ndely2*DABS(Onotemt1).AND.Mosflag.EQ.1)).AND.
!     3   (ntot.GE.0)).OR.AGE.EQ.3.OR.AGE.EQ.5)
!     4   .OR.(Bragg.NE.1.AND.
!L
!     5   (((ntotp.LE.ntott+9.AND.ntotp.GE.-9.AND.Mosflag.EQ.0)
!     1   .OR.(DFLOAT(ntotp-ntott)*dely0.LE.
!     2   ndely2*DABS(Onotemt1).AND.DFLOAT(ntotp)*dely0.GE.
!     3   -ndely2*DABS(Onotemt1).AND.Mosflag.EQ.1)).AND.
!     4   (ntot.GE.0)).OR.AGE.EQ.3.OR.AGE.EQ.5)) THEN
!U96:		modified ntotp==dely,Tabdy2; ntot>0 and peak within extremes: 
        IF (( &
            (((ntotp.LE.ntott+9.AND.ntotp.GE.-9.AND.Mosflag.EQ.0) &
            .OR.(DFLOAT(ntotp-ntott)*dely.LE. &
            ndely2*DABS(Onotemt1).AND.DFLOAT(ntotp)*dely.GE. &
            -ndely2*DABS(Onotemt1).AND.Mosflag.EQ.1)).AND. &
            (ntot.GE.0)).OR.AGE.EQ.3.OR.AGE.EQ.5)) THEN
          IF (AGE.EQ.3.OR.AGE.EQ.5) THEN	!.OR.t0c.GE.Maxt2
            ntot=1
          ELSEIF (ntot.GE.0.AND.ntot.LT.4.AND.Bragg.EQ.1) THEN
!B
            ntot=MAX(2,MIN(4,ntott))	! CUJun96 vs 1,... for 1st order bonus layer
!L         ntot=ntott
          ENDIF
!UJun96			Reinstating xtot output...
          IF (ntot.GT.xtot) xtot=ntot
          Cumt=1.D0
          Irel4=0.D0
          adely=DSIGN(dely,Dymax)		! initialisation dyd(dbar)
          TsurfF=1.D0			! initialise to be safe...
!U96test:  IF (Th1.EQ.Thm2L(VL).OR.xbdisp.EQ.xmin) &
!            WRITE(*,*) Th1,xbdisp,Kdiff,adely,Dymax,ntot,dely
          
          DO layer = 0 , ntot ! loop over each layer + Fresnel
!		Each layer now begins at ysurf-Dely(0)*(layer-1) and is 
!		 dely(0) thick; for Sk/R, dbar & temsk are const.
!U96:		!this loop is slow again for mosaic!
            IF (layer.LE.1) THEN		! i.e. first layer + Fresnel
              ylayer=ysurf
              sinthld=sinThsd
              thld=thetasd
            ELSE
!93atest:     Single Correction Isolated: good for PERFECT, not MOSAIC:
!              ylayer=ysurf+DFLOAT(layer-1)*adely !ylayer+adely vs front surface
!              sinthld=sinThsd+(ylayer-ysurf)*dsinthdy     !sinthld+adely*dsinthdy
              ylayer=ylayer+adely ! ysurf+DFLOAT(layer-1)*adely vs front surface
              sinthld=sinthld+adely*dsinthdy !sinThsd+(ylayer-ysurf)*dsinthdy
!93atest-
              IF (sinthld.GT.1.D0) THEN
                WRITE(*,*) '980sd',sinthld,ylayer,ysurf,adely,dsinthdy &
                    ,Maxt3,t0,t0c,dely0,dely,xbdisp,th1,layer,ntot,ntotp,ntott &
                    ,muabs,muext,maxt2,temt1,onotemt1,Kdiff
                GOTO 980 ! Goto next layer loop iteration
              ENDIF
!L
!test	WRITE(*,9801) FLOAT(ntot),FLOAT(layer),ylayer,ysurf,
!test     1       Dymaxt,adely,adelth
!U96:	Relax Constraint:
!U          IF (DABS((ylayer-ysurf)/Dymaxt).GT.1.D0) THEN
!U           ylayl(layer)=ylayer
!MO     happens for mosaics?                    WRITE(*,*) '980 LOOP'
!U           GOTO 980
!U          ENDIF
!93			Diff. angle:
              thld=DASIN(sinthld)	! or thetasd+(l-1)adelth or thld+adelth
            ENDIF
            costhld=DCOS(thld)
!93		Diff(layer) -> Off/On Gx,surf(layer) (In; and Out)
!93		Off,surf in/out used for basym->Temt1
!93		Diff(layer) used for dely,t0c,ytime,sintlt
            CALL GENTHSG(sinthld,costhld &
                ,sinaplane,cosaplane,sinalpha,cosalpha,Minthinc,sinthl &
                ,sinthol,Thlayer,Temsg2,thld0g,thetaoutl,Temog2) !off Gx to/from surf.
            costhl=DCOS(thlayer)
!91err:         ThlayerC=DASIN(sinthld)-aplane	 ! inc.angle
!-----------------------------------------------------------------------
!	????Fresnel surface reflection or Bragg plane diffraction????:
!-----------------------------------------------------------------------
            IF (layer.EQ.0) THEN		! Fresnel specular reflection:
              sinthol=sinthl		! ?
              sinthp=CDSQRT(DCMPLX(sinthl*sinthl,0.D0)+DPSI0)
              ctemrf(ip)=(cpolf*DCMPLX(sinthl,0.D0)-sinthp) &
                  /(cpolf*DCMPLX(sinthl,0.D0)+sinthp)
!93	! ... and t_F. non-magnetic; routine destroys ctem phase info:
              ctemtf(ip)=2.D0*sinthp		 &! vs cpolf*DCMPLX(sinthl,0.D0)
                  /(cpolf*DCMPLX(sinthl,0.D0)+sinthp)	! some kind of approxn?
              meanyl=ysurf
!93atest: for curved crystals here, or sym curved/flat crystals in BFM:
              IF (Igraz.EQ.0.OR.AGE.NE.2) THEN
                Refl=0.D0
                TsurfF=1.D0
              ELSE
                Refl=DREAL(ctemrf(ip))**2+DIMAG(ctemrf(ip))**2
                TsurfF=(DREAL(ctemtf(ip))**2+DIMAG(ctemtf(ip))**2) &
                    *sinthl/CDABS(sinthp)	! Power vs t2, vs inverse.
              ENDIF
              tlayer=1.D0				! ?still
!B
              IF (Bragg.NE.1) THEN
                Refl=0.D0
              ENDIF
!L
              Tranl(0)=TsurfF
              Cumt=1.D0
              dbar=0.D0
!L
              GOTO 705				! goto ray tracing
            ENDIF
!B
            IF (Bragg.EQ.1) THEN
              basym=-sinthl/sinthol		! exact!
            ELSE
              basym=sinthl/sinthol		! exact!
            ENDIF
!L
!93:	! Polarisation correction K/pi=1 but K/sigma.not.cos2thetaB:
            IF (ip.EQ.2) THEN
              Kdiff=K
              Tem5f=Tem5
            ELSE
              Kdiff=DABS(1.D0-2.D0*sinthld*sinth) &
                  /DSQRT(1.D0+4.D0*sinth*(sinth-sinthld))
              Tem5f=Tem5*Kdiff/K
            ENDIF
            dsinthdy=-DSQRT(DABS(basym))/basym*Tem5f
            Temt1=DMIN1(DMAX1(-dsinthdy/costhld,-1.D8),1.D8) !1st est, to 1E-4
!93		High??? Precision Anti-asymmetry test???:
!L
!L		If any layer important, all T's required...:
!B
!U96:         IF (Bragg.NE.1.OR.(layer.LE.4.OR.ylayer.LE.2.D0*ndely1
!U96     1    .OR.AGE.EQ.3.OR.AGE.EQ.5.OR.
!U96     2    ((DABS(ylayer*Temt1).LE.0.1D0*ndely2.OR.
!U96: Relax constraint:
!U     3    layer.EQ.10*INT(layer/10)).AND.Mosflag.EQ.1))) THEN
!U96     3    layer.EQ.3*INT(layer/3)).AND.Mosflag.EQ.1))) THEN
            
!U96: Need all for Laue; need more for mosaic; so why not use all???
            
!93	    Replaced earlier approx,following,by dely,dt0=f(thetasd(thetasPI))
!L
            dt0=DABS(DABS(GB1)*costhl &
                /DCOS(DABS(thlayer)+DABS(dely*Temt1))-DABS(GB1))
!L
!****** get rlayer,tlayer - n.b. the model lacks continuity by stepping y.
!
            meanyl=0.D0
            rlayer=0.D0
            tlayer=1.D0
            Refl=0.D0
!93test          DO 700 ITEST=1,ITIMES
            ITEST=1
!           IF (ITIMES.GT.1) THEN	! redundant/ITIMES>=2
!93		dely in sympathy with maxt, <<dely0 for near-normal inc.
640         IF (ITEST.EQ.1) THEN
              ytime=ylayer
            ELSE
              ytime=ylayer+adely/DFLOAT(ITIMES)*DFLOAT(ITEST-1)
            ENDIF
            sintlt=sinthld+(ytime-ylayer)*dsinthdy	!dsdy approx.
!93test
            IF (sintlt.GT.1.D0.OR.sintlt.LT.-1.D0) THEN
              WRITE(*,*) '700st',sintlt,itest,itimes,ytime,ylayer &
                  ,dsinthdy,maxt,maxt2,Maxt3,t0,t0c,dt0,dely0,dely,xbdisp &
                  ,th1,th1x,layer,ntot,ntotp,ntott,muabs,muext
              GOTO 700	! don't add R/T; reset R/T over valid range?
            ENDIF
!U96: Relax constraint:
!U           IF ((ytime-ysurf)/Dymaxt.GT.1.D0) THEN
!Mactest			 WRITE(*,*) '700LOOP'
!U            GOTO 700	! don't add R/T; reset R/T over valid range?
!U           ENDIF
!93			Diff. angle:
            thlt=DASIN(sintlt)	! or thld+adelth/DFLOAT(ITIMES)*DFLOAT(ITEST-1)
            costlt=DCOS(thlt)
!93		Diff(time) -> Off Gx,surf(layer) (not On Gx) (In; not Out)
!93		Off,surf in/out used for Refl, Trans (not? basym->Temt1)
!93		Diff(time) not used for dely,t0,ytime,sintlt
            CALL GENTHSF(sintlt,costlt &
                ,sinaplane,cosaplane,sinalpha,cosalpha,sintime)	! Off Gx,surf,in
!91err:            thtime=DASIN(sinthld+(ytime-ylayer)*dsinthdy)-aplane
            Thtime=DASIN(sintime)
            costime=DCOS(Thtime)			! full surf angle
            IF (thtime.GE.thmaxf+Delthm) THEN !large angle lim
!U96:
!Uthick:		rtime=Rtem(fof+EXTRASTEPS/2)
!U              ttime=Ttem(fof+EXTRASTEPS/2)
              Iold=fof+EXTRASTEPS/2
              CALL RTSET(rtime,ttime,Iold)
              IF (ITEST.EQ.1) THEN
                I=STEPSF+EXTRASTEPS/2
!U96:
!Uthick:
!              adely=Tabdy(I,4)
!              adelth=Tabdy(I,3)
!Uthin:
                CALL TABSET(adely,adelth,I)
              ENDIF
            ELSEIF (thtime.LE.thminf-Delthm) THEN ! small angle
!             rtime=Rtem(fof+EXTRASTEPS)
!             ttime=Ttem(fof+EXTRASTEPS)
              Iold=fof+EXTRASTEPS
              CALL RTSET(rtime,ttime,Iold)
              IF (ITEST.EQ.1) THEN
                I=STEPSF+EXTRASTEPS
!Uthick:
!              adely=Tabdy(I,4)
!              adelth=Tabdy(I,3)
!Uthin:
                CALL TABSET(adely,adelth,I)
              ENDIF
            ELSEIF (thtime.GE.thmaxf) THEN
              thold=thmaxf
              Iold=STEPSF
              CALL RTSET(rold,told,Iold)
!             rold=Rtem(STEPSF)
!             told=Ttem(STEPSF)
              Iold=fof
650           Iold=Iold+1
              IF (THSET(Iold).LT.thtime.AND.		 &!Thtem(Iold)
                  Iold.LT.fof+EXTRASTEPS/2) GOTO 650
              IF (Iold.GT.fof+1) THEN
                thold=THSET(Iold-1)
                CALL RTSET(rold,told,Iold-1)
              ENDIF
              thnew=THSET(Iold)
              CALL RTSET(rnew,tnew,Iold)
              IF (DABS(thnew-thold).GT.1.D-8) THEN
                rtime=rold+(rnew-rold)*(thtime-thold)/(thnew-thold)
                ttime=told+(tnew-told)*(thtime-thold)/(thnew-thold)
                IF (ITEST.EQ.1) THEN
                  I=Iold-fof+STEPSF-1
!Uthin:
                  CALL TABSET(adely,adelth,I)
                  CALL TABSET(adely1,adelth1,I+1)
                  adely=adely+(adely1-adely) &
                      *(thtime-thold)/(thnew-thold)
                  adelth=adelth+(adelth1-adelth) &
                      *(thtime-thold)/(thnew-thold)
                ENDIF
              ELSE
                rtime=rold
                ttime=told
                IF (ITEST.EQ.1) THEN
                  I=Iold-fof+STEPSF-1
!Uthin:
                  CALL TABSET(adely,adelth,I)
!              adely=Tabdy(I,4)
!              adelth=Tabdy(I,3)
                ENDIF
              ENDIF
            ELSEIF (thtime.LE.thminf) THEN
              thold=thminf
              CALL RTSET(rold,told,1)
!             rold=Rtem(1)
!             told=Ttem(1)
              Iold=fof+EXTRASTEPS/2
660           Iold=Iold+1
              IF (THSET(Iold).GT.thtime.AND. &
                  Iold.LT.fof+EXTRASTEPS) GOTO 660
              IF (Iold.GT.fof+1+EXTRASTEPS/2) THEN
                thold=THSET(Iold-1)
                CALL RTSET(rold,told,Iold-1)
!              rold=Rtem(Iold-1)
!              told=Ttem(Iold-1)
              ENDIF
              thnew=THSET(Iold)
              CALL RTSET(rnew,tnew,Iold)
!             rnew=Rtem(Iold)
!             tnew=Ttem(Iold)
              rtime=rold+(rnew-rold)*(thtime-thold)/(thnew-thold)
              ttime=told+(tnew-told)*(thtime-thold)/(thnew-thold)
              IF (ITEST.EQ.1) THEN
                I=Iold-fof+STEPSF-1
!Uthin:
                CALL TABSET(adely,adelth,I)
                CALL TABSET(adely1,adelth1,I+1)
                adely=adely+(adely1-adely) &
                    *(thtime-thold)/(thnew-thold)
                adelth=adelth+(adelth1-adelth) &
                    *(thtime-thold)/(thnew-thold)
!             adely=Tabdy(I,4)+(Tabdy(I+1,4)-Tabdy(I,4))
!     1           *(thtime-thold)/(thnew-thold)
!             adelth=Tabdy(I,3)+(Tabdy(I+1,3)-Tabdy(I,3))
!     1           *(thtime-thold)/(thnew-thold)
              ENDIF
            ELSE
              Iold=IDINT((thtime-thminf)/(thmaxf-thminf) &
                  *(DFLOAT(STEPSF)-1.D0)+1.D0)
              IF (Iold.LT.1) Iold=1
              IF (Iold.GE.STEPSF) Iold=STEPSF-1
              thold=THSET(Iold)
              thnew=THSET(Iold+1)
              IF (thnew.EQ.thold.OR.Iold.EQ.1) THEN
                CALL RTSET(rtime,ttime,Iold)
!              ttime=Ttem(Iold)
!              rtime=Rtem(Iold)
                IF (ITEST.EQ.1) THEN
                  I=Iold
                  CALL TABSET(adely,adelth,I)
!               adely=Tabdy(I,4)
!               adelth=Tabdy(I,3)
                ENDIF
              ELSE
                CALL RTSET(rold,told,Iold)
                CALL RTSET(rnew,tnew,Iold+1)
!              rold=Rtem(Iold)
!              rnew=Rtem(Iold+1)
!              told=Ttem(Iold)
!              tnew=Ttem(Iold+1)
                rtime=rold+(rnew-rold)*(thtime-thold)/(thnew-thold)
                ttime=told+(tnew-told)*(thtime-thold)/(thnew-thold)
                IF (ITEST.EQ.1) THEN
                  I=Iold
!Uthin:
                  CALL TABSET(adely,adelth,I)
                  CALL TABSET(adely1,adelth1,I+1)
                  adely=adely+(adely1-adely) &
                      *(thtime-thold)/(thnew-thold)
                  adelth=adelth+(adelth1-adelth) &
                      *(thtime-thold)/(thnew-thold)
!               adely=Tabdy(I,4)+(Tabdy(I+1,4)-Tabdy(I,4))
!     1           *(thtime-thold)/(thnew-thold)
!               adelth=Tabdy(I,3)+(Tabdy(I+1,3)-Tabdy(I,3))
!     1           *(thtime-thold)/(thnew-thold)
                ENDIF
              ENDIF
            ENDIF
!L				Laue options + Bragg...?
            IF (ITEST.EQ.1.AND.GB1.GT.0..AND.Bragg.NE.1) THEN
              adely=-adely
            ELSEIF (ITEST.EQ.1.AND.GB1.LE.0..AND.Bragg.NE.1) THEN
              adelth=-adelth
            ELSEIF (ITEST.EQ.1.AND.GB1.LE.0.) THEN
              adely=-adely
              adelth=-adelth
            ENDIF
!L
!		      This assumes broadening to dely ca .5*dely0
!		      (or some 'mean' interference) but with absn incd so
!		      Rbar=sum(rtime*exp(-mu*2*delSk),slabs)
            Wgt(ITEST)=tlayer*tlayer      !est of rel. diff. absn
            IF (ttime.GT.1.D0) THEN
              ttime=1.D0
            ELSEIF (ttime.LT.1.D-250) THEN
              ttime=1.D-250
            ENDIF
            IF (ITEST.EQ.1) THEN
              IF (layer.LE.4) THEN		! precision depth calcn:
                ITIMES=MAX(IDNINT(dt0/1.D1),3)		! 1.0mum precision
                ITIMES=MAX(ITIMES, &
                    IDNINT(-6.0D0*DLOG(ttime)))		! 20pc attenuation step
              ELSE
                ITIMES=MAX(IDNINT(dt0/2.D1),3)		! 2.0mum precision
                ITIMES=MAX(ITIMES, &
                    IDNINT(-4.0D0*DLOG(ttime)))		! 40pc attenuation step
              ENDIF
              IF (Mosflag.EQ.0) THEN
                ITIMES=MIN(ITIMES,100)			! precision limit
              ELSE
                ITIMES=MIN(ITIMES,20)
              ENDIF
            ENDIF
!            IF (ITIMES.GT.1) THEN
            tlayer=tlayer*ttime**(1.D0/DFLOAT(ITIMES))
!            ELSE
!             tlayer=ttime
!            ENDIF
!		      ! additional t for cumt= mean t? +-10%?
            rlayer=rlayer+Wgt(ITEST)
            meanyl=meanyl+ytime*Wgt(ITEST)
            Refl=Refl+rtime*Wgt(ITEST) !mean refl for crstlite region+-10%?
            IF (ITEST.LT.ITIMES) THEN
              ITEST=ITEST+1
              GOTO 640
            ENDIF
700         CONTINUE
            IF (rlayer.GT.1.D-30) THEN	! normalise; must be >1
              meanyl=meanyl/rlayer
!L
              Refl=Refl/rlayer      ! inc.diffn to and from surface later
!L
            ENDIF
!L			Laue from here on, a new broom sweeps clean...
!L
!L		No need for Sk=return layer surface-surface attenuation:
!B			Calculate additional attenuation:
            IF (Bragg.EQ.1) THEN
              IF (aplane.NE.0.D0) THEN	! Cumt no good; use muabs est.
!93           sinThl=DSIN(Thlayer)		! off Gx, surface locn
                cosThl=DCOS(Thlayer)
                dbar=DMIN1(Maxt2,DABS(GB1)*cosThs/cosThl-GB1) ! off Gx,surf-->thl
! 		    Sk= pathlength from front of crystallite to surface
                TemSk=(GB1+dbar)*sinthol		! 1st order
                Sk=TemSk-DSQRT(TemSk*TemSk-2.D0*GB1*dbar-dbar*dbar)
                Refl=Refl*Cumt*DEXP(-muabs*Sk)	! include absn to surface
              ELSE
                Refl=Refl*Cumt*Cumt		! inc.diffn to / from surf./same path
              ENDIF
            ENDIF
!B
!93atest:    use thldl to Prepare for ray tracing, only once per layer!
            sinthldl=sinthld+(meanyl-ylayer)*dsinthdy	!dsthdy of last layer
            thldl1=DASIN(sinthldl)
            thldl(layer)=thldl1
!L
            costhldl=DCOS(thldl1)
!93		Diff(layer) -> Off/On Gx,surf(layer) (In; and Out)
!93		Off,surf in/out used for basym->Temt1
!93		Diff(layer) used for dely,t0,ytime,sintlt
            CALL GENTHSG(sinthldl,costhldl &
                ,sinaplane,cosaplane,sinalpha,cosalpha,Minthinc,sinthl &
                ,sinthol,Thlayer,thinl,thld0g,thetaoutl,thoutl) !off Gx to/from layer
!U96:          ylayerl=meanyl
            cosThl=DCOS(Thlayer)			! off Gx, mean locn
            dbar=DMIN1(Maxt2,DABS(DABS(GB1) &
                *cosThs/cosThl-DABS(GB1))) ! off Gx,surf-->mean thl
!B93:
            IF (Bragg.EQ.1) THEN
              Refl=Refl*TsurfF		! include Fresnel transmission coeff.
            ENDIF
!L		Outgoing surface required versus incident...
            IF (Bragg.NE.1) THEN
              thetaoutg=DACOS(DABS((GB1+dbar)/(GB1+Maxt2)) &
                  *DCOS(thetaoutl)) !surface th
            ELSE
              thetaoutg=DACOS(DABS(1.D0+dbar/GB1)*DCOS(thetaoutl)) !surface th
            ENDIF
            CALL GENTHGDAZ(thetaoutg,cosalpha,Thout)	!on Gx, surf thout
            Thoutl2(layer)=Thout
!plate96
            
!	     Thetaap2=-2.*DASIN(DXXp2/2./GB(1))+Thetaap      ! poor approxn
!
            Thetaap2=Thetaap-Thlayer-thetaoutl+ThetasPI+thetaoutg ! output location in angle terms
!plate96
!plate96    Is calc of Thetaap2 above to a point on the surface of the crystal
!plate96     WRITE(*,*) 'Thetaap2,THOUT,ICYCLE value in 980 loop',Thetaap2,Thout,ICYCLE	
            
705         continue			! continue for Fresnel calcn
!		! off Gx, but == on Gx; from 
!		! tha1=thl-apl-ths,tha2=thl+apl-thouts,deltha=-tha1-tha2
!L
!B         ENDIF
!t         IF ((layer.LE.4.AND.layer.GT.0).OR.(layer.EQ.0.AND.
!     1    Bragg.EQ.1)
!     1    .OR.DABS(ylayer).LE.2.D0*ndely1.OR.AGE.EQ.3.OR.
!     2    AGE.EQ.5.OR.((DABS(ylayer*Temt1).LE.ndely2
!     3    .AND.Mosflag.NE.0).AND.rlayer.GE.2.D0*Rtem(1))) THEN
!		                                    -not IREL,Yiz
!	     4: Calc. shift of locn and Thetaout around crystal;
!		      RAY TRACING... calc. Sk,Skin (ave's)
!93:		Testing Fresnel ray tracing:
!B
            IF (layer.EQ.0) THEN
              Sk=0.D0
              Sk0=0.D0
              Skin=0.D0
              thetaap2=thetaap
            ELSEIF (Bragg.NE.1) THEN
!L			Laue: calc. ratio of path-lengths:
!L
              TemSk=(GB1+dbar)		! Laue result
              Skin=DSQRT(TemSk*TemSk+GB1*GB1-2.D0*GB1*TemSk &
                  *DCOS(ThetasPI-thlayer))
              TemSk=(GB1+dbar)*sinthol	! Laue result
              Sk=DABS(DABS(TemSk)-DSQRT(TemSk*TemSk+2.D0*GB1*(Maxt2-dbar) &
                  +Maxt2*Maxt2-dbar*dbar))
              TemSk=(GB1+dbar)*sinthl	! Laue result
              Sk0=DABS(DABS(TemSk)-DSQRT(TemSk*TemSk+2.D0*GB1*(Maxt2-dbar) &
                  +Maxt2*Maxt2-dbar*dbar))
            ELSE
              TemSk=(GB1+dbar)*sinthol		! 1st order
              Sk=DABS(DABS(TemSk)-DSQRT(TemSk*TemSk-2.D0*GB1*dbar &
                  -dbar*dbar))
              TemSk=(GB1+dbar)*sinthl		! 1st order
              Skin=DABS(DABS(TemSk)-DSQRT(TemSk*TemSk-2.D0*GB1*dbar &
                  -dbar*dbar))
              Sk0=Skin
            ENDIF
!L
!t         ENDIF
!			950 end of that goto statement
!U96: Cancelled:        ENDIF		! cf 950
!L
            IF (Sk0.LT.1.D-6) THEN	! (0)
              RSk(layer)=1.D0
            ELSE
              RSk(layer)=Sk/Sk0		! for attenuation.
            ENDIF
            Pathl(layer)=BXp+Sk+Skin
            Refll(layer)=Refl
            Temt1l(layer)=temt1
            Tsum1l(layer)=Cumt
            ylayl(layer)=meanyl		!c93atest
            Tranl(layer)=tlayer
            dbarl(layer)=dbar
            Thetaap2l(layer)=Thetaap2
!L
            Cumt=Cumt*tlayer
!B
!UJun96: add attenuation for next layer in 980 loop:
            IF (Bragg.EQ.1) THEN
              Refl=Refl*tlayer**2
            ENDIF
!B
980         CONTINUE            ! layer
          ENDDO
          
!t        WRITE(*,9801) (Refll(layer),layer=0,ntot)
9801      FORMAT(8(1PE10.2))
          DO layer = 0 , ntot		! loop over each important layer
!L
!u         IF ((Bragg.NE.1.AND.((layer.LE.4.AND.layer.GT.0)
!u     1    .OR.DABS(ylayer).LE.2.D0*ndely1.OR.AGE.EQ.3.OR.
!u     2    AGE.EQ.5.OR.
!u     2    (DABS(ylayl(layer)*Temt1l(layer)).LE.ndely2
!u     3    .AND.Mosflag.NE.0.AND.Refll(layer).GE.2.D0*Rtem(1)))).OR.
!u     4    (Bragg.EQ.1.AND.(layer.LE.4.OR.ylayer.LE.2.D0*ndely1
!u     1    .OR.AGE.EQ.3.OR.AGE.EQ.5.OR.
!u     2    ((DABS(ylayer*Temt1).LE.0.1D0*ndely2.OR.
!u     3    layer.EQ.10*INT(layer/10)).AND.Mosflag.EQ.1)))) THEN
!U96: testing ylayer = mean cutoff vs ylayer = surface cutoff (intended):
            dbar=dbarl(layer)
            temt1=Temt1l(layer)
            meanyl=ylayl(layer)		!c93atest
!U96: completely relax constraint: (for some?):
!U         IF ((Bragg.NE.1.AND.((layer.LE.4.AND.layer.GT.0)
!U     1    .OR.DABS(meanyl).LE.2.D0*ndely1.OR.AGE.EQ.3.OR.
!U     2    AGE.EQ.5.OR.
!U     2    (DABS(ylayl(layer)*Temt1l(layer)).LE.ndely2
!U     3    .AND.Mosflag.NE.0.AND.Refll(layer).GE.2.D0*Rtem(1)))).OR.
!U     4    (Bragg.EQ.1.AND.(layer.LE.4.OR.meanyl.LE.2.D0*ndely1
!U     1    .OR.AGE.EQ.3.OR.AGE.EQ.5.OR.
!U     2    ((DABS(meanyl*Temt1).LE.0.1D0*ndely2.OR.
!U96: Relax constraint:
!U1     3    layer.EQ.10*INT(layer/10)).AND.Mosflag.EQ.1)))) THEN
!U     3    layer.EQ.3*INT(layer/3)).AND.Mosflag.EQ.1)))) THEN
!Ltest
!t	WRITE(*,*)'981',layer,ntot,ylayer,meanyl,Dymaxt,Refll(layer)
!t     1  ,Tsum1l(layer),Tranl(layer),Cumt,RSk(layer),ysurf,sinthldl
!U96: Relax constraint:
!U          IF (sinthldl.GT.1.D0
!U     1      .OR.DABS((meanyl-ysurf)/Dymaxt).GT.1.D0) THEN
            IF (sinthldl.GT.1.D0) THEN
!MO	happens for mosaics??	esp. when ylayer undefined = last!!!	
!			WRITE(*,*) '981LOOP'
              GOTO 981 ! skip rest of loop iteration
            ENDIF
            IF (Bragg.NE.1) THEN
              Refl=Refll(layer)*Tsum1l(layer) &
                  *(Cumt/Tranl(layer)/Tsum1l(layer))**(RSk(layer))
            ELSE
              Refl=Refll(layer)
            ENDIF
!L
!	   act 2sin((theta'+thetaa")/2.).simeq.sin(theta')+sin(theta")
!		also arc on circle .simeq. arc on crystal
!	   DXXp2=cosalpha*(Skin*DCOS(Thlayer-aplane)
!     1+Sk*DCOS(Thlayer+aplane))      ! approx arc on crystal;
!	     5: Calc. shift of locn on film, and intensity cpt;
!	      n.b. y only affects BXp - irrelevant
!		   y=-swidth,swidth,2.*swidth/STEPS2
!		    BXp=BX+(xbdisp/DTAN(Thetas)-xbdisp/DSIN(Thetas)*DTAN(xbdisp/2./GB(1)
!     1              /DSIN(Thetas)+y+2.*Sk)*cosalpha      ! basym = -1
!		    Thetaap2 and Thout~=  'Thetas' are the important vars.
!L
            IF (Bragg.NE.1) THEN
              CALL GENXPZ(Yiz,Theta3,xline,Thetaap2l(layer) &
                  ,GB(1),Axisth,Thoutl2(layer),THABX,THBAX,PZ,Maxt2 &
                  ,Isect(VL),detflag)
            ELSE
!U96: Flag this escape from loop:
!plate96 this call to GENXYs is for layers within crystal           
!plate96  WRITE (*,*) 'value of Thetaap2l(layer)',Thetaap2l(layer)
              CALL GENXYS(Yiz,Theta3,detflag,xline,Thetaap2l(layer) &
                  ,GB(1),Axisth,Thoutl2(layer),Cx,PZ,Isect(VL))	!PZ=Rzf
              
!plate96
!plate96 This is where main calc of flat plate detector position is done	   
              
              IF (detflag.EQ.1) GOTO 950
              CALL PLATEFUNC (Detx,Thoutl2(layer),GB(1),Cx,Axisth,Thetaap2l(layer), &
                  Detarmlen,Dettheta,Detbeta,Rplate)           
!plate96 			IF (xbdisp.EQ.xmax.OR.(Th1.LE.7.D-6.AND.Th1.GE.-7.D-6)) THEN
!plate96			 WRITE (*,*) 'xbdisp eq xmax and Detx,Yiz is',Detx,Yiz,xbdisp,Th1,
!plate96     1  	Thetaap2l(layer),Thoutl2(layer)	
!plate96			 ENDIF
!plate96			IF (xbdisp.EQ.xmin.OR.Th1.EQ.(Thm2L(VL)+1000*DelthL)) THEN
!plate96			  WRITE (*,*) 'xbdisp eq xmin and Detx,Yiz is',Detx,Yiz,xbdisp,Th1,
!plate96     1  	Thetaap2l(layer),Thoutl2(layer)		  
!plate96			ENDIF
!plate96		   IF (detflag.EQ.1) GOTO 950
            ENDIF
!B			!XX=arc from now on! never propagated BUT
!Mac		! used to evaluate limits and mean NOT XXp = input only
            XXp2=GB(1)*Thetaap2
            IRELR=IREL*Refl
            mdepth(ip)=mdepth(ip)+dbar*IRELR
            mthld(ip)=mthld(ip)+thldl(layer)*IRELR
!UJun96:		Replace Refl by IRELR for consistency wrt Pk layer & sum:
            IF (layer.EQ.ntot.AND.IRELR.GT.mcontl) THEN	!tlast.LT.tlast0.AND.
              mcontl=IRELR
              maxt0=t0pk*layer  		! vs muabs,sinths,muext/30l,I/10**3
            ENDIF
            IF (layer.EQ.ntot.AND.Refl.GT.mcontr) THEN	!tlast.LT.tlast0.AND.
              mcontr=Refl
            ENDIF
!UJun96:		Additional layer / division testing:
            IF (layer.EQ.ntot.AND.IRELR.GT.pcontl.AND.ntot.LT.xtot) THEN
              pcontl=IRELR
              pcontr=Refl
              ptot=layer
              pdivs=ITIMES
            ENDIF
            Irel1(K1I)=Irel1(K1I)+IRELR
            IF (IRELR.GT.Yrel(K1I,4)) THEN      ! main cpt
              Yrel(K1I,1)=ysurf
              Yrel(K1I,4)=IRELR
            ENDIF
            Mshift1=Mshift1+(Th1x-Thm1C(VL))*IRELR
            CENT2=(Thoutl2(layer)-ThminoC(VL))/(ThmaxoC(VL)-ThminoC(VL)) &
                *(STEPS3-1.)+1.D0
            K2I=IDNINT(CENT2)        !Irel2(layer)==Bragg Thout=f(x))
!plate96 
            
!plate96		  WRITE(*,*) 'K2I at first calc',K2I
            
!93atest:               Limit estimate:
            IF (K2I.LT.K2min.AND.IRELR.GT.MaxI3t*5.D-3) K2min=K2I
            IF (K2I.GT.K2maxt.AND.IRELR.GT.MaxI3t*5.D-3) K2maxt=K2I
            IF (K2I.GT.ISTEPSO) THEN
              K2I=ISTEPSP
            ELSEIF (K2I.LT.1) THEN
              K2I=1
            ENDIF
            Imdepth2(K2I)=Imdepth2(K2I)+dbar*IRELR
            Imthld2(K2I)=Imthld2(K2I)+thldl(layer)*IRELR
            Irel22(K2I)=Irel22(K2I)+IRELR		! full, unbroadened
            IF (ICycle.EQ.1.OR.WDTH2.LE.1..OR.K2I.EQ.ISTEPSP &
                .OR.K2I.EQ.1) THEN
!plate96Irel2      First calc of Irel2           
              Irel2(K2I)=Irel2(K2I)+IRELR
              IF (layer.EQ.1) Irel5(K2I)=Irel5(K2I)+IREL
            ELSE
              Ist3=IDNINT(CENT2-WDTH2/2.D0)
              Iast3=IDNINT(CENT2+WDTH2/2.D0)
              IF (Ist3.LE.1) THEN
                Ist3=1
                Irel2(Ist3)=Irel2(Ist3)+IRELR/WDTH2      ! a full share
                IF (layer.EQ.1) Irel5(Ist3)=Irel5(Ist3)+IREL/WDTH2
              ELSE
                Irel2(Ist3)=Irel2(Ist3)+IRELR/WDTH2* &
                    (DFLOAT(Ist3)-CENT2+WDTH2/2.+0.5D0)
                IF (layer.EQ.1) Irel5(Ist3)=Irel5(Ist3)+IREL/WDTH2* &
                    (DFLOAT(Ist3)-CENT2+WDTH2/2.+0.5D0)
              ENDIF
              IF (Iast3.GT.K2max) THEN
                Iast3=K2max
                Irel2(Iast3)=Irel2(Iast3)+IRELR/WDTH2      ! a full share
                IF (layer.EQ.1) Irel5(Iast3)=Irel5(Iast3)+IREL/WDTH2
              ELSE
                Irel2(Iast3)=Irel2(Iast3)+IRELR/WDTH2* &
                    (CENT2+WDTH2/2.D0-DFLOAT(Iast3)+0.5D0)
                IF (layer.EQ.1) Irel5(Iast3)=Irel5(Iast3)+IREL/WDTH2* &
                    (CENT2+WDTH2/2.D0-DFLOAT(Iast3)+0.5D0)
              ENDIF
              IF (Iast3.GT.Ist3+1) THEN
                DO I=Ist3+1,Iast3-1
                  Irel2(I)=Irel2(I)+IRELR/WDTH2
                  IF (layer.EQ.1) Irel5(I)=Irel5(I)+IREL/WDTH2
                ENDDO
              ENDIF
            ENDIF
            IF (IRELR.GT.Yrel(K2I,5)) THEN      ! main cpt
              Yrel(K2I,2)=ysurf
              Yrel(K2I,5)=IRELR
            ENDIF
            MShift2=MShift2+(Thoutl2(layer)-Thout0)*IRELR
            Reflint(1)=Reflint(1)+IRELR       ! total Iout/Iin (from the source)
            Reflinty=Reflinty-IRELR*Reftem1 ! -dysurf/dTh1
            Reflintthinc=Reflintthinc+IRELR*Reftem1*temt1 ! dthinc/dTh1
            IF (DABS(xbdisp).LT.0.55*DELX) THEN
              Irel4=Irel4+Refl
              ReflintHy=ReflintHy-Refl*Reftem1 ! -dysurf/dTh1, for x=0 only
              Reflintth=Reflintth+Refl*DelthL	! Int dTh1 CMac vs DelthC
            ENDIF
!UJun96:
            Irel7=Irel7+Refl
!			! cf flat crystal Int(Refl,dy); here, dysurf
!93
            minxxp(VL)=DMIN1(minxxp(VL),XXp2)
            maxxxp(VL)=DMAX1(maxxxp(VL),XXp2)
            meanxxp(VL)=meanxxp(VL)+XXp2*IRELR
            IF (IRELR.GT.MaxI3t*5.D-2) THEN
              minth3=DMIN1(minth3,theta3)
              maxth3=DMAX1(maxth3,theta3)
              minthap2=DMIN1(minthap2,thetaap2l(layer))
              maxthap2=DMAX1(maxthap2,thetaap2l(layer))
            ENDIF
            
            CENT3=(Yiz-YminoC(VL))/(YmaxoC(VL)-YminoC(VL)) &
                *(STEPS4-1.D0)+1.D0
            K3I=IDNINT(CENT3)
!plate96
            CENT8 = (Detx-Detminx(VL))/(Detmaxx(VL)-Detminx(VL)) &
                *(STEPS8-1.D0)+1.D0
            K8I=IDINT(CENT8)
!plate96
            
!UJun96:               Limit estimates:
            IF (Refl.GT.MaxI3r) MaxI3r=Refl
            IF (IRELR.GT.MaxI3t) THEN
              MaxI3t=IRELR
              MaxI3r=Refl
              K3Imax=K3I
              mcurv=(basym-1.D0)*sinThs*lambda/DPI/(MPSIi2+MPSIr2) &
                  /basym/GB1*(1.D0+sinThs*sinThs/basym*(1.D0+K1)) ! +ve,.1mu
              transscale=xline+Pathl(layer)        ! Sk+Skin+BX
              mt0=dt0		! silly 'last layer' conts
              mtot=ntot
              mtimes=ITIMES
            ENDIF
!plate96  calc of .5% limits
            IF (K3I.LT.K3min.AND.IRELR.GT.MaxI3t*5.D-3) K3min=K3I
            IF (K3I.GT.K3maxt.AND.IRELR.GT.MaxI3t*5.D-3) K3maxt=K3I
            IF (K8I.LT.K8min.AND.IRELR.GT.MaxI3t*5.D-3) K8min=K8I
            IF (K8I.GT.K8maxt.AND.IRELR.GT.MaxI3t*5.D-3) K8maxt=K8I
            IF (Photo.EQ.1) THEN
!L				Dabs
              maxx=TEMUL/DABS(DSIN(theta3))/cosalpha            ! pathlength
              dydchx=(YmaxoC(VL)-YminoC(VL))/(STEPS4-1.D0) &
                  /DCOS(theta3)			!inc.pathlength
              dchxdy=(STEPS4-1.D0) &
                  *DABS(DCOS(theta3)/(YmaxoC(VL)-YminoC(VL)))
!L
              WDTH3=MAX(STEPS4/2.D3,maxx*dchxdy)	! smoothing
              NORMx=1.D0/mufilm*(1.D0-DEXP(-mufilm*maxx))
              delyshiftC(VL)=1.D0/mufilm/mufilm-DEXP(-mufilm*maxx)/mufilm &
                  *(1.D0/mufilm+maxx)
              delyshiftC(VL)=delyshiftC(VL)/NORMx*DCOS(theta3)*cosalpha !Yiz shift
            ELSE
              delyshiftC(VL)=0.D0
            ENDIF
            IF (iplate.EQ.1) THEN
!plate96		  CALL CALCINTENSITY()
              IF (K8I.GT.ISTEPSO) THEN
                K8I=ISTEPSP
                Irel8(K8I)=Irel8(K8I)+IRELR
                Irel28(K8I)=Irel28(K8I)+IRELR		! full, unbroadened
                IF (layer.EQ.1) Irel9(K8I)=Irel9(K8I)+IREL
              ELSEIF (K8I.LT.1) THEN
                K8I=1
                Irel8(K8I)=Irel8(K8I)+IRELR
                Irel28(K8I)=Irel28(K8I)+IRELR		! full, unbroadened
                IF (layer.EQ.1) Irel9(K8I)=Irel9(K8I)+IREL
              ELSE
                Irel28(K8I)=Irel28(K8I)+IRELR		! full, unbroadened
                
                IF (WDTH8.LE.DFLOAT(K8I+1)-CENT8) THEN
                  Irel8(K8I)=Irel8(K8I)+IRELR
                  IF (layer.EQ.1) Irel9(K8I)=Irel9(K8I)+IREL
                ELSE                  ! photo = 0 or near pi/2
                  Ist8=IDINT(CENT8-WDTH8/2.D0)
                  Iast8=IDINT(CENT8+WDTH8/2.D0)
                  IF (Ist8.LE.1) THEN
                    Ist8=1
                    Irel8(Ist8)=Irel8(Ist8)+IRELR/WDTH8      ! a full share
                    IF (layer.EQ.1) Irel9(Ist8)=Irel9(Ist8)+IREL/WDTH8
                  ELSE
!L
                    Irel8(Ist8)=Irel8(Ist8)+IRELR/WDTH8* &
                        (DFLOAT(Ist8)-CENT8+WDTH8/2.D0+1.D0)
                    IF (layer.EQ.1) Irel9(Ist8)=Irel9(Ist8)+IREL/WDTH8* &
                        (DFLOAT(Ist8)-CENT8+WDTH8/2.D0+1.D0)
!L
                  ENDIF
                  IF (Iast8.GT.K8max) THEN
                    Iast8=K8max
                    Irel8(Iast8)=Irel8(Iast8)+IRELR/WDTH8      ! a full share
                    IF (layer.EQ.1) Irel9(Iast8)=Irel9(Iast8)+IREL/WDTH8
                  ELSE
!L
!platedebug               IF (K8I.EQ.1000.) WRITE(*,*) 'Irel8(Iast8),IRELR',Irel8(Iast8),IRELR,WDTH8
                    Irel8(Iast8)=Irel8(Iast8)+IRELR/WDTH8* &
                        (CENT8+WDTH8/2.D0-DFLOAT(Iast8))
!platedebug                IF (K8I.EQ.1000)WRITE(*,*) 'CENT8,last8,Irel8(Iast8)',CENT8,Iast8,Irel8(Iast8)             
                    IF (layer.EQ.1) Irel9(Iast8)=Irel9(Iast8)+IREL/WDTH8* &
                        (CENT8+WDTH8/2.D0-DFLOAT(Iast8))
!L
                  ENDIF
                  IF (Iast8.GT.Ist8+1) THEN
                    DO I=Ist8+1,Iast8-1
                      IF (K8I.EQ.1000) THEN
!platedebug			  WRITE(*,*) 'last8,Ist8,Irel8(I)',Iast8,Ist8,Irel8(I)
                      ENDIF
                      Irel8(I)=Irel8(I)+IRELR/WDTH8
                      
                      IF (layer.EQ.1) Irel9(I)=Irel9(I)+IREL/WDTH8
                    ENDDO
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
!plate96 start of big IF statement calc of Intensity
            
            IF (K3I.GT.ISTEPSO) THEN
              K3I=ISTEPSP
              Irel3(K3I)=Irel3(K3I)+IRELR
              Irel23(K3I)=Irel23(K3I)+IRELR		! full, unbroadened
              IF (layer.EQ.1) Irel6(K3I)=Irel6(K3I)+IREL
            ELSEIF (K3I.LT.1) THEN
              K3I=1
              Irel3(K3I)=Irel3(K3I)+IRELR
              Irel23(K3I)=Irel23(K3I)+IRELR		! full, unbroadened
              IF (layer.EQ.1) Irel6(K3I)=Irel6(K3I)+IREL
            ELSE
              Irel23(K3I)=Irel23(K3I)+IRELR		! full, unbroadened
              IF (WDTH3.LE.DFLOAT(K3I+1)-CENT3) THEN
                Irel3(K3I)=Irel3(K3I)+IRELR
                IF (layer.EQ.1) Irel6(K3I)=Irel6(K3I)+IREL
              ELSEIF (Photo.EQ.1.AND.WDTH3.GT.STEPS4/2.D3) THEN !film weighting
                ONEchx=(1.D0-DEXP(-mufilm*dydchx))/mufilm/NORMx
                Ist3=IDINT(CENT3)
                Iast3=IDINT(CENT3+WDTH3)
                IF (Ist3.LT.1) THEN
                  Ist3=1
                  Irel3(Ist3)=Irel3(Ist3)+IRELR*ONEchx* &
                      DEXP(-mufilm*(YminoC(VL)-Yiz)/DCOS(theta3))      ! a full share
                  IF (layer.EQ.1) Irel6(Ist3)=Irel6(Ist3)+IREL*ONEchx* &
                      DEXP(-mufilm*(YminoC(VL)-Yiz)/DCOS(theta3))      ! a full share
                ELSE
                  Irel3(Ist3)=Irel3(Ist3)+IRELR/NORMx* &
                      (1.D0-DEXP(-mufilm*(DFLOAT(Ist3+1)-CENT3)*dydchx))
                  IF (layer.EQ.1) Irel6(Ist3)=Irel6(Ist3)+IREL/NORMx* &
                      (1.D0-DEXP(-mufilm*(DFLOAT(Ist3+1)-CENT3)*dydchx))
                ENDIF
                IF (Iast3.GT.K3max) THEN
                  Iast3=K3max
                  Irel3(Iast3)=Irel3(Iast3)+IRELR*ONEchx* &
                      DEXP(-mufilm*(DFLOAT(Iast3-1)*dydchx+(YminoC(VL)-Yiz) &
                      /DCOS(theta3)))	! full share
                  IF (layer.EQ.1) Irel6(Iast3)=Irel6(Iast3)+IREL*ONEchx* &
                      DEXP(-mufilm*(DFLOAT(Iast3-1)*dydchx+(YminoC(VL)-Yiz) &
                      /DCOS(theta3)))	! full share,Iten,Igraz
!
                ELSE
                  Irel3(Iast3)=Irel3(Iast3)+IRELR/NORMx* &
                      DEXP(-mufilm*(DFLOAT(Iast3-1)*dydchx+(YminoC(VL)-Yiz) &
                      /DCOS(theta3)))*(1.D0- &
                      DEXP(-mufilm*(CENT3+WDTH3-DFLOAT(Iast3))*dydchx))
                  IF (layer.EQ.1) Irel6(Iast3)=Irel6(Iast3)+IREL/NORMx* &
                      DEXP(-mufilm*(DFLOAT(Iast3-1)*dydchx+(YminoC(VL)-Yiz) &
                      /DCOS(theta3)))*(1.D0- &
                      DEXP(-mufilm*(CENT3+WDTH3-DFLOAT(Iast3))*dydchx))
                ENDIF
                IF (Iast3.GT.Ist3+1) THEN
                  DO I=Ist3+1,Iast3-1
                    Irel3(I)=Irel3(I)+IRELR*ONEchx* &
                        DEXP(-mufilm*(DFLOAT(I-1)*dydchx+(YminoC(VL)-Yiz) &
                        /DCOS(theta3))) !full share
                    IF (layer.EQ.1) Irel6(I)=Irel6(I)+IREL*ONEchx* &
                        DEXP(-mufilm*(DFLOAT(I-1)*dydchx+(YminoC(VL)-Yiz) &
                        /DCOS(theta3))) !full share
                  ENDDO
                ENDIF
              ELSE                  ! photo = 0 or near pi/2
                Ist3=IDINT(CENT3-WDTH3/2.D0)
                Iast3=IDINT(CENT3+WDTH3/2.D0)
                IF (Ist3.LE.1) THEN
                  Ist3=1
                  Irel3(Ist3)=Irel3(Ist3)+IRELR/WDTH3      ! a full share
                  IF (layer.EQ.1) Irel6(Ist3)=Irel6(Ist3)+IREL/WDTH3
                ELSE
!L
                  Irel3(Ist3)=Irel3(Ist3)+IRELR/WDTH3* &
                      (DFLOAT(Ist3)-CENT3+WDTH3/2.D0+1.D0)
                  IF (layer.EQ.1) Irel6(Ist3)=Irel6(Ist3)+IREL/WDTH3* &
                      (DFLOAT(Ist3)-CENT3+WDTH3/2.D0+1.D0)
!L
                ENDIF
                IF (Iast3.GT.K3max) THEN
                  Iast3=K3max
                  Irel3(Iast3)=Irel3(Iast3)+IRELR/WDTH3      ! a full share
                  IF (layer.EQ.1) Irel6(Iast3)=Irel6(Iast3)+IREL/WDTH3
                ELSE
!L
                  Irel3(Iast3)=Irel3(Iast3)+IRELR/WDTH3* &
                      (CENT3+WDTH3/2.D0-DFLOAT(Iast3))
!platedebug               IF (K8I.EQ.1000) WRITE(*,*) 'WDTH3,last3,CENT3,IRELR',WDTH3,Iast3,CENT3,IRELR
                  IF (layer.EQ.1) Irel6(Iast3)=Irel6(Iast3)+IREL/WDTH3* &
                      (CENT3+WDTH3/2.D0-DFLOAT(Iast3))
!L
                ENDIF
                IF (Iast3.GT.Ist3+1) THEN
                  DO I=Ist3+1,Iast3-1
                    Irel3(I)=Irel3(I)+IRELR/WDTH3
                    IF (layer.EQ.1) Irel6(I)=Irel6(I)+IREL/WDTH3
                  ENDDO
                ENDIF
              ENDIF
            ENDIF
            IF (IRELR.GT.Yrel(K3I,6)) THEN      ! main cpt
              Yrel(K3I,3)=meanyl		! c93atest
              Yrel(K3I,6)=IRELR
            ENDIF
            Yshift=Yiz-YozC(VL)+delyshiftC(VL)
!
            Mphotoshift=Mphotoshift+delyshiftC(VL)*IRELR
            MShift3(VL,ip)=MShift3(VL,ip)+Yshift*IRELR
            MShiftB(3*ip-3+VL)=MShiftB(3*ip-3+VL)+Yiz*IRELR
!plate96    This appears to be the wrong place to call plate function
!plate96  Thetaap2 is not recalc'd at this stage it is equivalent to 
!plate96 the last value calc'd in the 705 loop.Thetaap2l(layer)
            
!V		Intended but not implemented detector location:
!	  XD=((GB(1)*DCOS(Thout) - (GB(1)/2.-Cx)*DCOS(Thout+Thetaap2))/
!     1DSIN(Thout-ThetaD-Thetaap2v)) - (Rzf/DTAN(Thout-ThetaD-Thetaap2v))
            
!V	    XD=DSQRT(Rzf**2+(GB(1)+Cx)**2-2.*Rzf*(GB(1)+Cx)*DCOS(ThetaD))*
!     1      (GB(1)*DCOS(Thout) - (0.5*GB(1)-Cx)*DCOS(Thout+Thetaap2v)
!     2      - Rzf*DCOS(Thout-ThetaD-Thetaap2v))/
!     3      (Rzf*DSIN(Thout-ThetaD-Thetaap2v-Thetaob)
!     4	     -(GB(1)+Cx)*DSIN(Thout-Thetaap2v-Thetaob))
!V
950         CONTINUE
!			950 end of that goto statement
!U96: Cancelled:         ENDIF		! cf 950
981         CONTINUE            ! layer
          ENDDO
        ENDIF		! evasion of layer loop == 1000,1050
!		end of goto 1000   continue
        IF (Irel4.GT.MaxI4) THEN
          MaxI4=Irel4
          PkTh1=Th1x
        ENDIF
        IF (Irel7.GT.MaxI1r) THEN
          MaxI1r=Irel7
        ENDIF
        IF (Irel1(K1I).GT.MaxI1) THEN
          MaxI1=Irel1(K1I)		! pk channel refl for Th1
!UJun96:      est. MaxI1=MaxI1*STEPS1o/STEPS1
          Thpk=Th1x			!reftem1 from lastx, as before
!Mactest	 WRITE(*,*) K1I,SNGL(Th1x),SNGL(MaxI1),SNGL(Th1),SNGL(xbdisp),SNGL(Thetas)
          mReftem1=-Reftem1*Temt1/DelthL	!dThetas/dTh1 CMac C->L
        ENDIF
1025    CONTINUE				! end of xbdisp loop
      ENDDO
      
    ENDDO
!
!**************** IF real RI corrn to be found it must be found here:
    MaxI3=0.D0
    MaxI13=0.D0
    DO K3I=2,K3max-1		! full, unbroadened
      IF (Irel23(K3I).GT.MaxI3) THEN
        MaxI3=Irel23(K3I)
        Ypko=DFLOAT(K3I-1)/(STEPS4-1.D0)*(YmaxoC(VL)-YminoC(VL)) &
            +YminoC(VL)
      ENDIF
      IF (Irel3(K3I).GT.MaxI13) THEN
        MaxI13=Irel3(K3I)
        Ypk1o=DFLOAT(K3I-1)/(STEPS4-1.D0)*(YmaxoC(VL)-YminoC(VL)) &
            +YminoC(VL)
      ENDIF
    ENDDO
    
!plate96
!MK03**********************************************************************
!MK03 This section was altered by Mark Kinnane (3/10/03). Previously the
!MK03 value Detxpko was taken as the peak position on the plate detector.
!MK03 This corresponded to the maximum value of the array Irel28. As the 
!MK03 actual spectrum at the plate is contained by the array Irel8 the
!MK03 value of Detxpk1o should actually have been used as this is the 
!MK03 maximum position of Irel8. Further this section now also computes 
!MK03 the positions on the plate at which the peak trails of to 1% and 50%
!MK03 of it's maximum value. These are contained in the variables lo1pc,
!MK03 lo50pc, hi50pc and hi1pc which are then passed to the BRAGGFFM code.
!MK03 As yet it is unclear what the array Irel28 contains (3/10/03).
    
    IF(iplate.EQ.1) THEN
      
      MaxI8=0.D0
      MaxI18=0.D0
      DO K8I=2,K8max-1		! full, unbroadened
        IF (Irel28(K8I).GT.MaxI8) THEN
          MaxI8=Irel28(K8I)
          Detxpko=DFLOAT(K8I-1)/(STEPS8-1.D0)*(Detmaxx(VL)-Detminx(VL)) &
              +Detminx(VL)
        ENDIF
        IF (Irel8(K8I).GT.MaxI18) THEN
          MaxI18=Irel8(K8I)
          Maxchan=K8I
          Detxpk1o=DFLOAT(K8I-1)/(STEPS8-1.D0)*(Detmaxx(VL)-Detminx(VL)) &
              +Detminx(VL)
        ENDIF
      ENDDO
      DO K8I=2,Maxchan
        IF (Irel8(K8I).LT.(MaxI18*0.01D0)) THEN
          lo1pc=DFLOAT(K8I-1)/(STEPS8-1.D0)*(Detmaxx(VL)-Detminx(VL)) &
              +Detminx(VL)
        ENDIF
        IF (Irel8(K8I).LT.(MaxI18*0.5D0)) THEN
          lo50pc=DFLOAT(K8I-1)/(STEPS8-1.D0)*(Detmaxx(VL)-Detminx(VL)) &
              +Detminx(VL)
        ENDIF
      ENDDO
      K8I=K8Max-1
      DO WHILE (K8I.NE.Maxchan)
        IF (Irel8(K8I).LT.(MaxI18*0.01D0)) THEN
          hi1pc=DFLOAT(K8I-1)/(STEPS8-1.D0)*(Detmaxx(VL)-Detminx(VL)) &
              +Detminx(VL)
        ENDIF
        IF (Irel8(K8I).LT.(MaxI18*0.5D0)) THEN
          hi50pc=DFLOAT(K8I-1)/(STEPS8-1.D0)*(Detmaxx(VL)-Detminx(VL)) &
              +Detminx(VL)
        ENDIF
        K8I=K8I-1
      END DO
    ENDIF
!MK03**********************************************************************
    
!UJun96:      est. MaxI3=MaxI3*STEPS4/STEPS1
    MaxI2=0.D0
    MaxI12=0.D0
    DO K2I=2,K2max-1
      IF (Irel22(K2I).GT.MaxI2) THEN
        MaxI2=Irel22(K2I)
        Thpko=DFLOAT(K2I-1)/(STEPS3-1.D0)*(ThmaxoC(VL)-ThminoC(VL)) &
            +ThminoC(VL)
      ENDIF
      IF (Irel2(K2I).GT.MaxI12) THEN
        MaxI12=Irel2(K2I)
        Thpk1o=DFLOAT(K2I-1)/(STEPS3-1.D0)*(ThmaxoC(VL)-ThminoC(VL)) &
            +ThminoC(VL)
      ENDIF
    ENDDO
!UJun96:      est. MaxI2=MaxI2*STEPS3/STEPS1
    IF (ICycle.EQ.1) THEN
      I1L=0
      I1U=0
!Mac!!!
      DO I=1,IDINT(STEPS1o)		! CMac!!! IDINT(STEPS1)
        IF (Irel1(I).GT.5.D-3*MaxI1.AND.I1L.EQ.0) I1L=I
        IF (Irel1(IDINT(STEPS1o)+1-I).GT.5.D-3*MaxI1.AND.I1U.EQ.0) I1U= &
            IDINT(STEPS1o)+1-I
        IF (I1L.GT.0.AND.I1U.GT.0) GOTO 1100
      ENDDO
      I1L=-IDINT(STEPS1o/2.D0)
      I1U=IDINT(1.5D0*STEPS1o)
      WRITE(*,*) 'Range th1 error'
1100  TemL=ThminC(VL)
      TemU=ThmaxC(VL)
!93test	WRITE(*,*)'Th1',Teml,Temu,I1L,I1U,steps1,steps1o,thm2,thm3,Maxi1
!	WRITE(*,*)'I',(Irel1(I),I=I1L-20,I1U+20)
!B
!UJun96: Tried doubling: actually need calc th1 >> output th1x by max th1diff
!mosaicJuly96 Double output range by inserting 2.D0*
      
      IF (Bragg.EQ.1) THEN
        ThminC(VL)=TemL+DelthC*(DFLOAT(I1L)-2.5D0 &
            +2.D0*DFLOAT(I1L-I1U))	    ! range=3*(.005-.005)width+3ch
        ThmaxC(VL)=TemL+DelthC*(DFLOAT(I1U)+.5D0 &
            +2.D0*DFLOAT(I1U-I1L))	    ! range=3*.005 width+3ch
      ELSE
        ThminC(VL)=TemL+DelthC*(DFLOAT(I1L)-2.5D0 &
            +2.D-1*DFLOAT(I1L-I1U))	    ! range=1.5*(.005-.005)width+3ch
        ThmaxC(VL)=TemL+DelthC*(DFLOAT(I1U)+.5D0 &
            +2.D-1*DFLOAT(I1U-I1L))	    ! range=1.5*.005 width+3ch
      ENDIF
!L					Laue check including +x range limits
      ThminC(VL)=DMAX1(ThminC(VL),Thm2)  ! proper range, or crystal lim.(+x)
      ThmaxC(VL)=DMIN1(ThmaxC(VL),Thm3)
      IF (ThmaxC(VL).GT.Thm3C(VL)) THEN	! or sector limit?
        WRITE(*,1111) 'ax=',ThmaxC(VL),Thm3,Thm3C(VL) &
            ,'in=',ThminC(VL),Thm2,Thm2C(VL)
        ThmaxC(VL)=Thm3C(VL)
      ENDIF
      IF (ThminC(VL).LT.Thm2C(VL)) THEN
        WRITE(*,1111) 'in=',ThminC(VL),Thm2,Thm2C(VL) &
            ,'ax=', ThmaxC(VL),Thm3,Thm3C(VL)
        ThminC(VL)=Thm2C(VL)
      ENDIF
!Mac!!!		Proper ranges of output reset. Now for ONLY ONE of two loops.
!UJun96:
      BXp=DMIN1(BXx,BXm)
      IF (AGE.GE.4) THEN                  ! X=0 only
        swidth=0.D0
        DELX=1.D0
!plate96		
!plate96		xmin=0.2D4
!plate96	    xmax=0.2D4		
        xmin=0.D0
        xmax=0.D0
!UJun96: Old Reset Calc Range: N.b. this may not truncate Thm2L,Thm3L...
        IF (Thm2L(VL).LT.ThminC(VL)+DASIN(xmin1/BXp)) &
            Thm2L(VL)=ThminC(VL)+DASIN(xmin1/BXp)
        IF (Thm3L(VL).GT.ThmaxC(VL)+DASIN(xmax1/BXp)) &
            Thm3L(VL)=ThmaxC(VL)+DASIN(xmax1/BXp)
!Mac		Idiot!		DelthL=(Thm3L(VL)-Thm2L(VL))/(STEPS1-1.D0)
!93atest: basic idea: narrow ONE of two loops; or widen th1 loop:
      ELSEIF ((xmax-xmin)/GB(6).GT.Thm3L(VL)-Thm2L(VL).AND. &
          ThminC(VL).GT.xmin/GB(6).AND.ThmaxC(VL).LT.xmax/GB(6)) THEN
        xmin=ThminC(VL)*GB(6)
        xmax=ThmaxC(VL)*GB(6)
!Mac		Idiot!        DELX=(xmax-xmin)/(STEPS2-1.D0)
!96
!UJun96: Old Reset Calc Range: N.b. this may not truncate Thm2L,Thm3L...
      ELSE ! Commented out!! IF (ThminC(VL)+DASIN(xmin1/BXp).GT.Thm2L(VL)
!	1		.AND.ThmaxC(VL)+DASIN(xmax1/BXp).LT.Thm3L(VL)) THEN
        Thm2L(VL)=ThminC(VL)+DASIN(xmin1/BXp)
        Thm3L(VL)=ThmaxC(VL)+DASIN(xmax1/BXp)
!Mac		Idiot!	    DelthL=(Thm3L(VL)-Thm2L(VL))/(STEPS1-1.D0)
      ENDIF
!Mac!!!		End of evaluation. CU96: Earlier 1D-2. Now 5D-3
      I2L=0
      I2U=0
      DO I=2,K2max-1
        IF (Irel2(I).GT.5.D-3*MaxI12.AND.I2L.EQ.0) I2L=I
        IF (Irel2(K2max+1-I).GT.5.D-3*MaxI12.AND.I2U.EQ.0) I2U= &
            K2max+1-I
        IF (I2L.GT.0.AND.I2U.GT.0) GOTO 1200
      ENDDO
!		      ! Pk = ch 1
      IF (I2U.GT.0) GOTO 1200
      IF (Irel2(1).GT.Irel2(K2max)) THEN
        I2U=100
      ELSE
        I2U=(K2max*3)/2
      ENDIF
      WRITE(*,*) 'Range tho error'
      TemL=ThminoC(VL)
      TemU=ThmaxoC(VL)
      ThminoC(VL)=TemL+(TemU-TemL)*(DFLOAT(K2min)-1.5D0)/(STEPS3-1.D0)
      GOTO 1201
1200  TemL=ThminoC(VL)                  ! Range= 3.0*(c01-c99)+3.0ch
      TemU=ThmaxoC(VL)
      ThminoC(VL)=TemL+(TemU-TemL)*(DFLOAT(I2L)-2.5D0+ &
          DFLOAT(I2L-I2U))/(STEPS3-1.D0)
1201  ThmaxoC(VL)=TemL+(TemU-TemL)*(DFLOAT(I2U)+.5D0+ &
          DFLOAT(I2U-I2L))/(STEPS3-1.D0)
      I3L=0
      I3U=0
      DO I=2,K3max-1
        IF (Irel3(I).GT.1.D-2*MaxI13.AND.I3L.EQ.0) I3L=I
        IF (Irel3(K3max+1-I).GT.1.D-2*MaxI13.AND.I3U.EQ.0) I3U= &
            K3max+1-I
        IF (I3L.GT.0.AND.I3U.GT.0) GOTO 1300
      ENDDO
!		      ! Pk = ch 1
      IF (I3U.GT.0) GOTO 1300
      IF (Irel3(1).GT.Irel3(K3max)) THEN
        I3U=100
      ELSE
        I3U=(K3max*3)/2
      ENDIF
      WRITE(*,*) 'Range yo error'
      TemL=YminoC(VL)
      TemU=YmaxoC(VL)
      YminoC(VL)=TemL+(TemU-TemL)*(DFLOAT(K3min)-2.D0)/(STEPS4-1.D0)
      
      GOTO 1301
1300  TemL=YminoC(VL)
      TemU=YmaxoC(VL)
!UJun96: Increase range slightly:
      YminoC(VL)=TemL+(TemU-TemL)*(DFLOAT(I3L)-4.5D0	 &! v -2.5
          +DFLOAT(I3L-I3U))/(STEPS4-1.D0)
1301  YmaxoC(VL)=TemL+(TemU-TemL)*(DFLOAT(I3U)+2.5D0    &! v.5:
          +DFLOAT(I3U-I3L))/(STEPS4-1.D0)					! 3*(c01-c99)+7ch v +3ch
!platedebug
      WRITE(*,*)'YmaxoC(VL),YminoC(VL),,TemL,TemU,I3L,I3U range change?' &
          ,YmaxoC(VL),YminoC(VL),TemL,TemU,I3L,I3U,K3max,K3min
!plate96
      IF (iplate.EQ.1) THEN
        I8L=0
        I8U=0
        DO I=2,K8max-1
          IF (Irel8(I).GT.1.D-2*MaxI18.AND.I8L.EQ.0) I8L=I
          IF (Irel8(K8max+1-I).GT.1.D-2*MaxI18.AND.I8U.EQ.0) I8U= &
              K8max+1-I
          IF (I8L.GT.0.AND.I8U.GT.0) GOTO 1310
        ENDDO
!		      ! Pk = ch 1
        IF (I8U.GT.0) GOTO 1310
        IF (Irel8(1).GT.Irel8(K8max)) THEN
          I8U=100
        ELSE
          I8U=(K8max*3)/2
        ENDIF
        WRITE(*,*) 'Range Detx error'
        TemL=Detminx(VL)
        TemU=Detmaxx(VL)
        Detminx(VL)=TemL+(TemU-TemL)*(DFLOAT(K8min)-2.D0)/(STEPS8-1.D0)
        
        GOTO 1311
1310    TemL=Detminx(VL)
        TemU=Detmaxx(VL)
!UJun96: Increase range slightly:
        Detminx(VL)=TemL+(TemU-TemL)*(DFLOAT(I8L)-4.5D0	 &! v -2.5
            +DFLOAT(I8L-I8U))/(STEPS8-1.D0)
1311    Detmaxx(VL)=TemL+(TemU-TemL)*(DFLOAT(I8U)+2.5D0    &! v.5:
            +DFLOAT(I8U-I8L))/(STEPS8-1.D0)					! 3*(c01-c99)+7ch v +3ch
!platedebug
        WRITE(*,*)'Detminx(VL),Detmaxx(VL),TemL,TemU,I8L,I8U range change?' &
            ,Detminx(VL),Detmaxx(VL),TemL,TemU,I8L,I8U,K8max,K8min
      ENDIF
!V			Intended but not correct?:
!      XDmin=((GB(1)*DCOS(Thmino) - (GB(1)/2.-Cx)*DCOS(Thmino+Thetaap2v))/
!     1DSIN(Thmino-ThetaD-Thetaap2v)) - (Rzf/DTAN(Thmino-ThetaD-Thetaap2v))
!      XDmax=((GB(1)*DCOS(Thmaxo) - (GB(1)/2.-Cx)*DCOS(Thmaxo+Thetaap2v))/
!     1DSIN(Thmaxo-ThetaD-Thetaap2v)) - (Rzf/DTAN(Thmaxo-ThetaD-Thetaap2v))
!V	XDmin=DSQRT(Rzf**2+(GB(1)+Cx)**2-2.*Rzf*(GB(1)+Cx)*DCOS(ThetaD))*
!     1  (GB(1)*DCOS(Thmino) - (0.5*GB(1)-Cx)*DCOS(Thmino+Thetaap2v)
!     2  - Rzf*DCOS(Thmino-ThetaD-Thetaap2v))/
!     3  (Rzf*DSIN(Thmino-ThetaD-Thetaap2v-Thetaob)
!     4	 -(GB(1)+Cx)*DSIN(Thmino-Thetaap2v-Thetaob))
!	XDmax=DSQRT(Rzf**2+(GB(1)+Cx)**2-2.*Rzf*(GB(1)+Cx)*DCOS(ThetaD))*
!     1  (GB(1)*DCOS(Thmaxo) - (0.5*GB(1)-Cx)*DCOS(Thmaxo+Thetaap2v)
!     2  - Rzf*DCOS(Thmaxo-ThetaD-Thetaap2v))/
!     3  (Rzf*DSIN(Thmaxo-ThetaD-Thetaap2v-Thetaob)
!     4	 -(GB(1)+Cx)*DSIN(Thmaxo-Thetaap2v-Thetaob))
!V
      ICycle=2
!93atest: irelmo rescale:
      IRELMo=IRELM
      IF (Mosdel.LE.0.D0.AND.Iprecs.EQ.0) THEN
        STEPS1=1500.D0		! This is sufficient? vs 2.D3 old
        STEPS2=25.D0		! vs 75.D0 old
        STEPS3=DFLOAT(ISTEPSO)	! also cf. braggffm 6000-17800
        STEPS4=DFLOAT(ISTEPSO)
        STEPS8=DFLOAT(ISTEPSO)
        STEPS1o=DFLOAT(ISTEPSO)
      ELSEIF (Iprecs.NE.0) THEN
        STEPS1=2000.D0
        STEPS2=55.D0		! increased; vs 100 before
        STEPS3=DFLOAT(ISTEPSO)
        STEPS4=DFLOAT(ISTEPSO)
        STEPS8=DFLOAT(ISTEPSO)
        STEPS1o=DFLOAT(ISTEPSO)
      ELSE
!		OR(imp,s,1-4)1.4k,61/1k,43/800,37/1650/f(th),35 1000,1000
!		OR (imp,pi) 1.1k,61/1.5k,43/1k,45/1400/g(th),47 1000,1000
        IF (NINT(ORDER).EQ.3.AND.numstr(1:1).EQ.'S') THEN
          STEPS2=37.D0
          STEPS1=800.D0
        ELSEIF (NINT(ORDER).EQ.3.AND.numstr(1:1).EQ.'P') THEN
          STEPS2=45.D0
          STEPS1=1000.D0
        ELSEIF (NINT(ORDER).EQ.1) THEN
          STEPS2=61.D0		! Is this ???
          IF (numstr(1:1).EQ.'P') THEN
            STEPS1=1100.D0
          ELSE
            STEPS1=1400.D0		 &! Is this ???
!93:		! sigma polarisation CPU near 45 degrees:
                *DSQRT(DABS(DCOS(thf0g*2.D0)/0.36D0))
            IF (STEPS1.GT.1700.D0) STEPS1=1700.D0
            IF (STEPS1.LT.150.D0) STEPS1=150.D0
          ENDIF
!93
        ELSEIF (NINT(ORDER).GE.4) THEN
          Scale=(DACOS(DCOS(thf0g)/(1.D0+Maxt2/GB1)) &
              -thf0g)/9.285D-4
          IF (numstr(1:1).EQ.'P') THEN
            STEPS2=4.7D1
            STEPS1=DFLOAT(INT(1400./SNGL(Scale)))
            IF (STEPS1.GT.1500.D0) STEPS1=1500.D0
            IF (STEPS1.LT.150.D0) STEPS1=150.D0
          ELSE			! sigma
            STEPS2=35.D0		! Is this ??? 1hrx35/31
            STEPS1=DFLOAT(INT(1650./SNGL(Scale) &
                *(ABS(COS(SNGL(thf0g)*2.)/0.3586))**0.7))
            IF (STEPS1.GT.1700.D0) STEPS1=1700.D0
            IF (STEPS1.LT.150.D0) STEPS1=150.D0
          ENDIF
          WRITE(*,*) ' S=',Scale,IDNINT(STEPS2),IDNINT(STEPS1)
        ELSE
          STEPS2=43.D0	! Is this ???
          STEPS1=1000.D0
          IF (numstr(1:1).EQ.'P') STEPS1=1500.D0
        ENDIF
        IF (Iprecs.GT.0) THEN
          STEPS1=DFLOAT(MIN(IDINT(STEPS1*1.5),ISTEPSO))
        ENDIF
        STEPS3=4.D3
        STEPS4=4.D3
        STEPS8=4.D3
        STEPS1o=4.D3
      ENDIF
!Mac			Dominated by source width?:
      IF (Thsrange/DABS(swidth)*GB(6).LT..1) THEN
        temSTEPS=STEPS2
        STEPS2=STEPS1
        STEPS1=temSTEPS
!	   ELSEIF (Thsrange/DABS(swidth)*GB(6).LT.1.5) THEN
!        STEPS2=DFLOAT(IDINT(DSQRT(STEPS1*STEPS2)))
!        STEPS1=STEPS2
      ENDIF
      IF (Iprecs.GT.1) THEN
!U96: Unnecessary:	    STEPS1=DMIN1(STEPS1*DFLOAT(Iprecs),DFLOAT(ISTEPSO))
        STEPS1=STEPS1*DFLOAT(Iprecs)
!U96-
        STEPS2=DMIN1(STEPS2*DFLOAT(Iprecs),DFLOAT(ISTEPSO))
      ENDIF
      DelthL=(Thm3L(VL)-Thm2L(VL))/(STEPS1-1.D0)
      IF (xmax.GT.xmin) DELX=(xmax-xmin)/(STEPS2-1.D0)
!Mac
      IF (IREAD.EQ.1) Tim22=SECNDS(Time1)	!vs S(Time0)-Time1
      WRITE(*,1350) Sum,ThminC(VL),ThmaxC(VL),ThminoC(VL),ThmaxoC(VL) &
          ,Thm2L(VL),Thm3L(VL)
      WRITE(*,1351) MaxI1,MaxI4,Thpk,Thpko,Ypko,Tim22,xmin,xmax
1350  FORMAT(1X,'Cyc1S',1PE7.1,',Th1',2(1PE10.3), &
          ';tho',2(1PE10.3),';Th1L',2(1PE10.3))
1351  FORMAT(' MaxI14',2(1PE8.1),' at',3E10.3,' after' &
          ,1PE8.1,'s;x',2(1PE8.1))
!old		      !  reset basym for reftem only
!       basym=-1.D0/(cos2apl+sin2apl*sctemth)
!       umbo2=(1.D0-basym)/2.D0
!       Tem4=DSQRT(DABS(basym)*MPSIr2)*K
!       Temt1=Tem4/basym/sin2T0      ! approximate
!old
      GOTO 600
    ELSE ! ICycle==2
      JLC1=0.D0
      JUC1=0.D0
      JLP1=0.D0
      JUP1=0.D0
      DO I=1,IDNINT(STEPS1o)
        IF (Irel1(I).GT.1.D-2*MaxI1.AND.JLP1.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JLP1=1.D0
          ELSE
            JLP1=DFLOAT(I)-(Irel1(I)-1.D-2*MaxI1)/(Irel1(I)-Irel1(I-1))
          ENDIF
        ENDIF
        IF (Irel1(IDNINT(STEPS1o)+1-I).GT.1.D-2*MaxI1 &
            .AND.JUP1.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JUP1=STEPS1o
          ELSE
            JUP1=STEPS1o+DFLOAT(1-I)+(Irel1(IDNINT(STEPS1o)+1-I) &
                -1.D-2*MaxI1)/(Irel1(IDNINT(STEPS1o)+1-I) &
                -Irel1(IDNINT(STEPS1o)+2-I))
          ENDIF
        ENDIF
        IF (Irel1(I).GT.0.5D0*MaxI1.AND.JLC1.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JLC1=1.D0
          ELSE
            JLC1=DFLOAT(I)-(Irel1(I)-.5D0*MaxI1)/(Irel1(I)-Irel1(I-1))
          ENDIF
        ENDIF
        IF (Irel1(IDNINT(STEPS1o)+1-I).GT..5D0*MaxI1 &
            .AND.JUC1.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JUC1=STEPS1o
          ELSE
            JUC1=STEPS1o+DFLOAT(1-I)+(Irel1(IDNINT(STEPS1o)+1-I) &
                -.5D0*MaxI1)/(Irel1(IDNINT(STEPS1o)+1-I) &
                -Irel1(IDNINT(STEPS1o)+2-I))
          ENDIF
        ENDIF
        IF (JUC1.GT.0.D0.AND.JLC1.GT.0.D0) GOTO 1400
      ENDDO
1400  TemL=ThminC(VL)
      TemU=ThmaxC(VL)
      c251=TemL+DelthC*(JLC1-1.D0)
      c751=TemL+DelthC*(JUC1-1.D0)
      c011=TemL+DelthC*(JLP1-1.D0)
      c991=TemL+DelthC*(JUP1-1.D0)
      JLC2=0.D0
      JUC2=0.D0
      JLP2=0.D0
      JUP2=0.D0
      JLQ2=0.D0
      JUQ2=0.D0
!plate96 some sort of range check happens next????????       
      DO I=2,K2max-1
        IF (Irel2(I).GT.1.D-2*MaxI12.AND.JLP2.EQ.0.D0) THEN
          JLP2=DFLOAT(I)-(Irel2(I)-1.D-2*MaxI12)/(Irel2(I)-Irel2(I-1))
        ENDIF
        IF (Irel2(K2max+1-I).GT.1.D-2*MaxI12.AND.JUP2.EQ.0.D0) THEN
          JUP2=DFLOAT(K2max+1-I)+(Irel2(K2max+1-I)-1.D-2*MaxI12) &
              /(Irel2(K2max+1-I)-Irel2(K2max+2-I))
        ENDIF
        IF (Irel2(I).GT.1.D-3*MaxI12.AND.JLQ2.EQ.0.D0) THEN
          JLQ2=DFLOAT(I)-(Irel2(I)-1.D-3*MaxI12)/(Irel2(I)-Irel2(I-1))
        ENDIF
        IF (Irel2(K2max+1-I).GT.1.D-3*MaxI12.AND.JUQ2.EQ.0.D0) THEN
          JUQ2=DFLOAT(K2max+1-I)+(Irel2(K2max+1-I)-1.D-3*MaxI12) &
              /(Irel2(K2max+1-I)-Irel2(K2max+2-I))
        ENDIF
        IF (Irel2(I).GT..5D0*MaxI12.AND.JLC2.EQ.0.D0) THEN
          JLC2=DFLOAT(I)-(Irel2(I)-.5D0*MaxI12)/(Irel2(I)-Irel2(I-1))
        ENDIF
        IF (Irel2(K2max+1-I).GT..5D0*MaxI12.AND.JUC2.EQ.0.D0) THEN
          JUC2=DFLOAT(K2max+1-I)+(Irel2(K2max+1-I)-.5D0*MaxI12) &
              /(Irel2(K2max+1-I)-Irel2(K2max+2-I))
        ENDIF
        IF (JUC2.GT.0.D0.AND.JLC2.GT.0.D0) GOTO 1450
      ENDDO
1450  TemL=ThminoC(VL)
      TemU=ThmaxoC(VL)
      c252=TemL+(TemU-TemL)*(JLC2-1.D0)/(STEPS3-1.D0)
      c752=TemL+(TemU-TemL)*(JUC2-1.D0)/(STEPS3-1.D0)
      c012=TemL+(TemU-TemL)*(JLP2-1.D0)/(STEPS3-1.D0)
      c992=TemL+(TemU-TemL)*(JUP2-1.D0)/(STEPS3-1.D0)
      mdepth(ip+2)=0.D0
      mthld(ip+2)=0.D0
      Irels=0.D0
      DO I=IDNINT(JLP2)+1,IDNINT(JUP2)	! symmetric percentile range?
        mdepth(ip+2)=mdepth(ip+2)+Imdepth2(I)
        mthld(ip+2)=mthld(ip+2)+Imthld2(I)
        Irels=Irels+Irel22(I)
      ENDDO
      mdepth(ip+2)=mdepth(ip+2)/Irels
      mthld(ip+2)=mthld(ip+2)/Irels
      mdepth(ip+4)=0.D0
      mthld(ip+4)=0.D0
      Irels3=0.D0
      DO I=IDNINT(JLQ2)+1,IDNINT(JUQ2)	! symmetric .1pcile range?
        mdepth(ip+4)=mdepth(ip+4)+Imdepth2(I)
        mthld(ip+4)=mthld(ip+4)+Imthld2(I)
        Irels3=Irels3+Irel22(I)
      ENDDO
      mdepth(ip+4)=mdepth(ip+4)/Irels3
      mthld(ip+4)=mthld(ip+4)/Irels3
      JLC3=0.D0
      JUC3=0.D0
      JLP3=0.D0
      JUP3=0.D0
!93atest: JLQ3 variables, I=1 loop test:
      JLQ3=0.D0
      JUQ3=0.D0
      IF (Irel3(1).GT.5.D-1*MaxI13) THEN
!	   	JLC3=1.D0
        WRITE(*,*) 'c253 LLimit=Ch1', Irel3(1)
      ELSEIF (Irel3(1).GT.1.D-2*MaxI13) THEN
!	   	JLP3=1.D0
        WRITE(*,*) 'c013 LLimit=Ch1', Irel3(1)
      ELSEIF (Irel3(1).GT.1.D-3*MaxI13) THEN
!	   	JLQ3=1.D0
        WRITE(*,*) 'c001 LLimit=Ch1', Irel3(1)
      ENDIF
      IF (Irel3(K3max).GT.5.D-1*MaxI13) THEN
!       JUC3=DFLOAT(K3max)
        WRITE(*,*) 'c753 ULimit=LastCh', Irel3(K3max)
      ELSEIF (Irel3(K3max).GT.1.D-2*MaxI13) THEN
!	   	JUP3=DFLOAT(K3max)
        WRITE(*,*) 'c993 ULimit=LastCh', Irel3(K3max)
      ELSEIF (Irel3(K3max).GT.1.D-3*MaxI13) THEN
!	   	JUQ3=DFLOAT(K3max)
        WRITE(*,*) 'c999 ULimit=LastCh', Irel3(K3max)
      ENDIF
      DO I=2,K3max-1
        IF (Irel3(I).GT.5.D-1*MaxI13.AND.JLC3.EQ.0.D0) THEN
          JLC3=DFLOAT(I)-(Irel3(I)-5.D-1*MaxI13)/(Irel3(I)-Irel3(I-1))
        ENDIF
        IF (Irel3(I).GT.1.D-2*MaxI13.AND.JLP3.EQ.0.D0) THEN
!93atest: check on coverage of Yo profile:
          JLP3=DFLOAT(I)-(Irel3(I)-1.D-2*MaxI13)/(Irel3(I)-Irel3(I-1))
        ENDIF
        IF (Irel3(I).GT.1.D-3*MaxI13.AND.JLQ3.EQ.0.D0) THEN
          JLQ3=DFLOAT(I)        !-(Irel3(I)-1.D-3*MaxI13)/(Irel3(I)-Irel3(I-1))
        ENDIF
        IF (Irel3(K3max+1-I).GT..5D0*MaxI13.AND.JUC3.EQ.0.D0) THEN
          JUC3=DFLOAT(K3max+1-I)+(Irel3(K3max+1-I)-.5D0*MaxI13) &
              /(Irel3(K3max+1-I)-Irel3(K3max+2-I))
        ENDIF
        IF (Irel3(K3max+1-I).GT.1.D-2*MaxI13.AND.JUP3.EQ.0.D0) THEN
          JUP3=DFLOAT(K3max+1-I)+(Irel3(K3max+1-I)-1.D-2*MaxI13) &
              /(Irel3(K3max+1-I)-Irel3(K3max+2-I))
        ENDIF
        IF (Irel3(K3max+1-I).GT.1.D-3*MaxI13.AND.JUQ3.EQ.0.D0) THEN
          JUQ3=DFLOAT(K3max+1-I)        !+(Irel3(K3max+1-I)-1.D-3*MaxI13)
!       1 /(Irel3(K3max+1-I)-Irel3(K3max+2-I))
        ENDIF
        IF (JUC3.GT.0.D0.AND.JLC3.GT.0.D0) GOTO 1600
      ENDDO
1600  TemL=YminoC(VL)
      TemU=YmaxoC(VL)
      c253=TemL+(TemU-TemL)*(JLC3-1.D0)/(STEPS4-1.D0)
      c753=TemL+(TemU-TemL)*(JUC3-1.D0)/(STEPS4-1.D0)
      c013=TemL+(TemU-TemL)*(JLP3-1.D0)/(STEPS4-1.D0)
      c993=TemL+(TemU-TemL)*(JUP3-1.D0)/(STEPS4-1.D0)
      mYo(ip+2)=0.D0
      Irels=0.D0
      DO K3I=IDNINT(JLP3),IDNINT(JUP3)    ! symmetric percentile range?
        mYo(ip+2)=mYo(ip+2)+Irel3(K3I)*DFLOAT(K3I-1)
        Irels=Irels+Irel3(K3I)
      ENDDO
      mYo(ip+2)=mYo(ip+2)/Irels/(STEPS4-1.D0)*(YmaxoC(VL)-YminoC(VL)) &
          +YminoC(VL)-YozC(VL)
      mYo(ip+4)=0.D0
      Irels3=0.D0
      DO K3I=IDNINT(JLQ3),IDNINT(JUQ3)    ! symmetric .1pcile range?
        mYo(ip+4)=mYo(ip+4)+Irel3(K3I)*DFLOAT(K3I-1)
        Irels3=Irels3+Irel3(K3I)
      ENDDO
      mYo(ip+4)=mYo(ip+4)/Irels3/(STEPS4-1.D0)*(YmaxoC(VL)-YminoC(VL)) &
          +YminoC(VL)-YozC(VL)
!93atest-
    ENDIF
!	     6: Calc. profile and mean shift.
    IF (Reflint(1).LE.0.D0) THEN
      WRITE(*,*) 'No reflection for this wavelength at this angle!'
!        CALL OUTFILS(VL,dalpha,lambda,Twod,swidth,ORDER)
!	RETURN
    ELSE
      Mshift1=Mshift1/Reflint(1)
      MShift2=Mshift2/Reflint(1)
      MShift3(VL,ip)=MShift3(VL,ip)/Reflint(1)
      MShiftB(3*ip-3+VL)=MShiftB(3*ip-3+VL)/Reflint(1)/GB(1)-Temth0
      Mphotoshift=Mphotoshift/Reflint(1)
      mdepth(ip)=mdepth(ip)/Reflint(1)
      mthld(ip)=mthld(ip)/Reflint(1)
!Mac:
      meanxxp(VL)=meanxxp(VL)/Reflint(1)
!test      WRITE(*,*) 'th3,thap2 ranges',SNGL(minth3),SNGL(maxth3),
!t     1   SNGL(minthap2),SNGL(maxthap2)
!
!		      Calcn of Mshift4: Inverse transformation
!	shift of equivalent theta from Bragg on generatrix with basym=-1
!	to account for Yiz(dalpha=?,basym=?,thout=?,thin=?) vs Yoz
!
      Yiz=YozC(VL)+Mshift3(VL,ip)			! -delyshiftC(VL)
      thtema4=thtema(VL)
!LAUECURRENT
      IF (Mininc.GE.0.D0.AND.Bragg.NE.1) GOTO 1725		! Dummy goto
!B:
      IF (thtem4.LE.Minthinc) thtem4=DMIN1(Minthinc &
          +toldel*1.D-1,Yiz/GB(1))
      IF (Isect(VL).GT.2) THEN			! not sure about Sector 4 ...
        thtem4=DPI-thtem4
      ENDIF
      temxl=DSIN(thtem4)-DSIN(thtem4-thtema4)/2.D0      ! from beginning
      xline=GB(1)*(temxl+DSQRT(temxl*temxl+DCOS(thtema4)-1.D0))
      sinth2=DSIN(Yiz*2.D0/GB(1))
      costh2=DCOS(Yiz*2.D0/GB(1))
!test
      WRITE(*,1630) VL,YozC(VL),Yiz,thtem4,thtema4
1630  FORMAT(4X,'Inversion: VL,Yo,i,th,a',I2,4(1PE13.6))
      IF (Minthinc*GB(1).GE.Yiz) THEN
        WRITE(*,*)' Bypassing inversion as Yiz below simplistic minimum'
        Mshift4(VL)=(Yiz-Minthinc)/GB(1)
        Ermshift4=Mshift4(VL)
        Yoztem=Yiz
      ELSE
        DO I=1,4			! was 4/Ctest
!V
!       dthtema4dthtemV=			!!!	GB(1)**2*
!     1 DSIN(thtem4)/DSIN(thtema4)*
!     1	  (DCOS(AxisTh)-(GB(6)-GB(1)*DSIN(AxisTh))*DCOS(thtem4)
!     2	   /DSQRT((GB(1)*DSIN(thtem4)+GB(6))**2-2.*GB(1)*GB(6)*
!     3	    (DSIN(AxisTh)+DSIN(thtem4))))
!TC			Old approximation/test:
          dthtema4dthtem=2./DSQRT(1.D0-thtema4**2/4.D0)*GB(6)/GB(1)/2.* &
              (DCOS(thtem4-Axisth)/tem14-DSIN(thtem4-Axisth)/tem14**2* &
              (DCOS(thtem4)+GB(6)/GB(1)*DSIN(thtem4-Axisth)))
          dyizdtemxl=-GB(1)/sinth2 &
              *DSIN(thtem4-thtema4)*(-1.D0-temxl/DSQRT(temxl*temxl &
              +DCOS(thtema4)-1.D0))
          dyizdthtemC=-GB(1)/2.D0/sinth2*( &
              (-2.D0*DSIN(thtema4)+2.D0*xline/GB(1)*DCOS(thtem4-thtema4) &
!TC			versus:
!test92       +2.D0*DSIN(thtem4-thtema4)*DSIN(thtema4)/2.D0/DSQRT(temxl**2 &
!test92       +DCOS(thtema4)-1.D0) &
!TC
              )*dthtema4dthtem       &! dthtema4
              -xline*2.D0/GB(1)*DCOS(thtem4-thtema4))       &! dthtem4
              +dyizdtemxl*(DCOS(thtem4)+DCOS(thtem4-thtema4)/2.D0* &
              (dthtema4dthtem-1.D0))                  ! dtemxl
!NEW
          dyizdtha=GB(1)/sinth2*(DSIN(thtema4)-DCOS(thtem4-thtema4) &
              *xline/GB(1)+DSIN(thtem4-thtema4)*DCOS(thtem4-thtema4)/2.D0+ &
              DSIN(thtem4-thtema4)/2.D0/(xline/GB(1)-temxl) &
              *(temxl*DCOS(thtem4-thtema4)-DSIN(thtema4)))
          dyizdtemth=GB(1)/sinth2*(DCOS(thtem4-thtema4)*xline/GB(1) &
              +DSIN(thtem4-thtema4) &
              *(DCOS(thtem4)-DCOS(thtem4-thtema4)/2.D0)+ &
              DSIN(thtem4-thtema4)/(xline/GB(1)-temxl) &
              *temxl*(DCOS(thtem4)-DCOS(thtem4-thtema4)/2.D0))
!current:
!93	WRITE(*,1635) VL,Isect(VL),ABtem,GB1,thtem4
!t1635    FORMAT( ' V,I,Ab,GB1,th=',2I2,3(1PE13.6))
          IF (Isect(VL).EQ.1) THEN
            dthadtemth=-1.D0+GB1/ABtem*DSIN(thtem4)/DSQRT(1.D0- &
                (DCOS(thtem4)*GB1/ABtem)**2)
          ELSEIF (Isect(VL).EQ.2) THEN
            dthadtemth=-1.D0-GB1/ABtem*DSIN(thtem4)/DSQRT(1.D0- &
                (DCOS(thtem4)*GB1/ABtem)**2)
          ELSEIF (Isect(VL).EQ.3) THEN
            dthadtemth=1.D0+GB1/ABtem*DSIN(thtem4)/DSQRT(1.D0- &
                (DCOS(thtem4)*GB1/ABtem)**2)
          ELSEIF (Isect(VL).EQ.4) THEN
            dthadtemth=1.D0-GB1/ABtem*DSIN(thtem4)/DSQRT(1.D0- &
                (DCOS(thtem4)*GB1/ABtem)**2)
          ENDIF
!          dthadtemth=2.D0/DSQRT(1.D0-thtema4*thtema4/4.D0)*GB(6) &
!              /GB(1)/2.D0*(DCOS(thtem4-Axisth)/tem14 &
!              -DSIN(thtem4-Axisth)/tem14/tem14* &
!              (DCOS(thtem4)+GB(6)/GB(1)*DSIN(thtem4-Axisth)))
          dyizdthtem=dyizdtemth+dyizdtha*dthadtemth
          thtem4=DMAX1(thtem4+(Yiz-Yoztem)/dyizdthtem &
              ,Minthinc+DABS((Yiz-Yoztem)/dyizdthtem)/1.D1)
!test       WRITE(*,*) 'I,Yo,i,th:',I,Yoztem,Yiz,thtem4
!V:
!       temTV=thtem4
!       AxisTV=AxisTh
!       thtema4V=EMITANG(temTV,AxisTV,GB(1),GB(6),3)	!might be wrong sign
!TC			versus:
!       tem14=DSIN(thtem4)-DCOS(thtem4-Axisth)*GB(6)/GB(1)
!       thtema4=2.*DASIN(GB(6)/2.D0/GB(1)*DSIN(thtem4-Axisth)/tem14)
!test       WRITE(*,*) 'I,Yo,i,th,aC:',I,Yoztem,Yiz,thtem4,thtema4,thtema4V &
!t                     ,GB(1),GB(6)
!
          CALL GENGEOMS(XXC2(1),XXC2(2),EANGC(1),EANGC(2) &
              ,thtema4,tem24,GB(1),AxisTh,GB(6),thtem4,ABtem,THABX &
              ,THBAX,THABXp(1),THABXp(2),Isect(1),Isect(2))
          IF (VL.EQ.2) thtema4=tem24
!t         WRITE(*,*) 'I,Yo,i,th,a:',I,Yoztem,Yiz,thtem4,thtema4
!TC
          temxl=DSIN(thtem4)-DSIN(thtem4-thtema4)/2.D0
          xline=GB(1)*(temxl+DSQRT(temxl*temxl+DCOS(thtema4)-1.D0))
          costh2=2.D0*DCOS(thtema4)-1.D0-xline*2.D0/GB(1) &
              *DSIN(thtem4-thtema4)
          Yoztem=GB(1)/2.D0*DACOS(costh2)
          sinth2=DSIN(Yoztem/GB(1)*2.D0)
!test
          WRITE(*,1640) I,Yoztem,Yiz,thtem4,thtema4,xline
1640      FORMAT(1X,'I,Yo,i,th,a,xl',I2,2(1PE13.6),3(1PE10.3))
          WRITE(*,1645) dyizdthtem,dyizdtha,dyizdtemth,dthadtemth
!t     2 ,dyizdtemxl,dyizdthtemC,dthtema4dthtem
1645      FORMAT(1X,'dyd,dtd..',4(1PE13.6))
          IF (DABS(Yiz-Yoztem).LT.1.D-4*DABS(Mshift3(VL,ip)) &
              .AND.I.GE.2) GOTO 1700
        ENDDO
1700    Mshift4(VL)=thtem4
!93confused?	vs	DATAN(DTAN(thtem4)*cosalpha)
        Ermshift4=Yiz-Yoztem
      ENDIF
!
1725  CONTINUE
      DO K2I=1,K2max
        IF (Irpout.EQ.2) THEN
          Irel2(K2I)=Irel5(K2I)
        ELSEIF (Irpout.EQ.3) THEN
          Irel2(K2I)=Irel2(K2I)/Irel5(K2I)
        ENDIF
      ENDDO
      DO K3I=1,K3max
        IF (Irpout.EQ.2) THEN
          Irel3(K3I)=Irel6(K3I)
        ELSEIF (Irpout.EQ.3.AND.Irel6(K3I).NE.0.) THEN
          Irel3(K3I)=Irel3(K3I)/Irel6(K3I)
        ENDIF
      ENDDO
      Reflint(1)=Reflint(1)*DelthL		! CMac
!plate96  Need to have calc Irel8 (=Irelplate ) by this stage of prog)
!plate96  transfer of values 	   
      IF (iplate.EQ.1) THEN
!plate96 DO 1730 K8I=1,K8max
!plate96	   		Irel8(K8I)=Irel28(K8I)
!plate961730     CONTINUE 	   
      ENDIF
      CALL OUTFILS(VL,dalpha,lambda,Twod,swidth,ORDER)
    ENDIF
  ENDDO
!
!LAUECURRENT
  IF (Mininc.GE.0.D0) RETURN
!DEC92 below: estimation of effect of DP, esp. for higher orders:
!        YestoC includes b,ap,Cx,Rzf; AND RI shift, Profile a/s, AND DP:
  CALL GENTHSG(DSIN(Temth0g+Mshift2),DCOS(Temth0g+Mshift2) &
      ,sinaplane,cosaplane,sinalpha,cosalpha,Minthinc,sinthcs &
      ,sinTemtho,thcs,thcsg,thc0g,thco,thcog)	! on Gx to/from surface
!		new (determine sectors):
  CALL GENGEOMC(XXC2(1),XXC2(2),EANGC(1),EANGC(2),ThetaacC(1,ip), &
      ThetaacC(2,ip),GB(1),AxisTh,GB(6),thcsg,ABtem,THABX &
      ,THBAX,THABXp(1),THABXp(2),Isect(1),Isect(2))
  DO VL=1,VARMAX			! I==VARLOOP
    BXp=GB(6)*DSIN(AxisTh-ThetaacC(VL,ip)/2.D0) &
        /DSIN(thcsg+ThetaacC(VL,ip)/2.D0)
!l        IF (GB(1).LT.ABtem.AND.
!l     1     (Isect(VL).EQ.2.OR.Isect(VL).EQ.4)) THEN
!l         BXp=GB(1)*DCOS(THABXp(VL)+Temthsg)/DSIN(THABXp(VL))
!l        ELSE
!l         BXp=GB(1)*DCOS(THABXp(VL)-Temthsg)/DSIN(THABXp(VL))
!l        ENDIF
!B
    IF (Bragg.EQ.1) THEN
      CALL GENXYS(YestcC(VL,ip),Theta3,detflag,xline, &
          ThetaacC(VL,ip),GB(1),Axisth,thcog,Cx,PZ,Isect(VL))	!PZ=Rzf
      IF (iplate.EQ.1) THEN
        WRITE(*,*) 'ThetaacC just before call to platefunc',ThetaacC(VL,ip)
        CALL PLATEFUNC (Detx,Thout,GB(1),Cx,Axisth,ThetaacC(VL,ip), &
            Detarmlen,Dettheta,Detbeta,Rplate) 
      ENDIF
      IF (detflag.EQ.1) THEN
        WRITE(*,16) VL
16      FORMAT(1X,' cg) ',I2,'=No match on detector surface' &
            ,'(R C, Gx) with aplane')
!        VARMAX=1
      ENDIF
    ENDIF
  ENDDO
!DEC92 above
  RETURN
END
!---------------------------------------------------------------------------
!	            Old crystallite model
!	   IF (ysurf.LT.-dely0*1.5.AND.ntot.GT.1.AND.layer.EQ.1) THEN
!	*****                  !est/meany/layer(mid-plane)
!	    ylayer=ysurf      ! front => maxr; absn dominates
!	    dely=dely0*(DFLOAT(layer-ntotp)+0.5)-ysurf ! front - back
!	    dbar=0.
!	    Thlayer=(ylayer*Tem4-umbo2*RPSI0)/sin2T0/(-basym)+Temth0
!	    TemSk=(GB1+dbar)*DSIN(Thlayer+aplane)
!	    IF (DABS(dely).LT.1.0D-8) GOTO 960
!	   ELSEIF (ntot.EQ.1) THEN ! only one layer
!	    dely=dely0
!	    ylayer=ysurf                  ! default
!	    dbar=0.
!	    Thlayer=(ylayer*Tem4-umbo2*RPSI0)/sin2T0/(-basym)+Temth0
!	    TemSk=(GB1+dbar)*DSIN(Thlayer+aplane)
!	   ELSEIF (ysurf.LT.-dely0*1.5) THEN            ! layer>1
!	*****
!	    ylayer=dely0*DFLOAT(layer-ntotp)
!	    dely=dely0            ! Del y thickness for crystallite
!	    Thlayer=(ylayer*Tem4-umbo2*RPSI0)/sin2T0/(-basym)+Temth0
!	    dbar=GB1*(cosThs/DCOS(Thlayer-aplane-dely/2.*temt)-1.) !dbar|yl
!	    TemSk=(GB1+dbar)*DSIN(Thlayer+aplane-dely/2.*temt)
!	   ELSEIF (ysurf.GE.dely0/2.) THEN !ysurf>dely0/2.
!	    dely=dely0
!	    ylayer=ysurf+DFLOAT(layer-1)*dely0
!	    Thlayer=(ylayer*Tem4-umbo2*RPSI0)/sin2T0/(-basym)+Temth0
!	    dbar=GB1*(cosThs/DCOS(Thlayer-aplane)-1.) !dbar|yl
!	    TemSk=(GB1+dbar)*DSIN(Thlayer+aplane)
!	   ELSE                  ! -1.5*dely0<ysurf<dely0/2.
!		            ! make yl,dely cts
!	    dely=dely0
!	    ylayer=ysurf*0.75+dely0/8.+DFLOAT(layer-1)*dely0
!	    Thlayer=(ylayer*Tem4-umbo2*RPSI0)/sin2T0/(-basym)+Temth0
!	    dbar=GB1*(cosThs/DCOS(Thlayer-aplane-(dely0/8.-ysurf/4.)
!     1*temt)-1.) !dbar|yl
!	    TemSk=(GB1+dbar)*DSIN(Thlayer+aplane-(dely0/8.-ysurf/4.)
!     1*temt)
!	   ENDIF
!--------------------------------------------------------------------------
!---------------------------------------------------------------------
!	Sub routine for Int. Tables of X-ray Cryst + Henke
!	 PHOTOGRAPHIC ATTENUATION coefficients. i.e. only Mutot.
!	 CALLS other subroutines (q.v. FORMF) iff not given by RDDEF's
!
SUBROUTINE FORMF1
  IMPLICIT NONE
!91			Form factor variables
  integer ielem
  parameter (ielem=20)
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!
  DOUBLE PRECISION amu(ielem),rho(ielem),Mui(ielem)
  integer nedge(ielem),iPhoto
  INTEGER emultype
  COMMON/FORMFC2/amu,rho,Mui,nedge,iPhoto,emultype
!
  DOUBLE PRECISION energynew
  DOUBLE PRECISION fp(ielem),fpp(ielem)
  COMMON/newcom/energynew,fp,fpp
!			database integration
  INTEGER iGLflag,iGLorder,iGLstep
  DOUBLE PRECISION d_x(16), d_a(16)
  COMMON/GLweights/ d_x,d_a,iGLflag,iGLorder,iGLstep
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!
  INTEGER TemZed(6),tematoms
  DOUBLE PRECISION Volpc,NVolpc,Mu1,Mu0,dprime,Mum
!93      I=1
!93     WRITE(*,*) 'DEF (1) or 101 (0)?'
  IF (emultype.EQ.1) THEN
    Volpc=0.4	! quoted DEF Ag grain percent volume
    dprime=1.525/1.5	! 2/3 d, article II/7
  ELSE
    Volpc=0.74	! 1.0 quoted 101 Ag grain percent volume
    dprime=0.85/1.5	! 2/3 d, article II
  ENDIF
!U96 define NVolpc to avoid warning
  NVolpc=1.D0-Volpc
!
!95
!	Write(*,*) natomtypes, (kZed(iatom),iatom=1,natomtypes)
  tematoms=natomtypes
  DO iatom=1,6
    TemZed(iatom)=kZed(iatom)
  ENDDO
  natomtypes=6
  
  kZed(1)=1			! H
  kZed(2)=6			! C
  kZed(3)=7			! N
  kZed(4)=8			! O
  kZed(5)=47		! Ag
  kZed(6)=35		! Br
!     Photo=1
  iPhoto=1
  DO iatom=1,6
    CALL FORMF
  ENDDO
  Mu0=(Mui(1)*1.00797*16.+Mui(2)*12.01115*8. &
      +Mui(3)*14.0067*2.+Mui(4)*15.9994*5.)*1.4E-4/220.22712
  Mu1=(Mui(5)*107.87+Mui(6)*79.909)*6.473E-4/187.779
!95
  Mum=(Mu0*NVolpc+Mu1*Volpc)/1.D1      ! /.1micron old defn
!93      MupH=Mu0-DLOG(1.-Volpc*(1.-DEXP(d*(Mu0-Mu1+Sscat1-Sscat0))))/d
  Mu=Mu0-DLOG(1.D0-Volpc*(1.D0-DEXP(dprime*(Mu0-Mu1))))/dprime
  natomtypes=tematoms
!93atest:	reconfirm Mum:	Write(*,*) 'test',Mu,Mum
  DO iatom=1,6
    kZed(iatom)=TemZed(iatom)
  ENDDO
  RETURN
END
!***********************************************************************
!		Subroutine FORMF
!	 Subroutine for Int. Tables of X-ray Cryst + Henke + Viegele,
!	 and Cromer - Liberman theory for atomic, isotropic form factors.
!	ALL corrected as discussed here and in FFCOMPARE.FOR,.TEX.
!	 Following FFCOMPARE.for for extracting data from
!	dua0:[syslib]absorption.dat,abs$raycomp.dat,abs$sfcoef.dat
!	using abs$atomic_data.for,abs$cromer.for,abs$raycomp.for
!	and abs$sfcoef.for. System calls to sfcoef, cromer, atomic_data,
!	raycomp eliminated. Partially follows earlier work of Brennan/Cowan
!			CTChantler,Dec.1991
!---------------------------------------------------------------------
!  RDDEF.* base FORM FACTORS from Henke82 .03-10keV, Z=1-94
!			mu(photoelectric),f1,f2
!	extended to 20keV using f2=a mu(PE), lim(f1,E->inf)=Z,
!	and to 5eV using Reilman/Manson/extrapolation.
!  Viegele73,74 gives mu(total) and sig(scattering) and sig(incoherent)
!	used for mu(film),muabs and psi0''
!	Tabulation for Z=1,4,6,7,8,13,14,15,19,35,47 only.
!91    Validity (< gives est. 1-5% extrapolation/interpolation except edges;
!		 << gives larger value, say 5-20% uncertainty):
!  Updated to CTC/H(2) as follows
!	 5eV<<<30eV<<100eV<f1<2keV<20keV; 5eV<<(10-30)eV<f2,mu<10keV<20keV;
!	 5eV<sig(scat),sig(inc)<20keV.
!	F=(f1+f0(k)-Z-Df_r,f2+compt/inc) (H82,Jensen79,Cromer/Liberman).
!	For hkl=000, f0(k)-Z=0.
!	Otherwise, f0(k) from IntTabXRayCryst III, IV 3.3, 2.2.
!      Validity?: 0<=sintheta/lambda=1/2d<=(1.50-2.00)(A-1)
!		Surface reflection + nuclear scattering neglected.
!  Brennan/Cowan base FORM FACTORS follow same articles
!	(i.e. to Jensen79) with fp=f1-Z-Df_r, sfcoef=f0(k),
!	Df_r=relcor+Jensen, fpp=f2, compt/inc defined twice
!	(comp(E)+S(q,Z)). comp,ray in barns/atom=(1.4311e-8E)^{-1}sig(e/atom)
!	fp, fpp derived from theory (sum over orbitals),
!	tabulated as log(xsect(barns)) below Ebinding, or fn for tails
!		OR inter/extrapolation of McMasters' H,He - data.
!	Calcn of sum using formulae (B/C) differ (primarily) from
!	fitted/exptal tables (H) near edges (where both have 10%+ err)
!	f0(k) from sum-of-exponentials Cromer/Mann, Acta Cryst A24(68)321
!	Validity?: except for numerical error (CL ActaCrystA37(1981)267)
!	 should be similar/same for f1,f2:
!	 Df1=0%(>=1keV,H),-0.4e,1%(1keV,Ag).
!	 Df2=1%(1keV,H),7%(10keV,H),7%(20keV,H)-0.6e,4%(1keV,Ag).
!	 Df0(k)=1%(H),1-4%(st/l<.3,C),12%(>7,C?),6%(=.4,Ag)
!	 v '2-4%'(sinth/l<2,Ag,Hubbell) := ?0<=sinth/l=1/2d<=1.50(A-1)+?
!	 Tabulated for Z=1-92. Fitted from Mann HF functions.
!	 Except for B/C Z=1, f0 accurate to 10% for q<2.0.
!	 5eV<<100eV<f1<2keV<<20keV; 5eV<(10-30)eV<f2,mu<10keV<20keV;
!	 5eV<sig(scat),sig(inc)<20keV.
!---------------------------------------------------------------------
!			General Conclusions:
!	Updated RDDEF, CTC/H(2) from Hen82, Viegele is generally superior.
!	Edge-interpolated HenPC (1988) is better in particular regimes,
!	 and more extensive, but still suffers from lack of data and hence
!	 edge and low-E difficulties.
!	Rewritten interpolated/extrapolated/integrated B/C/C(2)
!	 theoretically covers any range, may be superior at particular
!	 edges e.g. L_{I}, M_{II-III}, M_{IV-V} regions and even for
!	 f2 over particular ranges. Is limitted by collective/valence
!	 effects at low energies, and by pair production and inadequate
!	 incoherent cross-sections at high (circa 500 keV) energies.
!---------------------------------------------------------------------
!	B/C=C/L give calculations of relcor; Hen,(CTC), HenPC use
!	 interpolation over Z (more accurate for Z<10: difference
!	 of 30% at low E or .001e error in f1,fp).
!	f1,f2: Hen,(CTC),HenPC derived from smoothed mu(PE,exp.);
!	 B/C,C/L from database for (most) orbitals, from theory,
!	 sampled at 10-11 energies above the edge. Valence orbitals
!	 omitted. Possibly massaged to avoid discrepancies.
!	 H,He from McMaster's data/formulae where earlier method failed.
!	 div/0 errors for Ar at 1.28keV, several other elements,
!	 revealing inadequacy of B/C and C/L formulae, even in quoted
!	 applicable region. Updated to B/C/C(1) and now B/C/C(2), here.
!	f0: B/C == (CTC=Int.Tab.X-rayCryst.) except for H (rho of gases)
!	 where atomic? hydrogen selected by B/C vs bonded H.
!	S(q,Z): B/C: interesting for inelastic scattering at angle==q;
!	 complicated integral to give sigma(inc).
!	mu(tot)=mu(PE)+sigcoh+siginc (CTC/Viegele,Henke);
!	sig1=sigcoh+siginc (''); sig2=siginc
!	cf. ray=sigcoh; comp=siginc. (OK at higher E's).
!	Omitted: sig(nuclear PE),sig(pair N e+e-),sig(pair e),Delbruck...
!----------------------------------------------------------------------
!	UNIT:	2=rddef=sfcoef=Henpc=absorption=raycomp
!	raycomp database in barns/atom; f's in e/atom; mu,sigs in cm2/g
!---------------------------------------------------------------------
SUBROUTINE FORMF
  IMPLICIT NONE
!---------------------------------------------------------------------
! COMMON block inputs
!  kZed, iatom, elemend, Iffsource, DATFIL, iPhoto
!  energynew, fp, fpp, Ifeff, Na11, e_per_b, IMac, ddat, dhen, dhm
!
! COMMON block outputs
!  Read from file
!   - En, Mu, f1, f2, sig1, sig2
!  Calculated
!   - f1o, f2o, Eno, Muo, POWER, sig1o, sig2o, SIG, f01, f02
!     Z, CFIL, SYMBOL, Mui, Zeff, eterm, fh1
!  Read from file by a called procedure
!   - coef
!  Calculated by a called procedure
!   - amu, rho, nedge, A1, B1, C1, fh1
!---------------------------------------------------------------------
!91			Form factor variables
  integer ielem
  parameter (ielem=20)
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!neverused:
  INTEGER Intflag,Iint
  COMMON /COMINT/ Intflag,Iint
!
  INTEGER Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
  COMMON /COMINTS/ Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
!
  INTEGER IREAD,Photo,Jbit4,Fwrite(0:20)
  COMMON/CS5F/ IREAD,Photo,Jbit4,Fwrite
!BCC2
  DOUBLE PRECISION amu(ielem),rho(ielem),Mui(ielem)
  integer nedge(ielem),iPhoto
  INTEGER emultype
  COMMON/FORMFC2/amu,rho,Mui,nedge,iPhoto,emultype
!		storage for alternate f01,f02 (B/C/C(2))
  DOUBLE PRECISION energynew
  DOUBLE PRECISION fp(ielem),fpp(ielem)
  COMMON/newcom/energynew,fp,fpp
  real coef(19)
  COMMON /SFDAT/ coef
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!
  integer iedge
  parameter (iedge=24)
  integer iopen,n_orb,i_funtype(iedge),i_nparms(iedge)
  DOUBLE PRECISION d_xsect(iedge,11), d_nrg(iedge,11) &
      ,d_sum_fp(4)	,d_sum_fpp(4)
  double precision eterm,amu_save,rho_save,bind_nrg(iedge)
  COMMON/ CRODAT/ iopen, n_orb, i_funtype, i_nparms &
      , eterm, amu_save, rho_save, bind_nrg &
      , d_xsect, d_nrg,d_sum_fp,d_sum_fpp
!		bind_nrg(1)=the k-edge energy
!		bind_nrg(2)=the LIII edge energy
!		relcor is the relativistic correction term
!91
  INTEGER J5,I,lun
  integer item,jZed, iSYMBOL
  DOUBLE PRECISION corr
  DOUBLE PRECISION Zsum,Zi
  character FILEIN2*20
  character Rubbish*15
!BCC
  DOUBLE PRECISION ray,comp,cm2g_per_ba,En1 &
      ,MuCL,abs_edge(iedge),frel,relcor
!HenPC
  integer jedge,iflagm,iflagp,iflag0
  DOUBLE PRECISION f1p,f1op,f1oop,f2p,f2op,f2oop,f01p &
      ,f02p,Enp,Enop,Enoop
  DOUBLE PRECISION MuHPC
!			element symbols
  character*2 elemend(92)
  COMMON/elecom/elemend
!			database integration
  INTEGER iGLflag,iGLorder,iGLstep
  DOUBLE PRECISION d_x(16), d_a(16)
  COMMON/GLweights/ d_x,d_a,iGLflag,iGLorder,iGLstep
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!MAC95
  CHARACTER dout*11,dcom*11,ddat*7,dhen*16,dhm*8
  COMMON/Macfiles/ dout,dcom,ddat,dhen,dhm
!MAC95
!		Energy limits for 'optimum'/default f1/f2 determination
  DOUBLE PRECISION Elim1,Elim2
  DOUBLE PRECISION me_amu		! mass of electron in amu = g/mol
  CHARACTER*2 Cifeff
!
  me_amu=5.48579903D-4	! (pm13) = 0.023ppm
  Elim1=1.0			! keV upper limit for RDDEF (Hen82+)
  Elim2=10.0		! keV upper limit for Hen90
!      Elim1=20.0		! database, old limit for RDDEF (Hen82+)
!      Elim2=30.0		! database, old limit for Hen90
!
  jZed=kZed(iatom)
  Z=DFLOAT(jZed)
!	Get reference to Z, datafiles: CFIL (RDDEa, CTC/H(2)) first
  IF (jZed.EQ.1) THEN
    CFIL='D1'            ! Hydrogen
  ELSEIF (jZed.EQ.4) THEN
    CFIL='D7'            ! Beryllium, but only E,mu
  ELSEIF (jZed.EQ.6) THEN
    CFIL='D2'            ! Carbon
  ELSEIF (jZed.EQ.7) THEN
    CFIL='D3'            ! Nitrogen
  ELSEIF (jZed.EQ.8) THEN
    CFIL='D4'            ! Oxygen
  ELSEIF (jZed.EQ.13) THEN
    CFIL='D8'            ! Al
  ELSEIF (jZed.EQ.14) THEN
    CFIL='C1'            ! Si
  ELSEIF (jZed.EQ.15) THEN
    CFIL='D9'            ! Phosphorus
  ELSEIF (jZed.EQ.19) THEN
    CFIL='C2'            ! K, Potassium
  ELSEIF (jZed.EQ.35) THEN
    CFIL='D6'            ! Bromine
  ELSEIF (jZed.EQ.47) THEN
    CFIL='D5'            ! Silver
  ELSE
    CFIL='D0'            ! Nothing
  ENDIF
!	Get SYMBOL (HenPC) next
  IF (jZed.LT.1.OR.jZed.GT.92) THEN
    WRITE(*,*) 'Element beyond range, default symbol used'
    SYMBOL='AA'
  ELSE
    SYMBOL=elemend(jZed)
  ENDIF
  iSYMBOL=2
  IF (SYMBOL(2:2).EQ.' ') iSYMBOL=1
!	use Cowan/Brennan library code to get amu, rho?
!Mactest		WRITE(*,*) 'CS5/formf'
  CALL atomic_data(jZed,amu(iatom),rho(iatom),nedge(iatom),abs_edge) ! (FTSUPP.f)
!92		calculate Zeff for compare-measures
!Mactest	WRITE(*,*) 'CS5/formf',dhm,ddat,cfil,symbol,dout,iread,imac
  Zeff(iatom)=Z
  Zsum=0
  DO jedge=1,nedge(iatom)	! in C/L order (note 6s error, etc.)
    IF (jedge.EQ.4.OR.jedge.EQ.7.OR.jedge.EQ.8.OR.jedge.EQ.12.OR.jedge.EQ.13 &
                  .OR.jedge.EQ.17.OR.jedge.EQ.20.OR.jedge.EQ.24) THEN
      Zi=4
    ELSEIF (jedge.EQ.9.OR.jedge.EQ.14.OR.jedge.EQ.18.OR.jedge.EQ.21) THEN
      Zi=6
    ELSEIF (jedge.EQ.19) THEN
      Zi=8
    ELSE
      Zi=2
    ENDIF
    IF (Zsum+Zi.GE.Z) Zi=Z-Zsum
    Zsum=Zsum+Zi
    Zeff(iatom)=Zeff(iatom)+Zi*(abs_edge(jedge)/energynew)**2 &
                *DLOG(DABS(1.D0-(energynew/abs_edge(jedge))**2)+1.D-20)
  ENDDO
!92		end of calcn
  cm2g_per_ba=(Na11*1.0D-35)/amu(iatom)
!		compute relativistic corrections to f1
  IF (jZed.LT.10) eterm=2.19D-6*Z**3+1.03D-4*Z*Z	! o/write
  frel=-0.6*eterm-Z*Z*me_amu/amu(iatom)
!91	exclude J=-Z/2.*(SNGL(Energynew)/mec2)**2
!	this includes Smith's observations on the static component
!			(see ffcompare.tex)
  En1=energynew*1.D3		! eV
!		compute ray, comp iff sig1, sig2 absent
  IF (CFIL.EQ.'D7'.OR.CFIL.EQ.'D0'.OR.Energynew.GE.20.0.OR.Energynew.LE.0.005) THEN
    call raycomp(jZed,En1,ray,comp)	! ray,comp in b/atom
!	ray, comp barns/atom => cm2/g, like mu, sig...
    SIG(2,iatom)=comp*cm2g_per_ba
    SIG(1,iatom)=ray*cm2g_per_ba+sig(2,iatom)
  ENDIF
!	 Get mu(total),f1,f2(Henke),sig(coherent+incoh+pair),sig(inc)
!		This cut-off should lie BELOW 20 keV
  IF (CFIL.NE.'D7'.AND.CFIL.NE.'D0'.AND.Energynew.GT.0.005.AND.Energynew.LT.20.0) THEN	! use current RDDEF data files.
    FILEIN2=DATFIL//CFIL
    OPEN (UNIT=2,FILE=ddat//FILEIN2,STATUS='OLD')
1340 READ (2,*) En,Mu,f1,f2,sig1,sig2      ! H,C,N,O incoh.scat.
    IF (En.LT.Energynew) THEN
      Eno=En
      Muo=Mu
      f1o=f1
      f2o=f2
      sig1o=sig1
      sig2o=sig2
      GOTO 1340
    ELSE
      POWER=(DLOG(f2)-DLOG(f2o))/(DLOG(En)-DLOG(Eno))
      f02(iatom)=f2o*(Energynew/Eno)**POWER
      POWER=(DLOG(Mu)-DLOG(Muo))/(DLOG(En)-DLOG(Eno))
      Mui(iatom)=Muo*(Energynew/Eno)**POWER		! POSSIBLE EST
      f01(iatom)=f1o+(Energynew-Eno)/(En-Eno)*(f1-f1o)
      SIG(1,iatom)=sig1o+(Energynew-Eno)/(En-Eno)*(sig1-sig1o)
      SIG(2,iatom)=sig2o+(Energynew-Eno)/(En-Eno)*(sig2-sig2o)
    ENDIF
    IF (iPhoto.NE.1) THEN
      Cifeff='oH'
    ENDIF
    IF (iPhoto.NE.1.AND.Ifeff.NE.2) THEN
      WRITE(*,1341) Cifeff,f01(iatom),f02(iatom),SIG(1,iatom),SIG(2,iatom)
    ENDIF
1341 FORMAT(X,A2,':f01,2(,s1,s2)=',4(1PE11.4))
    CLOSE(2,STATUS='KEEP')
  ENDIF
!91	Respond to choice of database. Select optimum f1, f2, Mui
!Henpc		! Henke/pc based tables, E in eV, note 30eV f1 cutoff
  IF (energynew.GT.0.01.AND.energynew.LT.Elim2.AND. &
      (Iffsource.EQ.2.OR.(Iffsource.LT.2.AND.(CFIL.EQ.'D0' &
      .OR.CFIL.EQ.'D7'.OR.energynew.GT.Elim1)))) THEN	! ??????
!Mactest	   WRITE(*,*) dhm//symbol//'.asc'
    IF (IMac.EQ.1) THEN
      OPEN (2,FILE=dhm//SYMBOL(1:iSYMBOL)//'.asc',STATUS='OLD')
    ELSE
      OPEN (2,FILE=dhen//SYMBOL(1:iSYMBOL)//'.asc',STATUS='OLD')
    ENDIF
8   FORMAT(X,A15)
    READ (2,8) Rubbish
    READ (2,*) Enoop,f1oop,f2oop
    READ (2,*) Enop,f1op,f2op	! Enop, Enp in eV
    READ (2,*) Enp,f1p,f2p
!t        IF (energynew.GE..01.AND.energynew.LT.30.0) THEN
1360 IF (Enp.LT.En1) THEN
      Enoop=Enop
      f1oop=f1op
      f2oop=f2op
      Enop=Enp
      f1op=f1p
      f2op=f2p
      READ (2,*) Enp,f1p,f2p
      GOTO 1360
    ELSE
      iflagm=0
      iflagp=0
      iflag0=0
      DO jedge=1,nedge(iatom)	! check out edges
        IF (abs_edge(jedge).GT.Enoop/1000..AND.abs_edge(jedge).LT.Enop/1000.) THEN
          IF (Enop.LT.En1) THEN
            iflag0=iflag0+1
          ELSEIF (abs_edge(jedge).LT.En1/1000.) THEN
            iflagm=iflagm-1
          ELSE
            iflagp=iflagp-1
          ENDIF
        ELSEIF (abs_edge(jedge).GT.Enop/1000..AND.abs_edge(jedge).LT.Enp/1000.) THEN
          IF (Enop.GT.En1) THEN
            iflag0=iflag0+1
          ELSEIF (abs_edge(jedge).LT.En1/1000.) THEN
            iflagm=iflagm-1
          ELSE
            iflagp=iflagp-1
          ENDIF
        ENDIF
      ENDDO
      IF (Enop.GT.En1) THEN
        f01p=f1oop+(En1-Enoop)/(Enop-Enoop)*(f1op-f1oop)
      ELSE
        f01p=f1op+(En1-Enop)/(Enp-Enop)*(f1p-f1op)
      ENDIF
      IF (((iflagm+iflagp.EQ.0.OR.iflagm*iflagp.GT.0) &
          .AND.Enop.GT.En1)		 &! 1st 2 pnts
          .OR.(iflag0.EQ.0.AND.Enop.LE.En1.AND.iflagm.EQ.0 &
          .AND.iflagp.LT.0)) THEN		! later pnts
        POWER=(DLOG(f2op)-DLOG(f2oop))/(DLOG(Enop)-DLOG(Enoop))
        f02p=f2oop*(En1/Enoop)**POWER
      ELSEIF (iflagm.EQ.0.AND.Enop.GT.En1) THEN	! 1st 2 pnts
        f02p=f2oop*(En1/Enoop)**-3.D0		! best est.?
      ELSEIF ((iflagp.EQ.0.AND.Enop.GT.En1.AND.iflag0.GT.0).OR. &
          (iflag0.GT.0.AND.Enop.LE.En1.AND.iflagm.EQ.0 &
          .AND.iflagp.LT.0)) THEN			! 2 odd states
        f02p=f2op*(En1/Enop)**-3.D0			! best est.?
      ELSEIF (iflagm.LT.0.AND.Enop.LE.En1.AND.iflagp.EQ.0) THEN
        Enoop=Enop			! step forward
        f1oop=f1op			! later pnts
        f2oop=f2op
        Enop=Enp
        f1op=f1p
        f2op=f2p
        READ (2,*,ERR=1371) Enp,f1p,f2p
        iflag0=0
        DO jedge=1,nedge(iatom)	! check out edges
          IF (abs_edge(jedge).GT.Enop/1000..AND.abs_edge(jedge).LT.Enp/1000.) THEN
            iflag0=iflag0+1
          ENDIF
        ENDDO
        IF (iflag0.GT.0) THEN
          f02p=f2op*(En1/Enop)**-3.D0	!best est.?
        ELSE
          POWER=(DLOG(f2p)-DLOG(f2op))/(DLOG(Enp)-DLOG(Enop))
          f02p=f2op*(En1/Enop)**POWER
        ENDIF
      ELSE		! normal and default situation
        POWER=(DLOG(f2p)-DLOG(f2op))/(DLOG(Enp)-DLOG(Enop))
        f02p=f2op*(En1/Enop)**POWER
      ENDIF
      GOTO 1381
1371  f02p=f2op*(En1/Enop)**-3.D0		! best est.?
!			define muhpc
1381  MuHPC=(Na11*1.D-35)*f02p/En1/e_per_b/amu(iatom)
    ENDIF
!t        ENDIF
    CLOSE(2,STATUS='KEEP')
    f01(iatom)=f01p			! overwrite/replace CTC/H(2)
    f02(iatom)=f02p
    Mui(iatom)=MuHPC+SIG(1,iatom)
    IF (iPhoto.NE.1) Cifeff='PC'
  ENDIF
!test	    IF (En1.LT.30.) THEN	! shouldn't use this...
!t	     WRITE(*,*) 'f01 not given below 30eV'
!t	    ENDIF
  IF (Iffsource.GT.2.OR.energynew.GT.Elim2.OR.energynew.LT.0.01 &
      .OR.((Iffsource.EQ.2.OR.(Iffsource.LT.2.AND.(CFIL.EQ.'D0' &
      .OR.CFIL.EQ.'D7'))).AND.energynew.LE..03).OR. &
      (Iffsource.LT.2.AND.CFIL.NE.'D0' &
      .AND.CFIL.NE.'D7'.AND.energynew.GT.Elim1)) THEN	! ???
    call cromer(jZed,En1,fp(iatom),fpp(iatom),relcor,iPhoto)
    MuCL=(Na11*1.0E-35)*fpp(iatom)/En1/e_per_b/amu(iatom)
    IF ((Iffsource.EQ.2.OR.(Iffsource.LT.2.AND.(CFIL.EQ.'D0'.OR. &
        CFIL.EQ.'D7'))).AND.energynew.LE..03.AND.energynew.GT..01) THEN	! ???
      f01(iatom)=fp(iatom)+Z		! overwrite/replace CTC/H(2)
    ELSE
      f01(iatom)=fp(iatom)+Z		! overwrite/replace CTC/H(2)
      f02(iatom)=fpp(iatom)
      Mui(iatom)=MuCL+SIG(1,iatom)
      IF (iPhoto.NE.1) Cifeff='CL'
    ENDIF
  ENDIF
!
!	Angle-dependent form factor f0 (replacing Z in f1):
!
  IF (iPhoto.NE.1) THEN
    CALL FORMF0
!       WRITE(*,*) iphoto,ifeff,iMac,Photo
    IF (iPhoto.NE.1.AND.Ifeff.NE.2) THEN
      WRITE(*,1391) Cifeff,f01(iatom),f02(iatom),fh1(iatom)
    ENDIF
1391 FORMAT(X,A2,': f01,f02,fh1= ',3(1PE13.6))
!Mactest		WRITE(*,*) 'RayCS5',Mui(iatom),SIG(1,iatom),SIG(2,iatom)
!	1  ,cm2g_per_ba,(Na11*1.D-35)/En1/e_per_b/amu(iatom)
    fh1(iatom)=fh1(iatom)+frel	! rel.+f0 included
    f01(iatom)=f01(iatom)+frel	! rel. included
  ENDIF
  RETURN
END
!--------------------------------------------------------------------------
!	Angle-dependent form factor f0 (replacing Z in f1):
!
SUBROUTINE FORMF0
  IMPLICIT NONE
!91			Form factor variables
  integer ielem
  parameter (ielem=20)
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!		storage for alternate f01,f02 (B/C/C(2))
  DOUBLE PRECISION energynew
  DOUBLE PRECISION fp(ielem),fpp(ielem)
  COMMON/newcom/energynew,fp,fpp
  real coef(19)
  COMMON /SFDAT/ coef
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!MAC95
  CHARACTER dout*11,dcom*11,ddat*7,dhen*16,dhm*8
  COMMON/Macfiles/ dout,dcom,ddat,dhen,dhm
!MAC95
  integer jZed,item,lun,j5
!
  jZed=kZed(iatom)
  Z=DFLOAT(jZed)
  IF (jZed.EQ.1) THEN      ! H HF free atom
    A1(1)=0.489918
    B1(1)=20.6593
    A1(2)=0.262003
    B1(2)=7.74039
    A1(3)=0.196767
    B1(3)=49.5519
    A1(4)=0.049879
    B1(4)=2.20159
    C1=0.001305
  ELSEIF (jZed.EQ.6) THEN      ! C sp3 hybridised HF
    A1(1)=2.26069
    B1(1)=22.69069
    A1(2)=1.56165
    B1(2)=0.656665
    A1(3)=1.05075
    B1(3)=9.75618
    A1(4)=0.839259
    B1(4)=55.5949
    C1=0.286977
  ELSEIF (jZed.EQ.7) THEN      ! N RHF
    A1(1)=12.2126
    B1(1)=0.0057
    A1(2)=3.13220
    B1(2)=9.89330
    A1(3)=2.01250
    B1(3)=28.9975
    A1(4)=1.16630
    B1(4)=0.582600
    C1=-11.529
  ELSEIF (jZed.EQ.8) THEN      ! O RHF
    A1(1)=3.04850
    B1(1)=13.2771
    A1(2)=2.28680
    B1(2)=5.70110
    A1(3)=1.54630
    B1(3)=0.323900
    A1(4)=0.867000
    B1(4)=32.9089
    C1=0.250800
  ELSEIF (jZed.EQ.13) THEN      ! Al RHF
    A1(1)=6.42020
    B1(1)=3.03870
    A1(2)=1.90020
    B1(2)=0.742600
    A1(3)=1.59360
    B1(3)=31.5472
    A1(4)=1.96460
    B1(4)=85.0886
    C1=1.11510
  ELSEIF (jZed.EQ.14) THEN      ! Si sp3 hybridised HF
    A1(1)=5.66269
    B1(1)=2.66520
    A1(2)=3.07164
    B1(2)=38.6634
    A1(3)=2.62446
    B1(3)=0.916946
    A1(4)=1.39320
    B1(4)=93.5458
    C1=1.24707
  ELSEIF (jZed.EQ.15) THEN      ! P RHF
    A1(1)=6.43450
    B1(1)=1.90670
    A1(2)=4.17910
    B1(2)=27.1570
    A1(3)=1.78000
    B1(3)=0.526000
    A1(4)=1.49080
    B1(4)=68.1645
    C1=1.11490
  ELSEIF (jZed.EQ.19) THEN      ! K RHF
    A1(1)=8.21860
    B1(1)=12.7949
    A1(2)=7.43980
    B1(2)=0.77480
    A1(3)=1.05190
    B1(3)=213.187
    A1(4)=0.86590
    B1(4)=41.6841
    C1=1.42280
  ELSE
    !  This section calculates f as f(sin(th)/lamda) given Z.
    !  it uses the parametrized fits of Cromer and Mann, Acta Cryst. A24
    !  321 (1968).  It also calculates the compton component
    !  using the fits of Balyuzi, Acta. Cryst. A31 600 (1975).
    !  nb k=4PI.SIN(THETA)/LAMBDA; q=sinTh/l=1/(2d). Valid for q<1.5 only
    lun=2
    IF (IMac.EQ.0) THEN		! local Vax source
      open (unit=lun,file='abs$sfcoef.dat',status='old',access='direct',recl=20)
    ELSEIF (IMac.EQ.1) THEN		! local Mac source
      open (unit=lun,file='abs$sfcoef.dat',status='old',access='direct',recl=80)
!
!U96    for unix source IMac =-1
!
    ELSEIF (IMac.EQ.-1) THEN		! local UNIX source
      open (unit=lun,file='abssfcoef.dat',  status='old',access='direct',recl=76)        
    ELSEIF (IMac.EQ.2) THEN	! GNU compiler source
      open (unit=lun,file='abssfcoef.dat',  status='old',access='direct',recl=304)  
    ELSE				! global Vax source
      open (unit=lun,file='abs$sfcoef_data',status='old',access='direct',recl=20)
    ENDIF
    read(lun,REC=jZed) (coef(item),item=1,19)
    close(lun)
    DO J5=1,4
      A1(J5)=DBLE(coef(2*J5-1))
      B1(J5)=DBLE(coef(2*J5))
    ENDDO
    C1=DBLE(coef(9))	! other coef's give compt S(q,Z) as follows:
  ENDIF
!91	The following is NOT a compton cross-section:
!t	rather, sigma(inc)=Int[dsiginc/dOmega]dOmega,
!t	ds/dO=[ds/dO]_{Klein-Nishina}S(q,Z),
!t	[ds/dO]_{K-N}=re0^2(Z/2){1+a(1-cosTh)}^-2
!t	x{1+cosTh^2+a^2(1-cosTh)^2[1+a(1-cosTh)]^-1}
!t	=free-electron Compton.
!t		Only S(q,Z)=Z-Sum(f_0^i(q))^2 is given below:
!t	i.e. this would be useful for angular dependences,
!t	but probably not for angular inetgrals to give sigma(inc.)
!test	  compt=0.	! now calculate S(q,Z)
!t        ksp = tpi/dsp	! 2\pi/d=4\pi/(2d)=4\pi\sin\theta/\lambda
!t        ksqr=-(ksp/fpi)**2
!t	  DO item=10,19,2
!t	   compt=compt+coef(item)*exp(ksqr*coef(item+1))
!t	  ENDDO
!t	  compt=Z-compt
!t      ENDIF
  fh1(iatom)=C1+f01(iatom)-Z
!91	dlambdanew not passed; sint/l=2d/n
  DO J5=1,4            ! this is NOT the temperature factor!!!
    fh1(iatom)=fh1(iatom)+A1(J5)*DEXP(-B1(J5)*ksp*ksp)
  ENDDO
  RETURN
END
!--------------------------------------------------------------------------
!92	Routine for estimating F0 structure factors for RI corrections.
!
SUBROUTINE F0CALCN
  IMPLICIT NONE
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER ielem
  PARAMETER (ielem=20)
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!		local parameter:
  INTEGER iatom
!
  DO iatom=1,3
    F0(iatom)=0.0D0
  ENDDO
  DO iatom=1,natomtypes
    F0(1)=F0(1)+Dfloat(kZed(iatom))*kpop(iatom)
    F0(2)=F0(2)+Zeff(iatom)*kpop(iatom)
    F0(3)=F0(3)+F0n(iatom)*kpop(iatom)
  ENDDO
!
  RETURN
END
!--------------------------------------------------------------------------
!92	Routine for estimating FH structure factors for RI corrections.
!
SUBROUTINE FHCALCN(HL,ORDER)
  IMPLICIT NONE
!		passed variable
  INTEGER HL(4)
  DOUBLE PRECISION ORDER
!
  INTEGER iatoms,isites
  PARAMETER (iatoms=40,isites=3)
  INTEGER IDIG,nalphs,nelas,nbasis,ksites,natoms(iatoms) &
      ,nsites(iatoms),iZed(iatoms,isites),ntherm(iatoms,isites) &
      ,atomtype(iatoms,isites)
  DOUBLE PRECISION a01,b01,c01,calpha,cbeta,cgamma,Tref,aalph(6) &
      ,elast(6),fpop(iatoms,isites),btherm(iatoms,isites,6),xco(100,3)
  CHARACTER PLABEL(15)*12
  COMMON/XLATTICE/PLABEL,IDIG,nalphs,nelas,nbasis,ksites,natoms &
      ,nsites,iZed,ntherm,atomtype &
      ,a01,b01,c01,calpha,cbeta,cgamma,Tref &
      ,aalph,elast,fpop,btherm,xco
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER ielem
  PARAMETER (ielem=20)
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!92		Separate THREEBM/FHCALCN parameters:
  INTEGER IM(4)
  DOUBLE PRECISION a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,d2,xTemp
  DOUBLE PRECISION Numcells
  COMPLEX*16 FHr, FHi, FHn(ielem)
  COMMON/com2d/ IM,a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,Numcells,d2,xTemp,FHr,FHi,FHn
!91			Form factor variables
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!		local variables
  INTEGER MH,MK,ML,ibasis,isite
  DOUBLE PRECISION fh1bT,f02bT,THERM
!
  MH=HL(1)
  MK=HL(2)
  ML=HL(idig)
!
  FHr=DCMPLX(0.,0.)
  FHi=DCMPLX(0.,0.)
!	  effect on B(T) over-estimated by linear extrapolation
!93:
  ksites=0
  DO ibasis=1,nbasis
    fh1bT=0.0
    f02bT=0.0
    DO iatom=1,natoms(ibasis)
      IF (ntherm(ibasis,iatom).EQ.1) THEN	! overall B value input
        THERM=DEXP(-btherm(ibasis,iatom,1)/d2/d2*ORDER*ORDER*xTemp/Tref)
      ELSEIF (ntherm(ibasis,iatom).EQ.3) THEN	!HH,KK,LL isotropic betaij
        THERM=DEXP(-(MH*MH*btherm(ibasis,iatom,1)+MK*MK* &
            btherm(ibasis,iatom,2)+ML*ML*btherm(ibasis,iatom,3) &
            )*ORDER*ORDER*xTemp/Tref)
      ELSEIF (ntherm(ibasis,iatom).EQ.4) THEN	! 4=HL,5=KL,6=HK
        THERM=DEXP(-(MH*MH*btherm(ibasis,iatom,1)+MK*MK* &
            btherm(ibasis,iatom,2)+ML*ML*btherm(ibasis,iatom,3)+MH*ML* &
            btherm(ibasis,iatom,4) &
            )*ORDER*ORDER*xTemp/Tref)
      ELSEIF (ntherm(ibasis,iatom).EQ.5) THEN	! 4=HL,5=KL,6=HK
        THERM=DEXP(-(MH*MH*btherm(ibasis,iatom,1)+MK*MK* &
            btherm(ibasis,iatom,2)+ML*ML*btherm(ibasis,iatom,3)+MH*ML* &
            btherm(ibasis,iatom,4)+MK*ML*btherm(ibasis,iatom,5) &
            )*ORDER*ORDER*xTemp/Tref)
      ELSEIF (ntherm(ibasis,iatom).EQ.6) THEN	! 4=HL,5=KL,6=HK
        THERM=DEXP(-(MH*MH*btherm(ibasis,iatom,1)+MK*MK* &
            btherm(ibasis,iatom,2)+ML*ML*btherm(ibasis,iatom,3)+MH*ML* &
            btherm(ibasis,iatom,4)+MK*ML*btherm(ibasis,iatom,5) &
            +MH*MK*btherm(ibasis,iatom,6) &
            )*ORDER*ORDER*xTemp/Tref)
      ELSE				! error default
        THERM=1.0
      ENDIF
      fh1bT=fh1bT+fh1(atomtype(ibasis,iatom))*fpop(ibasis,iatom)*THERM
      f02bT=f02bT+f02(atomtype(ibasis,iatom))*fpop(ibasis,iatom)*THERM
    ENDDO
    DO isite=1,nsites(ibasis)
      ksites=ksites+1
      FHr=FHr+DCMPLX(fh1bT,0.D0)*CDEXP(DCMPLX(0.D0,2.D0*DPI &
          *(xco(ksites,1)*MH+xco(ksites,2)*MK+xco(ksites,3)*ML)*ORDER))
      FHi=FHi+DCMPLX(f02bT,0.D0)*CDEXP(DCMPLX(0.D0,2.D0*DPI &
          *(xco(ksites,1)*MH+xco(ksites,2)*MK+xco(ksites,3)*ML)*ORDER))
    ENDDO
  ENDDO
!mactest	WRITE(*,*) fh1bT,f02bT,FHr,FHi,IM,HL,isite,nbasis
!
  RETURN
END
!---------------------------------------------------------------------
