!---------------------------------------------------------------------------
!				BRAGGFFM
!     Calculation of ffp, ffm crystallite profiles prior to curvature loop
!     Currently allows dalpha.ne.0. Angle to plane=inc+aplane.
!     Note sin(inc.diff)->sin(out.diff)=2sinth-sin(inc.diff.) for Bloch wave
!     generally... but coupled at surface to sin(out.diff)=-sin(inc.diff).
!---------------------------------------------------------------------------
!     2 June  1992 CTC:
!	Separated from Moscurve3.
!     9 Sept. 1992 CTC:
!	File also includes AJV approximation CS5 subroutines:
!	  XCHORD, EMITANG, GENGEOM;
!	and CTC generalised CS5 subroutines:
!	  GENGEOMC, GENGEOMS, GENTHSG, GENTHD;
!	together with
!	  OUTFILS: output file from Moscurve3, called in CS5;
!	and 
!	  GEN2D, fn NEW2D for lattice spacing evaluation/replacement
!     2 Feb.  1993 CTC:
!	  GENTHSF,GENTHDF (diff->surf), (surf->diff);
!	  GENTHE (surf -> diff -> diff out -> surf out);
!     25 Mar. 1993 CTC:
!	  GENXYS (Yiz ray tracing);
!	  GENTHDGEL, GENTHGDEL (Gx cpt <=> full / real angles via
!	   alpha(EL)=angle of elevation, tanalpha=(h-z)/BX);
!	  GENTHDGAZ, GENTHGDAZ (Gx cpt <=> full / real angles via
!	   alpha(AZ)=azimuthal angle at local crystal surface,
!	   tanalpha(AZ)=tanalpha(EL)/costheta_CPT).
!     20 May  1993 CTC:
!     	Scaling/multiplication of matrix for mosaic crystal maxt3 vs
!	maxt2/t0; outfil output of three 'flat' crystal profiles;
!	corrections (redefinitions) of percentiles, inc. 0.1% range.
!     30 June 1993 CTC:
!	Allowance for minimum (and grazing angle) profiles;
!	inclusion of Fresnel terms.
!     16 Aug. 1993 CTC:
!	Preparation for Laue code, following Zach.1945.
!U96  Modifications by David Paterson Dec95-Jan96 to run on unix
!UJun96	Rationalisation of ADP / PET tests & output: CTC Jun96
!plate96 Modifications to include plate function  David Paterson July96-?
!plate96out Modifications to include  
!out97 mods to  output including flags and full output files 
!	See diagram in DJP thesis for explanation of geometry and variable names
!--------------------------------------------------------------------------- 
SUBROUTINE BRAGGFFM(K,sinaplane,cosaplane,sinalpha,cosalpha &
     ,aplane,lambda,ORDER,Bragg)
  IMPLICIT NONE
!		      Passed vars:
  DOUBLE PRECISION lambda,K,sinaplane,cosaplane,sinalpha,cosalpha &
      ,aplane,ORDER
  INTEGER Bragg
!		      Common (I/O) vars (CS5-Rcurve)
  INTEGER ISTEPSO,ISTEPSP
  PARAMETER (ISTEPSO=8000,ISTEPSP=8001)
  DOUBLE PRECISION RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr
  DOUBLE PRECISION MPSIr2,MPSIi2,p,s,K1,Temth0,Thout0, &
      muabs,mcurv,mReftem1,Maxt2,umbo2
  DOUBLE PRECISION Irel1(ISTEPSP),Irel2(ISTEPSP),Irel3(ISTEPSP), &
      Reflint(6),Reflintth,ReflintHy,Mshift1,Mshift2,Mshift3(2,2), &
      Mshift4(3),Ermshift4,MShiftB(6),Irel5(ISTEPSP),Irel6(ISTEPSP)
  DOUBLE PRECISION MaxI1,MaxI2,MaxI3,MaxI4,Thpk, &
      Thpko,Ypko,Th1,Thout,Yshift, &
      STEPS1,STEPS2,STEPS3,STEPS4,basym,IRELM
!
  COMMON/CS5C/RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr,MPSIr2,MPSIi2, &
      p,s,K1,Temth0,Thout0,muabs,mcurv,mReftem1,Maxt2,umbo2, &
      Irel1,Irel2,Irel3,Reflint,Reflintth,ReflintHy,Mshift1, &
      Mshift2,Mshift3,Mshift4,Ermshift4,MShiftB,Irel5,Irel6,MaxI1, &
      MaxI2,MaxI3,MaxI4,Thpk,Thpko, &
      Ypko,Th1,Thout,Yshift,STEPS1,STEPS2,STEPS3,STEPS4,basym &
      ,IRELM
!plate96 Declaration of extra variables for plate function
!out97      
  INTEGER Outfilesflag, Maxlines ! flag to stop output files
  COMMON/OUTBRAGG/Outfilesflag, Maxlines
!plate96 Outfilesflag=0 full output, =1 no RP*TH0 files,=2 no RP*TH1 files	  
!plate96 =3 no RP*THO or RP*TH1 files outputed =4 no RP* files
!plate96 GE 1 then no FF* files
  DOUBLE PRECISION Detx,Detarmlen,Detphi,Detalpha
  COMMON/PLATE/Detx,Detarmlen,Detphi,Detalpha
!
  DOUBLE PRECISION c251,c252,c253,c751,c752,c753,mt0
  DOUBLE PRECISION mq2,PkTh1,Reflinto,thmaxf,thminf,Mosdel, &
      c1ff(6),c2ff(6),ffpk(2),Maxff,maxt0,maxt3,sigscat,siginc &
      ,Reflintm,Reflinty,ReflintthinC
  DOUBLE PRECISION transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm(2,8,2)
  INTEGER K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2
  CHARACTER numstr*4
  COMMON/CS5D/c251,c252,c253,c751,c752,c753,mt0,mq2,PkTh1, &
      Reflinto,thmaxf,thminf,Mosdel,c1ff,c2ff, &
      ffpk,Maxff,maxt0,maxt3,sigscat,siginc,Reflintm,Reflinty, &
      Reflintthinc,transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm,K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2,numstr
!
  INTEGER ffs
  PARAMETER (ffs=30100)
  COMPLEX*16 DPSI0, DPSIHr, DPSIHi
  DOUBLE PRECISION Thm2,Thm3,Temthm2,Temthm3,Yrel(ISTEPSP,6), &
      Thtem(ffs),Rtem(ffs),Ttem(ffs),Ytem(ffs),dely0,dely0t,mufilm, &
      TEMUL,Mphotoshift,mdepth(6),mthld(6),emthld(2) &
      ,mcontl,meanff(7,2),maxdp,maxdm,thff,Chinit,Chfin
  DOUBLE PRECISION Rzf,Cx
!93atest:     add mYo for output asymmetry evaluation:
  DOUBLE PRECISION fscale,RtemC(ffs),TtemC(ffs),Tabdy(ffs,4),mYo(6)
  DOUBLE PRECISION BXm,BXx
  INTEGER fof,detmatch,ip
  COMMON/CS5E/ DPSI0,DPSIHr,DPSIHi,Thm2,Thm3,Temthm2,Temthm3,Yrel, &
      Thtem,Rtem,Ttem,Ytem,dely0,dely0t,mufilm,TEMUL,Mphotoshift, &
      mdepth,mthld,emthld,mcontl,meanff,maxdp,maxdm,thff &
      ,Chinit,Chfin,Rzf,Cx,fscale,RtemC,TtemC &
      ,Tabdy,mYo,BXm,BXx,fof,detmatch,ip
!93atest-
  INTEGER IREAD,Photo,Jbit4,Fwrite(0:20)
  COMMON/CS5F/ IREAD,Photo,Jbit4,Fwrite
!91			constants
!plate96
  DOUBLE PRECISION thetaap2
  
!out97
  DOUBLE PRECISION  Irel8(ISTEPSP),  &! Rel intensity on Plate detector
      Detminx(2),Detmaxx(2), &! max and min range onto detector
      K8maxt,Detxpko    
  INTEGER K8max,K8min,STEPS8
  COMMON /CS5Plate/ &
      Irel8,Detminx,Detmaxx,K8maxt,Detxpko,  &! Irel8==IrelPlate
      K8max,K8min,STEPS8
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
  INTEGER Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
  COMMON /COMINTS/ Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
!
!		  Diffn vars from COMFFM/Braggffm:
!
  DOUBLE PRECISION bigD,bigQ,U,V,sa,sv,sw,Maxt,Maxt1,mz2
  COMPLEX*16 dq,dz,dqplusz2,drtqp2,cc2p1
  COMPLEX*16 ctem,ctem2,cx1,cx2,cc1,cc2,cc1p,cc2p,ctemr,ctemt
  DOUBLE PRECISION rc,tc,ddel,logttime
!		      Mosaic vars
  DOUBLE PRECISION Ascale,Rfact(0:ffs),temsum
  INTEGER Idel,Imax,Ist,Jst,Jast
!		      Other FFM variables:
  INTEGER EXTRASTEPS,tflag,ittime,Iolddel,Mosflag
  DOUBLE PRECISION JU,JL,JU2,JL2,JU3,JL3,JU4,JL4,norm
  DOUBLE PRECISION Temt1,tmin,Delthm,thtime &
      ,sintime,costime,costh,Tem5,Tem4,t0,GB1,sinth,dely &
      ,ytime,rtime,ttime,yffpk,Tlim,Delthf,scTemth,dsinthdy,TemU
  COMMON /COMFFM/ bigD,bigQ,U,V,sa,sv,sw,Maxt,Maxt1,mz2 &
      ,dq,dz,dqplusz2,drtqp2,ctem,ctem2,cx1,cx2,cc1,cc2,cc1p,cc2p &
      ,cc2p1,ctemr,ctemt,rc,tc,ddel,logttime,Ascale,Rfact,temsum &
      ,Idel,Imax,Ist,Jst,Jast,EXTRASTEPS,tflag &
!U96: norm
      ,ittime,JU,JL,JU2,JL2,JU3,JL3,JU4,JL4,norm,Iolddel &
      ,Mosflag,Temt1,tmin,Delthm,thtime,sintime,costime &
      ,costh,Tem5,Tem4,t0,GB1,sinth,dely,ytime,rtime,ttime &
      ,yffpk,Tlim,Delthf,scTemth,dsinthdy,TemU
!93		,sin2T0,sin2apl,cos2apl cancelled
!		local parameters:
  CHARACTER*20 FILEIN2
  INTEGER I,J,Iexc,Ilim,uflag,id,mcyc,Jbit,Jbit1,Iexcr,totf
  DOUBLE PRECISION meanffo,dsinth,eRthld,tsum2(ffs)
  DOUBLE PRECISION tolddth,tolir,tolminang,thtm2,Onotemt1 &
      ,tfact,tsmall,tdely,Onotemt1t,temt1t,tem,sinthmaxf,sinthminf &
      ,sintho,sinthdf,thdiff,costhdf,temtho,basym0,nflag &
      ,npower,ipower,KSTEP,DSTEPS,JL5,JU5 &
      ,ThtemC(ffs),YtemC(ffs),Kdiff,Tem5f
  COMPLEX*16 cpolf,ctemrf(2),ctemtf(2),sinthp
  INTEGER IDSTEPS,JLP,KLP
!91			Form factor variables
  INTEGER ielem
  PARAMETER (ielem=20)
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!MAC95
  CHARACTER dout*11,dcom*11,ddat*7,dhen*16,dhm*8
  COMMON/Macfiles/ dout,dcom,ddat,dhen,dhm
!93atest:
  DOUBLE PRECISION temmax,Rtem21
!93atest:
  DOUBLE PRECISION Thtem2(ffs),Rtem2(ffs),Ttem2(ffs)
  COMMON/FFREFL/Thtem2,Rtem2,Ttem2
  DOUBLE PRECISION Tabdy2(ffs,4)
  COMMON/FFTable/Tabdy2
!UJun96			Supplementary ranges:
  DOUBLE PRECISION Ytem2(ffs)	 &!=Thin
      ,t0pk,t0c					 &!non-overrun lamellar/mosaic thicknesses
      ,JUM,JLM,JLM2,JUM2,JLM4,JUM4,JL1,JU1	 &! mosdel convolved widths
      ,pcontl									 &! last trunc layer Refl*IREL
      ,xmin1,xmax1,xmin,xmax					 &! xrange: initial & final
      ,Thm2L(2),Thm3L(2)						 &! th1 ranges (VL)
      ,MaxI1r,MaxI3r,mcontr,pcontr			! reflectivity maxima
  INTEGER Jmaxff,Jmaxff2,xtot,ptot,pdivs
  COMMON/FFmarkers/Ytem2,t0pk,t0c &
      ,JUM,JLM,JLM2,JUM2,JLM4,JUM4,JL1,JU1 &
      ,pcontl,xmin1,xmax1,xmin,xmax,Thm2L,Thm3L,MaxI1r,MaxI3r,mcontr,pcontr &
      ,Jmaxff,Jmaxff2,xtot,ptot,pdivs
!93atest-
!MacTest
!		Time vars
!      DOUBLE PRECISION Maxtim,DTIME(6),Mtime,Ntime
!      REAL*4 Time0,Time1,Time2,Tim2f,Tim21,Tim22
!      COMMON/clockt/ Maxtim,DTIME,Time0,Time1,Time2,Mtime,Ntime,Tim2f
!     1,Tim21,Tim22
!		WRITE(*,*) 'Time/BFM',Tim2f,Time0,Time1
!MAC95
!		Maxsteps=18000 now, not 9000
!		Minimum angle attempted (note critical angle limit):
!out97      Outfilesflag=3
  IF (ip.EQ.1) THEN
    cpolf=DCMPLX(1.D0,0.D0)+DPSI0
  ELSE		! ip=2, pi
    cpolf=DCMPLX(1.D0,0.D0)
  ENDIF
  tolminang=2.D-3
  EXTRASTEPS=20
  norm=0
  mcyc=0
  dely0=2.D0
  Mosflag=0
  STEPSF=2000            !!! 1000
  Reflinto=0.D0
!NOV92:		Note initial estimates (assume dalpha=0)
!      thmaxf=DMIN1(temth0+(umbo2*RPSI0/basym/sin2T0)
!     1  +5.D1*DABS(Temt1),DPIo2)-aplane
!      thminf=DMAX1(thmaxf-1.D2*DABS(Temt1),tolminang-aplane)
!93test
  basym0=basym
  IF (Igraz.LE.0) THEN	! normal Bragg peak
!B       tem=DMIN1(Temth0+(umbo2*RPSI0/basym/2.D0/sinth/costh)
!B     1  +5.D1*DABS(Temt1),DPIo2)
    tem=Temth0+(umbo2*RPSI0/basym/2.D0/sinth/costh) &
!B     1  -5.D1*Temt1			! diffracting angle
!L
        -3.D1*Temt1			! diffracting angle
!L
    CALL GENTHSF(DSIN(tem),DCOS(tem),sinaplane,cosaplane,sinalpha &
        ,cosalpha,sinthmaxf)
    thmaxf=DASIN(sinthmaxf)		! assume 0<thinc<dpio2
    tem=Temth0+(umbo2*RPSI0/basym/2.D0/sinth/costh) &
!B     1  +5.D1*Temt1			! diffracting angle
!L
        +3.D1*Temt1			! diffracting angle
!L
    CALL GENTHSF(DSIN(tem),DCOS(tem),sinaplane,cosaplane,sinalpha &
        ,cosalpha,sinthminf)
    thminf=DASIN(sinthminf)
    IF (thmaxf.LT.tolminang) thmaxf=tolminang
    IF (thminf.LT.tolminang) thminf=tolminang
    IF (thmaxf.GT.DPI) thmaxf=DPI
    IF (thminf.GT.DPI) thminf=DPI
    IF (thmaxf.LT.thminf) THEN
      tem=thmaxf
      thmaxf=thminf
      thminf=tem
    ENDIF
  ELSE			! Igraz=1; grazing inc. region
    thminf=tolminang
    thmaxf=tolminang+1.D-2	! start at .6 degree width.
  ENDIF
!      IF (Temth0.EQ.DPIo2) thminf=DPIo2-aplane-tolminang
!
  tflag=0
  IF (AGE.GT.1) THEN	! lower precision for thin crystals
    tolddth=1.D-4
    tolir=1.D-3
  ELSE			! tolerances for convergence
    tolddth=0.5D-4
    tolir=0.5D-3
  ENDIF
150 meanffo=meanff(7,ip)
  Tmin=1.6      ! minimum ttime
  IF (STEPSF.GT.fof-200) THEN
!test       WRITE(*,*) 'Thmax,min,STEPS=',SNGL(thmaxf),SNGL(thminf)
    WRITE(*,160) STEPSF,meanffo-Temth0,Reflint(1)
160 FORMAT(X,' Poor convergence, FFRC: STEPS?,delTh,IR=',I10 &
        ,2(1PE10.3))
    STEPSF=fof-200
!test       GOTO 525
  ENDIF
  DO id=1,6      ! integrated rtime = mean rtime*delthf
    Reflint(id)=0.D0
    meanff(id,ip)=0.D0
  ENDDO
  meanff(7,ip)=0.D0
  Maxff=-1.D0
  ffpk(ip)=-1.D0
  Iexc=0
  Iexcr=0
  Ilim=0
!93atest: show convergence:
  IF (mcyc.GT.1) THEN
    DO I=1,STEPSF
      IF (DFLOAT(I).GT.JL2.AND.DFLOAT(I).LT.JU2) THEN
        Reflint(2)=Reflint(2)+Rtem(I)
        Meanff(2,ip)=Meanff(2,ip)+Rtem(I)*Thtem(I)
      ENDIF
    ENDDO
    Meanff(2,ip)=Meanff(2,ip)/Reflint(2)
  ENDIF
  DO I=1,STEPSF+EXTRASTEPS
    IF (I.GT.STEPSF) THEN
      J=fof+I-STEPSF
    ELSE
      J=I
    ENDIF
    Rtem(J)=0.D0
    Ttem(J)=0.D0
    Thtem(J)=0.D0
    Ytem(J)=0.D0
  ENDDO
!93atest-
!		note the error of C's method wrt t0 (dely0.NE.2)
  Delthm=1.6D1*(thmaxf-thminf)
  nflag=0
  DO I=1,STEPSF+EXTRASTEPS
    IF (I.LE.STEPSF) THEN
      thtm2=thminf+(thmaxf-thminf)*DFLOAT(I-1)/DFLOAT(STEPSF-1)
    ELSEIF (I.LE.STEPSF+EXTRASTEPS/2) THEN      ! large th. limit
      thtm2=thmaxf+(thmaxf-thminf)*2.D0**(DFLOAT(I-STEPSF-2)/2.D0)
    ELSE                        ! small th. limit
      thtm2=thminf-(thmaxf-thminf)*2.D0**(DFLOAT(I-STEPSF-2- &
          EXTRASTEPS/2)/2.D0)
    ENDIF
!92			allow tails beyond pi/2? (to zeroth order):
    IF (thtm2.GT.DPIo2) THEN
      thtime=DPI-thtm2
!?       ELSEIF (thtm2.EQ.DPIo2) THEN
!?        thtime=DPIo2-(thmaxf-thminf)/DFLOAT(STEPSF-1)
    ELSE
      thtime=thtm2
    ENDIF
    IF (thtime.LT.tolminang) thtime=tolminang
!
    sintime=DSIN(thtime)
    costime=DCOS(thtime)
!93test
    CALL GENTHE(sintime,costime,sinaplane,cosaplane &
        ,sinalpha,cosalpha,sinth,sinTho &
        ,sinthdf,thdiff,Temtho)	! off Gx to surface->diff.->off Gx,out
!B
    IF (Bragg.EQ.1) THEN
      basym=-sintime/sintho		! Bragg
    ELSE
      basym=sintime/sintho		! Laue
    ENDIF
!L
    umbo2=(1.D0-basym)/2.D0			!=1 in Symm.Bragg Refln
!93:	! Polarisation correction K/pi=1 but K/sigma.not.cos2thetaB:
    IF (ip.EQ.2) THEN
      Kdiff=K
      Tem5f=Tem5
    ELSE
      Kdiff=DABS(1.D0-2.D0*sinthdf*sinth) &
          /DSQRT(1.D0+4.D0*sinth*(sinth-sinthdf))
      Tem5f=Tem5*Kdiff/K
    ENDIF
    dsinthdy=-DSQRT(DABS(basym))/basym*Tem5f
    costhdf=DCOS(thdiff)		! thdiff simeq thtime+aplane
!92       basym=-1.D0/(cos2apl+sin2apl*costime/sintime)
!92       umbo2=(1.D0-basym)/2.D0      ! = 1 usually
!92       Tem4=DSQRT(DABS(basym)*MPSIr2)*K
    IF (Kdiff.LE.1.D-8) THEN	! truncate K/sigma at 45 degrees/forbidden
      Onotemt1=2.D0*sinth*costhdf*basym/DSQRT(DABS(basym)*MPSIr2)*1.D8
      Temt1=-dsinthdy/costhdf		!Tem4/sin2T0/basym,.simeq.0
    ELSEIF (Tem5f.GT.1.D-14) THEN		! 1/Temt1 normal
      Onotemt1=-costhdf/dsinthdy	! v sin2T0*basym/Tem4
      IF (DABS(Onotemt1/dely0).LT.1.D0) THEN ! temt1 enormous
        Temt1=1.D0/dely0
        t0=maxt3
        t0c=Maxt2
      ELSE
        Temt1=1.D0/Onotemt1      ! OK?
      ENDIF
    ELSE			! forbidden?
      Onotemt1=2.D0*sinth*costhdf*basym/DSQRT(DABS(basym))/Kdiff*1.D8
      Temt1=-dsinthdy/costhdf		!Tem4/sin2T0/basym,.simeq.0
    ENDIF
    IF ((Tem5f.LE.1.D-14).OR.(DABS(Onotemt1/dely0).GE.1.D0) &
        .OR.(Kdiff.LE.1.D-8)) THEN
!92	vs:	DMIN1(DMAX1(Tem4/basym/sin2T0,-1.D8),1.D8)
!93	vs:	DMIN1(DMAX1(-dsinthdy/costhdf,-1.D8),1.D8)
      IF (tflag.LE.1.AND.AGE.GT.1) THEN	! adjust t0
!L
        t0=(DABS(GB1)*costime		 &! assumes GB1=curvature of plane
            /DCOS(DABS(thtime)+DABS(dely0*Temt1))-GB1)
        IF (t0.LE.0.D0) THEN		! high th??
          t0=(DABS(GB1)*DCOS(DABS(thtime)-DABS(dely0*Temt1)) &
              /costime-GB1)
!L
        ENDIF
        t0c=t0
        IF (t0.LE.0.D0) THEN
          t0=maxt3
          t0c=Maxt2
        ENDIF
        tflag=1
!         IF (norm.LT.3) norm=1
!        ELSEIF (AGE.GT.1) THEN
!         t0=GB1*(DCOS(thdiff+dely0/2.D0*Temt1)
!     1    /DCOS(thdiff-dely0/2.D0*Temt1)-1.D0)
      ELSEIF (AGE.LE.1) THEN
        t0=maxt3
        t0c=Maxt2
      ENDIF
    ENDIF
    dely=dely0
    IF (t0.GE.maxt3) THEN
      t0=maxt3
      IF (AGE.GT.1.AND.GB1.GT.0.D0) THEN    	!thickness>mosaic/full crystal
!L
        dely=-(DACOS(costime/DABS(DABS(t0 &
            /GB1)+1.D0))-thtime)*Onotemt1
        IF (I.LE.STEPSF) nflag=1
!test         IF (I.LE.STEPSF) tflag=2
      ENDIF
    ENDIF
    Tabdy2(I,1)=dely
    IF (t0c.GE.Maxt2) THEN		! Cryst v t(C/Extn) v t3(inc.Mosaic)
      t0c=Maxt2
!L
      Tabdy2(I,2)=-(DACOS(costime/DABS(t0c &
          /DABS(GB1)+1.D0))-thtime)*Onotemt1
!L
    ELSE
      Tabdy2(I,2)=dely0
    ENDIF
    Tabdy2(I,3)=DABS(Tabdy2(I,2)*Temt1)
    Tabdy2(I,4)=Tabdy2(I,1)
!		      ! not ! t0=lambda/DPI/Tem4*sinThl*A02
!92:    sa=DPI*t0/sintime/lambda !approx: t0 from diff dy0 since sintime==inc
    sa=DPI*t0/sintime/lambda	! path through crystal (/ crystallite)
!L	! Note t0/sintime.sim.path Sk.sim.T(perp to diff)/sinthdf
!93     sa=DPI*t0/sinthdf/lambda ! cf. path through crystallite=diff.planes
!		      old values
!	 mz2=(umbo2*RPSI0+basym*(Temth0-thdiff)*sin2T0)**2
!     1+(umbo2*APSI0)**2
!	 dz=umbo2*DPSI0+DCMPLX(basym*(Temth0-thdiff)*sin2T0,0.0D0)
!		      COMPLEX METHOD???
    mz2=(umbo2*RPSI0+basym*(sinTh-sinthdf)*2.D0*sinth)**2 &
        +(umbo2*APSI0)**2
    dz=umbo2*DPSI0+DCMPLX(basym*(sinTh-sinthdf)*2.D0 &
        *sinTh,0.D0)
    ytime=-DREAL(dz)/(dsinthdy*2.D0*sinth*basym)	!Tem4
    dq=basym*Kdiff*Kdiff*(DREAL(DPSIHr)**2.D0+DIMAG(DPSIHr)**2.D0)* &
        DCMPLX(1.D0-K1*K1,2.D0*p)
    dqplusz2=dq+dz*dz
    drtqp2=CDSQRT(dqplusz2)
    ctem=-dz+drtqp2
    cx1=ctem/Kdiff/DCMPLX(DREAL(DPSIHr)-DIMAG(DPSIHi), &
        -DIMAG(DPSIHr)-DREAL(DPSIHi))
    ctem2=-dz-drtqp2
!test           IF (I.EQ.1.OR.I.GE.STEPSF) THEN
!t        WRITE(*,*) 'T',Temt1,t0,maxt3,sintime,lambda,sa,ctem,ctem2
!t              ENDIF
!t
    cx2=ctem2/Kdiff/DCMPLX(DREAL(DPSIHr)-DIMAG(DPSIHi), &
        -DIMAG(DPSIHr)-DREAL(DPSIHi))
!B
    IF (Bragg.EQ.1) THEN
!	divide cc1,cc2 by large number (cc1) to avoid G-floating o/flow
!       cc1=CDEXP(DCMPLX(sa*(DIMAG(DPSI0)+DIMAG(ctem)),-sa
!     1      *(DREAL(DPSI0)+DREAL(ctem))))
!       cc2=CDEXP(DCMPLX(sa*(DIMAG(DPSI0)+DIMAG(ctem2)),-sa
!     1      *(DREAL(DPSI0)+DREAL(ctem2))))
!       ctemt=cc1*cc2*(cx2-cx1)/(cc2*cx2-cc1*cx1)
      cc1p=DCMPLX(1.D0,0.D0)
      uflag=0
      IF (sa*DIMAG(ctem2-ctem).GT.705.D0) THEN
        IF (DIMAG(ctem2-ctem).GT.0.D0) THEN
          ctemr=-cx1
!93:		Testing for forbidden reflections
          IF (CDABS(ctemr).GT.1.D0) THEN
            WRITE(*,*) ' ctemr o/flow', ctemr
            ctemr=(1.D0,0.D0)
          ENDIF
          ctemt=(1.D0,0.D0)-(cx1/cx2)
          IF (Iexcr.EQ.0.AND.(mcyc.GE.8)) THEN
            WRITE(*,170) 'ofs',I,thtime-temth0,sa,ctem2,ctem,cx1
          ENDIF
          Iexcr=Iexcr+1
        ELSE
          ctemr=-cx2
!92
          IF (Iexcr.EQ.0.AND.(mcyc.EQ.4.OR.mcyc.GE.8)) THEN
            WRITE(*,170) 'ofr',I,thtime-temth0,sa,ctem2,ctem,cx1
          ENDIF
          Iexcr=Iexcr+1
          ctemt=(1.D0,0.D0)-(cx2/cx1)
          uflag=1
!92         ctemt=(0.D0,0.D0) no - scale by cc2 vs cc1
        ENDIF
      ELSE
        cc2p=CDEXP(DCMPLX(sa*DIMAG(ctem2-ctem),-sa &
            *DREAL(ctem2-ctem)))
        ctemr=cx1*cx2*(cc1p-cc2p)/(cc2p*cx2-cc1p*cx1)
        ctemt=cc2p*(cx2-cx1)/(cc2p*cx2-cc1p*cx1)
      ENDIF
!93		! ctemr gives the complex amplitude and phase
!93		! of the reflected wave in || and angle;
!93		! in general ctemt gives the complex amplitude and phase
!93		! of the transmitted wave, only after scaling by
!93		! cc2p1^10 defined below.
!93	! Hence here is a good place to bodge in r_F:
!	! NOTE sintime must be sintinc...
      sinthp=CDSQRT(DCMPLX(sintime*sintime,0.D0)+DPSI0)
      ctemrf(ip)=(cpolf*DCMPLX(sintime,0.D0)-sinthp) &
          /(cpolf*DCMPLX(sintime,0.D0)+sinthp)
!93	! ... and t_F. non-magnetic; ffm routine destroys ctem phase info:
      ctemtf(ip)=2.D0*sinthp		 &! vs cpolf*DCMPLX(sintime,0.D0)
          /(cpolf*DCMPLX(sintime,0.D0)+sinthp)	       ! some kind of approxn?
!93:	the following line is critical: (a/s diffn: ctr^2+ctrf^2)
!93atest: for flat crystals here, or a/s curved crystals in CS5:
      IF (AGE.NE.2.AND.(Igraz.EQ.1.OR.Igraz.EQ.-1)) THEN
        ctemr=ctemr+ctemrf(ip)
      ENDIF
!B	! There! Painless but wrong. Fresnel reln neglects decoupling...
    ELSE
!L	For Laue diffraction, one CANNOT:
!	divide cc1,cc2 by large number (cc1) to avoid G-floating o/flow;
!	so must give exact result, unsimplified (hence thin crystal required):
!
      cc1=CDEXP(DCMPLX(sa*(DIMAG(DPSI0)+DIMAG(ctem)),-sa &
          *(DREAL(DPSI0)+DREAL(ctem))))
      cc2=CDEXP(DCMPLX(sa*(DIMAG(DPSI0)+DIMAG(ctem2)),-sa &
          *(DREAL(DPSI0)+DREAL(ctem2))))
      ctemt=(cc1*cx2-cc2*cx1)/(cx2-cx1)
      ctemr=cx1*cx2*(cc1-cc2)/(cx2-cx1)
!93		! ctemr gives the complex amplitude and phase
!93		! of the reflected wave in || and angle;
!93		! here(Laue) ctemt gives the complex amplitude and phase
!93		! of the transmitted wave
!L
    ENDIF
    rtime=(DREAL(ctemr)**2.D0+DIMAG(ctemr)**2.D0)/DABS(basym)
    ttime=DREAL(ctemt)**2.D0+DIMAG(ctemt)**2.D0
!B
    IF (Bragg.EQ.1) THEN
!
!		rescale ctemt/ttime
!		ttime=|ctemt0|^2=ctemt*logttime^10
!		try to avoid skipping to next (OK if I>STEPSF)
      IF ((uflag.EQ.0.AND.sa*DIMAG(DPSI0+ctem)/1.D1.GT.2.D2) &
          .OR.(uflag.EQ.1.AND.sa*DIMAG(DPSI0+ctem2)/1.D1.GT.2.D2)) THEN
        IF (Iexc.EQ.0.AND.(mcyc.GE.8)) THEN
          WRITE(*,170) 'ofl',I,thtime-temth0,sa,ctem2,ctem,cx1
170       FORMAT(1X,'Gfl ',A3,';I,T',I5,8(1PE8.1))
        ENDIF
        ttime=1.D0
        Iexc=Iexc+1
      ELSEIF ((uflag.EQ.0.AND.sa*DIMAG(DPSI0+ctem)/1.D1.LT.-2.D2) &
          .OR.(uflag.EQ.1.AND.sa*DIMAG(DPSI0+ctem2)/1.D1.LT.-2.D2)) THEN
        IF (Iexc.EQ.0.AND.(mcyc.GE.8)) THEN
          WRITE(*,170) 'ufl',I,thtime-temth0,sa,ctem2,ctem,cx1
        ENDIF
        ttime=0.D0
        Iexc=Iexc+1
      ELSE
        IF (uflag.EQ.0.D0) THEN
          cc2p1=CDEXP(DCMPLX(sa*DIMAG(DPSI0+ctem),-sa &
              *DREAL(DPSI0+ctem))/1.D1)
        ELSE
          cc2p1=CDEXP(DCMPLX(sa*DIMAG(DPSI0+ctem2),-sa &
              *DREAL(DPSI0+ctem2))/1.D1)
        ENDIF
        logttime=DREAL(cc2p1)**2.D0+DIMAG(cc2p1)**2.D0
        IF (logttime.LE.1.D-99.OR.logttime.GE.1.D99) THEN
          DO Ittime=1,10
            ttime=ttime*logttime
          ENDDO
!92
!         IF (ttime.LT.1.D-250) THEN
!          ttime=1.D-250
!          Ilim=Ilim+1
!         ENDIF
          IF (ttime.GT.1.D0) ttime=1.D0
        ELSEIF (ttime.GT.0.D00) THEN
          logttime=DLOG(logttime)*1.D1+DLOG(ttime)
          IF (logttime.GT.2.D2) THEN
            WRITE(*,*) ' upper limit ttime error'
            ttime=1.D0
          ELSEIF (logttime.LT.-7.D2) THEN
!test          WRITE (*,*) ' lower limit ttime error'
            ttime=1.D-150
            Ilim=Ilim+1
          ELSE
            ttime=DEXP(logttime)
          ENDIF
        ENDIF
      ENDIF
!93:    the following line is less critical: (a/s diffn: ctr^2+ctrf^2)
!93atest: for flat crystals here, or a/s curved crystals in CS5:
      IF ((Igraz.EQ.1.OR.Igraz.EQ.-1).AND.ttime.GT.1.D-90.AND. &
          AGE.NE.2) THEN
        ttime=ttime*(DREAL(ctemtf(ip))**2+DIMAG(ctemtf(ip))**2) &
            *sintime/CDABS(sinthp)		! Power vs t2, vs inverse:
!     1   *CDABS(sinthp)/sintime        ! Power vs t2
!93atest:
        IF (rtime+ttime.GE.1.D0.OR.CDABS(ctemrf(ip)).GE.1.D0) THEN
!     1   .OR.CDABS(ctemtf(ip)).GE.1.D0) THEN
          WRITE(*,*) 'tht,t0',I,SNGL(thtime),SNGL(sintime),sinthp &
              ,SNGL(t0),SNGL(dely),SNGL(sa)
          WRITE(*,*) 'C,x,cp,tr,tt,r,t',CMPLX(ctem) &
              ,CMPLX(ctem2),CMPLX(cx1),CMPLX(cx2),CMPLX(cc1p) &
              ,CMPLX(cc2p),CMPLX(cc2p1),SNGL(DREAL(cc1)),CMPLX(ctemr) &
              ,CMPLX(ctemt),SNGL(rtime),SNGL(ttime)
          WRITE(*,*) 'F',CMPLX(DPSI0),CMPLX(cpolf) &
              ,CMPLX(ctemrf(ip)),CMPLX(ctemtf(ip))
        ENDIF
!93atest:
      ENDIF
!93	! There! Painless but wrong. Fresnel reln neglects decoupling...
!	 sv=DREAL(drtqp2)
!	 sw=DIMAG(drtqp2)
!	 sinhaw2=DSINH(sa*sw)**2
!	 sinav2=DSIN(sa*sv)**2
!	 bigQ=DSQRT(DREAL(dqplusz2)**2+DIMAG(dqplusz2)**2)
!	 U=bigQ+mz2
!	 V=bigQ-mz2
!	 mq2=((1.-K1**2)**2+4.*p*p)*(basym*K*K*MPSIr2)**2
!	 Vtem=DABS(V*V-mq2)
!	 IF (Vtem.LT.1.0D-35) THEN
!	  Vtem=0.0
!	 ELSE
!	  Vtem=0.5*DSQRT(Vtem)
!	 ENDIF
!	 Utem=DABS(U*U-mq2)
!	 IF (Utem.LT.1.0D-35) THEN
!	  Utem=0.0
!	 ELSE
!	  Utem=0.5*DSQRT(Utem)
!	 ENDIF
!	WRITE(*,*) 'Q,U,V,Utem,Vtem,sinhaw2,sinav2,sa,sw,sv',SNGL(bigQ),SNGL(U)
!     1,SNGL(V),SNGL(Utem),SNGL(Vtem),SNGL(sinhaw2),SNGL(sinav2),SNGL(sa)
!     2,SNGL(sw),SNGL(sv)
!	 bigD=bigQ+U*sinhaw2-V*sinav2+Utem*DSINH(2.*sa*DABS(sw))
!     1+Vtem*DSIN(2.*sa*DABS(sv))
!	 rc=DABS(basym)*K*K*(MPSIr2+MPSIi2)*(sinav2+sinhaw2)/bigD
!			! power ratio (not basym*basym)
!	 tc=bigQ*DEXP(A02*(1.+basym)*G/umbo2)/bigD
    ENDIF
!B
    IF (I.LE.STEPSF) THEN
      IF (rtime.GT.Maxff) THEN
        Maxff=rtime
        ffpk(ip)=thtm2
        Jmaxff=I
        yffpk=ytime
        IF (tflag.GT.0.AND.AGE.GT.1) THEN
          dely0t=dely
          temt1t=temt1
          Onotemt1t=Onotemt1
          t0pk=t0
        ENDIF
      ENDIF
      IF (ttime.LT.Tmin) Tmin=ttime
      Reflint(1)=Reflint(1)+rtime
      meanff(1,ip)=meanff(1,ip)+rtime*thtm2
      meanff(7,ip)=meanff(7,ip)+rtime*thdiff
      Rtem(I)=rtime
      Ttem(I)=ttime
      Thtem(I)=thtm2
      Ytem(I)=ytime
    ELSEIF (I.LE.STEPSF+EXTRASTEPS/2) THEN      ! large th. limit
      Rtem(I-STEPSF+fof)=rtime
      Ttem(I-STEPSF+fof)=ttime
      Thtem(I-STEPSF+fof)=thtm2
      Ytem(I-STEPSF+fof)=ytime
    ELSE                        ! small th. limit
      Rtem(I-STEPSF+fof)=rtime
      Ttem(I-STEPSF+fof)=ttime
      Thtem(I-STEPSF+fof)=thtm2
      Ytem(I-STEPSF+fof)=ytime
    ENDIF
  ENDDO
  IF (Reflint(1).GT.0.D0) THEN
    meanff(1,ip)=meanff(1,ip)/Reflint(1)
    meanff(7,ip)=meanff(7,ip)/Reflint(1)
  ENDIF
  Reflint(1)=Reflint(1)*(thmaxf-thminf)/DFLOAT(STEPSF-1)
  Tlim=MAX(Ttem(1),Ttem(STEPSF))
  Delthf=thmaxf-thminf
!		      calc c10,c90
  IF (Mosdel.GT.0.D0) THEN
    ddel=Mosdel*DFLOAT(STEPSF)/Delthf
    Idel=IDINT(2.5*ddel)
    IF (Idel.EQ.0) Idel=1
  ELSE
    ddel=0.D0
    Idel=0
  ENDIF
  JL=0.D0
  JU=0.D0
  JL2=0.D0
  JU2=0.D0
  JL3=0.D0
  JU3=0.D0
  JL4=0.D0
  JU4=0.D0
!		reset basym.
!92      basym=-1.D0/(cos2apl+sin2apl*scTemth)
  basym=basym0		!+/-sinThins/sinThout0		! ???
  Tem5=DSQRT(MPSIr2)*K/2.D0/sinth
  dsinthdy=-DSQRT(DABS(basym))/basym*Tem5
  Temt1=-dsinthdy/costh		!Tem4/sin2T0/basym
  umbo2=(1.D0-basym)/2.D0
!92      Tem4=DSQRT(DABS(basym)*MPSIr2)*K
!92      dsinthdy=-Tem4/basym/2.D0/sinth
!
  DO I=1,STEPSF           ! cover 50,10,1,0.1%ile ranges
    IF (Rtem(I).GT.0.5D0*Maxff.AND.JL.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JL=1.D0
      ELSE
        JL=DFLOAT(I)-(Rtem(I)-0.5D0*Maxff)/(Rtem(I)-Rtem(I-1))
      ENDIF
    ENDIF
    IF (Rtem(STEPSF+1-I).GT.0.5D0*Maxff.AND.JU.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JU=DFLOAT(STEPSF)
      ELSE
        JU=DFLOAT(STEPSF+1-I)+(Rtem(STEPSF+1-I)-0.5D0*Maxff) &
            /(Rtem(STEPSF+1-I)-Rtem(STEPSF+2-I))
      ENDIF
    ENDIF
    IF (Rtem(I).GT.1.D-1*Maxff.AND.JL3.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JL3=1.D0
      ELSE
        JL3=DFLOAT(I)-(Rtem(I)-1.D-1*Maxff)/(Rtem(I)-Rtem(I-1))
      ENDIF
    ENDIF
    IF (Rtem(STEPSF+1-I).GT.1.D-1*Maxff.AND.JU3.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JU3=DFLOAT(STEPSF)
      ELSE
        JU3=DFLOAT(STEPSF+1-I)+(Rtem(STEPSF+1-I)-1.D-1*Maxff) &
            /(Rtem(STEPSF+1-I)-Rtem(STEPSF+2-I))
      ENDIF
    ENDIF
    IF (Rtem(I).GT.1.D-3*Maxff.AND.JL4.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JL4=1.D0
      ELSE
        JL4=DFLOAT(I)-(Rtem(I)-1.D-3*Maxff)/(Rtem(I)-Rtem(I-1))
      ENDIF
    ENDIF
    IF (Rtem(STEPSF+1-I).GT.1.D-3*Maxff.AND.JU4.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JU4=DFLOAT(STEPSF)
      ELSE
        JU4=DFLOAT(STEPSF+1-I)+(Rtem(STEPSF+1-I)-1.D-3*Maxff) &
            /(Rtem(STEPSF+1-I)-Rtem(STEPSF+2-I))
      ENDIF
    ENDIF
    IF (Rtem(I).GT.1.D-2*Maxff.AND.JL2.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JL2=1.D0
      ELSE
        JL2=DFLOAT(I)-(Rtem(I)-1.D-2*Maxff)/(Rtem(I)-Rtem(I-1))
      ENDIF
    ENDIF
    IF (Rtem(STEPSF+1-I).GT.1.D-2*Maxff.AND.JU2.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JU2=DFLOAT(STEPSF)
      ELSE
        JU2=DFLOAT(STEPSF+1-I)+(Rtem(STEPSF+1-I)-1.D-2*Maxff) &
            /(Rtem(STEPSF+1-I)-Rtem(STEPSF+2-I))
      ENDIF
    ENDIF
    IF (JU.GT.0.D0.AND.JL.GT.0.D0.AND.JU4.GT.0.D0 &
        .AND.JL4.GT.0.D0) GOTO 230		! extremes covered?
  ENDDO
  WRITE(*,220) Maxff,JL,JU,JL4,JU4
220 FORMAT(' Maxff=',1PE13.6,',JL,JU=',2F8.1,',JL4,JU4=',2F8.1)
!92      stop
230 continue
!urrent      IF (AGE.LT.2) THEN
!Ltest      IF (mcyc.GT.1) THEN
  WRITE(*,240) norm,mcyc,STEPSF,thminf,delthf &
      ,meanff(7,ip)-temth0,meanff(2,ip)-temth0,Reflint(1)
240 FORMAT(1X,'n',F3.1,',m',I3,',S',I9,',thmn=',1PE13.6 &
        ,',R,d,1%,IR',4(1PE9.2))
  WRITE(*,250) IDNINT(JL4),IDNINT(JL2),IDNINT(JL3),IDNINT(JL) &
      ,IDNINT(JU),IDNINT(JU3),IDNINT(JU2),IDNINT(JU4) &
      ,tflag,dely0,dely0t,Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3))
250 FORMAT(1X,'c',2I5,6I6,' t,y',I2,3(1PE9.2))
  IF ((Iexc.GT.1.OR.Iexcr.GT.1.OR.Ilim.GT.0) &
      .AND.(mcyc.GE.8)) THEN
    WRITE(*,260) Iexc,Iexcr,Ilim
260 FORMAT(1X,'G-floating arg,ratio exceeds range:',2I5 &
        ,' steps;t uflow limit:',I5,' steps')
  ENDIF
!Ltest      ENDIF
!L
  IF (JL3.LE.1.5D0.AND.(JU3.GE.DFLOAT(STEPSF-1).OR.JU3.LE.1.5D0) &
!L
      .AND.norm.LT.3.AND.STEPSF.LT.fof-200.AND.thminf.GT.tolminang &
      .AND.thmaxf.LT.DPIo2) THEN      ! range * 2
    TemU=Delthf
    thmaxf=DMIN1(thmaxf+TemU/2.D0,DPIo2)
    thminf=DMAX1(thminf-TemU/2.D0,tolminang)
    mcyc=1
    GOTO 150
!L
  ELSEIF ((JL3.LE.1.5D0.OR.JU3.LE.1.5D0)	 &! Dick / Laue range...
!L
      .AND.thminf.GT.tolminang.AND. &
      norm.LT.3.AND.STEPSF.LT.fof-200) THEN      ! lower lim. adj.
    thminf=DMAX1(thminf-Delthf/2.D0,tolminang)
    mcyc=2
    GOTO 150
  ELSEIF (JU2.GE.DFLOAT(STEPSF-1).AND. &
      thmaxf.LT.DPIo2.AND.norm.LT.3.AND.STEPSF.LT.fof-200 &
      .AND.(Igraz.LE.0.OR.thmaxf.LT.0.2)) THEN
!						      ! upper lim. adj.
    thmaxf=DMIN1(thmaxf+Delthf/2.D0,DPIo2)
    mcyc=3
    GOTO 150
!93::
  ELSEIF ( ((DABS(JU2-JL2).LT.DFLOAT(STEPSF/40-3) &
      .AND.(Igraz.LE.0.OR.thmaxf.LT.DPIo2)) &
!93/B:     2  .OR.(DABS(JU2-JL2).GT.DFLOAT(STEPSF/40+3)
!L
      .OR.(DABS(JU3-JL3).GT.DFLOAT(STEPSF/40+3) &
!L
      .AND.(thminf.GT.tolminang.OR.thmaxf.LT.DPIo2))) &
      .AND.norm.LT.2) THEN     ! insuff. chs, vs .AND.norm.NE.1)
!92      ELSEIF((DABS(JU2-JL2).LT.DFLOAT(STEPSF/40-3)
!     1  .OR.DABS(JU2-JL2).GT.DFLOAT(STEPSF/40+3))
!     2  .AND.(thminf.GT.tolminang.OR.thmaxf.LT.DPIo2)
!     3  .AND.norm.LT.2) THEN     ! insuff. chs, vs .AND.norm.NE.1)
!92		Symmetric wrt peak, and estimate range:
!o      ELSEIF (JU2-JL2.LT.5.D1.AND.norm.LT.3) THEN     ! insuff. chs
!o       thmaxf=ffpk+DFLOAT(IABS(JU2-JL2)+50)/DFLOAT(STEPSF-1)*Delthf*2.D0
!o       thminf=ffpk-DFLOAT(IABS(JU2-JL2)+50)/DFLOAT(STEPSF-1)*Delthf*2.D0
!B       thminf=thminf-(DABS(JU2-JL2))/DFLOAT(STEPSF-1)*Delthf*2.D1
!B     1  +((JU2+JL2)/2.D0-1.D0)/DFLOAT(STEPSF-1)*Delthf
!L
    thminf=thminf-(DABS(JU3-JL3))/DFLOAT(STEPSF-1)*Delthf*2.D1 &
        +((JU3+JL3)/2.D0-1.D0)/DFLOAT(STEPSF-1)*Delthf
!L
    IF (thminf.LT.tolminang.OR.Igraz.EQ.1) THEN
      thminf=tolminang
!        IF (norm.NE.1) norm=2
    ENDIF
    IF (Igraz.EQ.1) THEN
      thmaxf=DMIN1(thmaxf+Delthf/2.D0,DPIo2)
    ELSE
!B        thmaxf=thminf+(DABS(JU2-JL2))/DFLOAT(STEPSF-1)*Delthf*4.D1
!L
      thmaxf=thminf+(DABS(JU3-JL3))/DFLOAT(STEPSF-1)*Delthf*4.D1
!L
    ENDIF
    IF (thmaxf.GT.DPIo2) THEN
      thmaxf=DPIo2
!        IF (norm.NE.1) norm=2
!B        thminf=thmaxf-(DABS(JU2-JL2))/DFLOAT(STEPSF-1)*Delthf*4.D1
!L
      thminf=thmaxf-(DABS(JU3-JL3))/DFLOAT(STEPSF-1)*Delthf*4.D1
!L
      IF (thminf.LT.tolminang) THEN
        thminf=tolminang
      ENDIF
    ENDIF
!old       IF (DFLOAT(STEPSF).LT.DABS((thmaxf-thminf)/(meanff(1,ip)-temth0))
!old     1  *3.D2.AND.STEPSF.LT.fof-200) THEN
!old        STEPSF=IDNINT(DABS((thmaxf-thminf)/(meanff(1,ip)-temth0))*3.D2)
!old       ENDIF			! factor of 2 below desired precision
    IF (STEPSF.LT.fof-200) THEN
      IF (AGE.LT.2.AND.norm.NE.1) THEN
        STEPSF=STEPSF*2.D0
      ELSE
        STEPSF=NINT(FLOAT(STEPSF)*1.5)
      ENDIF
    ENDIF
    mcyc=4
!93:
    IF (thmaxf.GE.DPIo2.AND.STEPSF.GE.fof-200) norm=2.0
    GOTO 150
  ELSEIF (AGE.GT.1.AND.t0pk.LT.Maxt3.AND.t0pk.GT.0.D0.AND. &
      dely0.GT.1.5D0.AND.Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3)) &
      .GT.3.D0.AND.norm.EQ.0) THEN	 ! (c90-c10)*.75 overest.
    norm=1
    dely0=DSQRT(dely0*(Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3))))	! vs Y*.75D0
    mcyc=5
    GOTO 150
  ELSEIF (AGE.GT.1.AND.norm.LT.2.D0.AND.dely0.LE.dely0t.AND. &
      dely0.GT.2.3D0.AND.((Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3))) &
      *1.15D0.LT.dely0.OR.((Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3))) &
      *0.9D0.GT.dely0).AND.tflag.LT.2)) THEN
    norm=1
    IF ((Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3))) &
        *1.15D0.LT.dely0) THEN		! jump down faster?
      dely0=DMAX1(2.D0,0.7D0*dely0 &
          +0.3D0*(Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3))) &
          )  	! versus old (Y-Y)*.75D0 or sqrt(dy*DY)
    ELSE
      dely0=0.3D0*dely0 &
          +0.7D0*(Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3)))
    ENDIF
!old       dely0=dely0*.75D0      ! t0 *.75 => c90-c10 * x
    tflag=0            ! cancel tflag
    mcyc=6
    GOTO 150
  ELSEIF (AGE.GT.1.AND.tflag.EQ.1.AND.norm.LT.1.5) &
      THEN
!err       tflag=2
    tflag=0            ! cancel tflag
    norm=1.5
    mcyc=7
    GOTO 150
  ELSEIF (DABS(meanff(7,ip)-meanffo).GT.tolddth &
      *DABS(meanff(7,ip)-temth0).AND.(norm.EQ.0.OR. &
      (norm.GE.1.5.AND.STEPSF.LT.fof-200))) THEN
!92		Refractive Index Precision cutoff:
    IF (thminf.GT.tolminang.AND.thmaxf.LT.DPIo2) THEN
!B        thminf=thminf+Delthf*(((JU2+JL2)/2.D0-1.D0)
!B     1   /DFLOAT(STEPSF-1)-0.5D0)
!B        thmaxf=thmaxf+Delthf*(((JU2+JL2)/2.D0-1.D0)
!B     1   /DFLOAT(STEPSF-1)-0.5D0)
!L
      thminf=thminf+Delthf*(((JU3+JL3)/2.D0-1.D0) &
          /DFLOAT(STEPSF-1)-0.5D0)
      thmaxf=thmaxf+Delthf*(((JU3+JL3)/2.D0-1.D0) &
          /DFLOAT(STEPSF-1)-0.5D0)
!L
      IF (thmaxf.GT.DPIo2) thmaxf=DPIo2
      IF (thminf.LT.tolminang) thminf=tolminang
    ENDIF
    IF (STEPSF.LT.fof-200) THEN
      IF (AGE.LT.2.AND.iprecs.NE.0) THEN
        STEPSF=fof-200
      ELSE
        STEPSF=NINT(FLOAT(STEPSF)*1.8)		! was 1.5 and 1.4
      ENDIF
    ELSE
      IF (thminf.GT.tolminang) THEN
        thminf=DMAX1(thminf-0.1D0*Delthf,tolminang)
        IF (thmaxf.LT.DPIo2) thmaxf=DMIN1(thmaxf+0.1D0*Delthf &
            ,DPIo2)
      ELSEIF (thmaxf.LT.DPIo2) THEN
        thmaxf=DMIN1(thmaxf+0.1D0*Delthf,DPIo2)
      ENDIF
      Reflinto=Reflint(1)	! consider RFL, but ...
      norm=2			! don't increase range any more
    ENDIF
    mcyc=8
    GOTO 150
  ELSEIF (DABS(Reflint(1)-Reflinto).GT.tolir*Reflint(1).AND. &
      norm.NE.1.AND.norm.LT.3.AND.STEPSF.LT.fof-200) THEN
!92		Integrated Reflectivity Precision cutoff:
    IF (thminf.GT.tolminang.AND.thmaxf.LT.DPIo2) THEN
!B        thminf=thminf+Delthf*(((JU2+JL2)/2.D0-1.D0)
!B     1   /DFLOAT(STEPSF-1)-0.75D0)
!B        thmaxf=thmaxf+Delthf*(((JU2+JL2)/2.D0-1.D0)
!B     1   /DFLOAT(STEPSF-1)-0.25D0)
!L
      thminf=thminf+Delthf*(((JU3+JL3)/2.D0-1.D0) &
          /DFLOAT(STEPSF-1)-0.75D0)
      thmaxf=thmaxf+Delthf*(((JU3+JL3)/2.D0-1.D0) &
          /DFLOAT(STEPSF-1)-0.25D0)
!L
    ELSEIF (thminf.GT.tolminang) THEN
      thminf=thminf-0.5D0*Delthf
    ELSEIF (thmaxf.LT.DPIo2) THEN
      thmaxf=thmaxf+0.5D0*Delthf
    ENDIF
    IF (thmaxf.GT.DPIo2) thmaxf=DPIo2
    IF (thminf.LT.tolminang) thminf=tolminang
    IF (AGE.LT.2.AND.iprecs.NE.0) THEN
      STEPSF=fof-200
    ELSE
      STEPSF=NINT(FLOAT(STEPSF)*1.8)		! was 1.5 and 1.4
    ENDIF
    Reflinto=Reflint(1)
    norm=2
    mcyc=9
    GOTO 150
  ELSEIF (norm.LE.1) THEN
    norm=2				 !end/dely0 search;test prec'n
    IF (thminf.GT.tolminang.AND.thmaxf.LT.DPIo2) THEN
!B        thminf=thminf+Delthf*(((JU2+JL2)/2.D0-1.D0)
!B     1   /DFLOAT(STEPSF-1)-0.75D0)
!B        thmaxf=thmaxf+Delthf*(((JU2+JL2)/2.D0-1.D0)
!B     1   /DFLOAT(STEPSF-1)-0.25D0)
!L
      thminf=thminf+Delthf*(((JU3+JL3)/2.D0-1.D0) &
          /DFLOAT(STEPSF-1)-0.75D0)
      thmaxf=thmaxf+Delthf*(((JU3+JL3)/2.D0-1.D0) &
          /DFLOAT(STEPSF-1)-0.25D0)
!L
    ELSEIF (thminf.GT.tolminang) THEN
      thminf=thminf-0.5D0*Delthf
    ELSEIF (thmaxf.LT.DPIo2) THEN
      thmaxf=thmaxf+0.5D0*Delthf
    ENDIF
    IF (thmaxf.GT.DPIo2) thmaxf=DPIo2
    IF (thminf.LT.tolminang) thminf=tolminang
    IF (STEPSF.LT.fof-200) THEN
      IF (AGE.LT.2.AND.iprecs.NE.0) THEN
        STEPSF=fof-200
      ELSE
        STEPSF=STEPSF*2
      ENDIF
    ENDIF
    Reflinto=Reflint(1)
    mcyc=10
    GOTO 150
  ELSEIF (Idel+STEPSF/2.GE.fof/2.AND.Idel.LT.25*fof) THEN
    STEPSF=IDINT(DFLOAT(STEPSF)*DFLOAT(fof-200) &
        /DFLOAT(2*Idel+STEPSF))
    IF (STEPSF.LT.5) STEPSF=5
    norm=3
    meanffo=meanff(7,ip)
    Reflinto=Reflint(1)
    mcyc=11
    GOTO 150
  ENDIF
!525   CONTINUE
  Reflinto=Reflint(1)
  meanffo=meanff(7,ip)
!		set THIN FLAT PERFECT calculation:
!      DO I=1,STEPSF+EXTRASTEPS
!       IF (I.GT.STEPSF) THEN
!        J=fof+I-STEPSF
!       ELSE
!        J=I
!       ENDIF
!       RtemC(J)=Rtem(J)
!       TtemC(J)=Ttem(J)
!       ThtemC(J)=Thtem(J)
!       YtemC(J)=Ytem(J)
!	   ENDDO
!      IF (Fwrite(Inext).EQ.Ilist.OR.ANS.EQ.2.OR.ANS.EQ.3) THEN ! profiles
!       FILEIN2='FFRCC.'//numstr(1:4)
!       OPEN (UNIT=8,FILE=dout//FILEIN2,STATUS='NEW')
!       DO I=1,STEPSF	!+EXTRASTEPS
!        IF (I.GT.STEPSF) THEN
!         J=fof+I-STEPSF
!        ELSE
!         J=I
!        ENDIF
!	 	 IF (20*(J/20).EQ.J)
!	1	 WRITE(8,588) ThtemC(J),RtemC(J),TtemC(J),YtemC(J),Tabdy2(I,1),Tabdy2(I,4)
!       ENDDO
!	   CLOSE(8,STATUS='KEEP')
!	  ENDIF
  IF (Mosdel.LE.0.D0) THEN
    DO I=1,STEPSF+EXTRASTEPS
      IF (I.GT.STEPSF) THEN
        J=fof+I-STEPSF
      ELSE
        J=I
      ENDIF
      Rtem2(J)=Rtem(J)
      Ttem2(J)=Ttem(J)
      Thtem2(J)=Thtem(J)
      Ytem2(J)=Ytem(J)
      Tabdy(I,1)=Tabdy2(I,1)
      Tabdy(I,4)=Tabdy2(I,4)
    ENDDO
  ENDIF
  STEPSF1=STEPSF
  cffm(ip,1,1)=thminf
  cffm(ip,2,1)=thminf+(thmaxf-thminf)*(JL2-1.D0)/DFLOAT(STEPSF-1)
  cffm(ip,3,1)=thminf+(thmaxf-thminf)*(JL-1.D0)/DFLOAT(STEPSF-1)
  cffm(ip,4,1)=ffpk(ip)
  cffm(ip,5,1)=thminf+(thmaxf-thminf)*(JU-1.D0)/DFLOAT(STEPSF-1)
  cffm(ip,6,1)=thminf+(thmaxf-thminf)*(JU2-1.D0)/DFLOAT(STEPSF-1)
  cffm(ip,7,1)=thmaxf
  cffm(ip,8,1)=Maxff
  tsmall=1.D-15
!U96- [RtemC,TtemC,ThtemC,YtemC]
!U96- Reflinto,meanffo,STEPSF1,cffm(..1),JU3,JL3,
!U96- [JL,JU,JL2,JU2,JL4,JU4,Maxff,ffpk,thminf,thmaxf,]
!U96- [Tabdy2(I,1),Reflint(1),Reflint(2),meanff(1:2:7,ip)]
!93test
  IF (AGE.GT.1) THEN		! adjust t0
    dely=dely0t			! use values near peak v dely0
    Temt1=temt1t
    Onotemt1=Onotemt1t
!U96:       t0=t0pk
!       IF (t0.GE.maxt3) THEN		! near-normal incidence
!        dely=-(DACOS(DCOS(thdiff)
!     1   /(t0/GB1+1.D0))-thdiff)*Onotemt1
!       ENDIF
!L
!L       tdely=-(DACOS(DCOS(thmaxf)/DABS(maxt3
!L     1   /DABS(GB1)+1.D0))-thmaxf)*Onotemt1
!U96:	maxt3 not for mosaic - should be maxt2(crystal)/maxt0(depth)
    tdely=-(DACOS(DCOS(thmaxf)/DABS(Maxt2 &
        /DABS(GB1)+1.D0))-thmaxf)*Onotemt1
!
  ENDIF
  Ist=1
!93atest:-------------------------------------------------------------------
!		Mosaic Angular spread convolution
!		      a: ffrc dominated by ang. spread
  IF (Mosdel.GT.0.D0) THEN
!		calculate THIN FLAT MOSAIC convolution:
    ddel=Mosdel*DFLOAT(STEPSF)/(thmaxf-thminf)
    Ascale=0.D0
    Idel=IDINT(2.5*ddel)            ! use good range for profiles
    IF (Idel.LT.1) Idel=1
    IF (Idel.GE.fof/2-101) THEN            ! sum gt fof useless
      Idel=fof/2-101
      DO J=0,Idel
        Rfact(J)=DEXP(-(DFLOAT(J)/DFLOAT(Idel)*2.5D0)**2*dln2)
        Ascale=Ascale+Rfact(J)
      ENDDO
      Ascale=Ascale*2.D0-Rfact(0)
      DO J=0,Idel
        Rfact(J)=Rfact(J)/Ascale
      ENDDO
      thmaxf=meanff(1,ip)+2.5D0*Mosdel      ! meanff is centre; not ffpk
      thminf=meanff(1,ip)-2.5D0*Mosdel
      STEPSF=2*Idel+1
      JL4=1.D0			! reset .001 indicators to extremes
      JU4=STEPSF
      DO J=-Idel,Idel
        rtime=Reflinto*Rfact(ABS(J))*DFLOAT(STEPSF)/4.D0/Mosdel
!		! from mosaic: r=conv(rf.W)=meanr.intW(over Delthf lim)
!		! =Reflint/Delthf * W(th-thB) * delsteps(Delthf)
!		! delsteps=Delthf/(4.Mosdel)*stepsf !!!
        ttime=Tlim
        Iolddel=INT(Delthf/Mosdel/4.D0*DFLOAT(Idel))
        Ist=MAX(-J-Iolddel,-Idel)
        Imax=MIN(-J+Iolddel,Idel)
        DO I=Ist,Imax            ! very simple approxn
          ttime=ttime+(Tmin-Tlim)*(1.D0-DABS(DFLOAT(I+J)) &
              /DFLOAT(Iolddel))*Rfact(ABS(I))
        ENDDO
        thtime=thminf+(thmaxf-thminf)*DFLOAT(J+Idel+1)/DFLOAT(STEPSF)
        Rtem2(J+Idel+1)=rtime
        Ttem2(J+Idel+1)=ttime
        Thtem2(J+Idel+1)=thtime
        Ytem2(J+Idel+1)=-(DSIN(ffpk(ip)+aplane) &
            -sinthdf)/dsinthdy+yffpk
        IF (J.EQ.0) Maxff=rtime
        Jmaxff2=Idel+1
      ENDDO
      Reflintm=Reflinto*DFLOAT(STEPSF)/4.D0/Mosdel
      Imax=STEPSF
      Ist=1
      DO I=1,EXTRASTEPS/2  !4Mosdel>Delthf=>Rint.stepdel.exp/A NOT=0
        Rtem2(I+fof)=rtime*2.D0**(-6.25D0* &
            (2.D0**(DFLOAT(I-5))+2.D0**(DFLOAT(I-3)/2.D0)))
        Rtem2(I+fof+10)=Rtem2(I+fof)
        Ttem2(I+fof)=Ttem2(fof+9)
        Ttem2(I+fof+10)=Ttem2(fof+19)
        Thtem2(I+fof)=thmaxf+(thmaxf-thminf)*2.D0**(DFLOAT(I-7)/2.D0)
        Thtem2(I+fof+10)=thminf-(thmaxf-thminf)*2.D0**(DFLOAT(I-7)/2.)
        Ytem2(I+fof)=-(DSIN(ffpk(ip)+aplane) &
            -DSIN(Thtem2(I+fof)+aplane))/dsinthdy+yffpk
        Ytem2(I+fof+10)=-(DSIN(ffpk(ip)+aplane) &
            -DSIN(Thtem2(I+fof+10)+aplane))/dsinthdy+yffpk
      ENDDO
      Delthf=thmaxf-thminf
      Delthm=(2.D0**1.5D0)*(thmaxf-thminf)
      Mosflag=1
!93:
      ffpk(ip)=meanff(1,ip)
!U96:        GOTO 580
    ELSE
      DO J=0,Idel
        Rfact(J)=DEXP(-(DFLOAT(J)/ddel)**2.D0*dln2)
        Ascale=Ascale+Rfact(J)
      ENDDO
      Ascale=Ascale*2.D0-Rfact(0)
      DO J=0,Idel
        Rfact(J)=Rfact(J)/Ascale
      ENDDO
!U96:       ENDIF
      IF (2*Idel.GT.STEPSF) THEN		! Mos.Ang.Width>ffrc range
        thminf=meanff(1,ip)-2.5D0*Mosdel-Delthf/2.D0
        thmaxf=meanff(1,ip)+2.5D0*Mosdel+Delthf/2.D0	!inc. ffrc profile tails
        Iolddel=STEPSF            ! ffrc fwhm range
        STEPSF=STEPSF+2*Idel
!U96:
        IF (STEPSF.GT.fof-200) STEPSF=fof-200
        JL4=1.D0			! reset .001 indicators to extremes
        JU4=STEPSF
        Reflintm=0.D0
        Maxff=-1.D0
        ffpk(ip)=thminf
        DO I=1,STEPSF
          rtime=0.D0
          ttime=0.D0
          temsum=0.
          Jst=MAX(1,I-2*Idel)            ! sum limitted by ffrc range
          Jast=MIN(Iolddel,I)
          DO J=Jst,Jast
            rtime=rtime+Rtem(J)*Rfact(IABS(I-J-Idel))
            ttime=ttime+Ttem(J)*Rfact(IABS(I-J-Idel))
            temsum=temsum+Rfact(IABS(I-J-Idel))
          ENDDO
          IF (temsum.GT.0.D0) ttime=ttime/temsum
          Reflintm=Reflintm+rtime
          IF (rtime.GT.Maxff) THEN
            Maxff=rtime
            Jmaxff2=I
            ffpk(ip)=thminf+(thmaxf-thminf)*DFLOAT(I-1)/DFLOAT(STEPSF)
          ENDIF
          Rtem2(I)=rtime
          Ttem2(I)=ttime
          Thtem2(I)=thminf+(thmaxf-thminf)*DFLOAT(I-1)/DFLOAT(STEPSF)
          Ytem2(I)=-(DSIN(ffpk(ip)+aplane) &
              -DSIN(Thtem2(I)+aplane))/dsinthdy+yffpk
        ENDDO
        Reflintm=Reflintm*(thmaxf-thminf)/DFLOAT(STEPSF)
!
!				    old method
!	    ttime=Tlim
!	    Ist=MAX(-J-Iolddel/2,-Idel)
!	    Imax=MIN(-J+Iolddel/2,Idel)
!	   DO J=-Idel,Idel
!	    rtime=Reflinto*Rfact(ABS(J))*DFLOAT(STEPSF)/4./Mosdel
!	    DO I=Ist,Imax		  ! very simple approxn
!	 ttime=ttime+(Tmin-Tlim)*(1.D0-DABS(DFLOAT(I+J))
!       1 /DFLOAT(Iolddel/2)*Rfact(ABS(I))
!	    ENDDO
!	    thtime=thminf+(thmaxf-thminf)*DFLOAT(J+Idel+1)/DFLOAT(STEPSF)
!	    Rtem(J+Idel+1)=rtime
!	    Ttem(J+Idel+1)=ttime
!	    Thtem(J+Idel+1)=thtime
!	    Ytem(J+Idel+1)=0.0
!	    IF (J.EQ.0) Maxff=rtime
!	   ENDDO
!	   Reflintm=Reflinto*DFLOAT(STEPSF)/4.D0/Mosdel
!	   Imax=STEPSF
!	   Ist=1
!
        Rtem21=DFLOAT(Iolddel)/DFLOAT(Idel)/2.D0
        DO I=1,EXTRASTEPS/2  !4Mosdel>Delthf=>Rint.stepdel.exp/A NOT=0
          Rtem2(I+fof)=Rtem(STEPSF-Iolddel)*2.D0**(-6.25D0*(2.D0*Rtem21 &
              -Rtem21*Rtem21+2.D0**(DFLOAT(I-5))+2.D0**(DFLOAT(I-3)/2.D0)))
          Rtem2(I+fof+10)=Rtem(Iolddel)*2.D0**(-6.25D0*(2.D0*Rtem21 &
              -Rtem21*Rtem21+2.D0**(DFLOAT(I-5))+2.D0**(DFLOAT(I-3)/2.D0))) 
          Ttem2(I+fof)=Ttem(fof+9)
          Ttem2(I+fof+10)=Ttem(fof+19)
          Thtem2(I+fof)=thmaxf+(thmaxf-thminf)*2.D0**(DFLOAT(I-7)/2.D0)
          Thtem2(I+fof+10)=thminf-(thmaxf-thminf) &
              *2.D0**(DFLOAT(I-7)/2.D0)
          Ytem2(I+fof)=-(DSIN(ffpk(ip)+aplane) &
              -DSIN(Thtem2(I+fof)+aplane))/dsinthdy+yffpk
          Ytem2(I+fof+10)=-(DSIN(ffpk(ip)+aplane) &
              -DSIN(Thtem2(I+fof+10)+aplane))/dsinthdy+yffpk
        ENDDO
        Delthf=thmaxf-thminf
        Delthm=(2.D0**1.5D0)*(thmaxf-thminf)
        Mosflag=1
      ELSE
        Reflintm=0.D0
        Maxff=-1.D0
        ffpk(ip)=Thtem(1)
        DO I=1,STEPSF
          rtime=0.D0
          ttime=0.D0
          temsum=0.D0
          Jst=MAX(-Idel,-I+1)
          Jast=MIN(Idel,STEPSF-I)
          DO J=Jst,Jast
            rtime=rtime+Rtem(I+J)*Rfact(IABS(J))
            ttime=ttime+Ttem(I+J)*Rfact(IABS(J))
            temsum=temsum+Rfact(IABS(J))
          ENDDO
          IF (temsum.GT.0.D0) ttime=ttime/temsum
          Reflintm=Reflintm+rtime
          IF (rtime.GT.Maxff) THEN
            Jmaxff2=I
            Maxff=rtime
            ffpk(ip)=Thtem(I)
          ENDIF
          Rtem2(I)=rtime
          Ttem2(I)=ttime
          Thtem2(I)=Thtem(I)
          Ytem2(I)=Ytem(I)
        ENDDO
        Reflintm=Reflintm*(thmaxf-thminf)/DFLOAT(STEPSF)
        Delthf=thmaxf-thminf
        Mosflag=1
      ENDIF
!		      ! 4.MOSDEL<DELTHF => Rint.stepdel.exp/A=0
!U96:580    continue
    ENDIF
  ELSE		! fill in perfect array
    Jmaxff2=Jmaxff
  ENDIF
!U96: endthin flat mosaic calcn
!		Recalculate c01, c25, c75, c99 and derivative mean angles
!93atest:	Was JLM but not propagated? Use JL?
  JLM=0.D0
  JUM=0.D0
  JLM2=0.D0
  JUM2=0.D0
  JLM4=0.D0
  JUM4=0.D0
  DO I=1,STEPSF
    IF (Rtem2(I).GT.0.5D0*Maxff.AND.JLM.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JLM=1.D0
      ELSE
        JLM=DFLOAT(I)-(Rtem2(I)-0.5D0*Maxff)/(Rtem2(I)-Rtem2(I-1))
      ENDIF
    ENDIF
    IF (Rtem2(STEPSF+1-I).GT.0.5D0*Maxff.AND.JUM.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JUM=DFLOAT(STEPSF)
      ELSE
        JUM=DFLOAT(STEPSF+1-I)+(Rtem2(STEPSF+1-I)-0.5D0*Maxff) &
            /(Rtem2(STEPSF+1-I)-Rtem2(STEPSF+2-I))
      ENDIF
    ENDIF
    IF (Rtem2(I).GT.1.D-2*Maxff.AND.JLM2.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JLM2=1.D0
      ELSE
        JLM2=DFLOAT(I)-(Rtem2(I)-1.D-2*Maxff)/(Rtem2(I)-Rtem2(I-1))
      ENDIF
    ENDIF
    IF (Rtem2(STEPSF+1-I).GT.1.D-2*Maxff.AND.JUM2.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JUM2=DFLOAT(STEPSF)
      ELSE
        JUM2=DFLOAT(STEPSF+1-I)+(Rtem2(STEPSF+1-I)-1.D-2*Maxff) &
            /(Rtem2(STEPSF+1-I)-Rtem2(STEPSF+2-I))
      ENDIF
    ENDIF
    IF (Rtem2(I).GT.1.D-3*Maxff.AND.JLM4.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JLM4=1.D0
      ELSE
        JLM4=DFLOAT(I)-(Rtem2(I)-1.D-3*Maxff)/(Rtem2(I)-Rtem2(I-1))
      ENDIF
    ENDIF
    IF (Rtem2(STEPSF+1-I).GT.1.D-3*Maxff.AND.JUM4.EQ.0.D0) THEN
      IF (I.EQ.1) THEN
        JUM4=DFLOAT(STEPSF)
      ELSE
        JUM4=DFLOAT(STEPSF+1-I)+(Rtem2(STEPSF+1-I)-1.D-3*Maxff) &
            /(Rtem2(STEPSF+1-I)-Rtem2(STEPSF+2-I))
      ENDIF
    ENDIF
  ENDDO
!	WRITE(*,*) 'JLM4/JUM4',JLM4,JUM4
!93atest: perfect/small mosdel: init.JL(M)4; large mosdel: 1:STEPSF
  eRthld=0.D0
  emthld(ip)=0.D0
  DO KLP=IDINT(JLM4)-1,IDINT(JUM4)+1
    tsum2(KLP)=1.D0
  ENDDO
!93atest: Delthf: all mosaics reset to new thmaxf-thminf:
!U96: I think emthld is garbage!: tdely = mosaic? should be Dymax/maxt0
  tfact=DMAX1(DABS(Temt1*dely/Delthf*STEPSF),1.D0)	! min=1 approxn
  totf=IDINT(DMIN1(DMAX1(DABS(Temt1*tdely/Delthf*STEPSF),1.D0), &
      JUM4-JLM4))	!c93atest: here/after convol? Delthf,JUM4 change
!93atest-	  WRITE(*,*) '1',dely,tdely,t0pk,Temt1,Delthf,tfact,totf
  Reflint(2)=0.D0
  Meanff(2,ip)=0.D0
  KLP=IDINT(JLM4)+1
  DO I=1,STEPSF
    thtime=thminf+(thmaxf-thminf)*DFLOAT(I-1)/DFLOAT(STEPSF-1)
    IF (Thtem2(I).NE.thtime) THEN
!93test		OK?
!         WRITE(*,*) 'Th',thtime,Thtem(I)
      Thtem2(I)=thtime			! just in case????
    ENDIF
    dsinth=DABS(DSIN(thtime) &
        -DSIN(thtime+(thmaxf-thminf)/DFLOAT(STEPSF-1)))
    rtime=Rtem2(I)
    Reflint(4)=Reflint(4)+rtime*dsinth
    meanff(4,ip)=meanff(4,ip)+rtime*DSIN(thtime)*dsinth
    IF (DFLOAT(I).GT.JLM2.AND.DFLOAT(I).LT.JUM2) THEN
      Reflint(2)=Reflint(2)+rtime
      meanff(2,ip)=meanff(2,ip)+rtime*thtime
      Reflint(5)=Reflint(5)+rtime*dsinth
      meanff(5,ip)=meanff(5,ip)+rtime*DSIN(thtime)*dsinth
    ENDIF
    IF (DFLOAT(I).GT.JLM4.AND.DFLOAT(I).LT.JUM4) THEN
      Reflint(3)=Reflint(3)+rtime
      meanff(3,ip)=meanff(3,ip)+rtime*thtime
      Reflint(6)=Reflint(6)+rtime*dsinth
      meanff(6,ip)=meanff(6,ip)+rtime*DSIN(thtime)*dsinth
      DO JLP=1,MIN(totf,I-1)	! crystal layers from surf to depth
!         IF (JLP.EQ.1) THEN	! first element
!          eRthld=eRthld+Rtem(I)
!          emthld(ip)=emthld(ip)+Rtem(I)*Thtem(I)
!          tsum2(I)=tsum2(I)*Ttem(I-1)**(2.D0/tfact)	! in and out
!         ELSE
        IF (tsum2(I).GT.tsmall) THEN
          eRthld=eRthld+Rtem2(I)*tsum2(I)
          emthld(ip)=emthld(ip)+Thtem2(I) &
              *Rtem2(I)*tsum2(I)
          tsum2(I)=tsum2(I) &
              *Ttem2(I-JLP)**(2.D0/tfact)
          IF (tsum2(I).LT.tsmall) tsum2(I)=0.D0
        ENDIF
!         ENDIF
      ENDDO
    ENDIF
!92       IF (JUM.GT.0.D0.AND.JLM.GT.0.D0) GOTO 585	! loop through all, now
  ENDDO
!93		set THIN FLAT MOSAIC calculation:
  STEPSF2=STEPSF
  IF (Fwrite(Inext).EQ.Ilist.OR.ANS.EQ.2.OR.ANS.EQ.3) THEN ! profiles
!plate96 output changes flag       
    IF (Outfilesflag.GE.1) GOTO 451
    FILEIN2='FFRC.'//numstr(1:4)
    OPEN (UNIT=8,FILE=dout//FILEIN2,STATUS='NEW')
    DO I=1,STEPSF+EXTRASTEPS
      IF (I.GT.STEPSF) THEN
        J=fof+I-STEPSF
      ELSE
        J=I
      ENDIF
      IF (8*(J/8).EQ.J.OR.I.GT.STEPSF) &
          WRITE(8,588) Thtem2(J),Rtem2(J),Ttem2(J),Ytem2(J),Tabdy2(I,1),Tabdy2(I,4)
    ENDDO
    CLOSE(8,STATUS='KEEP')
  ENDIF
451 DO id=2,3
    IF (Reflint(id).GT.0.D0) meanff(id,ip)=meanff(id,ip)/Reflint(id)
    Reflint(id)=Reflint(id)*(thmaxf-thminf)/DFLOAT(STEPSF-1)
  ENDDO
  emthld(ip)=emthld(ip)/eRthld-temth0	! maybe, C93test
  DO id=4,6		! conversion to meanth
    IF (Reflint(id).GT.0.D0) &
        meanff(id,ip)=DASIN(meanff(id,ip)/Reflint(id))
  ENDDO
!U96:      t0=t0pk
!93atest:-------------------------------------------------------------------
  cffm(ip,1,2)=thminf
  cffm(ip,2,2)=thminf+(thmaxf-thminf)*(JLM2-1.D0)/DFLOAT(STEPSF-1)
  cffm(ip,3,2)=thminf+(thmaxf-thminf)*(JLM-1.D0)/DFLOAT(STEPSF-1)
  cffm(ip,4,2)=ffpk(ip)
  cffm(ip,5,2)=thminf+(thmaxf-thminf)*(JUM-1.D0)/DFLOAT(STEPSF-1)
  cffm(ip,6,2)=thminf+(thmaxf-thminf)*(JUM2-1.D0)/DFLOAT(STEPSF-1)
  cffm(ip,7,2)=thmaxf
  cffm(ip,8,2)=Maxff
!U96- Rfact,Ascale,ddel,Idel,Reflintm,Delthf,Delthm,emthld,KLP,tfact,totf
!U96- JLM,JUM,JLM2,JUM2,JLM4,JUM4,cffm(..2),Reflint(2:6),meanff(2:6.)
!U96- Rtem2,Ttem2,Thtem2,Ytem2,Tabdy2(I,4),[JL4,JU4]
!93		calculate THICK FLAT MOSAIC convolution:
!		Tabdy, Rtem,Ttem,JU/M,JU2,JU4,c1ff,c2ff,Maxff,ffpk
!		+ DSTEPS,IDSTEPS,KSTEP,npower,ipower (re)computed:
!U96	  JUM=JU
!U96	  JLM=JL
!93atest: bypass last (unwanted) loop:      IF (Mosdel.GT.0.D0) THEN	
  IF (Mosdel.GT.0.D0) THEN
    IF (AGE.LE.1.AND.Maxt3.LT.Maxt2) THEN
      npower=Maxt2/Maxt3
      ipower=DFLOAT(IDINT(npower))
      Maxff=0.D0
      DO I=1,STEPSF+EXTRASTEPS
        IF (I.GT.STEPSF) THEN
          J=fof+I-STEPSF
        ELSE
          J=I
        ENDIF
        Rtem(J)=Rtem2(J)*((1.D0-Ttem(J)**(2.D0*ipower)) &
            /(1.D0-Ttem2(J)**2.D0)+(npower-ipower)**2.D0 &
            *Ttem2(J)**(2.D0*ipower))
        Ttem(J)=Ttem2(J)**npower
        Thtem(J)=Thtem2(J)
        Ytem(J)=Ytem2(J)
        IF (Rtem(J).GT.Maxff) THEN
          Maxff=Rtem(J)
          Jmaxff=J
          ffpk(ip)=Thtem(J)
        ENDIF
      ENDDO
    ELSEIF (AGE.GT.1.AND.nflag.EQ.1) THEN	! truncated somewhere...
!93		calculate THICK PSEUDO-FLAT MOSAIC convolution:
      Maxff=0.D0
      DO I=1,STEPSF+EXTRASTEPS
        IF (I.GT.STEPSF) THEN
          J=fof+I-STEPSF
        ELSE
          J=I
        ENDIF
!93		Local ratio = number of mosaic units per lamellar/crystal unit:
        Tabdy(I,1)=Tabdy2(I,1)
        IF (Tabdy2(I,2)*8.D0.GT.(Ytem2(JUM)-Ytem2(JLM)).AND. &
            Tabdy2(I,1).GT.1.D-4) THEN
          npower=Tabdy2(I,2)/Tabdy2(I,1)
          Tabdy(I,4)=Tabdy2(I,2)
        ELSEIF (Tabdy2(I,1).GT.1.D-4) THEN
          Tabdy(I,4)=(Ytem2(JUM)-Ytem2(JLM))/8.D0
!U96: allowed scaling depends on DP i.e. Ttem: 
!crystal/flat:
          npower=Tabdy(I,4)/Tabdy2(I,1)
! vs smaller DP error:
!          npower=DMIN1(Tabdy(I,4)/Tabdy2(I,1),1.D1)
        ELSE
          Tabdy(I,4)=Tabdy2(I,1)
          npower=1.D0
        ENDIF
        ipower=DFLOAT(IDINT(npower))
        Thtem(J)=Thtem2(J)
        Ytem(J)=Ytem2(J)
        IF (ipower.LE.1.D0) THEN	! both limited by dely0
          Rtem(J)=Rtem2(J)
          Ttem(J)=Ttem2(J)
        ELSE		! calcn == maxt3; intermediate == dely0 or Maxt2
          Tabdy(I,2)=Tabdy2(I,2)*ipower/npower	! for CS5, mosaic
          Tabdy(I,3)=Tabdy2(I,3)*ipower/npower
          DSTEPS=DFLOAT(STEPSF)*Tabdy(I,3)/(thmaxf-thminf)
          IDSTEPS=IDINT(DSTEPS/2.D0)+1
          IF (I.GT.STEPSF-IDSTEPS.OR.I.LE.IDSTEPS) THEN	! Assume R, T constant
            Rtem(J)=Rtem2(J)*((1.D0-Ttem2(J)**(2.D0*ipower)) &
                /(1.D0-Ttem2(J)**2.D0))
            Ttem(J)=Ttem2(J)**ipower
!U96:
          ELSE		! simple formula, poor approx. neglects DP
            Rtem(J)=0.D0
            Ttem(J)=1.D0
            DO KLP=1,IDINT(ipower)
!U96: assume front surface for first order:
              IF (ORDER.EQ.1.D0) THEN	!
                KSTEP=DFLOAT(J)+DSTEPS*DFLOAT(KLP-1) &
                    /(ipower-1.D0)
              ELSE
                KSTEP=DFLOAT(J)-DSTEPS/2.D0+DSTEPS*DFLOAT(KLP-1) &
                    /(ipower-1.D0)
              ENDIF
!U96-	Very crude.Last assumes T=1 so depth= 1/2 way
              Rtem(J)=Rtem(J)+(Rtem2(IDINT(KSTEP)) &
                  +(KSTEP-DFLOAT(IDINT(KSTEP)))*(Rtem2(IDINT(KSTEP)+1) &
                  -Rtem2(IDINT(KSTEP))))*Ttem(J)*Ttem(J)
              Ttem(J)=Ttem(J)*(Ttem2(IDINT(KSTEP)) &
                  +(KSTEP-DFLOAT(IDINT(KSTEP)))*(Ttem2(IDINT(KSTEP)+1) &
                  -Ttem2(IDINT(KSTEP))))
            ENDDO
!U96-
          ENDIF
        ENDIF
        IF (Rtem(J).GT.Maxff) THEN
          Maxff=Rtem(J)
          ffpk(ip)=Thtem(J)
          Jmaxff=J
        ENDIF
      ENDDO
!        DO I=1,STEPSF+EXTRASTEPS
!         IF (I.GT.STEPSF) THEN
!          J=fof+I-STEPSF
!         ELSE
!          J=I
!         ENDIF
!         Rtem(J)=Rtem2(J)
!         Ttem(J)=Ttem2(J)
!        ENDDO
    ENDIF
!93		Recalculate c01, c25, c75, c99:
    IF ((AGE.LE.1.AND.Maxt3.LT.Maxt2).OR. &
        (AGE.GT.1.AND.nflag.EQ.1)) THEN
      JL1=0.D0
      JU1=0.D0
      JL2=0.D0
      JU2=0.D0
      JL4=0.D0
      JU4=0.D0
      DO I=1,STEPSF
        IF (Rtem(I).GT.0.5D0*Maxff.AND.JL1.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JL1=1.D0
          ELSE
            JL1=DFLOAT(I)-(Rtem(I)-0.5D0*Maxff)/(Rtem(I)-Rtem(I-1))
          ENDIF
        ENDIF
        IF (Rtem(STEPSF+1-I).GT.0.5D0*Maxff.AND.JU1.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JU1=DFLOAT(STEPSF)
          ELSE
            JU1=DFLOAT(STEPSF+1-I)+(Rtem(STEPSF+1-I)-0.5D0*Maxff) &
                /(Rtem(STEPSF+1-I)-Rtem(STEPSF+2-I))
          ENDIF
        ENDIF
        IF (Rtem(I).GT.1.D-2*Maxff.AND.JL2.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JL2=1.D0
          ELSE
            JL2=DFLOAT(I)-(Rtem(I)-1.D-2*Maxff)/(Rtem(I)-Rtem(I-1))
          ENDIF
        ENDIF
        IF (Rtem(STEPSF+1-I).GT.1.D-2*Maxff.AND.JU2.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JU2=DFLOAT(STEPSF)
          ELSE
            JU2=DFLOAT(STEPSF+1-I)+(Rtem(STEPSF+1-I)-1.D-2*Maxff) &
                /(Rtem(STEPSF+1-I)-Rtem(STEPSF+2-I))
          ENDIF
        ENDIF
        IF (Rtem(I).GT.1.D-3*Maxff.AND.JL4.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JL4=1.D0
          ELSE
            JL4=DFLOAT(I)-(Rtem(I)-1.D-3*Maxff)/(Rtem(I)-Rtem(I-1))
          ENDIF
        ENDIF
        IF (Rtem(STEPSF+1-I).GT.1.D-3*Maxff.AND.JU4.EQ.0.D0) THEN
          IF (I.EQ.1) THEN
            JU4=DFLOAT(STEPSF)
          ELSE
            JU4=DFLOAT(STEPSF+1-I)+(Rtem(STEPSF+1-I)-1.D-3*Maxff) &
                /(Rtem(STEPSF+1-I)-Rtem(STEPSF+2-I))
          ENDIF
        ENDIF
      ENDDO
    ENDIF
!U96:
  ENDIF
585 CONTINUE	!c93atest:
!93atest:
!	  IF (Mosdel.GT.0.D0) THEN
!       cffm(ip,1,2)=thminf	!c93atest: temp. (unchanged)
!       cffm(ip,7,2)=thmaxf	!c93atest: temp. (unchanged)
!       cffm(ip,2,2)=thminf+(thmaxf-thminf)*(JL2-1.D0)/DFLOAT(STEPSF-1)
!       cffm(ip,3,2)=thminf+(thmaxf-thminf)*(JLM-1.D0)/DFLOAT(STEPSF-1)
!       cffm(ip,5,2)=thminf+(thmaxf-thminf)*(JUM-1.D0)/DFLOAT(STEPSF-1)
!       cffm(ip,6,2)=thminf+(thmaxf-thminf)*(JU2-1.D0)/DFLOAT(STEPSF-1)
!	   temmax=ffpk(ip)
! 	   ffpk(ip)=cffm(ip,4,2)
!       cffm(ip,4,2)=temmax
!	   temmax=Maxff
!	   Maxff=cffm(ip,8,2)
!       cffm(ip,8,2)=temmax	!c93atest: temp.
!	  ENDIF
!93atest:-------------------------------------------------------------------
  IF (Mosdel.LE.0.D0) THEN
    JL1=JLM
    JU1=JUM
  ENDIF
  c1ff(ip)=thminf+(thmaxf-thminf)*(JL1-1.D0)/DFLOAT(STEPSF-1)
  c2ff(ip)=thminf+(thmaxf-thminf)*(JU1-1.D0)/DFLOAT(STEPSF-1)
  c1ff(ip+2)=thminf+(thmaxf-thminf)*(JL2-1.D0)/DFLOAT(STEPSF-1)
  c2ff(ip+2)=thminf+(thmaxf-thminf)*(JU2-1.D0)/DFLOAT(STEPSF-1)
  c1ff(ip+4)=thminf+(thmaxf-thminf)*(JL4-1.D0)/DFLOAT(STEPSF-1)
  c2ff(ip+4)=thminf+(thmaxf-thminf)*(JU4-1.D0)/DFLOAT(STEPSF-1)
!       cffm(ip,1,2)=thminf
!       cffm(ip,2,2)=thminf+(thmaxf-thminf)*(JL2-1.D0)/DFLOAT(STEPSF-1)
!       cffm(ip,3,2)=thminf+(thmaxf-thminf)*(JL1-1.D0)/DFLOAT(STEPSF-1)
!       cffm(ip,4,2)=ffpk(ip)
!       cffm(ip,5,2)=thminf+(thmaxf-thminf)*(JU1-1.D0)/DFLOAT(STEPSF-1)
!       cffm(ip,6,2)=thminf+(thmaxf-thminf)*(JU2-1.D0)/DFLOAT(STEPSF-1)
!       cffm(ip,7,2)=thmaxf
!       cffm(ip,8,2)=Maxff
!DEC92      WRITE(*,*) 'JU1,JL1=',JU1,JL1
!
!		Output reduced FFRC file: 5x fwhm
!
!test       WRITE(*,*) 'In,s,l,F,A,n=',Inext,Isum,Ilist,Fwrite(Inext)
!t     1   ,ANS,numstr(1:4)
  IF (Outfilesflag.GT.1) GOTO 601
  IF (Fwrite(Inext).EQ.Ilist.OR.ANS.EQ.2.OR.ANS.EQ.3) THEN ! profiles
    FILEIN2='FFRCT.'//numstr(1:4)
    OPEN (UNIT=8,FILE=dout//FILEIN2,STATUS='NEW')
    thff=ffpk(ip)-DABS(c2ff(ip)-c1ff(ip))*1.D+1
    IF (thff.GT.thminf.AND.Igraz.LE.0) THEN
      Chinit=DFLOAT(STEPSF-1)/(thmaxf-thminf)*(thff-thminf)+1.D0
    ELSE
      Chinit=1.D0
    ENDIF
    thff=ffpk(ip)+DABS(c2ff(ip)-c1ff(ip))*1.D+1
    IF (thff.LT.thmaxf.AND.Igraz.LE.0) THEN
      Chfin=DFLOAT(STEPSF-1)/(thmaxf-thminf)*(thff-thminf)+1.D0
    ELSE
      Chfin=DFLOAT(STEPSF)
    ENDIF
    Jbit4=IDINT((Chfin-Chinit)/1.D3)+1
    IF (Jbit4.EQ.0) THEN
      Jbit4=1
    ENDIF
    Jbit1=INT(Jbit4/10)+1
    Jbit=Jbit4
    DO J=IDNINT(Chinit),IDNINT(Chfin)   ! <=1000 output steps
      I=J
      IF (Jbit.EQ.Jbit4.OR.(Rtem(J).GT.Maxff*1.D-2 &
          .AND.Jbit.EQ.Jbit1)) THEN
        WRITE(8,588) Thtem(J),Rtem(J),Ttem(J),Ytem(J),Tabdy(I,1),Tabdy(I,4)
588     FORMAT(1X,2(1PE15.8,','),1PE13.6,',',1PE10.3,2(',',1PE8.2))
        Jbit=0
      ENDIF
      Jbit=Jbit+1
    ENDDO
    WRITE(*,600) numstr(1:4),IDNINT(Chinit),Thtem(IDNINT(Chinit)), &
        Rtem(IDNINT(Chinit)),Ttem(IDNINT(Chinit)), &
        Ytem(IDNINT(Chinit))
!UJun96:	,Tabdy(IDNINT(Chinit),1),Tabdy(IDNINT(Chinit),4)
!UJun96:   Tabdy compares dely (thin) to Dy/dely0 (thick) but not used now.
600 FORMAT(4X,' FFRC.',A4,' Output Ch.1,th,r,t,y:',I5,F9.5 &
        ,2(1PE12.5),1PE9.2)
    CLOSE(8,STATUS='KEEP')
601 ENDIF
!
  RETURN
END
!V--------------------------------------------------------------------------
!V	{MOSAVED(9) attached to MOSCURVAR/OLD 17/10/91}
! 	File containing functions defined for MOSCURVAR to give exact answers
!	for a general geometry, rather than using CTC's approximation, eqn.5.26
!	{Other edits also anticipated}.....Feb 1991. AV.
!	Function Definitions	{{FUNCTION_NAME:=CTC_NAME=AV_NAME}}
!	====================
!	XCHORD:=XXz  EMITCHORD:=BX=ET  EMITANG:=thetas=theta1
!	CRYSTALRAD:=GB1=2R  SOURCEANG:=AxisTh=theta_axis
! 	SOURCEDIS:=BXz=(bx)=(GB(6))  INCANG:=Temth1=theta1tem
!     ****except when VARFLAG.EQ.4 when they are redefined****
!
!V--------------------------------------------------------------------------
DOUBLE PRECISION FUNCTION &
     XCHORD(CRYSTALRAD,EMITANG,SOURCEANG,VAR4,VARFLAG)
!	 -------------------------------------------------
  IMPLICIT NONE
  DOUBLE PRECISION CRYSTALRAD,EMITANG,SOURCEANG,SEMITANG
  DOUBLE PRECISION VAR4,SOURCEDIS,INCANG
  INTEGER VARFLAG
!
  SEMITANG=SOURCEANG+EMITANG
  IF (VARFLAG.LT.4) THEN		!{exact,if INCANG known}
    INCANG=VAR4
    XCHORD=2.*CRYSTALRAD*DSIN(0.5*(SEMITANG-INCANG))
  ELSE IF (VARFLAG.EQ.4) THEN 	!{CTC's approximation}
    SOURCEDIS=VAR4
    INCANG=EMITANG	!{EMITANG calculated from XCHORD!}
    XCHORD=SOURCEDIS*DSIN(INCANG-SOURCEANG)/ &
        (DSIN(INCANG)-DCOS(INCANG-SOURCEANG)*SOURCEDIS/CRYSTALRAD)
  ELSE IF (VARFLAG.EQ.5) THEN
    SOURCEDIS=VAR4	!{long expression,for unknown INCANG}
    XCHORD=DSQRT(2.*CRYSTALRAD*SOURCEDIS*DSIN(SOURCEANG) &
        -2.*(SOURCEDIS*DCOS(EMITANG)-CRYSTALRAD*DSIN(SEMITANG) &
        +DSQRT(CRYSTALRAD**2-(SOURCEDIS*DSIN(EMITANG) &
        +CRYSTALRAD*DCOS(SEMITANG))**2)) &
        *CRYSTALRAD*DSIN(SEMITANG))
  ENDIF
  RETURN
END
!--------------------------------------------------------------------------
DOUBLE PRECISION FUNCTION &
     EMITANG(INCANG,SOURCEANG,CRYSTALRAD,SOURCEDIS,VARFLAG)
!	 ------------------------------------------------------
  IMPLICIT NONE
  DOUBLE PRECISION CRYSTALRAD,INCANG,SOURCEANG,SOURCEDIS
  DOUBLE PRECISION TEMTERM,XCHORD
  INTEGER VARFLAG
!
!VJUL:
!TC	IF (INCANG.LE.SOURCEANG) THEN  	!{SOURCEANG>INCANG}
!TC	  INCANG=SOURCEANG
!TC	  PRINT*, 'INCANG(temth)<SOURCEANG(Axisth)=>INCANG=SOURCEANG!X'
!TC	ENDIF
!VJUL	IF (VARFLAG.EQ.1) THEN  	!{SOURCEANG>INCANG}
!VJUL	  VARFLAG=0
!VJUL	  EMITANG=INCANG-SOURCEANG
!VJUL	ELSE
  IF (VARFLAG.EQ.2) THEN	!{source on R.C.}
    EMITANG=DACOS(DCOS(INCANG)/DCOS(SOURCEANG))
  ELSEIF (VARFLAG.EQ.3.OR.VARFLAG.EQ.5) THEN	!{general case}
    TEMTERM=SOURCEDIS-CRYSTALRAD*DSIN(SOURCEANG)
!	PRINT*,'SQRT=',(CRYSTALRAD*DSIN(INCANG)+SOURCEDIS)**2
!     +      -2.*CRYSTALRAD*SOURCEDIS*(DSIN(SOURCEANG)+DSIN(INCANG))
!	PRINT*,'COSTERM=',(CRYSTALRAD**2*DCOS(INCANG)*DCOS(SOURCEANG)
!     1     +DABS(TEMTERM)*DSQRT((CRYSTALRAD*DSIN(INCANG)+SOURCEDIS)**2
!     2      -2.*CRYSTALRAD*SOURCEDIS*(DSIN(SOURCEANG)+DSIN(INCANG))))
!     3     /((CRYSTALRAD*DCOS(SOURCEANG))**2+TEMTERM**2)
!	PRINT*,'CRYSTALRAD=',CRYSTALRAD,'INCANG=',INCANG,'SOURCEANG=',
!     1 		SOURCEANG,'SOURCEDIS=',SOURCEDIS,'TEMTERM=',TEMTERM
    EMITANG=DACOS((CRYSTALRAD**2*DCOS(INCANG)*DCOS(SOURCEANG) &
        +DABS(TEMTERM)*DSQRT((CRYSTALRAD*DSIN(INCANG)+SOURCEDIS)**2 &
        -2.*CRYSTALRAD*SOURCEDIS*(DSIN(SOURCEANG)+DSIN(INCANG)))) &
        /((CRYSTALRAD*DCOS(SOURCEANG))**2+TEMTERM**2))
  ELSE IF (VARFLAG.EQ.4) THEN	!{CTC's/inverted case}
    XCHORD=SOURCEDIS
    EMITANG=SOURCEANG-INCANG-2.*DASIN(XCHORD/2./CRYSTALRAD)
  ENDIF
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENGEOM(XCHORD1,XCHORD2,EMITANG1,EMITANG2, &
     CRYSTALRAD,SOURCEANG,SOURCEDIS,INCANG,VARFLAG)
!	=====================================================
!	Subroutine outputting two emission angles and the corresponding
!	on-crystal chord-lengths for a given incident angle
!
  IMPLICIT NONE
  DOUBLE PRECISION XCHORD,XCHORD1,XCHORD2,AXCHORD(4),TXCHORD, &
      CRYSTALRAD,SOURCEDIS		!{lengths in .1mu}
  DOUBLE PRECISION EMITANG,EMITANG1,EMITANG2,AEMITANG(4),TEMITANG, &
      INCANG,SOURCEANG		!{angles in radians}
  INTEGER TEMFLAG,VARFLAG,I,J
!
  AEMITANG(1)=EMITANG(INCANG,SOURCEANG,CRYSTALRAD,SOURCEDIS,VARFLAG)
  AEMITANG(2)=-AEMITANG(1)
!
  DO, I=1,2
    AXCHORD(I)=XCHORD(CRYSTALRAD,AEMITANG(I),SOURCEANG,INCANG,2)
!ONTINUE
  ENDDO
!
  XCHORD1=AXCHORD(1)
  XCHORD2=AXCHORD(2)
  EMITANG1=-AEMITANG(1)
  EMITANG2=-AEMITANG(2)
!test	DO 40, I=1,2
!	  PRINT*,I,AXCHORD(I),AEMITANG(I)
! 40	CONTINUE
  RETURN
END
!--------------------------------------------------------------------------
!--------------------------------------------------------------------------
SUBROUTINE GENGEOMC(XXC1,XXC2,EANGC1,EANGC2, &
     ThetaaC1,ThetaaC2,GB1,Axisth,GB6,Thincgx,ABtem,THABX &
     ,THBAX,THABXpa,THABXpb,Isect1,Isect2)
!	=====================================================
!	Subroutine outputting abs. min. two (of four) (on-Generatrix)
!	 on-crystal arc-lengths (XX), source/emission angles (th1),
!	 and angles to crystal centre (thetaa) for a given incident angle
!	 (thincgx); XX,thetaa +ve to left of Axis (i.e. along D'X);
!	 th1 +ve to right of Axis (anticlockwise)
!
  IMPLICIT NONE
  DOUBLE PRECISION XXC1,XXC2	 &! best onGx onX XX
      ,EANGC1,EANGC2			 &! best th1
      ,ThetaaC1,ThetaaC2		 &! best thetaap
      ,GB1,Axisth,GB6 &
      ,Thincgx				 &! incident angle
      ,ABtem				 &!{lengths in .1mu}
      ,THABX				 &! for Axisth
      ,THBAX				 &! for Axisth
      ,THABXpa,THABXpb			! best two THABXp
  INTEGER Isect1,Isect2
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
  DOUBLE PRECISION THABXp,THABXp2	! ABX' {angles in radians}
  DOUBLE PRECISION XXt(4)	 &! four values of XX for surf.thinc
      ,thetaat(4)		 &! four thetaap for surf.thinc
      ,THABXp4(4)		 &! four thabxp
      ,EANGt(4)		! four th1 for surf.thinc
  INTEGER I
!
  THABXp2=DASIN(DCOS(Thincgx)*DABS(GB1)/ABtem) ! soln beyond M (AJV)
  IF (GB1.GT.ABtem) THEN
    THABXp=DPI-THABXp2		! MDprime solution (CTC,B,S2,S4)
  ELSE
    THABXp=THABXp2			! No diff. for Laue/GB1<0
  ENDIF
  THABXp4(1)=THABXp
  THABXp4(3)=THABXp
  THABXp4(2)=THABXp2
  THABXp4(4)=THABXp2
  IF (GB1.GT.ABtem) THEN		! th1 computation:
    EANGt(1)=THABX-THABXp
    EANGt(2)=THABX-THABXp2
    EANGt(3)=THABX+THABXp-2.D0*DPI	! beyond Dprime (sector 3)
    EANGt(4)=THABX+THABXp2		! beyond Mprime (sector 4) -2.D0*DPI
!B        1=THABX-THABXp
!B        2=THABX-THABXp
!B        3=THABX+THABXp-2.D0*DPI
!B        4=THABX+THABXp		! coming from S2
  ELSE			! sign +ve, ANTI-CL(same as GB1>0;vs earlier)
    EANGt(1)=THABX-THABXp
    EANGt(2)=THABX-THABXp2
    EANGt(3)=THABX+THABXp	! beyond Dprime (S3 from S1) +2.D0*DPI from S2
    EANGt(4)=THABX+THABXp2	! beyond Mprime (S4 from S2) +2.D0*DPI from S1
!L        1=THABXp-THABX	! a bit ugly since XX(th1) 2-valued
!L        2=THABXp-THABX	! cf. S1=1: THABX+THABXp+2Mininc-dpi
!L        3=-THABX-THABXp	! THABXp already OK (assume S1=1)
!L        4=-THABX-THABXp	! THABXp already OK (assume S1=2)
  ENDIF
!B
  IF (GB1.GT.ABtem) THEN			! thap=thbax'-/+thbax
    DO I=1,2
      thetaat(I)=AxisTh-Thincgx-EANGt(I)	! thap clockwise, with XX
    ENDDO
    thetaat(3)=AxisTh+Thincgx-DPI-EANGt(3)
    thetaat(4)=AxisTh+Thincgx+DPI-EANGt(4)
  ELSE
    thetaat(1)=THBAX-(DPIo2-THABXp+Thincgx)
    thetaat(2)=THBAX-(DPIo2-THABXp2-Thincgx)
    thetaat(3)=DPIo2-THABXp+Thincgx+THBAX-2.D0*DPI
    thetaat(4)=(DPIo2-THABXp2-Thincgx+THBAX)
  ENDIF
!L
  DO I=1,4
    XXt(I)=DABS(GB1)*thetaat(I)		! arclength
!       XXt(I)=2.D0*GB1*DSIN(thetaat(I)/2.D0)	! chord
  ENDDO
!TC		Choose best/closest solution:
  IF (DABS(XXt(1)).LE.DMIN1(DABS(XXt(2)),DABS(XXt(3)) &
      ,DABS(XXt(4)))) THEN
    Isect1=1
    IF (DABS(XXt(2)).LE.DMIN1(DABS(XXt(3)),DABS(XXt(4)))) THEN
      Isect2=2
    ELSEIF (DABS(XXt(3)).LE.DABS(XXt(4))) THEN
      Isect2=3
    ELSE
      Isect2=4
    ENDIF
  ELSEIF (DABS(XXt(2)).LE.DMIN1(DABS(XXt(3)),DABS(XXt(4)))) THEN
    Isect1=2
    IF (DABS(XXt(1)).LE.DMIN1(DABS(XXt(3)),DABS(XXt(4)))) THEN
      Isect2=1
    ELSEIF (DABS(XXt(3)).LE.DABS(XXt(4))) THEN
      Isect2=3
    ELSE
      Isect2=4
    ENDIF
  ELSEIF (DABS(XXt(3)).LE.DABS(XXt(4))) THEN
    Isect1=3
    IF (DABS(XXt(1)).LE.DMIN1(DABS(XXt(2)),DABS(XXt(4)))) THEN
      Isect2=1
    ELSEIF (DABS(XXt(2)).LE.DABS(XXt(4))) THEN
      Isect2=2
    ELSE
      Isect2=4
    ENDIF
  ELSE
    Isect1=4
    IF (DABS(XXt(2)).LE.DMIN1(DABS(XXt(3)),DABS(XXt(1)))) THEN
      Isect2=2
    ELSEIF (DABS(XXt(3)).LE.DABS(XXt(1))) THEN
      Isect2=3
    ELSE
      Isect2=1
      thetaaC2=thetaat(1)
      EANGC2=EANGt(1)
    ENDIF
  ENDIF
  XXC1=XXt(Isect1)
  thetaaC1=thetaat(Isect1)
  EANGC1=EANGt(Isect1)
  THABXpa=THABXp4(Isect1)
  XXC2=XXt(Isect2)
  thetaaC2=thetaat(Isect2)
  EANGC2=EANGt(Isect2)
  THABXpb=THABXp4(Isect2)
!92		Versus old structure:
!V	AEMITANG(1)=EMITANG(INCANG,SOURCEANG,CRYSTALRAD,SOURCEDIS,VARFLAG)
!V	AXCHORD(I)=XCHORD(CRYSTALRAD,AEMITANG(I),SOURCEANG,INCANG,2)
!V	XCHORD1=AXCHORD(1)
!V	EMITANG1=-AEMITANG(1)
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENGEOMS(XXC1,XXC2,EANGC1,EANGC2, &
     ThetaaC1,ThetaaC2,GB1,Axisth,GB6,Thincgx,ABtem,THABX &
     ,THBAX,THABXpa,THABXpb,Isect1,Isect2)
!    ===================================================================
!      Subroutine outputting abs. min. two (of four) (on-Generatrix)
!	on-crystal chord-lengths (XX), source/emission angles (th1),
!	and angles to crystal centre (thetaa) for a given incident angle
!	(thincgx); XX,thetaa +ve to left of Axis (i.e. along D'X);
!	th1 +ve to right of Axis (anticlockwise)
!	********  WITH SECTORS DEFINED	********
  IMPLICIT NONE
  DOUBLE PRECISION XXC1,XXC2	 &! best onGx onX XX OUTPUT
      ,EANGC1,EANGC2			 &! best th1 OUTPUT
      ,ThetaaC1,ThetaaC2		 &! best thetaap OUTPUT
      ,GB1,Axisth,GB6			 &! input
      ,Thincgx				 &! incident angle
      ,ABtem				 &!{lengths in .1mu}
      ,THABX				 &! for Axisth
      ,THBAX				 &! for Axisth
      ,THABXpa,THABXpb			! best two THABXp OUTPUT
  INTEGER Isect1,Isect2
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
  DOUBLE PRECISION THABXp,THABXp2	! ABX' {angles in radians}
  DOUBLE PRECISION XXt(4)	 &! four values of XX for surf.thinc
      ,thetaat(4)		 &! four thetaap for surf.thinc
      ,THABXp4(4)		 &! four thabxp
      ,EANGt(4)		! four th1 for surf.thinc
  INTEGER I
!
  THABXp2=DASIN(DMIN1(DCOS(Thincgx)*DABS(GB1)/ABtem,1.D0))
!L					! soln beyond Mininc (AJV)
  IF (GB1.GT.ABtem) THEN
    THABXp=DPI-THABXp2		! MDprime solution (CTC,B,S2,S4)
  ELSE
    THABXp=THABXp2			! No diff. for Laue/GB1<0
  ENDIF
  THABXp4(1)=THABXp
  THABXp4(3)=THABXp
  THABXp4(2)=THABXp2
  THABXp4(4)=THABXp2
  IF (GB1.GT.ABtem) THEN		! th1 computation:
    EANGt(1)=THABX-THABXp
    EANGt(2)=THABX-THABXp2
    EANGt(3)=THABX+THABXp-2.D0*DPI	! beyond Dprime (sector 3)
    EANGt(4)=THABX+THABXp2		! beyond Mprime (sector 4) -2.D0*DPI
!B        1=THABX-THABXp
!B        2=THABX-THABXp
!B        3=THABX+THABXp-2.D0*DPI
!B        4=THABX+THABXp		! coming from S2
  ELSE			! sign +ve, ANTI-CL(same as GB1>0;vs earlier)
    EANGt(1)=THABX-THABXp
    EANGt(2)=THABX-THABXp2
    EANGt(3)=THABX+THABXp	! beyond Dprime (S3 from S1) +2.D0*DPI from S2
    EANGt(4)=THABX+THABXp2	! beyond Mprime (S4 from S2) +2.D0*DPI from S1
!L        1=THABXp-THABX	! a bit ugly since XX(th1) 2-valued
!L        2=THABXp-THABX	! cf. S1=1: THABX+THABXp+2Mininc-dpi
!L        3=-THABX-THABXp	! THABXp already OK (assume S1=1)
!L        4=-THABX-THABXp	! THABXp already OK (assume S1=2)
  ENDIF
!B
  IF (GB1.GT.ABtem) THEN			! thap=thbax'-/+thbax
    DO I=1,2
      thetaat(I)=AxisTh-Thincgx-EANGt(I)	! thap clockwise, with XX
    ENDDO
    thetaat(3)=AxisTh+Thincgx-DPI-EANGt(3)
    thetaat(4)=AxisTh+Thincgx+DPI-EANGt(4)
  ELSE
    thetaat(1)=THBAX-(DPIo2-THABXp+Thincgx)
    thetaat(2)=THBAX-(DPIo2-THABXp2-Thincgx)
    thetaat(3)=DPIo2-THABXp+Thincgx+THBAX-2.D0*DPI
    thetaat(4)=(DPIo2-THABXp2-Thincgx+THBAX)
  ENDIF
!L
  DO I=1,4
    XXt(I)=DABS(GB1)*thetaat(I)		! arclength
!       XXt(I)=2.D0*GB1*DSIN(thetaat(I)/2.D0)	! chord
  ENDDO
!TC		Give both closest solutions:
  XXC1=XXt(Isect1)
  thetaaC1=thetaat(Isect1)
  EANGC1=EANGt(Isect1)
  THABXpa=THABXp4(Isect1)
  XXC2=XXt(Isect2)
  thetaaC2=thetaat(Isect2)
  EANGC2=EANGt(Isect2)
  THABXpb=THABXp4(Isect2)
  RETURN
END
!--------------------------------------------------------------------------
!--------------------------------------------------------------------------
SUBROUTINE GENXYS(YNZ,Theta3,detflag,xline, &
     Thetaap2,GB1,Axisth,Thout,Cx,Rzf,Isect1)
!==========================================================================
!      Subroutine deriving YNZ,Theta3 and detflag
!	as function of Thetaap2(output locn), Thout(output angle),
!	general geometry,
!	********  WITH SECTORS DEFINED	********
!
  IMPLICIT NONE
  DOUBLE PRECISION YNZ,Theta3	 &! Output
      ,Thetaap2			 &! Input
      ,xline,GB1,Axisth &
      ,Thout				 &! Input
      ,Cx,Rzf				!{lengths in .1mu, angles in radians}
  INTEGER Isect1,detflag
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
  DOUBLE PRECISION Temxl,sqrxl,CTheta2,Theta2,Thsurf
!	 Old calcn, neglecting defocussing,...:
!91err:  Temxl=DSIN(Temth+aplane)-DSIN(Temth+aplane-Thetaa)*(.5D0-Cx/GB(1))
!	 xline=GB(1)*(Temxl+DSQRT(Temxl*Temxl+(DCOS(Thetaap2)-1.)))
!	 Theta2=DACOS(2.*DCOS(Thetaap2)-1.-xline/GB(1)*2.
!     1    *DSIN(Thout-Thetaap2))      ! mean for some rays
!	 Yiz=GB(1)*Theta2/2.
!
!plate96      WRITE(*,*) 'Thetaap2 in GENXYZ',Thetaap2 
  IF (Isect1.LE.2) THEN
    Thsurf=Thout
  ELSE			! not sure about Sector 4 ...
    Thsurf=DPI-Thout
  ENDIF
  Temxl=DSIN(Thsurf)-DSIN(Thsurf-Thetaap2)*(.5D0-Cx/GB1)
  sqrxl=Temxl*Temxl+DCOS(Thetaap2) &
      -1.25D0+(Rzf*Rzf-Cx*Cx+Cx*GB1*(1.D0 &
      +2.D0*DCOS(Thetaap2)))/GB1/GB1
  IF (sqrxl.LT.0.D0) THEN
    detflag=1 			! rays not focussed on RC/detector
  ELSE
    detflag=0
    xline=GB1*(Temxl+DSQRT(sqrxl))
    CTheta2=GB1/Rzf*(DCOS(Thetaap2)-.5D0)-xline/Rzf &
        *DSIN(Thsurf-Thetaap2)-Cx/Rzf
    IF (CTheta2.GT.1.D0) THEN	! test for imag. angles/DPI precision
      Theta2=0.D0
    ELSEIF (CTheta2.LT.-1.D0) THEN
      Theta2=DPI
    ELSE
      Theta2=DACOS(CTheta2)	! could be wrong sign
    ENDIF
    YNZ=Rzf*Theta2
    Theta3=Theta2/2.D0+thetaap2      ! HALF OF ARC!!!
  ENDIF
  IF (detflag.EQ.1) GOTO 101
!debug	  WRITE(*,*)'DETFLAG',detflag
!debug	  WRITE(*,100) YNZ,Thout,Thetaap2,Isect1
!debug100   FORMAT('GENXYS=>YNZ,Thout,Thetaap2 is',(1PE15.8)1X(1PE15.8)1X(1PE15.8)1XI2)	  
!
!V			detector update:
!      thetaob=0.D0
!      ThetaD=DPI-2*AxisTh
!      XD0=((GB(1)*DCOS(Temth) - (GB(1)/2.-Cx)*DCOS(Temth+Thetaap2v))/
!     1DSIN(Temth-ThetaD-Thetaap2v)) - (Rzf/DTAN(Temth-ThetaD-Thetaap2v))
!V
!      XD0=DSQRT(Rzf**2+(GB(1)+Cx)**2-2.*Rzf*(GB(1)+Cx)*DCOS(ThetaD))*
!     1 (GB(1)*DCOS(Temth) - (0.5*GB(1)-Cx)*DCOS(Temth+Thetaap2v)
!     2 - Rzf*DCOS(Temth-ThetaD-Thetaap2v-Thetaob))/
!     3 (Rzf*DSIN(Temth-ThetaD-Thetaap2v-Thetaob)
!     4 -(GB(1)+Cx)*DSIN(Temth-Thetaap2v-Thetaob))
!V			! detector squiggle
!      XD0=((GB(1)*DCOS(Temth+aplane) - (GB(1)/2.-Cx)*DCOS(Temth+aplane
!     1 +Thetaap2v))/
!     2 DSIN(Temth+aplane-ThetaD-Thetaap2v)) - (Rzf/DTAN(Temth+aplane
!     3 -ThetaD-Thetaap2v))
!	XD0=DSQRT(Rzf**2+(GB(1)+Cx)**2-2.*Rzf*(GB(1)+Cx)*DCOS(ThetaD))*
!     1 	(GB(1)*DCOS(Temth+aplane) - (0.5*GB(1)-Cx)*DCOS(Temth
!     2   +aplane+Thetaap2v)- Rzf*DCOS(Temth+aplane-ThetaD-Thetaap2v))/
!     3   (Rzf*DSIN(Temth+aplane-ThetaD-Thetaap2v-Thetaob)
!     4	  -(GB(1)+Cx)*DSIN(Temth+aplane-Thetaap2v-Thetaob))
!V			Detector limits?
!      XDmin=((GB(1)*DCOS(Thmino) - (GB(1)/2.-Cx)*DCOS(Thmino+Thetaap2v))/
!     1DSIN(Thmino-ThetaD-Thetaap2v)) - (Rzf/DTAN(Thmino-ThetaD-Thetaap2v))
!      XDmax=((GB(1)*DCOS(Thmaxo) - (GB(1)/2.-Cx)*DCOS(Thmaxo+Thetaap2v))/
!     1DSIN(Thmaxo-ThetaD-Thetaap2v)) - (Rzf/DTAN(Thmaxo-ThetaD-Thetaap2v))
!V	XDmin=DSQRT(Rzf**2+(GB(1)+Cx)**2-2.*Rzf*(GB(1)+Cx)*DCOS(ThetaD))*
!     1  (GB(1)*DCOS(Thmino) - (0.5*GB(1)-Cx)*DCOS(Thmino+Thetaap2v)
!     2  - Rzf*DCOS(Thmino-ThetaD-Thetaap2v))/
!     3  (Rzf*DSIN(Thmino-ThetaD-Thetaap2v-Thetaob)
!     4	 -(GB(1)+Cx)*DSIN(Thmino-Thetaap2v-Thetaob))
!	XDmax=DSQRT(Rzf**2+(GB(1)+Cx)**2-2.*Rzf*(GB(1)+Cx)*DCOS(ThetaD))*
!     1  (GB(1)*DCOS(Thmaxo) - (0.5*GB(1)-Cx)*DCOS(Thmaxo+Thetaap2v)
!     2  - Rzf*DCOS(Thmaxo-ThetaD-Thetaap2v))/
!     3  (Rzf*DSIN(Thmaxo-ThetaD-Thetaap2v-Thetaob)
!     4	 -(mistakeGB(1)+Cx)*DSIN(Thmaxo-Thetaap2v-Thetaob))
!V
101 RETURN
END
!-------------------------------------------------------------------------
!plate96
!
SUBROUTINE PLATEFUNC (Detx,Thout,Cryrad,Cx,Axisth,Thetaap2, &
     Detarmlen,Dettheta,Detbeta,Rplate) 
!
!**********Generates location of rays on flat detector plate*************
! at present does not consider off axis rays and the shift associated
  IMPLICIT NONE
!plate96 Cryrad is GB(1) radius of curvature of crystal

  DOUBLE PRECISION Thout     ![INPUT] angle x-ray exits crystal with respect to the tangent line
                             !        of the crystal surface at the exit position
  DOUBLE PRECISION Thetaap2  ![INPUT] angle between the crystal pole and the x-ray exits position
                             !        measured from the center of curvature of the crystal (equivalent to s/Cryrad)
  DOUBLE PRECISION Cryrad    ![INPUT] radius of curvature of crystal
  DOUBLE PRECISION Cx        ![INPUT] misalignment of the crystal pole with axis of rotation of the detector
  DOUBLE PRECISION Axisth    ![INPUT] NOT USED  
  DOUBLE PRECISION Detx	     ![OUTPUT] position of ray on flat plate
  DOUBLE PRECISION Detarmlen ![INPUT] length of detector arm 
  DOUBLE PRECISION Detbeta   ![INPUT] angle of detector plate to detector arm,ideal=0 deg
  DOUBLE PRECISION Rplate    ![INPUT] Calc'd distance from centre of Rowland to centre of DETECTOR
  DOUBLE PRECISION Dettheta  ![INPUT] Calc'd angle of detector to crystal pole mesaured from the center of the Roland circle
                             !        (equivalent to AV's ThetaD)
  DOUBLE PRECISION Rowland   ! Rowland circle radius = Cryrad/2
!LFS  DOUBLE PRECISION Defocus ! diff between detector position and Rowland circle
!LFS  DOUBLE PRECISION Detphi  !angle of detector arm to incident radiation=(two theta)/2
!LFS!plate96                  !Detphi == Axisth if detector is well centered

! If Axisth was set but Rplate and Dettheta were not calulated then the following six lines are useful
!  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
!      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
!      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!  Rplate   = DSQRT((Cryrad/2.D0+Cx)**2 + Detarmlen**2 - 2.0D0*(Cryrad/2.D0+Cx)*Detarmlen*DCOS(DPIo2-Axisth))
!  Dettheta = DASIN(Detarmlen*DSIN(DPIo2-Axisth)/Rplate)

  Rowland = Cryrad/2.0D0
  Detx = -Detarmlen* &
      (Cryrad*DCOS(Thout) - (Rowland-Cx)*DCOS(Thout-Thetaap2) &
      - Rplate*DCOS(Thout-Dettheta-Thetaap2))/ &
      (Rplate*DSIN(Detbeta-Thout+Dettheta+Thetaap2) &
      - (Rowland+Cx)*DSIN(Detbeta-Thout+Thetaap2))	
  
  RETURN
END
!-------------------------------------------------------------------------
SUBROUTINE GENXPZ (Xoz,theta3,PDEL,Thetaap2 &
     ,TRz,Axisth,thog,THABX,THBAX,PZ,T2,Isect2,detflag)
!
!L	       Generates plate location est.=f(diff.angle)
!	********  WITH SECTORS DEFINED	********
  IMPLICIT NONE
  DOUBLE PRECISION Xoz	 &! Transverse shift along plate. Output
      ,theta3			 &! incident angle on plate/film. Output
      ,PDEL			 &! equiv. of xline: Y'P. Output
      ,Thetaap2		 &! shift of Thetaa
      ,THABX,Axisth		 &! alignment settings
      ,THBAX			! triangle, axisth
  DOUBLE PRECISION thog	 &! incident angle (outgoing) (allows for a/s)
      ,TRz			 &! Crystal Radius
      ,PZ			 &! Plate z from z=0 at entrant crystal surface
      ,T2			! Thickness /depth from which ray drawn..
  INTEGER detflag		 &! error flag (redundant)
      ,Isect2			! Laue sector = 2/4?
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!L
  DOUBLE PRECISION ThetaaT,Thetaout
!L		really dpio2-thsg-thabx'' but latter not passed..
!      IF (Isect2.LE.2) THEN
!       ThetaaT=Dpio2-Thetaap2+Axisth+THABX
!      ELSE
  ThetaaT=Thetaap2-THBAX		! cf. -Dpio2+Axisth+THABX
!      ENDIF
  IF (Isect2.LE.2) THEN
    Thetaout=ThetaaT+Thog-DPIo2	! thap<0
  ELSE
    Thetaout=ThetaaT-Thog+DPIo2	! thap>0
  ENDIF
  PDEL=(PZ+TRz-(TRz+T2)*DCOS(ThetaaT))/DCOS(Thetaout)
  Xoz=(-(TRz+T2)*DSIN(ThetaaT)-DSIN(Thetaout)*PDEL)
  theta3=Dpio2-Thetaout
  RETURN
END
!L
!--------------------------------------------------------------------------
SUBROUTINE GENTHSF(sinTemth0,cosTemth0,sinaplane,cosaplane &
     ,sinalpha,cosalpha,sinTemths)
!	       Generates sin(inc.ang.to surface)=f(diff.angle)
  IMPLICIT NONE
  DOUBLE PRECISION sinTemth0,cosTemth0	 &! diffracting angle
      ,sinaplane,cosaplane			 &! angle of planes to surface
      ,sinalpha,cosalpha			 &! angle to Gx(aplane maxm)
      ,sinTemths				! angle to surface
!
  IF (cosalpha.EQ.0.D0) THEN
    sinTemths=sinTemth0/cosaplane
  ELSE
    sinTemths=DABS(cosaplane*sinTemth0-sinaplane*cosalpha &
        *DSQRT(cosTemth0*cosTemth0-sinaplane*sinalpha* &
        sinaplane*sinalpha)) &
        /(1.D0-sinaplane*sinalpha*sinaplane*sinalpha)
  ENDIF
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENTHDF(sinTemths,cosTemths,sinaplane,cosaplane &
     ,sinalpha,cosalpha,sinTemth0)
!	       Generates sin(diff.angle)=f(inc.ang.to surface)
  IMPLICIT NONE
  DOUBLE PRECISION sinTemth0	 &! diffracting angle, OUTPUT
      ,sinaplane,cosaplane		 &! angle of planes to surface
      ,sinalpha,cosalpha		 &! angle to Gx(aplane maxm)
      ,sinTemths,costemths		! angle to surface
!L				        -0 for B???
  sinTemth0=DABS(sinTemths*cosaplane+ &
      sinaplane*cosalpha*cosTemths)
!L			Note: ALWAYS EXACT IF alpha=alphaAz-phi...
!92       sinTemth0g=DSIN(Temths)*cosaplane
!     1  +sinaplane*cosalpha*DCOS(Temths)
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENTHDGEL(sinTemthg,cosalpha,sinTemths)
!	Generates sin(full(diff)angle)=f(cpt on Generatrix)
!       FOR alpha(EL) = angle of elevation, defined by
!	 tanalpha(EL) = west/(xline+BX+XY+YZ)=(h-z)/BX
!	cf. alpha(AZ) = azimuthal angle at local crystal surface
!	 tanalpha(AZ) = tanalpha(EL) / costheta_CPT
!
  IMPLICIT NONE
  DOUBLE PRECISION sinTemths	 &! full / real angle
      ,cosalpha			 &! angle to Gx(aplane maxm)
      ,sinTemthg			! angle to surface
!
  sinTemths=sinTemthg*cosalpha
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENTHGDEL(sinTemths,cosalpha,sinTemthg,Temthg)
!	Generates sin(angle cpt on Generatrix)=f(full(diff)angle)
!       FOR alpha(EL) = angle of elevation, defined by
!	 tanalpha(EL) = west/(xline+BX+XY+YZ)=(h-z)/BX
!	cf. alpha(AZ) = azimuthal angle at local crystal surface
!	 tanalpha(AZ) = tanalpha(EL) / costheta_CPT
  IMPLICIT NONE
  DOUBLE PRECISION sinTemths	 &! full / real angle
      ,cosalpha			 &! angle to Gx(aplane maxm)
      ,sinTemthg,Temthg		! angle to surface
!
  sinTemthg=sinTemths/cosalpha
  Temthg=DASIN(sinTemthg)
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENTHDGAZ(Temthg,cosalpha,Temths)
!	Generates (full(diff)angle)=f(cpt on Generatrix)
!	FOR alpha(AZ) = azimuthal angle at local crystal surface
!	 tanalpha(AZ) = tanalpha(EL) / costheta_CPT
!       cf. alpha(EL) = angle of elevation, defined by
!	 tanalpha(EL) = west/(xline+BX+XY+YZ)=(h-z)/BX
!
  IMPLICIT NONE
  DOUBLE PRECISION Temths	 &! full / real angle
      ,cosalpha		 &! angle to Gx(aplane maxm)
      ,Temthg			! angle to surface
!
  Temths=DATAN(DTAN(Temthg)*cosalpha)
!92	Hence major errors in following code for Temthsg, Yozest et al.
!	 WHEN aplane and dalpha are large from:
!ERROR      Temthog=DASIN(sinTh/DCOS(dalpha))+aplane
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENTHGDAZ(Temths,cosalpha,Temthg)
!	Generates (angle cpt on Generatrix)=f(full(diff)angle)
!	FOR alpha(AZ) = azimuthal angle at local crystal surface
!	 tanalpha(AZ) = tanalpha(EL) / costheta_CPT
!       cf. alpha(EL) = angle of elevation, defined by
!	 tanalpha(EL) = west/(xline+BX+XY+YZ)=(h-z)/BX
  IMPLICIT NONE
  DOUBLE PRECISION Temths	 &! full / real angle
      ,cosalpha		 &! angle to Gx(aplane maxm)
      ,Temthg			! angle to surface
!
  Temthg=DATAN(DTAN(Temths)/cosalpha)	! if alpha='azimuthal'
!	      !  alpha (in aplane derivation) IS 'azimuthal' !
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENTHSG(sinTemth0,cosTemth0,sinaplane,cosaplane &
     ,sinalpha,cosalpha,Mininc,sinTemths,sinTemtho &
     ,Temths,Temthsg,Temth0g,Temtho,Temthog)	! on Gx to/from surface
!     =================================================================
!	Subroutine relating input (incident angle to diffracting planes)
!	 to incident and output angles at surface off and on Gx
!
  IMPLICIT NONE
  DOUBLE PRECISION &
      sinTemth0,cosTemth0	 &! angle to diff planes, off Gx
      ,sinaplane,cosaplane	 &! angle of plane to surface, assumed ON GX
      ,sinalpha,cosalpha	 &! SURFACE azimuthal angle from Gx
      ,Mininc	 &! minimum angle to surface
      ,sinTemths,Temths	 &! incident angle off Gx to surface
      ,Temthsg	 &! incident angle cpt on Gx to surface
      ,Temth0g	 &! revised diff angle if limited by mininc
      ,sinTemtho,Temtho	 &! outgoing angle off Gx from surface
      ,Temthog	! outgoing angle cpt on Gx (no RI corrns...)
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  DOUBLE PRECISION cosTemths,sinTemth0g,cosTemth0g
!
!92   Note: sin(theta.inc.diff.planes)=sin(thetaB+RI+/-range)
!	=sinTh (+RI+/-range)
!	=sin(theta.inc.full)cos(alpha.plane)
!	+sin(alpha.plane(assumed aligned with Gx))
!	*cos(dalpha)cos(theta.inc.full)
!     WHILE sin(theta.inc(surface,cpt on Gx))=sin(theta.inc.full)cos(dalpha)
!     HENCE ? angle off Gx, on surface, versus off Gx, on diff.planes==
  CALL GENTHSF(sinTemth0,cosTemth0,sinaplane,cosaplane &
      ,sinalpha,cosalpha,sinTemths)
  Temths=DASIN(sinTemths)
  CALL GENTHGDAZ(Temths,cosalpha,Temthsg)
  Temthsg=DMAX1(Temthsg,Mininc) !min cpt on Gx
  Temthsg=DMIN1(Temthsg,DPIo2)
!92		Hence effective minimum diffracting angle is:
  IF (temthsg.EQ.Mininc.OR.temthsg.EQ.DPIo2) THEN
    CALL GENTHDGAZ(Temthsg,cosalpha,Temths)
    sinTemths=DSIN(Temths)
    cosTemths=DCOS(Temths)
    CALL GENTHDF(sinTemths,cosTemths,sinaplane,cosaplane,sinalpha &
        ,cosalpha,sinTemth0g)		! thdiff simeq ths+aplane
    Temth0g=DASIN(sinTemth0g)
    cosTemth0g=DCOS(Temth0g)
  ELSE
    Temth0g=DASIN(sinTemth0)
    sinTemth0g=sinTemth0
    cosTemth0g=cosTemth0
  ENDIF
  CALL GENTHSF(sinTemth0g,cosTemth0g,-sinaplane,cosaplane,sinalpha &
      ,cosalpha,sinTemtho)
  Temtho=DASIN(sinTemtho)
  CALL GENTHGDAZ(Temtho,cosalpha,Temthog)
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENTHD(Temthsg,sinaplane,cosaplane &
     ,sinalpha,cosalpha,sinth,sinths,sinTho &
     ,Temths,sin0d,Temth0d,Temtho,Temthog)	! on Gx to/from surface
!     =================================================================
!	Subroutine relating input (incident angle at surface on Gx)
!	to incident angle to diffracting planes off Gx
!	and output angle to surface off and on Gx
!
  IMPLICIT NONE
  DOUBLE PRECISION &
      Temthsg,            &! incident angle cpt on Gx to surface
      sinaplane,cosaplane &! angle of plane to surface, assumed ON GX
      ,sinalpha,cosalpha  &! SURFACE azimuthal angle from Gx
      ,sinth               ! Bragg angle
  DOUBLE PRECISION   &! OUTPUTS:
      sinths,Temths  &! incident angle off Gx to surface
      ,Temth0d       &! diff angle, off Gx
      ,sin0d         &! sin(diff angle, off Gx)
      ,sintho,Temtho &! outgoing angle off Gx from surface
      ,Temthog        ! outgoing angle cpt on Gx (no RI corrns...)
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  DOUBLE PRECISION cosths
!
  CALL GENTHDGAZ(Temthsg,cosalpha,Temths)
  sinths=DSIN(Temths)
  cosths=DCOS(Temths)
  CALL GENTHE(sinths,cosths,sinaplane,cosaplane &
      ,sinalpha,cosalpha,sinth,sinTho &
      ,sin0d,Temth0d,Temtho)	! on Gx to/from surface
  CALL GENTHGDAZ(Temtho,cosalpha,Temthog)
!Ltest      WRITE(*,*) sinths,Temth0d,Temtho
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE GENTHE(sinths,cosths,sinaplane,cosaplane &
     ,sinalpha,cosalpha,sinth,sinTho &
     ,sin0d,Temth0d,Temtho)	! on Gx to/from surface
!     =================================================================
!	Subroutine relating input (incident angle at surface on Gx)
!	to diffracting and output angles off Gx
!
  IMPLICIT NONE
  DOUBLE PRECISION &
      sinths,cosths		 &! incident angle off Gx to surface
      ,sinaplane,cosaplane	 &! angle of plane to surface, assumed ON GX
      ,sinalpha,cosalpha	 &! SURFACE azimuthal angle from Gx
      ,sinth			! Bragg angle
  DOUBLE PRECISION           &! OUTPUTS:
      Temth0d			 &! diff angle, off Gx i=r at peak ONLY
      ,sin0d,cos0d		 &! sin(diff angle, off Gx)
      ,sintho,Temtho		! outgoing angle off Gx from surface
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!
  DOUBLE PRECISION Temth0do	 &! OUTPUT diff angle, off Gx
      ,sin0do,cos0do		! OUTPUT sin(diff angle, off Gx)
!
  CALL GENTHDF(sinths,cosths,sinaplane,cosaplane,sinalpha &
      ,cosalpha,sin0d)		! thdiff simeq ths+aplane
!92      sin0d=sinths*DCOS(aplane)
!     1  +DSIN(aplane)*DCOS(dalpha)*DCOS(Temths)
  Temth0d=DASIN(sin0d)
  cos0d=DCOS(Temth0d)
!93:	 Note NO change of outgoing diff.angle (off BRAGG peak) vs
!AC      sin0do=2.D0*sinth-sin0d
  sin0do=sin0d
  Temth0do=DASIN(DMIN1(sin0do,1.D0))
  cos0do=DCOS(Temth0do)
  CALL GENTHSF(sin0do,cos0do,-sinaplane,cosaplane,sinalpha &
      ,cosalpha,sintho)
  Temtho=DASIN(DMIN1(sintho,1.D0))
  RETURN
END
!--------------------------------------------------------------------------
!--------------------------------------------------------------------------
SUBROUTINE OUTFILS(VL,dalpha,lambda,Twod,swidth,ORDER)
!     ================================================================
!	Subroutine modularised from Moscurve3 generating output files,
!	data as subroutine of CS5, dependent on VARMAX=no. of solns,
!   	    VL=1 (first or only solution)
!	 or VL=2 (second solution, curved crystal geometry),
!	and numstr(1:1)='S' or numstr(1:1)='P'
!	! sigma polarisation (first call):E ll inc.plane, K=cos2thB
!	! pi polarisation (second call):E perp.to inc.plane, K2=1
!
  IMPLICIT NONE
  INTEGER VL
!		      Passed vars:
  DOUBLE PRECISION dalpha,lambda,Twod,swidth
  DOUBLE PRECISION ORDER
!			GENDAT variables:
  INTEGER NINDEPT
  PARAMETER (NINDEPT=28)
  INTEGER MAXK,KM(NINDEPT),ISP,OFL,OFL2,MS,JM
  DOUBLE PRECISION GB(NINDEPT),ERGB(NINDEPT),LB(NINDEPT), &
      UB(NINDEPT),GBP(NINDEPT),LBP(NINDEPT),UBP(NINDEPT), &
      ERGBP(NINDEPT)
!U96: alignment
  COMMON/FITVAR/ GB,ERGB,LB,UB,GBP,LBP,UBP,ERGBP, &
      MAXK,KM,ISP,OFL,OFL2,MS,JM
!92			major new curved crystal variables:
  DOUBLE PRECISION AxisTh,ABtem,Mininc,THABX,THBAX,BXmin
  DOUBLE PRECISION thm1C(2),ThminC(2),ThmaxC(2),thminoC(2) &
      ,thmaxoC(2),YozC(2),YminoC(2),YmaxoC(2)
  INTEGER VARMAX,Isect(2)
  COMMON/CS5B/AxisTh,ABtem,Mininc,THABX,THBAX,BXmin &
      ,thm1C,ThminC,ThmaxC,thminoC,thmaxoC,YozC,YminoC,YmaxoC &
      ,VARMAX,Isect
!		      Common (I/O) vars (CS5-Rcurve)
  INTEGER ISTEPSO,ISTEPSP
  PARAMETER (ISTEPSO=8000,ISTEPSP=8001)
  DOUBLE PRECISION RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr
  DOUBLE PRECISION MPSIr2,MPSIi2,p,s,K1,Temth0,Thout0, &
      muabs,mcurv,mReftem1,Maxt2,umbo2
  DOUBLE PRECISION Irel1(ISTEPSP),Irel2(ISTEPSP),Irel3(ISTEPSP), &
      Reflint(6),Reflintth,ReflintHy,Mshift1,Mshift2,Mshift3(2,2), &
      Mshift4(3),Ermshift4,MShiftB(6),Irel5(ISTEPSP),Irel6(ISTEPSP)
  DOUBLE PRECISION MaxI1,MaxI2,MaxI3,MaxI4,Thpk, &
      Thpko,Ypko,Th1,Thout,Yshift, &
      STEPS1,STEPS2,STEPS3,STEPS4,basym,IRELM
  COMMON/CS5C/RPSI0,APSI0,RPSIHi,APSIHi,RPSIHr,APSIHr,MPSIr2,MPSIi2, &
      p,s,K1,Temth0,Thout0,muabs,mcurv,mReftem1,Maxt2,umbo2, &
      Irel1,Irel2,Irel3,Reflint,Reflintth,ReflintHy,Mshift1, &
      Mshift2,Mshift3,Mshift4,Ermshift4,MShiftB,Irel5,Irel6,MaxI1, &
      MaxI2,MaxI3,MaxI4,Thpk,Thpko, &
      Ypko,Th1,Thout,Yshift,STEPS1,STEPS2,STEPS3,STEPS4,basym &
      ,IRELM
!
  DOUBLE PRECISION c251,c252,c253,c751,c752,c753,mt0
  DOUBLE PRECISION mq2,PkTh1,Reflinto,thmaxf,thminf,Mosdel, &
      c1ff(6),c2ff(6),ffpk(2),Maxff,maxt0,maxt3,sigscat,siginc &
      ,Reflintm,Reflinty,ReflintthinC
  DOUBLE PRECISION transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm(2,8,2)
  INTEGER K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2
  CHARACTER numstr*4
  COMMON/CS5D/c251,c252,c253,c751,c752,c753,mt0,mq2,PkTh1, &
      Reflinto,thmaxf,thminf,Mosdel,c1ff,c2ff, &
      ffpk,Maxff,maxt0,maxt3,sigscat,siginc,Reflintm,Reflinty, &
      Reflintthinc,transscale,c011,c991,c012,c992,c013,c993 &
      ,cffm,K2max,K3max,STEPSF,AGE,mtimes,mdvs,mtot,Irpout &
      ,STEPSF1,STEPSF2,numstr
!
  INTEGER ffs
  PARAMETER (ffs=30100)
  COMPLEX*16 DPSI0, DPSIHr, DPSIHi
  DOUBLE PRECISION Thm2,Thm3,Temthm2,Temthm3,Yrel(ISTEPSP,6), &
      Thtem(ffs),Rtem(ffs),Ttem(ffs),Ytem(ffs),dely0,dely0t,mufilm, &
      TEMUL,Mphotoshift,mdepth(6),mthld(6),emthld(2) &
      ,mcontl,meanff(7,2),maxdp,maxdm,thff,Chinit,Chfin
  DOUBLE PRECISION Rzf,Cx
!93atest:     add mYo for output asymmetry evaluation:
  DOUBLE PRECISION fscale,RtemC(ffs),TtemC(ffs),Tabdy(ffs,4),mYo(6)
  DOUBLE PRECISION BXm,BXx
  INTEGER fof,detmatch,ip
  COMMON/CS5E/ DPSI0,DPSIHr,DPSIHi,Thm2,Thm3,Temthm2,Temthm3,Yrel, &
      Thtem,Rtem,Ttem,Ytem,dely0,dely0t,mufilm,TEMUL,Mphotoshift, &
      mdepth,mthld,emthld,mcontl,meanff,maxdp,maxdm,thff &
      ,Chinit,Chfin,Rzf,Cx,fscale,RtemC,TtemC &
      ,Tabdy,mYo,BXm,BXx,fof,detmatch,ip
!
  INTEGER IREAD,Photo,Jbit4,Fwrite(0:20)
  COMMON/CS5F/ IREAD,Photo,Jbit4,Fwrite
!91			constants
  DOUBLE PRECISION DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
  COMMON /COMCONSTS/ DPI,dln2,re0,hckeV,mec2,Na11,e_per_b &
      ,keV_per_Ryd,INV_FINE_STRUCT,au_cross,DPIo2
!		      Time vars
!		Time vars
  DOUBLE PRECISION Maxtim,DTIME(6),Mtime,Ntime
  REAL*4 Time0,Time1,Time2,Tim2f,Tim21,Tim22
  COMMON/clockt/ Maxtim,DTIME,Mtime,Ntime,Time0,Time1,Time2,Tim2f &
      ,Tim21,Tim22
  INTEGER Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
  COMMON /COMINTS/ Ilist,Inext,ANS,Iprecs,Isum,Iten,Igraz
!
!plate96 Declaration of extra variables for plate function
  
  INTEGER Ist8,Iast8,I8L,I8U !
  DOUBLE PRECISION &
      Thoutp(ISTEPSP),		 &! Thout used in plate calc end of layerloop cycle
      Thetaap2p(ISTEPSP), 	 &! Thetaap2  used in plate calc end of layerloop  
      
      Detcenx(2), 		 &! centre position of detector, should be zero
      MaxK8I,MinK8I,	 &! extreme ray numbers of K8I flate plate 
      Irel28(ISTEPSP),Irel9(ISTEPSP), &
      WDTH8,MaxI18,MaxI8,Detxpk1o
  DOUBLE PRECISION  Irel8(ISTEPSP),  &! Rel intensity on Plate detector
      Detminx(2),Detmaxx(2), &! max and min range onto detector
      K8maxt,Detxpko,  &!variables to store info about Irel8 array
      lo1pc,hi1pc,lo50pc,hi50pc !variables to store info about Irel8 array
  INTEGER K8max,K8min,STEPS8
!MK03***************************************************************************
!MK03 The variables Detxpk1o, low1pc, hi1pc, low50pc, hi50pc were added to 
!MK03 the COMMON variables under CS5Plate by Mark Kinnane (3/10/03).
  COMMON /CS5Plate/ &
      Irel8,Detminx,Detmaxx,K8maxt,Detxpko,  &! Irel8==IrelPlate
      K8max,K8min,STEPS8,lo1pc,hi1pc,Detxpk1o,lo50pc,hi50pc
!MK03***************************************************************************
  DOUBLE PRECISION Detx,Detarmlen,Detbeta,Dettheta,Rplate
  COMMON/PLATE/Detx,Detarmlen,Detbeta,Dettheta,Rplate
!out97      
  INTEGER Outfilesflag, Maxlines ! flag to stop output files
  COMMON/OUTBRAGG/Outfilesflag, Maxlines
!V	new AV variables (for MCP detector)
!	DOUBLE PRECISION XD,XDmin,XDmax,XD0,thetaD,Thetaap2
!	COMMON/CS5G/ XD,XDmin,XDmax,XD0,thetaD,Thetaap2
!
!		from Moscurve3:
!
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER ielem
  PARAMETER (ielem=20)
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!91			Form factor variables
  DOUBLE PRECISION En,Mu,Muo,f1,f2,f1o,f2o,Eno,POWER &
      ,sig1,sig2,sig1o,sig2o
  DOUBLE PRECISION SIG(2,ielem)			! vs r*8 SIG(2,8)
  double precision f01(ielem),f02(ielem),fh1(ielem)	! from (8)!!
  double precision A1(4),B1(4),C1,Z
  DOUBLE PRECISION dlambdanew,THETA,ksp
  INTEGER iatom,Iffsource
  character CFIL*2,SYMBOL*2
  character DATFIL*6
  COMMON /FORMFC/En,Mu,f1,f2,f1o,f2o,Eno,Muo,POWER, &
      sig1,sig2,sig1o,sig2o,SIG,f01,f02,fh1,A1,B1,C1,Z, &
      dlambdanew,THETA,ksp, &
      iatom,Iffsource,CFIL,SYMBOL,DATFIL
!92		Separate THREEBM/FHCALCN parameters:
  INTEGER IM(4)
  DOUBLE PRECISION a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,d2,xTemp
  DOUBLE PRECISION Numcells
  COMPLEX*16 FHr, FHi, FHn(ielem)
  common/com2d/ IM,a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,Numcells,d2,xTemp,FHr,FHi,FHn
!
!		  Diffn vars from COMFFM/Braggffm:
!
  DOUBLE PRECISION bigD,bigQ,U,V,sa,sv,sw,Maxt,Maxt1,mz2
  COMPLEX*16 dq,dz,dqplusz2,drtqp2,cc2p1
  COMPLEX*16 ctem,ctem2,cx1,cx2,cc1,cc2,cc1p,cc2p,ctemr,ctemt
  DOUBLE PRECISION rc,tc,ddel,logttime
!		      Mosaic vars
  DOUBLE PRECISION Ascale,Rfact(0:ffs),temsum
  INTEGER Idel,Imax,Ist,Jst,Jast
!		      Other FFM variables:
  INTEGER EXTRASTEPS,tflag,ittime,Iolddel,Mosflag
  DOUBLE PRECISION JU,JL,JU2,JL2,JU3,JL3,JU4,JL4,norm
  DOUBLE PRECISION Temt1,tmin,Delthm,thtime &
      ,sintime,costime,costh,Tem5,Tem4,t0,GB1,sinth,dely &
      ,ytime,rtime,ttime,yffpk,Tlim,Delthf,scTemth,dsinthdy,TemU
  COMMON /COMFFM/ bigD,bigQ,U,V,sa,sv,sw,Maxt,Maxt1,mz2 &
      ,dq,dz,dqplusz2,drtqp2,ctem,ctem2,cx1,cx2,cc1,cc2,cc1p,cc2p &
      ,cc2p1,ctemr,ctemt,rc,tc,ddel,logttime,Ascale,Rfact,temsum &
      ,Idel,Imax,Ist,Jst,Jast,EXTRASTEPS,tflag &
!U96: norm
      ,ittime,JU,JL,JU2,JL2,JU3,JL3,JU4,JL4,norm,Iolddel &
      ,Mosflag,Temt1,tmin,Delthm,thtime,sintime,costime &
      ,costh,Tem5,Tem4,t0,GB1,sinth,dely,ytime,rtime,ttime &
      ,yffpk,Tlim,Delthf,scTemth,dsinthdy,TemU
!93		,sin2T0,sin2apl,cos2apl cancelled
!91		I/O pars (BRAGGIFP +)
  DOUBLE PRECISION RANGE(2),STEPS,DELJ(2),denom,aplane,G,G2,K12,K,K2
  DOUBLE PRECISION RI1(3),RI2(3),RI3,RFL(3),RFL2(3),RANGE0
  INTEGER CYCLE,Ibit,Jbit,J,Item
  DOUBLE PRECISION fwhm1,fwhm2
  DOUBLE PRECISION mangle(6,3,2)
  DOUBLE PRECISION RIT(6,3,2),RFLT(6,3,2)
  DOUBLE PRECISION scale1,thpk1,thpk2
  COMMON/COMIFP/RANGE,STEPS,DELJ,denom,aplane,G,G2,K12,K,K2 &
      ,RI1,RI2,RI3,RFL,RFL2,RANGE0 &
      ,fwhm1,fwhm2,mangle,RIT,RFLT &
      ,scale1,thpk1,thpk2,CYCLE,Ibit,Jbit,J,Item
!U96: alignment
  DOUBLE PRECISION dlambda,Mshift21,Mshift31(2),Mshift41(2)
  COMMON /mosout/ dlambda,Mshift21,Mshift31,Mshift41
!DEC92:		      Yiz estimates + CMac meanxxp
  DOUBLE PRECISION YozestC(2),YestfC(2,2) &
      ,YestcC(2,2),ThetaacC(2,2),XXC(2),minxxp(2),maxxxp(2) &
      ,meanxxp(2),STEPS1o
  COMMON /COMYEST/ YozestC,YestfC,YestcC,ThetaacC,XXC &
      ,minxxp,maxxxp,meanxxp,STEPS1o
!93atest:               extreme .1%ile estimates:
  DOUBLE PRECISION MaxI3t
  INTEGER K2min,K3min,K2maxt,K3maxt,K3Imax
  COMMON /COMEXTREME/ MaxI3t,K2min,K3min,K2maxt,K3maxt,K3Imax
!93atest-
!93atest:
  DOUBLE PRECISION Thtem2(ffs),Rtem2(ffs),Ttem2(ffs)
  COMMON/FFREFL/Thtem2,Rtem2,Ttem2
  DOUBLE PRECISION Tabdy2(ffs,4)
  COMMON/FFTable/Tabdy2
!UJun96			Supplementary ranges:
  DOUBLE PRECISION Ytem2(ffs)	 &!=Thin
      ,t0pk,t0c					 &!non-overrun lamellar/mosaic thicknesses
      ,JUM,JLM,JLM2,JUM2,JLM4,JUM4,JL1,JU1	 &! mosdel convolved widths
      ,pcontl									 &! last trunc layer Refl*IREL
      ,xmin1,xmax1,xmin,xmax					 &! xrange: initial & final
      ,Thm2L(2),Thm3L(2)						 &! th1 ranges (VL)
      ,MaxI1r,MaxI3r,mcontr,pcontr			! reflectivity maxima
  INTEGER Jmaxff,Jmaxff2,xtot,ptot,pdivs
  COMMON/FFmarkers/Ytem2,t0pk,t0c &
      ,JUM,JLM,JLM2,JUM2,JLM4,JUM4,JL1,JU1 &
      ,pcontl,xmin1,xmax1,xmin,xmax,Thm2L,Thm3L,MaxI1r,MaxI3r,mcontr,pcontr &
      ,Jmaxff,Jmaxff2,xtot,ptot,pdivs
!93atest-
!		local? never-to-be-seen-again?
  DOUBLE PRECISION Rtemff,MeanI,Y1,RI4,RI5,RI6(6),y0est &
      ,Irel,ITh1
  INTEGER Iast,Jbit1,Jbit2,Jbit3,Jbit8,I,Ich,Iscale,Iorder
  INTEGER id
  character FILEIN2*20
  INTEGER ILEN2 ! LFS: 25/2/2009
!91	Mac switch
  INTEGER IMac
  COMMON/Macswitch/ IMac
!MAC95
  CHARACTER dout*11,dcom*11,ddat*7,dhen*16,dhm*8
  COMMON/Macfiles/ dout,dcom,ddat,dhen,dhm
!MAC95

  !---------------------- LFS: 25/2/2009
  ILEN2=LEN(dout)
113 IF (ICHAR(dout(ILEN2:ILEN2)).LT.40.AND.ILEN2.NE.0) THEN
    ILEN2=ILEN2-1
    GOTO 113
  ENDIF

  Iorder=IDNINT(ORDER)
!plate96	  
!out97	  Outfilesflag=3
!
  IF (ip.EQ.1.AND.VL.EQ.1) THEN	!numstr(1:1).EQ.'S'
    WRITE(*,114) Ilist,dlambda,dlambdanew,iorder
114 FORMAT(/,1X,'line=',I3,';lambda(unshifted)=',F10.6,'(real)=' &
        ,F10.6,';order=',I3)
    WRITE(*,116) d2,Numcells,G
    WRITE(*,117) FHr,FHi,F0(3)
116 FORMAT(1X,'2d=',1PE12.5,';cells/m3=',1PE9.2,',g(abs,sig)=' &
        ,1PE9.2)
117 FORMAT(' S.factors FHr,FHi,F0=',6(1PE9.2,X))
    WRITE(*,118)
118 FORMAT(' Sigma polarisation: E in plane of inc. ' &
        ,'(poln factor cos2thB).')
  ELSEIF (ip.EQ.2.AND.VL.EQ.1) THEN	!numstr(1:1).EQ.'P'
    WRITE(*,1000)
1000 FORMAT(' ')
    WRITE(*,1140)
1140 FORMAT(' Pi polarisation: E perp. to plane of inc. (pol.factor 1).')
    IF (mcurv.GT.0.) THEN
      WRITE(*,1185) K1,G2,dely0/mcurv
    ELSE
      WRITE(*,1186) K1,G2
    ENDIF
1185 FORMAT(1X,'kappa=',1PE9.2,' ;g(absn,pi)=',1PE9.2,' ;A(t0)=' &
         ,1PE9.2)
1186 FORMAT(1X,'kappa=',1PE9.2,' ;g(absn,pi)=',1PE9.2)
  ELSE
    WRITE(*,1400) Isect(1),Isect(2)
1400 FORMAT(' Second solution: IRs add, profiles sectors:',2I2)
  ENDIF
!U96: Steps and layers:
  IF (AGE.GT.1) THEN
    WRITE(*,1450)IDINT(STEPS1),Thm2L(VL),Thm3L(VL),IDINT(STEPS2) &
        ,xmin,xmax,mtot,mtimes,MaxI3r,MaxI3t,K3Imax
    WRITE(*,1500) xtot,mdvs,mcontr,mcontl,ptot,pdivs,pcontr,pcontl
  ENDIF
1450 FORMAT(' Loop step:th1',I6,' from',1PE9.2,' to',1PE9.2,',x',I5 &
         ,' from ',1PE9.2,' to',1PE9.2,/,' Pk layer  ',I5,',Pk dvs',I4 &
         ,',Refl',1PE14.7,',Refl*S',1PE14.7,',Yo step',I9)
1500 FORMAT(' Last layer   ',I6,',est.dvs',I4,',R',1PE9.2,',R*S',1PE9.2 &
         ,/,' Lst trncd layer',I5,',divs',I6,',R',1PE9.2,',R*S',1PE9.2)
  IF (detmatch.EQ.0) THEN
!plate96 if Maxt2.EQ.maxt3 then perfect crystal??
    IF (AGE.GT.1.AND.Maxt2.EQ.maxt3) THEN
!Mac		Note YozC=R.Th is wrong for XXp.ne.0 or depth.
      WRITE(*,1800) Thm1C(VL),Thout0,YozC(VL),Temth0
!Mac		Note Axisth is on Gx, vs Thout0 column...
      WRITE(*,1801) 0.,Axisth,GB(1)*Axisth,Axisth
      WRITE(*,1805) IDINT(STEPS1o),IDINT(STEPS3) &
          ,IDINT(STEPS4),STEPSF
      WRITE(*,1810) ThminC(VL),ThminoC(VL)-Temth0,YminoC(VL),thminf-Temth0
      WRITE(*,1815) c011,c012-Temth0,c013,c1ff(ip+2)-Temth0
      WRITE(*,1820) c251,c252-Temth0,c253,c1ff(ip)-Temth0
      WRITE(*,1825) Thpk,Thpko-Temth0,Ypko,ffpk(ip)-Temth0
      WRITE(*,1830) c751,c752-Temth0,c753,c2ff(ip)-Temth0
      WRITE(*,1835) c991,c992-Temth0,c993,c2ff(ip+2)-Temth0
      WRITE(*,1840) ThmaxC(VL),ThmaxoC(VL)-Temth0,YmaxoC(VL),thmaxf-Temth0
      WRITE(*,1845) MaxI1,MaxI2,MaxI3,Maxff,IRELM
      WRITE(*,1846) Mshift1,Mshift2,Mshift3(VL,ip) &
          ,meanff(1,ip)-temth0,meanff(7,ip)-temth0
!93atest:       extreme estimeates:
      WRITE(*,1847) K2min,K3min
      WRITE(*,1848) K2maxt,K3maxt
1800  FORMAT( &
          ' Results: Th1(at source), Thout(surface)-0, Yiz(film), Tho/ff-0' &
          ,/,' zero:',5X,'Th1(rad);Thout0=bragg(rad); Yoz(.1mu' &
          ,');',4X,'Temth0(rad)=',/,' Bragg:   ',1PE12.5,3(1X,1PE14.7))
1799  FORMAT( &
          ' Results: Th1(at source), Thout(surface)-0, Detx(plate), Tho/ff-0' &
          ,/,' zero:',5X,'Th1(rad);Thout0=bragg(rad); Detx(.1mu' &
          ,');',4X,'Temth0(rad)=',/,' Bragg:   ',1PE12.5,3(1X,1PE14.7))	 
!Plate96out----------------------------------------------------------
!MK03*************************************************************************
!MK03 This section was altered by Mark Kinnane (3/10/03). Previously the 
!MK03 variable Detxpko, calculated in CS5plate.f, was reported as the peak 
!MK03 position. However this was not the peak of the plate sprectum Irel8 but
!MK03 the peak of the array Irel28. Therefore as we are interested in only in 
!MK03 Irel8 characteristics the variable Detxpk1o, calculated in CS5plate.f,
!MK03 which describes the Irel8 peak, is now reported as the peak position.
      IF(Detarmlen.GE.0.) THEN
        WRITE(*,1800) Thm1C(VL),Thout0,YozC(VL),Temth0
!Mac		Note Axisth is on Gx, vs Thout0 column...
        WRITE(*,1801) 0.,Axisth,GB(1)*Axisth,Axisth
        WRITE(*,1805) IDINT(STEPS1o),IDINT(STEPS3) &
            ,IDINT(STEPS4),STEPSF
        WRITE(*,1810) ThminC(VL),ThminoC(VL)-Temth0,Detminx(VL),thminf-Temth0
        WRITE(*,1815) c011,c012-Temth0,lo1pc,c1ff(ip+2)-Temth0
        WRITE(*,1820) c251,c252-Temth0,lo50pc,c1ff(ip)-Temth0
        WRITE(*,1825) Thpk,Thpko-Temth0,Detxpk1o,ffpk(ip)-Temth0
        WRITE(*,1830) c751,c752-Temth0,hi50pc,c2ff(ip)-Temth0
        WRITE(*,1835) c991,c992-Temth0,hi1pc,c2ff(ip+2)-Temth0
        WRITE(*,1840) ThmaxC(VL),ThmaxoC(VL)-Temth0,Detmaxx(VL),thmaxf-Temth0
        WRITE(*,1845) MaxI1,MaxI2,MaxI3,Maxff,IRELM
        WRITE(*,1846) Mshift1,Mshift2,Mshift3(VL,ip) &
            ,meanff(1,ip)-temth0,meanff(7,ip)-temth0
!93atest:       extreme estimates:
        WRITE(*,1847) K2min,K8min
        WRITE(*,1849) K2maxt,K8maxt
      ENDIF
!MK03*************************************************************************
!plate96out----------------------------------------------------------
1801  FORMAT(' Axis:    ',1PE12.5,3(1X,1PE14.7))
1805  FORMAT(' STEPS:   ',I12,3(1X,I14))
1810  FORMAT(' 1st ch:  ',1PE12.5,3(1X,1PE14.7))
1815  FORMAT(' 1 %:     ',1PE12.5,3(1X,1PE14.7))
1820  FORMAT(' 50%:     ',1PE12.5,3(1X,1PE14.7))
1825  FORMAT(' Peak:    ',1PE12.5,3(1X,1PE14.7))
1830  FORMAT(' 50%:     ',1PE12.5,3(1X,1PE14.7))
1835  FORMAT(' 1 %:     ',1PE12.5,3(1X,1PE14.7))
1840  FORMAT(' last ch: ',1PE12.5,3(1X,1PE14.7))
1845  FORMAT(' BinRefl*S',1PE12.5,3(1X,1PE14.7),2X,'S=IREL',1PE11.4)
!93atest: extreme .1%ile estimates:
1846  FORMAT(1X,'Shifts:',2X,3(2X,1PE10.3,3X),2X,1PE10.3,2X,'thdiff',1PE11.4)
1847  FORMAT(' 0.5% lower layer limit',5X,I9,6X,I9)
1848  FORMAT(' 0.5% upper layer limit',5X,I9,6X,I9)
1849  FORMAT(' 0.5% upper layer limit',5X,I9,6X,1PE9.4)
!plate96 if maxt3.LT.Maxt2 then mosaic crystal ??        
    ELSEIF (AGE.GT.1.AND.maxt3.LT.Maxt2) THEN
      WRITE(*,1850) Thm1C(VL),Thout0,YozC(VL),Temth0
!Mac		Note YozC=R.Th is wrong for XXp.ne.0 or depth.
!Mac		Note Axisth is on Gx, vs Thout0 column...
      WRITE(*,1851) 0.,Axisth,GB(1)*Axisth,Axisth
      WRITE(*,1855) IDINT(STEPS1o),IDINT(STEPS3) &
          ,IDINT(STEPS4),STEPSF2,STEPSF1,STEPSF
      WRITE(*,1860) ThminC(VL),ThminoC(VL)-Thout0,YminoC(VL) &
          ,cffm(ip,1,2)-Temth0,cffm(ip,1,1)-Temth0,thminf-Temth0
      WRITE(*,1865) c011,c012-Thout0,c013,cffm(ip,2,2)-Temth0 &
          ,cffm(ip,2,1)-Temth0,c1ff(ip+2)-Temth0
      WRITE(*,1870) c251,c252-Thout0,c253,cffm(ip,3,2)-Temth0 &
          ,cffm(ip,3,1)-Temth0,c1ff(ip)-Temth0
      WRITE(*,1875) Thpk,Thpko-Thout0,Ypko,cffm(ip,4,2)-Temth0 &
          ,cffm(ip,4,1)-Temth0,ffpk(ip)-Temth0
      WRITE(*,1880) c751,c752-Thout0,c753,cffm(ip,5,2)-Temth0 &
          ,cffm(ip,5,1)-Temth0,c2ff(ip)-Temth0
      WRITE(*,1885) c991,c992-Thout0,c993,cffm(ip,6,2)-Temth0 &
          ,cffm(ip,6,1)-Temth0,c2ff(ip+2)-Temth0
      WRITE(*,1890) ThmaxC(VL),ThmaxoC(VL)-Thout0,YmaxoC(VL) &
          ,cffm(ip,7,2)-Temth0,cffm(ip,7,1)-Temth0,thmaxf-Temth0
      WRITE(*,1895) MaxI1,MaxI2,MaxI3,cffm(ip,8,2) &
          ,cffm(ip,8,1),Maxff,IRELM
      WRITE(*,1846) Mshift1,Mshift2,Mshift3(VL,ip) &
          ,meanff(1,ip)-temth0,meanff(7,ip)-temth0
!93atest:       extreme estimates:
      WRITE(*,1847) K2min,K3min
      WRITE(*,1848) K2maxt,K3maxt
1850  FORMAT(8X, &
          'Th1/source  dThout/surf   Yiz/film   ffm/t0+mosdel' &
          ,' ffp/mosaict0 ff/thick',/, &
          ' Zero:   Th1(rad);Thout0=Bragg(rad);Yoz(.1mu' &
          ,');Temth0(rad)=',/,' Bragg',1PE12.5,3(1PE14.7))
1851  FORMAT(' Axis ',1PE12.5,3(1PE14.7))
1855  FORMAT(' STEPS',I12,I11,I14,I11,I11,I11)
1860  FORMAT(' 1stch',1PE12.5,1X,1PE11.4,1X,1PE14.7,3(1X,1PE11.4))
1865  FORMAT(' 1 %: ',1PE12.5,1X,1PE11.4,1X,1PE14.7,3(1X,1PE11.4))
1870  FORMAT(' 50%: ',1PE12.5,1X,1PE11.4,1X,1PE14.7,3(1X,1PE11.4))
1875  FORMAT(' Peak:',1PE12.5,1X,1PE11.4,1X,1PE14.7,3(1X,1PE11.4))
1880  FORMAT(' 50%: ',1PE12.5,1X,1PE11.4,1X,1PE14.7,3(1X,1PE11.4))
1885  FORMAT(' 1 %: ',1PE12.5,1X,1PE11.4,1X,1PE14.7,3(1X,1PE11.4))
1890  FORMAT(' lstch',1PE12.5,1X,1PE11.4,1X,1PE14.7,3(1X,1PE11.4))
1895  FORMAT(' PkRfl',1PE12.5,1X,1PE11.4,1X,1PE14.7,3(1X,1PE11.4) &
          ,/,1X,'Peak source contribution=',1PE11.4)
    ELSE		! AGE.LE.1 and perfect or imperfect
      WRITE(*,1900) Temth0
      WRITE(*,1905) STEPSF2,STEPSF1,STEPSF
      WRITE(*,1910) thminf,cffm(ip,1,1),cffm(ip,1,2)
      WRITE(*,1915) c1ff(ip+2),cffm(ip,1,1),cffm(ip,1,2)
      WRITE(*,1920) c1ff(ip),cffm(ip,1,1),cffm(ip,1,2)
      WRITE(*,1925) ffpk(ip),cffm(ip,1,1),cffm(ip,1,2)
      WRITE(*,1930) c2ff(ip),cffm(ip,1,1),cffm(ip,1,2)
      WRITE(*,1935) c2ff(ip+2),cffm(ip,1,1),cffm(ip,1,2)
      WRITE(*,1940) thmaxf,cffm(ip,1,1),cffm(ip,1,2)
      WRITE(*,1945) Maxff,cffm(ip,1,1),cffm(ip,1,2)
      WRITE(*,1950) meanff(1,ip)-temth0,meanff(7,ip)-temth0
1900  FORMAT(' Theta:thick dy0,ffp/t0 only,ffm/mosdel+t0; temth0(rad)=' &
          ,(1X,1PE14.7))
1905  FORMAT(' STEPS:   ',3(1X,I14))
1910  FORMAT(' 1st ch:  ',3(1X,1PE14.7))
1915  FORMAT(' 1 %:     ',3(1X,1PE14.7))
1920  FORMAT(' 50%:     ',3(1X,1PE14.7))
1925  FORMAT(' Peak:    ',3(1X,1PE14.7))
1930  FORMAT(' 50%:     ',3(1X,1PE14.7))
1935  FORMAT(' 1 %:     ',3(1X,1PE14.7))
1940  FORMAT(' last ch: ',3(1X,1PE14.7))
1945  FORMAT(' Pk Refl: ',3(1X,1PE14.7))
1950  FORMAT(1X,'Shifts:',2X,2(5X,1PE10.3))
    ENDIF
!93atest:       add mYo, not just mean(thout):
!UJun96: Minor format updates / clarifications:
    WRITE(*,1960) mYo(ip+2),mYo(ip+4)
1960 FORMAT(1X,'Yshift 1%/0.1% ranges =',3X,1PE10.3,5X,1PE10.3)
    WRITE(*,1965) mthld(ip)-meanff(3,ip) &
        ,emthld(ip)-meanff(3,ip)+THETA &
        ,mthld(ip+2)-meanff(2,ip)
!93     3 ,mthld(ip+4)-meanff(3,ip)
1965 FORMAT(1X,'Mean shift of Thdiff layer v ff mean:full/ffest/1%= ' &
         ,1PE9.2,2(1X,1PE10.3))
!93atest-
    IF (lambda/twod.GT.1.D0) THEN	! l/2d or dlnew/d2*order !!!
      y0est=0.D0
    ELSE
      y0est=lambda/twod+(1.D0-basym)/basym/4.D0*RPSI0 &
          /lambda*twod
      IF (y0est.GT.1.D0) THEN
        y0est=DPIo2-temth0
      ELSE
        y0est=DASIN(y0est)-temth0
      ENDIF
    ENDIF
    IF (AGE.GT.1) WRITE(*,1970) MaxI1r,MaxI4,PkTh1,Mphotoshift
1970 FORMAT(' Peak Reflectivity (th1)',1PE14.7,1X,'vs BinMean over x & xSTEPS1/STEPS' &
         ,/,' Peak refl.for x=0',1PE14.7,', at Th1=',1PE14.7 &
         ,' Emulsion:',1PE9.2)
    IF (Photo.EQ.1) THEN
      WRITE(*,2020) mufilm,muabs,siginc,y0est
2020  FORMAT(1X,'mufilm=',1PE9.2,', crystal muabs=',1PE9.2,',siginc=' &
          ,1PE9.2,',dthRI=',1PE11.4)
    ELSE
      WRITE(*,2030) 0.D0,y0est
2030  FORMAT(1X,'from mufilm=',1PE9.2,', dthRI=',1PE11.4)
    ENDIF
    IF (AGE.GT.1) WRITE(*,2040) Reflint(1)
2040 FORMAT(3X,'Integrated Reflectivities:', &
         'Iout/Iin*2pi==mean(IRELR).(th1mx-th1mn)=RHth1=',1PE10.3)
    IF (AGE.GT.1) &
        WRITE(*,2050) Reflinty,ReflintHy,Reflintth	!*(ThmaxC(VL)-ThminC(VL))
2050 FORMAT(1X,'RHy=',1PE9.2,', RHy(x=0)=I.dysurf=',1PE9.2, &
         ', RHth1(x=0)=I.dth1=',1PE9.2)
    IF (Mosdel.LE.0.) THEN
      WRITE(*,2060) Reflinto,Reflinto,Reflintthinc
    ELSE
      WRITE(*,2060) Reflinto,Reflintm,Reflintthinc
    ENDIF
2060 FORMAT(1X,'C(dthinc)=',1PE14.7, &
         ',inc.mosaic spread=',1PE9.2,',curved(thinc)=',1PE10.3)
    WRITE(*,2070) (meanff(id,ip)-temth0,id=1,6)
2070 FORMAT(' ffp delth(full range,2,3-decades); & from sinth axis=' &
         ,/,9X,6(1PE13.6))
    IF (Mosdel.LE.0.D0) THEN
      DO id=1,6
        IF (meanff(id,ip).NE.0.D0) THEN
          RI6(id)=1.D0-ORDER/d2*dLambdanew/DSIN(meanff(id,ip))
        ELSE
          RI6(id)=0.D0
        ENDIF
      ENDDO
      WRITE(*,2080) (RI6(id),id=1,6)
    ENDIF
2080 FORMAT(' ffp RI='1X,6(1PE13.6))
    WRITE(*,2090) transscale,XXC(VL),minxxp(VL),meanxxp(VL),maxxxp(VL)
2090 FORMAT(1X,'BXYZF',1PE10.3,',XXC/p',4(1PE10.3) &
         ,'; RIth=(1-RI)(2d/nl)^2=')
    IF (ip.EQ.1) THEN	! numstr(1:1).EQ.'S'; use VL=1 solution?
      RFL(VL)=Reflint(1)	! CMac in CS5*(ThmaxC(VL)-ThminC(VL))
      RI1(VL)=Mshift4(VL)                   ! th.inc.already wrt b=0
      IF (RI1(VL).NE.0.D0) THEN
        RI1(VL)=1.D0-ORDER/d2*dLambdanew/DSIN(RI1(VL))
      ENDIF
      
      IF (VL.EQ.1) THEN
        Mshift31(ip)=Mshift3(1,ip)
!Mac
        MShiftB(3*ip)=MShiftB(3*ip-3+VL)
        RFL(3)=RFL(1)
        RI1(3)=RI1(1)
        Mshift4(3)=Mshift4(VL)*RFL(VL)		! sum of shift*Refl
      ELSE
        RFL(3)=RFL(1)+RFL(2)
        Mshift31(ip)=(Mshift3(1,ip)*RFL(1)+Mshift3(2,ip)*RFL(2)) &
            /RFL(3)
        MShiftB(3*ip)=(MShiftB(3*ip-2)*RFL(1)+MshiftB(3*ip-1)*RFL(2)) &
            /RFL(3)
        RI1(3)=(Mshift4(1)*RFL(1)+Mshift4(2)*RFL(2))/RFL(3)
        IF (RI1(3).NE.0.D0) RI1(3)=1.D0-ORDER/d2*dLambdanew &
            /DSIN(RI1(3))
        Mshift4(3)=Mshift4(3)+Mshift4(VL)*RFL(VL)	! sum of shift*Refl
      ENDIF
      Mshift21=Mshift2
      Mshift41(VL)=Mshift4(VL)
    ELSE
      RFL2(VL)=Reflint(1)		! CMac in CS5*(ThmaxC(VL)-ThminC(VL))
      RI2(VL)=Mshift4(VL)                   ! th.inc.already wrt b=0
      IF (RI2(VL).NE.0.D0) RI2(VL)=1.D0-ORDER/d2*dLambdanew &
          /DSIN(RI2(VL))
      IF (VL.EQ.1) THEN
        Mshift31(ip)=Mshift3(1,ip)
        RFL2(3)=RFL2(1)
        RI2(3)=RI2(1)
      ELSE
        RFL2(3)=RFL2(1)+RFL2(2)
        Mshift31(ip)=(Mshift3(1,ip)*RFL2(1)+Mshift3(2,ip)*RFL2(2)) &
            /RFL2(3)
        RI2(3)=(Mshift4(1)*RFL2(1)+Mshift4(2)*RFL2(2))/RFL2(3)
        IF (RI2(3).NE.0.D0) RI2(3)=1.D0-ORDER/d2*dLambdanew &
            /DSIN(RI2(3))
      ENDIF
      Mshift4(3)=Mshift4(3)+Mshift4(VL)*RFL2(VL)	! sum of shift*Refl
    ENDIF
!93test:        PRINT*,' CT',Mshift4,RFL,RFL2
!
    RI3=Mshift1*mReftem1           ! input th*dThetas/dTh1
    RI4=Mshift2                    ! outward Th at surface
    RI5=Mshift3(VL,ip)/GB(1)        ! naive shift
    RI3=1.D0-ORDER/d2*dLambdanew/DSIN(Theta+RI3)
    RI4=1.D0-ORDER/d2*dLambdanew/DSIN(Theta+RI4)
    RI5=1.D0-ORDER/d2*dLambdanew/DSIN(Theta+RI5)
    IF (DSIN(meanff(1,ip)).NE.0.D0) THEN
      Rtemff=1.D0-ORDER/d2*dLambdanew/DSIN(meanff(1,ip))
      WRITE(*,2128) Mshift1*mReftem1,Mshift2,Mshift3(VL,ip)/GB(1) &
          ,meanff(1,ip)-Theta,MShiftB(3*ip-3+VL)
      WRITE(*,2129) RI3,RI4,RI5,Rtemff
    ELSE
      WRITE(*,2128) Mshift1*mReftem1,Mshift2,Mshift3(VL,ip)/GB(1) &
          ,0.0,MShiftB(3*ip-3+VL)
      WRITE(*,2129) RI3,RI4,RI5,0.0
    ENDIF
!U95   shorten following line to run in unix
2128 FORMAT(' derived mean dTheta= ',3(X,1PE11.4),X,1PE14.7,X,1PE11.4)
2129 FORMAT(' 1-n*lambda/(2dsinTh)=',3(X,1PE11.4),X,1PE14.7)
    IF (numstr(1:1).EQ.'S') THEN
      IF (AGE.EQ.1) THEN
        RFL(3)=Reflinto
        RI1(3)=Rtemff
        Mshift4(1)=meanff(1,ip)
      ENDIF
      WRITE(*,2132) RI1(3),Ermshift4,mcurv,Mshift4(1)-theta
    ELSE
      IF (AGE.EQ.1) THEN
        RFL2(3)=Reflinto
        RI2(3)=Rtemff
        Mshift4(1)=meanff(1,ip)
      ENDIF
      WRITE(*,2132) RI2(3),Ermshift4,mcurv,Mshift4(1)-theta
2132  FORMAT(1X,'Gen.RIcorrn=',1PE11.4,'==Y err',1PE9.2,'; mcurv', &
          1PE9.2,';Mean dth=',1PE11.4)
    ENDIF
    IF (AGE.NE.1) THEN
      WRITE(*,2134) Maxt2,t0c,t0pk,mt0,t0 &
          ,maxt0,mdepth(ip)
!U96: JU1, YtemC:
      WRITE(*,2135) dely0,dely0t,Tabdy2(IDNINT(JUM+JLM)/2,4) &
          ,Ytem2(IDNINT(JUM))-Ytem2(IDNINT(JLM)) &
          ,Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3)) &
          ,Ytem2(IDNINT(JUM2))-Ytem2(IDNINT(JLM2))
    ELSE
      WRITE(*,2137) Maxt2,dely0 &
          ,Ytem(IDNINT(JU1))-Ytem(IDNINT(JL1)) &
          ,Ytem(IDNINT(JU3))-Ytem(IDNINT(JL3)) &
          ,Ytem(IDNINT(JU2))-Ytem(IDNINT(JL2))
    ENDIF
2134 FORMAT(' T,tfp,tpk/fm,cm',1PE8.2,3(1PE9.2),';t0,dmx/dav' &
         ,1PE8.2,1PE8.1,1PE9.2)
2135 FORMAT(' dy0/pk/conv=' &
         ,3(1PE9.2),';DY/50,10,1=',3(1PE9.2))
2137 FORMAT(' Crystal t,dy0=',1PE9.2 &
         ,1PE9.2,';DY/50,10,1=',3(1PE9.2))
    IF (Mosdel.GT.0.) WRITE(*,2138) maxt3,mosdel
2138 FORMAT(1X,'Mosaic thickness=',1PE9.2,',width=',1PE9.2)
    IF (numstr(1:1).EQ.'P') WRITE(*,1000)
  ENDIF
  IF ((Fwrite(Inext).EQ.Ilist.OR.ANS.EQ.1.OR.ANS.EQ.3).AND. &
      AGE.GT.1.AND.(detmatch.EQ.0)) THEN		!profiles
!plate96 output changes flag to reduce number of output files
    IF (Outfilesflag.EQ.1.OR.Outfilesflag.EQ.3) THEN
      GOTO 2151
    ENDIF
    IF (numstr(1:1).EQ.'S') THEN
      FILEIN2='RPLTH1.D'//numstr(2:4)
    ELSE
      FILEIN2='RPPTH1.D'//numstr(2:4)
    ENDIF
    OPEN (UNIT=1,FILE=dout(1:ILEN2)//FILEIN2,STATUS='NEW')
    Ist=1
2139 Iast=IDNINT(STEPS1o)
    IF (Irel1(Ist+1).LE.0.D0) THEN
      Ist=Ist+1
      GOTO 2139
    ENDIF
    Ist=Ist+1
2140 IF (Irel1(Iast-1).LE.0.D0) THEN
      Iast=Iast-1
      GOTO 2140
    ENDIF
    Iast=Iast-1
    Jbit1=(Iast-Ist)/1000+1
    IF (Jbit1.LT.1) Jbit1=1
!test93        WRITE(*,*) ip,VL,Ist,Iast,Jbit1,Irel1(Ist)
    DO I=Ist,Iast-Jbit1,Jbit1      ! <=1000 output steps
      Y1=0.D0
      Irel=0.D0
      ITh1=0.D0
      DO Ibit=1,Jbit1
        Ich=I+Ibit-1
        Irel=Irel+Irel1(Ich)      ! output=mean of Jbit1 channels
        ITh1=ITh1+DFLOAT(Ich)*Irel1(Ich)      ! vs RPI= Jbit1'th channel
        Y1=Y1+Yrel(Ich,1)*Irel1(Ich)
      ENDDO
      IF (Irel.LE.0.D0) THEN
        GOTO 2150
      ELSE
        ITh1=ITh1/Irel
        Y1=Y1/Irel
      ENDIF
      Irel=Irel/DFLOAT(Jbit1)      ! mean reflectivity
      Th1=ThminC(VL)+ITh1*(ThmaxC(VL)-ThminC(VL))/(STEPS1o-1.D0)
!V	    XD=((GB(1)*DCOS(Thout) - (GB(1)/2.-Cx)*DCOS(Thout+Thetaap2))/
!     1    DSIN(Thout-ThetaD-Thetaap2)) - (Rzf/DTAN(Thout-ThetaD-Thetaap2))
!         WRITE(1,2145) Th1,Irel,I,Y1,XD
!V2145     FORMAT(1X,1PE15.8,',',1PE13.6,',',I5,',',1PE10.3,',',1PE10.3)
      WRITE(1,2145) Th1,Irel,I,Y1
!plate96 2145     FORMAT(1X,1PE15.8,',',1PE13.6,',',I5,',',1PE10.3)
2145  FORMAT(1X,1PE15.8,',',1PE13.6,',',I5,',',1PE10.3,',',1PE15.8)
!plate96 add format for Detx
!plate96 2146     FORMAT(1X,1PE15.8,',',1PE13.6,',',I5,',',1PE10.3,',',1PE15.8,
!plate96     1 ',',1PE15.8)
2146  FORMAT(1X,1PE15.8,',',1PE13.6,',',I5,',',1PE10.3,',',1PE15.8)
2150  CONTINUE
    ENDDO
    CLOSE(UNIT=1,STATUS='KEEP')
!plate96 output changes flag to reduce number of output files		
2151 IF ((Outfilesflag.EQ.2).OR.(Outfilesflag.EQ.3)) THEN
      GO TO 2162
    ENDIF
    IF (numstr(1:1).EQ.'S') THEN
      FILEIN2='RPLTHO.D'//numstr(2:4)
    ELSE
      FILEIN2='RPPTHO.D'//numstr(2:4)
    ENDIF
    OPEN (UNIT=1,FILE=dout(1:ILEN2)//FILEIN2,STATUS='NEW')
    Ist=1
2155 Iast=K2max
    IF (Irel2(Ist+1).LE.0.D0) THEN
      Ist=Ist+1
      GOTO 2155
    ENDIF
    Ist=Ist+1
2160 IF (Irel2(Iast-1).LE.0.D0) THEN
      Iast=Iast-1
      GOTO 2160
    ENDIF
    Iast=Iast-1
    Jbit2=(Iast-Ist)/1000+1
    IF (Jbit2.LT.1) Jbit2=1
    IF (Iast-Jbit2.LE.Ist) GOTO 2165
    DO I=Ist,Iast-Jbit2,Jbit2	! <=1000 output steps
!93         Irel=0.D0
!93         Y1=0.D0
!93         Iscale=0
!93         DO 2162 Ibit=1,Jbit2
!93          Ich=I-1+Ibit
!93          Irel=Irel+Irel2(Ich)      	! output=mean of Jbit2 channels
!93          IF (Yrel(Ich,5).GT.0.D0) THEN	! mean y for all assigned y
!93           Y1=Y1+Yrel(Ich,2)
!93           Iscale=Iscale+1
!93          ENDIF
!932162     CONTINUE
!93         IF (Irel.LE.0.D0) GOTO 2165
!93         IF (Iscale.GT.0) Y1=Y1/DFLOAT(Iscale)
!93         Irel=Irel/DFLOAT(Jbit2)
      Thout=ThminoC(VL)+(DFLOAT(I)-5.D-1)/(STEPS3-1.D0) &
          *(ThmaxoC(VL)-ThminoC(VL))
!plate96  Best place to insert call to subroutine PLATEFUNCTION?
!plate96 SUBROUTINE PLATEFUNC (Detx,Thout,Cryrad,Cx,Thetaap2,
!plate96     1 Detarmlen,Detphi,Detalpha)
!plate96       WRITE(*,*) 'Thetaap2 just before call to platefunc',Thetaap2 
!plte96		CALL PLATEFUNC (Detx,Thout,GB(1),Cx,Thetaap2,
!plate96     1  Detarmlen,Detphi,Detalpha)			
!TC		uncommented by AV:
!V	 XD=DSQRT(Rzf**2+(GB(1)+Cx)**2-2.*Rzf*(GB(1)+Cx)*DCOS(ThetaD))*
!     1    (GB(1)*DCOS(Thout) - (0.5*GB(1)-Cx)*DCOS(Thout+Thetaap2)
!     2    - Rzf*DCOS(Thout-ThetaD-Thetaap2))/
!     3    (Rzf*DSIN(Thout-ThetaD-Thetaap2-Thetaob)
!     4	  -(GB(1)+Cx)*DSIN(Thout-Thetaap2-Thetaob))
!V	 WRITE(1,2145) Thout,Irel,I,Y1,XD
!93         WRITE(1,2145) Thout,Irel,I,Y1,Detx
!plate96         WRITE(1,2145) Thout,Irel2(I),I,Yrel(I,2)
      WRITE(1,2145) Thout,Irel2(I),I,Yrel(I,2),Detx
2165  CONTINUE
    END DO
    CLOSE(UNIT=1,STATUS='KEEP')
!plate96 output flag to delete output files		
    IF (Outfilesflag.EQ.4) THEN
      GOTO 2171
    ENDIF
2162 IF (numstr(1:1).EQ.'S') THEN
      FILEIN2='RPLYO.D'//numstr(2:4)
    ELSE
      FILEIN2='RPPYO.D'//numstr(2:4)
    ENDIF
    OPEN (UNIT=1,FILE=dout(1:ILEN2)//FILEIN2,STATUS='NEW')
    WRITE(*,*)'K3max,YminoC(VL),YmaxoC(VL),YozC(VL) in OUTFILS' &
        ,K3max,YminoC(VL),YmaxoC(VL),YozC(VL)
    Ist=1
2166 Iast=K3max
    IF (Irel3(Ist+1).LE.0.D0) THEN
      Ist=Ist+1
      GOTO 2166
    ENDIF
    Ist=Ist+1
2168 IF (Irel3(Iast-1).LE.0.D0) THEN
      Iast=Iast-1
      GOTO 2168
    ENDIF
    Iast=Iast-1
    Jbit3=(Iast-Ist)/1000+1
    IF (Jbit3.LT.1) Jbit3=1
    DO I=Ist,Iast-Jbit3,Jbit3      ! <=1000 output steps
      Irel=0.D0
      Y1=0.D0
      Iscale=0
      MeanI=0.D0
      DO Ibit=1,Jbit3
        Ich=I-1+Ibit
        MeanI=MeanI+Irel3(Ich)*DFLOAT(Ich)
        Irel=Irel+Irel3(Ich)      ! output=mean of Jbit3 channels
!93          IF (Yrel(Ich,6).GT.0.D0) THEN
        Y1=Y1+Yrel(Ich,3)*Irel3(Ich)            ! mean y for all >0.
!93           Iscale=Iscale+1
!93          ENDIF
      ENDDO
      IF (Irel.LE.0.D0) GOTO 2170
!93         IF (Iscale.GT.0) Y1=Y1/DFLOAT(Iscale)
      MeanI=MeanI/Irel
      Y1=Y1/Irel
      Irel=Irel/DFLOAT(Jbit3)      ! mean reflectivity
      Yshift=YminoC(VL)+(MeanI-.5D0)/(STEPS4-1.)*(YmaxoC(VL) &
          -YminoC(VL))-YozC(VL)
!plate96 Best place to insert call to subroutine PLATEFUNCTION?
!plate96       CALL PLATEFUNC (Detx,Thout,Thetaap2,GB(1),Cx,
!plate96     1 Detarmlen,Detphi,Detalpha) 
!TC		XD column in RP(P/LL)Yo implemented by AV; uncommented
!V	 XD=XDmin+(MeanI-.5)/(STEPS4-1.)*(XDmax-XDmin)-XD0
!V	 WRITE(1,2145) Yshift,Irel,I,Y1,XD
      WRITE(1,2146) Yshift,Irel,IDINT(MeanI),Y1,Yshift+YozC(VL)
!plate96         WRITE(1,2146) Yshift,Irel,IDINT(MeanI),Y1,Yshift+YozC(VL),Detx
2170  CONTINUE
    ENDDO
    CLOSE(UNIT=1,STATUS='KEEP')
    
!plate96 output flag to delete output files		
    IF (Outfilesflag.EQ.5) THEN
      GOTO 2171
    ENDIF
2262 IF (numstr(1:1).EQ.'S') THEN
      FILEIN2='RPLPL.D'//numstr(2:4)
    ELSE
      FILEIN2='RPPPL.D'//numstr(2:4)
    ENDIF
    OPEN (UNIT=1,FILE=dout(1:ILEN2)//FILEIN2,STATUS='NEW')
    WRITE(*,*)'K8max,Detminx(VL),Detmaxx(VL) in OUTFILS',K8max,Detminx(VL),Detmaxx(VL)
    Ist=1
2266 Iast=K8max
    IF (Irel8(Ist+1).LE.0.D0) THEN
      Ist=Ist+1
      GOTO 2266
    ENDIF
    Ist=Ist+1
2268 IF (Irel8(Iast-1).LE.0.D0) THEN
      Iast=Iast-1
      GOTO 2268
    ENDIF
    Iast=Iast-1
    Jbit8=(Iast-Ist)/1000+1
!out97   output all data points         
    IF (Maxlines.EQ.1) THEN
      Jbit8=1
    ENDIF
    IF (Jbit8.LT.1) Jbit8=1
!MK****************************************************************************************
!MK This section was altered from the mosplate98 code by Mark Kinnane (2/10/03). Previously
!MK the array 'Irel8', which describes the relative intensity over the detector face, was 
!MK scaled before being written to the RPPPL and RPLPL files. Now the entire raw array is 
!MK written to the files. The variable 'Detx' however is still a scaled value which is 
!MK derived by converting array position 'I' to detector position in units of 0.1 microns.
    
    DO I=Ist,Iast
      Irel=0.D0
      Detx=0.D0
      Irel=Irel8(I)
      Detx=Detminx(VL)+(DFLOAT(I)-1.D0)/(DFLOAT(STEPS8-1))* &
          (Detmaxx(VL)-Detminx(VL))
      WRITE(1,2146) Detx,Irel
    ENDDO
    
!MK****************************************************************************************
    CLOSE(UNIT=1,STATUS='KEEP')
  ENDIF
2171 IF (Fwrite(Inext).EQ.Ilist.AND.VL.EQ.1.AND.VARMAX.EQ.2) THEN
!		Open new RP files if more to come...
    numstr(4:4)=CHAR(ICHAR(numstr(4:4))+1)
  ELSEIF (Fwrite(Inext).EQ.Ilist.AND. &
      VL.EQ.2.AND.VARMAX.EQ.2) THEN
    numstr(4:4)=CHAR(ICHAR(numstr(4:4))-1)
  ENDIF
  IF (Fwrite(Inext).EQ.Ilist.AND.numstr(1:1).EQ.'P' &
      .AND.VL.EQ.VARMAX) THEN
    Isum=Isum+1
    Inext=Inext+1
    Iten=Isum/10
    numstr(1:1)='S'
  ELSEIF (Fwrite(Inext).EQ.Ilist.AND.numstr(1:1).EQ.'S' &
      .AND.VL.EQ.VARMAX) THEN
    numstr(1:1)='P'
  ENDIF
  numstr=numstr(1:1)//CHAR(48+Iten) &
      //CHAR(48+Isum-Iten*10)//numstr(4:4)
!92       IF (Fwrite(Inext).EQ.Ilist.AND.numstr(1:1).EQ.'P'
!92     1    .AND.VL.EQ.VARMAX) THEN
!			.OR.ANS.EQ.2.OR.ANS.EQ.3) THEN
!		Open new FFRC files if more to come...
!        IF (Fwrite(Inext+1).GT.0.OR.Fwrite(Inext).EQ.Ilist) THEN
!92         numstr='S'//CHAR(48+Item)//CHAR(48+Inext-Item*10)//numstr(4:4)
!92         FILEIN2='FFRC.S'//numstr(2:4)
!92         IF ((Ilist.EQ.0.OR.ANS.GT.1).AND.AGE.GE.1) THEN
!92          OPEN (UNIT=8,FILE=FILEIN2,STATUS='NEW')
!92         ELSE
!92          OPEN (UNIT=8,FILE=FILEIN2,STATUS='UNKNOWN')
!92         ENDIF
!92         CLOSE(8,STATUS='KEEP')
!        ENDIF
!92       ENDIF
  IF (Jbit1*Jbit2*Jbit3*Jbit4*Jbit8.GT.1) &
      WRITE(*,2173) Jbit1,Jbit2,Jbit3,Jbit4,Jbit8
2173 FORMAT(1X,'Calcd profile steps/ output profile step=' &
         ,5(1X,I3))
  RETURN
END
!--------------------------------------------------------------------------
!92   Sub-routine for 2d, Numcells and (reciprocal) lattice dimensions
!
SUBROUTINE GEN2D
  IMPLICIT NONE
!
  INTEGER iatoms,isites
  PARAMETER (iatoms=40,isites=3)
  INTEGER IDIG,nalphs,nelas,nbasis,ksites,natoms(iatoms) &
      ,nsites(iatoms),iZed(iatoms,isites),ntherm(iatoms,isites) &
      ,atomtype(iatoms,isites)
  DOUBLE PRECISION a01,b01,c01,calpha,cbeta,cgamma,Tref,aalph(6) &
      ,elast(6),fpop(iatoms,isites),btherm(iatoms,isites,6),xco(100,3)
  CHARACTER PLABEL(15)*12
  COMMON/XLATTICE/PLABEL,IDIG,nalphs,nelas,nbasis,ksites,natoms &
      ,nsites,iZed,ntherm,atomtype &
      ,a01,b01,c01,calpha,cbeta,cgamma,Tref &
      ,aalph,elast,fpop,btherm,xco
!92		Z, populations, f0 for each crystal unit cell:
  INTEGER ielem
  PARAMETER (ielem=20)
  INTEGER natomtypes,kZed(ielem),Ifeff
  DOUBLE PRECISION Zeff(ielem),kpop(ielem)
  COMPLEX*16 F0(3),F0n(ielem)
  COMMON/FEFF/natomtypes,kZed,Ifeff,Zeff,kpop,F0,F0n
!92		Separate THREEBM/GEN2D parameters:
  INTEGER IM(4)
  DOUBLE PRECISION a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,d2,xTemp
  DOUBLE PRECISION Numcells
  COMPLEX*16 FHr, FHi, FHn(ielem)
  common/com2d/ IM,a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,Numcells,d2,xTemp,FHr,FHi,FHn
!		local variables
  DOUBLE PRECISION stmp,sstmp
  INTEGER LM(4),I
  DOUBLE PRECISION New2d
  EXTERNAL New2d
!
  IF (xTemp.LT.0.D0) xTemp=Tref
  IF (nalphs.EQ.1) THEN		! isotropic?
    aalph(2)=aalph(1)
    aalph(3)=aalph(1)
  ENDIF
!91		thermal expansion
  a02=a01*(1.D0+aalph(1)*(xTemp-Tref))
  b02=b01*(1.D0+aalph(2)*(xTemp-Tref))
  c02=c01*(1.D0+aalph(3)*(xTemp-Tref))
  stmp=(calpha+cbeta+cgamma)/2.D0
  sstmp=DSIN(stmp)*DSIN(stmp-calpha) &
      *DSIN(stmp-cbeta)*DSIN(stmp-cgamma)
  Volcell=2.D0*a02*b02*c02*DSQRT(sstmp)	! Angstroms^3
  Numcells=1.D30/Volcell
!92		additional for reciprocal manipulations:
  ast=b02*c02*DSIN(calpha)/Volcell
  bst=a02*c02*DSIN(cbeta)/Volcell
  cst=a02*b02*DSIN(cgamma)/Volcell
  alpst=DACOS((DCOS(cbeta)*DCOS(cgamma)-DCOS(calpha)) &
      /DSIN(cbeta)/DSIN(cgamma))
  betst=DACOS((DCOS(calpha)*DCOS(cgamma)-DCOS(cbeta)) &
      /DSIN(calpha)/DSIN(cgamma))
  gamst=DACOS((DCOS(calpha)*DCOS(cbeta)-DCOS(cgamma)) &
      /DSIN(calpha)/DSIN(cbeta))
  DO I=1,4
    LM(I)=IM(I)
  ENDDO
  d2=new2d(LM)
  RETURN
END
!--------------------------------------------------------------------------
!92   Function for d2 lattice plane spacing
!
DOUBLE PRECISION FUNCTION new2D(LM)
  IMPLICIT NONE
!		passed variable
  INTEGER LM(4)
!
  INTEGER iatoms,isites
  PARAMETER (iatoms=40,isites=3)
  INTEGER IDIG,nalphs,nelas,nbasis,ksites,natoms(iatoms) &
      ,nsites(iatoms),iZed(iatoms,isites),ntherm(iatoms,isites) &
      ,atomtype(iatoms,isites)
  DOUBLE PRECISION a01,b01,c01,calpha,cbeta,cgamma,Tref,aalph(6) &
      ,elast(6),fpop(iatoms,isites),btherm(iatoms,isites,6),xco(100,3)
  CHARACTER PLABEL(15)*12
  COMMON/XLATTICE/PLABEL,IDIG,nalphs,nelas,nbasis,ksites,natoms &
      ,nsites,iZed,ntherm,atomtype &
      ,a01,b01,c01,calpha,cbeta,cgamma,Tref &
      ,aalph,elast,fpop,btherm,xco
  INTEGER ielem
  PARAMETER (ielem=20)
!92		Separate THREEBM/GEN2D parameters:
  INTEGER IM(4)
  DOUBLE PRECISION a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,d2,xTemp
  DOUBLE PRECISION Numcells
  COMPLEX*16 FHr, FHi, FHn(ielem)
  common/com2d/ IM,a02,b02,c02,ast,bst,cst,alpst,betst,gamst &
      ,Volcell,Numcells,d2,xTemp,FHr,FHi,FHn
!		local variables
  DOUBLE PRECISION MH,MK,ML
  DOUBLE PRECISION stmp,sstmp
  INTEGER i
!
  MH=DFLOAT(LM(1))
  MK=DFLOAT(LM(2))
  ML=DFLOAT(LM(idig))
!		calculate twod
  stmp=(calpha+cbeta+cgamma)/2.D0
  sstmp=DSIN(stmp)*DSIN(stmp-calpha) &
      *DSIN(stmp-cbeta)*DSIN(stmp-cgamma)
!test
!      write(*,*) ' new2d check:',(LM(i),i=1,idig),a02,b02,c02
!     1,calpha,cbeta,cgamma,stmp,sstmp
!t
  new2d=2.D0*DSQRT(sstmp)/DSQRT((MH*DSIN(calpha)/2.D0/a02)**2.D0+ &
      (MK*DSIN(cbeta)/2.D0/b02)**2.D0+(ML*DSIN(cgamma)/2.D0/c02)**2.D0 &
      +MK*ML*(DCOS(cbeta)*DCOS(cgamma)-DCOS(calpha))/2.D0/b02/c02 &
      +ML*MH*(DCOS(cgamma)*DCOS(calpha)-DCOS(cbeta))/2.D0/c02/a02 &
      +MH*MK*(DCOS(calpha)*DCOS(cbeta)-DCOS(cgamma))/2.D0/a02/b02)
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE RTSET(rtime,ttime,J)
!	       reflectivity and transmission coefficients
  IMPLICIT NONE
  DOUBLE PRECISION rtime	 &! diffraction reflectivity, OUTPUT
      ,ttime					! transmission coefficient
  INTEGER J
  INTEGER ffs
  PARAMETER (ffs=30100)
!U96: thtem is erroneous - eliminate commons
!      INTEGER ISTEPSO,ISTEPSP
!      PARAMETER (ISTEPSO=8000,ISTEPSP=8001)
!      COMPLEX*16 DPSI0, DPSIHr, DPSIHi
!      DOUBLE PRECISION Thm2,Thm3,Temthm2,Temthm3,Yrel(ISTEPSP,6),
!     1 Thtem(ffs),Rtem(ffs),Ttem(ffs),Ytem(ffs),dely0,dely0t,mufilm,
!     2 TEMUL,Mphotoshift,mdepth(6),mthld(6),emthld(2)
!     3 ,mcontl,meanff(7,2),maxdp,maxdm,thff,Chinit,Chfin
!      DOUBLE PRECISION Rzf,Cx
!      DOUBLE PRECISION fscale,RtemC(ffs),TtemC(ffs),Tabdy(ffs,4),mYo(6)
!      DOUBLE PRECISION BXm,BXx
!      INTEGER fof,detmatch,ip
!      COMMON/CS5E/ DPSI0,DPSIHr,DPSIHi,Thm2,Thm3,Temthm2,Temthm3,Yrel,
!     1 Thtem,Rtem,Ttem,Ytem,dely0,dely0t,mufilm,TEMUL,Mphotoshift,
!     2 mdepth,mthld,emthld,mcontl,meanff,maxdp,maxdm,thff
!     3 ,Chinit,Chfin,Rzf,Cx,fscale,RtemC,TtemC
!     4 ,Tabdy,mYo,BXm,BXx,fof,detmatch,ip
!93atest:
  DOUBLE PRECISION Thtem2(ffs),Rtem2(ffs),Ttem2(ffs)
  COMMON/FFREFL/Thtem2,Rtem2,Ttem2
!93atest-
!Uthick:
!      rtime=Rtem(J)
!      ttime=Ttem(J)
!Uthin:
  rtime=Rtem2(J)
  ttime=Ttem2(J)
!U96-
  RETURN
END
!--------------------------------------------------------------------------
DOUBLE PRECISION FUNCTION THSET(J)
!	       reflectivity and transmission coefficients
  IMPLICIT NONE
  INTEGER J
  INTEGER ffs
  PARAMETER (ffs=30100)
!U96: thtem is erroneous - eliminate commons
!      INTEGER ISTEPSO,ISTEPSP
!      PARAMETER (ISTEPSO=8000,ISTEPSP=8001)
!      COMPLEX*16 DPSI0, DPSIHr, DPSIHi
!      DOUBLE PRECISION Thm2,Thm3,Temthm2,Temthm3,Yrel(ISTEPSP,6),
!     1 Thtem(ffs),Rtem(ffs),Ttem(ffs),Ytem(ffs),dely0,dely0t,mufilm,
!     2 TEMUL,Mphotoshift,mdepth(6),mthld(6),emthld(2)
!     3 ,mcontl,meanff(7,2),maxdp,maxdm,thff,Chinit,Chfin
!      DOUBLE PRECISION Rzf,Cx
!      DOUBLE PRECISION fscale,RtemC(ffs),TtemC(ffs),Tabdy(ffs,4),mYo(6)
!      DOUBLE PRECISION BXm,BXx
!      INTEGER fof,detmatch,ip
!      COMMON/CS5E/ DPSI0,DPSIHr,DPSIHi,Thm2,Thm3,Temthm2,Temthm3,Yrel,
!     1 Thtem,Rtem,Ttem,Ytem,dely0,dely0t,mufilm,TEMUL,Mphotoshift,
!     2 mdepth,mthld,emthld,mcontl,meanff,maxdp,maxdm,thff
!     3 ,Chinit,Chfin,Rzf,Cx,fscale,RtemC,TtemC
!     4 ,Tabdy,mYo,BXm,BXx,fof,detmatch,ip
!93atest:
  DOUBLE PRECISION Thtem2(ffs),Rtem2(ffs),Ttem2(ffs)
  COMMON/FFREFL/Thtem2,Rtem2,Ttem2
!93atest-
!Uthick:
!      THSET=Thtem(J)
!Uthin:
  THSET=Thtem2(J)
!U96-
  
  RETURN
END
!--------------------------------------------------------------------------
SUBROUTINE TABSET(adely,adelth,I)
!	       layer width in diffraction space
  IMPLICIT NONE
  DOUBLE PRECISION adely	 &! diffracting width, OUTPUT
      ,adelth					! width in theta
  INTEGER I
  INTEGER ffs
  PARAMETER (ffs=30100)
!U96: thtem is erroneous - eliminate commons
!      INTEGER ISTEPSO,ISTEPSP
!      PARAMETER (ISTEPSO=8000,ISTEPSP=8001)
!      COMPLEX*16 DPSI0, DPSIHr, DPSIHi
!      DOUBLE PRECISION Thm2,Thm3,Temthm2,Temthm3,Yrel(ISTEPSP,6),
!     1 Thtem(ffs),Rtem(ffs),Ttem(ffs),Ytem(ffs),dely0,dely0t,mufilm,
!     2 TEMUL,Mphotoshift,mdepth(6),mthld(6),emthld(2)
!     3 ,mcontl,meanff(7,2),maxdp,maxdm,thff,Chinit,Chfin
!      DOUBLE PRECISION Rzf,Cx
!      DOUBLE PRECISION fscale,RtemC(ffs),TtemC(ffs),Tabdy(ffs,4),mYo(6)
!      DOUBLE PRECISION BXm,BXx
!      INTEGER fof,detmatch,ip
!      COMMON/CS5E/ DPSI0,DPSIHr,DPSIHi,Thm2,Thm3,Temthm2,Temthm3,Yrel,
!     1 Thtem,Rtem,Ttem,Ytem,dely0,dely0t,mufilm,TEMUL,Mphotoshift,
!     2 mdepth,mthld,emthld,mcontl,meanff,maxdp,maxdm,thff
!     3 ,Chinit,Chfin,Rzf,Cx,fscale,RtemC,TtemC
!     4 ,Tabdy,mYo,BXm,BXx,fof,detmatch,ip
!93atest:
  DOUBLE PRECISION Tabdy2(ffs,4)
  COMMON/FFTable/Tabdy2
!93atest-
!Uthick:
!      adely=Tabdy(I,4)
!      adelth=Tabdy(I,3)
!Uthin:
  adely=Tabdy2(I,4)
  adelth=Tabdy2(I,3)
!U96-
  RETURN
END
!--------------------------------------------------------------------------
