function read_csv2, filename, STRUCT=struct
;print,'reading file called '+filename+'...'

column_names = ''
line2 = '  '
openr, unit, filename, /get_lun
readf, unit, column_names
readf, unit, line2
close,unit & free_lun,unit

n_lines = 0L
n_lines = file_lines(filename)

if ~keyword_set(struct) then begin
	tags = STRSPLIT(column_names, ',', /EXTRACT)
	Ntags = n_elements(tags)
	
	; Now we create an array, called floating, that contains a binary variable for
	; each tag telling us whether the tag stores floating point number. Any column
	; that contains a decimal point is assumed to hold floating point numbers
	
	floating = intarr(Ntags)
	is_array = intarr(Ntags)
	for t=0,Ntags-1 do begin   ; loop over tags
	  test = strsplit(line2,',',/EXTRACT)
	  test = test[t]
	  floating[t] = STREGEX(test,'\.',/BOOLEAN)
	  is_array[t] = STREGEX(tags[t],'\[',/BOOLEAN)
	endfor ; end loop over tags
	
	
	; Creates a structure, the tag names come from the titles of the columns.
	; Each tag is associated with type LONG or DOUBLE depending on the
	; results stored in the array called floating
	
	command_string = 'structure = CREATE_STRUCT(real_tags'
	t=0
	real_tags = [' ']
	while t lt Ntags do begin   ; loop over tags
	  len=0
	  flag=0
	  a=0
	  if is_array[t] then begin
	    tag = (strsplit(tags[t],'[',/EXTRACT))[0]
	    while a lt 9999L do begin
	      if STREGEX(tags[t+a],tag,/BOOLEAN,/FOLD_CASE) then begin
	        len=len+1
	      endif else begin
	        t=t+a-1
	        command_string = command_string +',dblarr('+strtrim(string(a),2)+')'
	        a = 10001L
	        flag=1
	        real_tags = [real_tags,tag]
	      endelse
	      a=a+1
	    endwhile
	
	  endif
	
	
	  if flag eq 0 then begin
	    if floating[t] then begin
	      command_string = command_string +',0.D'
	    endif else begin
	      command_string = command_string +',0L'
	    endelse
	    real_tags = [real_tags,tags[t]]
	  endif
	
	  t=t+1
	endwhile ; end loop over tags
	command_string = command_string +')'
	real_tags = real_tags[1:*]
	
	null = execute(command_string)
endif else begin
	structure = struct
endelse

data = ( replicate(structure, n_lines-1) )

; Reads the information from the specified file into the array of structures
; called data

openr, unit, filename, /get_lun
header=''
readf, unit, header
readf, unit, data
close,unit & free_lun,unit

;print,'file called '+filename+' read!'
return,data
end