************************************************************************
*                                                                      *
      SUBROUTINE ES0 (F,S0F)
*                                                                      *
*   Evaluate the sum of the series                                     *
*                                                                      *
*                       infinity      n              k                 *
*              S  (F) =   Sum     (-1)  exp (n*F) / n                  *
*               k        n = 0                                         *
*                                                                      *
*   for k = 0 to machine precision                                     *
*                                                                      *
*   Written by John Lowe, at Melbourne University.                     *
*                                                                      *
************************************************************************
*
      IMPLICIT REAL*8       (A-H, O-Z)
*
      N = 0
      S0F = 0.0D 00
      FASE = 1.0D 00
    1 N = N + 1
         EN = DBLE (N)
         FASE = -FASE
         ENF = EXP(EN * F)
         TERM = FASE * ENF
         SLAST = S0F
         S0F = S0F + TERM
         IF (ABS (S0F) .NE. ABS (SLAST)) GOTO 1
*
      RETURN
      END
