************************************************************************
*                                                                      *
      SUBROUTINE SCREENING (SLFINT)
*                                                                      *
*   This  routine estimates corrections to the  energy levels due to   *
*   self-energy.                                                       *
*                                                                      *
*   Call(s) to: [LIB92]: ALLOC, DALLOC, IQ, QUAD, RALLOC, SCREEN.      *
*               [RCI92]: FZALF, HOVLAP.                                *
*                                                                      *
*                                           Last update: 30 Oct 1992   *
*   Modified by Xinghong He                 Last update: 24 Jun 1997   *
*   Modified by John Lowe                   Last update: Sept 2012     *
*                                                                      *
************************************************************************
*
      IMPLICIT REAL*8          (A-H, O-Z)
      include 'parameters.def'
c      PARAMETER (NNNP = 590)
c      PARAMETER (NNN1 = NNNP+10)

c      PARAMETER (NNNW = 120)
      POINTER (PNTRIQ,RIQDUMMY)
      CHARACTER*4 JLBL,LABJ,LABP
      POINTER (PNIVEC,IVECDUMMY)
      CHARACTER*2 NH, npchar*1, nakchar
      LOGICAL LSE,DSCREEN,DFS
      REAL*8 valu1

      DIMENSION RATIO1(NW),RATIO2(NW),RATIO3(NW),RATIO4(NW),RATIO5(NW),
     : fza(NW),valu1(nw),valu2(nw),valu3(nw),valu4(nw),valu5(nw),
     : dfza(NW), valu6(nw)
*
      DIMENSION UCF(1)
*
      POINTER (PNEVEC,EVEC(1))
      POINTER (PNTRPF,PF(NNNP,1))
      POINTER (PNTRQF,QF(NNNP,1))
*
      pointer (pntrhpf, hpf(nnnp,1))
      pointer (pntrhqf, hqf(nnnp,1))
*
      DIMENSION PTEMP(NNNP),QTEMP(NNNP)
      DIMENSION HPTEMP(NNNP),HQTEMP(NNNP)
      DIMENSION SLFINT1(NNNW), SLFINT2(NNNW), SLFINT3(NNNW),
     :          SLFINT4(NNNW), SLFINT(NNNW)
*
      COMMON/DECIDE/LFORDR,LTRANS,LVP,LSE,LNMS,LSMS
      COMMON/DEF1/EMN,IONCTY,NELEC,Z
     :      /hydwav/pntrhpf,pntrhqf,henergy(nnnw)
     :      /SCREENBLK/NSCREEN,DSCREEN,DFS
     :      /DEF2/C
     :      /DEF9/CVAC,PI
     :      /DEF11/FMTOAU
     :      /EIGVEC/PNEVEC
     :      /GRID/R(NNN1),RP(NNN1),RPOR(NNN1),RNT,H,HP,N
     :      /HORB/PH(NNNP),QH(NNNP)
     :      /NLAP/ZLAP(NNNP)
     :      /NPAR/PARM(2),NPARM
     :      /JLABL/JLBL(32),LABJ(32),LABP(2)
     :      /ORB2/NCF,NW,PNTRIQ
     :      /ORB4/NP(NNNW),NAK(NNNW)
     :      /ORB10/NH(NNNW)
     :      /PRNT/NVEC,PNIVEC,NVECMX
     :      /TATB/TA(NNN1),TB(NNN1),MTP
     :      /WAVE/PZ(NNNW),PNTRPF,PNTRQF,MF(NNNW)
     :      /DEF10/AUCM,AUEV,CCMS,FASI,FBSI
     :      /DEFAULT/NDEF
*
*
*   Calculate the laplacian of the nuclear laplacian
*
*
      call nuclap
*
*   Loop over subshells
*
      DO 14 J = 1,NW
*
         NPJ = NP(J)
*
         IF (NPJ .LE. 8) THEN
*
*   Only orbitals with principal quantum number 8 or less can
*   be treated by this section of code
*
            KAPPA = NAK(J)
*
*   Begin by transferring the function to a temporary array
*
            MFJ = MF(J)
*
            PTEMP(1) = 0.0D 00
            QTEMP(1) = 0.0D 00
            DO 5 I = 2,MFJ
               PTEMP(I) = PF(I,J)
               QTEMP(I) = QF(I,J)
               HPTEMP(I) = HPF(I,J)
               HQTEMP(I) = HQF(I,J)
    5       CONTINUE
            zeff =z

            if (DFS.EQV..TRUE.) then
                nscreen = 5
            endif
* Unscreened self energy:
                if (nscreen .eq. 1) then
                    RATIO = 1.0D 00
* The following is the original GRASP method for calculating
* screening. Uses the overlap between actual wavefunction and
* a hydrogenic (point nucleus) function. But only for a small
* region around the nucleus
                else if (nscreen .eq. 2) then
                    RATIO=ratden(PTEMP,QTEMP,MFJ,NPJ,KAPPA,ZEFF)
*   This section calculates the raito of the wavefunction density
*   at the nucleus to the wavefunction density of a hydrogenic
*   function at the nucleus (point nucleus). Because this uses a
*   point nucleus, results are often innaccurate. Need to compare
*   this result with a hydrogenic self-consistent model with finite
*   nucleus to cancel out the bad bit.
                else if (nscreen .eq. 3) then
                    RATIO=ratcen(PTEMP,QTEMP,MFJ,NPJ,KAPPA,ZEFF)
*   This section does what GRASP is supposed to do, which is to
*   take the overlap of the wavefunction with a hydrogenic (point
*   nucleus) wave function and return that.
                else if (nscreen .eq. 4) then
                    RATIO=ratovlap(PTEMP,QTEMP,MFJ,NPJ,KAPPA,ZEFF)
*   This section uses the laplacian of the potential energy
*   to weight the overlap.
                else if (nscreen .eq. 5) then
                    ! Check that wavefunctions were loaded for this J
                    if (henergy(j) .lt. 0) then
                        print *, "SCREENING: Missing hydrogenic " //
     :                            "wavefunction for j = ", j
                        RATIO=ratden(PTEMP,QTEMP,MFJ,NPJ,KAPPA,ZEFF)
                    else
                        RATIO=ratlap(PTEMP,QTEMP,HPTEMP,HQTEMP,MFJ)
                    endif
                endif

                if (DSCREEN) then
                    ratio1(j) = 1.0D00
                    ratio2(j) = ratden(ptemp,qtemp,mfj,npj,kappa,zeff)
                    ratio3(j) = ratcen(ptemp,qtemp,mfj,npj,kappa,zeff)
                    ratio4(j) = ratovlap(ptemp,qtemp,mfj,npj,kappa,zeff)
                    ratio5(j) = ratlap(ptemp,qtemp,hptemp,hqtemp,mfj)
                    if (parm(2) .ne. 0d0) then
                        rrms = ESTRMS(PARM(2)/FMTOAU, PARM(1)/FMTOAU)
                        fza(j) = fzalf(npj,kappa,zeff)  
     :                           + fzalffin(npj,kappa,zeff,rrms)
                    else
                        fza(j) = fzalf(npj,kappa,zeff)
                    endif
                    valu1(j) = ratio1(j) * fza(j) /
     :                      dble(npj**3) * zeff**4/(pi*c**3)
                    valu2(j) = ratio2(j) * fza(j) /
     :                      dble(npj**3) * zeff**4/(pi*c**3)
                    valu3(j) = ratio3(j) * fza(j) /
     :                      dble(npj**3) * zeff**4/(pi*c**3)
                    valu4(j) = ratio4(j) * fza(j) /
     :                      dble(npj**3) * zeff**4/(pi*c**3)
                    valu5(j) = ratio5(j) * fza(j) /
     :                      dble(npj**3) * zeff**4/(pi*c**3)
                    valu6(j) = ratio1(j) * (fza(j) + dfza(j)) /
     :                      dble(npj**3) * zeff**4/(pi*c**3)
                endif

            if (parm(2) .ne. 0d0) then
                RRMS = ESTRMS(PARM(2)/FMTOAU, PARM(1)/FMTOAU)
                VALU = RATIO 
     :                 *(FZALF (NPJ,KAPPA,ZEFF) +
     :                   FZALFFIN (NPJ,KAPPA,ZEFF,RRMS))
     :                 /DBLE (NPJ**3)
            else
                VALU = RATIO * FZALF(NPJ,KAPPA,ZEFF)
     :                 /DBLE (NPJ**3)
            endif
            SLFINT(J) = VALU*ZEFF**4/(PI*C**3)
         ELSE
*
*   The self-energy for orbitals with principal quantum number
*   greater than 8 is set to zero
*
            SLFINT(J) = 0.0D 00
*
         ENDIF

   14 CONTINUE
         if (DSCREEN) then
             write (74,*) 'Self energy per electron (Hartrees):'
             write(74,'(A20,A30,A30,A30,A30,A30)')
     :      "Shell","Unscreened", "Original GRASP","Nuclear Density",
     :       "Hydrogenic projection", "Welton"

             do j=1,nw
                 write(74,
     :           '(I18,A2,D30.7,D30.7,D30.7,D30.7,D30.7)')
     :           np(j),nh(j),valu1(j),valu2(j),valu3(j),
     :           valu4(j),valu5(j)
             enddo

             write (74,*) 'Screening ratios:'
             write(74,'(A20,A30,A30,A30,A30,A30)')
     :      "Shell","Unscreened", "Original GRASP","Nuclear Density",
     :       "Hydrogenic projection", "Welton"
             do j=1, nw
                 write(74,
     :           '(I18,A2,D30.7,D30.7,D30.7,D30.7,D30.7)')
     :           np(j),nh(j),ratio1(j),ratio2(j),ratio3(j),
     :           ratio4(j),ratio5(j)
             enddo

             write (74,*) 'Effective F(Z alpha)'
             write(74,'(A20,A30,A30,A30,A30,A30)')
     :      "Shell","Unscreened", "Original GRASP","Nuclear Density",
     :       "Hydrogenic projection", "Welton"
             do j=1, nw
                 write(74,
     :           '(I18,A2,D30.7,D30.7,D30.7,D30.7,D30.7)')
     :              np(j),nh(j),ratio1(j)*fza(j),ratio2(j)*fza(j),
     :              ratio3(j)*fza(j),ratio4(j)*fza(j),ratio5(j)*fza(j)
             enddo
             write (74,*) 'Nuclear size effect on F(Z alpha)'
             write (74,*) 'Unscreened energy, Nuclear effect (eV)'
             do j=1, nw
                 write(74,'(I18,A2,D30.7,D30.7)')
     :                np(j),nh(j),valu1(j),valu6(j)
             enddo
          endif

      RETURN
      END


************************************************************************
*                                                                      *
      FUNCTION RATCEN (P,Q,HPF,HQF,MTPO,NP,KAPPA,Z)
*                                                                      *
*   This program returns the ratio of the denisty of the wavefunction  *
*   at the nucleus to the density of a hydrogenic wavefunction at the  *
*   nucleus                                                            *
*                                                                      *
************************************************************************
*
      IMPLICIT REAL*8          (A-H, O-Z)
      include 'parameters.def'
c      PARAMETER (NNNP = 590)
c      PARAMETER (NNN1 = NNNP+10)

c      PARAMETER (NNNW = 120)
*
      DIMENSION P(NNNP),Q(NNNP)
*
      COMMON/GRID/R(NNN1),RP(NNN1),RPOR(NNN1),RNT,H,HP,N
     :      /HORB/PH(NNNP),QH(NNNP)
     :      /TATB/TA(NNN1),TB(NNN1),MTP
     :      /NPOT/ZZ(NNNP),NNUC


*
*   Set up the hydrogenic orbital
*
      CALL DCBSRW (NP,KAPPA,Z,EH,PZH,PH,QH,MTPH)
*
*   Compute the values at r = 0
*   Actually at the fourth radial point, because the first three for the
*   self-consistent ones are exactly 0.
*
      DENSA = P(5)*P(5) + Q(5)*Q(5)
      DENSB = PH(5)*PH(5) + QH(5)*QH(5)
      do i=1,nnnp
        ppp = p(i) * p(i) + q(i) * q(i)
        qqq = ph(i) * ph(i) + qh(i) * qh(i)
      enddo

      RATCEN = DENSA / DENSB

      RETURN
      END

************************************************************************
*                                                                      *
      FUNCTION RATLAP (P,Q,HPF,HQF,MTPO)
*                                                                      *
*   This program computes the value                                    *
*                                                                      *
*           < Y | laplacian( V(r) ) | Y >                              *
*                                                                      *
*   ie. the expectation value of the laplacian of the nuclear          *
*       potential for the wavefunction defined by P and Q with MTPO    *
*                                                                      *
************************************************************************
*
      implicit real*8       (a-h, o-z)
      include 'parameters.def'
c      PARAMETER (NNNP = 590)
c      PARAMETER (NNN1 = NNNP+10)

c      PARAMETER (NNNW = 120)
      real*8 numer,denom
*
      dimension p(nnnp), q(nnnp)
      dimension hpf(nnnp), hqf(nnnp)
*
      common/GRID/r(nnn1),rp(nnn1),rpor(nnn1),rnt,h,hp,n
     :      /TATB/ta(nnn1),tb(nnn1),mtp
     :      /NLAP/zlap(nnnp)
*
      ta(1) = 0.0D 00
      do i=2,mtpo
        ta(i) = (p(i) * p(i) + q(i) * q(i))*rp(i)*zlap(i)
      enddo
      call quad(result)
      numer = result
      ta(1) = 0.0D 00
      do i=2,mtpo
        ta(i) = (hpf(i) * hpf(i) + hqf(i) * hqf(i))*rp(i)*zlap(i)
      enddo
      call quad(result)
      denom = result
      ratlap = min(numer/denom,1D0)
*
      return
      end

************************************************************************
*                                                                      *
      FUNCTION RATOVLAP (P,Q,MTPO,NP,KAPPA,Z)
*                                                                      *
*   This program computes what RATDEN in qed.f says that it is         *
*   calculating. ie. overlap of actual wavefunction with a hydrogenic  *
*   one.                                                               *
*                                                                      *
************************************************************************
*
      IMPLICIT REAL*8          (A-H, O-Z)
      include 'parameters.def'
c      PARAMETER (NNNP = 590)
c      PARAMETER (NNN1 = NNNP+10)

c      PARAMETER (NNNW = 120)
*
      DIMENSION P(NNNP),Q(NNNP)
*
      COMMON/GRID/R(NNN1),RP(NNN1),RPOR(NNN1),RNT,H,HP,N
     :      /HORB/PH(NNNP),QH(NNNP)
     :      /TATB/TA(NNN1),TB(NNN1),MTP
*
*   Set up the hydrogenic orbital
*
      CALL DCBSRW (NP,KAPPA,Z,EH,PZH,PH,QH,MTPH)
*
*   Compute the overlap
*
      MTP = MIN (MTPH,MTPO)
      TA(1) = 0.0D 00
      DO 1 I = 2,MTP
          TA(I) = (P(I)*PH(I)+Q(I)*QH(I))*RP(I)
c         TA(I) = (P(I)*PH(I)+Q(I)*QH(I))*RP(I)
    1 CONTINUE
      CALL QUAD (RESULT)
*
      RATOVLAP = RESULT
*
      RETURN
      END
