************************************************************************
*                                                                      *
      SUBROUTINE NUCLAP
*                                                                      *
*   Evaluate the laplacian of the  nuclear potential for point and     *
*   Fermi models. Stores the result in /NLAP/zlap(nnnp)                *
*                                                                      *
*   Call(s) to: [LIB92] ES0.                                           *
*                                                                      *
*   Written by John A Lowe, at Melbourne University                    *
*                                                                      *
************************************************************************
*
      implicit real*8       (a-h, o-z)
      parameter (nnnp = 590)
      parameter (nnn1 = nnnp+10)
*
      common/DEF1/emn,ioncty,nelec,z
     :      /DEF9/cvac,pi
     :      /GRID/r(nnn1),rp(nnn1),rpor(nnn1),rnt,h,hp,n
     :      /NPAR/parm(2),nparm
     :      /NPOT/zz(nnnp),nnuc
     :      /NLAP/zlap(nnnp)
*
*   Point Nucleus
*
      if (nparm .eq. 0) then 
*
        zlap(1) = 1.0d 00

        do 10 i = 2, nnnp
            zlap(i) = 0.0d 00
  10    continue
*
*   Fermi Distribution
*
*
*
      elseif (nparm .eq. 2) then
*
*  Set up constants for calculation
*
        c = parm(1)
        a = parm(2)
        abc = a/c
        abc2 = abc * abc
        abc3 = abc2 * abc
        cba = c/a
        pi2 = pi * pi
        c3 = c * c * c
        nt1 = 1.0D 00
        nt2 = pi2 * abc2
        call ES (-cba, s2mcba, s3mcba)
        nt3 = -6.0D00 * abc3 * s3mcba
        nt = nt1 + nt2 + nt3
        zbnc3 = z / (n * c * c * c)
*
*  Now loop over radial grid
*
      print *, n
      do 20 i = 1,n
        ri = r(i)
        rmc = ri - c
        rmcba = rmc / a
        rbc = ri / c
        if (rbc .le. 1.0D 00) then
            call es0 (rmcba, s0rmcba)
            zlap(i) = 3.0D 00 * zbnc3 * (s0rmcba + 1.0D 00)
        else
            call es0(-rmcba, s0rmcba)
            zlap(i) = -3.0D 00 * zbnc3 * s0rmcba
        endif
  20  continue
      endif

      end
