************************************************************************
*                                                                      *
      SUBROUTINE MOHRFIN (N,KAPPA,Z,R,DELTAFZ)
*                                                                      *
*   The  function  F (Z*alpha)  for the  1s  2s  2p-  2p  symmetries   *
*   is computed here.    A value is obtained by interpolating in, or   *
*   extrapolating from, the table due to  P J Mohr.   See  P J Mohr,   *
*   At Data Nucl Data Tables 29 (1983) 453.                            *
*                                                                      *
*   Call(s) to: [LIB92]: INTERP.                                       *
*                                                                      *
*   Written by Farid A Parpia, at Oxford    Last update: 09 Oct 1992   *
*                                                                      *
************************************************************************
*
      IMPLICIT REAL*8          (A-H, O-Z)
*
*----------------------------------------------------------------------*
*
*   Number of data points
*
      DIMENSION VALFIN2S(85)
      DIMENSION ARGFIN2S(85)
      PARAMETER (NUMVFIN2S = 85)

      DIMENSION VALPARA(110)
      DIMENSION ARGPARA(110)
      PARAMETER (NUMVPARA = 110)

      DIMENSION VALPARP(110)
      DIMENSION ARGPARP(110)
      PARAMETER (NUMVPARP = 110)

      DIMENSION VALPARB(110)
      DIMENSION ARGPARB(110)
      PARAMETER (NUMVPARB = 110)

      DIMENSION VALRREF(85)
      DIMENSION ARGRREF(85)
      PARAMETER (NUMVRREF = 85)

      DIMENSION VALFIN1S(85)
      DIMENSION ARGFIN1S(85)
      PARAMETER (NUMVFIN1S = 85)

      DIMENSION VALPARC(110)
      DIMENSION ARGPARC(110)
      PARAMETER (NUMVPARC = 110)

      DIMENSION VALFIN2P1(85)
      DIMENSION ARGFIN2P1(85)
      PARAMETER (NUMVFIN2P1 = 85)

      DATA VALFIN2S/
     :               3.059280000000D 00,
     :               2.999370000000D 00,
     :               2.942780000000D 00,
     :               2.889250000000D 00,
     :               2.838590000000D 00,
     :               2.790590000000D 00,
     :               2.745080000000D 00,
     :               2.701900000000D 00,
     :               2.660900000000D 00,
     :               2.621970000000D 00,
     :               2.584960000000D 00,
     :               2.549800000000D 00,
     :               2.516370000000D 00,
     :               2.484560000000D 00,
     :               2.454320000000D 00,
     :               2.425540000000D 00,
     :               2.398180000000D 00,
     :               2.372170000000D 00,
     :               2.347430000000D 00,
     :               2.323930000000D 00,
     :               2.301620000000D 00,
     :               2.280440000000D 00,
     :               2.260330000000D 00,
     :               2.241290000000D 00,
     :               2.223260000000D 00,
     :               2.206200000000D 00,
     :               2.190060000000D 00,
     :               2.174910000000D 00,
     :               2.160590000000D 00,
     :               2.147180000000D 00,
     :               2.134600000000D 00,
     :               2.122840000000D 00,
     :               2.111890000000D 00,
     :               2.101720000000D 00,
     :               2.092330000000D 00,
     :               2.083670000000D 00,
     :               2.075680000000D 00,
     :               2.068580000000D 00,
     :               2.062030000000D 00,
     :               2.056400000000D 00,
     :               2.051410000000D 00,
     :               2.046970000000D 00,
     :               2.043330000000D 00,
     :               2.040480000000D 00,
     :               2.037950000000D 00,
     :               2.036460000000D 00,
     :               2.035740000000D 00,
     :               2.035250000000D 00,
     :               2.035880000000D 00,
     :               2.037230000000D 00,
     :               2.039110000000D 00,
     :               2.041680000000D 00,
     :               2.044970000000D 00,
     :               2.048980000000D 00,
     :               2.053650000000D 00,
     :               2.059150000000D 00,
     :               2.065330000000D 00,
     :               2.072300000000D 00,
     :               2.080020000000D 00,
     :               2.088440000000D 00,
     :               2.097600000000D 00,
     :               2.107750000000D 00,
     :               2.118670000000D 00,
     :               2.130530000000D 00,
     :               2.142570000000D 00,
     :               2.156840000000D 00,
     :               2.170420000000D 00,
     :               2.186760000000D 00,
     :               2.202970000000D 00,
     :               2.220610000000D 00,
     :               2.239020000000D 00,
     :               2.258770000000D 00,
     :               2.279370000000D 00,
     :               2.301190000000D 00,
     :               2.324200000000D 00,
     :               2.348630000000D 00,
     :               2.374560000000D 00,
     :               2.401470000000D 00,
     :               2.430650000000D 00,
     :               2.459960000000D 00,
     :               2.491470000000D 00,
     :               2.524860000000D 00,
     :               2.559490000000D 00,
     :               2.595840000000D 00,
     :               2.633950000000D 00/

      DATA ARGFIN2S/
     :               26.000000000000D 00,
     :               27.000000000000D 00,
     :               28.000000000000D 00,
     :               29.000000000000D 00,
     :               30.000000000000D 00,
     :               31.000000000000D 00,
     :               32.000000000000D 00,
     :               33.000000000000D 00,
     :               34.000000000000D 00,
     :               35.000000000000D 00,
     :               36.000000000000D 00,
     :               37.000000000000D 00,
     :               38.000000000000D 00,
     :               39.000000000000D 00,
     :               40.000000000000D 00,
     :               41.000000000000D 00,
     :               42.000000000000D 00,
     :               43.000000000000D 00,
     :               44.000000000000D 00,
     :               45.000000000000D 00,
     :               46.000000000000D 00,
     :               47.000000000000D 00,
     :               48.000000000000D 00,
     :               49.000000000000D 00,
     :               50.000000000000D 00,
     :               51.000000000000D 00,
     :               52.000000000000D 00,
     :               53.000000000000D 00,
     :               54.000000000000D 00,
     :               55.000000000000D 00,
     :               56.000000000000D 00,
     :               57.000000000000D 00,
     :               58.000000000000D 00,
     :               59.000000000000D 00,
     :               60.000000000000D 00,
     :               61.000000000000D 00,
     :               62.000000000000D 00,
     :               63.000000000000D 00,
     :               64.000000000000D 00,
     :               65.000000000000D 00,
     :               66.000000000000D 00,
     :               67.000000000000D 00,
     :               68.000000000000D 00,
     :               69.000000000000D 00,
     :               70.000000000000D 00,
     :               71.000000000000D 00,
     :               72.000000000000D 00,
     :               73.000000000000D 00,
     :               74.000000000000D 00,
     :               75.000000000000D 00,
     :               76.000000000000D 00,
     :               77.000000000000D 00,
     :               78.000000000000D 00,
     :               79.000000000000D 00,
     :               80.000000000000D 00,
     :               81.000000000000D 00,
     :               82.000000000000D 00,
     :               83.000000000000D 00,
     :               84.000000000000D 00,
     :               85.000000000000D 00,
     :               86.000000000000D 00,
     :               87.000000000000D 00,
     :               88.000000000000D 00,
     :               89.000000000000D 00,
     :               90.000000000000D 00,
     :               91.000000000000D 00,
     :               92.000000000000D 00,
     :               93.000000000000D 00,
     :               94.000000000000D 00,
     :               95.000000000000D 00,
     :               96.000000000000D 00,
     :               97.000000000000D 00,
     :               98.000000000000D 00,
     :               99.000000000000D 00,
     :               100.000000000000D 00,
     :               101.000000000000D 00,
     :               102.000000000000D 00,
     :               103.000000000000D 00,
     :               104.000000000000D 00,
     :               105.000000000000D 00,
     :               106.000000000000D 00,
     :               107.000000000000D 00,
     :               108.000000000000D 00,
     :               109.000000000000D 00,
     :               110.000000000000D 00/

      DATA VALPARA/
     :               -0.000002767135D 00,
     :               -0.000002949997D 00,
     :               -0.000003144942D 00,
     :               -0.000003352770D 00,
     :               -0.000003574332D 00,
     :               -0.000003810536D 00,
     :               -0.000004062349D 00,
     :               -0.000004330802D 00,
     :               -0.000004616996D 00,
     :               -0.000004922102D 00,
     :               -0.000005247371D 00,
     :               -0.000005594134D 00,
     :               -0.000005963813D 00,
     :               -0.000006357921D 00,
     :               -0.000006778073D 00,
     :               -0.000007225991D 00,
     :               -0.000007703508D 00,
     :               -0.000008212581D 00,
     :               -0.000008755295D 00,
     :               -0.000009333874D 00,
     :               -0.000009950687D 00,
     :               -0.000010608261D 00,
     :               -0.000011309290D 00,
     :               -0.000012056645D 00,
     :               -0.000012853387D 00,
     :               -0.000013702781D 00,
     :               -0.000014608306D 00,
     :               -0.000015573671D 00,
     :               -0.000016602830D 00,
     :               -0.000017700000D 00,
     :               -0.000018869674D 00,
     :               -0.000020116644D 00,
     :               -0.000021446018D 00,
     :               -0.000022863241D 00,
     :               -0.000024374119D 00,
     :               -0.000025984841D 00,
     :               -0.000027702005D 00,
     :               -0.000029532644D 00,
     :               -0.000031484258D 00,
     :               -0.000033564842D 00,
     :               -0.000035782916D 00,
     :               -0.000038147569D 00,
     :               -0.000040668486D 00,
     :               -0.000043355993D 00,
     :               -0.000046221099D 00,
     :               -0.000049275541D 00,
     :               -0.000052531831D 00,
     :               -0.000056003306D 00,
     :               -0.000059704189D 00,
     :               -0.000063649638D 00,
     :               -0.000067855815D 00,
     :               -0.000072339950D 00,
     :               -0.000077120411D 00,
     :               -0.000082216781D 00,
     :               -0.000087649936D 00,
     :               -0.000093442131D 00,
     :               -0.000099617094D 00,
     :               -0.000106200119D 00,
     :               -0.000113218172D 00,
     :               -0.000120700000D 00,
     :               -0.000131005943D 00,
     :               -0.000142191857D 00,
     :               -0.000154332878D 00,
     :               -0.000167510557D 00,
     :               -0.000181813409D 00,
     :               -0.000197337508D 00,
     :               -0.000214187128D 00,
     :               -0.000232475449D 00,
     :               -0.000252325314D 00,
     :               -0.000273870056D 00,
     :               -0.000297254391D 00,
     :               -0.000322635393D 00,
     :               -0.000350183545D 00,
     :               -0.000380083891D 00,
     :               -0.000412537271D 00,
     :               -0.000447761676D 00,
     :               -0.000485993709D 00,
     :               -0.000527490176D 00,
     :               -0.000572529810D 00,
     :               -0.000621415142D 00,
     :               -0.000674474539D 00,
     :               -0.000732064400D 00,
     :               -0.000794571559D 00,
     :               -0.000862415879D 00,
     :               -0.000936053071D 00,
     :               -0.001015977758D 00,
     :               -0.001102726797D 00,
     :               -0.001196882884D 00,
     :               -0.001299078468D 00,
     :               -0.001410000000D 00,
     :               -0.001530392543D 00,
     :               -0.001661064776D 00,
     :               -0.001802894430D 00,
     :               -0.001956834177D 00,
     :               -0.002123918037D 00,
     :               -0.002305268315D 00,
     :               -0.002502103148D 00,
     :               -0.002715744679D 00,
     :               -0.002947627946D 00,
     :               -0.003199310516D 00,
     :               -0.003472482947D 00,
     :               -0.003768980146D 00,
     :               -0.004090793694D 00,
     :               -0.004440085221D 00,
     :               -0.004819200929D 00,
     :               -0.005230687350D 00,
     :               -0.005677308448D 00,
     :               -0.006162064192D 00,
     :               -0.006688210699D 00,
     :               -0.007259282112D 00/

      DATA ARGPARA/
     :               1.000000000000D 00,
     :               2.000000000000D 00,
     :               3.000000000000D 00,
     :               4.000000000000D 00,
     :               5.000000000000D 00,
     :               6.000000000000D 00,
     :               7.000000000000D 00,
     :               8.000000000000D 00,
     :               9.000000000000D 00,
     :               10.000000000000D 00,
     :               11.000000000000D 00,
     :               12.000000000000D 00,
     :               13.000000000000D 00,
     :               14.000000000000D 00,
     :               15.000000000000D 00,
     :               16.000000000000D 00,
     :               17.000000000000D 00,
     :               18.000000000000D 00,
     :               19.000000000000D 00,
     :               20.000000000000D 00,
     :               21.000000000000D 00,
     :               22.000000000000D 00,
     :               23.000000000000D 00,
     :               24.000000000000D 00,
     :               25.000000000000D 00,
     :               26.000000000000D 00,
     :               27.000000000000D 00,
     :               28.000000000000D 00,
     :               29.000000000000D 00,
     :               30.000000000000D 00,
     :               31.000000000000D 00,
     :               32.000000000000D 00,
     :               33.000000000000D 00,
     :               34.000000000000D 00,
     :               35.000000000000D 00,
     :               36.000000000000D 00,
     :               37.000000000000D 00,
     :               38.000000000000D 00,
     :               39.000000000000D 00,
     :               40.000000000000D 00,
     :               41.000000000000D 00,
     :               42.000000000000D 00,
     :               43.000000000000D 00,
     :               44.000000000000D 00,
     :               45.000000000000D 00,
     :               46.000000000000D 00,
     :               47.000000000000D 00,
     :               48.000000000000D 00,
     :               49.000000000000D 00,
     :               50.000000000000D 00,
     :               51.000000000000D 00,
     :               52.000000000000D 00,
     :               53.000000000000D 00,
     :               54.000000000000D 00,
     :               55.000000000000D 00,
     :               56.000000000000D 00,
     :               57.000000000000D 00,
     :               58.000000000000D 00,
     :               59.000000000000D 00,
     :               60.000000000000D 00,
     :               61.000000000000D 00,
     :               62.000000000000D 00,
     :               63.000000000000D 00,
     :               64.000000000000D 00,
     :               65.000000000000D 00,
     :               66.000000000000D 00,
     :               67.000000000000D 00,
     :               68.000000000000D 00,
     :               69.000000000000D 00,
     :               70.000000000000D 00,
     :               71.000000000000D 00,
     :               72.000000000000D 00,
     :               73.000000000000D 00,
     :               74.000000000000D 00,
     :               75.000000000000D 00,
     :               76.000000000000D 00,
     :               77.000000000000D 00,
     :               78.000000000000D 00,
     :               79.000000000000D 00,
     :               80.000000000000D 00,
     :               81.000000000000D 00,
     :               82.000000000000D 00,
     :               83.000000000000D 00,
     :               84.000000000000D 00,
     :               85.000000000000D 00,
     :               86.000000000000D 00,
     :               87.000000000000D 00,
     :               88.000000000000D 00,
     :               89.000000000000D 00,
     :               90.000000000000D 00,
     :               91.000000000000D 00,
     :               92.000000000000D 00,
     :               93.000000000000D 00,
     :               94.000000000000D 00,
     :               95.000000000000D 00,
     :               96.000000000000D 00,
     :               97.000000000000D 00,
     :               98.000000000000D 00,
     :               99.000000000000D 00,
     :               100.000000000000D 00,
     :               101.000000000000D 00,
     :               102.000000000000D 00,
     :               103.000000000000D 00,
     :               104.000000000000D 00,
     :               105.000000000000D 00,
     :               106.000000000000D 00,
     :               107.000000000000D 00,
     :               108.000000000000D 00,
     :               109.000000000000D 00,
     :               110.000000000000D 00/

      DATA VALPARP/
     :               2.106300856413D 00,
     :               2.099245218742D 00,
     :               2.092213215882D 00,
     :               2.085204768661D 00,
     :               2.078219798175D 00,
     :               2.071258225780D 00,
     :               2.064319973098D 00,
     :               2.057404962014D 00,
     :               2.050513114674D 00,
     :               2.043644353484D 00,
     :               2.036798601110D 00,
     :               2.029975780479D 00,
     :               2.023175814773D 00,
     :               2.016398627435D 00,
     :               2.009644142162D 00,
     :               2.002912282906D 00,
     :               1.996202973876D 00,
     :               1.989516139534D 00,
     :               1.982851704594D 00,
     :               1.976209594023D 00,
     :               1.969589733040D 00,
     :               1.962992047113D 00,
     :               1.956416461961D 00,
     :               1.949862903552D 00,
     :               1.943331298101D 00,
     :               1.936821572069D 00,
     :               1.930333652167D 00,
     :               1.923867465348D 00,
     :               1.917422938811D 00,
     :               1.911000000000D 00,
     :               1.904598576600D 00,
     :               1.898218596539D 00,
     :               1.891859987987D 00,
     :               1.885522679355D 00,
     :               1.879206599291D 00,
     :               1.872911676686D 00,
     :               1.866637840667D 00,
     :               1.860385020597D 00,
     :               1.854153146079D 00,
     :               1.847942146949D 00,
     :               1.841751953280D 00,
     :               1.835582495378D 00,
     :               1.829433703783D 00,
     :               1.823305509266D 00,
     :               1.817197842834D 00,
     :               1.811110635720D 00,
     :               1.805043819392D 00,
     :               1.798997325544D 00,
     :               1.792971086100D 00,
     :               1.786965033214D 00,
     :               1.780979099263D 00,
     :               1.775013216856D 00,
     :               1.769067318822D 00,
     :               1.763141338220D 00,
     :               1.757235208330D 00,
     :               1.751348862656D 00,
     :               1.745482234926D 00,
     :               1.739635259090D 00,
     :               1.733807869318D 00,
     :               1.728000000000D 00,
     :               1.716568170370D 00,
     :               1.705211969635D 00,
     :               1.693930897459D 00,
     :               1.682724456820D 00,
     :               1.671592153982D 00,
     :               1.660533498476D 00,
     :               1.649548003078D 00,
     :               1.638635183785D 00,
     :               1.627794559800D 00,
     :               1.617025653504D 00,
     :               1.606327990439D 00,
     :               1.595701099284D 00,
     :               1.585144511838D 00,
     :               1.574657762996D 00,
     :               1.564240390733D 00,
     :               1.553891936076D 00,
     :               1.543611943092D 00,
     :               1.533399958863D 00,
     :               1.523255533468D 00,
     :               1.513178219960D 00,
     :               1.503167574353D 00,
     :               1.493223155594D 00,
     :               1.483344525552D 00,
     :               1.473531248990D 00,
     :               1.463782893555D 00,
     :               1.454099029751D 00,
     :               1.444479230924D 00,
     :               1.434923073244D 00,
     :               1.425430135683D 00,
     :               1.416000000000D 00,
     :               1.406632250720D 00,
     :               1.397326475117D 00,
     :               1.388082263196D 00,
     :               1.378899207672D 00,
     :               1.369776903958D 00,
     :               1.360714950140D 00,
     :               1.351712946966D 00,
     :               1.342770497824D 00,
     :               1.333887208725D 00,
     :               1.325062688288D 00,
     :               1.316296547721D 00,
     :               1.307588400802D 00,
     :               1.298937863867D 00,
     :               1.290344555789D 00,
     :               1.281808097962D 00,
     :               1.273328114285D 00,
     :               1.264904231145D 00,
     :               1.256536077402D 00,
     :               1.248223284369D 00,
     :               1.239965485801D 00/

      DATA ARGPARP/
     :               1.000000000000D 00,
     :               2.000000000000D 00,
     :               3.000000000000D 00,
     :               4.000000000000D 00,
     :               5.000000000000D 00,
     :               6.000000000000D 00,
     :               7.000000000000D 00,
     :               8.000000000000D 00,
     :               9.000000000000D 00,
     :               10.000000000000D 00,
     :               11.000000000000D 00,
     :               12.000000000000D 00,
     :               13.000000000000D 00,
     :               14.000000000000D 00,
     :               15.000000000000D 00,
     :               16.000000000000D 00,
     :               17.000000000000D 00,
     :               18.000000000000D 00,
     :               19.000000000000D 00,
     :               20.000000000000D 00,
     :               21.000000000000D 00,
     :               22.000000000000D 00,
     :               23.000000000000D 00,
     :               24.000000000000D 00,
     :               25.000000000000D 00,
     :               26.000000000000D 00,
     :               27.000000000000D 00,
     :               28.000000000000D 00,
     :               29.000000000000D 00,
     :               30.000000000000D 00,
     :               31.000000000000D 00,
     :               32.000000000000D 00,
     :               33.000000000000D 00,
     :               34.000000000000D 00,
     :               35.000000000000D 00,
     :               36.000000000000D 00,
     :               37.000000000000D 00,
     :               38.000000000000D 00,
     :               39.000000000000D 00,
     :               40.000000000000D 00,
     :               41.000000000000D 00,
     :               42.000000000000D 00,
     :               43.000000000000D 00,
     :               44.000000000000D 00,
     :               45.000000000000D 00,
     :               46.000000000000D 00,
     :               47.000000000000D 00,
     :               48.000000000000D 00,
     :               49.000000000000D 00,
     :               50.000000000000D 00,
     :               51.000000000000D 00,
     :               52.000000000000D 00,
     :               53.000000000000D 00,
     :               54.000000000000D 00,
     :               55.000000000000D 00,
     :               56.000000000000D 00,
     :               57.000000000000D 00,
     :               58.000000000000D 00,
     :               59.000000000000D 00,
     :               60.000000000000D 00,
     :               61.000000000000D 00,
     :               62.000000000000D 00,
     :               63.000000000000D 00,
     :               64.000000000000D 00,
     :               65.000000000000D 00,
     :               66.000000000000D 00,
     :               67.000000000000D 00,
     :               68.000000000000D 00,
     :               69.000000000000D 00,
     :               70.000000000000D 00,
     :               71.000000000000D 00,
     :               72.000000000000D 00,
     :               73.000000000000D 00,
     :               74.000000000000D 00,
     :               75.000000000000D 00,
     :               76.000000000000D 00,
     :               77.000000000000D 00,
     :               78.000000000000D 00,
     :               79.000000000000D 00,
     :               80.000000000000D 00,
     :               81.000000000000D 00,
     :               82.000000000000D 00,
     :               83.000000000000D 00,
     :               84.000000000000D 00,
     :               85.000000000000D 00,
     :               86.000000000000D 00,
     :               87.000000000000D 00,
     :               88.000000000000D 00,
     :               89.000000000000D 00,
     :               90.000000000000D 00,
     :               91.000000000000D 00,
     :               92.000000000000D 00,
     :               93.000000000000D 00,
     :               94.000000000000D 00,
     :               95.000000000000D 00,
     :               96.000000000000D 00,
     :               97.000000000000D 00,
     :               98.000000000000D 00,
     :               99.000000000000D 00,
     :               100.000000000000D 00,
     :               101.000000000000D 00,
     :               102.000000000000D 00,
     :               103.000000000000D 00,
     :               104.000000000000D 00,
     :               105.000000000000D 00,
     :               106.000000000000D 00,
     :               107.000000000000D 00,
     :               108.000000000000D 00,
     :               109.000000000000D 00,
     :               110.000000000000D 00/

      DATA VALPARB/
     :               -0.001247773796D 00,
     :               -0.001281431642D 00,
     :               -0.001315997386D 00,
     :               -0.001351495517D 00,
     :               -0.001387951186D 00,
     :               -0.001425390222D 00,
     :               -0.001463839150D 00,
     :               -0.001503325212D 00,
     :               -0.001543876383D 00,
     :               -0.001585521395D 00,
     :               -0.001628289752D 00,
     :               -0.001672211757D 00,
     :               -0.001717318527D 00,
     :               -0.001763642022D 00,
     :               -0.001811215062D 00,
     :               -0.001860071352D 00,
     :               -0.001910245507D 00,
     :               -0.001961773075D 00,
     :               -0.002014690565D 00,
     :               -0.002069035467D 00,
     :               -0.002124846287D 00,
     :               -0.002182162565D 00,
     :               -0.002241024911D 00,
     :               -0.002301475028D 00,
     :               -0.002363555746D 00,
     :               -0.002427311048D 00,
     :               -0.002492786107D 00,
     :               -0.002560027310D 00,
     :               -0.002629082300D 00,
     :               -0.002700000000D 00,
     :               -0.002772830657D 00,
     :               -0.002847625871D 00,
     :               -0.002924438635D 00,
     :               -0.003003323371D 00,
     :               -0.003084335969D 00,
     :               -0.003167533826D 00,
     :               -0.003252975889D 00,
     :               -0.003340722693D 00,
     :               -0.003430836407D 00,
     :               -0.003523380877D 00,
     :               -0.003618421671D 00,
     :               -0.003716026126D 00,
     :               -0.003816263394D 00,
     :               -0.003919204494D 00,
     :               -0.004024922360D 00,
     :               -0.004133491893D 00,
     :               -0.004244990015D 00,
     :               -0.004359495723D 00,
     :               -0.004477090144D 00,
     :               -0.004597856594D 00,
     :               -0.004721880637D 00,
     :               -0.004849250144D 00,
     :               -0.004980055357D 00,
     :               -0.005114388950D 00,
     :               -0.005252346101D 00,
     :               -0.005394024552D 00,
     :               -0.005539524682D 00,
     :               -0.005688949579D 00,
     :               -0.005842405110D 00,
     :               -0.006000000000D 00,
     :               -0.006177673600D 00,
     :               -0.006360608518D 00,
     :               -0.006548960554D 00,
     :               -0.006742890120D 00,
     :               -0.006942562380D 00,
     :               -0.007148147389D 00,
     :               -0.007359820236D 00,
     :               -0.007577761195D 00,
     :               -0.007802155880D 00,
     :               -0.008033195401D 00,
     :               -0.008271076525D 00,
     :               -0.008516001849D 00,
     :               -0.008768179967D 00,
     :               -0.009027825650D 00,
     :               -0.009295160031D 00,
     :               -0.009570410788D 00,
     :               -0.009853812345D 00,
     :               -0.010145606064D 00,
     :               -0.010446040456D 00,
     :               -0.010755371392D 00,
     :               -0.011073862318D 00,
     :               -0.011401784482D 00,
     :               -0.011739417164D 00,
     :               -0.012087047916D 00,
     :               -0.012444972802D 00,
     :               -0.012813496655D 00,
     :               -0.013192933335D 00,
     :               -0.013583605995D 00,
     :               -0.013985847358D 00,
     :               -0.014400000000D 00,
     :               -0.014826416640D 00,
     :               -0.015265460443D 00,
     :               -0.015717505329D 00,
     :               -0.016182936288D 00,
     :               -0.016662149713D 00,
     :               -0.017155553734D 00,
     :               -0.017663568566D 00,
     :               -0.018186626868D 00,
     :               -0.018725174113D 00,
     :               -0.019279668962D 00,
     :               -0.019850583661D 00,
     :               -0.020438404438D 00,
     :               -0.021043631921D 00,
     :               -0.021666781561D 00,
     :               -0.022308384074D 00,
     :               -0.022968985892D 00,
     :               -0.023649149628D 00,
     :               -0.024349454553D 00,
     :               -0.025070497095D 00,
     :               -0.025812891340D 00/

      DATA ARGPARB/
     :               1.000000000000D 00,
     :               2.000000000000D 00,
     :               3.000000000000D 00,
     :               4.000000000000D 00,
     :               5.000000000000D 00,
     :               6.000000000000D 00,
     :               7.000000000000D 00,
     :               8.000000000000D 00,
     :               9.000000000000D 00,
     :               10.000000000000D 00,
     :               11.000000000000D 00,
     :               12.000000000000D 00,
     :               13.000000000000D 00,
     :               14.000000000000D 00,
     :               15.000000000000D 00,
     :               16.000000000000D 00,
     :               17.000000000000D 00,
     :               18.000000000000D 00,
     :               19.000000000000D 00,
     :               20.000000000000D 00,
     :               21.000000000000D 00,
     :               22.000000000000D 00,
     :               23.000000000000D 00,
     :               24.000000000000D 00,
     :               25.000000000000D 00,
     :               26.000000000000D 00,
     :               27.000000000000D 00,
     :               28.000000000000D 00,
     :               29.000000000000D 00,
     :               30.000000000000D 00,
     :               31.000000000000D 00,
     :               32.000000000000D 00,
     :               33.000000000000D 00,
     :               34.000000000000D 00,
     :               35.000000000000D 00,
     :               36.000000000000D 00,
     :               37.000000000000D 00,
     :               38.000000000000D 00,
     :               39.000000000000D 00,
     :               40.000000000000D 00,
     :               41.000000000000D 00,
     :               42.000000000000D 00,
     :               43.000000000000D 00,
     :               44.000000000000D 00,
     :               45.000000000000D 00,
     :               46.000000000000D 00,
     :               47.000000000000D 00,
     :               48.000000000000D 00,
     :               49.000000000000D 00,
     :               50.000000000000D 00,
     :               51.000000000000D 00,
     :               52.000000000000D 00,
     :               53.000000000000D 00,
     :               54.000000000000D 00,
     :               55.000000000000D 00,
     :               56.000000000000D 00,
     :               57.000000000000D 00,
     :               58.000000000000D 00,
     :               59.000000000000D 00,
     :               60.000000000000D 00,
     :               61.000000000000D 00,
     :               62.000000000000D 00,
     :               63.000000000000D 00,
     :               64.000000000000D 00,
     :               65.000000000000D 00,
     :               66.000000000000D 00,
     :               67.000000000000D 00,
     :               68.000000000000D 00,
     :               69.000000000000D 00,
     :               70.000000000000D 00,
     :               71.000000000000D 00,
     :               72.000000000000D 00,
     :               73.000000000000D 00,
     :               74.000000000000D 00,
     :               75.000000000000D 00,
     :               76.000000000000D 00,
     :               77.000000000000D 00,
     :               78.000000000000D 00,
     :               79.000000000000D 00,
     :               80.000000000000D 00,
     :               81.000000000000D 00,
     :               82.000000000000D 00,
     :               83.000000000000D 00,
     :               84.000000000000D 00,
     :               85.000000000000D 00,
     :               86.000000000000D 00,
     :               87.000000000000D 00,
     :               88.000000000000D 00,
     :               89.000000000000D 00,
     :               90.000000000000D 00,
     :               91.000000000000D 00,
     :               92.000000000000D 00,
     :               93.000000000000D 00,
     :               94.000000000000D 00,
     :               95.000000000000D 00,
     :               96.000000000000D 00,
     :               97.000000000000D 00,
     :               98.000000000000D 00,
     :               99.000000000000D 00,
     :               100.000000000000D 00,
     :               101.000000000000D 00,
     :               102.000000000000D 00,
     :               103.000000000000D 00,
     :               104.000000000000D 00,
     :               105.000000000000D 00,
     :               106.000000000000D 00,
     :               107.000000000000D 00,
     :               108.000000000000D 00,
     :               109.000000000000D 00,
     :               110.000000000000D 00/

      DATA VALRREF/
     :               3.801000000000D 00,
     :               3.782000000000D 00,
     :               3.769000000000D 00,
     :               3.933000000000D 00,
     :               3.923000000000D 00,
     :               3.998000000000D 00,
     :               4.079000000000D 00,
     :               4.104000000000D 00,
     :               4.171000000000D 00,
     :               4.156000000000D 00,
     :               4.230000000000D 00,
     :               4.245000000000D 00,
     :               4.188000000000D 00,
     :               4.244000000000D 00,
     :               4.258000000000D 00,
     :               4.330000000000D 00,
     :               4.388000000000D 00,
     :               4.410000000000D 00,
     :               4.475000000000D 00,
     :               4.502000000000D 00,
     :               4.526000000000D 00,
     :               4.542000000000D 00,
     :               4.613000000000D 00,
     :               4.619000000000D 00,
     :               4.655000000000D 00,
     :               4.704000000000D 00,
     :               4.804000000000D 00,
     :               4.752000000000D 00,
     :               4.826000000000D 00,
     :               4.807000000000D 00,
     :               4.840000000000D 00,
     :               4.855000000000D 00,
     :               4.877000000000D 00,
     :               4.893000000000D 00,
     :               4.915000000000D 00,
     :               4.962000000000D 00,
     :               5.093000000000D 00,
     :               5.041000000000D 00,
     :               5.172000000000D 00,
     :               5.099000000000D 00,
     :               5.083000000000D 00,
     :               5.210000000000D 00,
     :               5.237000000000D 00,
     :               5.192000000000D 00,
     :               5.410000000000D 00,
     :               5.370000000000D 00,
     :               5.290000000000D 00,
     :               5.480000000000D 00,
     :               5.420000000000D 00,
     :               5.351000000000D 00,
     :               5.376000000000D 00,
     :               5.401000000000D 00,
     :               5.418000000000D 00,
     :               5.437000000000D 00,
     :               5.475000000000D 00,
     :               5.479000000000D 00,
     :               5.505000000000D 00,
     :               5.519000000000D 00,
     :               5.539000000000D 00,
     :               5.578000000000D 00,
     :               5.632000000000D 00,
     :               5.640000000000D 00,
     :               5.663000000000D 00,
     :               5.670000000000D 00,
     :               5.802000000000D 00,
     :               5.700000000000D 00,
     :               5.860000000000D 00,
     :               5.744000000000D 00,
     :               5.794000000000D 00,
     :               5.787000000000D 00,
     :               5.816000000000D 00,
     :               5.816000000000D 00,
     :               5.844000000000D 00,
     :               5.865000000000D 00,
     :               5.886000000000D 00,
     :               5.893000000000D 00,
     :               5.886000000000D 00,
     :               5.906000000000D 00,
     :               5.872000000000D 00,
     :               5.920000000000D 00,
     :               5.927000000000D 00,
     :               5.920000000000D 00,
     :               5.934000000000D 00,
     :               5.947000000000D 00,
     :               5.961000000000D 00/

      DATA ARGRREF/
     :               26.000000000000D 00,
     :               27.000000000000D 00,
     :               28.000000000000D 00,
     :               29.000000000000D 00,
     :               30.000000000000D 00,
     :               31.000000000000D 00,
     :               32.000000000000D 00,
     :               33.000000000000D 00,
     :               34.000000000000D 00,
     :               35.000000000000D 00,
     :               36.000000000000D 00,
     :               37.000000000000D 00,
     :               38.000000000000D 00,
     :               39.000000000000D 00,
     :               40.000000000000D 00,
     :               41.000000000000D 00,
     :               42.000000000000D 00,
     :               43.000000000000D 00,
     :               44.000000000000D 00,
     :               45.000000000000D 00,
     :               46.000000000000D 00,
     :               47.000000000000D 00,
     :               48.000000000000D 00,
     :               49.000000000000D 00,
     :               50.000000000000D 00,
     :               51.000000000000D 00,
     :               52.000000000000D 00,
     :               53.000000000000D 00,
     :               54.000000000000D 00,
     :               55.000000000000D 00,
     :               56.000000000000D 00,
     :               57.000000000000D 00,
     :               58.000000000000D 00,
     :               59.000000000000D 00,
     :               60.000000000000D 00,
     :               61.000000000000D 00,
     :               62.000000000000D 00,
     :               63.000000000000D 00,
     :               64.000000000000D 00,
     :               65.000000000000D 00,
     :               66.000000000000D 00,
     :               67.000000000000D 00,
     :               68.000000000000D 00,
     :               69.000000000000D 00,
     :               70.000000000000D 00,
     :               71.000000000000D 00,
     :               72.000000000000D 00,
     :               73.000000000000D 00,
     :               74.000000000000D 00,
     :               75.000000000000D 00,
     :               76.000000000000D 00,
     :               77.000000000000D 00,
     :               78.000000000000D 00,
     :               79.000000000000D 00,
     :               80.000000000000D 00,
     :               81.000000000000D 00,
     :               82.000000000000D 00,
     :               83.000000000000D 00,
     :               84.000000000000D 00,
     :               85.000000000000D 00,
     :               86.000000000000D 00,
     :               87.000000000000D 00,
     :               88.000000000000D 00,
     :               89.000000000000D 00,
     :               90.000000000000D 00,
     :               91.000000000000D 00,
     :               92.000000000000D 00,
     :               93.000000000000D 00,
     :               94.000000000000D 00,
     :               95.000000000000D 00,
     :               96.000000000000D 00,
     :               97.000000000000D 00,
     :               98.000000000000D 00,
     :               99.000000000000D 00,
     :               100.000000000000D 00,
     :               101.000000000000D 00,
     :               102.000000000000D 00,
     :               103.000000000000D 00,
     :               104.000000000000D 00,
     :               105.000000000000D 00,
     :               106.000000000000D 00,
     :               107.000000000000D 00,
     :               108.000000000000D 00,
     :               109.000000000000D 00,
     :               110.000000000000D 00/

      DATA VALFIN1S/
     :               2.783760000000D 00,
     :               2.721117000000D 00,
     :               2.661734000000D 00,
     :               2.605347000000D 00,
     :               2.551777000000D 00,
     :               2.500798000000D 00,
     :               2.452243000000D 00,
     :               2.405960000000D 00,
     :               2.361792000000D 00,
     :               2.319626000000D 00,
     :               2.279315000000D 00,
     :               2.240773000000D 00,
     :               2.203904000000D 00,
     :               2.168581000000D 00,
     :               2.134749000000D 00,
     :               2.102309000000D 00,
     :               2.071203000000D 00,
     :               2.041372000000D 00,
     :               2.012404000000D 00,
     :               1.985251000000D 00,
     :               1.958864000000D 00,
     :               1.933524000000D 00,
     :               1.909166000000D 00,
     :               1.885786000000D 00,
     :               1.863312000000D 00,
     :               1.841713000000D 00,
     :               1.820937000000D 00,
     :               1.801037000000D 00,
     :               1.781866000000D 00,
     :               1.763493000000D 00,
     :               1.745824000000D 00,
     :               1.728869000000D 00,
     :               1.712591000000D 00,
     :               1.696977000000D 00,
     :               1.681999000000D 00,
     :               1.667626000000D 00,
     :               1.653794000000D 00,
     :               1.640680000000D 00,
     :               1.627997000000D 00,
     :               1.616035000000D 00,
     :               1.604575000000D 00,
     :               1.593517000000D 00,
     :               1.583068000000D 00,
     :               1.573207000000D 00,
     :               1.563558000000D 00,
     :               1.554685000000D 00,
     :               1.546354000000D 00,
     :               1.538154000000D 00,
     :               1.530754000000D 00,
     :               1.523844000000D 00,
     :               1.517261000000D 00,
     :               1.511133000000D 00,
     :               1.505528000000D 00,
     :               1.500254000000D 00,
     :               1.495448000000D 00,
     :               1.491153000000D 00,
     :               1.487258000000D 00,
     :               1.483833000000D 00,
     :               1.480839000000D 00,
     :               1.478239000000D 00,
     :               1.476035000000D 00,
     :               1.474407000000D 00,
     :               1.473196000000D 00,
     :               1.472472000000D 00,
     :               1.471765000000D 00,
     :               1.472380000000D 00,
     :               1.472437000000D 00,
     :               1.474112000000D 00,
     :               1.475564000000D 00,
     :               1.477773000000D 00,
     :               1.480306000000D 00,
     :               1.483504000000D 00,
     :               1.487065000000D 00,
     :               1.491194000000D 00,
     :               1.495862000000D 00,
     :               1.501187000000D 00,
     :               1.507202000000D 00,
     :               1.513601000000D 00,
     :               1.521086000000D 00,
     :               1.528463000000D 00,
     :               1.536862000000D 00,
     :               1.546088000000D 00,
     :               1.555783000000D 00,
     :               1.566198000000D 00,
     :               1.577334000000D 00/

      DATA ARGFIN1S/
     :               26.000000000000D 00,
     :               27.000000000000D 00,
     :               28.000000000000D 00,
     :               29.000000000000D 00,
     :               30.000000000000D 00,
     :               31.000000000000D 00,
     :               32.000000000000D 00,
     :               33.000000000000D 00,
     :               34.000000000000D 00,
     :               35.000000000000D 00,
     :               36.000000000000D 00,
     :               37.000000000000D 00,
     :               38.000000000000D 00,
     :               39.000000000000D 00,
     :               40.000000000000D 00,
     :               41.000000000000D 00,
     :               42.000000000000D 00,
     :               43.000000000000D 00,
     :               44.000000000000D 00,
     :               45.000000000000D 00,
     :               46.000000000000D 00,
     :               47.000000000000D 00,
     :               48.000000000000D 00,
     :               49.000000000000D 00,
     :               50.000000000000D 00,
     :               51.000000000000D 00,
     :               52.000000000000D 00,
     :               53.000000000000D 00,
     :               54.000000000000D 00,
     :               55.000000000000D 00,
     :               56.000000000000D 00,
     :               57.000000000000D 00,
     :               58.000000000000D 00,
     :               59.000000000000D 00,
     :               60.000000000000D 00,
     :               61.000000000000D 00,
     :               62.000000000000D 00,
     :               63.000000000000D 00,
     :               64.000000000000D 00,
     :               65.000000000000D 00,
     :               66.000000000000D 00,
     :               67.000000000000D 00,
     :               68.000000000000D 00,
     :               69.000000000000D 00,
     :               70.000000000000D 00,
     :               71.000000000000D 00,
     :               72.000000000000D 00,
     :               73.000000000000D 00,
     :               74.000000000000D 00,
     :               75.000000000000D 00,
     :               76.000000000000D 00,
     :               77.000000000000D 00,
     :               78.000000000000D 00,
     :               79.000000000000D 00,
     :               80.000000000000D 00,
     :               81.000000000000D 00,
     :               82.000000000000D 00,
     :               83.000000000000D 00,
     :               84.000000000000D 00,
     :               85.000000000000D 00,
     :               86.000000000000D 00,
     :               87.000000000000D 00,
     :               88.000000000000D 00,
     :               89.000000000000D 00,
     :               90.000000000000D 00,
     :               91.000000000000D 00,
     :               92.000000000000D 00,
     :               93.000000000000D 00,
     :               94.000000000000D 00,
     :               95.000000000000D 00,
     :               96.000000000000D 00,
     :               97.000000000000D 00,
     :               98.000000000000D 00,
     :               99.000000000000D 00,
     :               100.000000000000D 00,
     :               101.000000000000D 00,
     :               102.000000000000D 00,
     :               103.000000000000D 00,
     :               104.000000000000D 00,
     :               105.000000000000D 00,
     :               106.000000000000D 00,
     :               107.000000000000D 00,
     :               108.000000000000D 00,
     :               109.000000000000D 00,
     :               110.000000000000D 00/

      DATA VALPARC/
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000000000000D 00,
     :               0.000004782176D 00,
     :               0.000005145572D 00,
     :               0.000005536582D 00,
     :               0.000005957305D 00,
     :               0.000006409998D 00,
     :               0.000006897091D 00,
     :               0.000007421199D 00,
     :               0.000007985133D 00,
     :               0.000008591920D 00,
     :               0.000009244817D 00,
     :               0.000009947327D 00,
     :               0.000010703221D 00,
     :               0.000011516555D 00,
     :               0.000012391693D 00,
     :               0.000013333333D 00,
     :               0.000014346528D 00,
     :               0.000015436716D 00,
     :               0.000016609746D 00,
     :               0.000017871914D 00,
     :               0.000019229994D 00,
     :               0.000020691274D 00,
     :               0.000022263596D 00,
     :               0.000023955399D 00,
     :               0.000025775761D 00,
     :               0.000027734451D 00,
     :               0.000029841981D 00,
     :               0.000032109662D 00,
     :               0.000034549664D 00,
     :               0.000037175080D 00,
     :               0.000040000000D 00,
     :               0.000043039585D 00,
     :               0.000046310147D 00,
     :               0.000049829238D 00,
     :               0.000053615743D 00,
     :               0.000057689983D 00,
     :               0.000062073823D 00,
     :               0.000066790789D 00,
     :               0.000071866196D 00,
     :               0.000077327282D 00,
     :               0.000083203353D 00,
     :               0.000089525944D 00,
     :               0.000096328987D 00,
     :               0.000103648991D 00,
     :               0.000111525239D 00,
     :               0.000120000000D 00,
     :               0.000129118755D 00,
     :               0.000138930441D 00,
     :               0.000149487713D 00,
     :               0.000160847228D 00,
     :               0.000173069948D 00,
     :               0.000186221469D 00,
     :               0.000200372368D 00,
     :               0.000215598589D 00,
     :               0.000231981845D 00,
     :               0.000249610059D 00,
     :               0.000268577833D 00,
     :               0.000288986962D 00,
     :               0.000310946973D 00,
     :               0.000334575717D 00,
     :               0.000360000000D 00,
     :               0.000387356265D 00,
     :               0.000416791322D 00,
     :               0.000448463138D 00,
     :               0.000482541684D 00,
     :               0.000519209845D 00,
     :               0.000558664407D 00,
     :               0.000601117105D 00,
     :               0.000646795768D 00,
     :               0.000695945536D 00,
     :               0.000748830176D 00,
     :               0.000805733500D 00,
     :               0.000866960887D 00,
     :               0.000932840919D 00,
     :               0.001003727151D 00,
     :               0.001080000000D 00,
     :               0.001162068795D 00,
     :               0.001250373966D 00,
     :               0.001345389415D 00,
     :               0.001447625052D 00,
     :               0.001557629536D 00/

      DATA ARGPARC/
     :               1.000000000000D 00,
     :               2.000000000000D 00,
     :               3.000000000000D 00,
     :               4.000000000000D 00,
     :               5.000000000000D 00,
     :               6.000000000000D 00,
     :               7.000000000000D 00,
     :               8.000000000000D 00,
     :               9.000000000000D 00,
     :               10.000000000000D 00,
     :               11.000000000000D 00,
     :               12.000000000000D 00,
     :               13.000000000000D 00,
     :               14.000000000000D 00,
     :               15.000000000000D 00,
     :               16.000000000000D 00,
     :               17.000000000000D 00,
     :               18.000000000000D 00,
     :               19.000000000000D 00,
     :               20.000000000000D 00,
     :               21.000000000000D 00,
     :               22.000000000000D 00,
     :               23.000000000000D 00,
     :               24.000000000000D 00,
     :               25.000000000000D 00,
     :               26.000000000000D 00,
     :               27.000000000000D 00,
     :               28.000000000000D 00,
     :               29.000000000000D 00,
     :               30.000000000000D 00,
     :               31.000000000000D 00,
     :               32.000000000000D 00,
     :               33.000000000000D 00,
     :               34.000000000000D 00,
     :               35.000000000000D 00,
     :               36.000000000000D 00,
     :               37.000000000000D 00,
     :               38.000000000000D 00,
     :               39.000000000000D 00,
     :               40.000000000000D 00,
     :               41.000000000000D 00,
     :               42.000000000000D 00,
     :               43.000000000000D 00,
     :               44.000000000000D 00,
     :               45.000000000000D 00,
     :               46.000000000000D 00,
     :               47.000000000000D 00,
     :               48.000000000000D 00,
     :               49.000000000000D 00,
     :               50.000000000000D 00,
     :               51.000000000000D 00,
     :               52.000000000000D 00,
     :               53.000000000000D 00,
     :               54.000000000000D 00,
     :               55.000000000000D 00,
     :               56.000000000000D 00,
     :               57.000000000000D 00,
     :               58.000000000000D 00,
     :               59.000000000000D 00,
     :               60.000000000000D 00,
     :               61.000000000000D 00,
     :               62.000000000000D 00,
     :               63.000000000000D 00,
     :               64.000000000000D 00,
     :               65.000000000000D 00,
     :               66.000000000000D 00,
     :               67.000000000000D 00,
     :               68.000000000000D 00,
     :               69.000000000000D 00,
     :               70.000000000000D 00,
     :               71.000000000000D 00,
     :               72.000000000000D 00,
     :               73.000000000000D 00,
     :               74.000000000000D 00,
     :               75.000000000000D 00,
     :               76.000000000000D 00,
     :               77.000000000000D 00,
     :               78.000000000000D 00,
     :               79.000000000000D 00,
     :               80.000000000000D 00,
     :               81.000000000000D 00,
     :               82.000000000000D 00,
     :               83.000000000000D 00,
     :               84.000000000000D 00,
     :               85.000000000000D 00,
     :               86.000000000000D 00,
     :               87.000000000000D 00,
     :               88.000000000000D 00,
     :               89.000000000000D 00,
     :               90.000000000000D 00,
     :               91.000000000000D 00,
     :               92.000000000000D 00,
     :               93.000000000000D 00,
     :               94.000000000000D 00,
     :               95.000000000000D 00,
     :               96.000000000000D 00,
     :               97.000000000000D 00,
     :               98.000000000000D 00,
     :               99.000000000000D 00,
     :               100.000000000000D 00,
     :               101.000000000000D 00,
     :               102.000000000000D 00,
     :               103.000000000000D 00,
     :               104.000000000000D 00,
     :               105.000000000000D 00,
     :               106.000000000000D 00,
     :               107.000000000000D 00,
     :               108.000000000000D 00,
     :               109.000000000000D 00,
     :               110.000000000000D 00/

      DATA VALFIN2P1/
     :               -0.076220000000D 00,
     :               -0.073320000000D 00,
     :               -0.070380000000D 00,
     :               -0.067380000000D 00,
     :               -0.064330000000D 00,
     :               -0.061230000000D 00,
     :               -0.058090000000D 00,
     :               -0.054890000000D 00,
     :               -0.051640000000D 00,
     :               -0.048340000000D 00,
     :               -0.044990000000D 00,
     :               -0.041590000000D 00,
     :               -0.038130000000D 00,
     :               -0.034620000000D 00,
     :               -0.031050000000D 00,
     :               -0.027430000000D 00,
     :               -0.023750000000D 00,
     :               -0.050000000000D 00,
     :               -0.016200000000D 00,
     :               -0.012330000000D 00,
     :               -0.008410000000D 00,
     :               -0.004410000000D 00,
     :               -0.000340000000D 00,
     :               0.003790000000D 00,
     :               0.008000000000D 00,
     :               0.012290000000D 00,
     :               0.016650000000D 00,
     :               0.021090000000D 00,
     :               0.025620000000D 00,
     :               0.030230000000D 00,
     :               0.034930000000D 00,
     :               0.039730000000D 00,
     :               0.044620000000D 00,
     :               0.049620000000D 00,
     :               0.054720000000D 00,
     :               0.059930000000D 00,
     :               0.065250000000D 00,
     :               0.070690000000D 00,
     :               0.076250000000D 00,
     :               0.081950000000D 00,
     :               0.087780000000D 00,
     :               0.093740000000D 00,
     :               0.099860000000D 00,
     :               0.106130000000D 00,
     :               0.112560000000D 00,
     :               0.119160000000D 00,
     :               0.125940000000D 00,
     :               0.132890000000D 00,
     :               0.140060000000D 00,
     :               0.147420000000D 00,
     :               0.155000000000D 00,
     :               0.162800000000D 00,
     :               0.170840000000D 00,
     :               0.179120000000D 00,
     :               0.187670000000D 00,
     :               0.196500000000D 00,
     :               0.205610000000D 00,
     :               0.215040000000D 00,
     :               0.224780000000D 00,
     :               0.234870000000D 00,
     :               0.245310000000D 00,
     :               0.256150000000D 00,
     :               0.267390000000D 00,
     :               0.279070000000D 00,
     :               0.291140000000D 00,
     :               0.303810000000D 00,
     :               0.316860000000D 00,
     :               0.330610000000D 00,
     :               0.344840000000D 00,
     :               0.359730000000D 00,
     :               0.375260000000D 00,
     :               0.391520000000D 00,
     :               0.408510000000D 00,
     :               0.426300000000D 00,
     :               0.444960000000D 00,
     :               0.464560000000D 00,
     :               0.485180000000D 00,
     :               0.506820000000D 00,
     :               0.529720000000D 00,
     :               0.553680000000D 00,
     :               0.579070000000D 00,
     :               0.605930000000D 00,
     :               0.634280000000D 00,
     :               0.664310000000D 00,
     :               0.696140000000D 00/

      DATA ARGFIN2P1/
     :               26.000000000000D 00,
     :               27.000000000000D 00,
     :               28.000000000000D 00,
     :               29.000000000000D 00,
     :               30.000000000000D 00,
     :               31.000000000000D 00,
     :               32.000000000000D 00,
     :               33.000000000000D 00,
     :               34.000000000000D 00,
     :               35.000000000000D 00,
     :               36.000000000000D 00,
     :               37.000000000000D 00,
     :               38.000000000000D 00,
     :               39.000000000000D 00,
     :               40.000000000000D 00,
     :               41.000000000000D 00,
     :               42.000000000000D 00,
     :               43.000000000000D 00,
     :               44.000000000000D 00,
     :               45.000000000000D 00,
     :               46.000000000000D 00,
     :               47.000000000000D 00,
     :               48.000000000000D 00,
     :               49.000000000000D 00,
     :               50.000000000000D 00,
     :               51.000000000000D 00,
     :               52.000000000000D 00,
     :               53.000000000000D 00,
     :               54.000000000000D 00,
     :               55.000000000000D 00,
     :               56.000000000000D 00,
     :               57.000000000000D 00,
     :               58.000000000000D 00,
     :               59.000000000000D 00,
     :               60.000000000000D 00,
     :               61.000000000000D 00,
     :               62.000000000000D 00,
     :               63.000000000000D 00,
     :               64.000000000000D 00,
     :               65.000000000000D 00,
     :               66.000000000000D 00,
     :               67.000000000000D 00,
     :               68.000000000000D 00,
     :               69.000000000000D 00,
     :               70.000000000000D 00,
     :               71.000000000000D 00,
     :               72.000000000000D 00,
     :               73.000000000000D 00,
     :               74.000000000000D 00,
     :               75.000000000000D 00,
     :               76.000000000000D 00,
     :               77.000000000000D 00,
     :               78.000000000000D 00,
     :               79.000000000000D 00,
     :               80.000000000000D 00,
     :               81.000000000000D 00,
     :               82.000000000000D 00,
     :               83.000000000000D 00,
     :               84.000000000000D 00,
     :               85.000000000000D 00,
     :               86.000000000000D 00,
     :               87.000000000000D 00,
     :               88.000000000000D 00,
     :               89.000000000000D 00,
     :               90.000000000000D 00,
     :               91.000000000000D 00,
     :               92.000000000000D 00,
     :               93.000000000000D 00,
     :               94.000000000000D 00,
     :               95.000000000000D 00,
     :               96.000000000000D 00,
     :               97.000000000000D 00,
     :               98.000000000000D 00,
     :               99.000000000000D 00,
     :               100.000000000000D 00,
     :               101.000000000000D 00,
     :               102.000000000000D 00,
     :               103.000000000000D 00,
     :               104.000000000000D 00,
     :               105.000000000000D 00,
     :               106.000000000000D 00,
     :               107.000000000000D 00,
     :               108.000000000000D 00,
     :               109.000000000000D 00,
     :               110.000000000000D 00/





*
*----------------------------------------------------------------------*
*
*   Convergence criterion for interpolation
*
      DATA ACCY/1.0D-03/
*
*   Interpolate or issue error message as appropriate
      IF (Z .LT. 26) THEN
          VALUE = 0.0D0
      ELSE
          CALL INTERP(ARGPARA, VALPARA, NUMVPARA, Z, PARA, ACCY)
          CALL INTERP(ARGPARB, VALPARB, NUMVPARB, Z, PARB, ACCY)
          CALL INTERP(ARGPARC, VALPARC, NUMVPARC, Z, PARC, ACCY)
          CALL INTERP(ARGPARP, VALPARP, NUMVPARP, Z, PARP, ACCY)
          CALL INTERP(ARGRREF, VALRREF, NUMVRREF, Z, RREF, ACCY)
          IF ((N .EQ. 1) .AND. (KAPPA .EQ. -1)) THEN
              CALL INTERP(ARGFIN1S, VALFIN1S, NUMVFIN1S, Z, FIN1S, ACCY)
              VALUE = PARA * (R ** PARP) * (1 + PARB * R + PARC * R * R)
     :                - PARA * (RREF ** PARP) *
     :                (1 + PARB * RREF + PARC * RREF * RREF)
     :                - FZALF(N, KAPPA, Z) + FIN1S
          ELSEIF ((N .EQ. 2) .AND. (KAPPA .EQ. -1)) THEN
              CALL INTERP(ARGFIN2S, VALFIN2S, NUMVFIN2S, Z, FIN2S, ACCY)
              VALUE = PARA * (R ** PARP) * (1 + PARB * R + PARC * R * R)
     :                - PARA * (RREF ** PARP) *
     :                (1 + PARB * RREF + PARC * RREF * RREF)
     :                - FZALF(N, KAPPA, Z) + FIN2S
          ELSEIF ((N .EQ. 2) .AND. (KAPPA .EQ. 1)) THEN
              CALL INTERP(ARGFIN2P1, VALFIN2P1, NUMVFIN2P1, Z,
     :                    FIN2P1, ACCY)
              VALUE = PARA * (R ** PARP) * (1 + PARB * R + PARC * R * R)
     :                - PARA * (RREF ** PARP) *
     :                (1 + PARB * RREF + PARC * RREF * RREF)
     :                - FZALF(N, KAPPA, Z) + FIN2P1
          ELSE
              VALUE = 0.0D0
          ENDIF
      ENDIF

*
      DELTAFZ = VALUE
*
      RETURN
*
  300 FORMAT ('MOHR:')
  301 FORMAT (' Principal quantum number, ',I12,', kappa, ',1I3,'.')
  302 FORMAT (' Principal quantum number, ',1I2,
     :        ', Should be either 1 or 2.')
*
      END
