************************************************************************
*                                                                      *
      SUBROUTINE MOHR (N,KAPPA,Z,FZALFA)
*                                                                      *
*   The  function  F (Z*alpha)  for the  1s  2s  2p-  2p  symmetries   *
*   is computed here.    A value is obtained by interpolating in, or   *
*   extrapolating from, the table due to  P J Mohr.   See  P J Mohr,   *
*   At Data Nucl Data Tables 29 (1983) 453.                            *
*                                                                      *
*   Call(s) to: [LIB92]: INTERP.                                       *
*                                                                      *
*   Written by Farid A Parpia, at Oxford    Last update: 09 Oct 1992   *
*                                                                      *
************************************************************************
*
      IMPLICIT REAL*8          (A-H, O-Z)
*
*----------------------------------------------------------------------*
*
*   Number of data points
*
      DIMENSION VAL2P3(110)
      DIMENSION ARG2P3(110)
      PARAMETER (NUMV2P3 = 110)

      DIMENSION VAL3P3(11)
      DIMENSION ARG3P3(11)
      PARAMETER (NUMV3P3 = 11)

      DIMENSION VAL5D5(10)
      DIMENSION ARG5D5(10)
      PARAMETER (NUMV5D5 = 10)

      DIMENSION VAL5F5(10)
      DIMENSION ARG5F5(10)
      PARAMETER (NUMV5F5 = 10)

      DIMENSION VAL5F7(10)
      DIMENSION ARG5F7(10)
      PARAMETER (NUMV5F7 = 10)

      DIMENSION VAL3D3(11)
      DIMENSION ARG3D3(11)
      PARAMETER (NUMV3D3 = 11)

      DIMENSION VAL3D5(10)
      DIMENSION ARG3D5(10)
      PARAMETER (NUMV3D5 = 10)

      DIMENSION VAL4S(11)
      DIMENSION ARG4S(11)
      PARAMETER (NUMV4S = 11)

      DIMENSION VAL4F7(10)
      DIMENSION ARG4F7(10)
      PARAMETER (NUMV4F7 = 10)

      DIMENSION VAL3P1(11)
      DIMENSION ARG3P1(11)
      PARAMETER (NUMV3P1 = 11)

      DIMENSION VAL5D3(11)
      DIMENSION ARG5D3(11)
      PARAMETER (NUMV5D3 = 11)

      DIMENSION VAL1S(110)
      DIMENSION ARG1S(110)
      PARAMETER (NUMV1S = 110)

      DIMENSION VAL5S(11)
      DIMENSION ARG5S(11)
      PARAMETER (NUMV5S = 11)

      DIMENSION VAL4D5(10)
      DIMENSION ARG4D5(10)
      PARAMETER (NUMV4D5 = 10)

      DIMENSION VAL4P1(11)
      DIMENSION ARG4P1(11)
      PARAMETER (NUMV4P1 = 11)

      DIMENSION VAL4F5(10)
      DIMENSION ARG4F5(10)
      PARAMETER (NUMV4F5 = 10)

      DIMENSION VAL4P3(11)
      DIMENSION ARG4P3(11)
      PARAMETER (NUMV4P3 = 11)

      DIMENSION VAL2P1(110)
      DIMENSION ARG2P1(110)
      PARAMETER (NUMV2P1 = 110)

      DIMENSION VAL2S(110)
      DIMENSION ARG2S(110)
      PARAMETER (NUMV2S = 110)

      DIMENSION VAL3S(11)
      DIMENSION ARG3S(11)
      PARAMETER (NUMV3S = 11)

      DIMENSION VAL5P3(11)
      DIMENSION ARG5P3(11)
      PARAMETER (NUMV5P3 = 11)

      DIMENSION VAL4D3(11)
      DIMENSION ARG4D3(11)
      PARAMETER (NUMV4D3 = 11)

      DIMENSION VAL5P1(11)
      DIMENSION ARG5P1(11)
      PARAMETER (NUMV5P1 = 11)

      DATA VAL2P3/
     :               0.1235D 00,
     :               0.1238D 00,
     :               0.1243D 00,
     :               0.1249D 00,
     :               0.1256D 00,
     :               0.126412D 00,
     :               0.127324D 00,
     :               0.128236D 00,
     :               0.129248D 00,
     :               0.13036D 00,
     :               0.1314814D 00,
     :               0.1327028D 00,
     :               0.1339242D 00,
     :               0.1352456D 00,
     :               0.136567D 00,
     :               0.1379814D 00,
     :               0.1393958D 00,
     :               0.1408102D 00,
     :               0.1423246D 00,
     :               0.143839D 00,
     :               0.1453354D 00,
     :               0.1469318D 00,
     :               0.1485282D 00,
     :               0.1502246D 00,
     :               0.151921D 00,
     :               0.1536262D 00,
     :               0.1553314D 00,
     :               0.1570366D 00,
     :               0.1588418D 00,
     :               0.160647D 00,
     :               0.16243778D 00,
     :               0.16432856D 00,
     :               0.16611934D 00,
     :               0.16801012D 00,
     :               0.1699009D 00,
     :               0.1717997D 00,
     :               0.1736985D 00,
     :               0.1756973D 00,
     :               0.1775961D 00,
     :               0.1795949D 00,
     :               0.18158854D 00,
     :               0.18358218D 00,
     :               0.18557582D 00,
     :               0.18756946D 00,
     :               0.1896631D 00,
     :               0.19176122D 00,
     :               0.19375934D 00,
     :               0.19585746D 00,
     :               0.19795558D 00,
     :               0.2000537D 00,
     :               0.20214794D 00,
     :               0.20424218D 00,
     :               0.20643642D 00,
     :               0.20853066D 00,
     :               0.2107249D 00,
     :               0.21282812D 00,
     :               0.21503134D 00,
     :               0.21723456D 00,
     :               0.21943778D 00,
     :               0.221641D 00,
     :               0.22382738D 00,
     :               0.22601376D 00,
     :               0.22830014D 00,
     :               0.23048652D 00,
     :               0.2327729D 00,
     :               0.23497682D 00,
     :               0.23728074D 00,
     :               0.23948466D 00,
     :               0.24178858D 00,
     :               0.2440925D 00,
     :               0.24638864D 00,
     :               0.24868478D 00,
     :               0.25098092D 00,
     :               0.25327706D 00,
     :               0.2555732D 00,
     :               0.25787578D 00,
     :               0.26017836D 00,
     :               0.26248094D 00,
     :               0.26488352D 00,
     :               0.2671861D 00,
     :               0.26948852D 00,
     :               0.27189094D 00,
     :               0.27419336D 00,
     :               0.27659578D 00,
     :               0.2788982D 00,
     :               0.28129212D 00,
     :               0.28358604D 00,
     :               0.28597996D 00,
     :               0.28827388D 00,
     :               0.2906678D 00,
     :               0.2930621D 00,
     :               0.2953564D 00,
     :               0.2977507D 00,
     :               0.300045D 00,
     :               0.3024393D 00,
     :               0.30473828D 00,
     :               0.30713726D 00,
     :               0.30943624D 00,
     :               0.31183522D 00,
     :               0.3141342D 00,
     :               0.31643492D 00,
     :               0.31873564D 00,
     :               0.32103636D 00,
     :               0.32333708D 00,
     :               0.3256378D 00,
     :               0.32794528D 00,
     :               0.33015276D 00,
     :               0.33236024D 00,
     :               0.33456772D 00,
     :               0.3367752D 00/

      DATA ARG2P3/
     :               1D 00,
     :               2D 00,
     :               3D 00,
     :               4D 00,
     :               5D 00,
     :               6D 00,
     :               7D 00,
     :               8D 00,
     :               9D 00,
     :               10D 00,
     :               11D 00,
     :               12D 00,
     :               13D 00,
     :               14D 00,
     :               15D 00,
     :               16D 00,
     :               17D 00,
     :               18D 00,
     :               19D 00,
     :               20D 00,
     :               21D 00,
     :               22D 00,
     :               23D 00,
     :               24D 00,
     :               25D 00,
     :               26D 00,
     :               27D 00,
     :               28D 00,
     :               29D 00,
     :               30D 00,
     :               31D 00,
     :               32D 00,
     :               33D 00,
     :               34D 00,
     :               35D 00,
     :               36D 00,
     :               37D 00,
     :               38D 00,
     :               39D 00,
     :               40D 00,
     :               41D 00,
     :               42D 00,
     :               43D 00,
     :               44D 00,
     :               45D 00,
     :               46D 00,
     :               47D 00,
     :               48D 00,
     :               49D 00,
     :               50D 00,
     :               51D 00,
     :               52D 00,
     :               53D 00,
     :               54D 00,
     :               55D 00,
     :               56D 00,
     :               57D 00,
     :               58D 00,
     :               59D 00,
     :               60D 00,
     :               61D 00,
     :               62D 00,
     :               63D 00,
     :               64D 00,
     :               65D 00,
     :               66D 00,
     :               67D 00,
     :               68D 00,
     :               69D 00,
     :               70D 00,
     :               71D 00,
     :               72D 00,
     :               73D 00,
     :               74D 00,
     :               75D 00,
     :               76D 00,
     :               77D 00,
     :               78D 00,
     :               79D 00,
     :               80D 00,
     :               81D 00,
     :               82D 00,
     :               83D 00,
     :               84D 00,
     :               85D 00,
     :               86D 00,
     :               87D 00,
     :               88D 00,
     :               89D 00,
     :               90D 00,
     :               91D 00,
     :               92D 00,
     :               93D 00,
     :               94D 00,
     :               95D 00,
     :               96D 00,
     :               97D 00,
     :               98D 00,
     :               99D 00,
     :               100D 00,
     :               101D 00,
     :               102D 00,
     :               103D 00,
     :               104D 00,
     :               105D 00,
     :               106D 00,
     :               107D 00,
     :               108D 00,
     :               109D 00,
     :               110D 00/

      DATA VAL3P3/
     :               0.1421D 00,
     :               0.1572D 00,
     :               0.1761D 00,
     :               0.1977D 00,
     :               0.2214D 00,
     :               0.247D 00,
     :               0.2745D 00,
     :               0.3038D 00,
     :               0.335D 00,
     :               0.3679D 00,
     :               0.402D 00/

      DATA ARG3P3/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL5D5/
     :               0.0560084D 00,
     :               0.0584608D 00,
     :               0.0602164D 00,
     :               0.0620673D 00,
     :               0.0650174D 00,
     :               0.0665677D 00,
     :               0.0703682D 00,
     :               0.0714981D 00,
     :               0.0761897D 00,
     :               0.0823592D 00/

      DATA ARG5D5/
     :               60D 00,
     :               66D 00,
     :               70D 00,
     :               74D 00,
     :               80D 00,
     :               83D 00,
     :               90D 00,
     :               92D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL5F5/
     :               -0.0195626D 00,
     :               -0.0193062D 00,
     :               -0.0191179D 00,
     :               -0.0189139D 00,
     :               -0.0185761D 00,
     :               -0.0183914D 00,
     :               -0.0176156D 00,
     :               -0.0177669D 00,
     :               -0.0171113D 00,
     :               -0.0161389D 00/

      DATA ARG5F5/
     :               60D 00,
     :               66D 00,
     :               70D 00,
     :               74D 00,
     :               80D 00,
     :               83D 00,
     :               90D 00,
     :               92D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL5F7/
     :               0.0230942D 00,
     :               0.0235345D 00,
     :               0.0238498D 00,
     :               0.024183D 00,
     :               0.024717D 00,
     :               0.0249997D 00,
     :               0.0257006D 00,
     :               0.0259119D 00,
     :               0.026806D 00,
     :               0.0280366D 00/

      DATA ARG5F7/
     :               60D 00,
     :               66D 00,
     :               70D 00,
     :               74D 00,
     :               80D 00,
     :               83D 00,
     :               90D 00,
     :               92D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL3D3/
     :               -0.0428D 00,
     :               -0.042D 00,
     :               -0.041D 00,
     :               -0.0396D 00,
     :               -0.0378D 00,
     :               -0.0353D 00,
     :               -0.0321D 00,
     :               -0.0279D 00,
     :               -0.0225D 00,
     :               -0.0154D 00,
     :               -0.0062D 00/

      DATA ARG3D3/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL3D5/
     :               0.0503484D 00,
     :               0.0522327D 00,
     :               0.0535711D 00,
     :               0.0549734D 00,
     :               0.0571916D 00,
     :               0.0583498D 00,
     :               0.0611703D 00,
     :               0.062004D 00,
     :               0.0654457D 00,
     :               0.0699331D 00/

      DATA ARG3D5/
     :               60D 00,
     :               66D 00,
     :               70D 00,
     :               74D 00,
     :               80D 00,
     :               83D 00,
     :               90D 00,
     :               92D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL4S/
     :               4.9749D 00,
     :               3.5834D 00,
     :               2.911D 00,
     :               2.5215D 00,
     :               2.2842D 00,
     :               2.1455D 00,
     :               2.0814D 00,
     :               2.084D 00,
     :               2.1582D 00,
     :               2.3262D 00,
     :               2.6484D 00/

      DATA ARG4S/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL4F7/
     :               0.022159D 00,
     :               0.0225316D 00,
     :               0.0227973D 00,
     :               0.0230768D 00,
     :               0.0235224D 00,
     :               0.0237572D 00,
     :               0.0243367D 00,
     :               0.0245106D 00,
     :               0.0252427D 00,
     :               0.0262422D 00/

      DATA ARG4F7/
     :               60D 00,
     :               66D 00,
     :               70D 00,
     :               74D 00,
     :               80D 00,
     :               83D 00,
     :               90D 00,
     :               92D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL3P1/
     :               -0.1021D 00,
     :               -0.76D 00,
     :               -0.403D 00,
     :               -0.0041D 00,
     :               0.0414D 00,
     :               0.0956D 00,
     :               0.1623D 00,
     :               0.2483D 00,
     :               0.366D 00,
     :               0.5408D 00,
     :               0.8322D 00/

      DATA ARG3P1/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL5D3/
     :               -0.0396D 00,
     :               -0.0387D 00,
     :               -0.0374D 00,
     :               -0.0356D 00,
     :               -0.0331D 00,
     :               -0.0297D 00,
     :               -0.0252D 00,
     :               -0.019D 00,
     :               -0.0108D 00,
     :               0.0001D 00,
     :               0.0145D 00/

      DATA ARG5D3/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL1S/
     :               10.316827D 00,
     :               8.528327D 00,
     :               7.504527D 00,
     :               6.792827D 00,
     :               6.251627D 00,
     :               5.81785404D 00,
     :               5.45798108D 00,
     :               5.15200812D 00,
     :               4.88703516D 00,
     :               4.6541622D 00,
     :               4.44719192D 00,
     :               4.26162164D 00,
     :               4.09385136D 00,
     :               3.94118108D 00,
     :               3.8014108D 00,
     :               3.67289976D 00,
     :               3.55418872D 00,
     :               3.44417768D 00,
     :               3.34176664D 00,
     :               3.2462556D 00,
     :               3.15694532D 00,
     :               3.07313504D 00,
     :               2.99432476D 00,
     :               2.92011448D 00,
     :               2.8501042D 00,
     :               2.78398638D 00,
     :               2.72136856D 00,
     :               2.66195074D 00,
     :               2.60563292D 00,
     :               2.5520151D 00,
     :               2.5010073D 00,
     :               2.4524995D 00,
     :               2.4061917D 00,
     :               2.3620839D 00,
     :               2.3199761D 00,
     :               2.27968656D 00,
     :               2.24109702D 00,
     :               2.20430748D 00,
     :               2.16901794D 00,
     :               2.1352284D 00,
     :               2.10281146D 00,
     :               2.07179452D 00,
     :               2.04197758D 00,
     :               2.01336064D 00,
     :               1.9859437D 00,
     :               1.95960982D 00,
     :               1.93427594D 00,
     :               1.91004206D 00,
     :               1.88670818D 00,
     :               1.8642743D 00,
     :               1.8427855D 00,
     :               1.8220967D 00,
     :               1.8022079D 00,
     :               1.7831191D 00,
     :               1.7648303D 00,
     :               1.7472514D 00,
     :               1.7303725D 00,
     :               1.7141936D 00,
     :               1.6987147D 00,
     :               1.6838358D 00,
     :               1.66963592D 00,
     :               1.65593604D 00,
     :               1.64293616D 00,
     :               1.63053628D 00,
     :               1.6186364D 00,
     :               1.60731062D 00,
     :               1.59658484D 00,
     :               1.58625906D 00,
     :               1.57663328D 00,
     :               1.5674075D 00,
     :               1.55876282D 00,
     :               1.55051814D 00,
     :               1.54287346D 00,
     :               1.53562878D 00,
     :               1.5289841D 00,
     :               1.52276278D 00,
     :               1.51704146D 00,
     :               1.51182014D 00,
     :               1.50699882D 00,
     :               1.5027775D 00,
     :               1.49897452D 00,
     :               1.49567154D 00,
     :               1.49286856D 00,
     :               1.49056558D 00,
     :               1.4887626D 00,
     :               1.48745846D 00,
     :               1.48665432D 00,
     :               1.48645018D 00,
     :               1.48664604D 00,
     :               1.4875419D 00,
     :               1.48887596D 00,
     :               1.49081002D 00,
     :               1.49344408D 00,
     :               1.49657814D 00,
     :               1.5005122D 00,
     :               1.5049697D 00,
     :               1.5101272D 00,
     :               1.5159847D 00,
     :               1.5227422D 00,
     :               1.5301997D 00,
     :               1.5385222D 00,
     :               1.5476447D 00,
     :               1.5577672D 00,
     :               1.5687897D 00,
     :               1.5809122D 00,
     :               1.59442236D 00,
     :               1.60903252D 00,
     :               1.62474268D 00,
     :               1.64175284D 00,
     :               1.660063D 00/

      DATA ARG1S/
     :               1D 00,
     :               2D 00,
     :               3D 00,
     :               4D 00,
     :               5D 00,
     :               6D 00,
     :               7D 00,
     :               8D 00,
     :               9D 00,
     :               10D 00,
     :               11D 00,
     :               12D 00,
     :               13D 00,
     :               14D 00,
     :               15D 00,
     :               16D 00,
     :               17D 00,
     :               18D 00,
     :               19D 00,
     :               20D 00,
     :               21D 00,
     :               22D 00,
     :               23D 00,
     :               24D 00,
     :               25D 00,
     :               26D 00,
     :               27D 00,
     :               28D 00,
     :               29D 00,
     :               30D 00,
     :               31D 00,
     :               32D 00,
     :               33D 00,
     :               34D 00,
     :               35D 00,
     :               36D 00,
     :               37D 00,
     :               38D 00,
     :               39D 00,
     :               40D 00,
     :               41D 00,
     :               42D 00,
     :               43D 00,
     :               44D 00,
     :               45D 00,
     :               46D 00,
     :               47D 00,
     :               48D 00,
     :               49D 00,
     :               50D 00,
     :               51D 00,
     :               52D 00,
     :               53D 00,
     :               54D 00,
     :               55D 00,
     :               56D 00,
     :               57D 00,
     :               58D 00,
     :               59D 00,
     :               60D 00,
     :               61D 00,
     :               62D 00,
     :               63D 00,
     :               64D 00,
     :               65D 00,
     :               66D 00,
     :               67D 00,
     :               68D 00,
     :               69D 00,
     :               70D 00,
     :               71D 00,
     :               72D 00,
     :               73D 00,
     :               74D 00,
     :               75D 00,
     :               76D 00,
     :               77D 00,
     :               78D 00,
     :               79D 00,
     :               80D 00,
     :               81D 00,
     :               82D 00,
     :               83D 00,
     :               84D 00,
     :               85D 00,
     :               86D 00,
     :               87D 00,
     :               88D 00,
     :               89D 00,
     :               90D 00,
     :               91D 00,
     :               92D 00,
     :               93D 00,
     :               94D 00,
     :               95D 00,
     :               96D 00,
     :               97D 00,
     :               98D 00,
     :               99D 00,
     :               100D 00,
     :               101D 00,
     :               102D 00,
     :               103D 00,
     :               104D 00,
     :               105D 00,
     :               106D 00,
     :               107D 00,
     :               108D 00,
     :               109D 00,
     :               110D 00/

      DATA VAL5S/
     :               4.9858D 00,
     :               3.5923D 00,
     :               2.9173D 00,
     :               2.5249D 00,
     :               2.2833D 00,
     :               2.1395D 00,
     :               2.0686D 00,
     :               2.0619D 00,
     :               2.1225D 00,
     :               2.2696D 00,
     :               2.5566D 00/

      DATA ARG5S/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL4D5/
     :               0.0540821D 00,
     :               0.0563571D 00,
     :               0.0579826D 00,
     :               0.0596935D 00,
     :               0.062415D 00,
     :               0.063843D 00,
     :               0.0673377D 00,
     :               0.068375D 00,
     :               0.0726763D 00,
     :               0.0783217D 00/

      DATA ARG4D5/
     :               60D 00,
     :               66D 00,
     :               70D 00,
     :               74D 00,
     :               80D 00,
     :               83D 00,
     :               90D 00,
     :               92D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL4P1/
     :               -0.0963D 00,
     :               -0.069D 00,
     :               -0.0344D 00,
     :               0.0064D 00,
     :               0.0538D 00,
     :               0.1098D 00,
     :               0.178D 00,
     :               0.2649D 00,
     :               0.3819D 00,
     :               0.5525D 00,
     :               0.8311D 00/

      DATA ARG4P1/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL4F5/
     :               -0.0203415D 00,
     :               -0.0201262D 00,
     :               -0.0199699D 00,
     :               -0.019802D 00,
     :               -0.0195284D 00,
     :               -0.0193804D 00,
     :               -0.0190034D 00,
     :               -0.018887D 00,
     :               -0.0183786D 00,
     :               -0.0176375D 00/

      DATA ARG4F5/
     :               60D 00,
     :               66D 00,
     :               70D 00,
     :               74D 00,
     :               80D 00,
     :               83D 00,
     :               90D 00,
     :               92D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL4P3/
     :               0.1477D 00,
     :               0.163D 00,
     :               0.1827D 00,
     :               0.2052D 00,
     :               0.2299D 00,
     :               0.2568D 00,
     :               0.2858D 00,
     :               0.317D 00,
     :               0.3507D 00,
     :               0.3868D 00,
     :               0.4247D 00/

      DATA ARG4P3/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL2P1/
     :               -0.1266D 00,
     :               -0.126D 00,
     :               -0.1251D 00,
     :               -0.1241D 00,
     :               -0.1228D 00,
     :               -0.121426D 00,
     :               -0.119952D 00,
     :               -0.118378D 00,
     :               -0.116604D 00,
     :               -0.11483D 00,
     :               -0.1129338D 00,
     :               -0.1109376D 00,
     :               -0.1088414D 00,
     :               -0.1067452D 00,
     :               -0.104549D 00,
     :               -0.102243D 00,
     :               -0.099937D 00,
     :               -0.097531D 00,
     :               -0.095025D 00,
     :               -0.092519D 00,
     :               -0.0899084D 00,
     :               -0.0872978D 00,
     :               -0.0845872D 00,
     :               -0.0818766D 00,
     :               -0.079066D 00,
     :               -0.07625884D 00,
     :               -0.07335168D 00,
     :               -0.07094452D 00,
     :               -0.06733736D 00,
     :               -0.0643302D 00,
     :               -0.06123262D 00,
     :               -0.05813504D 00,
     :               -0.05493746D 00,
     :               -0.05163988D 00,
     :               -0.0483423D 00,
     :               -0.04494384D 00,
     :               -0.04154538D 00,
     :               -0.03814692D 00,
     :               -0.03464846D 00,
     :               -0.03105D 00,
     :               -0.02744606D 00,
     :               -0.02374212D 00,
     :               -0.02003818D 00,
     :               -0.01623424D 00,
     :               -0.0123303D 00,
     :               -0.0084218D 00,
     :               -0.0044133D 00,
     :               -0.0003048D 00,
     :               0.0038037D 00,
     :               0.0080122D 00,
     :               0.01232034D 00,
     :               0.01662848D 00,
     :               0.02113662D 00,
     :               0.02564476D 00,
     :               0.0302529D 00,
     :               0.03495496D 00,
     :               0.03975702D 00,
     :               0.04465908D 00,
     :               0.04966114D 00,
     :               0.0547632D 00,
     :               0.05995806D 00,
     :               0.06525292D 00,
     :               0.07074778D 00,
     :               0.07634264D 00,
     :               0.0820375D 00,
     :               0.0878365D 00,
     :               0.0938355D 00,
     :               0.1003345D 00,
     :               0.1062335D 00,
     :               0.1127325D 00,
     :               0.11933188D 00,
     :               0.12613126D 00,
     :               0.13313064D 00,
     :               0.14033002D 00,
     :               0.1477294D 00,
     :               0.15532878D 00,
     :               0.16322816D 00,
     :               0.17132754D 00,
     :               0.17962692D 00,
     :               0.1882263D 00,
     :               0.1971182D 00,
     :               0.2063101D 00,
     :               0.215802D 00,
     :               0.2256939D 00,
     :               0.2358858D 00,
     :               0.2464631D 00,
     :               0.2574404D 00,
     :               0.2688177D 00,
     :               0.280695D 00,
     :               0.2930723D 00,
     :               0.30592844D 00,
     :               0.31928458D 00,
     :               0.33334072D 00,
     :               0.34799686D 00,
     :               0.363253D 00,
     :               0.3793046D 00,
     :               0.3960562D 00,
     :               0.4136078D 00,
     :               0.4321594D 00,
     :               0.451711D 00,
     :               0.4722054D 00,
     :               0.4939998D 00,
     :               0.5168942D 00,
     :               0.5411886D 00,
     :               0.566883D 00,
     :               0.5944666D 00,
     :               0.6237502D 00,
     :               0.6548338D 00,
     :               0.6879174D 00,
     :               0.723101D 00/

      DATA ARG2P1/
     :               1D 00,
     :               2D 00,
     :               3D 00,
     :               4D 00,
     :               5D 00,
     :               6D 00,
     :               7D 00,
     :               8D 00,
     :               9D 00,
     :               10D 00,
     :               11D 00,
     :               12D 00,
     :               13D 00,
     :               14D 00,
     :               15D 00,
     :               16D 00,
     :               17D 00,
     :               18D 00,
     :               19D 00,
     :               20D 00,
     :               21D 00,
     :               22D 00,
     :               23D 00,
     :               24D 00,
     :               25D 00,
     :               26D 00,
     :               27D 00,
     :               28D 00,
     :               29D 00,
     :               30D 00,
     :               31D 00,
     :               32D 00,
     :               33D 00,
     :               34D 00,
     :               35D 00,
     :               36D 00,
     :               37D 00,
     :               38D 00,
     :               39D 00,
     :               40D 00,
     :               41D 00,
     :               42D 00,
     :               43D 00,
     :               44D 00,
     :               45D 00,
     :               46D 00,
     :               47D 00,
     :               48D 00,
     :               49D 00,
     :               50D 00,
     :               51D 00,
     :               52D 00,
     :               53D 00,
     :               54D 00,
     :               55D 00,
     :               56D 00,
     :               57D 00,
     :               58D 00,
     :               59D 00,
     :               60D 00,
     :               61D 00,
     :               62D 00,
     :               63D 00,
     :               64D 00,
     :               65D 00,
     :               66D 00,
     :               67D 00,
     :               68D 00,
     :               69D 00,
     :               70D 00,
     :               71D 00,
     :               72D 00,
     :               73D 00,
     :               74D 00,
     :               75D 00,
     :               76D 00,
     :               77D 00,
     :               78D 00,
     :               79D 00,
     :               80D 00,
     :               81D 00,
     :               82D 00,
     :               83D 00,
     :               84D 00,
     :               85D 00,
     :               86D 00,
     :               87D 00,
     :               88D 00,
     :               89D 00,
     :               90D 00,
     :               91D 00,
     :               92D 00,
     :               93D 00,
     :               94D 00,
     :               95D 00,
     :               96D 00,
     :               97D 00,
     :               98D 00,
     :               99D 00,
     :               100D 00,
     :               101D 00,
     :               102D 00,
     :               103D 00,
     :               104D 00,
     :               105D 00,
     :               106D 00,
     :               107D 00,
     :               108D 00,
     :               109D 00,
     :               110D 00/

      DATA VAL2S/
     :               10.5475D 00,
     :               8.7594D 00,
     :               7.7361D 00,
     :               7.0252D 00,
     :               6.4848D 00,
     :               6.05225D 00,
     :               5.6937D 00,
     :               5.38905D 00,
     :               5.1256D 00,
     :               4.89445D 00,
     :               4.689176D 00,
     :               4.505302D 00,
     :               4.339328D 00,
     :               4.188554D 00,
     :               4.05088D 00,
     :               3.9244336D 00,
     :               3.8077872D 00,
     :               3.6999408D 00,
     :               3.5998944D 00,
     :               3.506648D 00,
     :               3.41965026D 00,
     :               3.33835252D 00,
     :               3.26205478D 00,
     :               3.19045704D 00,
     :               3.1229593D 00,
     :               3.05953514D 00,
     :               2.99961098D 00,
     :               2.94308682D 00,
     :               2.88956266D 00,
     :               2.8388385D 00,
     :               2.79085796D 00,
     :               2.74537742D 00,
     :               2.70219688D 00,
     :               2.66121634D 00,
     :               2.6223358D 00,
     :               2.58533448D 00,
     :               2.55023316D 00,
     :               2.51683184D 00,
     :               2.48503052D 00,
     :               2.4548292D 00,
     :               2.42606136D 00,
     :               2.39879352D 00,
     :               2.37282568D 00,
     :               2.34815784D 00,
     :               2.32469D 00,
     :               2.30247954D 00,
     :               2.28126908D 00,
     :               2.26125862D 00,
     :               2.24224816D 00,
     :               2.2243377D 00,
     :               2.2073155D 00,
     :               2.1912933D 00,
     :               2.1761711D 00,
     :               2.1620489D 00,
     :               2.1487267D 00,
     :               2.13620488D 00,
     :               2.12458306D 00,
     :               2.11376124D 00,
     :               2.10373942D 00,
     :               2.0945176D 00,
     :               2.08607622D 00,
     :               2.07833484D 00,
     :               2.07129346D 00,
     :               2.06505208D 00,
     :               2.0596107D 00,
     :               2.05478678D 00,
     :               2.05076286D 00,
     :               2.04743894D 00,
     :               2.04481502D 00,
     :               2.0428911D 00,
     :               2.04165578D 00,
     :               2.04122046D 00,
     :               2.04148514D 00,
     :               2.04244982D 00,
     :               2.0441145D 00,
     :               2.04655282D 00,
     :               2.04979114D 00,
     :               2.05372946D 00,
     :               2.05836778D 00,
     :               2.0639061D 00,
     :               2.07022002D 00,
     :               2.07733394D 00,
     :               2.08534786D 00,
     :               2.09416178D 00,
     :               2.1038757D 00,
     :               2.11455724D 00,
     :               2.12613878D 00,
     :               2.13872032D 00,
     :               2.15220186D 00,
     :               2.1668834D 00,
     :               2.18263472D 00,
     :               2.19948604D 00,
     :               2.21753736D 00,
     :               2.23688868D 00,
     :               2.25754D 00,
     :               2.2795364D 00,
     :               2.3029328D 00,
     :               2.3280292D 00,
     :               2.3547256D 00,
     :               2.383122D 00,
     :               2.4133572D 00,
     :               2.4454924D 00,
     :               2.4798276D 00,
     :               2.5163628D 00,
     :               2.555298D 00,
     :               2.5971568D 00,
     :               2.6417156D 00,
     :               2.6891744D 00,
     :               2.7397332D 00,
     :               2.793592D 00/

      DATA ARG2S/
     :               1D 00,
     :               2D 00,
     :               3D 00,
     :               4D 00,
     :               5D 00,
     :               6D 00,
     :               7D 00,
     :               8D 00,
     :               9D 00,
     :               10D 00,
     :               11D 00,
     :               12D 00,
     :               13D 00,
     :               14D 00,
     :               15D 00,
     :               16D 00,
     :               17D 00,
     :               18D 00,
     :               19D 00,
     :               20D 00,
     :               21D 00,
     :               22D 00,
     :               23D 00,
     :               24D 00,
     :               25D 00,
     :               26D 00,
     :               27D 00,
     :               28D 00,
     :               29D 00,
     :               30D 00,
     :               31D 00,
     :               32D 00,
     :               33D 00,
     :               34D 00,
     :               35D 00,
     :               36D 00,
     :               37D 00,
     :               38D 00,
     :               39D 00,
     :               40D 00,
     :               41D 00,
     :               42D 00,
     :               43D 00,
     :               44D 00,
     :               45D 00,
     :               46D 00,
     :               47D 00,
     :               48D 00,
     :               49D 00,
     :               50D 00,
     :               51D 00,
     :               52D 00,
     :               53D 00,
     :               54D 00,
     :               55D 00,
     :               56D 00,
     :               57D 00,
     :               58D 00,
     :               59D 00,
     :               60D 00,
     :               61D 00,
     :               62D 00,
     :               63D 00,
     :               64D 00,
     :               65D 00,
     :               66D 00,
     :               67D 00,
     :               68D 00,
     :               69D 00,
     :               70D 00,
     :               71D 00,
     :               72D 00,
     :               73D 00,
     :               74D 00,
     :               75D 00,
     :               76D 00,
     :               77D 00,
     :               78D 00,
     :               79D 00,
     :               80D 00,
     :               81D 00,
     :               82D 00,
     :               83D 00,
     :               84D 00,
     :               85D 00,
     :               86D 00,
     :               87D 00,
     :               88D 00,
     :               89D 00,
     :               90D 00,
     :               91D 00,
     :               92D 00,
     :               93D 00,
     :               94D 00,
     :               95D 00,
     :               96D 00,
     :               97D 00,
     :               98D 00,
     :               99D 00,
     :               100D 00,
     :               101D 00,
     :               102D 00,
     :               103D 00,
     :               104D 00,
     :               105D 00,
     :               106D 00,
     :               107D 00,
     :               108D 00,
     :               109D 00,
     :               110D 00/

      DATA VAL3S/
     :               4.9524D 00,
     :               3.5633D 00,
     :               2.894D 00,
     :               2.5083D 00,
     :               2.2757D 00,
     :               2.1431D 00,
     :               2.0874D 00,
     :               2.1018D 00,
     :               2.1935D 00,
     :               2.3897D 00,
     :               2.7609D 00/

      DATA ARG3S/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL5P3/
     :               0.1502D 00,
     :               0.1662D 00,
     :               0.1861D 00,
     :               0.2089D 00,
     :               0.2341D 00,
     :               0.2614D 00,
     :               0.291D 00,
     :               0.3229D 00,
     :               0.3574D 00,
     :               0.3946D 00,
     :               0.4338D 00/

      DATA ARG5P3/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL4D3/
     :               -0.0403D 00,
     :               -0.0399D 00,
     :               -0.0387D 00,
     :               -0.0371D 00,
     :               -0.0348D 00,
     :               -0.0317D 00,
     :               -0.0276D 00,
     :               -0.0222D 00,
     :               -0.0149D 00,
     :               -0.0053D 00,
     :               0.0074D 00/

      DATA ARG4D3/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/

      DATA VAL5P1/
     :               -0.0933D 00,
     :               -0.0652D 00,
     :               -0.0299D 00,
     :               0.0116D 00,
     :               0.0597D 00,
     :               0.1161D 00,
     :               0.1843D 00,
     :               0.2703D 00,
     :               0.3848D 00,
     :               0.5497D 00,
     :               0.815D 00/

      DATA ARG5P1/
     :               10D 00,
     :               20D 00,
     :               30D 00,
     :               40D 00,
     :               50D 00,
     :               60D 00,
     :               70D 00,
     :               80D 00,
     :               90D 00,
     :               100D 00,
     :               110D 00/





*
*----------------------------------------------------------------------*
*
*   Convergence criterion for interpolation
*
      DATA ACCY/1.0D-03/
*
*   Interpolate or issue error message as appropriate
*
      IF ((N .EQ. 1) .AND. (KAPPA .EQ. -1)) THEN
          CALL INTERP(ARG1S, VAL1S, NUMV1S, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 2) .AND. (KAPPA .EQ. -1)) THEN
          CALL INTERP(ARG2S, VAL2S, NUMV2S, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 3) .AND. (KAPPA .EQ. -1)) THEN
          CALL INTERP(ARG3S, VAL3S, NUMV3S, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 4) .AND. (KAPPA .EQ. -1)) THEN
          CALL INTERP(ARG4S, VAL4S, NUMV4S, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 5) .AND. (KAPPA .EQ. -1)) THEN
          CALL INTERP(ARG5S, VAL5S, NUMV5S, Z, VALUE, ACCY)

      ELSEIF ((N .EQ. 2) .AND. (KAPPA .EQ. 1)) THEN
          CALL INTERP(ARG2P1, VAL2P1, NUMV2P1, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 3) .AND. (KAPPA .EQ. 1)) THEN
          CALL INTERP(ARG3P1, VAL3P1, NUMV3P1, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 4) .AND. (KAPPA .EQ. 1)) THEN
          CALL INTERP(ARG4P1, VAL4P1, NUMV4P1, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 5) .AND. (KAPPA .EQ. 1)) THEN
          CALL INTERP(ARG5P1, VAL5P1, NUMV5P1, Z, VALUE, ACCY)

      ELSEIF ((N .EQ. 2) .AND. (KAPPA .EQ. -2)) THEN
          CALL INTERP(ARG2P3, VAL2P3, NUMV2P3, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 3) .AND. (KAPPA .EQ. -2)) THEN
          CALL INTERP(ARG3P3, VAL3P3, NUMV3P3, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 4) .AND. (KAPPA .EQ. -2)) THEN
          CALL INTERP(ARG4P3, VAL4P3, NUMV4P3, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 5) .AND. (KAPPA .EQ. -2)) THEN
          CALL INTERP(ARG5P3, VAL5P3, NUMV5P3, Z, VALUE, ACCY)

      ELSEIF ((N .EQ. 3) .AND. (KAPPA .EQ. 2)) THEN
          CALL INTERP(ARG3D3, VAL3D3, NUMV3D3, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 4) .AND. (KAPPA .EQ. 2)) THEN
          CALL INTERP(ARG4D3, VAL4D3, NUMV4D3, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 5) .AND. (KAPPA .EQ. 2)) THEN
          CALL INTERP(ARG5D3, VAL5D3, NUMV5D3, Z, VALUE, ACCY)

      ELSEIF ((N .EQ. 3) .AND. (KAPPA .EQ. -3)) THEN
          CALL INTERP(ARG3D5, VAL3D5, NUMV3D5, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 4) .AND. (KAPPA .EQ. -3)) THEN
          CALL INTERP(ARG4D5, VAL4D5, NUMV4D5, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 5) .AND. (KAPPA .EQ. -3)) THEN
          CALL INTERP(ARG5D5, VAL5D5, NUMV5D5, Z, VALUE, ACCY)

      ELSEIF ((N .EQ. 4) .AND. (KAPPA .EQ. 3)) THEN
          CALL INTERP(ARG4F5, VAL4F5, NUMV4F5, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 5) .AND. (KAPPA .EQ. 3)) THEN
          CALL INTERP(ARG5F5, VAL5F5, NUMV5F5, Z, VALUE, ACCY)

      ELSEIF ((N .EQ. 4) .AND. (KAPPA .EQ. -4)) THEN
          CALL INTERP(ARG4F7, VAL4F7, NUMV4F7, Z, VALUE, ACCY)
      ELSEIF ((N .EQ. 5) .AND. (KAPPA .EQ. -4)) THEN
          CALL INTERP(ARG5F7, VAL5F7, NUMV5F7, Z, VALUE, ACCY)

      ELSE
         WRITE (*,300)
         WRITE (*,301) N,KAPPA
         STOP
      ENDIF

*
      FZALFA = VALUE
*
      RETURN
*
  300 FORMAT ('MOHR:')
  301 FORMAT (' Principal quantum number, ',I12,', kappa, ',1I3,'.')
  302 FORMAT (' Principal quantum number, ',1I2,
     :        ', Should be either 1 or 2.')
*
      END
