
************************************************************************
*                                                                      *
      SUBROUTINE LODHRWF (rwffile)
*                                                                      *
*   Load the rwf file for use in screening calucations                 *
*                                                                      *
*   Call(s) to: [LIB92]:                                               *
*                                                                      *
*   Written by John Lowe                  Last revision: 10 Dec 2011   *
*                                                                      *
************************************************************************
*

      IMPLICIT REAL*8          (A-H, O-Z)
*
      character*(*) rwffile
      include 'parameters.def'
CGG      PARAMETER (NNNP = 590)
CGG      PARAMETER (NNN1 = NNNP+10)
CGG      PARAMETER (NNNW = 120)

      real*8 e(nnnw)
*
      integer ierr, ios, npy, naky, my, loc
      real*8 ey

      character*6 G92RWF

      pointer (pntrpa,pa(1))
      pointer (pntrqa,qa(1))
      pointer (pntrra,ra(1))

      pointer (pntrpf,pf(nnnp,1))
      pointer (pntrqf,qf(nnnp,1))

      pointer (pntrtpf, tpf(nnnp,1))
      pointer (pntrtqf, tqf(nnnp,1))

      pointer (pntrhpf, hpf(nnnp,1))
      pointer (pntrhqf, hqf(nnnp,1))

      real*8 tpz(nnnw)
      integer tmf(nnnw)

      COMMON/DEF1/EMN,IONCTY,NELEC,Z
     :      /DEF2/C
     :      /GRID/R(NNN1),RP(NNN1),RPOR(NNN1),RNT,H,HP,N
     :      /WAVE/PZ(NNNW),PNTRPF,PNTRQF,MF(NNNW)
     :      /hydwav/pntrhpf,pntrhqf,henergy(nnnw)
     :      /ORB2/NCF,NW,PNTRIQ
* NP and NAK are read, but not written, used to make sure that the
* ordering of the hydrogenic wavefunctions is the same as of the system
* of interest
      COMMON/ORB4/NP(NNNW),NAK(NNNW)

* Copy global variables into temporary arrays
      call alloc(pntrtpf, nnnp*nw, 8)
      call alloc(pntrtqf, nnnp*nw, 8)
      tpz = pz
      tmf = mf

      do j=1,nw
        do i=1, nnnp
          tpf(i,j) = pf(i,j)
          tqf(i,j) = qf(i,j)
        enddo
      enddo

      call openfl (28, rwffile, 'unformatted', 'old', ierr)
      if (ierr .eq. 1) then
          write (istde, *) 'Error opening file "', rwffile, '"'
          close(28)
          stop
      endif

*  Check the file

      read (28, iostat = ios) G92RWF

      if ((ios .ne. 0) .or. (G92RWF .ne. 'G92RWF')) then
          write (istde,*) 'This is not a Radial Wavefunction File;'
          close(28)
          stop
      endif

*  Read orbital information from file

      call dalloc (pntrpf)
      call dalloc (pntrqf)

      call alloc (pntrpf, nnnp*nnnw, 8)
      call alloc (pntrqf, nnnp*nnnw, 8)

      do 2 j=1,nnnw
        do 1 i=1,n
          pf(i,j) = 0.0D00
          qf(i,j) = 0.0D00
    1   continue
        henergy(j) = -1.0D00
    2 continue 

    3 continue

      read (28, iostat=ios) npy, naky, ey, my

      if (ios .eq. 0) then
          call alloc (pntrpa, my, 8)
          call alloc (pntrqa, my, 8)
          call alloc (pntrra, my, 8)

          read (28) pzy, (pa(i), i=1, my), (qa(i), i=1, my)
          read (28) (ra(i), i=1, my)

          do j = 1, nnnw
              if ( (henergy(j) .lt. 0d00) .and. (npy .eq. NP(j)) .and.
     :                                    (naky .eq. NAK(j))) then
                  henergy(j) = ey
                  call intrpq (pa, qa, my, ra, j, dnorm)
              endif
          enddo
          call dalloc(pntrpa)
          call dalloc(pntrqa)
          call dalloc(pntrra)
          goto 3
      endif

* Copy hydrogenic orbitals just read in from global variables pf, qf to
* new hydrogenic global variables
      call alloc(pntrhpf, nnnp*nnnw, 8)
      call alloc(pntrhqf, nnnp*nnnw, 8)
      do j=1,nnnw
        do i=1, nnnp
          hpf(i,j) = pf(i,j)
          hqf(i,j) = qf(i,j)
        enddo
      enddo
      pz = tpz
      mf = tmf
      do j=1,nw
        do i=1, nnnp
          pf(i,j) = tpf(i,j)
          qf(i,j) = tqf(i,j)
        enddo
      enddo
      end
