************************************************************************
*                                                                      *
      FUNCTION FZALF (N,KAPPA,Z)
*                                                                      *
*   An estimate of the function  F (Z*\alpha) is computed here.        *
*                                                                      *
*   Call(s) to: [RCI92]: KLAMAQ, MOHR.                                 *
*                                                                      *
*   Written by Farid A Parpia, at Oxford                               *
*   Last Update: September 2012 by John Lowe, at Melbourne University  *
*                                                                      *
************************************************************************
*
      IMPLICIT REAL*8          (A-H, O-Z)
*
      IF ( (N .LE. 5) .AND.
     :      ( (KAPPA .EQ. -1) .OR.
     :        (KAPPA .EQ.  1) .OR.
     :        (KAPPA .EQ. -2) .OR.
     :        (KAPPA .EQ.  2) ) )  THEN
         CALL MOHR(N, KAPPA, Z, VALUE)
         WRITE(*,*) N, KAPPA, Z, VALUE
      ELSEIF ( (N .LE. 5) .AND. (Z .GE. 60) .AND.
     :         ( (KAPPA .EQ. -3) .OR.
     :         (KAPPA .EQ.  3) ) )  THEN
          CALL MOHR(N, KAPPA, Z, VALUE)
         WRITE(*,*) N, KAPPA, Z, VALUE
      ELSEIF ( (KAPPA .EQ. -1) .OR.
     :        (KAPPA .EQ.  1) .OR.
     :        (KAPPA .EQ. -2) .OR.
     :        (KAPPA .EQ.  2) .OR.
     :        (KAPPA .EQ. -3) .OR.
     :        (KAPPA .EQ.  3) ) THEN
            NEFF = 5
            CALL MOHR (NEFF,KAPPA,Z,VALUE)
         WRITE(*,*) N, KAPPA, Z, VALUE
      ELSE
            CALL KLAMAQ (N,KAPPA,Z,VALUE)
            WRITE(*,*) 'HERE'
      ENDIF
*
      FZALF = VALUE
*
      RETURN
      END
